package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.Attachment;
import microsoft.dynamics.crm.entity.collection.request.ActivitymimeattachmentCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;

@JsonIgnoreType
public class AttachmentRequest extends EntityRequest<Attachment> {

    public AttachmentRequest(ContextPath contextPath, Optional<Object> value) {
        super(Attachment.class, contextPath, value, false);
    }

    public SyncerrorRequest attachment_SyncErrors(UUID syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("Attachment_SyncErrors").addKeys(new NameValue(syncerrorid, UUID.class)), Optional.empty());
    }

    public SyncerrorCollectionRequest attachment_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("Attachment_SyncErrors"), Optional.empty());
    }

    public ActivitymimeattachmentRequest attachment_activity_mime_attachments(UUID activitymimeattachmentid) {
        return new ActivitymimeattachmentRequest(contextPath.addSegment("attachment_activity_mime_attachments").addKeys(new NameValue(activitymimeattachmentid, UUID.class)), Optional.empty());
    }

    public ActivitymimeattachmentCollectionRequest attachment_activity_mime_attachments() {
        return new ActivitymimeattachmentCollectionRequest(
                        contextPath.addSegment("attachment_activity_mime_attachments"), Optional.empty());
    }

}
