package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.Activitypointer;
import microsoft.dynamics.crm.entity.collection.request.ActivitymimeattachmentCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ActivitypartyCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.AppointmentCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ConnectionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.EmailCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.FaxCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.LetterCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PhonecallCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.QueueitemCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.RecurrenceruleCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.RecurringappointmentmasterCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SlakpiinstanceCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SocialactivityCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.TaskCollectionRequest;

@JsonIgnoreType
public class ActivitypointerRequest extends EntityRequest<Activitypointer> {

    public ActivitypointerRequest(ContextPath contextPath, Optional<Object> value) {
        super(Activitypointer.class, contextPath, value, false);
    }

    public InteractionforemailRequest regardingobjectid_new_interactionforemail() {
        return new InteractionforemailRequest(contextPath.addSegment("regardingobjectid_new_interactionforemail"), Optional.empty());
    }

    public KnowledgebaserecordRequest regardingobjectid_knowledgebaserecord() {
        return new KnowledgebaserecordRequest(contextPath.addSegment("regardingobjectid_knowledgebaserecord"), Optional.empty());
    }

    public AccountRequest regardingobjectid_account() {
        return new AccountRequest(contextPath.addSegment("regardingobjectid_account"), Optional.empty());
    }

    public SystemuserRequest createdby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), Optional.empty());
    }

    public ContactRequest regardingobjectid_contact() {
        return new ContactRequest(contextPath.addSegment("regardingobjectid_contact"), Optional.empty());
    }

    public SocialactivityRequest activity_pointer_socialactivity(UUID activityid) {
        return new SocialactivityRequest(contextPath.addSegment("activity_pointer_socialactivity").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public SocialactivityCollectionRequest activity_pointer_socialactivity() {
        return new SocialactivityCollectionRequest(
                        contextPath.addSegment("activity_pointer_socialactivity"), Optional.empty());
    }

    public RecurringappointmentmasterRequest activity_pointer_recurringappointmentmaster(UUID activityid) {
        return new RecurringappointmentmasterRequest(contextPath.addSegment("activity_pointer_recurringappointmentmaster").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public RecurringappointmentmasterCollectionRequest activity_pointer_recurringappointmentmaster() {
        return new RecurringappointmentmasterCollectionRequest(
                        contextPath.addSegment("activity_pointer_recurringappointmentmaster"), Optional.empty());
    }

    public EmailRequest activity_pointer_email(UUID activityid) {
        return new EmailRequest(contextPath.addSegment("activity_pointer_email").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public EmailCollectionRequest activity_pointer_email() {
        return new EmailCollectionRequest(
                        contextPath.addSegment("activity_pointer_email"), Optional.empty());
    }

    public MailboxRequest sendermailboxid() {
        return new MailboxRequest(contextPath.addSegment("sendermailboxid"), Optional.empty());
    }

    public TransactioncurrencyRequest transactioncurrencyid() {
        return new TransactioncurrencyRequest(contextPath.addSegment("transactioncurrencyid"), Optional.empty());
    }

    public QueueitemRequest activityPointer_QueueItem(UUID queueitemid) {
        return new QueueitemRequest(contextPath.addSegment("ActivityPointer_QueueItem").addKeys(new NameValue(queueitemid, UUID.class)), Optional.empty());
    }

    public QueueitemCollectionRequest activityPointer_QueueItem() {
        return new QueueitemCollectionRequest(
                        contextPath.addSegment("ActivityPointer_QueueItem"), Optional.empty());
    }

    public PrincipalRequest ownerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), Optional.empty());
    }

    public SystemuserRequest owninguser() {
        return new SystemuserRequest(contextPath.addSegment("owninguser"), Optional.empty());
    }

    public SlaRequest sla_activitypointer_sla() {
        return new SlaRequest(contextPath.addSegment("sla_activitypointer_sla"), Optional.empty());
    }

    public BusinessunitRequest owningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), Optional.empty());
    }

    public KnowledgearticleRequest regardingobjectid_knowledgearticle() {
        return new KnowledgearticleRequest(contextPath.addSegment("regardingobjectid_knowledgearticle"), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), Optional.empty());
    }

    public ActivitymimeattachmentRequest activity_pointer_activity_mime_attachment(UUID activitymimeattachmentid) {
        return new ActivitymimeattachmentRequest(contextPath.addSegment("activity_pointer_activity_mime_attachment").addKeys(new NameValue(activitymimeattachmentid, UUID.class)), Optional.empty());
    }

    public ActivitymimeattachmentCollectionRequest activity_pointer_activity_mime_attachment() {
        return new ActivitymimeattachmentCollectionRequest(
                        contextPath.addSegment("activity_pointer_activity_mime_attachment"), Optional.empty());
    }

    public FaxRequest activity_pointer_fax(UUID activityid) {
        return new FaxRequest(contextPath.addSegment("activity_pointer_fax").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public FaxCollectionRequest activity_pointer_fax() {
        return new FaxCollectionRequest(
                        contextPath.addSegment("activity_pointer_fax"), Optional.empty());
    }

    public SystemuserRequest createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), Optional.empty());
    }

    public SystemuserRequest modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), Optional.empty());
    }

    public TaskRequest activity_pointer_task(UUID activityid) {
        return new TaskRequest(contextPath.addSegment("activity_pointer_task").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public TaskCollectionRequest activity_pointer_task() {
        return new TaskCollectionRequest(
                        contextPath.addSegment("activity_pointer_task"), Optional.empty());
    }

    public PhonecallRequest activity_pointer_phonecall(UUID activityid) {
        return new PhonecallRequest(contextPath.addSegment("activity_pointer_phonecall").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public PhonecallCollectionRequest activity_pointer_phonecall() {
        return new PhonecallCollectionRequest(
                        contextPath.addSegment("activity_pointer_phonecall"), Optional.empty());
    }

    public AppointmentRequest activity_pointer_appointment(UUID activityid) {
        return new AppointmentRequest(contextPath.addSegment("activity_pointer_appointment").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public AppointmentCollectionRequest activity_pointer_appointment() {
        return new AppointmentCollectionRequest(
                        contextPath.addSegment("activity_pointer_appointment"), Optional.empty());
    }

    public LetterRequest activity_pointer_letter(UUID activityid) {
        return new LetterRequest(contextPath.addSegment("activity_pointer_letter").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public LetterCollectionRequest activity_pointer_letter() {
        return new LetterCollectionRequest(
                        contextPath.addSegment("activity_pointer_letter"), Optional.empty());
    }

    public ConnectionRequest activitypointer_connections2(UUID connectionid) {
        return new ConnectionRequest(contextPath.addSegment("activitypointer_connections2").addKeys(new NameValue(connectionid, UUID.class)), Optional.empty());
    }

    public ConnectionCollectionRequest activitypointer_connections2() {
        return new ConnectionCollectionRequest(
                        contextPath.addSegment("activitypointer_connections2"), Optional.empty());
    }

    public SlakpiinstanceRequest slakpiinstance_activitypointer(UUID slakpiinstanceid) {
        return new SlakpiinstanceRequest(contextPath.addSegment("slakpiinstance_activitypointer").addKeys(new NameValue(slakpiinstanceid, UUID.class)), Optional.empty());
    }

    public SlakpiinstanceCollectionRequest slakpiinstance_activitypointer() {
        return new SlakpiinstanceCollectionRequest(
                        contextPath.addSegment("slakpiinstance_activitypointer"), Optional.empty());
    }

    public TeamRequest owningteam() {
        return new TeamRequest(contextPath.addSegment("owningteam"), Optional.empty());
    }

    public BulkdeletefailureRequest activityPointer_BulkDeleteFailures(UUID bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("ActivityPointer_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid, UUID.class)), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest activityPointer_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("ActivityPointer_BulkDeleteFailures"), Optional.empty());
    }

    public SlaRequest slainvokedid_activitypointer_sla() {
        return new SlaRequest(contextPath.addSegment("slainvokedid_activitypointer_sla"), Optional.empty());
    }

    public ConnectionRequest activitypointer_connections1(UUID connectionid) {
        return new ConnectionRequest(contextPath.addSegment("activitypointer_connections1").addKeys(new NameValue(connectionid, UUID.class)), Optional.empty());
    }

    public ConnectionCollectionRequest activitypointer_connections1() {
        return new ConnectionCollectionRequest(
                        contextPath.addSegment("activitypointer_connections1"), Optional.empty());
    }

    public AsyncoperationRequest activityPointer_AsyncOperations(UUID asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("ActivityPointer_AsyncOperations").addKeys(new NameValue(asyncoperationid, UUID.class)), Optional.empty());
    }

    public AsyncoperationCollectionRequest activityPointer_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("ActivityPointer_AsyncOperations"), Optional.empty());
    }

    public RecurrenceruleRequest activity_pointer_recurrencerule(UUID ruleid) {
        return new RecurrenceruleRequest(contextPath.addSegment("activity_pointer_recurrencerule").addKeys(new NameValue(ruleid, UUID.class)), Optional.empty());
    }

    public RecurrenceruleCollectionRequest activity_pointer_recurrencerule() {
        return new RecurrenceruleCollectionRequest(
                        contextPath.addSegment("activity_pointer_recurrencerule"), Optional.empty());
    }

    public ActivitypartyRequest activitypointer_activity_parties(UUID activitypartyid) {
        return new ActivitypartyRequest(contextPath.addSegment("activitypointer_activity_parties").addKeys(new NameValue(activitypartyid, UUID.class)), Optional.empty());
    }

    public ActivitypartyCollectionRequest activitypointer_activity_parties() {
        return new ActivitypartyCollectionRequest(
                        contextPath.addSegment("activitypointer_activity_parties"), Optional.empty());
    }

}
