package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.Transactioncurrency;
import microsoft.dynamics.crm.entity.request.AccountRequest;
import microsoft.dynamics.crm.entity.request.ActioncardRequest;
import microsoft.dynamics.crm.entity.request.ActioncarduserstateRequest;
import microsoft.dynamics.crm.entity.request.ActivitypointerRequest;
import microsoft.dynamics.crm.entity.request.AnnualfiscalcalendarRequest;
import microsoft.dynamics.crm.entity.request.AppointmentRequest;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.BusinessunitRequest;
import microsoft.dynamics.crm.entity.request.CategoryRequest;
import microsoft.dynamics.crm.entity.request.ConnectionRequest;
import microsoft.dynamics.crm.entity.request.ContactRequest;
import microsoft.dynamics.crm.entity.request.CustomeraddressRequest;
import microsoft.dynamics.crm.entity.request.DuplicaterecordRequest;
import microsoft.dynamics.crm.entity.request.EmailRequest;
import microsoft.dynamics.crm.entity.request.ExpiredprocessRequest;
import microsoft.dynamics.crm.entity.request.FaxRequest;
import microsoft.dynamics.crm.entity.request.FeedbackRequest;
import microsoft.dynamics.crm.entity.request.FixedmonthlyfiscalcalendarRequest;
import microsoft.dynamics.crm.entity.request.GoalRequest;
import microsoft.dynamics.crm.entity.request.InteractionforemailRequest;
import microsoft.dynamics.crm.entity.request.KbarticleRequest;
import microsoft.dynamics.crm.entity.request.KnowledgearticleRequest;
import microsoft.dynamics.crm.entity.request.KnowledgearticleviewsRequest;
import microsoft.dynamics.crm.entity.request.KnowledgebaserecordRequest;
import microsoft.dynamics.crm.entity.request.LetterRequest;
import microsoft.dynamics.crm.entity.request.MailmergetemplateRequest;
import microsoft.dynamics.crm.entity.request.MonthlyfiscalcalendarRequest;
import microsoft.dynamics.crm.entity.request.NewprocessRequest;
import microsoft.dynamics.crm.entity.request.OfficegraphdocumentRequest;
import microsoft.dynamics.crm.entity.request.OrganizationRequest;
import microsoft.dynamics.crm.entity.request.PhonecallRequest;
import microsoft.dynamics.crm.entity.request.PositionRequest;
import microsoft.dynamics.crm.entity.request.ProcesssessionRequest;
import microsoft.dynamics.crm.entity.request.QuarterlyfiscalcalendarRequest;
import microsoft.dynamics.crm.entity.request.QueueRequest;
import microsoft.dynamics.crm.entity.request.QueueitemRequest;
import microsoft.dynamics.crm.entity.request.RecommendeddocumentRequest;
import microsoft.dynamics.crm.entity.request.RecurringappointmentmasterRequest;
import microsoft.dynamics.crm.entity.request.ReportcategoryRequest;
import microsoft.dynamics.crm.entity.request.SemiannualfiscalcalendarRequest;
import microsoft.dynamics.crm.entity.request.SharepointdocumentlocationRequest;
import microsoft.dynamics.crm.entity.request.SharepointsiteRequest;
import microsoft.dynamics.crm.entity.request.SimilarityruleRequest;
import microsoft.dynamics.crm.entity.request.SlaRequest;
import microsoft.dynamics.crm.entity.request.SlaitemRequest;
import microsoft.dynamics.crm.entity.request.SlakpiinstanceRequest;
import microsoft.dynamics.crm.entity.request.SocialactivityRequest;
import microsoft.dynamics.crm.entity.request.SocialprofileRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.TaskRequest;
import microsoft.dynamics.crm.entity.request.TeamRequest;
import microsoft.dynamics.crm.entity.request.TerritoryRequest;
import microsoft.dynamics.crm.entity.request.ThemeRequest;
import microsoft.dynamics.crm.entity.request.TransactioncurrencyRequest;
import microsoft.dynamics.crm.entity.request.TranslationprocessRequest;
import microsoft.dynamics.crm.entity.request.UsermappingRequest;
import microsoft.dynamics.crm.entity.request.UsersettingsRequest;

public class TransactioncurrencyCollectionRequest extends CollectionPageEntityRequest<Transactioncurrency, TransactioncurrencyRequest>{

    protected ContextPath contextPath;

    public TransactioncurrencyCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Transactioncurrency.class, cp -> new TransactioncurrencyRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public GoalRequest transactionCurrency_Goal(UUID goalid) {
        return new GoalRequest(contextPath.addSegment("TransactionCurrency_Goal").addKeys(new NameValue(goalid, UUID.class)), Optional.empty());
    }

    public GoalCollectionRequest transactionCurrency_Goal() {
        return new GoalCollectionRequest(contextPath.addSegment("TransactionCurrency_Goal"), Optional.empty());
    }

    public EmailRequest transactionCurrency_Email(UUID activityid) {
        return new EmailRequest(contextPath.addSegment("TransactionCurrency_Email").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public EmailCollectionRequest transactionCurrency_Email() {
        return new EmailCollectionRequest(contextPath.addSegment("TransactionCurrency_Email"), Optional.empty());
    }

    public DuplicaterecordRequest transactionCurrency_DuplicateBaseRecord(UUID duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("TransactionCurrency_DuplicateBaseRecord").addKeys(new NameValue(duplicateid, UUID.class)), Optional.empty());
    }

    public DuplicaterecordCollectionRequest transactionCurrency_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(contextPath.addSegment("TransactionCurrency_DuplicateBaseRecord"), Optional.empty());
    }

    public BusinessunitRequest transactionCurrency_BusinessUnit(UUID businessunitid) {
        return new BusinessunitRequest(contextPath.addSegment("TransactionCurrency_BusinessUnit").addKeys(new NameValue(businessunitid, UUID.class)), Optional.empty());
    }

    public BusinessunitCollectionRequest transactionCurrency_BusinessUnit() {
        return new BusinessunitCollectionRequest(contextPath.addSegment("TransactionCurrency_BusinessUnit"), Optional.empty());
    }

    public ConnectionRequest transactionCurrency_Connection(UUID connectionid) {
        return new ConnectionRequest(contextPath.addSegment("TransactionCurrency_Connection").addKeys(new NameValue(connectionid, UUID.class)), Optional.empty());
    }

    public ConnectionCollectionRequest transactionCurrency_Connection() {
        return new ConnectionCollectionRequest(contextPath.addSegment("TransactionCurrency_Connection"), Optional.empty());
    }

    public DuplicaterecordRequest transactionCurrency_DuplicateMatchingRecord(UUID duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("TransactionCurrency_DuplicateMatchingRecord").addKeys(new NameValue(duplicateid, UUID.class)), Optional.empty());
    }

    public DuplicaterecordCollectionRequest transactionCurrency_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(contextPath.addSegment("TransactionCurrency_DuplicateMatchingRecord"), Optional.empty());
    }

    public AnnualfiscalcalendarRequest transactioncurrency_annualfiscalcalendar(UUID userfiscalcalendarid) {
        return new AnnualfiscalcalendarRequest(contextPath.addSegment("transactioncurrency_annualfiscalcalendar").addKeys(new NameValue(userfiscalcalendarid, UUID.class)), Optional.empty());
    }

    public AnnualfiscalcalendarCollectionRequest transactioncurrency_annualfiscalcalendar() {
        return new AnnualfiscalcalendarCollectionRequest(contextPath.addSegment("transactioncurrency_annualfiscalcalendar"), Optional.empty());
    }

    public ProcesssessionRequest transactionCurrency_ProcessSessions(UUID processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("TransactionCurrency_ProcessSessions").addKeys(new NameValue(processsessionid, UUID.class)), Optional.empty());
    }

    public ProcesssessionCollectionRequest transactionCurrency_ProcessSessions() {
        return new ProcesssessionCollectionRequest(contextPath.addSegment("TransactionCurrency_ProcessSessions"), Optional.empty());
    }

    public PhonecallRequest transactionCurrency_PhoneCall(UUID activityid) {
        return new PhonecallRequest(contextPath.addSegment("TransactionCurrency_PhoneCall").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public PhonecallCollectionRequest transactionCurrency_PhoneCall() {
        return new PhonecallCollectionRequest(contextPath.addSegment("TransactionCurrency_PhoneCall"), Optional.empty());
    }

    public RecommendeddocumentRequest transactionCurrency_recommendeddocument(UUID recommendeddocumentid) {
        return new RecommendeddocumentRequest(contextPath.addSegment("TransactionCurrency_recommendeddocument").addKeys(new NameValue(recommendeddocumentid, UUID.class)), Optional.empty());
    }

    public RecommendeddocumentCollectionRequest transactionCurrency_recommendeddocument() {
        return new RecommendeddocumentCollectionRequest(contextPath.addSegment("TransactionCurrency_recommendeddocument"), Optional.empty());
    }

    public SocialactivityRequest transactioncurrency_socialactivity(UUID activityid) {
        return new SocialactivityRequest(contextPath.addSegment("transactioncurrency_socialactivity").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public SocialactivityCollectionRequest transactioncurrency_socialactivity() {
        return new SocialactivityCollectionRequest(contextPath.addSegment("transactioncurrency_socialactivity"), Optional.empty());
    }

    public MailmergetemplateRequest transactionCurrency_MailMergeTemplate(UUID mailmergetemplateid) {
        return new MailmergetemplateRequest(contextPath.addSegment("TransactionCurrency_MailMergeTemplate").addKeys(new NameValue(mailmergetemplateid, UUID.class)), Optional.empty());
    }

    public MailmergetemplateCollectionRequest transactionCurrency_MailMergeTemplate() {
        return new MailmergetemplateCollectionRequest(contextPath.addSegment("TransactionCurrency_MailMergeTemplate"), Optional.empty());
    }

    public ActivitypointerRequest transactionCurrency_ActivityPointer(UUID activityid) {
        return new ActivitypointerRequest(contextPath.addSegment("TransactionCurrency_ActivityPointer").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public ActivitypointerCollectionRequest transactionCurrency_ActivityPointer() {
        return new ActivitypointerCollectionRequest(contextPath.addSegment("TransactionCurrency_ActivityPointer"), Optional.empty());
    }

    public SystemuserRequest transactionCurrency_SystemUser(UUID ownerid) {
        return new SystemuserRequest(contextPath.addSegment("TransactionCurrency_SystemUser").addKeys(new NameValue(ownerid, UUID.class)), Optional.empty());
    }

    public SystemuserCollectionRequest transactionCurrency_SystemUser() {
        return new SystemuserCollectionRequest(contextPath.addSegment("TransactionCurrency_SystemUser"), Optional.empty());
    }

    public AsyncoperationRequest transactionCurrency_AsyncOperations(UUID asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("TransactionCurrency_AsyncOperations").addKeys(new NameValue(asyncoperationid, UUID.class)), Optional.empty());
    }

    public AsyncoperationCollectionRequest transactionCurrency_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("TransactionCurrency_AsyncOperations"), Optional.empty());
    }

    public MonthlyfiscalcalendarRequest transactioncurrency_monthlyfiscalcalendar(UUID userfiscalcalendarid) {
        return new MonthlyfiscalcalendarRequest(contextPath.addSegment("transactioncurrency_monthlyfiscalcalendar").addKeys(new NameValue(userfiscalcalendarid, UUID.class)), Optional.empty());
    }

    public MonthlyfiscalcalendarCollectionRequest transactioncurrency_monthlyfiscalcalendar() {
        return new MonthlyfiscalcalendarCollectionRequest(contextPath.addSegment("transactioncurrency_monthlyfiscalcalendar"), Optional.empty());
    }

    public FixedmonthlyfiscalcalendarRequest transactioncurrency_fixedmonthlyfiscalcalendar(UUID userfiscalcalendarid) {
        return new FixedmonthlyfiscalcalendarRequest(contextPath.addSegment("transactioncurrency_fixedmonthlyfiscalcalendar").addKeys(new NameValue(userfiscalcalendarid, UUID.class)), Optional.empty());
    }

    public FixedmonthlyfiscalcalendarCollectionRequest transactioncurrency_fixedmonthlyfiscalcalendar() {
        return new FixedmonthlyfiscalcalendarCollectionRequest(contextPath.addSegment("transactioncurrency_fixedmonthlyfiscalcalendar"), Optional.empty());
    }

    public AccountRequest transactioncurrency_account(UUID accountid) {
        return new AccountRequest(contextPath.addSegment("transactioncurrency_account").addKeys(new NameValue(accountid, UUID.class)), Optional.empty());
    }

    public AccountCollectionRequest transactioncurrency_account() {
        return new AccountCollectionRequest(contextPath.addSegment("transactioncurrency_account"), Optional.empty());
    }

    public QuarterlyfiscalcalendarRequest transactioncurrency_quarterlyfiscalcalendar(UUID userfiscalcalendarid) {
        return new QuarterlyfiscalcalendarRequest(contextPath.addSegment("transactioncurrency_quarterlyfiscalcalendar").addKeys(new NameValue(userfiscalcalendarid, UUID.class)), Optional.empty());
    }

    public QuarterlyfiscalcalendarCollectionRequest transactioncurrency_quarterlyfiscalcalendar() {
        return new QuarterlyfiscalcalendarCollectionRequest(contextPath.addSegment("transactioncurrency_quarterlyfiscalcalendar"), Optional.empty());
    }

    public KnowledgebaserecordRequest transactionCurrency_KnowledgeBaseRecord(UUID knowledgebaserecordid) {
        return new KnowledgebaserecordRequest(contextPath.addSegment("TransactionCurrency_KnowledgeBaseRecord").addKeys(new NameValue(knowledgebaserecordid, UUID.class)), Optional.empty());
    }

    public KnowledgebaserecordCollectionRequest transactionCurrency_KnowledgeBaseRecord() {
        return new KnowledgebaserecordCollectionRequest(contextPath.addSegment("TransactionCurrency_KnowledgeBaseRecord"), Optional.empty());
    }

    public KnowledgearticleviewsRequest transactioncurrency_knowledgearticleviews(UUID knowledgearticleviewsid) {
        return new KnowledgearticleviewsRequest(contextPath.addSegment("transactioncurrency_knowledgearticleviews").addKeys(new NameValue(knowledgearticleviewsid, UUID.class)), Optional.empty());
    }

    public KnowledgearticleviewsCollectionRequest transactioncurrency_knowledgearticleviews() {
        return new KnowledgearticleviewsCollectionRequest(contextPath.addSegment("transactioncurrency_knowledgearticleviews"), Optional.empty());
    }

    public CustomeraddressRequest transactionCurrency_CustomerAddress(UUID customeraddressid) {
        return new CustomeraddressRequest(contextPath.addSegment("TransactionCurrency_CustomerAddress").addKeys(new NameValue(customeraddressid, UUID.class)), Optional.empty());
    }

    public CustomeraddressCollectionRequest transactionCurrency_CustomerAddress() {
        return new CustomeraddressCollectionRequest(contextPath.addSegment("TransactionCurrency_CustomerAddress"), Optional.empty());
    }

    public FaxRequest transactionCurrency_Fax(UUID activityid) {
        return new FaxRequest(contextPath.addSegment("TransactionCurrency_Fax").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public FaxCollectionRequest transactionCurrency_Fax() {
        return new FaxCollectionRequest(contextPath.addSegment("TransactionCurrency_Fax"), Optional.empty());
    }

    public PositionRequest transactioncurrency_position(UUID positionid) {
        return new PositionRequest(contextPath.addSegment("transactioncurrency_position").addKeys(new NameValue(positionid, UUID.class)), Optional.empty());
    }

    public PositionCollectionRequest transactioncurrency_position() {
        return new PositionCollectionRequest(contextPath.addSegment("transactioncurrency_position"), Optional.empty());
    }

    public ExpiredprocessRequest transactioncurrency_expiredprocess(UUID businessprocessflowinstanceid) {
        return new ExpiredprocessRequest(contextPath.addSegment("transactioncurrency_expiredprocess").addKeys(new NameValue(businessprocessflowinstanceid, UUID.class)), Optional.empty());
    }

    public ExpiredprocessCollectionRequest transactioncurrency_expiredprocess() {
        return new ExpiredprocessCollectionRequest(contextPath.addSegment("transactioncurrency_expiredprocess"), Optional.empty());
    }

    public ActioncardRequest transactioncurrency_actioncard(UUID actioncardid) {
        return new ActioncardRequest(contextPath.addSegment("transactioncurrency_actioncard").addKeys(new NameValue(actioncardid, UUID.class)), Optional.empty());
    }

    public ActioncardCollectionRequest transactioncurrency_actioncard() {
        return new ActioncardCollectionRequest(contextPath.addSegment("transactioncurrency_actioncard"), Optional.empty());
    }

    public TaskRequest transactionCurrency_Task(UUID activityid) {
        return new TaskRequest(contextPath.addSegment("TransactionCurrency_Task").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public TaskCollectionRequest transactionCurrency_Task() {
        return new TaskCollectionRequest(contextPath.addSegment("TransactionCurrency_Task"), Optional.empty());
    }

    public OrganizationRequest basecurrency_organization(UUID organizationid) {
        return new OrganizationRequest(contextPath.addSegment("basecurrency_organization").addKeys(new NameValue(organizationid, UUID.class)), Optional.empty());
    }

    public OrganizationCollectionRequest basecurrency_organization() {
        return new OrganizationCollectionRequest(contextPath.addSegment("basecurrency_organization"), Optional.empty());
    }

    public FeedbackRequest transactioncurrency_feedback(UUID feedbackid) {
        return new FeedbackRequest(contextPath.addSegment("transactioncurrency_feedback").addKeys(new NameValue(feedbackid, UUID.class)), Optional.empty());
    }

    public FeedbackCollectionRequest transactioncurrency_feedback() {
        return new FeedbackCollectionRequest(contextPath.addSegment("transactioncurrency_feedback"), Optional.empty());
    }

    public SimilarityruleRequest transactionCurrency_SimilarityRule(UUID similarityruleid) {
        return new SimilarityruleRequest(contextPath.addSegment("TransactionCurrency_SimilarityRule").addKeys(new NameValue(similarityruleid, UUID.class)), Optional.empty());
    }

    public SimilarityruleCollectionRequest transactionCurrency_SimilarityRule() {
        return new SimilarityruleCollectionRequest(contextPath.addSegment("TransactionCurrency_SimilarityRule"), Optional.empty());
    }

    public CategoryRequest transactioncurrency_category(UUID categoryid) {
        return new CategoryRequest(contextPath.addSegment("transactioncurrency_category").addKeys(new NameValue(categoryid, UUID.class)), Optional.empty());
    }

    public CategoryCollectionRequest transactioncurrency_category() {
        return new CategoryCollectionRequest(contextPath.addSegment("transactioncurrency_category"), Optional.empty());
    }

    public TeamRequest transactionCurrency_Team(UUID ownerid) {
        return new TeamRequest(contextPath.addSegment("TransactionCurrency_Team").addKeys(new NameValue(ownerid, UUID.class)), Optional.empty());
    }

    public TeamCollectionRequest transactionCurrency_Team() {
        return new TeamCollectionRequest(contextPath.addSegment("TransactionCurrency_Team"), Optional.empty());
    }

    public SlaRequest transactionCurrency_SLA(UUID slaid) {
        return new SlaRequest(contextPath.addSegment("TransactionCurrency_SLA").addKeys(new NameValue(slaid, UUID.class)), Optional.empty());
    }

    public SlaCollectionRequest transactionCurrency_SLA() {
        return new SlaCollectionRequest(contextPath.addSegment("TransactionCurrency_SLA"), Optional.empty());
    }

    public RecurringappointmentmasterRequest transactionCurrency_RecurringAppointmentMaster(UUID activityid) {
        return new RecurringappointmentmasterRequest(contextPath.addSegment("TransactionCurrency_RecurringAppointmentMaster").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public RecurringappointmentmasterCollectionRequest transactionCurrency_RecurringAppointmentMaster() {
        return new RecurringappointmentmasterCollectionRequest(contextPath.addSegment("TransactionCurrency_RecurringAppointmentMaster"), Optional.empty());
    }

    public KnowledgearticleRequest transactioncurrency_knowledgearticle(UUID knowledgearticleid) {
        return new KnowledgearticleRequest(contextPath.addSegment("transactioncurrency_knowledgearticle").addKeys(new NameValue(knowledgearticleid, UUID.class)), Optional.empty());
    }

    public KnowledgearticleCollectionRequest transactioncurrency_knowledgearticle() {
        return new KnowledgearticleCollectionRequest(contextPath.addSegment("transactioncurrency_knowledgearticle"), Optional.empty());
    }

    public ThemeRequest transactionCurrency_Theme(UUID themeid) {
        return new ThemeRequest(contextPath.addSegment("TransactionCurrency_Theme").addKeys(new NameValue(themeid, UUID.class)), Optional.empty());
    }

    public ThemeCollectionRequest transactionCurrency_Theme() {
        return new ThemeCollectionRequest(contextPath.addSegment("TransactionCurrency_Theme"), Optional.empty());
    }

    public LetterRequest transactionCurrency_Letter(UUID activityid) {
        return new LetterRequest(contextPath.addSegment("TransactionCurrency_Letter").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public LetterCollectionRequest transactionCurrency_Letter() {
        return new LetterCollectionRequest(contextPath.addSegment("TransactionCurrency_Letter"), Optional.empty());
    }

    public UsermappingRequest transactionCurrency_UserMapping(UUID usermappingid) {
        return new UsermappingRequest(contextPath.addSegment("TransactionCurrency_UserMapping").addKeys(new NameValue(usermappingid, UUID.class)), Optional.empty());
    }

    public UsermappingCollectionRequest transactionCurrency_UserMapping() {
        return new UsermappingCollectionRequest(contextPath.addSegment("TransactionCurrency_UserMapping"), Optional.empty());
    }

    public QueueRequest transactionCurrency_Queue(UUID queueid) {
        return new QueueRequest(contextPath.addSegment("TransactionCurrency_Queue").addKeys(new NameValue(queueid, UUID.class)), Optional.empty());
    }

    public QueueCollectionRequest transactionCurrency_Queue() {
        return new QueueCollectionRequest(contextPath.addSegment("TransactionCurrency_Queue"), Optional.empty());
    }

    public SocialprofileRequest transactioncurrency_SocialProfile(UUID socialprofileid) {
        return new SocialprofileRequest(contextPath.addSegment("transactioncurrency_SocialProfile").addKeys(new NameValue(socialprofileid, UUID.class)), Optional.empty());
    }

    public SocialprofileCollectionRequest transactioncurrency_SocialProfile() {
        return new SocialprofileCollectionRequest(contextPath.addSegment("transactioncurrency_SocialProfile"), Optional.empty());
    }

    public ContactRequest transactioncurrency_contact(UUID contactid) {
        return new ContactRequest(contextPath.addSegment("transactioncurrency_contact").addKeys(new NameValue(contactid, UUID.class)), Optional.empty());
    }

    public ContactCollectionRequest transactioncurrency_contact() {
        return new ContactCollectionRequest(contextPath.addSegment("transactioncurrency_contact"), Optional.empty());
    }

    public ActioncarduserstateRequest transactionCurrency_ActionCardUserState(UUID actioncarduserstateid) {
        return new ActioncarduserstateRequest(contextPath.addSegment("TransactionCurrency_ActionCardUserState").addKeys(new NameValue(actioncarduserstateid, UUID.class)), Optional.empty());
    }

    public ActioncarduserstateCollectionRequest transactionCurrency_ActionCardUserState() {
        return new ActioncarduserstateCollectionRequest(contextPath.addSegment("TransactionCurrency_ActionCardUserState"), Optional.empty());
    }

    public AppointmentRequest transactionCurrency_Appointment(UUID activityid) {
        return new AppointmentRequest(contextPath.addSegment("TransactionCurrency_Appointment").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public AppointmentCollectionRequest transactionCurrency_Appointment() {
        return new AppointmentCollectionRequest(contextPath.addSegment("TransactionCurrency_Appointment"), Optional.empty());
    }

    public SharepointsiteRequest transactionCurrency_SharePointSite(UUID sharepointsiteid) {
        return new SharepointsiteRequest(contextPath.addSegment("TransactionCurrency_SharePointSite").addKeys(new NameValue(sharepointsiteid, UUID.class)), Optional.empty());
    }

    public SharepointsiteCollectionRequest transactionCurrency_SharePointSite() {
        return new SharepointsiteCollectionRequest(contextPath.addSegment("TransactionCurrency_SharePointSite"), Optional.empty());
    }

    public SharepointdocumentlocationRequest transactionCurrency_SharePointDocumentLocation(UUID sharepointdocumentlocationid) {
        return new SharepointdocumentlocationRequest(contextPath.addSegment("TransactionCurrency_SharePointDocumentLocation").addKeys(new NameValue(sharepointdocumentlocationid, UUID.class)), Optional.empty());
    }

    public SharepointdocumentlocationCollectionRequest transactionCurrency_SharePointDocumentLocation() {
        return new SharepointdocumentlocationCollectionRequest(contextPath.addSegment("TransactionCurrency_SharePointDocumentLocation"), Optional.empty());
    }

    public SlaitemRequest transactionCurrency_SLAItem(UUID slaitemid) {
        return new SlaitemRequest(contextPath.addSegment("TransactionCurrency_SLAItem").addKeys(new NameValue(slaitemid, UUID.class)), Optional.empty());
    }

    public SlaitemCollectionRequest transactionCurrency_SLAItem() {
        return new SlaitemCollectionRequest(contextPath.addSegment("TransactionCurrency_SLAItem"), Optional.empty());
    }

    public NewprocessRequest transactioncurrency_newprocess(UUID businessprocessflowinstanceid) {
        return new NewprocessRequest(contextPath.addSegment("transactioncurrency_newprocess").addKeys(new NameValue(businessprocessflowinstanceid, UUID.class)), Optional.empty());
    }

    public NewprocessCollectionRequest transactioncurrency_newprocess() {
        return new NewprocessCollectionRequest(contextPath.addSegment("transactioncurrency_newprocess"), Optional.empty());
    }

    public KbarticleRequest transactionCurrency_KbArticle(UUID kbarticleid) {
        return new KbarticleRequest(contextPath.addSegment("TransactionCurrency_KbArticle").addKeys(new NameValue(kbarticleid, UUID.class)), Optional.empty());
    }

    public KbarticleCollectionRequest transactionCurrency_KbArticle() {
        return new KbarticleCollectionRequest(contextPath.addSegment("TransactionCurrency_KbArticle"), Optional.empty());
    }

    public QueueitemRequest transactionCurrency_QueueItem(UUID queueitemid) {
        return new QueueitemRequest(contextPath.addSegment("TransactionCurrency_QueueItem").addKeys(new NameValue(queueitemid, UUID.class)), Optional.empty());
    }

    public QueueitemCollectionRequest transactionCurrency_QueueItem() {
        return new QueueitemCollectionRequest(contextPath.addSegment("TransactionCurrency_QueueItem"), Optional.empty());
    }

    public ReportcategoryRequest transactionCurrency_ReportCategory(UUID reportcategoryid) {
        return new ReportcategoryRequest(contextPath.addSegment("TransactionCurrency_ReportCategory").addKeys(new NameValue(reportcategoryid, UUID.class)), Optional.empty());
    }

    public ReportcategoryCollectionRequest transactionCurrency_ReportCategory() {
        return new ReportcategoryCollectionRequest(contextPath.addSegment("TransactionCurrency_ReportCategory"), Optional.empty());
    }

    public SemiannualfiscalcalendarRequest transactioncurrency_semiannualfiscalcalendar(UUID userfiscalcalendarid) {
        return new SemiannualfiscalcalendarRequest(contextPath.addSegment("transactioncurrency_semiannualfiscalcalendar").addKeys(new NameValue(userfiscalcalendarid, UUID.class)), Optional.empty());
    }

    public SemiannualfiscalcalendarCollectionRequest transactioncurrency_semiannualfiscalcalendar() {
        return new SemiannualfiscalcalendarCollectionRequest(contextPath.addSegment("transactioncurrency_semiannualfiscalcalendar"), Optional.empty());
    }

    public UsersettingsRequest transactioncurrency_usersettings(UUID systemuserid) {
        return new UsersettingsRequest(contextPath.addSegment("transactioncurrency_usersettings").addKeys(new NameValue(systemuserid, UUID.class)), Optional.empty());
    }

    public UsersettingsCollectionRequest transactioncurrency_usersettings() {
        return new UsersettingsCollectionRequest(contextPath.addSegment("transactioncurrency_usersettings"), Optional.empty());
    }

    public TranslationprocessRequest transactioncurrency_translationprocess(UUID businessprocessflowinstanceid) {
        return new TranslationprocessRequest(contextPath.addSegment("transactioncurrency_translationprocess").addKeys(new NameValue(businessprocessflowinstanceid, UUID.class)), Optional.empty());
    }

    public TranslationprocessCollectionRequest transactioncurrency_translationprocess() {
        return new TranslationprocessCollectionRequest(contextPath.addSegment("transactioncurrency_translationprocess"), Optional.empty());
    }

    public SlakpiinstanceRequest transactionCurrency_slakpiinstance(UUID slakpiinstanceid) {
        return new SlakpiinstanceRequest(contextPath.addSegment("TransactionCurrency_slakpiinstance").addKeys(new NameValue(slakpiinstanceid, UUID.class)), Optional.empty());
    }

    public SlakpiinstanceCollectionRequest transactionCurrency_slakpiinstance() {
        return new SlakpiinstanceCollectionRequest(contextPath.addSegment("TransactionCurrency_slakpiinstance"), Optional.empty());
    }

    public OfficegraphdocumentRequest transactionCurrency_officegraphdocument(UUID officegraphdocumentid) {
        return new OfficegraphdocumentRequest(contextPath.addSegment("TransactionCurrency_officegraphdocument").addKeys(new NameValue(officegraphdocumentid, UUID.class)), Optional.empty());
    }

    public OfficegraphdocumentCollectionRequest transactionCurrency_officegraphdocument() {
        return new OfficegraphdocumentCollectionRequest(contextPath.addSegment("TransactionCurrency_officegraphdocument"), Optional.empty());
    }

    public SyncerrorRequest transactionCurrency_SyncErrors(UUID syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("TransactionCurrency_SyncErrors").addKeys(new NameValue(syncerrorid, UUID.class)), Optional.empty());
    }

    public SyncerrorCollectionRequest transactionCurrency_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("TransactionCurrency_SyncErrors"), Optional.empty());
    }

    public InteractionforemailRequest transactionCurrency_InteractionForEmail(UUID interactionforemailid) {
        return new InteractionforemailRequest(contextPath.addSegment("TransactionCurrency_InteractionForEmail").addKeys(new NameValue(interactionforemailid, UUID.class)), Optional.empty());
    }

    public InteractionforemailCollectionRequest transactionCurrency_InteractionForEmail() {
        return new InteractionforemailCollectionRequest(contextPath.addSegment("TransactionCurrency_InteractionForEmail"), Optional.empty());
    }

    public TerritoryRequest transactionCurrency_Territory(UUID territoryid) {
        return new TerritoryRequest(contextPath.addSegment("TransactionCurrency_Territory").addKeys(new NameValue(territoryid, UUID.class)), Optional.empty());
    }

    public TerritoryCollectionRequest transactionCurrency_Territory() {
        return new TerritoryCollectionRequest(contextPath.addSegment("TransactionCurrency_Territory"), Optional.empty());
    }

}
