package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.Task;
import microsoft.dynamics.crm.entity.request.ActioncardRequest;
import microsoft.dynamics.crm.entity.request.ActivitypartyRequest;
import microsoft.dynamics.crm.entity.request.AnnotationRequest;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.BulkdeletefailureRequest;
import microsoft.dynamics.crm.entity.request.ConnectionRequest;
import microsoft.dynamics.crm.entity.request.DuplicaterecordRequest;
import microsoft.dynamics.crm.entity.request.PostfollowRequest;
import microsoft.dynamics.crm.entity.request.PostregardingRequest;
import microsoft.dynamics.crm.entity.request.PrincipalobjectattributeaccessRequest;
import microsoft.dynamics.crm.entity.request.ProcesssessionRequest;
import microsoft.dynamics.crm.entity.request.QueueitemRequest;
import microsoft.dynamics.crm.entity.request.SlakpiinstanceRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;
import microsoft.dynamics.crm.entity.request.TaskRequest;

public class TaskCollectionRequest extends CollectionPageEntityRequest<Task, TaskRequest>{

    protected ContextPath contextPath;

    public TaskCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Task.class, cp -> new TaskRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public PostregardingRequest task_PostRegardings(UUID postregardingid) {
        return new PostregardingRequest(contextPath.addSegment("task_PostRegardings").addKeys(new NameValue(postregardingid, UUID.class)), Optional.empty());
    }

    public PostregardingCollectionRequest task_PostRegardings() {
        return new PostregardingCollectionRequest(contextPath.addSegment("task_PostRegardings"), Optional.empty());
    }

    public PostfollowRequest task_PostFollows(UUID postfollowid) {
        return new PostfollowRequest(contextPath.addSegment("task_PostFollows").addKeys(new NameValue(postfollowid, UUID.class)), Optional.empty());
    }

    public PostfollowCollectionRequest task_PostFollows() {
        return new PostfollowCollectionRequest(contextPath.addSegment("task_PostFollows"), Optional.empty());
    }

    public ConnectionRequest task_connections2(UUID connectionid) {
        return new ConnectionRequest(contextPath.addSegment("task_connections2").addKeys(new NameValue(connectionid, UUID.class)), Optional.empty());
    }

    public ConnectionCollectionRequest task_connections2() {
        return new ConnectionCollectionRequest(contextPath.addSegment("task_connections2"), Optional.empty());
    }

    public DuplicaterecordRequest task_DuplicateBaseRecord(UUID duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("Task_DuplicateBaseRecord").addKeys(new NameValue(duplicateid, UUID.class)), Optional.empty());
    }

    public DuplicaterecordCollectionRequest task_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(contextPath.addSegment("Task_DuplicateBaseRecord"), Optional.empty());
    }

    public SlakpiinstanceRequest slakpiinstance_task(UUID slakpiinstanceid) {
        return new SlakpiinstanceRequest(contextPath.addSegment("slakpiinstance_task").addKeys(new NameValue(slakpiinstanceid, UUID.class)), Optional.empty());
    }

    public SlakpiinstanceCollectionRequest slakpiinstance_task() {
        return new SlakpiinstanceCollectionRequest(contextPath.addSegment("slakpiinstance_task"), Optional.empty());
    }

    public DuplicaterecordRequest task_DuplicateMatchingRecord(UUID duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("Task_DuplicateMatchingRecord").addKeys(new NameValue(duplicateid, UUID.class)), Optional.empty());
    }

    public DuplicaterecordCollectionRequest task_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(contextPath.addSegment("Task_DuplicateMatchingRecord"), Optional.empty());
    }

    public ConnectionRequest task_connections1(UUID connectionid) {
        return new ConnectionRequest(contextPath.addSegment("task_connections1").addKeys(new NameValue(connectionid, UUID.class)), Optional.empty());
    }

    public ConnectionCollectionRequest task_connections1() {
        return new ConnectionCollectionRequest(contextPath.addSegment("task_connections1"), Optional.empty());
    }

    public ActivitypartyRequest task_activity_parties(UUID activitypartyid) {
        return new ActivitypartyRequest(contextPath.addSegment("task_activity_parties").addKeys(new NameValue(activitypartyid, UUID.class)), Optional.empty());
    }

    public ActivitypartyCollectionRequest task_activity_parties() {
        return new ActivitypartyCollectionRequest(contextPath.addSegment("task_activity_parties"), Optional.empty());
    }

    public AnnotationRequest task_Annotation(UUID annotationid) {
        return new AnnotationRequest(contextPath.addSegment("Task_Annotation").addKeys(new NameValue(annotationid, UUID.class)), Optional.empty());
    }

    public AnnotationCollectionRequest task_Annotation() {
        return new AnnotationCollectionRequest(contextPath.addSegment("Task_Annotation"), Optional.empty());
    }

    public ProcesssessionRequest task_ProcessSessions(UUID processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("Task_ProcessSessions").addKeys(new NameValue(processsessionid, UUID.class)), Optional.empty());
    }

    public ProcesssessionCollectionRequest task_ProcessSessions() {
        return new ProcesssessionCollectionRequest(contextPath.addSegment("Task_ProcessSessions"), Optional.empty());
    }

    public AsyncoperationRequest task_AsyncOperations(UUID asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("Task_AsyncOperations").addKeys(new NameValue(asyncoperationid, UUID.class)), Optional.empty());
    }

    public AsyncoperationCollectionRequest task_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("Task_AsyncOperations"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest task_principalobjectattributeaccess(UUID principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("task_principalobjectattributeaccess").addKeys(new NameValue(principalobjectattributeaccessid, UUID.class)), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest task_principalobjectattributeaccess() {
        return new PrincipalobjectattributeaccessCollectionRequest(contextPath.addSegment("task_principalobjectattributeaccess"), Optional.empty());
    }

    public SyncerrorRequest task_SyncErrors(UUID syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("Task_SyncErrors").addKeys(new NameValue(syncerrorid, UUID.class)), Optional.empty());
    }

    public SyncerrorCollectionRequest task_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("Task_SyncErrors"), Optional.empty());
    }

    public QueueitemRequest task_QueueItem(UUID queueitemid) {
        return new QueueitemRequest(contextPath.addSegment("Task_QueueItem").addKeys(new NameValue(queueitemid, UUID.class)), Optional.empty());
    }

    public QueueitemCollectionRequest task_QueueItem() {
        return new QueueitemCollectionRequest(contextPath.addSegment("Task_QueueItem"), Optional.empty());
    }

    public ActioncardRequest task_actioncard(UUID actioncardid) {
        return new ActioncardRequest(contextPath.addSegment("task_actioncard").addKeys(new NameValue(actioncardid, UUID.class)), Optional.empty());
    }

    public ActioncardCollectionRequest task_actioncard() {
        return new ActioncardCollectionRequest(contextPath.addSegment("task_actioncard"), Optional.empty());
    }

    public BulkdeletefailureRequest task_BulkDeleteFailures(UUID bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("Task_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid, UUID.class)), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest task_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(contextPath.addSegment("Task_BulkDeleteFailures"), Optional.empty());
    }

}
