package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.Subject;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.BulkdeletefailureRequest;
import microsoft.dynamics.crm.entity.request.KbarticleRequest;
import microsoft.dynamics.crm.entity.request.KnowledgearticleRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_knowledgearticletemplateRequest;
import microsoft.dynamics.crm.entity.request.ProcesssessionRequest;
import microsoft.dynamics.crm.entity.request.SubjectRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;

public class SubjectCollectionRequest extends CollectionPageEntityRequest<Subject, SubjectRequest>{

    protected ContextPath contextPath;

    public SubjectCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Subject.class, cp -> new SubjectRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public ProcesssessionRequest subject_ProcessSessions(UUID processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("Subject_ProcessSessions").addKeys(new NameValue(processsessionid, UUID.class)), Optional.empty());
    }

    public ProcesssessionCollectionRequest subject_ProcessSessions() {
        return new ProcesssessionCollectionRequest(contextPath.addSegment("Subject_ProcessSessions"), Optional.empty());
    }

    public SubjectRequest subject_parent_subject(UUID subjectid) {
        return new SubjectRequest(contextPath.addSegment("subject_parent_subject").addKeys(new NameValue(subjectid, UUID.class)), Optional.empty());
    }

    public SubjectCollectionRequest subject_parent_subject() {
        return new SubjectCollectionRequest(contextPath.addSegment("subject_parent_subject"), Optional.empty());
    }

    public AsyncoperationRequest subject_AsyncOperations(UUID asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("Subject_AsyncOperations").addKeys(new NameValue(asyncoperationid, UUID.class)), Optional.empty());
    }

    public AsyncoperationCollectionRequest subject_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("Subject_AsyncOperations"), Optional.empty());
    }

    public SyncerrorRequest subject_SyncErrors(UUID syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("Subject_SyncErrors").addKeys(new NameValue(syncerrorid, UUID.class)), Optional.empty());
    }

    public SyncerrorCollectionRequest subject_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("Subject_SyncErrors"), Optional.empty());
    }

    public KbarticleRequest subject_kb_articles(UUID kbarticleid) {
        return new KbarticleRequest(contextPath.addSegment("subject_kb_articles").addKeys(new NameValue(kbarticleid, UUID.class)), Optional.empty());
    }

    public KbarticleCollectionRequest subject_kb_articles() {
        return new KbarticleCollectionRequest(contextPath.addSegment("subject_kb_articles"), Optional.empty());
    }

    public KnowledgearticleRequest subject_knowledgearticles(UUID knowledgearticleid) {
        return new KnowledgearticleRequest(contextPath.addSegment("subject_knowledgearticles").addKeys(new NameValue(knowledgearticleid, UUID.class)), Optional.empty());
    }

    public KnowledgearticleCollectionRequest subject_knowledgearticles() {
        return new KnowledgearticleCollectionRequest(contextPath.addSegment("subject_knowledgearticles"), Optional.empty());
    }

    public BulkdeletefailureRequest subject_BulkDeleteFailures(UUID bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("Subject_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid, UUID.class)), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest subject_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(contextPath.addSegment("Subject_BulkDeleteFailures"), Optional.empty());
    }

    public Msdyn_knowledgearticletemplateRequest msdyn_subject_knowledgearticletemplate_subjectid(UUID msdyn_knowledgearticletemplateid) {
        return new Msdyn_knowledgearticletemplateRequest(contextPath.addSegment("msdyn_subject_knowledgearticletemplate_subjectid").addKeys(new NameValue(msdyn_knowledgearticletemplateid, UUID.class)), Optional.empty());
    }

    public Msdyn_knowledgearticletemplateCollectionRequest msdyn_subject_knowledgearticletemplate_subjectid() {
        return new Msdyn_knowledgearticletemplateCollectionRequest(contextPath.addSegment("msdyn_subject_knowledgearticletemplate_subjectid"), Optional.empty());
    }

}
