package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.Sharepointdocumentlocation;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.DuplicaterecordRequest;
import microsoft.dynamics.crm.entity.request.PrincipalobjectattributeaccessRequest;
import microsoft.dynamics.crm.entity.request.ProcesssessionRequest;
import microsoft.dynamics.crm.entity.request.SharepointdocumentlocationRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;

public class SharepointdocumentlocationCollectionRequest extends CollectionPageEntityRequest<Sharepointdocumentlocation, SharepointdocumentlocationRequest>{

    protected ContextPath contextPath;

    public SharepointdocumentlocationCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Sharepointdocumentlocation.class, cp -> new SharepointdocumentlocationRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public PrincipalobjectattributeaccessRequest sharepointdocumentlocation_principalobjectattributeaccess(UUID principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("sharepointdocumentlocation_principalobjectattributeaccess").addKeys(new NameValue(principalobjectattributeaccessid, UUID.class)), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest sharepointdocumentlocation_principalobjectattributeaccess() {
        return new PrincipalobjectattributeaccessCollectionRequest(contextPath.addSegment("sharepointdocumentlocation_principalobjectattributeaccess"), Optional.empty());
    }

    public SharepointdocumentlocationRequest sharepointdocumentlocation_parent_sharepointdocumentlocation(UUID sharepointdocumentlocationid) {
        return new SharepointdocumentlocationRequest(contextPath.addSegment("sharepointdocumentlocation_parent_sharepointdocumentlocation").addKeys(new NameValue(sharepointdocumentlocationid, UUID.class)), Optional.empty());
    }

    public SharepointdocumentlocationCollectionRequest sharepointdocumentlocation_parent_sharepointdocumentlocation() {
        return new SharepointdocumentlocationCollectionRequest(contextPath.addSegment("sharepointdocumentlocation_parent_sharepointdocumentlocation"), Optional.empty());
    }

    public DuplicaterecordRequest sharePointDocumentLocation_DuplicateBaseRecord(UUID duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("SharePointDocumentLocation_DuplicateBaseRecord").addKeys(new NameValue(duplicateid, UUID.class)), Optional.empty());
    }

    public DuplicaterecordCollectionRequest sharePointDocumentLocation_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(contextPath.addSegment("SharePointDocumentLocation_DuplicateBaseRecord"), Optional.empty());
    }

    public DuplicaterecordRequest sharePointDocumentLocation_DuplicateMatchingRecord(UUID duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("SharePointDocumentLocation_DuplicateMatchingRecord").addKeys(new NameValue(duplicateid, UUID.class)), Optional.empty());
    }

    public DuplicaterecordCollectionRequest sharePointDocumentLocation_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(contextPath.addSegment("SharePointDocumentLocation_DuplicateMatchingRecord"), Optional.empty());
    }

    public ProcesssessionRequest sharePointDocumentLocation_ProcessSessions(UUID processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("SharePointDocumentLocation_ProcessSessions").addKeys(new NameValue(processsessionid, UUID.class)), Optional.empty());
    }

    public ProcesssessionCollectionRequest sharePointDocumentLocation_ProcessSessions() {
        return new ProcesssessionCollectionRequest(contextPath.addSegment("SharePointDocumentLocation_ProcessSessions"), Optional.empty());
    }

    public SyncerrorRequest sharePointDocumentLocation_SyncErrors(UUID syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("SharePointDocumentLocation_SyncErrors").addKeys(new NameValue(syncerrorid, UUID.class)), Optional.empty());
    }

    public SyncerrorCollectionRequest sharePointDocumentLocation_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("SharePointDocumentLocation_SyncErrors"), Optional.empty());
    }

    public AsyncoperationRequest sharePointDocumentLocation_AsyncOperations(UUID asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("SharePointDocumentLocation_AsyncOperations").addKeys(new NameValue(asyncoperationid, UUID.class)), Optional.empty());
    }

    public AsyncoperationCollectionRequest sharePointDocumentLocation_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("SharePointDocumentLocation_AsyncOperations"), Optional.empty());
    }

}
