package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.Role;
import microsoft.dynamics.crm.entity.request.ApplicationuserRequest;
import microsoft.dynamics.crm.entity.request.AppmoduleRequest;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.BulkdeletefailureRequest;
import microsoft.dynamics.crm.entity.request.PrivilegeRequest;
import microsoft.dynamics.crm.entity.request.RoleRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.TeamRequest;

public class RoleCollectionRequest extends CollectionPageEntityRequest<Role, RoleRequest>{

    protected ContextPath contextPath;

    public RoleCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Role.class, cp -> new RoleRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public SystemuserRequest systemuserroles_association(UUID ownerid) {
        return new SystemuserRequest(contextPath.addSegment("systemuserroles_association").addKeys(new NameValue(ownerid, UUID.class)), Optional.empty());
    }

    public SystemuserCollectionRequest systemuserroles_association() {
        return new SystemuserCollectionRequest(contextPath.addSegment("systemuserroles_association"), Optional.empty());
    }

    public PrivilegeRequest roleprivileges_association(UUID privilegeid) {
        return new PrivilegeRequest(contextPath.addSegment("roleprivileges_association").addKeys(new NameValue(privilegeid, UUID.class)), Optional.empty());
    }

    public PrivilegeCollectionRequest roleprivileges_association() {
        return new PrivilegeCollectionRequest(contextPath.addSegment("roleprivileges_association"), Optional.empty());
    }

    public AppmoduleRequest appmoduleroles_association(UUID appmoduleid) {
        return new AppmoduleRequest(contextPath.addSegment("appmoduleroles_association").addKeys(new NameValue(appmoduleid, UUID.class)), Optional.empty());
    }

    public AppmoduleCollectionRequest appmoduleroles_association() {
        return new AppmoduleCollectionRequest(contextPath.addSegment("appmoduleroles_association"), Optional.empty());
    }

    public RoleRequest role_parent_role(UUID roleid) {
        return new RoleRequest(contextPath.addSegment("role_parent_role").addKeys(new NameValue(roleid, UUID.class)), Optional.empty());
    }

    public RoleCollectionRequest role_parent_role() {
        return new RoleCollectionRequest(contextPath.addSegment("role_parent_role"), Optional.empty());
    }

    public AsyncoperationRequest role_AsyncOperations(UUID asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("Role_AsyncOperations").addKeys(new NameValue(asyncoperationid, UUID.class)), Optional.empty());
    }

    public AsyncoperationCollectionRequest role_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("Role_AsyncOperations"), Optional.empty());
    }

    public BulkdeletefailureRequest role_BulkDeleteFailures(UUID bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("Role_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid, UUID.class)), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest role_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(contextPath.addSegment("Role_BulkDeleteFailures"), Optional.empty());
    }

    public TeamRequest teamroles_association(UUID ownerid) {
        return new TeamRequest(contextPath.addSegment("teamroles_association").addKeys(new NameValue(ownerid, UUID.class)), Optional.empty());
    }

    public TeamCollectionRequest teamroles_association() {
        return new TeamCollectionRequest(contextPath.addSegment("teamroles_association"), Optional.empty());
    }

    public RoleRequest role_parent_root_role(UUID roleid) {
        return new RoleRequest(contextPath.addSegment("role_parent_root_role").addKeys(new NameValue(roleid, UUID.class)), Optional.empty());
    }

    public RoleCollectionRequest role_parent_root_role() {
        return new RoleCollectionRequest(contextPath.addSegment("role_parent_root_role"), Optional.empty());
    }

    public SyncerrorRequest role_SyncErrors(UUID syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("Role_SyncErrors").addKeys(new NameValue(syncerrorid, UUID.class)), Optional.empty());
    }

    public SyncerrorCollectionRequest role_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("Role_SyncErrors"), Optional.empty());
    }

    public ApplicationuserRequest applicationuserrole(UUID applicationuserid) {
        return new ApplicationuserRequest(contextPath.addSegment("applicationuserrole").addKeys(new NameValue(applicationuserid, UUID.class)), Optional.empty());
    }

    public ApplicationuserCollectionRequest applicationuserrole() {
        return new ApplicationuserCollectionRequest(contextPath.addSegment("applicationuserrole"), Optional.empty());
    }

}
