package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.Relationshipattribute;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.BulkdeletefailureRequest;
import microsoft.dynamics.crm.entity.request.MailboxtrackingfolderRequest;
import microsoft.dynamics.crm.entity.request.PrincipalobjectattributeaccessRequest;
import microsoft.dynamics.crm.entity.request.RelationshipattributeRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;

public class RelationshipattributeCollectionRequest extends CollectionPageEntityRequest<Relationshipattribute, RelationshipattributeRequest>{

    protected ContextPath contextPath;

    public RelationshipattributeCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Relationshipattribute.class, cp -> new RelationshipattributeRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public SyncerrorRequest relationshipattribute_SyncErrors(UUID syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("relationshipattribute_SyncErrors").addKeys(new NameValue(syncerrorid, UUID.class)), Optional.empty());
    }

    public SyncerrorCollectionRequest relationshipattribute_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("relationshipattribute_SyncErrors"), Optional.empty());
    }

    public AsyncoperationRequest relationshipattribute_AsyncOperations(UUID asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("relationshipattribute_AsyncOperations").addKeys(new NameValue(asyncoperationid, UUID.class)), Optional.empty());
    }

    public AsyncoperationCollectionRequest relationshipattribute_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("relationshipattribute_AsyncOperations"), Optional.empty());
    }

    public MailboxtrackingfolderRequest relationshipattribute_MailboxTrackingFolders(UUID mailboxtrackingfolderid) {
        return new MailboxtrackingfolderRequest(contextPath.addSegment("relationshipattribute_MailboxTrackingFolders").addKeys(new NameValue(mailboxtrackingfolderid, UUID.class)), Optional.empty());
    }

    public MailboxtrackingfolderCollectionRequest relationshipattribute_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(contextPath.addSegment("relationshipattribute_MailboxTrackingFolders"), Optional.empty());
    }

    public BulkdeletefailureRequest relationshipattribute_BulkDeleteFailures(UUID bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("relationshipattribute_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid, UUID.class)), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest relationshipattribute_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(contextPath.addSegment("relationshipattribute_BulkDeleteFailures"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest relationshipattribute_PrincipalObjectAttributeAccesses(UUID principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("relationshipattribute_PrincipalObjectAttributeAccesses").addKeys(new NameValue(principalobjectattributeaccessid, UUID.class)), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest relationshipattribute_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(contextPath.addSegment("relationshipattribute_PrincipalObjectAttributeAccesses"), Optional.empty());
    }

}
