package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.Quarterlyfiscalcalendar;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.BulkdeletefailureRequest;
import microsoft.dynamics.crm.entity.request.QuarterlyfiscalcalendarRequest;

public class QuarterlyfiscalcalendarCollectionRequest extends CollectionPageEntityRequest<Quarterlyfiscalcalendar, QuarterlyfiscalcalendarRequest>{

    protected ContextPath contextPath;

    public QuarterlyfiscalcalendarCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Quarterlyfiscalcalendar.class, cp -> new QuarterlyfiscalcalendarRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public AsyncoperationRequest quarterlyFiscalCalendar_AsyncOperations(UUID asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("QuarterlyFiscalCalendar_AsyncOperations").addKeys(new NameValue(asyncoperationid, UUID.class)), Optional.empty());
    }

    public AsyncoperationCollectionRequest quarterlyFiscalCalendar_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("QuarterlyFiscalCalendar_AsyncOperations"), Optional.empty());
    }

    public BulkdeletefailureRequest quarterlyFiscalCalendar_BulkDeleteFailures(UUID bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("QuarterlyFiscalCalendar_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid, UUID.class)), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest quarterlyFiscalCalendar_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(contextPath.addSegment("QuarterlyFiscalCalendar_BulkDeleteFailures"), Optional.empty());
    }

}
