package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.Processstageparameter;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.BulkdeletefailureRequest;
import microsoft.dynamics.crm.entity.request.MailboxtrackingfolderRequest;
import microsoft.dynamics.crm.entity.request.PrincipalobjectattributeaccessRequest;
import microsoft.dynamics.crm.entity.request.ProcesssessionRequest;
import microsoft.dynamics.crm.entity.request.ProcessstageparameterRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;

public class ProcessstageparameterCollectionRequest extends CollectionPageEntityRequest<Processstageparameter, ProcessstageparameterRequest>{

    protected ContextPath contextPath;

    public ProcessstageparameterCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Processstageparameter.class, cp -> new ProcessstageparameterRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public SyncerrorRequest processstageparameter_SyncErrors(UUID syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("processstageparameter_SyncErrors").addKeys(new NameValue(syncerrorid, UUID.class)), Optional.empty());
    }

    public SyncerrorCollectionRequest processstageparameter_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("processstageparameter_SyncErrors"), Optional.empty());
    }

    public AsyncoperationRequest processstageparameter_AsyncOperations(UUID asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("processstageparameter_AsyncOperations").addKeys(new NameValue(asyncoperationid, UUID.class)), Optional.empty());
    }

    public AsyncoperationCollectionRequest processstageparameter_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("processstageparameter_AsyncOperations"), Optional.empty());
    }

    public MailboxtrackingfolderRequest processstageparameter_MailboxTrackingFolders(UUID mailboxtrackingfolderid) {
        return new MailboxtrackingfolderRequest(contextPath.addSegment("processstageparameter_MailboxTrackingFolders").addKeys(new NameValue(mailboxtrackingfolderid, UUID.class)), Optional.empty());
    }

    public MailboxtrackingfolderCollectionRequest processstageparameter_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(contextPath.addSegment("processstageparameter_MailboxTrackingFolders"), Optional.empty());
    }

    public ProcesssessionRequest processstageparameter_ProcessSession(UUID processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("processstageparameter_ProcessSession").addKeys(new NameValue(processsessionid, UUID.class)), Optional.empty());
    }

    public ProcesssessionCollectionRequest processstageparameter_ProcessSession() {
        return new ProcesssessionCollectionRequest(contextPath.addSegment("processstageparameter_ProcessSession"), Optional.empty());
    }

    public BulkdeletefailureRequest processstageparameter_BulkDeleteFailures(UUID bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("processstageparameter_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid, UUID.class)), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest processstageparameter_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(contextPath.addSegment("processstageparameter_BulkDeleteFailures"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest processstageparameter_PrincipalObjectAttributeAccesses(UUID principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("processstageparameter_PrincipalObjectAttributeAccesses").addKeys(new NameValue(principalobjectattributeaccessid, UUID.class)), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest processstageparameter_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(contextPath.addSegment("processstageparameter_PrincipalObjectAttributeAccesses"), Optional.empty());
    }

}
