package microsoft.dynamics.crm.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.Privilege;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.BulkdeletefailureRequest;
import microsoft.dynamics.crm.entity.request.PrivilegeRequest;
import microsoft.dynamics.crm.entity.request.RoleRequest;
import microsoft.dynamics.crm.entity.request.RoletemplateRequest;

public class PrivilegeCollectionRequest extends CollectionPageEntityRequest<Privilege, PrivilegeRequest>{

    protected ContextPath contextPath;

    public PrivilegeCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Privilege.class, cp -> new PrivilegeRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public RoletemplateRequest roletemplateprivileges_association(UUID roletemplateid) {
        return new RoletemplateRequest(contextPath.addSegment("roletemplateprivileges_association").addKeys(new NameValue(roletemplateid, UUID.class)), Optional.empty());
    }

    public RoletemplateCollectionRequest roletemplateprivileges_association() {
        return new RoletemplateCollectionRequest(contextPath.addSegment("roletemplateprivileges_association"), Optional.empty());
    }

    public RoleRequest roleprivileges_association(UUID roleid) {
        return new RoleRequest(contextPath.addSegment("roleprivileges_association").addKeys(new NameValue(roleid, UUID.class)), Optional.empty());
    }

    public RoleCollectionRequest roleprivileges_association() {
        return new RoleCollectionRequest(contextPath.addSegment("roleprivileges_association"), Optional.empty());
    }

    public AsyncoperationRequest privilege_AsyncOperations(UUID asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("Privilege_AsyncOperations").addKeys(new NameValue(asyncoperationid, UUID.class)), Optional.empty());
    }

    public AsyncoperationCollectionRequest privilege_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("Privilege_AsyncOperations"), Optional.empty());
    }

    public BulkdeletefailureRequest privilege_BulkDeleteFailures(UUID bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("Privilege_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid, UUID.class)), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest privilege_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(contextPath.addSegment("Privilege_BulkDeleteFailures"), Optional.empty());
    }

    @Function(name = "RetrievePrivilegeSet")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Privilege> retrievePrivilegeSet() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrievePrivilegeSet"), Privilege.class, _parameters);
    }

}
