package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.Msdyn_solutionhealthruleargument;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.BulkdeletefailureRequest;
import microsoft.dynamics.crm.entity.request.DuplicaterecordRequest;
import microsoft.dynamics.crm.entity.request.MailboxtrackingfolderRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_solutionhealthruleargumentRequest;
import microsoft.dynamics.crm.entity.request.PrincipalobjectattributeaccessRequest;
import microsoft.dynamics.crm.entity.request.ProcesssessionRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;

public class Msdyn_solutionhealthruleargumentCollectionRequest extends CollectionPageEntityRequest<Msdyn_solutionhealthruleargument, Msdyn_solutionhealthruleargumentRequest>{

    protected ContextPath contextPath;

    public Msdyn_solutionhealthruleargumentCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Msdyn_solutionhealthruleargument.class, cp -> new Msdyn_solutionhealthruleargumentRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public SyncerrorRequest msdyn_solutionhealthruleargument_SyncErrors(UUID syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("msdyn_solutionhealthruleargument_SyncErrors").addKeys(new NameValue(syncerrorid, UUID.class)), Optional.empty());
    }

    public SyncerrorCollectionRequest msdyn_solutionhealthruleargument_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("msdyn_solutionhealthruleargument_SyncErrors"), Optional.empty());
    }

    public DuplicaterecordRequest msdyn_solutionhealthruleargument_DuplicateMatchingRecord(UUID duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("msdyn_solutionhealthruleargument_DuplicateMatchingRecord").addKeys(new NameValue(duplicateid, UUID.class)), Optional.empty());
    }

    public DuplicaterecordCollectionRequest msdyn_solutionhealthruleargument_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(contextPath.addSegment("msdyn_solutionhealthruleargument_DuplicateMatchingRecord"), Optional.empty());
    }

    public DuplicaterecordRequest msdyn_solutionhealthruleargument_DuplicateBaseRecord(UUID duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("msdyn_solutionhealthruleargument_DuplicateBaseRecord").addKeys(new NameValue(duplicateid, UUID.class)), Optional.empty());
    }

    public DuplicaterecordCollectionRequest msdyn_solutionhealthruleargument_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(contextPath.addSegment("msdyn_solutionhealthruleargument_DuplicateBaseRecord"), Optional.empty());
    }

    public AsyncoperationRequest msdyn_solutionhealthruleargument_AsyncOperations(UUID asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("msdyn_solutionhealthruleargument_AsyncOperations").addKeys(new NameValue(asyncoperationid, UUID.class)), Optional.empty());
    }

    public AsyncoperationCollectionRequest msdyn_solutionhealthruleargument_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("msdyn_solutionhealthruleargument_AsyncOperations"), Optional.empty());
    }

    public MailboxtrackingfolderRequest msdyn_solutionhealthruleargument_MailboxTrackingFolders(UUID mailboxtrackingfolderid) {
        return new MailboxtrackingfolderRequest(contextPath.addSegment("msdyn_solutionhealthruleargument_MailboxTrackingFolders").addKeys(new NameValue(mailboxtrackingfolderid, UUID.class)), Optional.empty());
    }

    public MailboxtrackingfolderCollectionRequest msdyn_solutionhealthruleargument_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(contextPath.addSegment("msdyn_solutionhealthruleargument_MailboxTrackingFolders"), Optional.empty());
    }

    public ProcesssessionRequest msdyn_solutionhealthruleargument_ProcessSession(UUID processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("msdyn_solutionhealthruleargument_ProcessSession").addKeys(new NameValue(processsessionid, UUID.class)), Optional.empty());
    }

    public ProcesssessionCollectionRequest msdyn_solutionhealthruleargument_ProcessSession() {
        return new ProcesssessionCollectionRequest(contextPath.addSegment("msdyn_solutionhealthruleargument_ProcessSession"), Optional.empty());
    }

    public BulkdeletefailureRequest msdyn_solutionhealthruleargument_BulkDeleteFailures(UUID bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("msdyn_solutionhealthruleargument_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid, UUID.class)), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest msdyn_solutionhealthruleargument_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(contextPath.addSegment("msdyn_solutionhealthruleargument_BulkDeleteFailures"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest msdyn_solutionhealthruleargument_PrincipalObjectAttributeAccesses(UUID principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("msdyn_solutionhealthruleargument_PrincipalObjectAttributeAccesses").addKeys(new NameValue(principalobjectattributeaccessid, UUID.class)), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest msdyn_solutionhealthruleargument_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(contextPath.addSegment("msdyn_solutionhealthruleargument_PrincipalObjectAttributeAccesses"), Optional.empty());
    }

}
