package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.Msdyn_solutionhealthrule;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.BulkdeletefailureRequest;
import microsoft.dynamics.crm.entity.request.DuplicaterecordRequest;
import microsoft.dynamics.crm.entity.request.MailboxtrackingfolderRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_solutionhealthruleRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_solutionhealthruleargumentRequest;
import microsoft.dynamics.crm.entity.request.PrincipalobjectattributeaccessRequest;
import microsoft.dynamics.crm.entity.request.ProcesssessionRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;

public class Msdyn_solutionhealthruleCollectionRequest extends CollectionPageEntityRequest<Msdyn_solutionhealthrule, Msdyn_solutionhealthruleRequest>{

    protected ContextPath contextPath;

    public Msdyn_solutionhealthruleCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Msdyn_solutionhealthrule.class, cp -> new Msdyn_solutionhealthruleRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public SyncerrorRequest msdyn_solutionhealthrule_SyncErrors(UUID syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("msdyn_solutionhealthrule_SyncErrors").addKeys(new NameValue(syncerrorid, UUID.class)), Optional.empty());
    }

    public SyncerrorCollectionRequest msdyn_solutionhealthrule_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("msdyn_solutionhealthrule_SyncErrors"), Optional.empty());
    }

    public DuplicaterecordRequest msdyn_solutionhealthrule_DuplicateMatchingRecord(UUID duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("msdyn_solutionhealthrule_DuplicateMatchingRecord").addKeys(new NameValue(duplicateid, UUID.class)), Optional.empty());
    }

    public DuplicaterecordCollectionRequest msdyn_solutionhealthrule_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(contextPath.addSegment("msdyn_solutionhealthrule_DuplicateMatchingRecord"), Optional.empty());
    }

    public DuplicaterecordRequest msdyn_solutionhealthrule_DuplicateBaseRecord(UUID duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("msdyn_solutionhealthrule_DuplicateBaseRecord").addKeys(new NameValue(duplicateid, UUID.class)), Optional.empty());
    }

    public DuplicaterecordCollectionRequest msdyn_solutionhealthrule_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(contextPath.addSegment("msdyn_solutionhealthrule_DuplicateBaseRecord"), Optional.empty());
    }

    public AsyncoperationRequest msdyn_solutionhealthrule_AsyncOperations(UUID asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("msdyn_solutionhealthrule_AsyncOperations").addKeys(new NameValue(asyncoperationid, UUID.class)), Optional.empty());
    }

    public AsyncoperationCollectionRequest msdyn_solutionhealthrule_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("msdyn_solutionhealthrule_AsyncOperations"), Optional.empty());
    }

    public MailboxtrackingfolderRequest msdyn_solutionhealthrule_MailboxTrackingFolders(UUID mailboxtrackingfolderid) {
        return new MailboxtrackingfolderRequest(contextPath.addSegment("msdyn_solutionhealthrule_MailboxTrackingFolders").addKeys(new NameValue(mailboxtrackingfolderid, UUID.class)), Optional.empty());
    }

    public MailboxtrackingfolderCollectionRequest msdyn_solutionhealthrule_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(contextPath.addSegment("msdyn_solutionhealthrule_MailboxTrackingFolders"), Optional.empty());
    }

    public ProcesssessionRequest msdyn_solutionhealthrule_ProcessSession(UUID processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("msdyn_solutionhealthrule_ProcessSession").addKeys(new NameValue(processsessionid, UUID.class)), Optional.empty());
    }

    public ProcesssessionCollectionRequest msdyn_solutionhealthrule_ProcessSession() {
        return new ProcesssessionCollectionRequest(contextPath.addSegment("msdyn_solutionhealthrule_ProcessSession"), Optional.empty());
    }

    public BulkdeletefailureRequest msdyn_solutionhealthrule_BulkDeleteFailures(UUID bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("msdyn_solutionhealthrule_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid, UUID.class)), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest msdyn_solutionhealthrule_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(contextPath.addSegment("msdyn_solutionhealthrule_BulkDeleteFailures"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest msdyn_solutionhealthrule_PrincipalObjectAttributeAccesses(UUID principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("msdyn_solutionhealthrule_PrincipalObjectAttributeAccesses").addKeys(new NameValue(principalobjectattributeaccessid, UUID.class)), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest msdyn_solutionhealthrule_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(contextPath.addSegment("msdyn_solutionhealthrule_PrincipalObjectAttributeAccesses"), Optional.empty());
    }

    public Msdyn_solutionhealthruleargumentRequest msdyn_msdyn_solutionhealthrule_msdyn_solutionhealthruleargument_SolutionHealthRule(UUID msdyn_solutionhealthruleargumentid) {
        return new Msdyn_solutionhealthruleargumentRequest(contextPath.addSegment("msdyn_msdyn_solutionhealthrule_msdyn_solutionhealthruleargument_SolutionHealthRule").addKeys(new NameValue(msdyn_solutionhealthruleargumentid, UUID.class)), Optional.empty());
    }

    public Msdyn_solutionhealthruleargumentCollectionRequest msdyn_msdyn_solutionhealthrule_msdyn_solutionhealthruleargument_SolutionHealthRule() {
        return new Msdyn_solutionhealthruleargumentCollectionRequest(contextPath.addSegment("msdyn_msdyn_solutionhealthrule_msdyn_solutionhealthruleargument_SolutionHealthRule"), Optional.empty());
    }

}
