package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.Msdyn_knowledgearticleimage;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.BulkdeletefailureRequest;
import microsoft.dynamics.crm.entity.request.DuplicaterecordRequest;
import microsoft.dynamics.crm.entity.request.FileattachmentRequest;
import microsoft.dynamics.crm.entity.request.MailboxtrackingfolderRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_knowledgearticleimageRequest;
import microsoft.dynamics.crm.entity.request.PrincipalobjectattributeaccessRequest;
import microsoft.dynamics.crm.entity.request.ProcesssessionRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;

public class Msdyn_knowledgearticleimageCollectionRequest extends CollectionPageEntityRequest<Msdyn_knowledgearticleimage, Msdyn_knowledgearticleimageRequest>{

    protected ContextPath contextPath;

    public Msdyn_knowledgearticleimageCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Msdyn_knowledgearticleimage.class, cp -> new Msdyn_knowledgearticleimageRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public SyncerrorRequest msdyn_knowledgearticleimage_SyncErrors(UUID syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("msdyn_knowledgearticleimage_SyncErrors").addKeys(new NameValue(syncerrorid, UUID.class)), Optional.empty());
    }

    public SyncerrorCollectionRequest msdyn_knowledgearticleimage_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("msdyn_knowledgearticleimage_SyncErrors"), Optional.empty());
    }

    public DuplicaterecordRequest msdyn_knowledgearticleimage_DuplicateMatchingRecord(UUID duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("msdyn_knowledgearticleimage_DuplicateMatchingRecord").addKeys(new NameValue(duplicateid, UUID.class)), Optional.empty());
    }

    public DuplicaterecordCollectionRequest msdyn_knowledgearticleimage_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(contextPath.addSegment("msdyn_knowledgearticleimage_DuplicateMatchingRecord"), Optional.empty());
    }

    public DuplicaterecordRequest msdyn_knowledgearticleimage_DuplicateBaseRecord(UUID duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("msdyn_knowledgearticleimage_DuplicateBaseRecord").addKeys(new NameValue(duplicateid, UUID.class)), Optional.empty());
    }

    public DuplicaterecordCollectionRequest msdyn_knowledgearticleimage_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(contextPath.addSegment("msdyn_knowledgearticleimage_DuplicateBaseRecord"), Optional.empty());
    }

    public AsyncoperationRequest msdyn_knowledgearticleimage_AsyncOperations(UUID asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("msdyn_knowledgearticleimage_AsyncOperations").addKeys(new NameValue(asyncoperationid, UUID.class)), Optional.empty());
    }

    public AsyncoperationCollectionRequest msdyn_knowledgearticleimage_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("msdyn_knowledgearticleimage_AsyncOperations"), Optional.empty());
    }

    public MailboxtrackingfolderRequest msdyn_knowledgearticleimage_MailboxTrackingFolders(UUID mailboxtrackingfolderid) {
        return new MailboxtrackingfolderRequest(contextPath.addSegment("msdyn_knowledgearticleimage_MailboxTrackingFolders").addKeys(new NameValue(mailboxtrackingfolderid, UUID.class)), Optional.empty());
    }

    public MailboxtrackingfolderCollectionRequest msdyn_knowledgearticleimage_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(contextPath.addSegment("msdyn_knowledgearticleimage_MailboxTrackingFolders"), Optional.empty());
    }

    public ProcesssessionRequest msdyn_knowledgearticleimage_ProcessSession(UUID processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("msdyn_knowledgearticleimage_ProcessSession").addKeys(new NameValue(processsessionid, UUID.class)), Optional.empty());
    }

    public ProcesssessionCollectionRequest msdyn_knowledgearticleimage_ProcessSession() {
        return new ProcesssessionCollectionRequest(contextPath.addSegment("msdyn_knowledgearticleimage_ProcessSession"), Optional.empty());
    }

    public BulkdeletefailureRequest msdyn_knowledgearticleimage_BulkDeleteFailures(UUID bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("msdyn_knowledgearticleimage_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid, UUID.class)), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest msdyn_knowledgearticleimage_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(contextPath.addSegment("msdyn_knowledgearticleimage_BulkDeleteFailures"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest msdyn_knowledgearticleimage_PrincipalObjectAttributeAccesses(UUID principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("msdyn_knowledgearticleimage_PrincipalObjectAttributeAccesses").addKeys(new NameValue(principalobjectattributeaccessid, UUID.class)), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest msdyn_knowledgearticleimage_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(contextPath.addSegment("msdyn_knowledgearticleimage_PrincipalObjectAttributeAccesses"), Optional.empty());
    }

    public FileattachmentRequest msdyn_knowledgearticleimage_FileAttachments(UUID fileattachmentid) {
        return new FileattachmentRequest(contextPath.addSegment("msdyn_knowledgearticleimage_FileAttachments").addKeys(new NameValue(fileattachmentid, UUID.class)), Optional.empty());
    }

    public FileattachmentCollectionRequest msdyn_knowledgearticleimage_FileAttachments() {
        return new FileattachmentCollectionRequest(contextPath.addSegment("msdyn_knowledgearticleimage_FileAttachments"), Optional.empty());
    }

}
