package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.Msdyn_aiconfiguration;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.BulkdeletefailureRequest;
import microsoft.dynamics.crm.entity.request.FileattachmentRequest;
import microsoft.dynamics.crm.entity.request.MailboxtrackingfolderRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aiconfigurationRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aifptrainingdocumentRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aiodlabelRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aiodtrainingimageRequest;
import microsoft.dynamics.crm.entity.request.PrincipalobjectattributeaccessRequest;
import microsoft.dynamics.crm.entity.request.ProcesssessionRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;

public class Msdyn_aiconfigurationCollectionRequest extends CollectionPageEntityRequest<Msdyn_aiconfiguration, Msdyn_aiconfigurationRequest>{

    protected ContextPath contextPath;

    public Msdyn_aiconfigurationCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Msdyn_aiconfiguration.class, cp -> new Msdyn_aiconfigurationRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public SyncerrorRequest msdyn_aiconfiguration_SyncErrors(UUID syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("msdyn_aiconfiguration_SyncErrors").addKeys(new NameValue(syncerrorid, UUID.class)), Optional.empty());
    }

    public SyncerrorCollectionRequest msdyn_aiconfiguration_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("msdyn_aiconfiguration_SyncErrors"), Optional.empty());
    }

    public AsyncoperationRequest msdyn_aiconfiguration_AsyncOperations(UUID asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("msdyn_aiconfiguration_AsyncOperations").addKeys(new NameValue(asyncoperationid, UUID.class)), Optional.empty());
    }

    public AsyncoperationCollectionRequest msdyn_aiconfiguration_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("msdyn_aiconfiguration_AsyncOperations"), Optional.empty());
    }

    public MailboxtrackingfolderRequest msdyn_aiconfiguration_MailboxTrackingFolders(UUID mailboxtrackingfolderid) {
        return new MailboxtrackingfolderRequest(contextPath.addSegment("msdyn_aiconfiguration_MailboxTrackingFolders").addKeys(new NameValue(mailboxtrackingfolderid, UUID.class)), Optional.empty());
    }

    public MailboxtrackingfolderCollectionRequest msdyn_aiconfiguration_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(contextPath.addSegment("msdyn_aiconfiguration_MailboxTrackingFolders"), Optional.empty());
    }

    public ProcesssessionRequest msdyn_aiconfiguration_ProcessSession(UUID processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("msdyn_aiconfiguration_ProcessSession").addKeys(new NameValue(processsessionid, UUID.class)), Optional.empty());
    }

    public ProcesssessionCollectionRequest msdyn_aiconfiguration_ProcessSession() {
        return new ProcesssessionCollectionRequest(contextPath.addSegment("msdyn_aiconfiguration_ProcessSession"), Optional.empty());
    }

    public BulkdeletefailureRequest msdyn_aiconfiguration_BulkDeleteFailures(UUID bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("msdyn_aiconfiguration_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid, UUID.class)), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest msdyn_aiconfiguration_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(contextPath.addSegment("msdyn_aiconfiguration_BulkDeleteFailures"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest msdyn_aiconfiguration_PrincipalObjectAttributeAccesses(UUID principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("msdyn_aiconfiguration_PrincipalObjectAttributeAccesses").addKeys(new NameValue(principalobjectattributeaccessid, UUID.class)), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest msdyn_aiconfiguration_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(contextPath.addSegment("msdyn_aiconfiguration_PrincipalObjectAttributeAccesses"), Optional.empty());
    }

    public FileattachmentRequest msdyn_aiconfiguration_FileAttachments(UUID fileattachmentid) {
        return new FileattachmentRequest(contextPath.addSegment("msdyn_aiconfiguration_FileAttachments").addKeys(new NameValue(fileattachmentid, UUID.class)), Optional.empty());
    }

    public FileattachmentCollectionRequest msdyn_aiconfiguration_FileAttachments() {
        return new FileattachmentCollectionRequest(contextPath.addSegment("msdyn_aiconfiguration_FileAttachments"), Optional.empty());
    }

    public Msdyn_aiconfigurationRequest msdyn_aiconfiguration_msdyn_aiconfiguration(UUID msdyn_aiconfigurationid) {
        return new Msdyn_aiconfigurationRequest(contextPath.addSegment("msdyn_aiconfiguration_msdyn_aiconfiguration").addKeys(new NameValue(msdyn_aiconfigurationid, UUID.class)), Optional.empty());
    }

    public Msdyn_aiconfigurationCollectionRequest msdyn_aiconfiguration_msdyn_aiconfiguration() {
        return new Msdyn_aiconfigurationCollectionRequest(contextPath.addSegment("msdyn_aiconfiguration_msdyn_aiconfiguration"), Optional.empty());
    }

    public Msdyn_aiconfigurationRequest msdyn_createdfromconfiguration_msdyn_toconfiguration(UUID msdyn_aiconfigurationid) {
        return new Msdyn_aiconfigurationRequest(contextPath.addSegment("msdyn_createdfromconfiguration_msdyn_toconfiguration").addKeys(new NameValue(msdyn_aiconfigurationid, UUID.class)), Optional.empty());
    }

    public Msdyn_aiconfigurationCollectionRequest msdyn_createdfromconfiguration_msdyn_toconfiguration() {
        return new Msdyn_aiconfigurationCollectionRequest(contextPath.addSegment("msdyn_createdfromconfiguration_msdyn_toconfiguration"), Optional.empty());
    }

    public Msdyn_aiodtrainingimageRequest msdyn_aiconfiguration_msdyn_aiodtrainingimage(UUID msdyn_aiodtrainingimageid) {
        return new Msdyn_aiodtrainingimageRequest(contextPath.addSegment("msdyn_aiconfiguration_msdyn_aiodtrainingimage").addKeys(new NameValue(msdyn_aiodtrainingimageid, UUID.class)), Optional.empty());
    }

    public Msdyn_aiodtrainingimageCollectionRequest msdyn_aiconfiguration_msdyn_aiodtrainingimage() {
        return new Msdyn_aiodtrainingimageCollectionRequest(contextPath.addSegment("msdyn_aiconfiguration_msdyn_aiodtrainingimage"), Optional.empty());
    }

    public Msdyn_aiodlabelRequest msdyn_aiodlabel_msdyn_aiconfiguration(UUID msdyn_aiodlabelid) {
        return new Msdyn_aiodlabelRequest(contextPath.addSegment("msdyn_aiodlabel_msdyn_aiconfiguration").addKeys(new NameValue(msdyn_aiodlabelid, UUID.class)), Optional.empty());
    }

    public Msdyn_aiodlabelCollectionRequest msdyn_aiodlabel_msdyn_aiconfiguration() {
        return new Msdyn_aiodlabelCollectionRequest(contextPath.addSegment("msdyn_aiodlabel_msdyn_aiconfiguration"), Optional.empty());
    }

    public Msdyn_aifptrainingdocumentRequest msdyn_msdyn_aiconfiguration_msdyn_aifptrainingdocument_AIConfigurationId(UUID msdyn_aifptrainingdocumentid) {
        return new Msdyn_aifptrainingdocumentRequest(contextPath.addSegment("msdyn_msdyn_aiconfiguration_msdyn_aifptrainingdocument_AIConfigurationId").addKeys(new NameValue(msdyn_aifptrainingdocumentid, UUID.class)), Optional.empty());
    }

    public Msdyn_aifptrainingdocumentCollectionRequest msdyn_msdyn_aiconfiguration_msdyn_aifptrainingdocument_AIConfigurationId() {
        return new Msdyn_aifptrainingdocumentCollectionRequest(contextPath.addSegment("msdyn_msdyn_aiconfiguration_msdyn_aifptrainingdocument_AIConfigurationId"), Optional.empty());
    }

}
