package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.Msdyn_aibdatasetscontainer;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.BulkdeletefailureRequest;
import microsoft.dynamics.crm.entity.request.DuplicaterecordRequest;
import microsoft.dynamics.crm.entity.request.MailboxtrackingfolderRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aibdatasetRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aibdatasetscontainerRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aibfileRequest;
import microsoft.dynamics.crm.entity.request.PrincipalobjectattributeaccessRequest;
import microsoft.dynamics.crm.entity.request.ProcesssessionRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;

public class Msdyn_aibdatasetscontainerCollectionRequest extends CollectionPageEntityRequest<Msdyn_aibdatasetscontainer, Msdyn_aibdatasetscontainerRequest>{

    protected ContextPath contextPath;

    public Msdyn_aibdatasetscontainerCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Msdyn_aibdatasetscontainer.class, cp -> new Msdyn_aibdatasetscontainerRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public SyncerrorRequest msdyn_aibdatasetscontainer_SyncErrors(UUID syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("msdyn_aibdatasetscontainer_SyncErrors").addKeys(new NameValue(syncerrorid, UUID.class)), Optional.empty());
    }

    public SyncerrorCollectionRequest msdyn_aibdatasetscontainer_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("msdyn_aibdatasetscontainer_SyncErrors"), Optional.empty());
    }

    public DuplicaterecordRequest msdyn_aibdatasetscontainer_DuplicateMatchingRecord(UUID duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("msdyn_aibdatasetscontainer_DuplicateMatchingRecord").addKeys(new NameValue(duplicateid, UUID.class)), Optional.empty());
    }

    public DuplicaterecordCollectionRequest msdyn_aibdatasetscontainer_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(contextPath.addSegment("msdyn_aibdatasetscontainer_DuplicateMatchingRecord"), Optional.empty());
    }

    public DuplicaterecordRequest msdyn_aibdatasetscontainer_DuplicateBaseRecord(UUID duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("msdyn_aibdatasetscontainer_DuplicateBaseRecord").addKeys(new NameValue(duplicateid, UUID.class)), Optional.empty());
    }

    public DuplicaterecordCollectionRequest msdyn_aibdatasetscontainer_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(contextPath.addSegment("msdyn_aibdatasetscontainer_DuplicateBaseRecord"), Optional.empty());
    }

    public AsyncoperationRequest msdyn_aibdatasetscontainer_AsyncOperations(UUID asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("msdyn_aibdatasetscontainer_AsyncOperations").addKeys(new NameValue(asyncoperationid, UUID.class)), Optional.empty());
    }

    public AsyncoperationCollectionRequest msdyn_aibdatasetscontainer_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("msdyn_aibdatasetscontainer_AsyncOperations"), Optional.empty());
    }

    public MailboxtrackingfolderRequest msdyn_aibdatasetscontainer_MailboxTrackingFolders(UUID mailboxtrackingfolderid) {
        return new MailboxtrackingfolderRequest(contextPath.addSegment("msdyn_aibdatasetscontainer_MailboxTrackingFolders").addKeys(new NameValue(mailboxtrackingfolderid, UUID.class)), Optional.empty());
    }

    public MailboxtrackingfolderCollectionRequest msdyn_aibdatasetscontainer_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(contextPath.addSegment("msdyn_aibdatasetscontainer_MailboxTrackingFolders"), Optional.empty());
    }

    public ProcesssessionRequest msdyn_aibdatasetscontainer_ProcessSession(UUID processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("msdyn_aibdatasetscontainer_ProcessSession").addKeys(new NameValue(processsessionid, UUID.class)), Optional.empty());
    }

    public ProcesssessionCollectionRequest msdyn_aibdatasetscontainer_ProcessSession() {
        return new ProcesssessionCollectionRequest(contextPath.addSegment("msdyn_aibdatasetscontainer_ProcessSession"), Optional.empty());
    }

    public BulkdeletefailureRequest msdyn_aibdatasetscontainer_BulkDeleteFailures(UUID bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("msdyn_aibdatasetscontainer_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid, UUID.class)), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest msdyn_aibdatasetscontainer_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(contextPath.addSegment("msdyn_aibdatasetscontainer_BulkDeleteFailures"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest msdyn_aibdatasetscontainer_PrincipalObjectAttributeAccesses(UUID principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("msdyn_aibdatasetscontainer_PrincipalObjectAttributeAccesses").addKeys(new NameValue(principalobjectattributeaccessid, UUID.class)), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest msdyn_aibdatasetscontainer_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(contextPath.addSegment("msdyn_aibdatasetscontainer_PrincipalObjectAttributeAccesses"), Optional.empty());
    }

    public Msdyn_aibdatasetRequest msdyn_AIBDataset_msdyn_AIBDatasetsContain(UUID msdyn_aibdatasetid) {
        return new Msdyn_aibdatasetRequest(contextPath.addSegment("msdyn_AIBDataset_msdyn_AIBDatasetsContain").addKeys(new NameValue(msdyn_aibdatasetid, UUID.class)), Optional.empty());
    }

    public Msdyn_aibdatasetCollectionRequest msdyn_AIBDataset_msdyn_AIBDatasetsContain() {
        return new Msdyn_aibdatasetCollectionRequest(contextPath.addSegment("msdyn_AIBDataset_msdyn_AIBDatasetsContain"), Optional.empty());
    }

    public Msdyn_aibfileRequest msdyn_AIBFile_msdyn_AIBDatasetsCont(UUID msdyn_aibfileid) {
        return new Msdyn_aibfileRequest(contextPath.addSegment("msdyn_AIBFile_msdyn_AIBDatasetsCont").addKeys(new NameValue(msdyn_aibfileid, UUID.class)), Optional.empty());
    }

    public Msdyn_aibfileCollectionRequest msdyn_AIBFile_msdyn_AIBDatasetsCont() {
        return new Msdyn_aibfileCollectionRequest(contextPath.addSegment("msdyn_AIBFile_msdyn_AIBDatasetsCont"), Optional.empty());
    }

}
