package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.Msdyn_aibdatasetfile;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.BulkdeletefailureRequest;
import microsoft.dynamics.crm.entity.request.DuplicaterecordRequest;
import microsoft.dynamics.crm.entity.request.MailboxtrackingfolderRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aibdatasetfileRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aibfileattacheddataRequest;
import microsoft.dynamics.crm.entity.request.PrincipalobjectattributeaccessRequest;
import microsoft.dynamics.crm.entity.request.ProcesssessionRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;

public class Msdyn_aibdatasetfileCollectionRequest extends CollectionPageEntityRequest<Msdyn_aibdatasetfile, Msdyn_aibdatasetfileRequest>{

    protected ContextPath contextPath;

    public Msdyn_aibdatasetfileCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Msdyn_aibdatasetfile.class, cp -> new Msdyn_aibdatasetfileRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public SyncerrorRequest msdyn_aibdatasetfile_SyncErrors(UUID syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("msdyn_aibdatasetfile_SyncErrors").addKeys(new NameValue(syncerrorid, UUID.class)), Optional.empty());
    }

    public SyncerrorCollectionRequest msdyn_aibdatasetfile_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("msdyn_aibdatasetfile_SyncErrors"), Optional.empty());
    }

    public DuplicaterecordRequest msdyn_aibdatasetfile_DuplicateMatchingRecord(UUID duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("msdyn_aibdatasetfile_DuplicateMatchingRecord").addKeys(new NameValue(duplicateid, UUID.class)), Optional.empty());
    }

    public DuplicaterecordCollectionRequest msdyn_aibdatasetfile_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(contextPath.addSegment("msdyn_aibdatasetfile_DuplicateMatchingRecord"), Optional.empty());
    }

    public DuplicaterecordRequest msdyn_aibdatasetfile_DuplicateBaseRecord(UUID duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("msdyn_aibdatasetfile_DuplicateBaseRecord").addKeys(new NameValue(duplicateid, UUID.class)), Optional.empty());
    }

    public DuplicaterecordCollectionRequest msdyn_aibdatasetfile_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(contextPath.addSegment("msdyn_aibdatasetfile_DuplicateBaseRecord"), Optional.empty());
    }

    public AsyncoperationRequest msdyn_aibdatasetfile_AsyncOperations(UUID asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("msdyn_aibdatasetfile_AsyncOperations").addKeys(new NameValue(asyncoperationid, UUID.class)), Optional.empty());
    }

    public AsyncoperationCollectionRequest msdyn_aibdatasetfile_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("msdyn_aibdatasetfile_AsyncOperations"), Optional.empty());
    }

    public MailboxtrackingfolderRequest msdyn_aibdatasetfile_MailboxTrackingFolders(UUID mailboxtrackingfolderid) {
        return new MailboxtrackingfolderRequest(contextPath.addSegment("msdyn_aibdatasetfile_MailboxTrackingFolders").addKeys(new NameValue(mailboxtrackingfolderid, UUID.class)), Optional.empty());
    }

    public MailboxtrackingfolderCollectionRequest msdyn_aibdatasetfile_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(contextPath.addSegment("msdyn_aibdatasetfile_MailboxTrackingFolders"), Optional.empty());
    }

    public ProcesssessionRequest msdyn_aibdatasetfile_ProcessSession(UUID processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("msdyn_aibdatasetfile_ProcessSession").addKeys(new NameValue(processsessionid, UUID.class)), Optional.empty());
    }

    public ProcesssessionCollectionRequest msdyn_aibdatasetfile_ProcessSession() {
        return new ProcesssessionCollectionRequest(contextPath.addSegment("msdyn_aibdatasetfile_ProcessSession"), Optional.empty());
    }

    public BulkdeletefailureRequest msdyn_aibdatasetfile_BulkDeleteFailures(UUID bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("msdyn_aibdatasetfile_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid, UUID.class)), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest msdyn_aibdatasetfile_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(contextPath.addSegment("msdyn_aibdatasetfile_BulkDeleteFailures"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest msdyn_aibdatasetfile_PrincipalObjectAttributeAccesses(UUID principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("msdyn_aibdatasetfile_PrincipalObjectAttributeAccesses").addKeys(new NameValue(principalobjectattributeaccessid, UUID.class)), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest msdyn_aibdatasetfile_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(contextPath.addSegment("msdyn_aibdatasetfile_PrincipalObjectAttributeAccesses"), Optional.empty());
    }

    public Msdyn_aibfileattacheddataRequest msdyn_AIBFileAttachedData_msdyn_AIB(UUID msdyn_aibfileattacheddataid) {
        return new Msdyn_aibfileattacheddataRequest(contextPath.addSegment("msdyn_AIBFileAttachedData_msdyn_AIB").addKeys(new NameValue(msdyn_aibfileattacheddataid, UUID.class)), Optional.empty());
    }

    public Msdyn_aibfileattacheddataCollectionRequest msdyn_AIBFileAttachedData_msdyn_AIB() {
        return new Msdyn_aibfileattacheddataCollectionRequest(contextPath.addSegment("msdyn_AIBFileAttachedData_msdyn_AIB"), Optional.empty());
    }

}
