package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.Knowledgearticleviews;
import microsoft.dynamics.crm.entity.request.KnowledgearticleviewsRequest;
import microsoft.dynamics.crm.entity.request.PrincipalobjectattributeaccessRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;

public class KnowledgearticleviewsCollectionRequest extends CollectionPageEntityRequest<Knowledgearticleviews, KnowledgearticleviewsRequest>{

    protected ContextPath contextPath;

    public KnowledgearticleviewsCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Knowledgearticleviews.class, cp -> new KnowledgearticleviewsRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public SyncerrorRequest knowledgeArticleViews_SyncErrors(UUID syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("KnowledgeArticleViews_SyncErrors").addKeys(new NameValue(syncerrorid, UUID.class)), Optional.empty());
    }

    public SyncerrorCollectionRequest knowledgeArticleViews_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("KnowledgeArticleViews_SyncErrors"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest knowledgearticleviews_principalobjectattributeaccess(UUID principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("knowledgearticleviews_principalobjectattributeaccess").addKeys(new NameValue(principalobjectattributeaccessid, UUID.class)), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest knowledgearticleviews_principalobjectattributeaccess() {
        return new PrincipalobjectattributeaccessCollectionRequest(contextPath.addSegment("knowledgearticleviews_principalobjectattributeaccess"), Optional.empty());
    }

}
