package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.Importdata;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.BulkdeletefailureRequest;
import microsoft.dynamics.crm.entity.request.ImportdataRequest;
import microsoft.dynamics.crm.entity.request.ImportlogRequest;

public class ImportdataCollectionRequest extends CollectionPageEntityRequest<Importdata, ImportdataRequest>{

    protected ContextPath contextPath;

    public ImportdataCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Importdata.class, cp -> new ImportdataRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public AsyncoperationRequest importData_AsyncOperations(UUID asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("ImportData_AsyncOperations").addKeys(new NameValue(asyncoperationid, UUID.class)), Optional.empty());
    }

    public AsyncoperationCollectionRequest importData_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("ImportData_AsyncOperations"), Optional.empty());
    }

    public ImportlogRequest importLog_ImportData(UUID importlogid) {
        return new ImportlogRequest(contextPath.addSegment("ImportLog_ImportData").addKeys(new NameValue(importlogid, UUID.class)), Optional.empty());
    }

    public ImportlogCollectionRequest importLog_ImportData() {
        return new ImportlogCollectionRequest(contextPath.addSegment("ImportLog_ImportData"), Optional.empty());
    }

    public BulkdeletefailureRequest importData_BulkDeleteFailures(UUID bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("ImportData_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid, UUID.class)), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest importData_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(contextPath.addSegment("ImportData_BulkDeleteFailures"), Optional.empty());
    }

}
