package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.Ggw_team_application;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.BulkdeletefailureRequest;
import microsoft.dynamics.crm.entity.request.DuplicaterecordRequest;
import microsoft.dynamics.crm.entity.request.Ggw_team_applicationRequest;
import microsoft.dynamics.crm.entity.request.MailboxtrackingfolderRequest;
import microsoft.dynamics.crm.entity.request.PrincipalobjectattributeaccessRequest;
import microsoft.dynamics.crm.entity.request.ProcesssessionRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;

public class Ggw_team_applicationCollectionRequest extends CollectionPageEntityRequest<Ggw_team_application, Ggw_team_applicationRequest>{

    protected ContextPath contextPath;

    public Ggw_team_applicationCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Ggw_team_application.class, cp -> new Ggw_team_applicationRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public SyncerrorRequest ggw_team_application_SyncErrors(UUID syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("ggw_team_application_SyncErrors").addKeys(new NameValue(syncerrorid, UUID.class)), Optional.empty());
    }

    public SyncerrorCollectionRequest ggw_team_application_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("ggw_team_application_SyncErrors"), Optional.empty());
    }

    public DuplicaterecordRequest ggw_team_application_DuplicateMatchingRecord(UUID duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("ggw_team_application_DuplicateMatchingRecord").addKeys(new NameValue(duplicateid, UUID.class)), Optional.empty());
    }

    public DuplicaterecordCollectionRequest ggw_team_application_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(contextPath.addSegment("ggw_team_application_DuplicateMatchingRecord"), Optional.empty());
    }

    public DuplicaterecordRequest ggw_team_application_DuplicateBaseRecord(UUID duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("ggw_team_application_DuplicateBaseRecord").addKeys(new NameValue(duplicateid, UUID.class)), Optional.empty());
    }

    public DuplicaterecordCollectionRequest ggw_team_application_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(contextPath.addSegment("ggw_team_application_DuplicateBaseRecord"), Optional.empty());
    }

    public AsyncoperationRequest ggw_team_application_AsyncOperations(UUID asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("ggw_team_application_AsyncOperations").addKeys(new NameValue(asyncoperationid, UUID.class)), Optional.empty());
    }

    public AsyncoperationCollectionRequest ggw_team_application_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("ggw_team_application_AsyncOperations"), Optional.empty());
    }

    public MailboxtrackingfolderRequest ggw_team_application_MailboxTrackingFolders(UUID mailboxtrackingfolderid) {
        return new MailboxtrackingfolderRequest(contextPath.addSegment("ggw_team_application_MailboxTrackingFolders").addKeys(new NameValue(mailboxtrackingfolderid, UUID.class)), Optional.empty());
    }

    public MailboxtrackingfolderCollectionRequest ggw_team_application_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(contextPath.addSegment("ggw_team_application_MailboxTrackingFolders"), Optional.empty());
    }

    public ProcesssessionRequest ggw_team_application_ProcessSession(UUID processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("ggw_team_application_ProcessSession").addKeys(new NameValue(processsessionid, UUID.class)), Optional.empty());
    }

    public ProcesssessionCollectionRequest ggw_team_application_ProcessSession() {
        return new ProcesssessionCollectionRequest(contextPath.addSegment("ggw_team_application_ProcessSession"), Optional.empty());
    }

    public BulkdeletefailureRequest ggw_team_application_BulkDeleteFailures(UUID bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("ggw_team_application_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid, UUID.class)), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest ggw_team_application_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(contextPath.addSegment("ggw_team_application_BulkDeleteFailures"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest ggw_team_application_PrincipalObjectAttributeAccesses(UUID principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("ggw_team_application_PrincipalObjectAttributeAccesses").addKeys(new NameValue(principalobjectattributeaccessid, UUID.class)), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest ggw_team_application_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(contextPath.addSegment("ggw_team_application_PrincipalObjectAttributeAccesses"), Optional.empty());
    }

}
