package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.Ggw_crew;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.BulkdeletefailureRequest;
import microsoft.dynamics.crm.entity.request.DuplicaterecordRequest;
import microsoft.dynamics.crm.entity.request.Ggw_crewRequest;
import microsoft.dynamics.crm.entity.request.Ggw_teamRequest;
import microsoft.dynamics.crm.entity.request.Ggw_team_applicationRequest;
import microsoft.dynamics.crm.entity.request.MailboxtrackingfolderRequest;
import microsoft.dynamics.crm.entity.request.PrincipalobjectattributeaccessRequest;
import microsoft.dynamics.crm.entity.request.ProcesssessionRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;

public class Ggw_crewCollectionRequest extends CollectionPageEntityRequest<Ggw_crew, Ggw_crewRequest>{

    protected ContextPath contextPath;

    public Ggw_crewCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Ggw_crew.class, cp -> new Ggw_crewRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public SyncerrorRequest ggw_crew_SyncErrors(UUID syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("ggw_crew_SyncErrors").addKeys(new NameValue(syncerrorid, UUID.class)), Optional.empty());
    }

    public SyncerrorCollectionRequest ggw_crew_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("ggw_crew_SyncErrors"), Optional.empty());
    }

    public DuplicaterecordRequest ggw_crew_DuplicateMatchingRecord(UUID duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("ggw_crew_DuplicateMatchingRecord").addKeys(new NameValue(duplicateid, UUID.class)), Optional.empty());
    }

    public DuplicaterecordCollectionRequest ggw_crew_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(contextPath.addSegment("ggw_crew_DuplicateMatchingRecord"), Optional.empty());
    }

    public DuplicaterecordRequest ggw_crew_DuplicateBaseRecord(UUID duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("ggw_crew_DuplicateBaseRecord").addKeys(new NameValue(duplicateid, UUID.class)), Optional.empty());
    }

    public DuplicaterecordCollectionRequest ggw_crew_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(contextPath.addSegment("ggw_crew_DuplicateBaseRecord"), Optional.empty());
    }

    public AsyncoperationRequest ggw_crew_AsyncOperations(UUID asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("ggw_crew_AsyncOperations").addKeys(new NameValue(asyncoperationid, UUID.class)), Optional.empty());
    }

    public AsyncoperationCollectionRequest ggw_crew_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("ggw_crew_AsyncOperations"), Optional.empty());
    }

    public MailboxtrackingfolderRequest ggw_crew_MailboxTrackingFolders(UUID mailboxtrackingfolderid) {
        return new MailboxtrackingfolderRequest(contextPath.addSegment("ggw_crew_MailboxTrackingFolders").addKeys(new NameValue(mailboxtrackingfolderid, UUID.class)), Optional.empty());
    }

    public MailboxtrackingfolderCollectionRequest ggw_crew_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(contextPath.addSegment("ggw_crew_MailboxTrackingFolders"), Optional.empty());
    }

    public ProcesssessionRequest ggw_crew_ProcessSession(UUID processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("ggw_crew_ProcessSession").addKeys(new NameValue(processsessionid, UUID.class)), Optional.empty());
    }

    public ProcesssessionCollectionRequest ggw_crew_ProcessSession() {
        return new ProcesssessionCollectionRequest(contextPath.addSegment("ggw_crew_ProcessSession"), Optional.empty());
    }

    public BulkdeletefailureRequest ggw_crew_BulkDeleteFailures(UUID bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("ggw_crew_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid, UUID.class)), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest ggw_crew_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(contextPath.addSegment("ggw_crew_BulkDeleteFailures"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest ggw_crew_PrincipalObjectAttributeAccesses(UUID principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("ggw_crew_PrincipalObjectAttributeAccesses").addKeys(new NameValue(principalobjectattributeaccessid, UUID.class)), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest ggw_crew_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(contextPath.addSegment("ggw_crew_PrincipalObjectAttributeAccesses"), Optional.empty());
    }

    public Ggw_teamRequest ggw_ggw_crew_ggw_team(UUID ggw_teamid) {
        return new Ggw_teamRequest(contextPath.addSegment("ggw_ggw_crew_ggw_team").addKeys(new NameValue(ggw_teamid, UUID.class)), Optional.empty());
    }

    public Ggw_teamCollectionRequest ggw_ggw_crew_ggw_team() {
        return new Ggw_teamCollectionRequest(contextPath.addSegment("ggw_ggw_crew_ggw_team"), Optional.empty());
    }

    public Ggw_team_applicationRequest ggw_ggw_crew_ggw_team_application(UUID ggw_team_applicationid) {
        return new Ggw_team_applicationRequest(contextPath.addSegment("ggw_ggw_crew_ggw_team_application").addKeys(new NameValue(ggw_team_applicationid, UUID.class)), Optional.empty());
    }

    public Ggw_team_applicationCollectionRequest ggw_ggw_crew_ggw_team_application() {
        return new Ggw_team_applicationCollectionRequest(contextPath.addSegment("ggw_ggw_crew_ggw_team_application"), Optional.empty());
    }

}
