package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.Flowsession;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.BulkdeletefailureRequest;
import microsoft.dynamics.crm.entity.request.FileattachmentRequest;
import microsoft.dynamics.crm.entity.request.FlowsessionRequest;
import microsoft.dynamics.crm.entity.request.MailboxtrackingfolderRequest;
import microsoft.dynamics.crm.entity.request.PrincipalobjectattributeaccessRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;
import microsoft.dynamics.crm.entity.request.WorkflowbinaryRequest;

public class FlowsessionCollectionRequest extends CollectionPageEntityRequest<Flowsession, FlowsessionRequest>{

    protected ContextPath contextPath;

    public FlowsessionCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Flowsession.class, cp -> new FlowsessionRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public SyncerrorRequest flowsession_SyncErrors(UUID syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("flowsession_SyncErrors").addKeys(new NameValue(syncerrorid, UUID.class)), Optional.empty());
    }

    public SyncerrorCollectionRequest flowsession_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("flowsession_SyncErrors"), Optional.empty());
    }

    public AsyncoperationRequest flowsession_AsyncOperations(UUID asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("flowsession_AsyncOperations").addKeys(new NameValue(asyncoperationid, UUID.class)), Optional.empty());
    }

    public AsyncoperationCollectionRequest flowsession_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("flowsession_AsyncOperations"), Optional.empty());
    }

    public MailboxtrackingfolderRequest flowsession_MailboxTrackingFolders(UUID mailboxtrackingfolderid) {
        return new MailboxtrackingfolderRequest(contextPath.addSegment("flowsession_MailboxTrackingFolders").addKeys(new NameValue(mailboxtrackingfolderid, UUID.class)), Optional.empty());
    }

    public MailboxtrackingfolderCollectionRequest flowsession_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(contextPath.addSegment("flowsession_MailboxTrackingFolders"), Optional.empty());
    }

    public BulkdeletefailureRequest flowsession_BulkDeleteFailures(UUID bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("flowsession_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid, UUID.class)), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest flowsession_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(contextPath.addSegment("flowsession_BulkDeleteFailures"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest flowsession_PrincipalObjectAttributeAccesses(UUID principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("flowsession_PrincipalObjectAttributeAccesses").addKeys(new NameValue(principalobjectattributeaccessid, UUID.class)), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest flowsession_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(contextPath.addSegment("flowsession_PrincipalObjectAttributeAccesses"), Optional.empty());
    }

    public FileattachmentRequest flowsession_FileAttachments(UUID fileattachmentid) {
        return new FileattachmentRequest(contextPath.addSegment("flowsession_FileAttachments").addKeys(new NameValue(fileattachmentid, UUID.class)), Optional.empty());
    }

    public FileattachmentCollectionRequest flowsession_FileAttachments() {
        return new FileattachmentCollectionRequest(contextPath.addSegment("flowsession_FileAttachments"), Optional.empty());
    }

    public WorkflowbinaryRequest flowsession_workflowbinary_FlowSessionId(UUID workflowbinaryid) {
        return new WorkflowbinaryRequest(contextPath.addSegment("flowsession_workflowbinary_FlowSessionId").addKeys(new NameValue(workflowbinaryid, UUID.class)), Optional.empty());
    }

    public WorkflowbinaryCollectionRequest flowsession_workflowbinary_FlowSessionId() {
        return new WorkflowbinaryCollectionRequest(contextPath.addSegment("flowsession_workflowbinary_FlowSessionId"), Optional.empty());
    }

}
