package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.Fieldsecurityprofile;
import microsoft.dynamics.crm.entity.request.FieldpermissionRequest;
import microsoft.dynamics.crm.entity.request.FieldsecurityprofileRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.TeamRequest;

public class FieldsecurityprofileCollectionRequest extends CollectionPageEntityRequest<Fieldsecurityprofile, FieldsecurityprofileRequest>{

    protected ContextPath contextPath;

    public FieldsecurityprofileCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Fieldsecurityprofile.class, cp -> new FieldsecurityprofileRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public SyncerrorRequest fieldSecurityProfile_SyncErrors(UUID syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("FieldSecurityProfile_SyncErrors").addKeys(new NameValue(syncerrorid, UUID.class)), Optional.empty());
    }

    public SyncerrorCollectionRequest fieldSecurityProfile_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("FieldSecurityProfile_SyncErrors"), Optional.empty());
    }

    public SystemuserRequest systemuserprofiles_association(UUID ownerid) {
        return new SystemuserRequest(contextPath.addSegment("systemuserprofiles_association").addKeys(new NameValue(ownerid, UUID.class)), Optional.empty());
    }

    public SystemuserCollectionRequest systemuserprofiles_association() {
        return new SystemuserCollectionRequest(contextPath.addSegment("systemuserprofiles_association"), Optional.empty());
    }

    public FieldpermissionRequest lk_fieldpermission_fieldsecurityprofileid(UUID fieldpermissionid) {
        return new FieldpermissionRequest(contextPath.addSegment("lk_fieldpermission_fieldsecurityprofileid").addKeys(new NameValue(fieldpermissionid, UUID.class)), Optional.empty());
    }

    public FieldpermissionCollectionRequest lk_fieldpermission_fieldsecurityprofileid() {
        return new FieldpermissionCollectionRequest(contextPath.addSegment("lk_fieldpermission_fieldsecurityprofileid"), Optional.empty());
    }

    public TeamRequest teamprofiles_association(UUID ownerid) {
        return new TeamRequest(contextPath.addSegment("teamprofiles_association").addKeys(new NameValue(ownerid, UUID.class)), Optional.empty());
    }

    public TeamCollectionRequest teamprofiles_association() {
        return new TeamCollectionRequest(contextPath.addSegment("teamprofiles_association"), Optional.empty());
    }

}
