package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.Fieldpermission;
import microsoft.dynamics.crm.entity.request.FieldpermissionRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;

public class FieldpermissionCollectionRequest extends CollectionPageEntityRequest<Fieldpermission, FieldpermissionRequest>{

    protected ContextPath contextPath;

    public FieldpermissionCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Fieldpermission.class, cp -> new FieldpermissionRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public SyncerrorRequest fieldPermission_SyncErrors(UUID syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("FieldPermission_SyncErrors").addKeys(new NameValue(syncerrorid, UUID.class)), Optional.empty());
    }

    public SyncerrorCollectionRequest fieldPermission_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("FieldPermission_SyncErrors"), Optional.empty());
    }

}
