package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.Feedback;
import microsoft.dynamics.crm.entity.request.DuplicaterecordRequest;
import microsoft.dynamics.crm.entity.request.FeedbackRequest;
import microsoft.dynamics.crm.entity.request.PrincipalobjectattributeaccessRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;

public class FeedbackCollectionRequest extends CollectionPageEntityRequest<Feedback, FeedbackRequest>{

    protected ContextPath contextPath;

    public FeedbackCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Feedback.class, cp -> new FeedbackRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public PrincipalobjectattributeaccessRequest feedback_principalobjectattributeaccess(UUID principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("feedback_principalobjectattributeaccess").addKeys(new NameValue(principalobjectattributeaccessid, UUID.class)), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest feedback_principalobjectattributeaccess() {
        return new PrincipalobjectattributeaccessCollectionRequest(contextPath.addSegment("feedback_principalobjectattributeaccess"), Optional.empty());
    }

    public FeedbackRequest feedback_feedback(UUID feedbackid) {
        return new FeedbackRequest(contextPath.addSegment("feedback_feedback").addKeys(new NameValue(feedbackid, UUID.class)), Optional.empty());
    }

    public FeedbackCollectionRequest feedback_feedback() {
        return new FeedbackCollectionRequest(contextPath.addSegment("feedback_feedback"), Optional.empty());
    }

    public SyncerrorRequest feedback_SyncErrors(UUID syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("Feedback_SyncErrors").addKeys(new NameValue(syncerrorid, UUID.class)), Optional.empty());
    }

    public SyncerrorCollectionRequest feedback_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("Feedback_SyncErrors"), Optional.empty());
    }

    public DuplicaterecordRequest feedback_DuplicateBaseRecord(UUID duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("feedback_DuplicateBaseRecord").addKeys(new NameValue(duplicateid, UUID.class)), Optional.empty());
    }

    public DuplicaterecordCollectionRequest feedback_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(contextPath.addSegment("feedback_DuplicateBaseRecord"), Optional.empty());
    }

    public DuplicaterecordRequest feedback_DuplicateMatchingRecord(UUID duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("feedback_DuplicateMatchingRecord").addKeys(new NameValue(duplicateid, UUID.class)), Optional.empty());
    }

    public DuplicaterecordCollectionRequest feedback_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(contextPath.addSegment("feedback_DuplicateMatchingRecord"), Optional.empty());
    }

}
