package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.Environmentvariabledefinition;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.BulkdeletefailureRequest;
import microsoft.dynamics.crm.entity.request.DuplicaterecordRequest;
import microsoft.dynamics.crm.entity.request.EnvironmentvariabledefinitionRequest;
import microsoft.dynamics.crm.entity.request.EnvironmentvariablevalueRequest;
import microsoft.dynamics.crm.entity.request.MailboxtrackingfolderRequest;
import microsoft.dynamics.crm.entity.request.PrincipalobjectattributeaccessRequest;
import microsoft.dynamics.crm.entity.request.ProcesssessionRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;

public class EnvironmentvariabledefinitionCollectionRequest extends CollectionPageEntityRequest<Environmentvariabledefinition, EnvironmentvariabledefinitionRequest>{

    protected ContextPath contextPath;

    public EnvironmentvariabledefinitionCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Environmentvariabledefinition.class, cp -> new EnvironmentvariabledefinitionRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public SyncerrorRequest environmentvariabledefinition_SyncErrors(UUID syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("environmentvariabledefinition_SyncErrors").addKeys(new NameValue(syncerrorid, UUID.class)), Optional.empty());
    }

    public SyncerrorCollectionRequest environmentvariabledefinition_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("environmentvariabledefinition_SyncErrors"), Optional.empty());
    }

    public DuplicaterecordRequest environmentvariabledefinition_DuplicateMatchingRecord(UUID duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("environmentvariabledefinition_DuplicateMatchingRecord").addKeys(new NameValue(duplicateid, UUID.class)), Optional.empty());
    }

    public DuplicaterecordCollectionRequest environmentvariabledefinition_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(contextPath.addSegment("environmentvariabledefinition_DuplicateMatchingRecord"), Optional.empty());
    }

    public DuplicaterecordRequest environmentvariabledefinition_DuplicateBaseRecord(UUID duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("environmentvariabledefinition_DuplicateBaseRecord").addKeys(new NameValue(duplicateid, UUID.class)), Optional.empty());
    }

    public DuplicaterecordCollectionRequest environmentvariabledefinition_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(contextPath.addSegment("environmentvariabledefinition_DuplicateBaseRecord"), Optional.empty());
    }

    public AsyncoperationRequest environmentvariabledefinition_AsyncOperations(UUID asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("environmentvariabledefinition_AsyncOperations").addKeys(new NameValue(asyncoperationid, UUID.class)), Optional.empty());
    }

    public AsyncoperationCollectionRequest environmentvariabledefinition_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("environmentvariabledefinition_AsyncOperations"), Optional.empty());
    }

    public MailboxtrackingfolderRequest environmentvariabledefinition_MailboxTrackingFolders(UUID mailboxtrackingfolderid) {
        return new MailboxtrackingfolderRequest(contextPath.addSegment("environmentvariabledefinition_MailboxTrackingFolders").addKeys(new NameValue(mailboxtrackingfolderid, UUID.class)), Optional.empty());
    }

    public MailboxtrackingfolderCollectionRequest environmentvariabledefinition_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(contextPath.addSegment("environmentvariabledefinition_MailboxTrackingFolders"), Optional.empty());
    }

    public ProcesssessionRequest environmentvariabledefinition_ProcessSession(UUID processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("environmentvariabledefinition_ProcessSession").addKeys(new NameValue(processsessionid, UUID.class)), Optional.empty());
    }

    public ProcesssessionCollectionRequest environmentvariabledefinition_ProcessSession() {
        return new ProcesssessionCollectionRequest(contextPath.addSegment("environmentvariabledefinition_ProcessSession"), Optional.empty());
    }

    public BulkdeletefailureRequest environmentvariabledefinition_BulkDeleteFailures(UUID bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("environmentvariabledefinition_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid, UUID.class)), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest environmentvariabledefinition_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(contextPath.addSegment("environmentvariabledefinition_BulkDeleteFailures"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest environmentvariabledefinition_PrincipalObjectAttributeAccesses(UUID principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("environmentvariabledefinition_PrincipalObjectAttributeAccesses").addKeys(new NameValue(principalobjectattributeaccessid, UUID.class)), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest environmentvariabledefinition_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(contextPath.addSegment("environmentvariabledefinition_PrincipalObjectAttributeAccesses"), Optional.empty());
    }

    public EnvironmentvariablevalueRequest environmentvariabledefinition_environmentvariablevalue(UUID environmentvariablevalueid) {
        return new EnvironmentvariablevalueRequest(contextPath.addSegment("environmentvariabledefinition_environmentvariablevalue").addKeys(new NameValue(environmentvariablevalueid, UUID.class)), Optional.empty());
    }

    public EnvironmentvariablevalueCollectionRequest environmentvariabledefinition_environmentvariablevalue() {
        return new EnvironmentvariablevalueCollectionRequest(contextPath.addSegment("environmentvariabledefinition_environmentvariablevalue"), Optional.empty());
    }

}
