package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.Displaystring;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.BulkdeletefailureRequest;
import microsoft.dynamics.crm.entity.request.DisplaystringRequest;

public class DisplaystringCollectionRequest extends CollectionPageEntityRequest<Displaystring, DisplaystringRequest>{

    protected ContextPath contextPath;

    public DisplaystringCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Displaystring.class, cp -> new DisplaystringRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public AsyncoperationRequest displayString_AsyncOperations(UUID asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("DisplayString_AsyncOperations").addKeys(new NameValue(asyncoperationid, UUID.class)), Optional.empty());
    }

    public AsyncoperationCollectionRequest displayString_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("DisplayString_AsyncOperations"), Optional.empty());
    }

    public BulkdeletefailureRequest displayString_BulkDeleteFailures(UUID bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("DisplayString_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid, UUID.class)), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest displayString_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(contextPath.addSegment("DisplayString_BulkDeleteFailures"), Optional.empty());
    }

}
