package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.Customeraddress;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.BulkdeletefailureRequest;
import microsoft.dynamics.crm.entity.request.CustomeraddressRequest;
import microsoft.dynamics.crm.entity.request.PrincipalobjectattributeaccessRequest;
import microsoft.dynamics.crm.entity.request.ProcesssessionRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;

public class CustomeraddressCollectionRequest extends CollectionPageEntityRequest<Customeraddress, CustomeraddressRequest>{

    protected ContextPath contextPath;

    public CustomeraddressCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Customeraddress.class, cp -> new CustomeraddressRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public BulkdeletefailureRequest customerAddress_BulkDeleteFailures(UUID bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("CustomerAddress_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid, UUID.class)), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest customerAddress_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(contextPath.addSegment("CustomerAddress_BulkDeleteFailures"), Optional.empty());
    }

    public ProcesssessionRequest customerAddress_ProcessSessions(UUID processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("CustomerAddress_ProcessSessions").addKeys(new NameValue(processsessionid, UUID.class)), Optional.empty());
    }

    public ProcesssessionCollectionRequest customerAddress_ProcessSessions() {
        return new ProcesssessionCollectionRequest(contextPath.addSegment("CustomerAddress_ProcessSessions"), Optional.empty());
    }

    public SyncerrorRequest customerAddress_SyncErrors(UUID syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("CustomerAddress_SyncErrors").addKeys(new NameValue(syncerrorid, UUID.class)), Optional.empty());
    }

    public SyncerrorCollectionRequest customerAddress_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("CustomerAddress_SyncErrors"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest customeraddress_principalobjectattributeaccess(UUID principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("customeraddress_principalobjectattributeaccess").addKeys(new NameValue(principalobjectattributeaccessid, UUID.class)), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest customeraddress_principalobjectattributeaccess() {
        return new PrincipalobjectattributeaccessCollectionRequest(contextPath.addSegment("customeraddress_principalobjectattributeaccess"), Optional.empty());
    }

    public AsyncoperationRequest customerAddress_AsyncOperations(UUID asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("CustomerAddress_AsyncOperations").addKeys(new NameValue(asyncoperationid, UUID.class)), Optional.empty());
    }

    public AsyncoperationCollectionRequest customerAddress_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("CustomerAddress_AsyncOperations"), Optional.empty());
    }

}
