package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.Connectionreference;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.BulkdeletefailureRequest;
import microsoft.dynamics.crm.entity.request.ConnectionreferenceRequest;
import microsoft.dynamics.crm.entity.request.MailboxtrackingfolderRequest;
import microsoft.dynamics.crm.entity.request.PrincipalobjectattributeaccessRequest;
import microsoft.dynamics.crm.entity.request.ProcesssessionRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;

public class ConnectionreferenceCollectionRequest extends CollectionPageEntityRequest<Connectionreference, ConnectionreferenceRequest>{

    protected ContextPath contextPath;

    public ConnectionreferenceCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Connectionreference.class, cp -> new ConnectionreferenceRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public SyncerrorRequest connectionreference_SyncErrors(UUID syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("connectionreference_SyncErrors").addKeys(new NameValue(syncerrorid, UUID.class)), Optional.empty());
    }

    public SyncerrorCollectionRequest connectionreference_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("connectionreference_SyncErrors"), Optional.empty());
    }

    public AsyncoperationRequest connectionreference_AsyncOperations(UUID asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("connectionreference_AsyncOperations").addKeys(new NameValue(asyncoperationid, UUID.class)), Optional.empty());
    }

    public AsyncoperationCollectionRequest connectionreference_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("connectionreference_AsyncOperations"), Optional.empty());
    }

    public MailboxtrackingfolderRequest connectionreference_MailboxTrackingFolders(UUID mailboxtrackingfolderid) {
        return new MailboxtrackingfolderRequest(contextPath.addSegment("connectionreference_MailboxTrackingFolders").addKeys(new NameValue(mailboxtrackingfolderid, UUID.class)), Optional.empty());
    }

    public MailboxtrackingfolderCollectionRequest connectionreference_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(contextPath.addSegment("connectionreference_MailboxTrackingFolders"), Optional.empty());
    }

    public ProcesssessionRequest connectionreference_ProcessSession(UUID processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("connectionreference_ProcessSession").addKeys(new NameValue(processsessionid, UUID.class)), Optional.empty());
    }

    public ProcesssessionCollectionRequest connectionreference_ProcessSession() {
        return new ProcesssessionCollectionRequest(contextPath.addSegment("connectionreference_ProcessSession"), Optional.empty());
    }

    public BulkdeletefailureRequest connectionreference_BulkDeleteFailures(UUID bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("connectionreference_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid, UUID.class)), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest connectionreference_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(contextPath.addSegment("connectionreference_BulkDeleteFailures"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest connectionreference_PrincipalObjectAttributeAccesses(UUID principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("connectionreference_PrincipalObjectAttributeAccesses").addKeys(new NameValue(principalobjectattributeaccessid, UUID.class)), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest connectionreference_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(contextPath.addSegment("connectionreference_PrincipalObjectAttributeAccesses"), Optional.empty());
    }

}
