package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.Cascadegrantrevokeaccessversiontracker;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.BulkdeletefailureRequest;
import microsoft.dynamics.crm.entity.request.CascadegrantrevokeaccessrecordstrackerRequest;
import microsoft.dynamics.crm.entity.request.CascadegrantrevokeaccessversiontrackerRequest;
import microsoft.dynamics.crm.entity.request.DuplicaterecordRequest;
import microsoft.dynamics.crm.entity.request.MailboxtrackingfolderRequest;
import microsoft.dynamics.crm.entity.request.PrincipalobjectattributeaccessRequest;
import microsoft.dynamics.crm.entity.request.ProcesssessionRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;

public class CascadegrantrevokeaccessversiontrackerCollectionRequest extends CollectionPageEntityRequest<Cascadegrantrevokeaccessversiontracker, CascadegrantrevokeaccessversiontrackerRequest>{

    protected ContextPath contextPath;

    public CascadegrantrevokeaccessversiontrackerCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Cascadegrantrevokeaccessversiontracker.class, cp -> new CascadegrantrevokeaccessversiontrackerRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public SyncerrorRequest cascadegrantrevokeaccessversiontracker_SyncErrors(UUID syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("cascadegrantrevokeaccessversiontracker_SyncErrors").addKeys(new NameValue(syncerrorid, UUID.class)), Optional.empty());
    }

    public SyncerrorCollectionRequest cascadegrantrevokeaccessversiontracker_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("cascadegrantrevokeaccessversiontracker_SyncErrors"), Optional.empty());
    }

    public DuplicaterecordRequest cascadegrantrevokeaccessversiontracker_DuplicateMatchingRecord(UUID duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("cascadegrantrevokeaccessversiontracker_DuplicateMatchingRecord").addKeys(new NameValue(duplicateid, UUID.class)), Optional.empty());
    }

    public DuplicaterecordCollectionRequest cascadegrantrevokeaccessversiontracker_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(contextPath.addSegment("cascadegrantrevokeaccessversiontracker_DuplicateMatchingRecord"), Optional.empty());
    }

    public DuplicaterecordRequest cascadegrantrevokeaccessversiontracker_DuplicateBaseRecord(UUID duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("cascadegrantrevokeaccessversiontracker_DuplicateBaseRecord").addKeys(new NameValue(duplicateid, UUID.class)), Optional.empty());
    }

    public DuplicaterecordCollectionRequest cascadegrantrevokeaccessversiontracker_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(contextPath.addSegment("cascadegrantrevokeaccessversiontracker_DuplicateBaseRecord"), Optional.empty());
    }

    public AsyncoperationRequest cascadegrantrevokeaccessversiontracker_AsyncOperations(UUID asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("cascadegrantrevokeaccessversiontracker_AsyncOperations").addKeys(new NameValue(asyncoperationid, UUID.class)), Optional.empty());
    }

    public AsyncoperationCollectionRequest cascadegrantrevokeaccessversiontracker_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("cascadegrantrevokeaccessversiontracker_AsyncOperations"), Optional.empty());
    }

    public MailboxtrackingfolderRequest cascadegrantrevokeaccessversiontracker_MailboxTrackingFolders(UUID mailboxtrackingfolderid) {
        return new MailboxtrackingfolderRequest(contextPath.addSegment("cascadegrantrevokeaccessversiontracker_MailboxTrackingFolders").addKeys(new NameValue(mailboxtrackingfolderid, UUID.class)), Optional.empty());
    }

    public MailboxtrackingfolderCollectionRequest cascadegrantrevokeaccessversiontracker_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(contextPath.addSegment("cascadegrantrevokeaccessversiontracker_MailboxTrackingFolders"), Optional.empty());
    }

    public ProcesssessionRequest cascadegrantrevokeaccessversiontracker_ProcessSession(UUID processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("cascadegrantrevokeaccessversiontracker_ProcessSession").addKeys(new NameValue(processsessionid, UUID.class)), Optional.empty());
    }

    public ProcesssessionCollectionRequest cascadegrantrevokeaccessversiontracker_ProcessSession() {
        return new ProcesssessionCollectionRequest(contextPath.addSegment("cascadegrantrevokeaccessversiontracker_ProcessSession"), Optional.empty());
    }

    public BulkdeletefailureRequest cascadegrantrevokeaccessversiontracker_BulkDeleteFailures(UUID bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("cascadegrantrevokeaccessversiontracker_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid, UUID.class)), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest cascadegrantrevokeaccessversiontracker_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(contextPath.addSegment("cascadegrantrevokeaccessversiontracker_BulkDeleteFailures"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest cascadegrantrevokeaccessversiontracker_PrincipalObjectAttributeAccesses(UUID principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("cascadegrantrevokeaccessversiontracker_PrincipalObjectAttributeAccesses").addKeys(new NameValue(principalobjectattributeaccessid, UUID.class)), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest cascadegrantrevokeaccessversiontracker_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(contextPath.addSegment("cascadegrantrevokeaccessversiontracker_PrincipalObjectAttributeAccesses"), Optional.empty());
    }

    public CascadegrantrevokeaccessrecordstrackerRequest syncTrackerIdLookup(UUID cascadegrantrevokeaccessrecordstrackerid) {
        return new CascadegrantrevokeaccessrecordstrackerRequest(contextPath.addSegment("SyncTrackerIdLookup").addKeys(new NameValue(cascadegrantrevokeaccessrecordstrackerid, UUID.class)), Optional.empty());
    }

    public CascadegrantrevokeaccessrecordstrackerCollectionRequest syncTrackerIdLookup() {
        return new CascadegrantrevokeaccessrecordstrackerCollectionRequest(contextPath.addSegment("SyncTrackerIdLookup"), Optional.empty());
    }

}
