package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.Annotation;
import microsoft.dynamics.crm.entity.request.AnnotationRequest;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.BulkdeletefailureRequest;
import microsoft.dynamics.crm.entity.request.ProcesssessionRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;

public class AnnotationCollectionRequest extends CollectionPageEntityRequest<Annotation, AnnotationRequest>{

    protected ContextPath contextPath;

    public AnnotationCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Annotation.class, cp -> new AnnotationRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public BulkdeletefailureRequest annotation_BulkDeleteFailures(UUID bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("Annotation_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid, UUID.class)), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest annotation_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(contextPath.addSegment("Annotation_BulkDeleteFailures"), Optional.empty());
    }

    public AsyncoperationRequest annotation_AsyncOperations(UUID asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("Annotation_AsyncOperations").addKeys(new NameValue(asyncoperationid, UUID.class)), Optional.empty());
    }

    public AsyncoperationCollectionRequest annotation_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("Annotation_AsyncOperations"), Optional.empty());
    }

    public ProcesssessionRequest annotation_ProcessSessions(UUID processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("Annotation_ProcessSessions").addKeys(new NameValue(processsessionid, UUID.class)), Optional.empty());
    }

    public ProcesssessionCollectionRequest annotation_ProcessSessions() {
        return new ProcesssessionCollectionRequest(contextPath.addSegment("Annotation_ProcessSessions"), Optional.empty());
    }

    public SyncerrorRequest annotation_SyncErrors(UUID syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("Annotation_SyncErrors").addKeys(new NameValue(syncerrorid, UUID.class)), Optional.empty());
    }

    public SyncerrorCollectionRequest annotation_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("Annotation_SyncErrors"), Optional.empty());
    }

}
