package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.Actioncard;
import microsoft.dynamics.crm.entity.request.ActioncardRequest;
import microsoft.dynamics.crm.entity.request.ActioncarduserstateRequest;

public class ActioncardCollectionRequest extends CollectionPageEntityRequest<Actioncard, ActioncardRequest>{

    protected ContextPath contextPath;

    public ActioncardCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Actioncard.class, cp -> new ActioncardRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public ActioncarduserstateRequest actionCardUserState_ActionCard(UUID actioncarduserstateid) {
        return new ActioncarduserstateRequest(contextPath.addSegment("ActionCardUserState_ActionCard").addKeys(new NameValue(actioncarduserstateid, UUID.class)), Optional.empty());
    }

    public ActioncarduserstateCollectionRequest actionCardUserState_ActionCard() {
        return new ActioncarduserstateCollectionRequest(contextPath.addSegment("ActionCardUserState_ActionCard"), Optional.empty());
    }

}
