package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;
import java.util.UUID;

@JsonPropertyOrder({
    "@odata.type", 
    "teamsyncattributemappingprofileid", 
    "syncattributemappingprofileid", 
    "versionnumber", 
    "teamid"})
@JsonInclude(Include.NON_NULL)
public class Teamsyncattributemappingprofiles extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.teamsyncattributemappingprofiles";
    }

    @JsonProperty("teamsyncattributemappingprofileid")
    protected UUID teamsyncattributemappingprofileid;

    @JsonProperty("syncattributemappingprofileid")
    protected UUID syncattributemappingprofileid;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("teamid")
    protected UUID teamid;

    protected Teamsyncattributemappingprofiles() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderTeamsyncattributemappingprofiles() {
        return new Builder();
    }

    public static final class Builder {
        private UUID teamsyncattributemappingprofileid;
        private UUID syncattributemappingprofileid;
        private Long versionnumber;
        private UUID teamid;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder teamsyncattributemappingprofileid(UUID teamsyncattributemappingprofileid) {
            this.teamsyncattributemappingprofileid = teamsyncattributemappingprofileid;
            this.changedFields = changedFields.add("teamsyncattributemappingprofileid");
            return this;
        }

        public Builder syncattributemappingprofileid(UUID syncattributemappingprofileid) {
            this.syncattributemappingprofileid = syncattributemappingprofileid;
            this.changedFields = changedFields.add("syncattributemappingprofileid");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder teamid(UUID teamid) {
            this.teamid = teamid;
            this.changedFields = changedFields.add("teamid");
            return this;
        }

        public Teamsyncattributemappingprofiles build() {
            Teamsyncattributemappingprofiles _x = new Teamsyncattributemappingprofiles();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.teamsyncattributemappingprofiles";
            _x.teamsyncattributemappingprofileid = teamsyncattributemappingprofileid;
            _x.syncattributemappingprofileid = syncattributemappingprofileid;
            _x.versionnumber = versionnumber;
            _x.teamid = teamid;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && teamsyncattributemappingprofileid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(teamsyncattributemappingprofileid, UUID.class));
        }
    }

    @Property(name="teamsyncattributemappingprofileid")
    @JsonIgnore
    public Optional<UUID> getTeamsyncattributemappingprofileid() {
        return Optional.ofNullable(teamsyncattributemappingprofileid);
    }

    public Teamsyncattributemappingprofiles withTeamsyncattributemappingprofileid(UUID teamsyncattributemappingprofileid) {
        Teamsyncattributemappingprofiles _x = _copy();
        _x.changedFields = changedFields.add("teamsyncattributemappingprofileid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.teamsyncattributemappingprofiles");
        _x.teamsyncattributemappingprofileid = teamsyncattributemappingprofileid;
        return _x;
    }

    @Property(name="syncattributemappingprofileid")
    @JsonIgnore
    public Optional<UUID> getSyncattributemappingprofileid() {
        return Optional.ofNullable(syncattributemappingprofileid);
    }

    public Teamsyncattributemappingprofiles withSyncattributemappingprofileid(UUID syncattributemappingprofileid) {
        Teamsyncattributemappingprofiles _x = _copy();
        _x.changedFields = changedFields.add("syncattributemappingprofileid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.teamsyncattributemappingprofiles");
        _x.syncattributemappingprofileid = syncattributemappingprofileid;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Teamsyncattributemappingprofiles withVersionnumber(Long versionnumber) {
        Teamsyncattributemappingprofiles _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.teamsyncattributemappingprofiles");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="teamid")
    @JsonIgnore
    public Optional<UUID> getTeamid() {
        return Optional.ofNullable(teamid);
    }

    public Teamsyncattributemappingprofiles withTeamid(UUID teamid) {
        Teamsyncattributemappingprofiles _x = _copy();
        _x.changedFields = changedFields.add("teamid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.teamsyncattributemappingprofiles");
        _x.teamid = teamid;
        return _x;
    }

    public Teamsyncattributemappingprofiles withUnmappedField(String name, String value) {
        Teamsyncattributemappingprofiles _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Teamsyncattributemappingprofiles patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Teamsyncattributemappingprofiles _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Teamsyncattributemappingprofiles put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Teamsyncattributemappingprofiles _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Teamsyncattributemappingprofiles _copy() {
        Teamsyncattributemappingprofiles _x = new Teamsyncattributemappingprofiles();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.teamsyncattributemappingprofileid = teamsyncattributemappingprofileid;
        _x.syncattributemappingprofileid = syncattributemappingprofileid;
        _x.versionnumber = versionnumber;
        _x.teamid = teamid;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Teamsyncattributemappingprofiles[");
        b.append("teamsyncattributemappingprofileid=");
        b.append(this.teamsyncattributemappingprofileid);
        b.append(", ");
        b.append("syncattributemappingprofileid=");
        b.append(this.syncattributemappingprofileid);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("teamid=");
        b.append(this.teamid);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
