package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;
import java.util.UUID;

@JsonPropertyOrder({
    "@odata.type", 
    "queueid", 
    "queuemembershipid", 
    "versionnumber", 
    "systemuserid"})
@JsonInclude(Include.NON_NULL)
public class Queuemembership extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.queuemembership";
    }

    @JsonProperty("queueid")
    protected UUID queueid;

    @JsonProperty("queuemembershipid")
    protected UUID queuemembershipid;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("systemuserid")
    protected UUID systemuserid;

    protected Queuemembership() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderQueuemembership() {
        return new Builder();
    }

    public static final class Builder {
        private UUID queueid;
        private UUID queuemembershipid;
        private Long versionnumber;
        private UUID systemuserid;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder queueid(UUID queueid) {
            this.queueid = queueid;
            this.changedFields = changedFields.add("queueid");
            return this;
        }

        public Builder queuemembershipid(UUID queuemembershipid) {
            this.queuemembershipid = queuemembershipid;
            this.changedFields = changedFields.add("queuemembershipid");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder systemuserid(UUID systemuserid) {
            this.systemuserid = systemuserid;
            this.changedFields = changedFields.add("systemuserid");
            return this;
        }

        public Queuemembership build() {
            Queuemembership _x = new Queuemembership();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.queuemembership";
            _x.queueid = queueid;
            _x.queuemembershipid = queuemembershipid;
            _x.versionnumber = versionnumber;
            _x.systemuserid = systemuserid;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && queuemembershipid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(queuemembershipid, UUID.class));
        }
    }

    @Property(name="queueid")
    @JsonIgnore
    public Optional<UUID> getQueueid() {
        return Optional.ofNullable(queueid);
    }

    public Queuemembership withQueueid(UUID queueid) {
        Queuemembership _x = _copy();
        _x.changedFields = changedFields.add("queueid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.queuemembership");
        _x.queueid = queueid;
        return _x;
    }

    @Property(name="queuemembershipid")
    @JsonIgnore
    public Optional<UUID> getQueuemembershipid() {
        return Optional.ofNullable(queuemembershipid);
    }

    public Queuemembership withQueuemembershipid(UUID queuemembershipid) {
        Queuemembership _x = _copy();
        _x.changedFields = changedFields.add("queuemembershipid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.queuemembership");
        _x.queuemembershipid = queuemembershipid;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Queuemembership withVersionnumber(Long versionnumber) {
        Queuemembership _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.queuemembership");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="systemuserid")
    @JsonIgnore
    public Optional<UUID> getSystemuserid() {
        return Optional.ofNullable(systemuserid);
    }

    public Queuemembership withSystemuserid(UUID systemuserid) {
        Queuemembership _x = _copy();
        _x.changedFields = changedFields.add("systemuserid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.queuemembership");
        _x.systemuserid = systemuserid;
        return _x;
    }

    public Queuemembership withUnmappedField(String name, String value) {
        Queuemembership _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Queuemembership patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Queuemembership _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Queuemembership put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Queuemembership _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Queuemembership _copy() {
        Queuemembership _x = new Queuemembership();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.queueid = queueid;
        _x.queuemembershipid = queuemembershipid;
        _x.versionnumber = versionnumber;
        _x.systemuserid = systemuserid;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Queuemembership[");
        b.append("queueid=");
        b.append(this.queueid);
        b.append(", ");
        b.append("queuemembershipid=");
        b.append(this.queuemembershipid);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("systemuserid=");
        b.append(this.systemuserid);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
