package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.collection.request.AccountCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.AppointmentCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ContactCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.EmailCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ExpiredprocessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.FaxCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.KnowledgearticleCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.LetterCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.NewprocessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PhonecallCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcessstageparameterCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.RecurringappointmentmasterCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SystemuserCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.TaskCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.TeamCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.TranslationprocessCollectionRequest;
import microsoft.dynamics.crm.entity.request.WorkflowRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "operationkind", 
    "operationtype", 
    "clientdata", 
    "istrigger", 
    "primaryentitytypecode", 
    "owningbusinessunit", 
    "_processid_value", 
    "stagename", 
    "connector", 
    "stagecategory", 
    "_ownerid_value", 
    "versionnumber", 
    "processstageid", 
    "operationid"})
@JsonInclude(Include.NON_NULL)
public class Processstage extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.processstage";
    }

    @JsonProperty("operationkind")
    protected Integer operationkind;

    @JsonProperty("operationtype")
    protected Integer operationtype;

    @JsonProperty("clientdata")
    protected String clientdata;

    @JsonProperty("istrigger")
    protected Boolean istrigger;

    @JsonProperty("primaryentitytypecode")
    protected String primaryentitytypecode;

    @JsonProperty("owningbusinessunit")
    protected UUID owningbusinessunit;

    @JsonProperty("_processid_value")
    protected UUID _processid_value;

    @JsonProperty("stagename")
    protected String stagename;

    @JsonProperty("connector")
    protected String connector;

    @JsonProperty("stagecategory")
    protected Integer stagecategory;

    @JsonProperty("_ownerid_value")
    protected UUID _ownerid_value;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("processstageid")
    protected UUID processstageid;

    @JsonProperty("operationid")
    protected String operationid;

    protected Processstage() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderProcessstage() {
        return new Builder();
    }

    public static final class Builder {
        private Integer operationkind;
        private Integer operationtype;
        private String clientdata;
        private Boolean istrigger;
        private String primaryentitytypecode;
        private UUID owningbusinessunit;
        private UUID _processid_value;
        private String stagename;
        private String connector;
        private Integer stagecategory;
        private UUID _ownerid_value;
        private Long versionnumber;
        private UUID processstageid;
        private String operationid;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder operationkind(Integer operationkind) {
            this.operationkind = operationkind;
            this.changedFields = changedFields.add("operationkind");
            return this;
        }

        public Builder operationtype(Integer operationtype) {
            this.operationtype = operationtype;
            this.changedFields = changedFields.add("operationtype");
            return this;
        }

        public Builder clientdata(String clientdata) {
            this.clientdata = clientdata;
            this.changedFields = changedFields.add("clientdata");
            return this;
        }

        public Builder istrigger(Boolean istrigger) {
            this.istrigger = istrigger;
            this.changedFields = changedFields.add("istrigger");
            return this;
        }

        public Builder primaryentitytypecode(String primaryentitytypecode) {
            this.primaryentitytypecode = primaryentitytypecode;
            this.changedFields = changedFields.add("primaryentitytypecode");
            return this;
        }

        public Builder owningbusinessunit(UUID owningbusinessunit) {
            this.owningbusinessunit = owningbusinessunit;
            this.changedFields = changedFields.add("owningbusinessunit");
            return this;
        }

        public Builder _processid_value(UUID _processid_value) {
            this._processid_value = _processid_value;
            this.changedFields = changedFields.add("_processid_value");
            return this;
        }

        public Builder stagename(String stagename) {
            this.stagename = stagename;
            this.changedFields = changedFields.add("stagename");
            return this;
        }

        public Builder connector(String connector) {
            this.connector = connector;
            this.changedFields = changedFields.add("connector");
            return this;
        }

        public Builder stagecategory(Integer stagecategory) {
            this.stagecategory = stagecategory;
            this.changedFields = changedFields.add("stagecategory");
            return this;
        }

        public Builder _ownerid_value(UUID _ownerid_value) {
            this._ownerid_value = _ownerid_value;
            this.changedFields = changedFields.add("_ownerid_value");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder processstageid(UUID processstageid) {
            this.processstageid = processstageid;
            this.changedFields = changedFields.add("processstageid");
            return this;
        }

        public Builder operationid(String operationid) {
            this.operationid = operationid;
            this.changedFields = changedFields.add("operationid");
            return this;
        }

        public Processstage build() {
            Processstage _x = new Processstage();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.processstage";
            _x.operationkind = operationkind;
            _x.operationtype = operationtype;
            _x.clientdata = clientdata;
            _x.istrigger = istrigger;
            _x.primaryentitytypecode = primaryentitytypecode;
            _x.owningbusinessunit = owningbusinessunit;
            _x._processid_value = _processid_value;
            _x.stagename = stagename;
            _x.connector = connector;
            _x.stagecategory = stagecategory;
            _x._ownerid_value = _ownerid_value;
            _x.versionnumber = versionnumber;
            _x.processstageid = processstageid;
            _x.operationid = operationid;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && processstageid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(processstageid, UUID.class));
        }
    }

    @Property(name="operationkind")
    @JsonIgnore
    public Optional<Integer> getOperationkind() {
        return Optional.ofNullable(operationkind);
    }

    public Processstage withOperationkind(Integer operationkind) {
        Processstage _x = _copy();
        _x.changedFields = changedFields.add("operationkind");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.processstage");
        _x.operationkind = operationkind;
        return _x;
    }

    @Property(name="operationtype")
    @JsonIgnore
    public Optional<Integer> getOperationtype() {
        return Optional.ofNullable(operationtype);
    }

    public Processstage withOperationtype(Integer operationtype) {
        Processstage _x = _copy();
        _x.changedFields = changedFields.add("operationtype");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.processstage");
        _x.operationtype = operationtype;
        return _x;
    }

    @Property(name="clientdata")
    @JsonIgnore
    public Optional<String> getClientdata() {
        return Optional.ofNullable(clientdata);
    }

    public Processstage withClientdata(String clientdata) {
        Checks.checkIsAscii(clientdata);
        Processstage _x = _copy();
        _x.changedFields = changedFields.add("clientdata");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.processstage");
        _x.clientdata = clientdata;
        return _x;
    }

    @Property(name="istrigger")
    @JsonIgnore
    public Optional<Boolean> getIstrigger() {
        return Optional.ofNullable(istrigger);
    }

    public Processstage withIstrigger(Boolean istrigger) {
        Processstage _x = _copy();
        _x.changedFields = changedFields.add("istrigger");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.processstage");
        _x.istrigger = istrigger;
        return _x;
    }

    @Property(name="primaryentitytypecode")
    @JsonIgnore
    public Optional<String> getPrimaryentitytypecode() {
        return Optional.ofNullable(primaryentitytypecode);
    }

    public Processstage withPrimaryentitytypecode(String primaryentitytypecode) {
        Checks.checkIsAscii(primaryentitytypecode);
        Processstage _x = _copy();
        _x.changedFields = changedFields.add("primaryentitytypecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.processstage");
        _x.primaryentitytypecode = primaryentitytypecode;
        return _x;
    }

    @Property(name="owningbusinessunit")
    @JsonIgnore
    public Optional<UUID> getOwningbusinessunit() {
        return Optional.ofNullable(owningbusinessunit);
    }

    public Processstage withOwningbusinessunit(UUID owningbusinessunit) {
        Processstage _x = _copy();
        _x.changedFields = changedFields.add("owningbusinessunit");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.processstage");
        _x.owningbusinessunit = owningbusinessunit;
        return _x;
    }

    @Property(name="_processid_value")
    @JsonIgnore
    public Optional<UUID> get_processid_value() {
        return Optional.ofNullable(_processid_value);
    }

    public Processstage with_processid_value(UUID _processid_value) {
        Processstage _x = _copy();
        _x.changedFields = changedFields.add("_processid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.processstage");
        _x._processid_value = _processid_value;
        return _x;
    }

    @Property(name="stagename")
    @JsonIgnore
    public Optional<String> getStagename() {
        return Optional.ofNullable(stagename);
    }

    public Processstage withStagename(String stagename) {
        Checks.checkIsAscii(stagename);
        Processstage _x = _copy();
        _x.changedFields = changedFields.add("stagename");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.processstage");
        _x.stagename = stagename;
        return _x;
    }

    @Property(name="connector")
    @JsonIgnore
    public Optional<String> getConnector() {
        return Optional.ofNullable(connector);
    }

    public Processstage withConnector(String connector) {
        Checks.checkIsAscii(connector);
        Processstage _x = _copy();
        _x.changedFields = changedFields.add("connector");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.processstage");
        _x.connector = connector;
        return _x;
    }

    @Property(name="stagecategory")
    @JsonIgnore
    public Optional<Integer> getStagecategory() {
        return Optional.ofNullable(stagecategory);
    }

    public Processstage withStagecategory(Integer stagecategory) {
        Processstage _x = _copy();
        _x.changedFields = changedFields.add("stagecategory");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.processstage");
        _x.stagecategory = stagecategory;
        return _x;
    }

    @Property(name="_ownerid_value")
    @JsonIgnore
    public Optional<UUID> get_ownerid_value() {
        return Optional.ofNullable(_ownerid_value);
    }

    public Processstage with_ownerid_value(UUID _ownerid_value) {
        Processstage _x = _copy();
        _x.changedFields = changedFields.add("_ownerid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.processstage");
        _x._ownerid_value = _ownerid_value;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Processstage withVersionnumber(Long versionnumber) {
        Processstage _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.processstage");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="processstageid")
    @JsonIgnore
    public Optional<UUID> getProcessstageid() {
        return Optional.ofNullable(processstageid);
    }

    public Processstage withProcessstageid(UUID processstageid) {
        Processstage _x = _copy();
        _x.changedFields = changedFields.add("processstageid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.processstage");
        _x.processstageid = processstageid;
        return _x;
    }

    @Property(name="operationid")
    @JsonIgnore
    public Optional<String> getOperationid() {
        return Optional.ofNullable(operationid);
    }

    public Processstage withOperationid(String operationid) {
        Checks.checkIsAscii(operationid);
        Processstage _x = _copy();
        _x.changedFields = changedFields.add("operationid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.processstage");
        _x.operationid = operationid;
        return _x;
    }

    public Processstage withUnmappedField(String name, String value) {
        Processstage _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="processstage_knowledgearticle")
    @JsonIgnore
    public KnowledgearticleCollectionRequest getProcessstage_knowledgearticle() {
        return new KnowledgearticleCollectionRequest(
                        contextPath.addSegment("processstage_knowledgearticle"), RequestHelper.getValue(unmappedFields, "processstage_knowledgearticle"));
    }

    @NavigationProperty(name="processstage_contact")
    @JsonIgnore
    public ContactCollectionRequest getProcessstage_contact() {
        return new ContactCollectionRequest(
                        contextPath.addSegment("processstage_contact"), RequestHelper.getValue(unmappedFields, "processstage_contact"));
    }

    @NavigationProperty(name="processstage_faxes")
    @JsonIgnore
    public FaxCollectionRequest getProcessstage_faxes() {
        return new FaxCollectionRequest(
                        contextPath.addSegment("processstage_faxes"), RequestHelper.getValue(unmappedFields, "processstage_faxes"));
    }

    @NavigationProperty(name="processstage_teams")
    @JsonIgnore
    public TeamCollectionRequest getProcessstage_teams() {
        return new TeamCollectionRequest(
                        contextPath.addSegment("processstage_teams"), RequestHelper.getValue(unmappedFields, "processstage_teams"));
    }

    @NavigationProperty(name="ProcessStage_SyncErrors")
    @JsonIgnore
    public SyncerrorCollectionRequest getProcessStage_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("ProcessStage_SyncErrors"), RequestHelper.getValue(unmappedFields, "ProcessStage_SyncErrors"));
    }

    @NavigationProperty(name="processstage_letters")
    @JsonIgnore
    public LetterCollectionRequest getProcessstage_letters() {
        return new LetterCollectionRequest(
                        contextPath.addSegment("processstage_letters"), RequestHelper.getValue(unmappedFields, "processstage_letters"));
    }

    @NavigationProperty(name="processstage_appointments")
    @JsonIgnore
    public AppointmentCollectionRequest getProcessstage_appointments() {
        return new AppointmentCollectionRequest(
                        contextPath.addSegment("processstage_appointments"), RequestHelper.getValue(unmappedFields, "processstage_appointments"));
    }

    @NavigationProperty(name="processstage_expiredprocess")
    @JsonIgnore
    public ExpiredprocessCollectionRequest getProcessstage_expiredprocess() {
        return new ExpiredprocessCollectionRequest(
                        contextPath.addSegment("processstage_expiredprocess"), RequestHelper.getValue(unmappedFields, "processstage_expiredprocess"));
    }

    @NavigationProperty(name="processstage_tasks")
    @JsonIgnore
    public TaskCollectionRequest getProcessstage_tasks() {
        return new TaskCollectionRequest(
                        contextPath.addSegment("processstage_tasks"), RequestHelper.getValue(unmappedFields, "processstage_tasks"));
    }

    @NavigationProperty(name="processstage_newprocess")
    @JsonIgnore
    public NewprocessCollectionRequest getProcessstage_newprocess() {
        return new NewprocessCollectionRequest(
                        contextPath.addSegment("processstage_newprocess"), RequestHelper.getValue(unmappedFields, "processstage_newprocess"));
    }

    @NavigationProperty(name="processstage_phonecalls")
    @JsonIgnore
    public PhonecallCollectionRequest getProcessstage_phonecalls() {
        return new PhonecallCollectionRequest(
                        contextPath.addSegment("processstage_phonecalls"), RequestHelper.getValue(unmappedFields, "processstage_phonecalls"));
    }

    @NavigationProperty(name="processstage_recurringappointmentmasters")
    @JsonIgnore
    public RecurringappointmentmasterCollectionRequest getProcessstage_recurringappointmentmasters() {
        return new RecurringappointmentmasterCollectionRequest(
                        contextPath.addSegment("processstage_recurringappointmentmasters"), RequestHelper.getValue(unmappedFields, "processstage_recurringappointmentmasters"));
    }

    @NavigationProperty(name="processstage_systemusers")
    @JsonIgnore
    public SystemuserCollectionRequest getProcessstage_systemusers() {
        return new SystemuserCollectionRequest(
                        contextPath.addSegment("processstage_systemusers"), RequestHelper.getValue(unmappedFields, "processstage_systemusers"));
    }

    @NavigationProperty(name="processid")
    @JsonIgnore
    public WorkflowRequest getProcessid() {
        return new WorkflowRequest(contextPath.addSegment("processid"), RequestHelper.getValue(unmappedFields, "processid"));
    }

    @NavigationProperty(name="processstage_emails")
    @JsonIgnore
    public EmailCollectionRequest getProcessstage_emails() {
        return new EmailCollectionRequest(
                        contextPath.addSegment("processstage_emails"), RequestHelper.getValue(unmappedFields, "processstage_emails"));
    }

    @NavigationProperty(name="processstage_translationprocess")
    @JsonIgnore
    public TranslationprocessCollectionRequest getProcessstage_translationprocess() {
        return new TranslationprocessCollectionRequest(
                        contextPath.addSegment("processstage_translationprocess"), RequestHelper.getValue(unmappedFields, "processstage_translationprocess"));
    }

    @NavigationProperty(name="processstage_account")
    @JsonIgnore
    public AccountCollectionRequest getProcessstage_account() {
        return new AccountCollectionRequest(
                        contextPath.addSegment("processstage_account"), RequestHelper.getValue(unmappedFields, "processstage_account"));
    }

    @NavigationProperty(name="processstage_processstageparameter")
    @JsonIgnore
    public ProcessstageparameterCollectionRequest getProcessstage_processstageparameter() {
        return new ProcessstageparameterCollectionRequest(
                        contextPath.addSegment("processstage_processstageparameter"), RequestHelper.getValue(unmappedFields, "processstage_processstageparameter"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Processstage patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Processstage _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Processstage put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Processstage _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Processstage _copy() {
        Processstage _x = new Processstage();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.operationkind = operationkind;
        _x.operationtype = operationtype;
        _x.clientdata = clientdata;
        _x.istrigger = istrigger;
        _x.primaryentitytypecode = primaryentitytypecode;
        _x.owningbusinessunit = owningbusinessunit;
        _x._processid_value = _processid_value;
        _x.stagename = stagename;
        _x.connector = connector;
        _x.stagecategory = stagecategory;
        _x._ownerid_value = _ownerid_value;
        _x.versionnumber = versionnumber;
        _x.processstageid = processstageid;
        _x.operationid = operationid;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Processstage[");
        b.append("operationkind=");
        b.append(this.operationkind);
        b.append(", ");
        b.append("operationtype=");
        b.append(this.operationtype);
        b.append(", ");
        b.append("clientdata=");
        b.append(this.clientdata);
        b.append(", ");
        b.append("istrigger=");
        b.append(this.istrigger);
        b.append(", ");
        b.append("primaryentitytypecode=");
        b.append(this.primaryentitytypecode);
        b.append(", ");
        b.append("owningbusinessunit=");
        b.append(this.owningbusinessunit);
        b.append(", ");
        b.append("_processid_value=");
        b.append(this._processid_value);
        b.append(", ");
        b.append("stagename=");
        b.append(this.stagename);
        b.append(", ");
        b.append("connector=");
        b.append(this.connector);
        b.append(", ");
        b.append("stagecategory=");
        b.append(this.stagecategory);
        b.append(", ");
        b.append("_ownerid_value=");
        b.append(this._ownerid_value);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("processstageid=");
        b.append(this.processstageid);
        b.append(", ");
        b.append("operationid=");
        b.append(this.operationid);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
