package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.request.AccountRequest;
import microsoft.dynamics.crm.entity.request.ApplicationuserRequest;
import microsoft.dynamics.crm.entity.request.AppointmentRequest;
import microsoft.dynamics.crm.entity.request.AttributeimageconfigRequest;
import microsoft.dynamics.crm.entity.request.BusinessunitRequest;
import microsoft.dynamics.crm.entity.request.CascadegrantrevokeaccessrecordstrackerRequest;
import microsoft.dynamics.crm.entity.request.CascadegrantrevokeaccessversiontrackerRequest;
import microsoft.dynamics.crm.entity.request.ConnectionRequest;
import microsoft.dynamics.crm.entity.request.ConnectionreferenceRequest;
import microsoft.dynamics.crm.entity.request.ConnectorRequest;
import microsoft.dynamics.crm.entity.request.ContactRequest;
import microsoft.dynamics.crm.entity.request.CustomeraddressRequest;
import microsoft.dynamics.crm.entity.request.DatalakeworkspaceRequest;
import microsoft.dynamics.crm.entity.request.DatalakeworkspacepermissionRequest;
import microsoft.dynamics.crm.entity.request.EmailRequest;
import microsoft.dynamics.crm.entity.request.EntityanalyticsconfigRequest;
import microsoft.dynamics.crm.entity.request.EntityimageconfigRequest;
import microsoft.dynamics.crm.entity.request.EnvironmentvariabledefinitionRequest;
import microsoft.dynamics.crm.entity.request.EnvironmentvariablevalueRequest;
import microsoft.dynamics.crm.entity.request.ExportsolutionuploadRequest;
import microsoft.dynamics.crm.entity.request.FaxRequest;
import microsoft.dynamics.crm.entity.request.FeedbackRequest;
import microsoft.dynamics.crm.entity.request.FlowsessionRequest;
import microsoft.dynamics.crm.entity.request.Ggw_crewRequest;
import microsoft.dynamics.crm.entity.request.Ggw_eventRequest;
import microsoft.dynamics.crm.entity.request.Ggw_teamRequest;
import microsoft.dynamics.crm.entity.request.Ggw_team_applicationRequest;
import microsoft.dynamics.crm.entity.request.GoalRequest;
import microsoft.dynamics.crm.entity.request.KbarticleRequest;
import microsoft.dynamics.crm.entity.request.KnowledgearticleRequest;
import microsoft.dynamics.crm.entity.request.KnowledgearticleviewsRequest;
import microsoft.dynamics.crm.entity.request.KnowledgebaserecordRequest;
import microsoft.dynamics.crm.entity.request.LetterRequest;
import microsoft.dynamics.crm.entity.request.MailmergetemplateRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aibdatasetRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aibdatasetfileRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aibdatasetrecordRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aibdatasetscontainerRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aibfileRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aibfileattacheddataRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aiconfigurationRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aifptrainingdocumentRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aimodelRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aiodimageRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aiodlabelRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aiodtrainingboundingboxRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aiodtrainingimageRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aitemplateRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_analysiscomponentRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_analysisjobRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_analysisresultRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_analysisresultdetailRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_dataflowRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_helppageRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_knowledgearticleimageRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_knowledgearticletemplateRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_richtextfileRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_serviceconfigurationRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_slakpiRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_solutionhealthruleRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_solutionhealthruleargumentRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_solutionhealthrulesetRequest;
import microsoft.dynamics.crm.entity.request.OrganizationRequest;
import microsoft.dynamics.crm.entity.request.PhonecallRequest;
import microsoft.dynamics.crm.entity.request.PositionRequest;
import microsoft.dynamics.crm.entity.request.ProcessstageparameterRequest;
import microsoft.dynamics.crm.entity.request.QueueRequest;
import microsoft.dynamics.crm.entity.request.QueueitemRequest;
import microsoft.dynamics.crm.entity.request.RecurringappointmentmasterRequest;
import microsoft.dynamics.crm.entity.request.RelationshipattributeRequest;
import microsoft.dynamics.crm.entity.request.ReportcategoryRequest;
import microsoft.dynamics.crm.entity.request.ServiceplanRequest;
import microsoft.dynamics.crm.entity.request.SharepointdocumentlocationRequest;
import microsoft.dynamics.crm.entity.request.SharepointsiteRequest;
import microsoft.dynamics.crm.entity.request.SocialactivityRequest;
import microsoft.dynamics.crm.entity.request.SocialprofileRequest;
import microsoft.dynamics.crm.entity.request.SolutioncomponentattributeconfigurationRequest;
import microsoft.dynamics.crm.entity.request.SolutioncomponentconfigurationRequest;
import microsoft.dynamics.crm.entity.request.SolutioncomponentrelationshipconfigurationRequest;
import microsoft.dynamics.crm.entity.request.StagesolutionuploadRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.TaskRequest;
import microsoft.dynamics.crm.entity.request.TeamRequest;
import microsoft.dynamics.crm.entity.request.TerritoryRequest;
import microsoft.dynamics.crm.entity.request.WorkflowbinaryRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "principalobjectattributeaccessid", 
    "_principalid_value", 
    "readaccess", 
    "attributeid", 
    "versionnumber", 
    "updateaccess", 
    "_organizationid_value", 
    "_objectid_value"})
@JsonInclude(Include.NON_NULL)
public class Principalobjectattributeaccess extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.principalobjectattributeaccess";
    }

    @JsonProperty("principalobjectattributeaccessid")
    protected UUID principalobjectattributeaccessid;

    @JsonProperty("_principalid_value")
    protected UUID _principalid_value;

    @JsonProperty("readaccess")
    protected Boolean readaccess;

    @JsonProperty("attributeid")
    protected UUID attributeid;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("updateaccess")
    protected Boolean updateaccess;

    @JsonProperty("_organizationid_value")
    protected UUID _organizationid_value;

    @JsonProperty("_objectid_value")
    protected UUID _objectid_value;

    protected Principalobjectattributeaccess() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderPrincipalobjectattributeaccess() {
        return new Builder();
    }

    public static final class Builder {
        private UUID principalobjectattributeaccessid;
        private UUID _principalid_value;
        private Boolean readaccess;
        private UUID attributeid;
        private Long versionnumber;
        private Boolean updateaccess;
        private UUID _organizationid_value;
        private UUID _objectid_value;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder principalobjectattributeaccessid(UUID principalobjectattributeaccessid) {
            this.principalobjectattributeaccessid = principalobjectattributeaccessid;
            this.changedFields = changedFields.add("principalobjectattributeaccessid");
            return this;
        }

        public Builder _principalid_value(UUID _principalid_value) {
            this._principalid_value = _principalid_value;
            this.changedFields = changedFields.add("_principalid_value");
            return this;
        }

        public Builder readaccess(Boolean readaccess) {
            this.readaccess = readaccess;
            this.changedFields = changedFields.add("readaccess");
            return this;
        }

        public Builder attributeid(UUID attributeid) {
            this.attributeid = attributeid;
            this.changedFields = changedFields.add("attributeid");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder updateaccess(Boolean updateaccess) {
            this.updateaccess = updateaccess;
            this.changedFields = changedFields.add("updateaccess");
            return this;
        }

        public Builder _organizationid_value(UUID _organizationid_value) {
            this._organizationid_value = _organizationid_value;
            this.changedFields = changedFields.add("_organizationid_value");
            return this;
        }

        public Builder _objectid_value(UUID _objectid_value) {
            this._objectid_value = _objectid_value;
            this.changedFields = changedFields.add("_objectid_value");
            return this;
        }

        public Principalobjectattributeaccess build() {
            Principalobjectattributeaccess _x = new Principalobjectattributeaccess();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.principalobjectattributeaccess";
            _x.principalobjectattributeaccessid = principalobjectattributeaccessid;
            _x._principalid_value = _principalid_value;
            _x.readaccess = readaccess;
            _x.attributeid = attributeid;
            _x.versionnumber = versionnumber;
            _x.updateaccess = updateaccess;
            _x._organizationid_value = _organizationid_value;
            _x._objectid_value = _objectid_value;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && principalobjectattributeaccessid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(principalobjectattributeaccessid, UUID.class));
        }
    }

    @Property(name="principalobjectattributeaccessid")
    @JsonIgnore
    public Optional<UUID> getPrincipalobjectattributeaccessid() {
        return Optional.ofNullable(principalobjectattributeaccessid);
    }

    public Principalobjectattributeaccess withPrincipalobjectattributeaccessid(UUID principalobjectattributeaccessid) {
        Principalobjectattributeaccess _x = _copy();
        _x.changedFields = changedFields.add("principalobjectattributeaccessid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.principalobjectattributeaccess");
        _x.principalobjectattributeaccessid = principalobjectattributeaccessid;
        return _x;
    }

    @Property(name="_principalid_value")
    @JsonIgnore
    public Optional<UUID> get_principalid_value() {
        return Optional.ofNullable(_principalid_value);
    }

    public Principalobjectattributeaccess with_principalid_value(UUID _principalid_value) {
        Principalobjectattributeaccess _x = _copy();
        _x.changedFields = changedFields.add("_principalid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.principalobjectattributeaccess");
        _x._principalid_value = _principalid_value;
        return _x;
    }

    @Property(name="readaccess")
    @JsonIgnore
    public Optional<Boolean> getReadaccess() {
        return Optional.ofNullable(readaccess);
    }

    public Principalobjectattributeaccess withReadaccess(Boolean readaccess) {
        Principalobjectattributeaccess _x = _copy();
        _x.changedFields = changedFields.add("readaccess");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.principalobjectattributeaccess");
        _x.readaccess = readaccess;
        return _x;
    }

    @Property(name="attributeid")
    @JsonIgnore
    public Optional<UUID> getAttributeid() {
        return Optional.ofNullable(attributeid);
    }

    public Principalobjectattributeaccess withAttributeid(UUID attributeid) {
        Principalobjectattributeaccess _x = _copy();
        _x.changedFields = changedFields.add("attributeid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.principalobjectattributeaccess");
        _x.attributeid = attributeid;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Principalobjectattributeaccess withVersionnumber(Long versionnumber) {
        Principalobjectattributeaccess _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.principalobjectattributeaccess");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="updateaccess")
    @JsonIgnore
    public Optional<Boolean> getUpdateaccess() {
        return Optional.ofNullable(updateaccess);
    }

    public Principalobjectattributeaccess withUpdateaccess(Boolean updateaccess) {
        Principalobjectattributeaccess _x = _copy();
        _x.changedFields = changedFields.add("updateaccess");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.principalobjectattributeaccess");
        _x.updateaccess = updateaccess;
        return _x;
    }

    @Property(name="_organizationid_value")
    @JsonIgnore
    public Optional<UUID> get_organizationid_value() {
        return Optional.ofNullable(_organizationid_value);
    }

    public Principalobjectattributeaccess with_organizationid_value(UUID _organizationid_value) {
        Principalobjectattributeaccess _x = _copy();
        _x.changedFields = changedFields.add("_organizationid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.principalobjectattributeaccess");
        _x._organizationid_value = _organizationid_value;
        return _x;
    }

    @Property(name="_objectid_value")
    @JsonIgnore
    public Optional<UUID> get_objectid_value() {
        return Optional.ofNullable(_objectid_value);
    }

    public Principalobjectattributeaccess with_objectid_value(UUID _objectid_value) {
        Principalobjectattributeaccess _x = _copy();
        _x.changedFields = changedFields.add("_objectid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.principalobjectattributeaccess");
        _x._objectid_value = _objectid_value;
        return _x;
    }

    public Principalobjectattributeaccess withUnmappedField(String name, String value) {
        Principalobjectattributeaccess _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="objectid_contact")
    @JsonIgnore
    public ContactRequest getObjectid_contact() {
        return new ContactRequest(contextPath.addSegment("objectid_contact"), RequestHelper.getValue(unmappedFields, "objectid_contact"));
    }

    @NavigationProperty(name="objectid_account")
    @JsonIgnore
    public AccountRequest getObjectid_account() {
        return new AccountRequest(contextPath.addSegment("objectid_account"), RequestHelper.getValue(unmappedFields, "objectid_account"));
    }

    @NavigationProperty(name="organizationid")
    @JsonIgnore
    public OrganizationRequest getOrganizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), RequestHelper.getValue(unmappedFields, "organizationid"));
    }

    @NavigationProperty(name="principalid_systemuser")
    @JsonIgnore
    public SystemuserRequest getPrincipalid_systemuser() {
        return new SystemuserRequest(contextPath.addSegment("principalid_systemuser"), RequestHelper.getValue(unmappedFields, "principalid_systemuser"));
    }

    @NavigationProperty(name="principalid_team")
    @JsonIgnore
    public TeamRequest getPrincipalid_team() {
        return new TeamRequest(contextPath.addSegment("principalid_team"), RequestHelper.getValue(unmappedFields, "principalid_team"));
    }

    @NavigationProperty(name="objectid_knowledgearticle")
    @JsonIgnore
    public KnowledgearticleRequest getObjectid_knowledgearticle() {
        return new KnowledgearticleRequest(contextPath.addSegment("objectid_knowledgearticle"), RequestHelper.getValue(unmappedFields, "objectid_knowledgearticle"));
    }

    @NavigationProperty(name="objectid_knowledgebaserecord")
    @JsonIgnore
    public KnowledgebaserecordRequest getObjectid_knowledgebaserecord() {
        return new KnowledgebaserecordRequest(contextPath.addSegment("objectid_knowledgebaserecord"), RequestHelper.getValue(unmappedFields, "objectid_knowledgebaserecord"));
    }

    @NavigationProperty(name="objectid_letter")
    @JsonIgnore
    public LetterRequest getObjectid_letter() {
        return new LetterRequest(contextPath.addSegment("objectid_letter"), RequestHelper.getValue(unmappedFields, "objectid_letter"));
    }

    @NavigationProperty(name="objectid_reportcategory")
    @JsonIgnore
    public ReportcategoryRequest getObjectid_reportcategory() {
        return new ReportcategoryRequest(contextPath.addSegment("objectid_reportcategory"), RequestHelper.getValue(unmappedFields, "objectid_reportcategory"));
    }

    @NavigationProperty(name="objectid_sharepointdocumentlocation")
    @JsonIgnore
    public SharepointdocumentlocationRequest getObjectid_sharepointdocumentlocation() {
        return new SharepointdocumentlocationRequest(contextPath.addSegment("objectid_sharepointdocumentlocation"), RequestHelper.getValue(unmappedFields, "objectid_sharepointdocumentlocation"));
    }

    @NavigationProperty(name="objectid_recurringappointmentmaster")
    @JsonIgnore
    public RecurringappointmentmasterRequest getObjectid_recurringappointmentmaster() {
        return new RecurringappointmentmasterRequest(contextPath.addSegment("objectid_recurringappointmentmaster"), RequestHelper.getValue(unmappedFields, "objectid_recurringappointmentmaster"));
    }

    @NavigationProperty(name="objectid_connection")
    @JsonIgnore
    public ConnectionRequest getObjectid_connection() {
        return new ConnectionRequest(contextPath.addSegment("objectid_connection"), RequestHelper.getValue(unmappedFields, "objectid_connection"));
    }

    @NavigationProperty(name="objectid_position")
    @JsonIgnore
    public PositionRequest getObjectid_position() {
        return new PositionRequest(contextPath.addSegment("objectid_position"), RequestHelper.getValue(unmappedFields, "objectid_position"));
    }

    @NavigationProperty(name="objectid_feedback")
    @JsonIgnore
    public FeedbackRequest getObjectid_feedback() {
        return new FeedbackRequest(contextPath.addSegment("objectid_feedback"), RequestHelper.getValue(unmappedFields, "objectid_feedback"));
    }

    @NavigationProperty(name="objectid_mailmergetemplate")
    @JsonIgnore
    public MailmergetemplateRequest getObjectid_mailmergetemplate() {
        return new MailmergetemplateRequest(contextPath.addSegment("objectid_mailmergetemplate"), RequestHelper.getValue(unmappedFields, "objectid_mailmergetemplate"));
    }

    @NavigationProperty(name="objectid_fax")
    @JsonIgnore
    public FaxRequest getObjectid_fax() {
        return new FaxRequest(contextPath.addSegment("objectid_fax"), RequestHelper.getValue(unmappedFields, "objectid_fax"));
    }

    @NavigationProperty(name="objectid_sharepointsite")
    @JsonIgnore
    public SharepointsiteRequest getObjectid_sharepointsite() {
        return new SharepointsiteRequest(contextPath.addSegment("objectid_sharepointsite"), RequestHelper.getValue(unmappedFields, "objectid_sharepointsite"));
    }

    @NavigationProperty(name="objectid_socialprofile")
    @JsonIgnore
    public SocialprofileRequest getObjectid_socialprofile() {
        return new SocialprofileRequest(contextPath.addSegment("objectid_socialprofile"), RequestHelper.getValue(unmappedFields, "objectid_socialprofile"));
    }

    @NavigationProperty(name="objectid_kbarticle")
    @JsonIgnore
    public KbarticleRequest getObjectid_kbarticle() {
        return new KbarticleRequest(contextPath.addSegment("objectid_kbarticle"), RequestHelper.getValue(unmappedFields, "objectid_kbarticle"));
    }

    @NavigationProperty(name="objectid_appointment")
    @JsonIgnore
    public AppointmentRequest getObjectid_appointment() {
        return new AppointmentRequest(contextPath.addSegment("objectid_appointment"), RequestHelper.getValue(unmappedFields, "objectid_appointment"));
    }

    @NavigationProperty(name="objectid_knowledgearticleviews")
    @JsonIgnore
    public KnowledgearticleviewsRequest getObjectid_knowledgearticleviews() {
        return new KnowledgearticleviewsRequest(contextPath.addSegment("objectid_knowledgearticleviews"), RequestHelper.getValue(unmappedFields, "objectid_knowledgearticleviews"));
    }

    @NavigationProperty(name="objectid_task")
    @JsonIgnore
    public TaskRequest getObjectid_task() {
        return new TaskRequest(contextPath.addSegment("objectid_task"), RequestHelper.getValue(unmappedFields, "objectid_task"));
    }

    @NavigationProperty(name="objectid_team")
    @JsonIgnore
    public TeamRequest getObjectid_team() {
        return new TeamRequest(contextPath.addSegment("objectid_team"), RequestHelper.getValue(unmappedFields, "objectid_team"));
    }

    @NavigationProperty(name="objectid_email")
    @JsonIgnore
    public EmailRequest getObjectid_email() {
        return new EmailRequest(contextPath.addSegment("objectid_email"), RequestHelper.getValue(unmappedFields, "objectid_email"));
    }

    @NavigationProperty(name="objectid_businessunit")
    @JsonIgnore
    public BusinessunitRequest getObjectid_businessunit() {
        return new BusinessunitRequest(contextPath.addSegment("objectid_businessunit"), RequestHelper.getValue(unmappedFields, "objectid_businessunit"));
    }

    @NavigationProperty(name="objectid_socialactivity")
    @JsonIgnore
    public SocialactivityRequest getObjectid_socialactivity() {
        return new SocialactivityRequest(contextPath.addSegment("objectid_socialactivity"), RequestHelper.getValue(unmappedFields, "objectid_socialactivity"));
    }

    @NavigationProperty(name="objectid_queue")
    @JsonIgnore
    public QueueRequest getObjectid_queue() {
        return new QueueRequest(contextPath.addSegment("objectid_queue"), RequestHelper.getValue(unmappedFields, "objectid_queue"));
    }

    @NavigationProperty(name="objectid_customeraddress")
    @JsonIgnore
    public CustomeraddressRequest getObjectid_customeraddress() {
        return new CustomeraddressRequest(contextPath.addSegment("objectid_customeraddress"), RequestHelper.getValue(unmappedFields, "objectid_customeraddress"));
    }

    @NavigationProperty(name="objectid_systemuser")
    @JsonIgnore
    public SystemuserRequest getObjectid_systemuser() {
        return new SystemuserRequest(contextPath.addSegment("objectid_systemuser"), RequestHelper.getValue(unmappedFields, "objectid_systemuser"));
    }

    @NavigationProperty(name="objectid_queueitem")
    @JsonIgnore
    public QueueitemRequest getObjectid_queueitem() {
        return new QueueitemRequest(contextPath.addSegment("objectid_queueitem"), RequestHelper.getValue(unmappedFields, "objectid_queueitem"));
    }

    @NavigationProperty(name="objectid_goal")
    @JsonIgnore
    public GoalRequest getObjectid_goal() {
        return new GoalRequest(contextPath.addSegment("objectid_goal"), RequestHelper.getValue(unmappedFields, "objectid_goal"));
    }

    @NavigationProperty(name="objectid_phonecall")
    @JsonIgnore
    public PhonecallRequest getObjectid_phonecall() {
        return new PhonecallRequest(contextPath.addSegment("objectid_phonecall"), RequestHelper.getValue(unmappedFields, "objectid_phonecall"));
    }

    @NavigationProperty(name="objectid_solutioncomponentattributeconfiguration")
    @JsonIgnore
    public SolutioncomponentattributeconfigurationRequest getObjectid_solutioncomponentattributeconfiguration() {
        return new SolutioncomponentattributeconfigurationRequest(contextPath.addSegment("objectid_solutioncomponentattributeconfiguration"), RequestHelper.getValue(unmappedFields, "objectid_solutioncomponentattributeconfiguration"));
    }

    @NavigationProperty(name="objectid_solutioncomponentconfiguration")
    @JsonIgnore
    public SolutioncomponentconfigurationRequest getObjectid_solutioncomponentconfiguration() {
        return new SolutioncomponentconfigurationRequest(contextPath.addSegment("objectid_solutioncomponentconfiguration"), RequestHelper.getValue(unmappedFields, "objectid_solutioncomponentconfiguration"));
    }

    @NavigationProperty(name="objectid_solutioncomponentrelationshipconfiguration")
    @JsonIgnore
    public SolutioncomponentrelationshipconfigurationRequest getObjectid_solutioncomponentrelationshipconfiguration() {
        return new SolutioncomponentrelationshipconfigurationRequest(contextPath.addSegment("objectid_solutioncomponentrelationshipconfiguration"), RequestHelper.getValue(unmappedFields, "objectid_solutioncomponentrelationshipconfiguration"));
    }

    @NavigationProperty(name="objectid_stagesolutionupload")
    @JsonIgnore
    public StagesolutionuploadRequest getObjectid_stagesolutionupload() {
        return new StagesolutionuploadRequest(contextPath.addSegment("objectid_stagesolutionupload"), RequestHelper.getValue(unmappedFields, "objectid_stagesolutionupload"));
    }

    @NavigationProperty(name="objectid_exportsolutionupload")
    @JsonIgnore
    public ExportsolutionuploadRequest getObjectid_exportsolutionupload() {
        return new ExportsolutionuploadRequest(contextPath.addSegment("objectid_exportsolutionupload"), RequestHelper.getValue(unmappedFields, "objectid_exportsolutionupload"));
    }

    @NavigationProperty(name="objectid_attributeimageconfig")
    @JsonIgnore
    public AttributeimageconfigRequest getObjectid_attributeimageconfig() {
        return new AttributeimageconfigRequest(contextPath.addSegment("objectid_attributeimageconfig"), RequestHelper.getValue(unmappedFields, "objectid_attributeimageconfig"));
    }

    @NavigationProperty(name="objectid_entityimageconfig")
    @JsonIgnore
    public EntityimageconfigRequest getObjectid_entityimageconfig() {
        return new EntityimageconfigRequest(contextPath.addSegment("objectid_entityimageconfig"), RequestHelper.getValue(unmappedFields, "objectid_entityimageconfig"));
    }

    @NavigationProperty(name="objectid_entityanalyticsconfig")
    @JsonIgnore
    public EntityanalyticsconfigRequest getObjectid_entityanalyticsconfig() {
        return new EntityanalyticsconfigRequest(contextPath.addSegment("objectid_entityanalyticsconfig"), RequestHelper.getValue(unmappedFields, "objectid_entityanalyticsconfig"));
    }

    @NavigationProperty(name="objectid_relationshipattribute")
    @JsonIgnore
    public RelationshipattributeRequest getObjectid_relationshipattribute() {
        return new RelationshipattributeRequest(contextPath.addSegment("objectid_relationshipattribute"), RequestHelper.getValue(unmappedFields, "objectid_relationshipattribute"));
    }

    @NavigationProperty(name="objectid_datalakeworkspace")
    @JsonIgnore
    public DatalakeworkspaceRequest getObjectid_datalakeworkspace() {
        return new DatalakeworkspaceRequest(contextPath.addSegment("objectid_datalakeworkspace"), RequestHelper.getValue(unmappedFields, "objectid_datalakeworkspace"));
    }

    @NavigationProperty(name="objectid_datalakeworkspacepermission")
    @JsonIgnore
    public DatalakeworkspacepermissionRequest getObjectid_datalakeworkspacepermission() {
        return new DatalakeworkspacepermissionRequest(contextPath.addSegment("objectid_datalakeworkspacepermission"), RequestHelper.getValue(unmappedFields, "objectid_datalakeworkspacepermission"));
    }

    @NavigationProperty(name="objectid_applicationuser")
    @JsonIgnore
    public ApplicationuserRequest getObjectid_applicationuser() {
        return new ApplicationuserRequest(contextPath.addSegment("objectid_applicationuser"), RequestHelper.getValue(unmappedFields, "objectid_applicationuser"));
    }

    @NavigationProperty(name="objectid_serviceplan")
    @JsonIgnore
    public ServiceplanRequest getObjectid_serviceplan() {
        return new ServiceplanRequest(contextPath.addSegment("objectid_serviceplan"), RequestHelper.getValue(unmappedFields, "objectid_serviceplan"));
    }

    @NavigationProperty(name="objectid_connector")
    @JsonIgnore
    public ConnectorRequest getObjectid_connector() {
        return new ConnectorRequest(contextPath.addSegment("objectid_connector"), RequestHelper.getValue(unmappedFields, "objectid_connector"));
    }

    @NavigationProperty(name="objectid_environmentvariabledefinition")
    @JsonIgnore
    public EnvironmentvariabledefinitionRequest getObjectid_environmentvariabledefinition() {
        return new EnvironmentvariabledefinitionRequest(contextPath.addSegment("objectid_environmentvariabledefinition"), RequestHelper.getValue(unmappedFields, "objectid_environmentvariabledefinition"));
    }

    @NavigationProperty(name="objectid_environmentvariablevalue")
    @JsonIgnore
    public EnvironmentvariablevalueRequest getObjectid_environmentvariablevalue() {
        return new EnvironmentvariablevalueRequest(contextPath.addSegment("objectid_environmentvariablevalue"), RequestHelper.getValue(unmappedFields, "objectid_environmentvariablevalue"));
    }

    @NavigationProperty(name="objectid_processstageparameter")
    @JsonIgnore
    public ProcessstageparameterRequest getObjectid_processstageparameter() {
        return new ProcessstageparameterRequest(contextPath.addSegment("objectid_processstageparameter"), RequestHelper.getValue(unmappedFields, "objectid_processstageparameter"));
    }

    @NavigationProperty(name="objectid_flowsession")
    @JsonIgnore
    public FlowsessionRequest getObjectid_flowsession() {
        return new FlowsessionRequest(contextPath.addSegment("objectid_flowsession"), RequestHelper.getValue(unmappedFields, "objectid_flowsession"));
    }

    @NavigationProperty(name="objectid_workflowbinary")
    @JsonIgnore
    public WorkflowbinaryRequest getObjectid_workflowbinary() {
        return new WorkflowbinaryRequest(contextPath.addSegment("objectid_workflowbinary"), RequestHelper.getValue(unmappedFields, "objectid_workflowbinary"));
    }

    @NavigationProperty(name="objectid_connectionreference")
    @JsonIgnore
    public ConnectionreferenceRequest getObjectid_connectionreference() {
        return new ConnectionreferenceRequest(contextPath.addSegment("objectid_connectionreference"), RequestHelper.getValue(unmappedFields, "objectid_connectionreference"));
    }

    @NavigationProperty(name="objectid_msdyn_helppage")
    @JsonIgnore
    public Msdyn_helppageRequest getObjectid_msdyn_helppage() {
        return new Msdyn_helppageRequest(contextPath.addSegment("objectid_msdyn_helppage"), RequestHelper.getValue(unmappedFields, "objectid_msdyn_helppage"));
    }

    @NavigationProperty(name="objectid_territory")
    @JsonIgnore
    public TerritoryRequest getObjectid_territory() {
        return new TerritoryRequest(contextPath.addSegment("objectid_territory"), RequestHelper.getValue(unmappedFields, "objectid_territory"));
    }

    @NavigationProperty(name="objectid_msdyn_serviceconfiguration")
    @JsonIgnore
    public Msdyn_serviceconfigurationRequest getObjectid_msdyn_serviceconfiguration() {
        return new Msdyn_serviceconfigurationRequest(contextPath.addSegment("objectid_msdyn_serviceconfiguration"), RequestHelper.getValue(unmappedFields, "objectid_msdyn_serviceconfiguration"));
    }

    @NavigationProperty(name="objectid_msdyn_slakpi")
    @JsonIgnore
    public Msdyn_slakpiRequest getObjectid_msdyn_slakpi() {
        return new Msdyn_slakpiRequest(contextPath.addSegment("objectid_msdyn_slakpi"), RequestHelper.getValue(unmappedFields, "objectid_msdyn_slakpi"));
    }

    @NavigationProperty(name="objectid_msdyn_knowledgearticleimage")
    @JsonIgnore
    public Msdyn_knowledgearticleimageRequest getObjectid_msdyn_knowledgearticleimage() {
        return new Msdyn_knowledgearticleimageRequest(contextPath.addSegment("objectid_msdyn_knowledgearticleimage"), RequestHelper.getValue(unmappedFields, "objectid_msdyn_knowledgearticleimage"));
    }

    @NavigationProperty(name="objectid_msdyn_knowledgearticletemplate")
    @JsonIgnore
    public Msdyn_knowledgearticletemplateRequest getObjectid_msdyn_knowledgearticletemplate() {
        return new Msdyn_knowledgearticletemplateRequest(contextPath.addSegment("objectid_msdyn_knowledgearticletemplate"), RequestHelper.getValue(unmappedFields, "objectid_msdyn_knowledgearticletemplate"));
    }

    @NavigationProperty(name="objectid_msdyn_dataflow")
    @JsonIgnore
    public Msdyn_dataflowRequest getObjectid_msdyn_dataflow() {
        return new Msdyn_dataflowRequest(contextPath.addSegment("objectid_msdyn_dataflow"), RequestHelper.getValue(unmappedFields, "objectid_msdyn_dataflow"));
    }

    @NavigationProperty(name="objectid_msdyn_richtextfile")
    @JsonIgnore
    public Msdyn_richtextfileRequest getObjectid_msdyn_richtextfile() {
        return new Msdyn_richtextfileRequest(contextPath.addSegment("objectid_msdyn_richtextfile"), RequestHelper.getValue(unmappedFields, "objectid_msdyn_richtextfile"));
    }

    @NavigationProperty(name="objectid_msdyn_aiconfiguration")
    @JsonIgnore
    public Msdyn_aiconfigurationRequest getObjectid_msdyn_aiconfiguration() {
        return new Msdyn_aiconfigurationRequest(contextPath.addSegment("objectid_msdyn_aiconfiguration"), RequestHelper.getValue(unmappedFields, "objectid_msdyn_aiconfiguration"));
    }

    @NavigationProperty(name="objectid_msdyn_aimodel")
    @JsonIgnore
    public Msdyn_aimodelRequest getObjectid_msdyn_aimodel() {
        return new Msdyn_aimodelRequest(contextPath.addSegment("objectid_msdyn_aimodel"), RequestHelper.getValue(unmappedFields, "objectid_msdyn_aimodel"));
    }

    @NavigationProperty(name="objectid_msdyn_aitemplate")
    @JsonIgnore
    public Msdyn_aitemplateRequest getObjectid_msdyn_aitemplate() {
        return new Msdyn_aitemplateRequest(contextPath.addSegment("objectid_msdyn_aitemplate"), RequestHelper.getValue(unmappedFields, "objectid_msdyn_aitemplate"));
    }

    @NavigationProperty(name="objectid_msdyn_aibdataset")
    @JsonIgnore
    public Msdyn_aibdatasetRequest getObjectid_msdyn_aibdataset() {
        return new Msdyn_aibdatasetRequest(contextPath.addSegment("objectid_msdyn_aibdataset"), RequestHelper.getValue(unmappedFields, "objectid_msdyn_aibdataset"));
    }

    @NavigationProperty(name="objectid_msdyn_aibdatasetfile")
    @JsonIgnore
    public Msdyn_aibdatasetfileRequest getObjectid_msdyn_aibdatasetfile() {
        return new Msdyn_aibdatasetfileRequest(contextPath.addSegment("objectid_msdyn_aibdatasetfile"), RequestHelper.getValue(unmappedFields, "objectid_msdyn_aibdatasetfile"));
    }

    @NavigationProperty(name="objectid_msdyn_aibdatasetrecord")
    @JsonIgnore
    public Msdyn_aibdatasetrecordRequest getObjectid_msdyn_aibdatasetrecord() {
        return new Msdyn_aibdatasetrecordRequest(contextPath.addSegment("objectid_msdyn_aibdatasetrecord"), RequestHelper.getValue(unmappedFields, "objectid_msdyn_aibdatasetrecord"));
    }

    @NavigationProperty(name="objectid_msdyn_aibdatasetscontainer")
    @JsonIgnore
    public Msdyn_aibdatasetscontainerRequest getObjectid_msdyn_aibdatasetscontainer() {
        return new Msdyn_aibdatasetscontainerRequest(contextPath.addSegment("objectid_msdyn_aibdatasetscontainer"), RequestHelper.getValue(unmappedFields, "objectid_msdyn_aibdatasetscontainer"));
    }

    @NavigationProperty(name="objectid_msdyn_aibfile")
    @JsonIgnore
    public Msdyn_aibfileRequest getObjectid_msdyn_aibfile() {
        return new Msdyn_aibfileRequest(contextPath.addSegment("objectid_msdyn_aibfile"), RequestHelper.getValue(unmappedFields, "objectid_msdyn_aibfile"));
    }

    @NavigationProperty(name="objectid_msdyn_aibfileattacheddata")
    @JsonIgnore
    public Msdyn_aibfileattacheddataRequest getObjectid_msdyn_aibfileattacheddata() {
        return new Msdyn_aibfileattacheddataRequest(contextPath.addSegment("objectid_msdyn_aibfileattacheddata"), RequestHelper.getValue(unmappedFields, "objectid_msdyn_aibfileattacheddata"));
    }

    @NavigationProperty(name="objectid_msdyn_aifptrainingdocument")
    @JsonIgnore
    public Msdyn_aifptrainingdocumentRequest getObjectid_msdyn_aifptrainingdocument() {
        return new Msdyn_aifptrainingdocumentRequest(contextPath.addSegment("objectid_msdyn_aifptrainingdocument"), RequestHelper.getValue(unmappedFields, "objectid_msdyn_aifptrainingdocument"));
    }

    @NavigationProperty(name="objectid_msdyn_aiodimage")
    @JsonIgnore
    public Msdyn_aiodimageRequest getObjectid_msdyn_aiodimage() {
        return new Msdyn_aiodimageRequest(contextPath.addSegment("objectid_msdyn_aiodimage"), RequestHelper.getValue(unmappedFields, "objectid_msdyn_aiodimage"));
    }

    @NavigationProperty(name="objectid_msdyn_aiodlabel")
    @JsonIgnore
    public Msdyn_aiodlabelRequest getObjectid_msdyn_aiodlabel() {
        return new Msdyn_aiodlabelRequest(contextPath.addSegment("objectid_msdyn_aiodlabel"), RequestHelper.getValue(unmappedFields, "objectid_msdyn_aiodlabel"));
    }

    @NavigationProperty(name="objectid_msdyn_aiodtrainingboundingbox")
    @JsonIgnore
    public Msdyn_aiodtrainingboundingboxRequest getObjectid_msdyn_aiodtrainingboundingbox() {
        return new Msdyn_aiodtrainingboundingboxRequest(contextPath.addSegment("objectid_msdyn_aiodtrainingboundingbox"), RequestHelper.getValue(unmappedFields, "objectid_msdyn_aiodtrainingboundingbox"));
    }

    @NavigationProperty(name="objectid_msdyn_aiodtrainingimage")
    @JsonIgnore
    public Msdyn_aiodtrainingimageRequest getObjectid_msdyn_aiodtrainingimage() {
        return new Msdyn_aiodtrainingimageRequest(contextPath.addSegment("objectid_msdyn_aiodtrainingimage"), RequestHelper.getValue(unmappedFields, "objectid_msdyn_aiodtrainingimage"));
    }

    @NavigationProperty(name="objectid_msdyn_analysiscomponent")
    @JsonIgnore
    public Msdyn_analysiscomponentRequest getObjectid_msdyn_analysiscomponent() {
        return new Msdyn_analysiscomponentRequest(contextPath.addSegment("objectid_msdyn_analysiscomponent"), RequestHelper.getValue(unmappedFields, "objectid_msdyn_analysiscomponent"));
    }

    @NavigationProperty(name="objectid_msdyn_analysisjob")
    @JsonIgnore
    public Msdyn_analysisjobRequest getObjectid_msdyn_analysisjob() {
        return new Msdyn_analysisjobRequest(contextPath.addSegment("objectid_msdyn_analysisjob"), RequestHelper.getValue(unmappedFields, "objectid_msdyn_analysisjob"));
    }

    @NavigationProperty(name="objectid_msdyn_analysisresult")
    @JsonIgnore
    public Msdyn_analysisresultRequest getObjectid_msdyn_analysisresult() {
        return new Msdyn_analysisresultRequest(contextPath.addSegment("objectid_msdyn_analysisresult"), RequestHelper.getValue(unmappedFields, "objectid_msdyn_analysisresult"));
    }

    @NavigationProperty(name="objectid_msdyn_analysisresultdetail")
    @JsonIgnore
    public Msdyn_analysisresultdetailRequest getObjectid_msdyn_analysisresultdetail() {
        return new Msdyn_analysisresultdetailRequest(contextPath.addSegment("objectid_msdyn_analysisresultdetail"), RequestHelper.getValue(unmappedFields, "objectid_msdyn_analysisresultdetail"));
    }

    @NavigationProperty(name="objectid_msdyn_solutionhealthrule")
    @JsonIgnore
    public Msdyn_solutionhealthruleRequest getObjectid_msdyn_solutionhealthrule() {
        return new Msdyn_solutionhealthruleRequest(contextPath.addSegment("objectid_msdyn_solutionhealthrule"), RequestHelper.getValue(unmappedFields, "objectid_msdyn_solutionhealthrule"));
    }

    @NavigationProperty(name="objectid_msdyn_solutionhealthruleargument")
    @JsonIgnore
    public Msdyn_solutionhealthruleargumentRequest getObjectid_msdyn_solutionhealthruleargument() {
        return new Msdyn_solutionhealthruleargumentRequest(contextPath.addSegment("objectid_msdyn_solutionhealthruleargument"), RequestHelper.getValue(unmappedFields, "objectid_msdyn_solutionhealthruleargument"));
    }

    @NavigationProperty(name="objectid_msdyn_solutionhealthruleset")
    @JsonIgnore
    public Msdyn_solutionhealthrulesetRequest getObjectid_msdyn_solutionhealthruleset() {
        return new Msdyn_solutionhealthrulesetRequest(contextPath.addSegment("objectid_msdyn_solutionhealthruleset"), RequestHelper.getValue(unmappedFields, "objectid_msdyn_solutionhealthruleset"));
    }

    @NavigationProperty(name="objectid_ggw_event")
    @JsonIgnore
    public Ggw_eventRequest getObjectid_ggw_event() {
        return new Ggw_eventRequest(contextPath.addSegment("objectid_ggw_event"), RequestHelper.getValue(unmappedFields, "objectid_ggw_event"));
    }

    @NavigationProperty(name="objectid_ggw_team")
    @JsonIgnore
    public Ggw_teamRequest getObjectid_ggw_team() {
        return new Ggw_teamRequest(contextPath.addSegment("objectid_ggw_team"), RequestHelper.getValue(unmappedFields, "objectid_ggw_team"));
    }

    @NavigationProperty(name="objectid_ggw_crew")
    @JsonIgnore
    public Ggw_crewRequest getObjectid_ggw_crew() {
        return new Ggw_crewRequest(contextPath.addSegment("objectid_ggw_crew"), RequestHelper.getValue(unmappedFields, "objectid_ggw_crew"));
    }

    @NavigationProperty(name="objectid_ggw_team_application")
    @JsonIgnore
    public Ggw_team_applicationRequest getObjectid_ggw_team_application() {
        return new Ggw_team_applicationRequest(contextPath.addSegment("objectid_ggw_team_application"), RequestHelper.getValue(unmappedFields, "objectid_ggw_team_application"));
    }

    @NavigationProperty(name="objectid_cascadegrantrevokeaccessrecordstracker")
    @JsonIgnore
    public CascadegrantrevokeaccessrecordstrackerRequest getObjectid_cascadegrantrevokeaccessrecordstracker() {
        return new CascadegrantrevokeaccessrecordstrackerRequest(contextPath.addSegment("objectid_cascadegrantrevokeaccessrecordstracker"), RequestHelper.getValue(unmappedFields, "objectid_cascadegrantrevokeaccessrecordstracker"));
    }

    @NavigationProperty(name="objectid_cascadegrantrevokeaccessversiontracker")
    @JsonIgnore
    public CascadegrantrevokeaccessversiontrackerRequest getObjectid_cascadegrantrevokeaccessversiontracker() {
        return new CascadegrantrevokeaccessversiontrackerRequest(contextPath.addSegment("objectid_cascadegrantrevokeaccessversiontracker"), RequestHelper.getValue(unmappedFields, "objectid_cascadegrantrevokeaccessversiontracker"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Principalobjectattributeaccess patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Principalobjectattributeaccess _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Principalobjectattributeaccess put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Principalobjectattributeaccess _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Principalobjectattributeaccess _copy() {
        Principalobjectattributeaccess _x = new Principalobjectattributeaccess();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.principalobjectattributeaccessid = principalobjectattributeaccessid;
        _x._principalid_value = _principalid_value;
        _x.readaccess = readaccess;
        _x.attributeid = attributeid;
        _x.versionnumber = versionnumber;
        _x.updateaccess = updateaccess;
        _x._organizationid_value = _organizationid_value;
        _x._objectid_value = _objectid_value;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Principalobjectattributeaccess[");
        b.append("principalobjectattributeaccessid=");
        b.append(this.principalobjectattributeaccessid);
        b.append(", ");
        b.append("_principalid_value=");
        b.append(this._principalid_value);
        b.append(", ");
        b.append("readaccess=");
        b.append(this.readaccess);
        b.append(", ");
        b.append("attributeid=");
        b.append(this.attributeid);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("updateaccess=");
        b.append(this.updateaccess);
        b.append(", ");
        b.append("_organizationid_value=");
        b.append(this._organizationid_value);
        b.append(", ");
        b.append("_objectid_value=");
        b.append(this._objectid_value);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
