package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.complex.BooleanManagedProperty;
import microsoft.dynamics.crm.complex.Label;
import microsoft.dynamics.crm.complex.OptionMetadata;
import microsoft.dynamics.crm.enums.OptionSetType;

@JsonPropertyOrder({
    "@odata.type", 
    "Options", 
    "ParentOptionSetName"})
@JsonInclude(Include.NON_NULL)
public class OptionSetMetadata extends OptionSetMetadataBase implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.OptionSetMetadata";
    }

    @JsonProperty("Options")
    protected List<OptionMetadata> options;

    @JsonProperty("Options@nextLink")
    protected String optionsNextLink;

    @JsonProperty("ParentOptionSetName")
    protected String parentOptionSetName;

    protected OptionSetMetadata() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderOptionSetMetadata() {
        return new Builder();
    }

    public static final class Builder {
        private UUID metadataId;
        private Boolean hasChanged;
        private Label description;
        private Label displayName;
        private Boolean isCustomOptionSet;
        private Boolean isGlobal;
        private Boolean isManaged;
        private BooleanManagedProperty isCustomizable;
        private String name;
        private String externalTypeName;
        private OptionSetType optionSetType;
        private String introducedVersion;
        private List<OptionMetadata> options;
        private String optionsNextLink;
        private String parentOptionSetName;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder metadataId(UUID metadataId) {
            this.metadataId = metadataId;
            this.changedFields = changedFields.add("MetadataId");
            return this;
        }

        public Builder hasChanged(Boolean hasChanged) {
            this.hasChanged = hasChanged;
            this.changedFields = changedFields.add("HasChanged");
            return this;
        }

        public Builder description(Label description) {
            this.description = description;
            this.changedFields = changedFields.add("Description");
            return this;
        }

        public Builder displayName(Label displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("DisplayName");
            return this;
        }

        public Builder isCustomOptionSet(Boolean isCustomOptionSet) {
            this.isCustomOptionSet = isCustomOptionSet;
            this.changedFields = changedFields.add("IsCustomOptionSet");
            return this;
        }

        public Builder isGlobal(Boolean isGlobal) {
            this.isGlobal = isGlobal;
            this.changedFields = changedFields.add("IsGlobal");
            return this;
        }

        public Builder isManaged(Boolean isManaged) {
            this.isManaged = isManaged;
            this.changedFields = changedFields.add("IsManaged");
            return this;
        }

        public Builder isCustomizable(BooleanManagedProperty isCustomizable) {
            this.isCustomizable = isCustomizable;
            this.changedFields = changedFields.add("IsCustomizable");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("Name");
            return this;
        }

        public Builder externalTypeName(String externalTypeName) {
            this.externalTypeName = externalTypeName;
            this.changedFields = changedFields.add("ExternalTypeName");
            return this;
        }

        public Builder optionSetType(OptionSetType optionSetType) {
            this.optionSetType = optionSetType;
            this.changedFields = changedFields.add("OptionSetType");
            return this;
        }

        public Builder introducedVersion(String introducedVersion) {
            this.introducedVersion = introducedVersion;
            this.changedFields = changedFields.add("IntroducedVersion");
            return this;
        }

        public Builder options(List<OptionMetadata> options) {
            this.options = options;
            this.changedFields = changedFields.add("Options");
            return this;
        }

        public Builder options(OptionMetadata... options) {
            return options(Arrays.asList(options));
        }

        public Builder optionsNextLink(String optionsNextLink) {
            this.optionsNextLink = optionsNextLink;
            this.changedFields = changedFields.add("Options");
            return this;
        }

        public Builder parentOptionSetName(String parentOptionSetName) {
            this.parentOptionSetName = parentOptionSetName;
            this.changedFields = changedFields.add("ParentOptionSetName");
            return this;
        }

        public OptionSetMetadata build() {
            OptionSetMetadata _x = new OptionSetMetadata();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.OptionSetMetadata";
            _x.metadataId = metadataId;
            _x.hasChanged = hasChanged;
            _x.description = description;
            _x.displayName = displayName;
            _x.isCustomOptionSet = isCustomOptionSet;
            _x.isGlobal = isGlobal;
            _x.isManaged = isManaged;
            _x.isCustomizable = isCustomizable;
            _x.name = name;
            _x.externalTypeName = externalTypeName;
            _x.optionSetType = optionSetType;
            _x.introducedVersion = introducedVersion;
            _x.options = options;
            _x.optionsNextLink = optionsNextLink;
            _x.parentOptionSetName = parentOptionSetName;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && metadataId != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(metadataId, UUID.class));
        }
    }

    @Property(name="Options")
    @JsonIgnore
    public CollectionPage<OptionMetadata> getOptions() {
        return new CollectionPage<OptionMetadata>(contextPath, OptionMetadata.class, this.options, Optional.ofNullable(optionsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public OptionSetMetadata withOptions(List<OptionMetadata> options) {
        OptionSetMetadata _x = _copy();
        _x.changedFields = changedFields.add("Options");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.OptionSetMetadata");
        _x.options = options;
        return _x;
    }

    @Property(name="Options")
    @JsonIgnore
    public CollectionPage<OptionMetadata> getOptions(HttpRequestOptions options) {
        return new CollectionPage<OptionMetadata>(contextPath, OptionMetadata.class, this.options, Optional.ofNullable(optionsNextLink), Collections.emptyList(), options);
    }

    @Property(name="ParentOptionSetName")
    @JsonIgnore
    public Optional<String> getParentOptionSetName() {
        return Optional.ofNullable(parentOptionSetName);
    }

    public OptionSetMetadata withParentOptionSetName(String parentOptionSetName) {
        Checks.checkIsAscii(parentOptionSetName);
        OptionSetMetadata _x = _copy();
        _x.changedFields = changedFields.add("ParentOptionSetName");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.OptionSetMetadata");
        _x.parentOptionSetName = parentOptionSetName;
        return _x;
    }

    public OptionSetMetadata withUnmappedField(String name, String value) {
        OptionSetMetadata _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public OptionSetMetadata patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        OptionSetMetadata _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public OptionSetMetadata put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        OptionSetMetadata _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private OptionSetMetadata _copy() {
        OptionSetMetadata _x = new OptionSetMetadata();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.metadataId = metadataId;
        _x.hasChanged = hasChanged;
        _x.description = description;
        _x.displayName = displayName;
        _x.isCustomOptionSet = isCustomOptionSet;
        _x.isGlobal = isGlobal;
        _x.isManaged = isManaged;
        _x.isCustomizable = isCustomizable;
        _x.name = name;
        _x.externalTypeName = externalTypeName;
        _x.optionSetType = optionSetType;
        _x.introducedVersion = introducedVersion;
        _x.options = options;
        _x.parentOptionSetName = parentOptionSetName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("OptionSetMetadata[");
        b.append("MetadataId=");
        b.append(this.metadataId);
        b.append(", ");
        b.append("HasChanged=");
        b.append(this.hasChanged);
        b.append(", ");
        b.append("Description=");
        b.append(this.description);
        b.append(", ");
        b.append("DisplayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("IsCustomOptionSet=");
        b.append(this.isCustomOptionSet);
        b.append(", ");
        b.append("IsGlobal=");
        b.append(this.isGlobal);
        b.append(", ");
        b.append("IsManaged=");
        b.append(this.isManaged);
        b.append(", ");
        b.append("IsCustomizable=");
        b.append(this.isCustomizable);
        b.append(", ");
        b.append("Name=");
        b.append(this.name);
        b.append(", ");
        b.append("ExternalTypeName=");
        b.append(this.externalTypeName);
        b.append(", ");
        b.append("OptionSetType=");
        b.append(this.optionSetType);
        b.append(", ");
        b.append("IntroducedVersion=");
        b.append(this.introducedVersion);
        b.append(", ");
        b.append("Options=");
        b.append(this.options);
        b.append(", ");
        b.append("ParentOptionSetName=");
        b.append(this.parentOptionSetName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
