package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.math.BigDecimal;
import java.util.Optional;
import java.util.UUID;

@JsonPropertyOrder({
    "@odata.type", 
    "msdyn_connectorinternalid", 
    "msdyn_isolationmode", 
    "msdyn_subtype", 
    "msdyn_iscustomizablename", 
    "msdyn_deployment", 
    "msdyn_logicalcollectionname", 
    "msdyn_componenttype", 
    "msdyn_relatedentity", 
    "msdyn_istableenabled", 
    "msdyn_primaryentityname", 
    "msdyn_ismanaged", 
    "msdyn_isdefault", 
    "msdyn_solutioncomponentsummaryid", 
    "msdyn_name", 
    "organizationid", 
    "msdyn_modifiedon", 
    "msdyn_typename", 
    "msdyn_iscustom", 
    "msdyn_canvasappuniqueid", 
    "msdyn_owningbusinessunit", 
    "msdyn_isappawarename", 
    "msdyn_executionstage", 
    "msdyn_iscustomname", 
    "msdyn_fieldtype", 
    "msdyn_isappaware", 
    "msdyn_displayname", 
    "msdyn_isauditenabledname", 
    "msdyn_eventhandler", 
    "msdyn_workflowidunique", 
    "msdyn_isdefaultname", 
    "msdyn_objecttypecode", 
    "msdyn_solutionid", 
    "msdyn_isauditenabled", 
    "msdyn_relatedentityattribute", 
    "msdyn_fieldsecurity", 
    "msdyn_description", 
    "msdyn_sdkmessagename", 
    "msdyn_owner", 
    "msdyn_objectid", 
    "msdyn_uniquename", 
    "msdyn_version", 
    "msdyn_synctoexternalsearchindex", 
    "msdyn_componentlogicalname", 
    "msdyn_statusname", 
    "msdyn_publickeytoken", 
    "msdyn_iscustomizable", 
    "msdyn_total", 
    "msdyn_executionorder", 
    "msdyn_schemaname", 
    "msdyn_culture", 
    "msdyn_componenttypename", 
    "msdyn_createdon", 
    "msdyn_status", 
    "msdyn_workflowcategory", 
    "msdyn_ismanagedname", 
    "msdyn_workflowcategoryname"})
@JsonInclude(Include.NON_NULL)
public class Msdyn_solutioncomponentsummary extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.msdyn_solutioncomponentsummary";
    }

    @JsonProperty("msdyn_connectorinternalid")
    protected String msdyn_connectorinternalid;

    @JsonProperty("msdyn_isolationmode")
    protected String msdyn_isolationmode;

    @JsonProperty("msdyn_subtype")
    protected String msdyn_subtype;

    @JsonProperty("msdyn_iscustomizablename")
    protected String msdyn_iscustomizablename;

    @JsonProperty("msdyn_deployment")
    protected String msdyn_deployment;

    @JsonProperty("msdyn_logicalcollectionname")
    protected String msdyn_logicalcollectionname;

    @JsonProperty("msdyn_componenttype")
    protected BigDecimal msdyn_componenttype;

    @JsonProperty("msdyn_relatedentity")
    protected String msdyn_relatedentity;

    @JsonProperty("msdyn_istableenabled")
    protected String msdyn_istableenabled;

    @JsonProperty("msdyn_primaryentityname")
    protected String msdyn_primaryentityname;

    @JsonProperty("msdyn_ismanaged")
    protected String msdyn_ismanaged;

    @JsonProperty("msdyn_isdefault")
    protected String msdyn_isdefault;

    @JsonProperty("msdyn_solutioncomponentsummaryid")
    protected UUID msdyn_solutioncomponentsummaryid;

    @JsonProperty("msdyn_name")
    protected String msdyn_name;

    @JsonProperty("organizationid")
    protected UUID organizationid;

    @JsonProperty("msdyn_modifiedon")
    protected String msdyn_modifiedon;

    @JsonProperty("msdyn_typename")
    protected String msdyn_typename;

    @JsonProperty("msdyn_iscustom")
    protected String msdyn_iscustom;

    @JsonProperty("msdyn_canvasappuniqueid")
    protected String msdyn_canvasappuniqueid;

    @JsonProperty("msdyn_owningbusinessunit")
    protected String msdyn_owningbusinessunit;

    @JsonProperty("msdyn_isappawarename")
    protected String msdyn_isappawarename;

    @JsonProperty("msdyn_executionstage")
    protected String msdyn_executionstage;

    @JsonProperty("msdyn_iscustomname")
    protected String msdyn_iscustomname;

    @JsonProperty("msdyn_fieldtype")
    protected String msdyn_fieldtype;

    @JsonProperty("msdyn_isappaware")
    protected String msdyn_isappaware;

    @JsonProperty("msdyn_displayname")
    protected String msdyn_displayname;

    @JsonProperty("msdyn_isauditenabledname")
    protected String msdyn_isauditenabledname;

    @JsonProperty("msdyn_eventhandler")
    protected String msdyn_eventhandler;

    @JsonProperty("msdyn_workflowidunique")
    protected String msdyn_workflowidunique;

    @JsonProperty("msdyn_isdefaultname")
    protected String msdyn_isdefaultname;

    @JsonProperty("msdyn_objecttypecode")
    protected String msdyn_objecttypecode;

    @JsonProperty("msdyn_solutionid")
    protected String msdyn_solutionid;

    @JsonProperty("msdyn_isauditenabled")
    protected String msdyn_isauditenabled;

    @JsonProperty("msdyn_relatedentityattribute")
    protected String msdyn_relatedentityattribute;

    @JsonProperty("msdyn_fieldsecurity")
    protected String msdyn_fieldsecurity;

    @JsonProperty("msdyn_description")
    protected String msdyn_description;

    @JsonProperty("msdyn_sdkmessagename")
    protected String msdyn_sdkmessagename;

    @JsonProperty("msdyn_owner")
    protected String msdyn_owner;

    @JsonProperty("msdyn_objectid")
    protected String msdyn_objectid;

    @JsonProperty("msdyn_uniquename")
    protected String msdyn_uniquename;

    @JsonProperty("msdyn_version")
    protected String msdyn_version;

    @JsonProperty("msdyn_synctoexternalsearchindex")
    protected String msdyn_synctoexternalsearchindex;

    @JsonProperty("msdyn_componentlogicalname")
    protected String msdyn_componentlogicalname;

    @JsonProperty("msdyn_statusname")
    protected String msdyn_statusname;

    @JsonProperty("msdyn_publickeytoken")
    protected String msdyn_publickeytoken;

    @JsonProperty("msdyn_iscustomizable")
    protected String msdyn_iscustomizable;

    @JsonProperty("msdyn_total")
    protected BigDecimal msdyn_total;

    @JsonProperty("msdyn_executionorder")
    protected String msdyn_executionorder;

    @JsonProperty("msdyn_schemaname")
    protected String msdyn_schemaname;

    @JsonProperty("msdyn_culture")
    protected String msdyn_culture;

    @JsonProperty("msdyn_componenttypename")
    protected String msdyn_componenttypename;

    @JsonProperty("msdyn_createdon")
    protected String msdyn_createdon;

    @JsonProperty("msdyn_status")
    protected String msdyn_status;

    @JsonProperty("msdyn_workflowcategory")
    protected String msdyn_workflowcategory;

    @JsonProperty("msdyn_ismanagedname")
    protected String msdyn_ismanagedname;

    @JsonProperty("msdyn_workflowcategoryname")
    protected String msdyn_workflowcategoryname;

    protected Msdyn_solutioncomponentsummary() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMsdyn_solutioncomponentsummary() {
        return new Builder();
    }

    public static final class Builder {
        private String msdyn_connectorinternalid;
        private String msdyn_isolationmode;
        private String msdyn_subtype;
        private String msdyn_iscustomizablename;
        private String msdyn_deployment;
        private String msdyn_logicalcollectionname;
        private BigDecimal msdyn_componenttype;
        private String msdyn_relatedentity;
        private String msdyn_istableenabled;
        private String msdyn_primaryentityname;
        private String msdyn_ismanaged;
        private String msdyn_isdefault;
        private UUID msdyn_solutioncomponentsummaryid;
        private String msdyn_name;
        private UUID organizationid;
        private String msdyn_modifiedon;
        private String msdyn_typename;
        private String msdyn_iscustom;
        private String msdyn_canvasappuniqueid;
        private String msdyn_owningbusinessunit;
        private String msdyn_isappawarename;
        private String msdyn_executionstage;
        private String msdyn_iscustomname;
        private String msdyn_fieldtype;
        private String msdyn_isappaware;
        private String msdyn_displayname;
        private String msdyn_isauditenabledname;
        private String msdyn_eventhandler;
        private String msdyn_workflowidunique;
        private String msdyn_isdefaultname;
        private String msdyn_objecttypecode;
        private String msdyn_solutionid;
        private String msdyn_isauditenabled;
        private String msdyn_relatedentityattribute;
        private String msdyn_fieldsecurity;
        private String msdyn_description;
        private String msdyn_sdkmessagename;
        private String msdyn_owner;
        private String msdyn_objectid;
        private String msdyn_uniquename;
        private String msdyn_version;
        private String msdyn_synctoexternalsearchindex;
        private String msdyn_componentlogicalname;
        private String msdyn_statusname;
        private String msdyn_publickeytoken;
        private String msdyn_iscustomizable;
        private BigDecimal msdyn_total;
        private String msdyn_executionorder;
        private String msdyn_schemaname;
        private String msdyn_culture;
        private String msdyn_componenttypename;
        private String msdyn_createdon;
        private String msdyn_status;
        private String msdyn_workflowcategory;
        private String msdyn_ismanagedname;
        private String msdyn_workflowcategoryname;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder msdyn_connectorinternalid(String msdyn_connectorinternalid) {
            this.msdyn_connectorinternalid = msdyn_connectorinternalid;
            this.changedFields = changedFields.add("msdyn_connectorinternalid");
            return this;
        }

        public Builder msdyn_isolationmode(String msdyn_isolationmode) {
            this.msdyn_isolationmode = msdyn_isolationmode;
            this.changedFields = changedFields.add("msdyn_isolationmode");
            return this;
        }

        public Builder msdyn_subtype(String msdyn_subtype) {
            this.msdyn_subtype = msdyn_subtype;
            this.changedFields = changedFields.add("msdyn_subtype");
            return this;
        }

        public Builder msdyn_iscustomizablename(String msdyn_iscustomizablename) {
            this.msdyn_iscustomizablename = msdyn_iscustomizablename;
            this.changedFields = changedFields.add("msdyn_iscustomizablename");
            return this;
        }

        public Builder msdyn_deployment(String msdyn_deployment) {
            this.msdyn_deployment = msdyn_deployment;
            this.changedFields = changedFields.add("msdyn_deployment");
            return this;
        }

        public Builder msdyn_logicalcollectionname(String msdyn_logicalcollectionname) {
            this.msdyn_logicalcollectionname = msdyn_logicalcollectionname;
            this.changedFields = changedFields.add("msdyn_logicalcollectionname");
            return this;
        }

        public Builder msdyn_componenttype(BigDecimal msdyn_componenttype) {
            this.msdyn_componenttype = msdyn_componenttype;
            this.changedFields = changedFields.add("msdyn_componenttype");
            return this;
        }

        public Builder msdyn_relatedentity(String msdyn_relatedentity) {
            this.msdyn_relatedentity = msdyn_relatedentity;
            this.changedFields = changedFields.add("msdyn_relatedentity");
            return this;
        }

        public Builder msdyn_istableenabled(String msdyn_istableenabled) {
            this.msdyn_istableenabled = msdyn_istableenabled;
            this.changedFields = changedFields.add("msdyn_istableenabled");
            return this;
        }

        public Builder msdyn_primaryentityname(String msdyn_primaryentityname) {
            this.msdyn_primaryentityname = msdyn_primaryentityname;
            this.changedFields = changedFields.add("msdyn_primaryentityname");
            return this;
        }

        public Builder msdyn_ismanaged(String msdyn_ismanaged) {
            this.msdyn_ismanaged = msdyn_ismanaged;
            this.changedFields = changedFields.add("msdyn_ismanaged");
            return this;
        }

        public Builder msdyn_isdefault(String msdyn_isdefault) {
            this.msdyn_isdefault = msdyn_isdefault;
            this.changedFields = changedFields.add("msdyn_isdefault");
            return this;
        }

        public Builder msdyn_solutioncomponentsummaryid(UUID msdyn_solutioncomponentsummaryid) {
            this.msdyn_solutioncomponentsummaryid = msdyn_solutioncomponentsummaryid;
            this.changedFields = changedFields.add("msdyn_solutioncomponentsummaryid");
            return this;
        }

        public Builder msdyn_name(String msdyn_name) {
            this.msdyn_name = msdyn_name;
            this.changedFields = changedFields.add("msdyn_name");
            return this;
        }

        public Builder organizationid(UUID organizationid) {
            this.organizationid = organizationid;
            this.changedFields = changedFields.add("organizationid");
            return this;
        }

        public Builder msdyn_modifiedon(String msdyn_modifiedon) {
            this.msdyn_modifiedon = msdyn_modifiedon;
            this.changedFields = changedFields.add("msdyn_modifiedon");
            return this;
        }

        public Builder msdyn_typename(String msdyn_typename) {
            this.msdyn_typename = msdyn_typename;
            this.changedFields = changedFields.add("msdyn_typename");
            return this;
        }

        public Builder msdyn_iscustom(String msdyn_iscustom) {
            this.msdyn_iscustom = msdyn_iscustom;
            this.changedFields = changedFields.add("msdyn_iscustom");
            return this;
        }

        public Builder msdyn_canvasappuniqueid(String msdyn_canvasappuniqueid) {
            this.msdyn_canvasappuniqueid = msdyn_canvasappuniqueid;
            this.changedFields = changedFields.add("msdyn_canvasappuniqueid");
            return this;
        }

        public Builder msdyn_owningbusinessunit(String msdyn_owningbusinessunit) {
            this.msdyn_owningbusinessunit = msdyn_owningbusinessunit;
            this.changedFields = changedFields.add("msdyn_owningbusinessunit");
            return this;
        }

        public Builder msdyn_isappawarename(String msdyn_isappawarename) {
            this.msdyn_isappawarename = msdyn_isappawarename;
            this.changedFields = changedFields.add("msdyn_isappawarename");
            return this;
        }

        public Builder msdyn_executionstage(String msdyn_executionstage) {
            this.msdyn_executionstage = msdyn_executionstage;
            this.changedFields = changedFields.add("msdyn_executionstage");
            return this;
        }

        public Builder msdyn_iscustomname(String msdyn_iscustomname) {
            this.msdyn_iscustomname = msdyn_iscustomname;
            this.changedFields = changedFields.add("msdyn_iscustomname");
            return this;
        }

        public Builder msdyn_fieldtype(String msdyn_fieldtype) {
            this.msdyn_fieldtype = msdyn_fieldtype;
            this.changedFields = changedFields.add("msdyn_fieldtype");
            return this;
        }

        public Builder msdyn_isappaware(String msdyn_isappaware) {
            this.msdyn_isappaware = msdyn_isappaware;
            this.changedFields = changedFields.add("msdyn_isappaware");
            return this;
        }

        public Builder msdyn_displayname(String msdyn_displayname) {
            this.msdyn_displayname = msdyn_displayname;
            this.changedFields = changedFields.add("msdyn_displayname");
            return this;
        }

        public Builder msdyn_isauditenabledname(String msdyn_isauditenabledname) {
            this.msdyn_isauditenabledname = msdyn_isauditenabledname;
            this.changedFields = changedFields.add("msdyn_isauditenabledname");
            return this;
        }

        public Builder msdyn_eventhandler(String msdyn_eventhandler) {
            this.msdyn_eventhandler = msdyn_eventhandler;
            this.changedFields = changedFields.add("msdyn_eventhandler");
            return this;
        }

        public Builder msdyn_workflowidunique(String msdyn_workflowidunique) {
            this.msdyn_workflowidunique = msdyn_workflowidunique;
            this.changedFields = changedFields.add("msdyn_workflowidunique");
            return this;
        }

        public Builder msdyn_isdefaultname(String msdyn_isdefaultname) {
            this.msdyn_isdefaultname = msdyn_isdefaultname;
            this.changedFields = changedFields.add("msdyn_isdefaultname");
            return this;
        }

        public Builder msdyn_objecttypecode(String msdyn_objecttypecode) {
            this.msdyn_objecttypecode = msdyn_objecttypecode;
            this.changedFields = changedFields.add("msdyn_objecttypecode");
            return this;
        }

        public Builder msdyn_solutionid(String msdyn_solutionid) {
            this.msdyn_solutionid = msdyn_solutionid;
            this.changedFields = changedFields.add("msdyn_solutionid");
            return this;
        }

        public Builder msdyn_isauditenabled(String msdyn_isauditenabled) {
            this.msdyn_isauditenabled = msdyn_isauditenabled;
            this.changedFields = changedFields.add("msdyn_isauditenabled");
            return this;
        }

        public Builder msdyn_relatedentityattribute(String msdyn_relatedentityattribute) {
            this.msdyn_relatedentityattribute = msdyn_relatedentityattribute;
            this.changedFields = changedFields.add("msdyn_relatedentityattribute");
            return this;
        }

        public Builder msdyn_fieldsecurity(String msdyn_fieldsecurity) {
            this.msdyn_fieldsecurity = msdyn_fieldsecurity;
            this.changedFields = changedFields.add("msdyn_fieldsecurity");
            return this;
        }

        public Builder msdyn_description(String msdyn_description) {
            this.msdyn_description = msdyn_description;
            this.changedFields = changedFields.add("msdyn_description");
            return this;
        }

        public Builder msdyn_sdkmessagename(String msdyn_sdkmessagename) {
            this.msdyn_sdkmessagename = msdyn_sdkmessagename;
            this.changedFields = changedFields.add("msdyn_sdkmessagename");
            return this;
        }

        public Builder msdyn_owner(String msdyn_owner) {
            this.msdyn_owner = msdyn_owner;
            this.changedFields = changedFields.add("msdyn_owner");
            return this;
        }

        public Builder msdyn_objectid(String msdyn_objectid) {
            this.msdyn_objectid = msdyn_objectid;
            this.changedFields = changedFields.add("msdyn_objectid");
            return this;
        }

        public Builder msdyn_uniquename(String msdyn_uniquename) {
            this.msdyn_uniquename = msdyn_uniquename;
            this.changedFields = changedFields.add("msdyn_uniquename");
            return this;
        }

        public Builder msdyn_version(String msdyn_version) {
            this.msdyn_version = msdyn_version;
            this.changedFields = changedFields.add("msdyn_version");
            return this;
        }

        public Builder msdyn_synctoexternalsearchindex(String msdyn_synctoexternalsearchindex) {
            this.msdyn_synctoexternalsearchindex = msdyn_synctoexternalsearchindex;
            this.changedFields = changedFields.add("msdyn_synctoexternalsearchindex");
            return this;
        }

        public Builder msdyn_componentlogicalname(String msdyn_componentlogicalname) {
            this.msdyn_componentlogicalname = msdyn_componentlogicalname;
            this.changedFields = changedFields.add("msdyn_componentlogicalname");
            return this;
        }

        public Builder msdyn_statusname(String msdyn_statusname) {
            this.msdyn_statusname = msdyn_statusname;
            this.changedFields = changedFields.add("msdyn_statusname");
            return this;
        }

        public Builder msdyn_publickeytoken(String msdyn_publickeytoken) {
            this.msdyn_publickeytoken = msdyn_publickeytoken;
            this.changedFields = changedFields.add("msdyn_publickeytoken");
            return this;
        }

        public Builder msdyn_iscustomizable(String msdyn_iscustomizable) {
            this.msdyn_iscustomizable = msdyn_iscustomizable;
            this.changedFields = changedFields.add("msdyn_iscustomizable");
            return this;
        }

        public Builder msdyn_total(BigDecimal msdyn_total) {
            this.msdyn_total = msdyn_total;
            this.changedFields = changedFields.add("msdyn_total");
            return this;
        }

        public Builder msdyn_executionorder(String msdyn_executionorder) {
            this.msdyn_executionorder = msdyn_executionorder;
            this.changedFields = changedFields.add("msdyn_executionorder");
            return this;
        }

        public Builder msdyn_schemaname(String msdyn_schemaname) {
            this.msdyn_schemaname = msdyn_schemaname;
            this.changedFields = changedFields.add("msdyn_schemaname");
            return this;
        }

        public Builder msdyn_culture(String msdyn_culture) {
            this.msdyn_culture = msdyn_culture;
            this.changedFields = changedFields.add("msdyn_culture");
            return this;
        }

        public Builder msdyn_componenttypename(String msdyn_componenttypename) {
            this.msdyn_componenttypename = msdyn_componenttypename;
            this.changedFields = changedFields.add("msdyn_componenttypename");
            return this;
        }

        public Builder msdyn_createdon(String msdyn_createdon) {
            this.msdyn_createdon = msdyn_createdon;
            this.changedFields = changedFields.add("msdyn_createdon");
            return this;
        }

        public Builder msdyn_status(String msdyn_status) {
            this.msdyn_status = msdyn_status;
            this.changedFields = changedFields.add("msdyn_status");
            return this;
        }

        public Builder msdyn_workflowcategory(String msdyn_workflowcategory) {
            this.msdyn_workflowcategory = msdyn_workflowcategory;
            this.changedFields = changedFields.add("msdyn_workflowcategory");
            return this;
        }

        public Builder msdyn_ismanagedname(String msdyn_ismanagedname) {
            this.msdyn_ismanagedname = msdyn_ismanagedname;
            this.changedFields = changedFields.add("msdyn_ismanagedname");
            return this;
        }

        public Builder msdyn_workflowcategoryname(String msdyn_workflowcategoryname) {
            this.msdyn_workflowcategoryname = msdyn_workflowcategoryname;
            this.changedFields = changedFields.add("msdyn_workflowcategoryname");
            return this;
        }

        public Msdyn_solutioncomponentsummary build() {
            Msdyn_solutioncomponentsummary _x = new Msdyn_solutioncomponentsummary();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.msdyn_solutioncomponentsummary";
            _x.msdyn_connectorinternalid = msdyn_connectorinternalid;
            _x.msdyn_isolationmode = msdyn_isolationmode;
            _x.msdyn_subtype = msdyn_subtype;
            _x.msdyn_iscustomizablename = msdyn_iscustomizablename;
            _x.msdyn_deployment = msdyn_deployment;
            _x.msdyn_logicalcollectionname = msdyn_logicalcollectionname;
            _x.msdyn_componenttype = msdyn_componenttype;
            _x.msdyn_relatedentity = msdyn_relatedentity;
            _x.msdyn_istableenabled = msdyn_istableenabled;
            _x.msdyn_primaryentityname = msdyn_primaryentityname;
            _x.msdyn_ismanaged = msdyn_ismanaged;
            _x.msdyn_isdefault = msdyn_isdefault;
            _x.msdyn_solutioncomponentsummaryid = msdyn_solutioncomponentsummaryid;
            _x.msdyn_name = msdyn_name;
            _x.organizationid = organizationid;
            _x.msdyn_modifiedon = msdyn_modifiedon;
            _x.msdyn_typename = msdyn_typename;
            _x.msdyn_iscustom = msdyn_iscustom;
            _x.msdyn_canvasappuniqueid = msdyn_canvasappuniqueid;
            _x.msdyn_owningbusinessunit = msdyn_owningbusinessunit;
            _x.msdyn_isappawarename = msdyn_isappawarename;
            _x.msdyn_executionstage = msdyn_executionstage;
            _x.msdyn_iscustomname = msdyn_iscustomname;
            _x.msdyn_fieldtype = msdyn_fieldtype;
            _x.msdyn_isappaware = msdyn_isappaware;
            _x.msdyn_displayname = msdyn_displayname;
            _x.msdyn_isauditenabledname = msdyn_isauditenabledname;
            _x.msdyn_eventhandler = msdyn_eventhandler;
            _x.msdyn_workflowidunique = msdyn_workflowidunique;
            _x.msdyn_isdefaultname = msdyn_isdefaultname;
            _x.msdyn_objecttypecode = msdyn_objecttypecode;
            _x.msdyn_solutionid = msdyn_solutionid;
            _x.msdyn_isauditenabled = msdyn_isauditenabled;
            _x.msdyn_relatedentityattribute = msdyn_relatedentityattribute;
            _x.msdyn_fieldsecurity = msdyn_fieldsecurity;
            _x.msdyn_description = msdyn_description;
            _x.msdyn_sdkmessagename = msdyn_sdkmessagename;
            _x.msdyn_owner = msdyn_owner;
            _x.msdyn_objectid = msdyn_objectid;
            _x.msdyn_uniquename = msdyn_uniquename;
            _x.msdyn_version = msdyn_version;
            _x.msdyn_synctoexternalsearchindex = msdyn_synctoexternalsearchindex;
            _x.msdyn_componentlogicalname = msdyn_componentlogicalname;
            _x.msdyn_statusname = msdyn_statusname;
            _x.msdyn_publickeytoken = msdyn_publickeytoken;
            _x.msdyn_iscustomizable = msdyn_iscustomizable;
            _x.msdyn_total = msdyn_total;
            _x.msdyn_executionorder = msdyn_executionorder;
            _x.msdyn_schemaname = msdyn_schemaname;
            _x.msdyn_culture = msdyn_culture;
            _x.msdyn_componenttypename = msdyn_componenttypename;
            _x.msdyn_createdon = msdyn_createdon;
            _x.msdyn_status = msdyn_status;
            _x.msdyn_workflowcategory = msdyn_workflowcategory;
            _x.msdyn_ismanagedname = msdyn_ismanagedname;
            _x.msdyn_workflowcategoryname = msdyn_workflowcategoryname;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && msdyn_solutioncomponentsummaryid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(msdyn_solutioncomponentsummaryid, UUID.class));
        }
    }

    @Property(name="msdyn_connectorinternalid")
    @JsonIgnore
    public Optional<String> getMsdyn_connectorinternalid() {
        return Optional.ofNullable(msdyn_connectorinternalid);
    }

    public Msdyn_solutioncomponentsummary withMsdyn_connectorinternalid(String msdyn_connectorinternalid) {
        Checks.checkIsAscii(msdyn_connectorinternalid);
        Msdyn_solutioncomponentsummary _x = _copy();
        _x.changedFields = changedFields.add("msdyn_connectorinternalid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutioncomponentsummary");
        _x.msdyn_connectorinternalid = msdyn_connectorinternalid;
        return _x;
    }

    @Property(name="msdyn_isolationmode")
    @JsonIgnore
    public Optional<String> getMsdyn_isolationmode() {
        return Optional.ofNullable(msdyn_isolationmode);
    }

    public Msdyn_solutioncomponentsummary withMsdyn_isolationmode(String msdyn_isolationmode) {
        Checks.checkIsAscii(msdyn_isolationmode);
        Msdyn_solutioncomponentsummary _x = _copy();
        _x.changedFields = changedFields.add("msdyn_isolationmode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutioncomponentsummary");
        _x.msdyn_isolationmode = msdyn_isolationmode;
        return _x;
    }

    @Property(name="msdyn_subtype")
    @JsonIgnore
    public Optional<String> getMsdyn_subtype() {
        return Optional.ofNullable(msdyn_subtype);
    }

    public Msdyn_solutioncomponentsummary withMsdyn_subtype(String msdyn_subtype) {
        Checks.checkIsAscii(msdyn_subtype);
        Msdyn_solutioncomponentsummary _x = _copy();
        _x.changedFields = changedFields.add("msdyn_subtype");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutioncomponentsummary");
        _x.msdyn_subtype = msdyn_subtype;
        return _x;
    }

    @Property(name="msdyn_iscustomizablename")
    @JsonIgnore
    public Optional<String> getMsdyn_iscustomizablename() {
        return Optional.ofNullable(msdyn_iscustomizablename);
    }

    public Msdyn_solutioncomponentsummary withMsdyn_iscustomizablename(String msdyn_iscustomizablename) {
        Checks.checkIsAscii(msdyn_iscustomizablename);
        Msdyn_solutioncomponentsummary _x = _copy();
        _x.changedFields = changedFields.add("msdyn_iscustomizablename");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutioncomponentsummary");
        _x.msdyn_iscustomizablename = msdyn_iscustomizablename;
        return _x;
    }

    @Property(name="msdyn_deployment")
    @JsonIgnore
    public Optional<String> getMsdyn_deployment() {
        return Optional.ofNullable(msdyn_deployment);
    }

    public Msdyn_solutioncomponentsummary withMsdyn_deployment(String msdyn_deployment) {
        Checks.checkIsAscii(msdyn_deployment);
        Msdyn_solutioncomponentsummary _x = _copy();
        _x.changedFields = changedFields.add("msdyn_deployment");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutioncomponentsummary");
        _x.msdyn_deployment = msdyn_deployment;
        return _x;
    }

    @Property(name="msdyn_logicalcollectionname")
    @JsonIgnore
    public Optional<String> getMsdyn_logicalcollectionname() {
        return Optional.ofNullable(msdyn_logicalcollectionname);
    }

    public Msdyn_solutioncomponentsummary withMsdyn_logicalcollectionname(String msdyn_logicalcollectionname) {
        Checks.checkIsAscii(msdyn_logicalcollectionname);
        Msdyn_solutioncomponentsummary _x = _copy();
        _x.changedFields = changedFields.add("msdyn_logicalcollectionname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutioncomponentsummary");
        _x.msdyn_logicalcollectionname = msdyn_logicalcollectionname;
        return _x;
    }

    @Property(name="msdyn_componenttype")
    @JsonIgnore
    public Optional<BigDecimal> getMsdyn_componenttype() {
        return Optional.ofNullable(msdyn_componenttype);
    }

    public Msdyn_solutioncomponentsummary withMsdyn_componenttype(BigDecimal msdyn_componenttype) {
        Msdyn_solutioncomponentsummary _x = _copy();
        _x.changedFields = changedFields.add("msdyn_componenttype");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutioncomponentsummary");
        _x.msdyn_componenttype = msdyn_componenttype;
        return _x;
    }

    @Property(name="msdyn_relatedentity")
    @JsonIgnore
    public Optional<String> getMsdyn_relatedentity() {
        return Optional.ofNullable(msdyn_relatedentity);
    }

    public Msdyn_solutioncomponentsummary withMsdyn_relatedentity(String msdyn_relatedentity) {
        Checks.checkIsAscii(msdyn_relatedentity);
        Msdyn_solutioncomponentsummary _x = _copy();
        _x.changedFields = changedFields.add("msdyn_relatedentity");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutioncomponentsummary");
        _x.msdyn_relatedentity = msdyn_relatedentity;
        return _x;
    }

    @Property(name="msdyn_istableenabled")
    @JsonIgnore
    public Optional<String> getMsdyn_istableenabled() {
        return Optional.ofNullable(msdyn_istableenabled);
    }

    public Msdyn_solutioncomponentsummary withMsdyn_istableenabled(String msdyn_istableenabled) {
        Checks.checkIsAscii(msdyn_istableenabled);
        Msdyn_solutioncomponentsummary _x = _copy();
        _x.changedFields = changedFields.add("msdyn_istableenabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutioncomponentsummary");
        _x.msdyn_istableenabled = msdyn_istableenabled;
        return _x;
    }

    @Property(name="msdyn_primaryentityname")
    @JsonIgnore
    public Optional<String> getMsdyn_primaryentityname() {
        return Optional.ofNullable(msdyn_primaryentityname);
    }

    public Msdyn_solutioncomponentsummary withMsdyn_primaryentityname(String msdyn_primaryentityname) {
        Checks.checkIsAscii(msdyn_primaryentityname);
        Msdyn_solutioncomponentsummary _x = _copy();
        _x.changedFields = changedFields.add("msdyn_primaryentityname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutioncomponentsummary");
        _x.msdyn_primaryentityname = msdyn_primaryentityname;
        return _x;
    }

    @Property(name="msdyn_ismanaged")
    @JsonIgnore
    public Optional<String> getMsdyn_ismanaged() {
        return Optional.ofNullable(msdyn_ismanaged);
    }

    public Msdyn_solutioncomponentsummary withMsdyn_ismanaged(String msdyn_ismanaged) {
        Checks.checkIsAscii(msdyn_ismanaged);
        Msdyn_solutioncomponentsummary _x = _copy();
        _x.changedFields = changedFields.add("msdyn_ismanaged");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutioncomponentsummary");
        _x.msdyn_ismanaged = msdyn_ismanaged;
        return _x;
    }

    @Property(name="msdyn_isdefault")
    @JsonIgnore
    public Optional<String> getMsdyn_isdefault() {
        return Optional.ofNullable(msdyn_isdefault);
    }

    public Msdyn_solutioncomponentsummary withMsdyn_isdefault(String msdyn_isdefault) {
        Checks.checkIsAscii(msdyn_isdefault);
        Msdyn_solutioncomponentsummary _x = _copy();
        _x.changedFields = changedFields.add("msdyn_isdefault");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutioncomponentsummary");
        _x.msdyn_isdefault = msdyn_isdefault;
        return _x;
    }

    @Property(name="msdyn_solutioncomponentsummaryid")
    @JsonIgnore
    public Optional<UUID> getMsdyn_solutioncomponentsummaryid() {
        return Optional.ofNullable(msdyn_solutioncomponentsummaryid);
    }

    public Msdyn_solutioncomponentsummary withMsdyn_solutioncomponentsummaryid(UUID msdyn_solutioncomponentsummaryid) {
        Msdyn_solutioncomponentsummary _x = _copy();
        _x.changedFields = changedFields.add("msdyn_solutioncomponentsummaryid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutioncomponentsummary");
        _x.msdyn_solutioncomponentsummaryid = msdyn_solutioncomponentsummaryid;
        return _x;
    }

    @Property(name="msdyn_name")
    @JsonIgnore
    public Optional<String> getMsdyn_name() {
        return Optional.ofNullable(msdyn_name);
    }

    public Msdyn_solutioncomponentsummary withMsdyn_name(String msdyn_name) {
        Checks.checkIsAscii(msdyn_name);
        Msdyn_solutioncomponentsummary _x = _copy();
        _x.changedFields = changedFields.add("msdyn_name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutioncomponentsummary");
        _x.msdyn_name = msdyn_name;
        return _x;
    }

    @Property(name="organizationid")
    @JsonIgnore
    public Optional<UUID> getOrganizationid() {
        return Optional.ofNullable(organizationid);
    }

    public Msdyn_solutioncomponentsummary withOrganizationid(UUID organizationid) {
        Msdyn_solutioncomponentsummary _x = _copy();
        _x.changedFields = changedFields.add("organizationid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutioncomponentsummary");
        _x.organizationid = organizationid;
        return _x;
    }

    @Property(name="msdyn_modifiedon")
    @JsonIgnore
    public Optional<String> getMsdyn_modifiedon() {
        return Optional.ofNullable(msdyn_modifiedon);
    }

    public Msdyn_solutioncomponentsummary withMsdyn_modifiedon(String msdyn_modifiedon) {
        Checks.checkIsAscii(msdyn_modifiedon);
        Msdyn_solutioncomponentsummary _x = _copy();
        _x.changedFields = changedFields.add("msdyn_modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutioncomponentsummary");
        _x.msdyn_modifiedon = msdyn_modifiedon;
        return _x;
    }

    @Property(name="msdyn_typename")
    @JsonIgnore
    public Optional<String> getMsdyn_typename() {
        return Optional.ofNullable(msdyn_typename);
    }

    public Msdyn_solutioncomponentsummary withMsdyn_typename(String msdyn_typename) {
        Checks.checkIsAscii(msdyn_typename);
        Msdyn_solutioncomponentsummary _x = _copy();
        _x.changedFields = changedFields.add("msdyn_typename");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutioncomponentsummary");
        _x.msdyn_typename = msdyn_typename;
        return _x;
    }

    @Property(name="msdyn_iscustom")
    @JsonIgnore
    public Optional<String> getMsdyn_iscustom() {
        return Optional.ofNullable(msdyn_iscustom);
    }

    public Msdyn_solutioncomponentsummary withMsdyn_iscustom(String msdyn_iscustom) {
        Checks.checkIsAscii(msdyn_iscustom);
        Msdyn_solutioncomponentsummary _x = _copy();
        _x.changedFields = changedFields.add("msdyn_iscustom");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutioncomponentsummary");
        _x.msdyn_iscustom = msdyn_iscustom;
        return _x;
    }

    @Property(name="msdyn_canvasappuniqueid")
    @JsonIgnore
    public Optional<String> getMsdyn_canvasappuniqueid() {
        return Optional.ofNullable(msdyn_canvasappuniqueid);
    }

    public Msdyn_solutioncomponentsummary withMsdyn_canvasappuniqueid(String msdyn_canvasappuniqueid) {
        Checks.checkIsAscii(msdyn_canvasappuniqueid);
        Msdyn_solutioncomponentsummary _x = _copy();
        _x.changedFields = changedFields.add("msdyn_canvasappuniqueid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutioncomponentsummary");
        _x.msdyn_canvasappuniqueid = msdyn_canvasappuniqueid;
        return _x;
    }

    @Property(name="msdyn_owningbusinessunit")
    @JsonIgnore
    public Optional<String> getMsdyn_owningbusinessunit() {
        return Optional.ofNullable(msdyn_owningbusinessunit);
    }

    public Msdyn_solutioncomponentsummary withMsdyn_owningbusinessunit(String msdyn_owningbusinessunit) {
        Checks.checkIsAscii(msdyn_owningbusinessunit);
        Msdyn_solutioncomponentsummary _x = _copy();
        _x.changedFields = changedFields.add("msdyn_owningbusinessunit");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutioncomponentsummary");
        _x.msdyn_owningbusinessunit = msdyn_owningbusinessunit;
        return _x;
    }

    @Property(name="msdyn_isappawarename")
    @JsonIgnore
    public Optional<String> getMsdyn_isappawarename() {
        return Optional.ofNullable(msdyn_isappawarename);
    }

    public Msdyn_solutioncomponentsummary withMsdyn_isappawarename(String msdyn_isappawarename) {
        Checks.checkIsAscii(msdyn_isappawarename);
        Msdyn_solutioncomponentsummary _x = _copy();
        _x.changedFields = changedFields.add("msdyn_isappawarename");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutioncomponentsummary");
        _x.msdyn_isappawarename = msdyn_isappawarename;
        return _x;
    }

    @Property(name="msdyn_executionstage")
    @JsonIgnore
    public Optional<String> getMsdyn_executionstage() {
        return Optional.ofNullable(msdyn_executionstage);
    }

    public Msdyn_solutioncomponentsummary withMsdyn_executionstage(String msdyn_executionstage) {
        Checks.checkIsAscii(msdyn_executionstage);
        Msdyn_solutioncomponentsummary _x = _copy();
        _x.changedFields = changedFields.add("msdyn_executionstage");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutioncomponentsummary");
        _x.msdyn_executionstage = msdyn_executionstage;
        return _x;
    }

    @Property(name="msdyn_iscustomname")
    @JsonIgnore
    public Optional<String> getMsdyn_iscustomname() {
        return Optional.ofNullable(msdyn_iscustomname);
    }

    public Msdyn_solutioncomponentsummary withMsdyn_iscustomname(String msdyn_iscustomname) {
        Checks.checkIsAscii(msdyn_iscustomname);
        Msdyn_solutioncomponentsummary _x = _copy();
        _x.changedFields = changedFields.add("msdyn_iscustomname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutioncomponentsummary");
        _x.msdyn_iscustomname = msdyn_iscustomname;
        return _x;
    }

    @Property(name="msdyn_fieldtype")
    @JsonIgnore
    public Optional<String> getMsdyn_fieldtype() {
        return Optional.ofNullable(msdyn_fieldtype);
    }

    public Msdyn_solutioncomponentsummary withMsdyn_fieldtype(String msdyn_fieldtype) {
        Checks.checkIsAscii(msdyn_fieldtype);
        Msdyn_solutioncomponentsummary _x = _copy();
        _x.changedFields = changedFields.add("msdyn_fieldtype");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutioncomponentsummary");
        _x.msdyn_fieldtype = msdyn_fieldtype;
        return _x;
    }

    @Property(name="msdyn_isappaware")
    @JsonIgnore
    public Optional<String> getMsdyn_isappaware() {
        return Optional.ofNullable(msdyn_isappaware);
    }

    public Msdyn_solutioncomponentsummary withMsdyn_isappaware(String msdyn_isappaware) {
        Checks.checkIsAscii(msdyn_isappaware);
        Msdyn_solutioncomponentsummary _x = _copy();
        _x.changedFields = changedFields.add("msdyn_isappaware");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutioncomponentsummary");
        _x.msdyn_isappaware = msdyn_isappaware;
        return _x;
    }

    @Property(name="msdyn_displayname")
    @JsonIgnore
    public Optional<String> getMsdyn_displayname() {
        return Optional.ofNullable(msdyn_displayname);
    }

    public Msdyn_solutioncomponentsummary withMsdyn_displayname(String msdyn_displayname) {
        Checks.checkIsAscii(msdyn_displayname);
        Msdyn_solutioncomponentsummary _x = _copy();
        _x.changedFields = changedFields.add("msdyn_displayname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutioncomponentsummary");
        _x.msdyn_displayname = msdyn_displayname;
        return _x;
    }

    @Property(name="msdyn_isauditenabledname")
    @JsonIgnore
    public Optional<String> getMsdyn_isauditenabledname() {
        return Optional.ofNullable(msdyn_isauditenabledname);
    }

    public Msdyn_solutioncomponentsummary withMsdyn_isauditenabledname(String msdyn_isauditenabledname) {
        Checks.checkIsAscii(msdyn_isauditenabledname);
        Msdyn_solutioncomponentsummary _x = _copy();
        _x.changedFields = changedFields.add("msdyn_isauditenabledname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutioncomponentsummary");
        _x.msdyn_isauditenabledname = msdyn_isauditenabledname;
        return _x;
    }

    @Property(name="msdyn_eventhandler")
    @JsonIgnore
    public Optional<String> getMsdyn_eventhandler() {
        return Optional.ofNullable(msdyn_eventhandler);
    }

    public Msdyn_solutioncomponentsummary withMsdyn_eventhandler(String msdyn_eventhandler) {
        Checks.checkIsAscii(msdyn_eventhandler);
        Msdyn_solutioncomponentsummary _x = _copy();
        _x.changedFields = changedFields.add("msdyn_eventhandler");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutioncomponentsummary");
        _x.msdyn_eventhandler = msdyn_eventhandler;
        return _x;
    }

    @Property(name="msdyn_workflowidunique")
    @JsonIgnore
    public Optional<String> getMsdyn_workflowidunique() {
        return Optional.ofNullable(msdyn_workflowidunique);
    }

    public Msdyn_solutioncomponentsummary withMsdyn_workflowidunique(String msdyn_workflowidunique) {
        Checks.checkIsAscii(msdyn_workflowidunique);
        Msdyn_solutioncomponentsummary _x = _copy();
        _x.changedFields = changedFields.add("msdyn_workflowidunique");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutioncomponentsummary");
        _x.msdyn_workflowidunique = msdyn_workflowidunique;
        return _x;
    }

    @Property(name="msdyn_isdefaultname")
    @JsonIgnore
    public Optional<String> getMsdyn_isdefaultname() {
        return Optional.ofNullable(msdyn_isdefaultname);
    }

    public Msdyn_solutioncomponentsummary withMsdyn_isdefaultname(String msdyn_isdefaultname) {
        Checks.checkIsAscii(msdyn_isdefaultname);
        Msdyn_solutioncomponentsummary _x = _copy();
        _x.changedFields = changedFields.add("msdyn_isdefaultname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutioncomponentsummary");
        _x.msdyn_isdefaultname = msdyn_isdefaultname;
        return _x;
    }

    @Property(name="msdyn_objecttypecode")
    @JsonIgnore
    public Optional<String> getMsdyn_objecttypecode() {
        return Optional.ofNullable(msdyn_objecttypecode);
    }

    public Msdyn_solutioncomponentsummary withMsdyn_objecttypecode(String msdyn_objecttypecode) {
        Checks.checkIsAscii(msdyn_objecttypecode);
        Msdyn_solutioncomponentsummary _x = _copy();
        _x.changedFields = changedFields.add("msdyn_objecttypecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutioncomponentsummary");
        _x.msdyn_objecttypecode = msdyn_objecttypecode;
        return _x;
    }

    @Property(name="msdyn_solutionid")
    @JsonIgnore
    public Optional<String> getMsdyn_solutionid() {
        return Optional.ofNullable(msdyn_solutionid);
    }

    public Msdyn_solutioncomponentsummary withMsdyn_solutionid(String msdyn_solutionid) {
        Checks.checkIsAscii(msdyn_solutionid);
        Msdyn_solutioncomponentsummary _x = _copy();
        _x.changedFields = changedFields.add("msdyn_solutionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutioncomponentsummary");
        _x.msdyn_solutionid = msdyn_solutionid;
        return _x;
    }

    @Property(name="msdyn_isauditenabled")
    @JsonIgnore
    public Optional<String> getMsdyn_isauditenabled() {
        return Optional.ofNullable(msdyn_isauditenabled);
    }

    public Msdyn_solutioncomponentsummary withMsdyn_isauditenabled(String msdyn_isauditenabled) {
        Checks.checkIsAscii(msdyn_isauditenabled);
        Msdyn_solutioncomponentsummary _x = _copy();
        _x.changedFields = changedFields.add("msdyn_isauditenabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutioncomponentsummary");
        _x.msdyn_isauditenabled = msdyn_isauditenabled;
        return _x;
    }

    @Property(name="msdyn_relatedentityattribute")
    @JsonIgnore
    public Optional<String> getMsdyn_relatedentityattribute() {
        return Optional.ofNullable(msdyn_relatedentityattribute);
    }

    public Msdyn_solutioncomponentsummary withMsdyn_relatedentityattribute(String msdyn_relatedentityattribute) {
        Checks.checkIsAscii(msdyn_relatedentityattribute);
        Msdyn_solutioncomponentsummary _x = _copy();
        _x.changedFields = changedFields.add("msdyn_relatedentityattribute");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutioncomponentsummary");
        _x.msdyn_relatedentityattribute = msdyn_relatedentityattribute;
        return _x;
    }

    @Property(name="msdyn_fieldsecurity")
    @JsonIgnore
    public Optional<String> getMsdyn_fieldsecurity() {
        return Optional.ofNullable(msdyn_fieldsecurity);
    }

    public Msdyn_solutioncomponentsummary withMsdyn_fieldsecurity(String msdyn_fieldsecurity) {
        Checks.checkIsAscii(msdyn_fieldsecurity);
        Msdyn_solutioncomponentsummary _x = _copy();
        _x.changedFields = changedFields.add("msdyn_fieldsecurity");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutioncomponentsummary");
        _x.msdyn_fieldsecurity = msdyn_fieldsecurity;
        return _x;
    }

    @Property(name="msdyn_description")
    @JsonIgnore
    public Optional<String> getMsdyn_description() {
        return Optional.ofNullable(msdyn_description);
    }

    public Msdyn_solutioncomponentsummary withMsdyn_description(String msdyn_description) {
        Checks.checkIsAscii(msdyn_description);
        Msdyn_solutioncomponentsummary _x = _copy();
        _x.changedFields = changedFields.add("msdyn_description");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutioncomponentsummary");
        _x.msdyn_description = msdyn_description;
        return _x;
    }

    @Property(name="msdyn_sdkmessagename")
    @JsonIgnore
    public Optional<String> getMsdyn_sdkmessagename() {
        return Optional.ofNullable(msdyn_sdkmessagename);
    }

    public Msdyn_solutioncomponentsummary withMsdyn_sdkmessagename(String msdyn_sdkmessagename) {
        Checks.checkIsAscii(msdyn_sdkmessagename);
        Msdyn_solutioncomponentsummary _x = _copy();
        _x.changedFields = changedFields.add("msdyn_sdkmessagename");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutioncomponentsummary");
        _x.msdyn_sdkmessagename = msdyn_sdkmessagename;
        return _x;
    }

    @Property(name="msdyn_owner")
    @JsonIgnore
    public Optional<String> getMsdyn_owner() {
        return Optional.ofNullable(msdyn_owner);
    }

    public Msdyn_solutioncomponentsummary withMsdyn_owner(String msdyn_owner) {
        Checks.checkIsAscii(msdyn_owner);
        Msdyn_solutioncomponentsummary _x = _copy();
        _x.changedFields = changedFields.add("msdyn_owner");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutioncomponentsummary");
        _x.msdyn_owner = msdyn_owner;
        return _x;
    }

    @Property(name="msdyn_objectid")
    @JsonIgnore
    public Optional<String> getMsdyn_objectid() {
        return Optional.ofNullable(msdyn_objectid);
    }

    public Msdyn_solutioncomponentsummary withMsdyn_objectid(String msdyn_objectid) {
        Checks.checkIsAscii(msdyn_objectid);
        Msdyn_solutioncomponentsummary _x = _copy();
        _x.changedFields = changedFields.add("msdyn_objectid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutioncomponentsummary");
        _x.msdyn_objectid = msdyn_objectid;
        return _x;
    }

    @Property(name="msdyn_uniquename")
    @JsonIgnore
    public Optional<String> getMsdyn_uniquename() {
        return Optional.ofNullable(msdyn_uniquename);
    }

    public Msdyn_solutioncomponentsummary withMsdyn_uniquename(String msdyn_uniquename) {
        Checks.checkIsAscii(msdyn_uniquename);
        Msdyn_solutioncomponentsummary _x = _copy();
        _x.changedFields = changedFields.add("msdyn_uniquename");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutioncomponentsummary");
        _x.msdyn_uniquename = msdyn_uniquename;
        return _x;
    }

    @Property(name="msdyn_version")
    @JsonIgnore
    public Optional<String> getMsdyn_version() {
        return Optional.ofNullable(msdyn_version);
    }

    public Msdyn_solutioncomponentsummary withMsdyn_version(String msdyn_version) {
        Checks.checkIsAscii(msdyn_version);
        Msdyn_solutioncomponentsummary _x = _copy();
        _x.changedFields = changedFields.add("msdyn_version");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutioncomponentsummary");
        _x.msdyn_version = msdyn_version;
        return _x;
    }

    @Property(name="msdyn_synctoexternalsearchindex")
    @JsonIgnore
    public Optional<String> getMsdyn_synctoexternalsearchindex() {
        return Optional.ofNullable(msdyn_synctoexternalsearchindex);
    }

    public Msdyn_solutioncomponentsummary withMsdyn_synctoexternalsearchindex(String msdyn_synctoexternalsearchindex) {
        Checks.checkIsAscii(msdyn_synctoexternalsearchindex);
        Msdyn_solutioncomponentsummary _x = _copy();
        _x.changedFields = changedFields.add("msdyn_synctoexternalsearchindex");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutioncomponentsummary");
        _x.msdyn_synctoexternalsearchindex = msdyn_synctoexternalsearchindex;
        return _x;
    }

    @Property(name="msdyn_componentlogicalname")
    @JsonIgnore
    public Optional<String> getMsdyn_componentlogicalname() {
        return Optional.ofNullable(msdyn_componentlogicalname);
    }

    public Msdyn_solutioncomponentsummary withMsdyn_componentlogicalname(String msdyn_componentlogicalname) {
        Checks.checkIsAscii(msdyn_componentlogicalname);
        Msdyn_solutioncomponentsummary _x = _copy();
        _x.changedFields = changedFields.add("msdyn_componentlogicalname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutioncomponentsummary");
        _x.msdyn_componentlogicalname = msdyn_componentlogicalname;
        return _x;
    }

    @Property(name="msdyn_statusname")
    @JsonIgnore
    public Optional<String> getMsdyn_statusname() {
        return Optional.ofNullable(msdyn_statusname);
    }

    public Msdyn_solutioncomponentsummary withMsdyn_statusname(String msdyn_statusname) {
        Checks.checkIsAscii(msdyn_statusname);
        Msdyn_solutioncomponentsummary _x = _copy();
        _x.changedFields = changedFields.add("msdyn_statusname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutioncomponentsummary");
        _x.msdyn_statusname = msdyn_statusname;
        return _x;
    }

    @Property(name="msdyn_publickeytoken")
    @JsonIgnore
    public Optional<String> getMsdyn_publickeytoken() {
        return Optional.ofNullable(msdyn_publickeytoken);
    }

    public Msdyn_solutioncomponentsummary withMsdyn_publickeytoken(String msdyn_publickeytoken) {
        Checks.checkIsAscii(msdyn_publickeytoken);
        Msdyn_solutioncomponentsummary _x = _copy();
        _x.changedFields = changedFields.add("msdyn_publickeytoken");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutioncomponentsummary");
        _x.msdyn_publickeytoken = msdyn_publickeytoken;
        return _x;
    }

    @Property(name="msdyn_iscustomizable")
    @JsonIgnore
    public Optional<String> getMsdyn_iscustomizable() {
        return Optional.ofNullable(msdyn_iscustomizable);
    }

    public Msdyn_solutioncomponentsummary withMsdyn_iscustomizable(String msdyn_iscustomizable) {
        Checks.checkIsAscii(msdyn_iscustomizable);
        Msdyn_solutioncomponentsummary _x = _copy();
        _x.changedFields = changedFields.add("msdyn_iscustomizable");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutioncomponentsummary");
        _x.msdyn_iscustomizable = msdyn_iscustomizable;
        return _x;
    }

    @Property(name="msdyn_total")
    @JsonIgnore
    public Optional<BigDecimal> getMsdyn_total() {
        return Optional.ofNullable(msdyn_total);
    }

    public Msdyn_solutioncomponentsummary withMsdyn_total(BigDecimal msdyn_total) {
        Msdyn_solutioncomponentsummary _x = _copy();
        _x.changedFields = changedFields.add("msdyn_total");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutioncomponentsummary");
        _x.msdyn_total = msdyn_total;
        return _x;
    }

    @Property(name="msdyn_executionorder")
    @JsonIgnore
    public Optional<String> getMsdyn_executionorder() {
        return Optional.ofNullable(msdyn_executionorder);
    }

    public Msdyn_solutioncomponentsummary withMsdyn_executionorder(String msdyn_executionorder) {
        Checks.checkIsAscii(msdyn_executionorder);
        Msdyn_solutioncomponentsummary _x = _copy();
        _x.changedFields = changedFields.add("msdyn_executionorder");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutioncomponentsummary");
        _x.msdyn_executionorder = msdyn_executionorder;
        return _x;
    }

    @Property(name="msdyn_schemaname")
    @JsonIgnore
    public Optional<String> getMsdyn_schemaname() {
        return Optional.ofNullable(msdyn_schemaname);
    }

    public Msdyn_solutioncomponentsummary withMsdyn_schemaname(String msdyn_schemaname) {
        Checks.checkIsAscii(msdyn_schemaname);
        Msdyn_solutioncomponentsummary _x = _copy();
        _x.changedFields = changedFields.add("msdyn_schemaname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutioncomponentsummary");
        _x.msdyn_schemaname = msdyn_schemaname;
        return _x;
    }

    @Property(name="msdyn_culture")
    @JsonIgnore
    public Optional<String> getMsdyn_culture() {
        return Optional.ofNullable(msdyn_culture);
    }

    public Msdyn_solutioncomponentsummary withMsdyn_culture(String msdyn_culture) {
        Checks.checkIsAscii(msdyn_culture);
        Msdyn_solutioncomponentsummary _x = _copy();
        _x.changedFields = changedFields.add("msdyn_culture");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutioncomponentsummary");
        _x.msdyn_culture = msdyn_culture;
        return _x;
    }

    @Property(name="msdyn_componenttypename")
    @JsonIgnore
    public Optional<String> getMsdyn_componenttypename() {
        return Optional.ofNullable(msdyn_componenttypename);
    }

    public Msdyn_solutioncomponentsummary withMsdyn_componenttypename(String msdyn_componenttypename) {
        Checks.checkIsAscii(msdyn_componenttypename);
        Msdyn_solutioncomponentsummary _x = _copy();
        _x.changedFields = changedFields.add("msdyn_componenttypename");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutioncomponentsummary");
        _x.msdyn_componenttypename = msdyn_componenttypename;
        return _x;
    }

    @Property(name="msdyn_createdon")
    @JsonIgnore
    public Optional<String> getMsdyn_createdon() {
        return Optional.ofNullable(msdyn_createdon);
    }

    public Msdyn_solutioncomponentsummary withMsdyn_createdon(String msdyn_createdon) {
        Checks.checkIsAscii(msdyn_createdon);
        Msdyn_solutioncomponentsummary _x = _copy();
        _x.changedFields = changedFields.add("msdyn_createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutioncomponentsummary");
        _x.msdyn_createdon = msdyn_createdon;
        return _x;
    }

    @Property(name="msdyn_status")
    @JsonIgnore
    public Optional<String> getMsdyn_status() {
        return Optional.ofNullable(msdyn_status);
    }

    public Msdyn_solutioncomponentsummary withMsdyn_status(String msdyn_status) {
        Checks.checkIsAscii(msdyn_status);
        Msdyn_solutioncomponentsummary _x = _copy();
        _x.changedFields = changedFields.add("msdyn_status");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutioncomponentsummary");
        _x.msdyn_status = msdyn_status;
        return _x;
    }

    @Property(name="msdyn_workflowcategory")
    @JsonIgnore
    public Optional<String> getMsdyn_workflowcategory() {
        return Optional.ofNullable(msdyn_workflowcategory);
    }

    public Msdyn_solutioncomponentsummary withMsdyn_workflowcategory(String msdyn_workflowcategory) {
        Checks.checkIsAscii(msdyn_workflowcategory);
        Msdyn_solutioncomponentsummary _x = _copy();
        _x.changedFields = changedFields.add("msdyn_workflowcategory");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutioncomponentsummary");
        _x.msdyn_workflowcategory = msdyn_workflowcategory;
        return _x;
    }

    @Property(name="msdyn_ismanagedname")
    @JsonIgnore
    public Optional<String> getMsdyn_ismanagedname() {
        return Optional.ofNullable(msdyn_ismanagedname);
    }

    public Msdyn_solutioncomponentsummary withMsdyn_ismanagedname(String msdyn_ismanagedname) {
        Checks.checkIsAscii(msdyn_ismanagedname);
        Msdyn_solutioncomponentsummary _x = _copy();
        _x.changedFields = changedFields.add("msdyn_ismanagedname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutioncomponentsummary");
        _x.msdyn_ismanagedname = msdyn_ismanagedname;
        return _x;
    }

    @Property(name="msdyn_workflowcategoryname")
    @JsonIgnore
    public Optional<String> getMsdyn_workflowcategoryname() {
        return Optional.ofNullable(msdyn_workflowcategoryname);
    }

    public Msdyn_solutioncomponentsummary withMsdyn_workflowcategoryname(String msdyn_workflowcategoryname) {
        Checks.checkIsAscii(msdyn_workflowcategoryname);
        Msdyn_solutioncomponentsummary _x = _copy();
        _x.changedFields = changedFields.add("msdyn_workflowcategoryname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutioncomponentsummary");
        _x.msdyn_workflowcategoryname = msdyn_workflowcategoryname;
        return _x;
    }

    public Msdyn_solutioncomponentsummary withUnmappedField(String name, String value) {
        Msdyn_solutioncomponentsummary _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Msdyn_solutioncomponentsummary patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Msdyn_solutioncomponentsummary _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Msdyn_solutioncomponentsummary put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Msdyn_solutioncomponentsummary _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Msdyn_solutioncomponentsummary _copy() {
        Msdyn_solutioncomponentsummary _x = new Msdyn_solutioncomponentsummary();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.msdyn_connectorinternalid = msdyn_connectorinternalid;
        _x.msdyn_isolationmode = msdyn_isolationmode;
        _x.msdyn_subtype = msdyn_subtype;
        _x.msdyn_iscustomizablename = msdyn_iscustomizablename;
        _x.msdyn_deployment = msdyn_deployment;
        _x.msdyn_logicalcollectionname = msdyn_logicalcollectionname;
        _x.msdyn_componenttype = msdyn_componenttype;
        _x.msdyn_relatedentity = msdyn_relatedentity;
        _x.msdyn_istableenabled = msdyn_istableenabled;
        _x.msdyn_primaryentityname = msdyn_primaryentityname;
        _x.msdyn_ismanaged = msdyn_ismanaged;
        _x.msdyn_isdefault = msdyn_isdefault;
        _x.msdyn_solutioncomponentsummaryid = msdyn_solutioncomponentsummaryid;
        _x.msdyn_name = msdyn_name;
        _x.organizationid = organizationid;
        _x.msdyn_modifiedon = msdyn_modifiedon;
        _x.msdyn_typename = msdyn_typename;
        _x.msdyn_iscustom = msdyn_iscustom;
        _x.msdyn_canvasappuniqueid = msdyn_canvasappuniqueid;
        _x.msdyn_owningbusinessunit = msdyn_owningbusinessunit;
        _x.msdyn_isappawarename = msdyn_isappawarename;
        _x.msdyn_executionstage = msdyn_executionstage;
        _x.msdyn_iscustomname = msdyn_iscustomname;
        _x.msdyn_fieldtype = msdyn_fieldtype;
        _x.msdyn_isappaware = msdyn_isappaware;
        _x.msdyn_displayname = msdyn_displayname;
        _x.msdyn_isauditenabledname = msdyn_isauditenabledname;
        _x.msdyn_eventhandler = msdyn_eventhandler;
        _x.msdyn_workflowidunique = msdyn_workflowidunique;
        _x.msdyn_isdefaultname = msdyn_isdefaultname;
        _x.msdyn_objecttypecode = msdyn_objecttypecode;
        _x.msdyn_solutionid = msdyn_solutionid;
        _x.msdyn_isauditenabled = msdyn_isauditenabled;
        _x.msdyn_relatedentityattribute = msdyn_relatedentityattribute;
        _x.msdyn_fieldsecurity = msdyn_fieldsecurity;
        _x.msdyn_description = msdyn_description;
        _x.msdyn_sdkmessagename = msdyn_sdkmessagename;
        _x.msdyn_owner = msdyn_owner;
        _x.msdyn_objectid = msdyn_objectid;
        _x.msdyn_uniquename = msdyn_uniquename;
        _x.msdyn_version = msdyn_version;
        _x.msdyn_synctoexternalsearchindex = msdyn_synctoexternalsearchindex;
        _x.msdyn_componentlogicalname = msdyn_componentlogicalname;
        _x.msdyn_statusname = msdyn_statusname;
        _x.msdyn_publickeytoken = msdyn_publickeytoken;
        _x.msdyn_iscustomizable = msdyn_iscustomizable;
        _x.msdyn_total = msdyn_total;
        _x.msdyn_executionorder = msdyn_executionorder;
        _x.msdyn_schemaname = msdyn_schemaname;
        _x.msdyn_culture = msdyn_culture;
        _x.msdyn_componenttypename = msdyn_componenttypename;
        _x.msdyn_createdon = msdyn_createdon;
        _x.msdyn_status = msdyn_status;
        _x.msdyn_workflowcategory = msdyn_workflowcategory;
        _x.msdyn_ismanagedname = msdyn_ismanagedname;
        _x.msdyn_workflowcategoryname = msdyn_workflowcategoryname;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Msdyn_solutioncomponentsummary[");
        b.append("msdyn_connectorinternalid=");
        b.append(this.msdyn_connectorinternalid);
        b.append(", ");
        b.append("msdyn_isolationmode=");
        b.append(this.msdyn_isolationmode);
        b.append(", ");
        b.append("msdyn_subtype=");
        b.append(this.msdyn_subtype);
        b.append(", ");
        b.append("msdyn_iscustomizablename=");
        b.append(this.msdyn_iscustomizablename);
        b.append(", ");
        b.append("msdyn_deployment=");
        b.append(this.msdyn_deployment);
        b.append(", ");
        b.append("msdyn_logicalcollectionname=");
        b.append(this.msdyn_logicalcollectionname);
        b.append(", ");
        b.append("msdyn_componenttype=");
        b.append(this.msdyn_componenttype);
        b.append(", ");
        b.append("msdyn_relatedentity=");
        b.append(this.msdyn_relatedentity);
        b.append(", ");
        b.append("msdyn_istableenabled=");
        b.append(this.msdyn_istableenabled);
        b.append(", ");
        b.append("msdyn_primaryentityname=");
        b.append(this.msdyn_primaryentityname);
        b.append(", ");
        b.append("msdyn_ismanaged=");
        b.append(this.msdyn_ismanaged);
        b.append(", ");
        b.append("msdyn_isdefault=");
        b.append(this.msdyn_isdefault);
        b.append(", ");
        b.append("msdyn_solutioncomponentsummaryid=");
        b.append(this.msdyn_solutioncomponentsummaryid);
        b.append(", ");
        b.append("msdyn_name=");
        b.append(this.msdyn_name);
        b.append(", ");
        b.append("organizationid=");
        b.append(this.organizationid);
        b.append(", ");
        b.append("msdyn_modifiedon=");
        b.append(this.msdyn_modifiedon);
        b.append(", ");
        b.append("msdyn_typename=");
        b.append(this.msdyn_typename);
        b.append(", ");
        b.append("msdyn_iscustom=");
        b.append(this.msdyn_iscustom);
        b.append(", ");
        b.append("msdyn_canvasappuniqueid=");
        b.append(this.msdyn_canvasappuniqueid);
        b.append(", ");
        b.append("msdyn_owningbusinessunit=");
        b.append(this.msdyn_owningbusinessunit);
        b.append(", ");
        b.append("msdyn_isappawarename=");
        b.append(this.msdyn_isappawarename);
        b.append(", ");
        b.append("msdyn_executionstage=");
        b.append(this.msdyn_executionstage);
        b.append(", ");
        b.append("msdyn_iscustomname=");
        b.append(this.msdyn_iscustomname);
        b.append(", ");
        b.append("msdyn_fieldtype=");
        b.append(this.msdyn_fieldtype);
        b.append(", ");
        b.append("msdyn_isappaware=");
        b.append(this.msdyn_isappaware);
        b.append(", ");
        b.append("msdyn_displayname=");
        b.append(this.msdyn_displayname);
        b.append(", ");
        b.append("msdyn_isauditenabledname=");
        b.append(this.msdyn_isauditenabledname);
        b.append(", ");
        b.append("msdyn_eventhandler=");
        b.append(this.msdyn_eventhandler);
        b.append(", ");
        b.append("msdyn_workflowidunique=");
        b.append(this.msdyn_workflowidunique);
        b.append(", ");
        b.append("msdyn_isdefaultname=");
        b.append(this.msdyn_isdefaultname);
        b.append(", ");
        b.append("msdyn_objecttypecode=");
        b.append(this.msdyn_objecttypecode);
        b.append(", ");
        b.append("msdyn_solutionid=");
        b.append(this.msdyn_solutionid);
        b.append(", ");
        b.append("msdyn_isauditenabled=");
        b.append(this.msdyn_isauditenabled);
        b.append(", ");
        b.append("msdyn_relatedentityattribute=");
        b.append(this.msdyn_relatedentityattribute);
        b.append(", ");
        b.append("msdyn_fieldsecurity=");
        b.append(this.msdyn_fieldsecurity);
        b.append(", ");
        b.append("msdyn_description=");
        b.append(this.msdyn_description);
        b.append(", ");
        b.append("msdyn_sdkmessagename=");
        b.append(this.msdyn_sdkmessagename);
        b.append(", ");
        b.append("msdyn_owner=");
        b.append(this.msdyn_owner);
        b.append(", ");
        b.append("msdyn_objectid=");
        b.append(this.msdyn_objectid);
        b.append(", ");
        b.append("msdyn_uniquename=");
        b.append(this.msdyn_uniquename);
        b.append(", ");
        b.append("msdyn_version=");
        b.append(this.msdyn_version);
        b.append(", ");
        b.append("msdyn_synctoexternalsearchindex=");
        b.append(this.msdyn_synctoexternalsearchindex);
        b.append(", ");
        b.append("msdyn_componentlogicalname=");
        b.append(this.msdyn_componentlogicalname);
        b.append(", ");
        b.append("msdyn_statusname=");
        b.append(this.msdyn_statusname);
        b.append(", ");
        b.append("msdyn_publickeytoken=");
        b.append(this.msdyn_publickeytoken);
        b.append(", ");
        b.append("msdyn_iscustomizable=");
        b.append(this.msdyn_iscustomizable);
        b.append(", ");
        b.append("msdyn_total=");
        b.append(this.msdyn_total);
        b.append(", ");
        b.append("msdyn_executionorder=");
        b.append(this.msdyn_executionorder);
        b.append(", ");
        b.append("msdyn_schemaname=");
        b.append(this.msdyn_schemaname);
        b.append(", ");
        b.append("msdyn_culture=");
        b.append(this.msdyn_culture);
        b.append(", ");
        b.append("msdyn_componenttypename=");
        b.append(this.msdyn_componenttypename);
        b.append(", ");
        b.append("msdyn_createdon=");
        b.append(this.msdyn_createdon);
        b.append(", ");
        b.append("msdyn_status=");
        b.append(this.msdyn_status);
        b.append(", ");
        b.append("msdyn_workflowcategory=");
        b.append(this.msdyn_workflowcategory);
        b.append(", ");
        b.append("msdyn_ismanagedname=");
        b.append(this.msdyn_ismanagedname);
        b.append(", ");
        b.append("msdyn_workflowcategoryname=");
        b.append(this.msdyn_workflowcategoryname);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
