package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;
import java.util.UUID;

@JsonPropertyOrder({
    "@odata.type", 
    "msdyn_odatav4dsid", 
    "msdyn_parameter9name", 
    "msdyn_parameter2value", 
    "msdyn_isparameter5header", 
    "msdyn_isparameter4header", 
    "msdyn_parameter10value", 
    "msdyn_parameter3name", 
    "msdyn_name", 
    "msdyn_isparameter1header", 
    "msdyn_parameter5value", 
    "msdyn_parameter8name", 
    "msdyn_parameter1name", 
    "msdyn_paginationmode", 
    "msdyn_parameter7name", 
    "msdyn_description", 
    "msdyn_parameter5name", 
    "msdyn_isparameter7header", 
    "msdyn_isparameter10header", 
    "msdyn_parameter1value", 
    "msdyn_returninlinecount", 
    "msdyn_isparameter9header", 
    "msdyn_parameter7value", 
    "msdyn_isparameter3header", 
    "msdyn_parameter6value", 
    "msdyn_isparameter6header", 
    "msdyn_uri", 
    "msdyn_parameter9value", 
    "msdyn_parameter4value", 
    "msdyn_parameter4name", 
    "msdyn_paginationtype", 
    "msdyn_parameter8value", 
    "msdyn_isparameter2header", 
    "msdyn_parameter2name", 
    "msdyn_parameter10name", 
    "msdyn_isparameter8header", 
    "msdyn_parameter3value", 
    "msdyn_parameter6name", 
    "msdyn_timeout"})
@JsonInclude(Include.NON_NULL)
public class Msdyn_odatav4ds extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.msdyn_odatav4ds";
    }

    @JsonProperty("msdyn_odatav4dsid")
    protected UUID msdyn_odatav4dsid;

    @JsonProperty("msdyn_parameter9name")
    protected String msdyn_parameter9name;

    @JsonProperty("msdyn_parameter2value")
    protected String msdyn_parameter2value;

    @JsonProperty("msdyn_isparameter5header")
    protected Boolean msdyn_isparameter5header;

    @JsonProperty("msdyn_isparameter4header")
    protected Boolean msdyn_isparameter4header;

    @JsonProperty("msdyn_parameter10value")
    protected String msdyn_parameter10value;

    @JsonProperty("msdyn_parameter3name")
    protected String msdyn_parameter3name;

    @JsonProperty("msdyn_name")
    protected String msdyn_name;

    @JsonProperty("msdyn_isparameter1header")
    protected Boolean msdyn_isparameter1header;

    @JsonProperty("msdyn_parameter5value")
    protected String msdyn_parameter5value;

    @JsonProperty("msdyn_parameter8name")
    protected String msdyn_parameter8name;

    @JsonProperty("msdyn_parameter1name")
    protected String msdyn_parameter1name;

    @JsonProperty("msdyn_paginationmode")
    protected Boolean msdyn_paginationmode;

    @JsonProperty("msdyn_parameter7name")
    protected String msdyn_parameter7name;

    @JsonProperty("msdyn_description")
    protected String msdyn_description;

    @JsonProperty("msdyn_parameter5name")
    protected String msdyn_parameter5name;

    @JsonProperty("msdyn_isparameter7header")
    protected Boolean msdyn_isparameter7header;

    @JsonProperty("msdyn_isparameter10header")
    protected Boolean msdyn_isparameter10header;

    @JsonProperty("msdyn_parameter1value")
    protected String msdyn_parameter1value;

    @JsonProperty("msdyn_returninlinecount")
    protected Boolean msdyn_returninlinecount;

    @JsonProperty("msdyn_isparameter9header")
    protected Boolean msdyn_isparameter9header;

    @JsonProperty("msdyn_parameter7value")
    protected String msdyn_parameter7value;

    @JsonProperty("msdyn_isparameter3header")
    protected Boolean msdyn_isparameter3header;

    @JsonProperty("msdyn_parameter6value")
    protected String msdyn_parameter6value;

    @JsonProperty("msdyn_isparameter6header")
    protected Boolean msdyn_isparameter6header;

    @JsonProperty("msdyn_uri")
    protected String msdyn_uri;

    @JsonProperty("msdyn_parameter9value")
    protected String msdyn_parameter9value;

    @JsonProperty("msdyn_parameter4value")
    protected String msdyn_parameter4value;

    @JsonProperty("msdyn_parameter4name")
    protected String msdyn_parameter4name;

    @JsonProperty("msdyn_paginationtype")
    protected Integer msdyn_paginationtype;

    @JsonProperty("msdyn_parameter8value")
    protected String msdyn_parameter8value;

    @JsonProperty("msdyn_isparameter2header")
    protected Boolean msdyn_isparameter2header;

    @JsonProperty("msdyn_parameter2name")
    protected String msdyn_parameter2name;

    @JsonProperty("msdyn_parameter10name")
    protected String msdyn_parameter10name;

    @JsonProperty("msdyn_isparameter8header")
    protected Boolean msdyn_isparameter8header;

    @JsonProperty("msdyn_parameter3value")
    protected String msdyn_parameter3value;

    @JsonProperty("msdyn_parameter6name")
    protected String msdyn_parameter6name;

    @JsonProperty("msdyn_timeout")
    protected Integer msdyn_timeout;

    protected Msdyn_odatav4ds() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMsdyn_odatav4ds() {
        return new Builder();
    }

    public static final class Builder {
        private UUID msdyn_odatav4dsid;
        private String msdyn_parameter9name;
        private String msdyn_parameter2value;
        private Boolean msdyn_isparameter5header;
        private Boolean msdyn_isparameter4header;
        private String msdyn_parameter10value;
        private String msdyn_parameter3name;
        private String msdyn_name;
        private Boolean msdyn_isparameter1header;
        private String msdyn_parameter5value;
        private String msdyn_parameter8name;
        private String msdyn_parameter1name;
        private Boolean msdyn_paginationmode;
        private String msdyn_parameter7name;
        private String msdyn_description;
        private String msdyn_parameter5name;
        private Boolean msdyn_isparameter7header;
        private Boolean msdyn_isparameter10header;
        private String msdyn_parameter1value;
        private Boolean msdyn_returninlinecount;
        private Boolean msdyn_isparameter9header;
        private String msdyn_parameter7value;
        private Boolean msdyn_isparameter3header;
        private String msdyn_parameter6value;
        private Boolean msdyn_isparameter6header;
        private String msdyn_uri;
        private String msdyn_parameter9value;
        private String msdyn_parameter4value;
        private String msdyn_parameter4name;
        private Integer msdyn_paginationtype;
        private String msdyn_parameter8value;
        private Boolean msdyn_isparameter2header;
        private String msdyn_parameter2name;
        private String msdyn_parameter10name;
        private Boolean msdyn_isparameter8header;
        private String msdyn_parameter3value;
        private String msdyn_parameter6name;
        private Integer msdyn_timeout;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder msdyn_odatav4dsid(UUID msdyn_odatav4dsid) {
            this.msdyn_odatav4dsid = msdyn_odatav4dsid;
            this.changedFields = changedFields.add("msdyn_odatav4dsid");
            return this;
        }

        public Builder msdyn_parameter9name(String msdyn_parameter9name) {
            this.msdyn_parameter9name = msdyn_parameter9name;
            this.changedFields = changedFields.add("msdyn_parameter9name");
            return this;
        }

        public Builder msdyn_parameter2value(String msdyn_parameter2value) {
            this.msdyn_parameter2value = msdyn_parameter2value;
            this.changedFields = changedFields.add("msdyn_parameter2value");
            return this;
        }

        public Builder msdyn_isparameter5header(Boolean msdyn_isparameter5header) {
            this.msdyn_isparameter5header = msdyn_isparameter5header;
            this.changedFields = changedFields.add("msdyn_isparameter5header");
            return this;
        }

        public Builder msdyn_isparameter4header(Boolean msdyn_isparameter4header) {
            this.msdyn_isparameter4header = msdyn_isparameter4header;
            this.changedFields = changedFields.add("msdyn_isparameter4header");
            return this;
        }

        public Builder msdyn_parameter10value(String msdyn_parameter10value) {
            this.msdyn_parameter10value = msdyn_parameter10value;
            this.changedFields = changedFields.add("msdyn_parameter10value");
            return this;
        }

        public Builder msdyn_parameter3name(String msdyn_parameter3name) {
            this.msdyn_parameter3name = msdyn_parameter3name;
            this.changedFields = changedFields.add("msdyn_parameter3name");
            return this;
        }

        public Builder msdyn_name(String msdyn_name) {
            this.msdyn_name = msdyn_name;
            this.changedFields = changedFields.add("msdyn_name");
            return this;
        }

        public Builder msdyn_isparameter1header(Boolean msdyn_isparameter1header) {
            this.msdyn_isparameter1header = msdyn_isparameter1header;
            this.changedFields = changedFields.add("msdyn_isparameter1header");
            return this;
        }

        public Builder msdyn_parameter5value(String msdyn_parameter5value) {
            this.msdyn_parameter5value = msdyn_parameter5value;
            this.changedFields = changedFields.add("msdyn_parameter5value");
            return this;
        }

        public Builder msdyn_parameter8name(String msdyn_parameter8name) {
            this.msdyn_parameter8name = msdyn_parameter8name;
            this.changedFields = changedFields.add("msdyn_parameter8name");
            return this;
        }

        public Builder msdyn_parameter1name(String msdyn_parameter1name) {
            this.msdyn_parameter1name = msdyn_parameter1name;
            this.changedFields = changedFields.add("msdyn_parameter1name");
            return this;
        }

        public Builder msdyn_paginationmode(Boolean msdyn_paginationmode) {
            this.msdyn_paginationmode = msdyn_paginationmode;
            this.changedFields = changedFields.add("msdyn_paginationmode");
            return this;
        }

        public Builder msdyn_parameter7name(String msdyn_parameter7name) {
            this.msdyn_parameter7name = msdyn_parameter7name;
            this.changedFields = changedFields.add("msdyn_parameter7name");
            return this;
        }

        public Builder msdyn_description(String msdyn_description) {
            this.msdyn_description = msdyn_description;
            this.changedFields = changedFields.add("msdyn_description");
            return this;
        }

        public Builder msdyn_parameter5name(String msdyn_parameter5name) {
            this.msdyn_parameter5name = msdyn_parameter5name;
            this.changedFields = changedFields.add("msdyn_parameter5name");
            return this;
        }

        public Builder msdyn_isparameter7header(Boolean msdyn_isparameter7header) {
            this.msdyn_isparameter7header = msdyn_isparameter7header;
            this.changedFields = changedFields.add("msdyn_isparameter7header");
            return this;
        }

        public Builder msdyn_isparameter10header(Boolean msdyn_isparameter10header) {
            this.msdyn_isparameter10header = msdyn_isparameter10header;
            this.changedFields = changedFields.add("msdyn_isparameter10header");
            return this;
        }

        public Builder msdyn_parameter1value(String msdyn_parameter1value) {
            this.msdyn_parameter1value = msdyn_parameter1value;
            this.changedFields = changedFields.add("msdyn_parameter1value");
            return this;
        }

        public Builder msdyn_returninlinecount(Boolean msdyn_returninlinecount) {
            this.msdyn_returninlinecount = msdyn_returninlinecount;
            this.changedFields = changedFields.add("msdyn_returninlinecount");
            return this;
        }

        public Builder msdyn_isparameter9header(Boolean msdyn_isparameter9header) {
            this.msdyn_isparameter9header = msdyn_isparameter9header;
            this.changedFields = changedFields.add("msdyn_isparameter9header");
            return this;
        }

        public Builder msdyn_parameter7value(String msdyn_parameter7value) {
            this.msdyn_parameter7value = msdyn_parameter7value;
            this.changedFields = changedFields.add("msdyn_parameter7value");
            return this;
        }

        public Builder msdyn_isparameter3header(Boolean msdyn_isparameter3header) {
            this.msdyn_isparameter3header = msdyn_isparameter3header;
            this.changedFields = changedFields.add("msdyn_isparameter3header");
            return this;
        }

        public Builder msdyn_parameter6value(String msdyn_parameter6value) {
            this.msdyn_parameter6value = msdyn_parameter6value;
            this.changedFields = changedFields.add("msdyn_parameter6value");
            return this;
        }

        public Builder msdyn_isparameter6header(Boolean msdyn_isparameter6header) {
            this.msdyn_isparameter6header = msdyn_isparameter6header;
            this.changedFields = changedFields.add("msdyn_isparameter6header");
            return this;
        }

        public Builder msdyn_uri(String msdyn_uri) {
            this.msdyn_uri = msdyn_uri;
            this.changedFields = changedFields.add("msdyn_uri");
            return this;
        }

        public Builder msdyn_parameter9value(String msdyn_parameter9value) {
            this.msdyn_parameter9value = msdyn_parameter9value;
            this.changedFields = changedFields.add("msdyn_parameter9value");
            return this;
        }

        public Builder msdyn_parameter4value(String msdyn_parameter4value) {
            this.msdyn_parameter4value = msdyn_parameter4value;
            this.changedFields = changedFields.add("msdyn_parameter4value");
            return this;
        }

        public Builder msdyn_parameter4name(String msdyn_parameter4name) {
            this.msdyn_parameter4name = msdyn_parameter4name;
            this.changedFields = changedFields.add("msdyn_parameter4name");
            return this;
        }

        public Builder msdyn_paginationtype(Integer msdyn_paginationtype) {
            this.msdyn_paginationtype = msdyn_paginationtype;
            this.changedFields = changedFields.add("msdyn_paginationtype");
            return this;
        }

        public Builder msdyn_parameter8value(String msdyn_parameter8value) {
            this.msdyn_parameter8value = msdyn_parameter8value;
            this.changedFields = changedFields.add("msdyn_parameter8value");
            return this;
        }

        public Builder msdyn_isparameter2header(Boolean msdyn_isparameter2header) {
            this.msdyn_isparameter2header = msdyn_isparameter2header;
            this.changedFields = changedFields.add("msdyn_isparameter2header");
            return this;
        }

        public Builder msdyn_parameter2name(String msdyn_parameter2name) {
            this.msdyn_parameter2name = msdyn_parameter2name;
            this.changedFields = changedFields.add("msdyn_parameter2name");
            return this;
        }

        public Builder msdyn_parameter10name(String msdyn_parameter10name) {
            this.msdyn_parameter10name = msdyn_parameter10name;
            this.changedFields = changedFields.add("msdyn_parameter10name");
            return this;
        }

        public Builder msdyn_isparameter8header(Boolean msdyn_isparameter8header) {
            this.msdyn_isparameter8header = msdyn_isparameter8header;
            this.changedFields = changedFields.add("msdyn_isparameter8header");
            return this;
        }

        public Builder msdyn_parameter3value(String msdyn_parameter3value) {
            this.msdyn_parameter3value = msdyn_parameter3value;
            this.changedFields = changedFields.add("msdyn_parameter3value");
            return this;
        }

        public Builder msdyn_parameter6name(String msdyn_parameter6name) {
            this.msdyn_parameter6name = msdyn_parameter6name;
            this.changedFields = changedFields.add("msdyn_parameter6name");
            return this;
        }

        public Builder msdyn_timeout(Integer msdyn_timeout) {
            this.msdyn_timeout = msdyn_timeout;
            this.changedFields = changedFields.add("msdyn_timeout");
            return this;
        }

        public Msdyn_odatav4ds build() {
            Msdyn_odatav4ds _x = new Msdyn_odatav4ds();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.msdyn_odatav4ds";
            _x.msdyn_odatav4dsid = msdyn_odatav4dsid;
            _x.msdyn_parameter9name = msdyn_parameter9name;
            _x.msdyn_parameter2value = msdyn_parameter2value;
            _x.msdyn_isparameter5header = msdyn_isparameter5header;
            _x.msdyn_isparameter4header = msdyn_isparameter4header;
            _x.msdyn_parameter10value = msdyn_parameter10value;
            _x.msdyn_parameter3name = msdyn_parameter3name;
            _x.msdyn_name = msdyn_name;
            _x.msdyn_isparameter1header = msdyn_isparameter1header;
            _x.msdyn_parameter5value = msdyn_parameter5value;
            _x.msdyn_parameter8name = msdyn_parameter8name;
            _x.msdyn_parameter1name = msdyn_parameter1name;
            _x.msdyn_paginationmode = msdyn_paginationmode;
            _x.msdyn_parameter7name = msdyn_parameter7name;
            _x.msdyn_description = msdyn_description;
            _x.msdyn_parameter5name = msdyn_parameter5name;
            _x.msdyn_isparameter7header = msdyn_isparameter7header;
            _x.msdyn_isparameter10header = msdyn_isparameter10header;
            _x.msdyn_parameter1value = msdyn_parameter1value;
            _x.msdyn_returninlinecount = msdyn_returninlinecount;
            _x.msdyn_isparameter9header = msdyn_isparameter9header;
            _x.msdyn_parameter7value = msdyn_parameter7value;
            _x.msdyn_isparameter3header = msdyn_isparameter3header;
            _x.msdyn_parameter6value = msdyn_parameter6value;
            _x.msdyn_isparameter6header = msdyn_isparameter6header;
            _x.msdyn_uri = msdyn_uri;
            _x.msdyn_parameter9value = msdyn_parameter9value;
            _x.msdyn_parameter4value = msdyn_parameter4value;
            _x.msdyn_parameter4name = msdyn_parameter4name;
            _x.msdyn_paginationtype = msdyn_paginationtype;
            _x.msdyn_parameter8value = msdyn_parameter8value;
            _x.msdyn_isparameter2header = msdyn_isparameter2header;
            _x.msdyn_parameter2name = msdyn_parameter2name;
            _x.msdyn_parameter10name = msdyn_parameter10name;
            _x.msdyn_isparameter8header = msdyn_isparameter8header;
            _x.msdyn_parameter3value = msdyn_parameter3value;
            _x.msdyn_parameter6name = msdyn_parameter6name;
            _x.msdyn_timeout = msdyn_timeout;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && msdyn_odatav4dsid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(msdyn_odatav4dsid, UUID.class));
        }
    }

    @Property(name="msdyn_odatav4dsid")
    @JsonIgnore
    public Optional<UUID> getMsdyn_odatav4dsid() {
        return Optional.ofNullable(msdyn_odatav4dsid);
    }

    public Msdyn_odatav4ds withMsdyn_odatav4dsid(UUID msdyn_odatav4dsid) {
        Msdyn_odatav4ds _x = _copy();
        _x.changedFields = changedFields.add("msdyn_odatav4dsid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_odatav4ds");
        _x.msdyn_odatav4dsid = msdyn_odatav4dsid;
        return _x;
    }

    @Property(name="msdyn_parameter9name")
    @JsonIgnore
    public Optional<String> getMsdyn_parameter9name() {
        return Optional.ofNullable(msdyn_parameter9name);
    }

    public Msdyn_odatav4ds withMsdyn_parameter9name(String msdyn_parameter9name) {
        Checks.checkIsAscii(msdyn_parameter9name);
        Msdyn_odatav4ds _x = _copy();
        _x.changedFields = changedFields.add("msdyn_parameter9name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_odatav4ds");
        _x.msdyn_parameter9name = msdyn_parameter9name;
        return _x;
    }

    @Property(name="msdyn_parameter2value")
    @JsonIgnore
    public Optional<String> getMsdyn_parameter2value() {
        return Optional.ofNullable(msdyn_parameter2value);
    }

    public Msdyn_odatav4ds withMsdyn_parameter2value(String msdyn_parameter2value) {
        Checks.checkIsAscii(msdyn_parameter2value);
        Msdyn_odatav4ds _x = _copy();
        _x.changedFields = changedFields.add("msdyn_parameter2value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_odatav4ds");
        _x.msdyn_parameter2value = msdyn_parameter2value;
        return _x;
    }

    @Property(name="msdyn_isparameter5header")
    @JsonIgnore
    public Optional<Boolean> getMsdyn_isparameter5header() {
        return Optional.ofNullable(msdyn_isparameter5header);
    }

    public Msdyn_odatav4ds withMsdyn_isparameter5header(Boolean msdyn_isparameter5header) {
        Msdyn_odatav4ds _x = _copy();
        _x.changedFields = changedFields.add("msdyn_isparameter5header");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_odatav4ds");
        _x.msdyn_isparameter5header = msdyn_isparameter5header;
        return _x;
    }

    @Property(name="msdyn_isparameter4header")
    @JsonIgnore
    public Optional<Boolean> getMsdyn_isparameter4header() {
        return Optional.ofNullable(msdyn_isparameter4header);
    }

    public Msdyn_odatav4ds withMsdyn_isparameter4header(Boolean msdyn_isparameter4header) {
        Msdyn_odatav4ds _x = _copy();
        _x.changedFields = changedFields.add("msdyn_isparameter4header");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_odatav4ds");
        _x.msdyn_isparameter4header = msdyn_isparameter4header;
        return _x;
    }

    @Property(name="msdyn_parameter10value")
    @JsonIgnore
    public Optional<String> getMsdyn_parameter10value() {
        return Optional.ofNullable(msdyn_parameter10value);
    }

    public Msdyn_odatav4ds withMsdyn_parameter10value(String msdyn_parameter10value) {
        Checks.checkIsAscii(msdyn_parameter10value);
        Msdyn_odatav4ds _x = _copy();
        _x.changedFields = changedFields.add("msdyn_parameter10value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_odatav4ds");
        _x.msdyn_parameter10value = msdyn_parameter10value;
        return _x;
    }

    @Property(name="msdyn_parameter3name")
    @JsonIgnore
    public Optional<String> getMsdyn_parameter3name() {
        return Optional.ofNullable(msdyn_parameter3name);
    }

    public Msdyn_odatav4ds withMsdyn_parameter3name(String msdyn_parameter3name) {
        Checks.checkIsAscii(msdyn_parameter3name);
        Msdyn_odatav4ds _x = _copy();
        _x.changedFields = changedFields.add("msdyn_parameter3name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_odatav4ds");
        _x.msdyn_parameter3name = msdyn_parameter3name;
        return _x;
    }

    @Property(name="msdyn_name")
    @JsonIgnore
    public Optional<String> getMsdyn_name() {
        return Optional.ofNullable(msdyn_name);
    }

    public Msdyn_odatav4ds withMsdyn_name(String msdyn_name) {
        Checks.checkIsAscii(msdyn_name);
        Msdyn_odatav4ds _x = _copy();
        _x.changedFields = changedFields.add("msdyn_name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_odatav4ds");
        _x.msdyn_name = msdyn_name;
        return _x;
    }

    @Property(name="msdyn_isparameter1header")
    @JsonIgnore
    public Optional<Boolean> getMsdyn_isparameter1header() {
        return Optional.ofNullable(msdyn_isparameter1header);
    }

    public Msdyn_odatav4ds withMsdyn_isparameter1header(Boolean msdyn_isparameter1header) {
        Msdyn_odatav4ds _x = _copy();
        _x.changedFields = changedFields.add("msdyn_isparameter1header");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_odatav4ds");
        _x.msdyn_isparameter1header = msdyn_isparameter1header;
        return _x;
    }

    @Property(name="msdyn_parameter5value")
    @JsonIgnore
    public Optional<String> getMsdyn_parameter5value() {
        return Optional.ofNullable(msdyn_parameter5value);
    }

    public Msdyn_odatav4ds withMsdyn_parameter5value(String msdyn_parameter5value) {
        Checks.checkIsAscii(msdyn_parameter5value);
        Msdyn_odatav4ds _x = _copy();
        _x.changedFields = changedFields.add("msdyn_parameter5value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_odatav4ds");
        _x.msdyn_parameter5value = msdyn_parameter5value;
        return _x;
    }

    @Property(name="msdyn_parameter8name")
    @JsonIgnore
    public Optional<String> getMsdyn_parameter8name() {
        return Optional.ofNullable(msdyn_parameter8name);
    }

    public Msdyn_odatav4ds withMsdyn_parameter8name(String msdyn_parameter8name) {
        Checks.checkIsAscii(msdyn_parameter8name);
        Msdyn_odatav4ds _x = _copy();
        _x.changedFields = changedFields.add("msdyn_parameter8name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_odatav4ds");
        _x.msdyn_parameter8name = msdyn_parameter8name;
        return _x;
    }

    @Property(name="msdyn_parameter1name")
    @JsonIgnore
    public Optional<String> getMsdyn_parameter1name() {
        return Optional.ofNullable(msdyn_parameter1name);
    }

    public Msdyn_odatav4ds withMsdyn_parameter1name(String msdyn_parameter1name) {
        Checks.checkIsAscii(msdyn_parameter1name);
        Msdyn_odatav4ds _x = _copy();
        _x.changedFields = changedFields.add("msdyn_parameter1name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_odatav4ds");
        _x.msdyn_parameter1name = msdyn_parameter1name;
        return _x;
    }

    @Property(name="msdyn_paginationmode")
    @JsonIgnore
    public Optional<Boolean> getMsdyn_paginationmode() {
        return Optional.ofNullable(msdyn_paginationmode);
    }

    public Msdyn_odatav4ds withMsdyn_paginationmode(Boolean msdyn_paginationmode) {
        Msdyn_odatav4ds _x = _copy();
        _x.changedFields = changedFields.add("msdyn_paginationmode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_odatav4ds");
        _x.msdyn_paginationmode = msdyn_paginationmode;
        return _x;
    }

    @Property(name="msdyn_parameter7name")
    @JsonIgnore
    public Optional<String> getMsdyn_parameter7name() {
        return Optional.ofNullable(msdyn_parameter7name);
    }

    public Msdyn_odatav4ds withMsdyn_parameter7name(String msdyn_parameter7name) {
        Checks.checkIsAscii(msdyn_parameter7name);
        Msdyn_odatav4ds _x = _copy();
        _x.changedFields = changedFields.add("msdyn_parameter7name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_odatav4ds");
        _x.msdyn_parameter7name = msdyn_parameter7name;
        return _x;
    }

    @Property(name="msdyn_description")
    @JsonIgnore
    public Optional<String> getMsdyn_description() {
        return Optional.ofNullable(msdyn_description);
    }

    public Msdyn_odatav4ds withMsdyn_description(String msdyn_description) {
        Checks.checkIsAscii(msdyn_description);
        Msdyn_odatav4ds _x = _copy();
        _x.changedFields = changedFields.add("msdyn_description");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_odatav4ds");
        _x.msdyn_description = msdyn_description;
        return _x;
    }

    @Property(name="msdyn_parameter5name")
    @JsonIgnore
    public Optional<String> getMsdyn_parameter5name() {
        return Optional.ofNullable(msdyn_parameter5name);
    }

    public Msdyn_odatav4ds withMsdyn_parameter5name(String msdyn_parameter5name) {
        Checks.checkIsAscii(msdyn_parameter5name);
        Msdyn_odatav4ds _x = _copy();
        _x.changedFields = changedFields.add("msdyn_parameter5name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_odatav4ds");
        _x.msdyn_parameter5name = msdyn_parameter5name;
        return _x;
    }

    @Property(name="msdyn_isparameter7header")
    @JsonIgnore
    public Optional<Boolean> getMsdyn_isparameter7header() {
        return Optional.ofNullable(msdyn_isparameter7header);
    }

    public Msdyn_odatav4ds withMsdyn_isparameter7header(Boolean msdyn_isparameter7header) {
        Msdyn_odatav4ds _x = _copy();
        _x.changedFields = changedFields.add("msdyn_isparameter7header");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_odatav4ds");
        _x.msdyn_isparameter7header = msdyn_isparameter7header;
        return _x;
    }

    @Property(name="msdyn_isparameter10header")
    @JsonIgnore
    public Optional<Boolean> getMsdyn_isparameter10header() {
        return Optional.ofNullable(msdyn_isparameter10header);
    }

    public Msdyn_odatav4ds withMsdyn_isparameter10header(Boolean msdyn_isparameter10header) {
        Msdyn_odatav4ds _x = _copy();
        _x.changedFields = changedFields.add("msdyn_isparameter10header");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_odatav4ds");
        _x.msdyn_isparameter10header = msdyn_isparameter10header;
        return _x;
    }

    @Property(name="msdyn_parameter1value")
    @JsonIgnore
    public Optional<String> getMsdyn_parameter1value() {
        return Optional.ofNullable(msdyn_parameter1value);
    }

    public Msdyn_odatav4ds withMsdyn_parameter1value(String msdyn_parameter1value) {
        Checks.checkIsAscii(msdyn_parameter1value);
        Msdyn_odatav4ds _x = _copy();
        _x.changedFields = changedFields.add("msdyn_parameter1value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_odatav4ds");
        _x.msdyn_parameter1value = msdyn_parameter1value;
        return _x;
    }

    @Property(name="msdyn_returninlinecount")
    @JsonIgnore
    public Optional<Boolean> getMsdyn_returninlinecount() {
        return Optional.ofNullable(msdyn_returninlinecount);
    }

    public Msdyn_odatav4ds withMsdyn_returninlinecount(Boolean msdyn_returninlinecount) {
        Msdyn_odatav4ds _x = _copy();
        _x.changedFields = changedFields.add("msdyn_returninlinecount");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_odatav4ds");
        _x.msdyn_returninlinecount = msdyn_returninlinecount;
        return _x;
    }

    @Property(name="msdyn_isparameter9header")
    @JsonIgnore
    public Optional<Boolean> getMsdyn_isparameter9header() {
        return Optional.ofNullable(msdyn_isparameter9header);
    }

    public Msdyn_odatav4ds withMsdyn_isparameter9header(Boolean msdyn_isparameter9header) {
        Msdyn_odatav4ds _x = _copy();
        _x.changedFields = changedFields.add("msdyn_isparameter9header");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_odatav4ds");
        _x.msdyn_isparameter9header = msdyn_isparameter9header;
        return _x;
    }

    @Property(name="msdyn_parameter7value")
    @JsonIgnore
    public Optional<String> getMsdyn_parameter7value() {
        return Optional.ofNullable(msdyn_parameter7value);
    }

    public Msdyn_odatav4ds withMsdyn_parameter7value(String msdyn_parameter7value) {
        Checks.checkIsAscii(msdyn_parameter7value);
        Msdyn_odatav4ds _x = _copy();
        _x.changedFields = changedFields.add("msdyn_parameter7value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_odatav4ds");
        _x.msdyn_parameter7value = msdyn_parameter7value;
        return _x;
    }

    @Property(name="msdyn_isparameter3header")
    @JsonIgnore
    public Optional<Boolean> getMsdyn_isparameter3header() {
        return Optional.ofNullable(msdyn_isparameter3header);
    }

    public Msdyn_odatav4ds withMsdyn_isparameter3header(Boolean msdyn_isparameter3header) {
        Msdyn_odatav4ds _x = _copy();
        _x.changedFields = changedFields.add("msdyn_isparameter3header");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_odatav4ds");
        _x.msdyn_isparameter3header = msdyn_isparameter3header;
        return _x;
    }

    @Property(name="msdyn_parameter6value")
    @JsonIgnore
    public Optional<String> getMsdyn_parameter6value() {
        return Optional.ofNullable(msdyn_parameter6value);
    }

    public Msdyn_odatav4ds withMsdyn_parameter6value(String msdyn_parameter6value) {
        Checks.checkIsAscii(msdyn_parameter6value);
        Msdyn_odatav4ds _x = _copy();
        _x.changedFields = changedFields.add("msdyn_parameter6value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_odatav4ds");
        _x.msdyn_parameter6value = msdyn_parameter6value;
        return _x;
    }

    @Property(name="msdyn_isparameter6header")
    @JsonIgnore
    public Optional<Boolean> getMsdyn_isparameter6header() {
        return Optional.ofNullable(msdyn_isparameter6header);
    }

    public Msdyn_odatav4ds withMsdyn_isparameter6header(Boolean msdyn_isparameter6header) {
        Msdyn_odatav4ds _x = _copy();
        _x.changedFields = changedFields.add("msdyn_isparameter6header");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_odatav4ds");
        _x.msdyn_isparameter6header = msdyn_isparameter6header;
        return _x;
    }

    @Property(name="msdyn_uri")
    @JsonIgnore
    public Optional<String> getMsdyn_uri() {
        return Optional.ofNullable(msdyn_uri);
    }

    public Msdyn_odatav4ds withMsdyn_uri(String msdyn_uri) {
        Checks.checkIsAscii(msdyn_uri);
        Msdyn_odatav4ds _x = _copy();
        _x.changedFields = changedFields.add("msdyn_uri");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_odatav4ds");
        _x.msdyn_uri = msdyn_uri;
        return _x;
    }

    @Property(name="msdyn_parameter9value")
    @JsonIgnore
    public Optional<String> getMsdyn_parameter9value() {
        return Optional.ofNullable(msdyn_parameter9value);
    }

    public Msdyn_odatav4ds withMsdyn_parameter9value(String msdyn_parameter9value) {
        Checks.checkIsAscii(msdyn_parameter9value);
        Msdyn_odatav4ds _x = _copy();
        _x.changedFields = changedFields.add("msdyn_parameter9value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_odatav4ds");
        _x.msdyn_parameter9value = msdyn_parameter9value;
        return _x;
    }

    @Property(name="msdyn_parameter4value")
    @JsonIgnore
    public Optional<String> getMsdyn_parameter4value() {
        return Optional.ofNullable(msdyn_parameter4value);
    }

    public Msdyn_odatav4ds withMsdyn_parameter4value(String msdyn_parameter4value) {
        Checks.checkIsAscii(msdyn_parameter4value);
        Msdyn_odatav4ds _x = _copy();
        _x.changedFields = changedFields.add("msdyn_parameter4value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_odatav4ds");
        _x.msdyn_parameter4value = msdyn_parameter4value;
        return _x;
    }

    @Property(name="msdyn_parameter4name")
    @JsonIgnore
    public Optional<String> getMsdyn_parameter4name() {
        return Optional.ofNullable(msdyn_parameter4name);
    }

    public Msdyn_odatav4ds withMsdyn_parameter4name(String msdyn_parameter4name) {
        Checks.checkIsAscii(msdyn_parameter4name);
        Msdyn_odatav4ds _x = _copy();
        _x.changedFields = changedFields.add("msdyn_parameter4name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_odatav4ds");
        _x.msdyn_parameter4name = msdyn_parameter4name;
        return _x;
    }

    @Property(name="msdyn_paginationtype")
    @JsonIgnore
    public Optional<Integer> getMsdyn_paginationtype() {
        return Optional.ofNullable(msdyn_paginationtype);
    }

    public Msdyn_odatav4ds withMsdyn_paginationtype(Integer msdyn_paginationtype) {
        Msdyn_odatav4ds _x = _copy();
        _x.changedFields = changedFields.add("msdyn_paginationtype");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_odatav4ds");
        _x.msdyn_paginationtype = msdyn_paginationtype;
        return _x;
    }

    @Property(name="msdyn_parameter8value")
    @JsonIgnore
    public Optional<String> getMsdyn_parameter8value() {
        return Optional.ofNullable(msdyn_parameter8value);
    }

    public Msdyn_odatav4ds withMsdyn_parameter8value(String msdyn_parameter8value) {
        Checks.checkIsAscii(msdyn_parameter8value);
        Msdyn_odatav4ds _x = _copy();
        _x.changedFields = changedFields.add("msdyn_parameter8value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_odatav4ds");
        _x.msdyn_parameter8value = msdyn_parameter8value;
        return _x;
    }

    @Property(name="msdyn_isparameter2header")
    @JsonIgnore
    public Optional<Boolean> getMsdyn_isparameter2header() {
        return Optional.ofNullable(msdyn_isparameter2header);
    }

    public Msdyn_odatav4ds withMsdyn_isparameter2header(Boolean msdyn_isparameter2header) {
        Msdyn_odatav4ds _x = _copy();
        _x.changedFields = changedFields.add("msdyn_isparameter2header");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_odatav4ds");
        _x.msdyn_isparameter2header = msdyn_isparameter2header;
        return _x;
    }

    @Property(name="msdyn_parameter2name")
    @JsonIgnore
    public Optional<String> getMsdyn_parameter2name() {
        return Optional.ofNullable(msdyn_parameter2name);
    }

    public Msdyn_odatav4ds withMsdyn_parameter2name(String msdyn_parameter2name) {
        Checks.checkIsAscii(msdyn_parameter2name);
        Msdyn_odatav4ds _x = _copy();
        _x.changedFields = changedFields.add("msdyn_parameter2name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_odatav4ds");
        _x.msdyn_parameter2name = msdyn_parameter2name;
        return _x;
    }

    @Property(name="msdyn_parameter10name")
    @JsonIgnore
    public Optional<String> getMsdyn_parameter10name() {
        return Optional.ofNullable(msdyn_parameter10name);
    }

    public Msdyn_odatav4ds withMsdyn_parameter10name(String msdyn_parameter10name) {
        Checks.checkIsAscii(msdyn_parameter10name);
        Msdyn_odatav4ds _x = _copy();
        _x.changedFields = changedFields.add("msdyn_parameter10name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_odatav4ds");
        _x.msdyn_parameter10name = msdyn_parameter10name;
        return _x;
    }

    @Property(name="msdyn_isparameter8header")
    @JsonIgnore
    public Optional<Boolean> getMsdyn_isparameter8header() {
        return Optional.ofNullable(msdyn_isparameter8header);
    }

    public Msdyn_odatav4ds withMsdyn_isparameter8header(Boolean msdyn_isparameter8header) {
        Msdyn_odatav4ds _x = _copy();
        _x.changedFields = changedFields.add("msdyn_isparameter8header");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_odatav4ds");
        _x.msdyn_isparameter8header = msdyn_isparameter8header;
        return _x;
    }

    @Property(name="msdyn_parameter3value")
    @JsonIgnore
    public Optional<String> getMsdyn_parameter3value() {
        return Optional.ofNullable(msdyn_parameter3value);
    }

    public Msdyn_odatav4ds withMsdyn_parameter3value(String msdyn_parameter3value) {
        Checks.checkIsAscii(msdyn_parameter3value);
        Msdyn_odatav4ds _x = _copy();
        _x.changedFields = changedFields.add("msdyn_parameter3value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_odatav4ds");
        _x.msdyn_parameter3value = msdyn_parameter3value;
        return _x;
    }

    @Property(name="msdyn_parameter6name")
    @JsonIgnore
    public Optional<String> getMsdyn_parameter6name() {
        return Optional.ofNullable(msdyn_parameter6name);
    }

    public Msdyn_odatav4ds withMsdyn_parameter6name(String msdyn_parameter6name) {
        Checks.checkIsAscii(msdyn_parameter6name);
        Msdyn_odatav4ds _x = _copy();
        _x.changedFields = changedFields.add("msdyn_parameter6name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_odatav4ds");
        _x.msdyn_parameter6name = msdyn_parameter6name;
        return _x;
    }

    @Property(name="msdyn_timeout")
    @JsonIgnore
    public Optional<Integer> getMsdyn_timeout() {
        return Optional.ofNullable(msdyn_timeout);
    }

    public Msdyn_odatav4ds withMsdyn_timeout(Integer msdyn_timeout) {
        Msdyn_odatav4ds _x = _copy();
        _x.changedFields = changedFields.add("msdyn_timeout");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_odatav4ds");
        _x.msdyn_timeout = msdyn_timeout;
        return _x;
    }

    public Msdyn_odatav4ds withUnmappedField(String name, String value) {
        Msdyn_odatav4ds _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Msdyn_odatav4ds patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Msdyn_odatav4ds _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Msdyn_odatav4ds put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Msdyn_odatav4ds _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Msdyn_odatav4ds _copy() {
        Msdyn_odatav4ds _x = new Msdyn_odatav4ds();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.msdyn_odatav4dsid = msdyn_odatav4dsid;
        _x.msdyn_parameter9name = msdyn_parameter9name;
        _x.msdyn_parameter2value = msdyn_parameter2value;
        _x.msdyn_isparameter5header = msdyn_isparameter5header;
        _x.msdyn_isparameter4header = msdyn_isparameter4header;
        _x.msdyn_parameter10value = msdyn_parameter10value;
        _x.msdyn_parameter3name = msdyn_parameter3name;
        _x.msdyn_name = msdyn_name;
        _x.msdyn_isparameter1header = msdyn_isparameter1header;
        _x.msdyn_parameter5value = msdyn_parameter5value;
        _x.msdyn_parameter8name = msdyn_parameter8name;
        _x.msdyn_parameter1name = msdyn_parameter1name;
        _x.msdyn_paginationmode = msdyn_paginationmode;
        _x.msdyn_parameter7name = msdyn_parameter7name;
        _x.msdyn_description = msdyn_description;
        _x.msdyn_parameter5name = msdyn_parameter5name;
        _x.msdyn_isparameter7header = msdyn_isparameter7header;
        _x.msdyn_isparameter10header = msdyn_isparameter10header;
        _x.msdyn_parameter1value = msdyn_parameter1value;
        _x.msdyn_returninlinecount = msdyn_returninlinecount;
        _x.msdyn_isparameter9header = msdyn_isparameter9header;
        _x.msdyn_parameter7value = msdyn_parameter7value;
        _x.msdyn_isparameter3header = msdyn_isparameter3header;
        _x.msdyn_parameter6value = msdyn_parameter6value;
        _x.msdyn_isparameter6header = msdyn_isparameter6header;
        _x.msdyn_uri = msdyn_uri;
        _x.msdyn_parameter9value = msdyn_parameter9value;
        _x.msdyn_parameter4value = msdyn_parameter4value;
        _x.msdyn_parameter4name = msdyn_parameter4name;
        _x.msdyn_paginationtype = msdyn_paginationtype;
        _x.msdyn_parameter8value = msdyn_parameter8value;
        _x.msdyn_isparameter2header = msdyn_isparameter2header;
        _x.msdyn_parameter2name = msdyn_parameter2name;
        _x.msdyn_parameter10name = msdyn_parameter10name;
        _x.msdyn_isparameter8header = msdyn_isparameter8header;
        _x.msdyn_parameter3value = msdyn_parameter3value;
        _x.msdyn_parameter6name = msdyn_parameter6name;
        _x.msdyn_timeout = msdyn_timeout;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Msdyn_odatav4ds[");
        b.append("msdyn_odatav4dsid=");
        b.append(this.msdyn_odatav4dsid);
        b.append(", ");
        b.append("msdyn_parameter9name=");
        b.append(this.msdyn_parameter9name);
        b.append(", ");
        b.append("msdyn_parameter2value=");
        b.append(this.msdyn_parameter2value);
        b.append(", ");
        b.append("msdyn_isparameter5header=");
        b.append(this.msdyn_isparameter5header);
        b.append(", ");
        b.append("msdyn_isparameter4header=");
        b.append(this.msdyn_isparameter4header);
        b.append(", ");
        b.append("msdyn_parameter10value=");
        b.append(this.msdyn_parameter10value);
        b.append(", ");
        b.append("msdyn_parameter3name=");
        b.append(this.msdyn_parameter3name);
        b.append(", ");
        b.append("msdyn_name=");
        b.append(this.msdyn_name);
        b.append(", ");
        b.append("msdyn_isparameter1header=");
        b.append(this.msdyn_isparameter1header);
        b.append(", ");
        b.append("msdyn_parameter5value=");
        b.append(this.msdyn_parameter5value);
        b.append(", ");
        b.append("msdyn_parameter8name=");
        b.append(this.msdyn_parameter8name);
        b.append(", ");
        b.append("msdyn_parameter1name=");
        b.append(this.msdyn_parameter1name);
        b.append(", ");
        b.append("msdyn_paginationmode=");
        b.append(this.msdyn_paginationmode);
        b.append(", ");
        b.append("msdyn_parameter7name=");
        b.append(this.msdyn_parameter7name);
        b.append(", ");
        b.append("msdyn_description=");
        b.append(this.msdyn_description);
        b.append(", ");
        b.append("msdyn_parameter5name=");
        b.append(this.msdyn_parameter5name);
        b.append(", ");
        b.append("msdyn_isparameter7header=");
        b.append(this.msdyn_isparameter7header);
        b.append(", ");
        b.append("msdyn_isparameter10header=");
        b.append(this.msdyn_isparameter10header);
        b.append(", ");
        b.append("msdyn_parameter1value=");
        b.append(this.msdyn_parameter1value);
        b.append(", ");
        b.append("msdyn_returninlinecount=");
        b.append(this.msdyn_returninlinecount);
        b.append(", ");
        b.append("msdyn_isparameter9header=");
        b.append(this.msdyn_isparameter9header);
        b.append(", ");
        b.append("msdyn_parameter7value=");
        b.append(this.msdyn_parameter7value);
        b.append(", ");
        b.append("msdyn_isparameter3header=");
        b.append(this.msdyn_isparameter3header);
        b.append(", ");
        b.append("msdyn_parameter6value=");
        b.append(this.msdyn_parameter6value);
        b.append(", ");
        b.append("msdyn_isparameter6header=");
        b.append(this.msdyn_isparameter6header);
        b.append(", ");
        b.append("msdyn_uri=");
        b.append(this.msdyn_uri);
        b.append(", ");
        b.append("msdyn_parameter9value=");
        b.append(this.msdyn_parameter9value);
        b.append(", ");
        b.append("msdyn_parameter4value=");
        b.append(this.msdyn_parameter4value);
        b.append(", ");
        b.append("msdyn_parameter4name=");
        b.append(this.msdyn_parameter4name);
        b.append(", ");
        b.append("msdyn_paginationtype=");
        b.append(this.msdyn_paginationtype);
        b.append(", ");
        b.append("msdyn_parameter8value=");
        b.append(this.msdyn_parameter8value);
        b.append(", ");
        b.append("msdyn_isparameter2header=");
        b.append(this.msdyn_isparameter2header);
        b.append(", ");
        b.append("msdyn_parameter2name=");
        b.append(this.msdyn_parameter2name);
        b.append(", ");
        b.append("msdyn_parameter10name=");
        b.append(this.msdyn_parameter10name);
        b.append(", ");
        b.append("msdyn_isparameter8header=");
        b.append(this.msdyn_isparameter8header);
        b.append(", ");
        b.append("msdyn_parameter3value=");
        b.append(this.msdyn_parameter3value);
        b.append(", ");
        b.append("msdyn_parameter6name=");
        b.append(this.msdyn_parameter6name);
        b.append(", ");
        b.append("msdyn_timeout=");
        b.append(this.msdyn_timeout);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
