package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DuplicaterecordCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MailboxtrackingfolderCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_analysisresultCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.request.BusinessunitRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_analysisjobRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_solutionhealthrulesetRequest;
import microsoft.dynamics.crm.entity.request.PrincipalRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.TeamRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "statecode", 
    "msdyn_rulepassrate", 
    "msdyn_componentversion", 
    "statuscode", 
    "overriddencreatedon", 
    "_modifiedby_value", 
    "_ownerid_value", 
    "modifiedon", 
    "msdyn_sevmediumcount", 
    "msdyn_sevcriticalcount", 
    "msdyn_analysiscomponentid", 
    "msdyn_name", 
    "_msdyn_analysisjobid_value", 
    "msdyn_componenttype", 
    "msdyn_errorcount", 
    "_createdby_value", 
    "_createdonbehalfby_value", 
    "msdyn_analysiscomponenttype", 
    "timezoneruleversionnumber", 
    "_modifiedonbehalfby_value", 
    "msdyn_componentid", 
    "msdyn_rulepasscount", 
    "importsequencenumber", 
    "msdyn_sevlowcount", 
    "msdyn_warningcount", 
    "msdyn_sevhighcount", 
    "_owninguser_value", 
    "utcconversiontimezonecode", 
    "_msdyn_solutionhealthrulesetid_value", 
    "msdyn_componentname", 
    "createdon", 
    "_owningteam_value", 
    "msdyn_rulefailcount", 
    "msdyn_retrycount", 
    "_owningbusinessunit_value", 
    "versionnumber"})
@JsonInclude(Include.NON_NULL)
public class Msdyn_analysiscomponent extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.msdyn_analysiscomponent";
    }

    @JsonProperty("statecode")
    protected Integer statecode;

    @JsonProperty("msdyn_rulepassrate")
    protected Integer msdyn_rulepassrate;

    @JsonProperty("msdyn_componentversion")
    protected String msdyn_componentversion;

    @JsonProperty("statuscode")
    protected Integer statuscode;

    @JsonProperty("overriddencreatedon")
    protected OffsetDateTime overriddencreatedon;

    @JsonProperty("_modifiedby_value")
    protected UUID _modifiedby_value;

    @JsonProperty("_ownerid_value")
    protected UUID _ownerid_value;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("msdyn_sevmediumcount")
    protected Integer msdyn_sevmediumcount;

    @JsonProperty("msdyn_sevcriticalcount")
    protected Integer msdyn_sevcriticalcount;

    @JsonProperty("msdyn_analysiscomponentid")
    protected UUID msdyn_analysiscomponentid;

    @JsonProperty("msdyn_name")
    protected String msdyn_name;

    @JsonProperty("_msdyn_analysisjobid_value")
    protected UUID _msdyn_analysisjobid_value;

    @JsonProperty("msdyn_componenttype")
    protected Integer msdyn_componenttype;

    @JsonProperty("msdyn_errorcount")
    protected Integer msdyn_errorcount;

    @JsonProperty("_createdby_value")
    protected UUID _createdby_value;

    @JsonProperty("_createdonbehalfby_value")
    protected UUID _createdonbehalfby_value;

    @JsonProperty("msdyn_analysiscomponenttype")
    protected Integer msdyn_analysiscomponenttype;

    @JsonProperty("timezoneruleversionnumber")
    protected Integer timezoneruleversionnumber;

    @JsonProperty("_modifiedonbehalfby_value")
    protected UUID _modifiedonbehalfby_value;

    @JsonProperty("msdyn_componentid")
    protected String msdyn_componentid;

    @JsonProperty("msdyn_rulepasscount")
    protected Integer msdyn_rulepasscount;

    @JsonProperty("importsequencenumber")
    protected Integer importsequencenumber;

    @JsonProperty("msdyn_sevlowcount")
    protected Integer msdyn_sevlowcount;

    @JsonProperty("msdyn_warningcount")
    protected Integer msdyn_warningcount;

    @JsonProperty("msdyn_sevhighcount")
    protected Integer msdyn_sevhighcount;

    @JsonProperty("_owninguser_value")
    protected UUID _owninguser_value;

    @JsonProperty("utcconversiontimezonecode")
    protected Integer utcconversiontimezonecode;

    @JsonProperty("_msdyn_solutionhealthrulesetid_value")
    protected UUID _msdyn_solutionhealthrulesetid_value;

    @JsonProperty("msdyn_componentname")
    protected String msdyn_componentname;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("_owningteam_value")
    protected UUID _owningteam_value;

    @JsonProperty("msdyn_rulefailcount")
    protected Integer msdyn_rulefailcount;

    @JsonProperty("msdyn_retrycount")
    protected Integer msdyn_retrycount;

    @JsonProperty("_owningbusinessunit_value")
    protected UUID _owningbusinessunit_value;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    protected Msdyn_analysiscomponent() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMsdyn_analysiscomponent() {
        return new Builder();
    }

    public static final class Builder {
        private Integer statecode;
        private Integer msdyn_rulepassrate;
        private String msdyn_componentversion;
        private Integer statuscode;
        private OffsetDateTime overriddencreatedon;
        private UUID _modifiedby_value;
        private UUID _ownerid_value;
        private OffsetDateTime modifiedon;
        private Integer msdyn_sevmediumcount;
        private Integer msdyn_sevcriticalcount;
        private UUID msdyn_analysiscomponentid;
        private String msdyn_name;
        private UUID _msdyn_analysisjobid_value;
        private Integer msdyn_componenttype;
        private Integer msdyn_errorcount;
        private UUID _createdby_value;
        private UUID _createdonbehalfby_value;
        private Integer msdyn_analysiscomponenttype;
        private Integer timezoneruleversionnumber;
        private UUID _modifiedonbehalfby_value;
        private String msdyn_componentid;
        private Integer msdyn_rulepasscount;
        private Integer importsequencenumber;
        private Integer msdyn_sevlowcount;
        private Integer msdyn_warningcount;
        private Integer msdyn_sevhighcount;
        private UUID _owninguser_value;
        private Integer utcconversiontimezonecode;
        private UUID _msdyn_solutionhealthrulesetid_value;
        private String msdyn_componentname;
        private OffsetDateTime createdon;
        private UUID _owningteam_value;
        private Integer msdyn_rulefailcount;
        private Integer msdyn_retrycount;
        private UUID _owningbusinessunit_value;
        private Long versionnumber;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder statecode(Integer statecode) {
            this.statecode = statecode;
            this.changedFields = changedFields.add("statecode");
            return this;
        }

        public Builder msdyn_rulepassrate(Integer msdyn_rulepassrate) {
            this.msdyn_rulepassrate = msdyn_rulepassrate;
            this.changedFields = changedFields.add("msdyn_rulepassrate");
            return this;
        }

        public Builder msdyn_componentversion(String msdyn_componentversion) {
            this.msdyn_componentversion = msdyn_componentversion;
            this.changedFields = changedFields.add("msdyn_componentversion");
            return this;
        }

        public Builder statuscode(Integer statuscode) {
            this.statuscode = statuscode;
            this.changedFields = changedFields.add("statuscode");
            return this;
        }

        public Builder overriddencreatedon(OffsetDateTime overriddencreatedon) {
            this.overriddencreatedon = overriddencreatedon;
            this.changedFields = changedFields.add("overriddencreatedon");
            return this;
        }

        public Builder _modifiedby_value(UUID _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder _ownerid_value(UUID _ownerid_value) {
            this._ownerid_value = _ownerid_value;
            this.changedFields = changedFields.add("_ownerid_value");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder msdyn_sevmediumcount(Integer msdyn_sevmediumcount) {
            this.msdyn_sevmediumcount = msdyn_sevmediumcount;
            this.changedFields = changedFields.add("msdyn_sevmediumcount");
            return this;
        }

        public Builder msdyn_sevcriticalcount(Integer msdyn_sevcriticalcount) {
            this.msdyn_sevcriticalcount = msdyn_sevcriticalcount;
            this.changedFields = changedFields.add("msdyn_sevcriticalcount");
            return this;
        }

        public Builder msdyn_analysiscomponentid(UUID msdyn_analysiscomponentid) {
            this.msdyn_analysiscomponentid = msdyn_analysiscomponentid;
            this.changedFields = changedFields.add("msdyn_analysiscomponentid");
            return this;
        }

        public Builder msdyn_name(String msdyn_name) {
            this.msdyn_name = msdyn_name;
            this.changedFields = changedFields.add("msdyn_name");
            return this;
        }

        public Builder _msdyn_analysisjobid_value(UUID _msdyn_analysisjobid_value) {
            this._msdyn_analysisjobid_value = _msdyn_analysisjobid_value;
            this.changedFields = changedFields.add("_msdyn_analysisjobid_value");
            return this;
        }

        public Builder msdyn_componenttype(Integer msdyn_componenttype) {
            this.msdyn_componenttype = msdyn_componenttype;
            this.changedFields = changedFields.add("msdyn_componenttype");
            return this;
        }

        public Builder msdyn_errorcount(Integer msdyn_errorcount) {
            this.msdyn_errorcount = msdyn_errorcount;
            this.changedFields = changedFields.add("msdyn_errorcount");
            return this;
        }

        public Builder _createdby_value(UUID _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder _createdonbehalfby_value(UUID _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder msdyn_analysiscomponenttype(Integer msdyn_analysiscomponenttype) {
            this.msdyn_analysiscomponenttype = msdyn_analysiscomponenttype;
            this.changedFields = changedFields.add("msdyn_analysiscomponenttype");
            return this;
        }

        public Builder timezoneruleversionnumber(Integer timezoneruleversionnumber) {
            this.timezoneruleversionnumber = timezoneruleversionnumber;
            this.changedFields = changedFields.add("timezoneruleversionnumber");
            return this;
        }

        public Builder _modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder msdyn_componentid(String msdyn_componentid) {
            this.msdyn_componentid = msdyn_componentid;
            this.changedFields = changedFields.add("msdyn_componentid");
            return this;
        }

        public Builder msdyn_rulepasscount(Integer msdyn_rulepasscount) {
            this.msdyn_rulepasscount = msdyn_rulepasscount;
            this.changedFields = changedFields.add("msdyn_rulepasscount");
            return this;
        }

        public Builder importsequencenumber(Integer importsequencenumber) {
            this.importsequencenumber = importsequencenumber;
            this.changedFields = changedFields.add("importsequencenumber");
            return this;
        }

        public Builder msdyn_sevlowcount(Integer msdyn_sevlowcount) {
            this.msdyn_sevlowcount = msdyn_sevlowcount;
            this.changedFields = changedFields.add("msdyn_sevlowcount");
            return this;
        }

        public Builder msdyn_warningcount(Integer msdyn_warningcount) {
            this.msdyn_warningcount = msdyn_warningcount;
            this.changedFields = changedFields.add("msdyn_warningcount");
            return this;
        }

        public Builder msdyn_sevhighcount(Integer msdyn_sevhighcount) {
            this.msdyn_sevhighcount = msdyn_sevhighcount;
            this.changedFields = changedFields.add("msdyn_sevhighcount");
            return this;
        }

        public Builder _owninguser_value(UUID _owninguser_value) {
            this._owninguser_value = _owninguser_value;
            this.changedFields = changedFields.add("_owninguser_value");
            return this;
        }

        public Builder utcconversiontimezonecode(Integer utcconversiontimezonecode) {
            this.utcconversiontimezonecode = utcconversiontimezonecode;
            this.changedFields = changedFields.add("utcconversiontimezonecode");
            return this;
        }

        public Builder _msdyn_solutionhealthrulesetid_value(UUID _msdyn_solutionhealthrulesetid_value) {
            this._msdyn_solutionhealthrulesetid_value = _msdyn_solutionhealthrulesetid_value;
            this.changedFields = changedFields.add("_msdyn_solutionhealthrulesetid_value");
            return this;
        }

        public Builder msdyn_componentname(String msdyn_componentname) {
            this.msdyn_componentname = msdyn_componentname;
            this.changedFields = changedFields.add("msdyn_componentname");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder _owningteam_value(UUID _owningteam_value) {
            this._owningteam_value = _owningteam_value;
            this.changedFields = changedFields.add("_owningteam_value");
            return this;
        }

        public Builder msdyn_rulefailcount(Integer msdyn_rulefailcount) {
            this.msdyn_rulefailcount = msdyn_rulefailcount;
            this.changedFields = changedFields.add("msdyn_rulefailcount");
            return this;
        }

        public Builder msdyn_retrycount(Integer msdyn_retrycount) {
            this.msdyn_retrycount = msdyn_retrycount;
            this.changedFields = changedFields.add("msdyn_retrycount");
            return this;
        }

        public Builder _owningbusinessunit_value(UUID _owningbusinessunit_value) {
            this._owningbusinessunit_value = _owningbusinessunit_value;
            this.changedFields = changedFields.add("_owningbusinessunit_value");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Msdyn_analysiscomponent build() {
            Msdyn_analysiscomponent _x = new Msdyn_analysiscomponent();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.msdyn_analysiscomponent";
            _x.statecode = statecode;
            _x.msdyn_rulepassrate = msdyn_rulepassrate;
            _x.msdyn_componentversion = msdyn_componentversion;
            _x.statuscode = statuscode;
            _x.overriddencreatedon = overriddencreatedon;
            _x._modifiedby_value = _modifiedby_value;
            _x._ownerid_value = _ownerid_value;
            _x.modifiedon = modifiedon;
            _x.msdyn_sevmediumcount = msdyn_sevmediumcount;
            _x.msdyn_sevcriticalcount = msdyn_sevcriticalcount;
            _x.msdyn_analysiscomponentid = msdyn_analysiscomponentid;
            _x.msdyn_name = msdyn_name;
            _x._msdyn_analysisjobid_value = _msdyn_analysisjobid_value;
            _x.msdyn_componenttype = msdyn_componenttype;
            _x.msdyn_errorcount = msdyn_errorcount;
            _x._createdby_value = _createdby_value;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.msdyn_analysiscomponenttype = msdyn_analysiscomponenttype;
            _x.timezoneruleversionnumber = timezoneruleversionnumber;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.msdyn_componentid = msdyn_componentid;
            _x.msdyn_rulepasscount = msdyn_rulepasscount;
            _x.importsequencenumber = importsequencenumber;
            _x.msdyn_sevlowcount = msdyn_sevlowcount;
            _x.msdyn_warningcount = msdyn_warningcount;
            _x.msdyn_sevhighcount = msdyn_sevhighcount;
            _x._owninguser_value = _owninguser_value;
            _x.utcconversiontimezonecode = utcconversiontimezonecode;
            _x._msdyn_solutionhealthrulesetid_value = _msdyn_solutionhealthrulesetid_value;
            _x.msdyn_componentname = msdyn_componentname;
            _x.createdon = createdon;
            _x._owningteam_value = _owningteam_value;
            _x.msdyn_rulefailcount = msdyn_rulefailcount;
            _x.msdyn_retrycount = msdyn_retrycount;
            _x._owningbusinessunit_value = _owningbusinessunit_value;
            _x.versionnumber = versionnumber;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && msdyn_analysiscomponentid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(msdyn_analysiscomponentid, UUID.class));
        }
    }

    @Property(name="statecode")
    @JsonIgnore
    public Optional<Integer> getStatecode() {
        return Optional.ofNullable(statecode);
    }

    public Msdyn_analysiscomponent withStatecode(Integer statecode) {
        Msdyn_analysiscomponent _x = _copy();
        _x.changedFields = changedFields.add("statecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysiscomponent");
        _x.statecode = statecode;
        return _x;
    }

    @Property(name="msdyn_rulepassrate")
    @JsonIgnore
    public Optional<Integer> getMsdyn_rulepassrate() {
        return Optional.ofNullable(msdyn_rulepassrate);
    }

    public Msdyn_analysiscomponent withMsdyn_rulepassrate(Integer msdyn_rulepassrate) {
        Msdyn_analysiscomponent _x = _copy();
        _x.changedFields = changedFields.add("msdyn_rulepassrate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysiscomponent");
        _x.msdyn_rulepassrate = msdyn_rulepassrate;
        return _x;
    }

    @Property(name="msdyn_componentversion")
    @JsonIgnore
    public Optional<String> getMsdyn_componentversion() {
        return Optional.ofNullable(msdyn_componentversion);
    }

    public Msdyn_analysiscomponent withMsdyn_componentversion(String msdyn_componentversion) {
        Checks.checkIsAscii(msdyn_componentversion);
        Msdyn_analysiscomponent _x = _copy();
        _x.changedFields = changedFields.add("msdyn_componentversion");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysiscomponent");
        _x.msdyn_componentversion = msdyn_componentversion;
        return _x;
    }

    @Property(name="statuscode")
    @JsonIgnore
    public Optional<Integer> getStatuscode() {
        return Optional.ofNullable(statuscode);
    }

    public Msdyn_analysiscomponent withStatuscode(Integer statuscode) {
        Msdyn_analysiscomponent _x = _copy();
        _x.changedFields = changedFields.add("statuscode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysiscomponent");
        _x.statuscode = statuscode;
        return _x;
    }

    @Property(name="overriddencreatedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverriddencreatedon() {
        return Optional.ofNullable(overriddencreatedon);
    }

    public Msdyn_analysiscomponent withOverriddencreatedon(OffsetDateTime overriddencreatedon) {
        Msdyn_analysiscomponent _x = _copy();
        _x.changedFields = changedFields.add("overriddencreatedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysiscomponent");
        _x.overriddencreatedon = overriddencreatedon;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Msdyn_analysiscomponent with_modifiedby_value(UUID _modifiedby_value) {
        Msdyn_analysiscomponent _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysiscomponent");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="_ownerid_value")
    @JsonIgnore
    public Optional<UUID> get_ownerid_value() {
        return Optional.ofNullable(_ownerid_value);
    }

    public Msdyn_analysiscomponent with_ownerid_value(UUID _ownerid_value) {
        Msdyn_analysiscomponent _x = _copy();
        _x.changedFields = changedFields.add("_ownerid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysiscomponent");
        _x._ownerid_value = _ownerid_value;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Msdyn_analysiscomponent withModifiedon(OffsetDateTime modifiedon) {
        Msdyn_analysiscomponent _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysiscomponent");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="msdyn_sevmediumcount")
    @JsonIgnore
    public Optional<Integer> getMsdyn_sevmediumcount() {
        return Optional.ofNullable(msdyn_sevmediumcount);
    }

    public Msdyn_analysiscomponent withMsdyn_sevmediumcount(Integer msdyn_sevmediumcount) {
        Msdyn_analysiscomponent _x = _copy();
        _x.changedFields = changedFields.add("msdyn_sevmediumcount");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysiscomponent");
        _x.msdyn_sevmediumcount = msdyn_sevmediumcount;
        return _x;
    }

    @Property(name="msdyn_sevcriticalcount")
    @JsonIgnore
    public Optional<Integer> getMsdyn_sevcriticalcount() {
        return Optional.ofNullable(msdyn_sevcriticalcount);
    }

    public Msdyn_analysiscomponent withMsdyn_sevcriticalcount(Integer msdyn_sevcriticalcount) {
        Msdyn_analysiscomponent _x = _copy();
        _x.changedFields = changedFields.add("msdyn_sevcriticalcount");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysiscomponent");
        _x.msdyn_sevcriticalcount = msdyn_sevcriticalcount;
        return _x;
    }

    @Property(name="msdyn_analysiscomponentid")
    @JsonIgnore
    public Optional<UUID> getMsdyn_analysiscomponentid() {
        return Optional.ofNullable(msdyn_analysiscomponentid);
    }

    public Msdyn_analysiscomponent withMsdyn_analysiscomponentid(UUID msdyn_analysiscomponentid) {
        Msdyn_analysiscomponent _x = _copy();
        _x.changedFields = changedFields.add("msdyn_analysiscomponentid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysiscomponent");
        _x.msdyn_analysiscomponentid = msdyn_analysiscomponentid;
        return _x;
    }

    @Property(name="msdyn_name")
    @JsonIgnore
    public Optional<String> getMsdyn_name() {
        return Optional.ofNullable(msdyn_name);
    }

    public Msdyn_analysiscomponent withMsdyn_name(String msdyn_name) {
        Checks.checkIsAscii(msdyn_name);
        Msdyn_analysiscomponent _x = _copy();
        _x.changedFields = changedFields.add("msdyn_name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysiscomponent");
        _x.msdyn_name = msdyn_name;
        return _x;
    }

    @Property(name="_msdyn_analysisjobid_value")
    @JsonIgnore
    public Optional<UUID> get_msdyn_analysisjobid_value() {
        return Optional.ofNullable(_msdyn_analysisjobid_value);
    }

    public Msdyn_analysiscomponent with_msdyn_analysisjobid_value(UUID _msdyn_analysisjobid_value) {
        Msdyn_analysiscomponent _x = _copy();
        _x.changedFields = changedFields.add("_msdyn_analysisjobid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysiscomponent");
        _x._msdyn_analysisjobid_value = _msdyn_analysisjobid_value;
        return _x;
    }

    @Property(name="msdyn_componenttype")
    @JsonIgnore
    public Optional<Integer> getMsdyn_componenttype() {
        return Optional.ofNullable(msdyn_componenttype);
    }

    public Msdyn_analysiscomponent withMsdyn_componenttype(Integer msdyn_componenttype) {
        Msdyn_analysiscomponent _x = _copy();
        _x.changedFields = changedFields.add("msdyn_componenttype");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysiscomponent");
        _x.msdyn_componenttype = msdyn_componenttype;
        return _x;
    }

    @Property(name="msdyn_errorcount")
    @JsonIgnore
    public Optional<Integer> getMsdyn_errorcount() {
        return Optional.ofNullable(msdyn_errorcount);
    }

    public Msdyn_analysiscomponent withMsdyn_errorcount(Integer msdyn_errorcount) {
        Msdyn_analysiscomponent _x = _copy();
        _x.changedFields = changedFields.add("msdyn_errorcount");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysiscomponent");
        _x.msdyn_errorcount = msdyn_errorcount;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<UUID> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Msdyn_analysiscomponent with_createdby_value(UUID _createdby_value) {
        Msdyn_analysiscomponent _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysiscomponent");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Msdyn_analysiscomponent with_createdonbehalfby_value(UUID _createdonbehalfby_value) {
        Msdyn_analysiscomponent _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysiscomponent");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="msdyn_analysiscomponenttype")
    @JsonIgnore
    public Optional<Integer> getMsdyn_analysiscomponenttype() {
        return Optional.ofNullable(msdyn_analysiscomponenttype);
    }

    public Msdyn_analysiscomponent withMsdyn_analysiscomponenttype(Integer msdyn_analysiscomponenttype) {
        Msdyn_analysiscomponent _x = _copy();
        _x.changedFields = changedFields.add("msdyn_analysiscomponenttype");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysiscomponent");
        _x.msdyn_analysiscomponenttype = msdyn_analysiscomponenttype;
        return _x;
    }

    @Property(name="timezoneruleversionnumber")
    @JsonIgnore
    public Optional<Integer> getTimezoneruleversionnumber() {
        return Optional.ofNullable(timezoneruleversionnumber);
    }

    public Msdyn_analysiscomponent withTimezoneruleversionnumber(Integer timezoneruleversionnumber) {
        Msdyn_analysiscomponent _x = _copy();
        _x.changedFields = changedFields.add("timezoneruleversionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysiscomponent");
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Msdyn_analysiscomponent with_modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
        Msdyn_analysiscomponent _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysiscomponent");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="msdyn_componentid")
    @JsonIgnore
    public Optional<String> getMsdyn_componentid() {
        return Optional.ofNullable(msdyn_componentid);
    }

    public Msdyn_analysiscomponent withMsdyn_componentid(String msdyn_componentid) {
        Checks.checkIsAscii(msdyn_componentid);
        Msdyn_analysiscomponent _x = _copy();
        _x.changedFields = changedFields.add("msdyn_componentid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysiscomponent");
        _x.msdyn_componentid = msdyn_componentid;
        return _x;
    }

    @Property(name="msdyn_rulepasscount")
    @JsonIgnore
    public Optional<Integer> getMsdyn_rulepasscount() {
        return Optional.ofNullable(msdyn_rulepasscount);
    }

    public Msdyn_analysiscomponent withMsdyn_rulepasscount(Integer msdyn_rulepasscount) {
        Msdyn_analysiscomponent _x = _copy();
        _x.changedFields = changedFields.add("msdyn_rulepasscount");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysiscomponent");
        _x.msdyn_rulepasscount = msdyn_rulepasscount;
        return _x;
    }

    @Property(name="importsequencenumber")
    @JsonIgnore
    public Optional<Integer> getImportsequencenumber() {
        return Optional.ofNullable(importsequencenumber);
    }

    public Msdyn_analysiscomponent withImportsequencenumber(Integer importsequencenumber) {
        Msdyn_analysiscomponent _x = _copy();
        _x.changedFields = changedFields.add("importsequencenumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysiscomponent");
        _x.importsequencenumber = importsequencenumber;
        return _x;
    }

    @Property(name="msdyn_sevlowcount")
    @JsonIgnore
    public Optional<Integer> getMsdyn_sevlowcount() {
        return Optional.ofNullable(msdyn_sevlowcount);
    }

    public Msdyn_analysiscomponent withMsdyn_sevlowcount(Integer msdyn_sevlowcount) {
        Msdyn_analysiscomponent _x = _copy();
        _x.changedFields = changedFields.add("msdyn_sevlowcount");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysiscomponent");
        _x.msdyn_sevlowcount = msdyn_sevlowcount;
        return _x;
    }

    @Property(name="msdyn_warningcount")
    @JsonIgnore
    public Optional<Integer> getMsdyn_warningcount() {
        return Optional.ofNullable(msdyn_warningcount);
    }

    public Msdyn_analysiscomponent withMsdyn_warningcount(Integer msdyn_warningcount) {
        Msdyn_analysiscomponent _x = _copy();
        _x.changedFields = changedFields.add("msdyn_warningcount");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysiscomponent");
        _x.msdyn_warningcount = msdyn_warningcount;
        return _x;
    }

    @Property(name="msdyn_sevhighcount")
    @JsonIgnore
    public Optional<Integer> getMsdyn_sevhighcount() {
        return Optional.ofNullable(msdyn_sevhighcount);
    }

    public Msdyn_analysiscomponent withMsdyn_sevhighcount(Integer msdyn_sevhighcount) {
        Msdyn_analysiscomponent _x = _copy();
        _x.changedFields = changedFields.add("msdyn_sevhighcount");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysiscomponent");
        _x.msdyn_sevhighcount = msdyn_sevhighcount;
        return _x;
    }

    @Property(name="_owninguser_value")
    @JsonIgnore
    public Optional<UUID> get_owninguser_value() {
        return Optional.ofNullable(_owninguser_value);
    }

    public Msdyn_analysiscomponent with_owninguser_value(UUID _owninguser_value) {
        Msdyn_analysiscomponent _x = _copy();
        _x.changedFields = changedFields.add("_owninguser_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysiscomponent");
        _x._owninguser_value = _owninguser_value;
        return _x;
    }

    @Property(name="utcconversiontimezonecode")
    @JsonIgnore
    public Optional<Integer> getUtcconversiontimezonecode() {
        return Optional.ofNullable(utcconversiontimezonecode);
    }

    public Msdyn_analysiscomponent withUtcconversiontimezonecode(Integer utcconversiontimezonecode) {
        Msdyn_analysiscomponent _x = _copy();
        _x.changedFields = changedFields.add("utcconversiontimezonecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysiscomponent");
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        return _x;
    }

    @Property(name="_msdyn_solutionhealthrulesetid_value")
    @JsonIgnore
    public Optional<UUID> get_msdyn_solutionhealthrulesetid_value() {
        return Optional.ofNullable(_msdyn_solutionhealthrulesetid_value);
    }

    public Msdyn_analysiscomponent with_msdyn_solutionhealthrulesetid_value(UUID _msdyn_solutionhealthrulesetid_value) {
        Msdyn_analysiscomponent _x = _copy();
        _x.changedFields = changedFields.add("_msdyn_solutionhealthrulesetid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysiscomponent");
        _x._msdyn_solutionhealthrulesetid_value = _msdyn_solutionhealthrulesetid_value;
        return _x;
    }

    @Property(name="msdyn_componentname")
    @JsonIgnore
    public Optional<String> getMsdyn_componentname() {
        return Optional.ofNullable(msdyn_componentname);
    }

    public Msdyn_analysiscomponent withMsdyn_componentname(String msdyn_componentname) {
        Checks.checkIsAscii(msdyn_componentname);
        Msdyn_analysiscomponent _x = _copy();
        _x.changedFields = changedFields.add("msdyn_componentname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysiscomponent");
        _x.msdyn_componentname = msdyn_componentname;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Msdyn_analysiscomponent withCreatedon(OffsetDateTime createdon) {
        Msdyn_analysiscomponent _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysiscomponent");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="_owningteam_value")
    @JsonIgnore
    public Optional<UUID> get_owningteam_value() {
        return Optional.ofNullable(_owningteam_value);
    }

    public Msdyn_analysiscomponent with_owningteam_value(UUID _owningteam_value) {
        Msdyn_analysiscomponent _x = _copy();
        _x.changedFields = changedFields.add("_owningteam_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysiscomponent");
        _x._owningteam_value = _owningteam_value;
        return _x;
    }

    @Property(name="msdyn_rulefailcount")
    @JsonIgnore
    public Optional<Integer> getMsdyn_rulefailcount() {
        return Optional.ofNullable(msdyn_rulefailcount);
    }

    public Msdyn_analysiscomponent withMsdyn_rulefailcount(Integer msdyn_rulefailcount) {
        Msdyn_analysiscomponent _x = _copy();
        _x.changedFields = changedFields.add("msdyn_rulefailcount");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysiscomponent");
        _x.msdyn_rulefailcount = msdyn_rulefailcount;
        return _x;
    }

    @Property(name="msdyn_retrycount")
    @JsonIgnore
    public Optional<Integer> getMsdyn_retrycount() {
        return Optional.ofNullable(msdyn_retrycount);
    }

    public Msdyn_analysiscomponent withMsdyn_retrycount(Integer msdyn_retrycount) {
        Msdyn_analysiscomponent _x = _copy();
        _x.changedFields = changedFields.add("msdyn_retrycount");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysiscomponent");
        _x.msdyn_retrycount = msdyn_retrycount;
        return _x;
    }

    @Property(name="_owningbusinessunit_value")
    @JsonIgnore
    public Optional<UUID> get_owningbusinessunit_value() {
        return Optional.ofNullable(_owningbusinessunit_value);
    }

    public Msdyn_analysiscomponent with_owningbusinessunit_value(UUID _owningbusinessunit_value) {
        Msdyn_analysiscomponent _x = _copy();
        _x.changedFields = changedFields.add("_owningbusinessunit_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysiscomponent");
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Msdyn_analysiscomponent withVersionnumber(Long versionnumber) {
        Msdyn_analysiscomponent _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysiscomponent");
        _x.versionnumber = versionnumber;
        return _x;
    }

    public Msdyn_analysiscomponent withUnmappedField(String name, String value) {
        Msdyn_analysiscomponent _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="owninguser")
    @JsonIgnore
    public SystemuserRequest getOwninguser() {
        return new SystemuserRequest(contextPath.addSegment("owninguser"), RequestHelper.getValue(unmappedFields, "owninguser"));
    }

    @NavigationProperty(name="owningteam")
    @JsonIgnore
    public TeamRequest getOwningteam() {
        return new TeamRequest(contextPath.addSegment("owningteam"), RequestHelper.getValue(unmappedFields, "owningteam"));
    }

    @NavigationProperty(name="ownerid")
    @JsonIgnore
    public PrincipalRequest getOwnerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), RequestHelper.getValue(unmappedFields, "ownerid"));
    }

    @NavigationProperty(name="owningbusinessunit")
    @JsonIgnore
    public BusinessunitRequest getOwningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), RequestHelper.getValue(unmappedFields, "owningbusinessunit"));
    }

    @NavigationProperty(name="msdyn_analysiscomponent_SyncErrors")
    @JsonIgnore
    public SyncerrorCollectionRequest getMsdyn_analysiscomponent_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("msdyn_analysiscomponent_SyncErrors"), RequestHelper.getValue(unmappedFields, "msdyn_analysiscomponent_SyncErrors"));
    }

    @NavigationProperty(name="msdyn_analysiscomponent_DuplicateMatchingRecord")
    @JsonIgnore
    public DuplicaterecordCollectionRequest getMsdyn_analysiscomponent_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("msdyn_analysiscomponent_DuplicateMatchingRecord"), RequestHelper.getValue(unmappedFields, "msdyn_analysiscomponent_DuplicateMatchingRecord"));
    }

    @NavigationProperty(name="msdyn_analysiscomponent_DuplicateBaseRecord")
    @JsonIgnore
    public DuplicaterecordCollectionRequest getMsdyn_analysiscomponent_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("msdyn_analysiscomponent_DuplicateBaseRecord"), RequestHelper.getValue(unmappedFields, "msdyn_analysiscomponent_DuplicateBaseRecord"));
    }

    @NavigationProperty(name="msdyn_analysiscomponent_AsyncOperations")
    @JsonIgnore
    public AsyncoperationCollectionRequest getMsdyn_analysiscomponent_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("msdyn_analysiscomponent_AsyncOperations"), RequestHelper.getValue(unmappedFields, "msdyn_analysiscomponent_AsyncOperations"));
    }

    @NavigationProperty(name="msdyn_analysiscomponent_MailboxTrackingFolders")
    @JsonIgnore
    public MailboxtrackingfolderCollectionRequest getMsdyn_analysiscomponent_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(
                        contextPath.addSegment("msdyn_analysiscomponent_MailboxTrackingFolders"), RequestHelper.getValue(unmappedFields, "msdyn_analysiscomponent_MailboxTrackingFolders"));
    }

    @NavigationProperty(name="msdyn_analysiscomponent_ProcessSession")
    @JsonIgnore
    public ProcesssessionCollectionRequest getMsdyn_analysiscomponent_ProcessSession() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("msdyn_analysiscomponent_ProcessSession"), RequestHelper.getValue(unmappedFields, "msdyn_analysiscomponent_ProcessSession"));
    }

    @NavigationProperty(name="msdyn_analysiscomponent_BulkDeleteFailures")
    @JsonIgnore
    public BulkdeletefailureCollectionRequest getMsdyn_analysiscomponent_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("msdyn_analysiscomponent_BulkDeleteFailures"), RequestHelper.getValue(unmappedFields, "msdyn_analysiscomponent_BulkDeleteFailures"));
    }

    @NavigationProperty(name="msdyn_analysiscomponent_PrincipalObjectAttributeAccesses")
    @JsonIgnore
    public PrincipalobjectattributeaccessCollectionRequest getMsdyn_analysiscomponent_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("msdyn_analysiscomponent_PrincipalObjectAttributeAccesses"), RequestHelper.getValue(unmappedFields, "msdyn_analysiscomponent_PrincipalObjectAttributeAccesses"));
    }

    @NavigationProperty(name="msdyn_analysiscomponent_msdyn_analysisresult")
    @JsonIgnore
    public Msdyn_analysisresultCollectionRequest getMsdyn_analysiscomponent_msdyn_analysisresult() {
        return new Msdyn_analysisresultCollectionRequest(
                        contextPath.addSegment("msdyn_analysiscomponent_msdyn_analysisresult"), RequestHelper.getValue(unmappedFields, "msdyn_analysiscomponent_msdyn_analysisresult"));
    }

    @NavigationProperty(name="msdyn_AnalysisJobId")
    @JsonIgnore
    public Msdyn_analysisjobRequest getMsdyn_AnalysisJobId() {
        return new Msdyn_analysisjobRequest(contextPath.addSegment("msdyn_AnalysisJobId"), RequestHelper.getValue(unmappedFields, "msdyn_AnalysisJobId"));
    }

    @NavigationProperty(name="msdyn_SolutionHealthRuleSetId")
    @JsonIgnore
    public Msdyn_solutionhealthrulesetRequest getMsdyn_SolutionHealthRuleSetId() {
        return new Msdyn_solutionhealthrulesetRequest(contextPath.addSegment("msdyn_SolutionHealthRuleSetId"), RequestHelper.getValue(unmappedFields, "msdyn_SolutionHealthRuleSetId"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Msdyn_analysiscomponent patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Msdyn_analysiscomponent _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Msdyn_analysiscomponent put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Msdyn_analysiscomponent _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Msdyn_analysiscomponent _copy() {
        Msdyn_analysiscomponent _x = new Msdyn_analysiscomponent();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.statecode = statecode;
        _x.msdyn_rulepassrate = msdyn_rulepassrate;
        _x.msdyn_componentversion = msdyn_componentversion;
        _x.statuscode = statuscode;
        _x.overriddencreatedon = overriddencreatedon;
        _x._modifiedby_value = _modifiedby_value;
        _x._ownerid_value = _ownerid_value;
        _x.modifiedon = modifiedon;
        _x.msdyn_sevmediumcount = msdyn_sevmediumcount;
        _x.msdyn_sevcriticalcount = msdyn_sevcriticalcount;
        _x.msdyn_analysiscomponentid = msdyn_analysiscomponentid;
        _x.msdyn_name = msdyn_name;
        _x._msdyn_analysisjobid_value = _msdyn_analysisjobid_value;
        _x.msdyn_componenttype = msdyn_componenttype;
        _x.msdyn_errorcount = msdyn_errorcount;
        _x._createdby_value = _createdby_value;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.msdyn_analysiscomponenttype = msdyn_analysiscomponenttype;
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.msdyn_componentid = msdyn_componentid;
        _x.msdyn_rulepasscount = msdyn_rulepasscount;
        _x.importsequencenumber = importsequencenumber;
        _x.msdyn_sevlowcount = msdyn_sevlowcount;
        _x.msdyn_warningcount = msdyn_warningcount;
        _x.msdyn_sevhighcount = msdyn_sevhighcount;
        _x._owninguser_value = _owninguser_value;
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        _x._msdyn_solutionhealthrulesetid_value = _msdyn_solutionhealthrulesetid_value;
        _x.msdyn_componentname = msdyn_componentname;
        _x.createdon = createdon;
        _x._owningteam_value = _owningteam_value;
        _x.msdyn_rulefailcount = msdyn_rulefailcount;
        _x.msdyn_retrycount = msdyn_retrycount;
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Msdyn_analysiscomponent[");
        b.append("statecode=");
        b.append(this.statecode);
        b.append(", ");
        b.append("msdyn_rulepassrate=");
        b.append(this.msdyn_rulepassrate);
        b.append(", ");
        b.append("msdyn_componentversion=");
        b.append(this.msdyn_componentversion);
        b.append(", ");
        b.append("statuscode=");
        b.append(this.statuscode);
        b.append(", ");
        b.append("overriddencreatedon=");
        b.append(this.overriddencreatedon);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("_ownerid_value=");
        b.append(this._ownerid_value);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("msdyn_sevmediumcount=");
        b.append(this.msdyn_sevmediumcount);
        b.append(", ");
        b.append("msdyn_sevcriticalcount=");
        b.append(this.msdyn_sevcriticalcount);
        b.append(", ");
        b.append("msdyn_analysiscomponentid=");
        b.append(this.msdyn_analysiscomponentid);
        b.append(", ");
        b.append("msdyn_name=");
        b.append(this.msdyn_name);
        b.append(", ");
        b.append("_msdyn_analysisjobid_value=");
        b.append(this._msdyn_analysisjobid_value);
        b.append(", ");
        b.append("msdyn_componenttype=");
        b.append(this.msdyn_componenttype);
        b.append(", ");
        b.append("msdyn_errorcount=");
        b.append(this.msdyn_errorcount);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("msdyn_analysiscomponenttype=");
        b.append(this.msdyn_analysiscomponenttype);
        b.append(", ");
        b.append("timezoneruleversionnumber=");
        b.append(this.timezoneruleversionnumber);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("msdyn_componentid=");
        b.append(this.msdyn_componentid);
        b.append(", ");
        b.append("msdyn_rulepasscount=");
        b.append(this.msdyn_rulepasscount);
        b.append(", ");
        b.append("importsequencenumber=");
        b.append(this.importsequencenumber);
        b.append(", ");
        b.append("msdyn_sevlowcount=");
        b.append(this.msdyn_sevlowcount);
        b.append(", ");
        b.append("msdyn_warningcount=");
        b.append(this.msdyn_warningcount);
        b.append(", ");
        b.append("msdyn_sevhighcount=");
        b.append(this.msdyn_sevhighcount);
        b.append(", ");
        b.append("_owninguser_value=");
        b.append(this._owninguser_value);
        b.append(", ");
        b.append("utcconversiontimezonecode=");
        b.append(this.utcconversiontimezonecode);
        b.append(", ");
        b.append("_msdyn_solutionhealthrulesetid_value=");
        b.append(this._msdyn_solutionhealthrulesetid_value);
        b.append(", ");
        b.append("msdyn_componentname=");
        b.append(this.msdyn_componentname);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("_owningteam_value=");
        b.append(this._owningteam_value);
        b.append(", ");
        b.append("msdyn_rulefailcount=");
        b.append(this.msdyn_rulefailcount);
        b.append(", ");
        b.append("msdyn_retrycount=");
        b.append(this.msdyn_retrycount);
        b.append(", ");
        b.append("_owningbusinessunit_value=");
        b.append(this._owningbusinessunit_value);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
