package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.collection.request.AnnotationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MailboxtrackingfolderCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.request.BusinessunitRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aiconfigurationRequest;
import microsoft.dynamics.crm.entity.request.PrincipalRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.TeamRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "timezoneruleversionnumber", 
    "msdyn_name", 
    "importsequencenumber", 
    "utcconversiontimezonecode", 
    "_msdyn_aiconfigurationid_value", 
    "msdyn_aifptrainingdocumentid", 
    "_owningteam_value", 
    "_modifiedonbehalfby_value", 
    "_ownerid_value", 
    "_modifiedby_value", 
    "createdon", 
    "_createdonbehalfby_value", 
    "overriddencreatedon", 
    "msdyn_checksum", 
    "msdyn_sourcetype", 
    "_createdby_value", 
    "msdyn_metadata", 
    "_owninguser_value", 
    "statuscode", 
    "_owningbusinessunit_value", 
    "modifiedon", 
    "versionnumber", 
    "statecode"})
@JsonInclude(Include.NON_NULL)
public class Msdyn_aifptrainingdocument extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.msdyn_aifptrainingdocument";
    }

    @JsonProperty("timezoneruleversionnumber")
    protected Integer timezoneruleversionnumber;

    @JsonProperty("msdyn_name")
    protected String msdyn_name;

    @JsonProperty("importsequencenumber")
    protected Integer importsequencenumber;

    @JsonProperty("utcconversiontimezonecode")
    protected Integer utcconversiontimezonecode;

    @JsonProperty("_msdyn_aiconfigurationid_value")
    protected UUID _msdyn_aiconfigurationid_value;

    @JsonProperty("msdyn_aifptrainingdocumentid")
    protected UUID msdyn_aifptrainingdocumentid;

    @JsonProperty("_owningteam_value")
    protected UUID _owningteam_value;

    @JsonProperty("_modifiedonbehalfby_value")
    protected UUID _modifiedonbehalfby_value;

    @JsonProperty("_ownerid_value")
    protected UUID _ownerid_value;

    @JsonProperty("_modifiedby_value")
    protected UUID _modifiedby_value;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("_createdonbehalfby_value")
    protected UUID _createdonbehalfby_value;

    @JsonProperty("overriddencreatedon")
    protected OffsetDateTime overriddencreatedon;

    @JsonProperty("msdyn_checksum")
    protected String msdyn_checksum;

    @JsonProperty("msdyn_sourcetype")
    protected String msdyn_sourcetype;

    @JsonProperty("_createdby_value")
    protected UUID _createdby_value;

    @JsonProperty("msdyn_metadata")
    protected String msdyn_metadata;

    @JsonProperty("_owninguser_value")
    protected UUID _owninguser_value;

    @JsonProperty("statuscode")
    protected Integer statuscode;

    @JsonProperty("_owningbusinessunit_value")
    protected UUID _owningbusinessunit_value;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("statecode")
    protected Integer statecode;

    protected Msdyn_aifptrainingdocument() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMsdyn_aifptrainingdocument() {
        return new Builder();
    }

    public static final class Builder {
        private Integer timezoneruleversionnumber;
        private String msdyn_name;
        private Integer importsequencenumber;
        private Integer utcconversiontimezonecode;
        private UUID _msdyn_aiconfigurationid_value;
        private UUID msdyn_aifptrainingdocumentid;
        private UUID _owningteam_value;
        private UUID _modifiedonbehalfby_value;
        private UUID _ownerid_value;
        private UUID _modifiedby_value;
        private OffsetDateTime createdon;
        private UUID _createdonbehalfby_value;
        private OffsetDateTime overriddencreatedon;
        private String msdyn_checksum;
        private String msdyn_sourcetype;
        private UUID _createdby_value;
        private String msdyn_metadata;
        private UUID _owninguser_value;
        private Integer statuscode;
        private UUID _owningbusinessunit_value;
        private OffsetDateTime modifiedon;
        private Long versionnumber;
        private Integer statecode;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder timezoneruleversionnumber(Integer timezoneruleversionnumber) {
            this.timezoneruleversionnumber = timezoneruleversionnumber;
            this.changedFields = changedFields.add("timezoneruleversionnumber");
            return this;
        }

        public Builder msdyn_name(String msdyn_name) {
            this.msdyn_name = msdyn_name;
            this.changedFields = changedFields.add("msdyn_name");
            return this;
        }

        public Builder importsequencenumber(Integer importsequencenumber) {
            this.importsequencenumber = importsequencenumber;
            this.changedFields = changedFields.add("importsequencenumber");
            return this;
        }

        public Builder utcconversiontimezonecode(Integer utcconversiontimezonecode) {
            this.utcconversiontimezonecode = utcconversiontimezonecode;
            this.changedFields = changedFields.add("utcconversiontimezonecode");
            return this;
        }

        public Builder _msdyn_aiconfigurationid_value(UUID _msdyn_aiconfigurationid_value) {
            this._msdyn_aiconfigurationid_value = _msdyn_aiconfigurationid_value;
            this.changedFields = changedFields.add("_msdyn_aiconfigurationid_value");
            return this;
        }

        public Builder msdyn_aifptrainingdocumentid(UUID msdyn_aifptrainingdocumentid) {
            this.msdyn_aifptrainingdocumentid = msdyn_aifptrainingdocumentid;
            this.changedFields = changedFields.add("msdyn_aifptrainingdocumentid");
            return this;
        }

        public Builder _owningteam_value(UUID _owningteam_value) {
            this._owningteam_value = _owningteam_value;
            this.changedFields = changedFields.add("_owningteam_value");
            return this;
        }

        public Builder _modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder _ownerid_value(UUID _ownerid_value) {
            this._ownerid_value = _ownerid_value;
            this.changedFields = changedFields.add("_ownerid_value");
            return this;
        }

        public Builder _modifiedby_value(UUID _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder _createdonbehalfby_value(UUID _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder overriddencreatedon(OffsetDateTime overriddencreatedon) {
            this.overriddencreatedon = overriddencreatedon;
            this.changedFields = changedFields.add("overriddencreatedon");
            return this;
        }

        public Builder msdyn_checksum(String msdyn_checksum) {
            this.msdyn_checksum = msdyn_checksum;
            this.changedFields = changedFields.add("msdyn_checksum");
            return this;
        }

        public Builder msdyn_sourcetype(String msdyn_sourcetype) {
            this.msdyn_sourcetype = msdyn_sourcetype;
            this.changedFields = changedFields.add("msdyn_sourcetype");
            return this;
        }

        public Builder _createdby_value(UUID _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder msdyn_metadata(String msdyn_metadata) {
            this.msdyn_metadata = msdyn_metadata;
            this.changedFields = changedFields.add("msdyn_metadata");
            return this;
        }

        public Builder _owninguser_value(UUID _owninguser_value) {
            this._owninguser_value = _owninguser_value;
            this.changedFields = changedFields.add("_owninguser_value");
            return this;
        }

        public Builder statuscode(Integer statuscode) {
            this.statuscode = statuscode;
            this.changedFields = changedFields.add("statuscode");
            return this;
        }

        public Builder _owningbusinessunit_value(UUID _owningbusinessunit_value) {
            this._owningbusinessunit_value = _owningbusinessunit_value;
            this.changedFields = changedFields.add("_owningbusinessunit_value");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder statecode(Integer statecode) {
            this.statecode = statecode;
            this.changedFields = changedFields.add("statecode");
            return this;
        }

        public Msdyn_aifptrainingdocument build() {
            Msdyn_aifptrainingdocument _x = new Msdyn_aifptrainingdocument();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.msdyn_aifptrainingdocument";
            _x.timezoneruleversionnumber = timezoneruleversionnumber;
            _x.msdyn_name = msdyn_name;
            _x.importsequencenumber = importsequencenumber;
            _x.utcconversiontimezonecode = utcconversiontimezonecode;
            _x._msdyn_aiconfigurationid_value = _msdyn_aiconfigurationid_value;
            _x.msdyn_aifptrainingdocumentid = msdyn_aifptrainingdocumentid;
            _x._owningteam_value = _owningteam_value;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x._ownerid_value = _ownerid_value;
            _x._modifiedby_value = _modifiedby_value;
            _x.createdon = createdon;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.overriddencreatedon = overriddencreatedon;
            _x.msdyn_checksum = msdyn_checksum;
            _x.msdyn_sourcetype = msdyn_sourcetype;
            _x._createdby_value = _createdby_value;
            _x.msdyn_metadata = msdyn_metadata;
            _x._owninguser_value = _owninguser_value;
            _x.statuscode = statuscode;
            _x._owningbusinessunit_value = _owningbusinessunit_value;
            _x.modifiedon = modifiedon;
            _x.versionnumber = versionnumber;
            _x.statecode = statecode;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && msdyn_aifptrainingdocumentid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(msdyn_aifptrainingdocumentid, UUID.class));
        }
    }

    @Property(name="timezoneruleversionnumber")
    @JsonIgnore
    public Optional<Integer> getTimezoneruleversionnumber() {
        return Optional.ofNullable(timezoneruleversionnumber);
    }

    public Msdyn_aifptrainingdocument withTimezoneruleversionnumber(Integer timezoneruleversionnumber) {
        Msdyn_aifptrainingdocument _x = _copy();
        _x.changedFields = changedFields.add("timezoneruleversionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aifptrainingdocument");
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        return _x;
    }

    @Property(name="msdyn_name")
    @JsonIgnore
    public Optional<String> getMsdyn_name() {
        return Optional.ofNullable(msdyn_name);
    }

    public Msdyn_aifptrainingdocument withMsdyn_name(String msdyn_name) {
        Checks.checkIsAscii(msdyn_name);
        Msdyn_aifptrainingdocument _x = _copy();
        _x.changedFields = changedFields.add("msdyn_name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aifptrainingdocument");
        _x.msdyn_name = msdyn_name;
        return _x;
    }

    @Property(name="importsequencenumber")
    @JsonIgnore
    public Optional<Integer> getImportsequencenumber() {
        return Optional.ofNullable(importsequencenumber);
    }

    public Msdyn_aifptrainingdocument withImportsequencenumber(Integer importsequencenumber) {
        Msdyn_aifptrainingdocument _x = _copy();
        _x.changedFields = changedFields.add("importsequencenumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aifptrainingdocument");
        _x.importsequencenumber = importsequencenumber;
        return _x;
    }

    @Property(name="utcconversiontimezonecode")
    @JsonIgnore
    public Optional<Integer> getUtcconversiontimezonecode() {
        return Optional.ofNullable(utcconversiontimezonecode);
    }

    public Msdyn_aifptrainingdocument withUtcconversiontimezonecode(Integer utcconversiontimezonecode) {
        Msdyn_aifptrainingdocument _x = _copy();
        _x.changedFields = changedFields.add("utcconversiontimezonecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aifptrainingdocument");
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        return _x;
    }

    @Property(name="_msdyn_aiconfigurationid_value")
    @JsonIgnore
    public Optional<UUID> get_msdyn_aiconfigurationid_value() {
        return Optional.ofNullable(_msdyn_aiconfigurationid_value);
    }

    public Msdyn_aifptrainingdocument with_msdyn_aiconfigurationid_value(UUID _msdyn_aiconfigurationid_value) {
        Msdyn_aifptrainingdocument _x = _copy();
        _x.changedFields = changedFields.add("_msdyn_aiconfigurationid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aifptrainingdocument");
        _x._msdyn_aiconfigurationid_value = _msdyn_aiconfigurationid_value;
        return _x;
    }

    @Property(name="msdyn_aifptrainingdocumentid")
    @JsonIgnore
    public Optional<UUID> getMsdyn_aifptrainingdocumentid() {
        return Optional.ofNullable(msdyn_aifptrainingdocumentid);
    }

    public Msdyn_aifptrainingdocument withMsdyn_aifptrainingdocumentid(UUID msdyn_aifptrainingdocumentid) {
        Msdyn_aifptrainingdocument _x = _copy();
        _x.changedFields = changedFields.add("msdyn_aifptrainingdocumentid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aifptrainingdocument");
        _x.msdyn_aifptrainingdocumentid = msdyn_aifptrainingdocumentid;
        return _x;
    }

    @Property(name="_owningteam_value")
    @JsonIgnore
    public Optional<UUID> get_owningteam_value() {
        return Optional.ofNullable(_owningteam_value);
    }

    public Msdyn_aifptrainingdocument with_owningteam_value(UUID _owningteam_value) {
        Msdyn_aifptrainingdocument _x = _copy();
        _x.changedFields = changedFields.add("_owningteam_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aifptrainingdocument");
        _x._owningteam_value = _owningteam_value;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Msdyn_aifptrainingdocument with_modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
        Msdyn_aifptrainingdocument _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aifptrainingdocument");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="_ownerid_value")
    @JsonIgnore
    public Optional<UUID> get_ownerid_value() {
        return Optional.ofNullable(_ownerid_value);
    }

    public Msdyn_aifptrainingdocument with_ownerid_value(UUID _ownerid_value) {
        Msdyn_aifptrainingdocument _x = _copy();
        _x.changedFields = changedFields.add("_ownerid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aifptrainingdocument");
        _x._ownerid_value = _ownerid_value;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Msdyn_aifptrainingdocument with_modifiedby_value(UUID _modifiedby_value) {
        Msdyn_aifptrainingdocument _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aifptrainingdocument");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Msdyn_aifptrainingdocument withCreatedon(OffsetDateTime createdon) {
        Msdyn_aifptrainingdocument _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aifptrainingdocument");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Msdyn_aifptrainingdocument with_createdonbehalfby_value(UUID _createdonbehalfby_value) {
        Msdyn_aifptrainingdocument _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aifptrainingdocument");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="overriddencreatedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverriddencreatedon() {
        return Optional.ofNullable(overriddencreatedon);
    }

    public Msdyn_aifptrainingdocument withOverriddencreatedon(OffsetDateTime overriddencreatedon) {
        Msdyn_aifptrainingdocument _x = _copy();
        _x.changedFields = changedFields.add("overriddencreatedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aifptrainingdocument");
        _x.overriddencreatedon = overriddencreatedon;
        return _x;
    }

    @Property(name="msdyn_checksum")
    @JsonIgnore
    public Optional<String> getMsdyn_checksum() {
        return Optional.ofNullable(msdyn_checksum);
    }

    public Msdyn_aifptrainingdocument withMsdyn_checksum(String msdyn_checksum) {
        Checks.checkIsAscii(msdyn_checksum);
        Msdyn_aifptrainingdocument _x = _copy();
        _x.changedFields = changedFields.add("msdyn_checksum");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aifptrainingdocument");
        _x.msdyn_checksum = msdyn_checksum;
        return _x;
    }

    @Property(name="msdyn_sourcetype")
    @JsonIgnore
    public Optional<String> getMsdyn_sourcetype() {
        return Optional.ofNullable(msdyn_sourcetype);
    }

    public Msdyn_aifptrainingdocument withMsdyn_sourcetype(String msdyn_sourcetype) {
        Checks.checkIsAscii(msdyn_sourcetype);
        Msdyn_aifptrainingdocument _x = _copy();
        _x.changedFields = changedFields.add("msdyn_sourcetype");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aifptrainingdocument");
        _x.msdyn_sourcetype = msdyn_sourcetype;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<UUID> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Msdyn_aifptrainingdocument with_createdby_value(UUID _createdby_value) {
        Msdyn_aifptrainingdocument _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aifptrainingdocument");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="msdyn_metadata")
    @JsonIgnore
    public Optional<String> getMsdyn_metadata() {
        return Optional.ofNullable(msdyn_metadata);
    }

    public Msdyn_aifptrainingdocument withMsdyn_metadata(String msdyn_metadata) {
        Checks.checkIsAscii(msdyn_metadata);
        Msdyn_aifptrainingdocument _x = _copy();
        _x.changedFields = changedFields.add("msdyn_metadata");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aifptrainingdocument");
        _x.msdyn_metadata = msdyn_metadata;
        return _x;
    }

    @Property(name="_owninguser_value")
    @JsonIgnore
    public Optional<UUID> get_owninguser_value() {
        return Optional.ofNullable(_owninguser_value);
    }

    public Msdyn_aifptrainingdocument with_owninguser_value(UUID _owninguser_value) {
        Msdyn_aifptrainingdocument _x = _copy();
        _x.changedFields = changedFields.add("_owninguser_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aifptrainingdocument");
        _x._owninguser_value = _owninguser_value;
        return _x;
    }

    @Property(name="statuscode")
    @JsonIgnore
    public Optional<Integer> getStatuscode() {
        return Optional.ofNullable(statuscode);
    }

    public Msdyn_aifptrainingdocument withStatuscode(Integer statuscode) {
        Msdyn_aifptrainingdocument _x = _copy();
        _x.changedFields = changedFields.add("statuscode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aifptrainingdocument");
        _x.statuscode = statuscode;
        return _x;
    }

    @Property(name="_owningbusinessunit_value")
    @JsonIgnore
    public Optional<UUID> get_owningbusinessunit_value() {
        return Optional.ofNullable(_owningbusinessunit_value);
    }

    public Msdyn_aifptrainingdocument with_owningbusinessunit_value(UUID _owningbusinessunit_value) {
        Msdyn_aifptrainingdocument _x = _copy();
        _x.changedFields = changedFields.add("_owningbusinessunit_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aifptrainingdocument");
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Msdyn_aifptrainingdocument withModifiedon(OffsetDateTime modifiedon) {
        Msdyn_aifptrainingdocument _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aifptrainingdocument");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Msdyn_aifptrainingdocument withVersionnumber(Long versionnumber) {
        Msdyn_aifptrainingdocument _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aifptrainingdocument");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="statecode")
    @JsonIgnore
    public Optional<Integer> getStatecode() {
        return Optional.ofNullable(statecode);
    }

    public Msdyn_aifptrainingdocument withStatecode(Integer statecode) {
        Msdyn_aifptrainingdocument _x = _copy();
        _x.changedFields = changedFields.add("statecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aifptrainingdocument");
        _x.statecode = statecode;
        return _x;
    }

    public Msdyn_aifptrainingdocument withUnmappedField(String name, String value) {
        Msdyn_aifptrainingdocument _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="owninguser")
    @JsonIgnore
    public SystemuserRequest getOwninguser() {
        return new SystemuserRequest(contextPath.addSegment("owninguser"), RequestHelper.getValue(unmappedFields, "owninguser"));
    }

    @NavigationProperty(name="owningteam")
    @JsonIgnore
    public TeamRequest getOwningteam() {
        return new TeamRequest(contextPath.addSegment("owningteam"), RequestHelper.getValue(unmappedFields, "owningteam"));
    }

    @NavigationProperty(name="ownerid")
    @JsonIgnore
    public PrincipalRequest getOwnerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), RequestHelper.getValue(unmappedFields, "ownerid"));
    }

    @NavigationProperty(name="owningbusinessunit")
    @JsonIgnore
    public BusinessunitRequest getOwningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), RequestHelper.getValue(unmappedFields, "owningbusinessunit"));
    }

    @NavigationProperty(name="msdyn_aifptrainingdocument_SyncErrors")
    @JsonIgnore
    public SyncerrorCollectionRequest getMsdyn_aifptrainingdocument_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("msdyn_aifptrainingdocument_SyncErrors"), RequestHelper.getValue(unmappedFields, "msdyn_aifptrainingdocument_SyncErrors"));
    }

    @NavigationProperty(name="msdyn_aifptrainingdocument_AsyncOperations")
    @JsonIgnore
    public AsyncoperationCollectionRequest getMsdyn_aifptrainingdocument_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("msdyn_aifptrainingdocument_AsyncOperations"), RequestHelper.getValue(unmappedFields, "msdyn_aifptrainingdocument_AsyncOperations"));
    }

    @NavigationProperty(name="msdyn_aifptrainingdocument_MailboxTrackingFolders")
    @JsonIgnore
    public MailboxtrackingfolderCollectionRequest getMsdyn_aifptrainingdocument_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(
                        contextPath.addSegment("msdyn_aifptrainingdocument_MailboxTrackingFolders"), RequestHelper.getValue(unmappedFields, "msdyn_aifptrainingdocument_MailboxTrackingFolders"));
    }

    @NavigationProperty(name="msdyn_aifptrainingdocument_ProcessSession")
    @JsonIgnore
    public ProcesssessionCollectionRequest getMsdyn_aifptrainingdocument_ProcessSession() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("msdyn_aifptrainingdocument_ProcessSession"), RequestHelper.getValue(unmappedFields, "msdyn_aifptrainingdocument_ProcessSession"));
    }

    @NavigationProperty(name="msdyn_aifptrainingdocument_BulkDeleteFailures")
    @JsonIgnore
    public BulkdeletefailureCollectionRequest getMsdyn_aifptrainingdocument_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("msdyn_aifptrainingdocument_BulkDeleteFailures"), RequestHelper.getValue(unmappedFields, "msdyn_aifptrainingdocument_BulkDeleteFailures"));
    }

    @NavigationProperty(name="msdyn_aifptrainingdocument_PrincipalObjectAttributeAccesses")
    @JsonIgnore
    public PrincipalobjectattributeaccessCollectionRequest getMsdyn_aifptrainingdocument_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("msdyn_aifptrainingdocument_PrincipalObjectAttributeAccesses"), RequestHelper.getValue(unmappedFields, "msdyn_aifptrainingdocument_PrincipalObjectAttributeAccesses"));
    }

    @NavigationProperty(name="msdyn_aifptrainingdocument_Annotations")
    @JsonIgnore
    public AnnotationCollectionRequest getMsdyn_aifptrainingdocument_Annotations() {
        return new AnnotationCollectionRequest(
                        contextPath.addSegment("msdyn_aifptrainingdocument_Annotations"), RequestHelper.getValue(unmappedFields, "msdyn_aifptrainingdocument_Annotations"));
    }

    @NavigationProperty(name="msdyn_AIConfigurationId")
    @JsonIgnore
    public Msdyn_aiconfigurationRequest getMsdyn_AIConfigurationId() {
        return new Msdyn_aiconfigurationRequest(contextPath.addSegment("msdyn_AIConfigurationId"), RequestHelper.getValue(unmappedFields, "msdyn_AIConfigurationId"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Msdyn_aifptrainingdocument patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Msdyn_aifptrainingdocument _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Msdyn_aifptrainingdocument put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Msdyn_aifptrainingdocument _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Msdyn_aifptrainingdocument _copy() {
        Msdyn_aifptrainingdocument _x = new Msdyn_aifptrainingdocument();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        _x.msdyn_name = msdyn_name;
        _x.importsequencenumber = importsequencenumber;
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        _x._msdyn_aiconfigurationid_value = _msdyn_aiconfigurationid_value;
        _x.msdyn_aifptrainingdocumentid = msdyn_aifptrainingdocumentid;
        _x._owningteam_value = _owningteam_value;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x._ownerid_value = _ownerid_value;
        _x._modifiedby_value = _modifiedby_value;
        _x.createdon = createdon;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.overriddencreatedon = overriddencreatedon;
        _x.msdyn_checksum = msdyn_checksum;
        _x.msdyn_sourcetype = msdyn_sourcetype;
        _x._createdby_value = _createdby_value;
        _x.msdyn_metadata = msdyn_metadata;
        _x._owninguser_value = _owninguser_value;
        _x.statuscode = statuscode;
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        _x.modifiedon = modifiedon;
        _x.versionnumber = versionnumber;
        _x.statecode = statecode;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Msdyn_aifptrainingdocument[");
        b.append("timezoneruleversionnumber=");
        b.append(this.timezoneruleversionnumber);
        b.append(", ");
        b.append("msdyn_name=");
        b.append(this.msdyn_name);
        b.append(", ");
        b.append("importsequencenumber=");
        b.append(this.importsequencenumber);
        b.append(", ");
        b.append("utcconversiontimezonecode=");
        b.append(this.utcconversiontimezonecode);
        b.append(", ");
        b.append("_msdyn_aiconfigurationid_value=");
        b.append(this._msdyn_aiconfigurationid_value);
        b.append(", ");
        b.append("msdyn_aifptrainingdocumentid=");
        b.append(this.msdyn_aifptrainingdocumentid);
        b.append(", ");
        b.append("_owningteam_value=");
        b.append(this._owningteam_value);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("_ownerid_value=");
        b.append(this._ownerid_value);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("overriddencreatedon=");
        b.append(this.overriddencreatedon);
        b.append(", ");
        b.append("msdyn_checksum=");
        b.append(this.msdyn_checksum);
        b.append(", ");
        b.append("msdyn_sourcetype=");
        b.append(this.msdyn_sourcetype);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("msdyn_metadata=");
        b.append(this.msdyn_metadata);
        b.append(", ");
        b.append("_owninguser_value=");
        b.append(this._owninguser_value);
        b.append(", ");
        b.append("statuscode=");
        b.append(this.statuscode);
        b.append(", ");
        b.append("_owningbusinessunit_value=");
        b.append(this._owningbusinessunit_value);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("statecode=");
        b.append(this.statecode);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
