package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.UUID;

@JsonPropertyOrder({
    "@odata.type", 
    "logicalname", 
    "solutionid", 
    "overwritetime", 
    "entitykeyid", 
    "componentstate", 
    "name"})
@JsonInclude(Include.NON_NULL)
public class Entitykey extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.entitykey";
    }

    @JsonProperty("logicalname")
    protected String logicalname;

    @JsonProperty("solutionid")
    protected UUID solutionid;

    @JsonProperty("overwritetime")
    protected OffsetDateTime overwritetime;

    @JsonProperty("entitykeyid")
    protected UUID entitykeyid;

    @JsonProperty("componentstate")
    protected Integer componentstate;

    @JsonProperty("name")
    protected String name;

    protected Entitykey() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderEntitykey() {
        return new Builder();
    }

    public static final class Builder {
        private String logicalname;
        private UUID solutionid;
        private OffsetDateTime overwritetime;
        private UUID entitykeyid;
        private Integer componentstate;
        private String name;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder logicalname(String logicalname) {
            this.logicalname = logicalname;
            this.changedFields = changedFields.add("logicalname");
            return this;
        }

        public Builder solutionid(UUID solutionid) {
            this.solutionid = solutionid;
            this.changedFields = changedFields.add("solutionid");
            return this;
        }

        public Builder overwritetime(OffsetDateTime overwritetime) {
            this.overwritetime = overwritetime;
            this.changedFields = changedFields.add("overwritetime");
            return this;
        }

        public Builder entitykeyid(UUID entitykeyid) {
            this.entitykeyid = entitykeyid;
            this.changedFields = changedFields.add("entitykeyid");
            return this;
        }

        public Builder componentstate(Integer componentstate) {
            this.componentstate = componentstate;
            this.changedFields = changedFields.add("componentstate");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Entitykey build() {
            Entitykey _x = new Entitykey();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.entitykey";
            _x.logicalname = logicalname;
            _x.solutionid = solutionid;
            _x.overwritetime = overwritetime;
            _x.entitykeyid = entitykeyid;
            _x.componentstate = componentstate;
            _x.name = name;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && entitykeyid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(entitykeyid, UUID.class));
        }
    }

    @Property(name="logicalname")
    @JsonIgnore
    public Optional<String> getLogicalname() {
        return Optional.ofNullable(logicalname);
    }

    public Entitykey withLogicalname(String logicalname) {
        Checks.checkIsAscii(logicalname);
        Entitykey _x = _copy();
        _x.changedFields = changedFields.add("logicalname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.entitykey");
        _x.logicalname = logicalname;
        return _x;
    }

    @Property(name="solutionid")
    @JsonIgnore
    public Optional<UUID> getSolutionid() {
        return Optional.ofNullable(solutionid);
    }

    public Entitykey withSolutionid(UUID solutionid) {
        Entitykey _x = _copy();
        _x.changedFields = changedFields.add("solutionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.entitykey");
        _x.solutionid = solutionid;
        return _x;
    }

    @Property(name="overwritetime")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverwritetime() {
        return Optional.ofNullable(overwritetime);
    }

    public Entitykey withOverwritetime(OffsetDateTime overwritetime) {
        Entitykey _x = _copy();
        _x.changedFields = changedFields.add("overwritetime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.entitykey");
        _x.overwritetime = overwritetime;
        return _x;
    }

    @Property(name="entitykeyid")
    @JsonIgnore
    public Optional<UUID> getEntitykeyid() {
        return Optional.ofNullable(entitykeyid);
    }

    public Entitykey withEntitykeyid(UUID entitykeyid) {
        Entitykey _x = _copy();
        _x.changedFields = changedFields.add("entitykeyid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.entitykey");
        _x.entitykeyid = entitykeyid;
        return _x;
    }

    @Property(name="componentstate")
    @JsonIgnore
    public Optional<Integer> getComponentstate() {
        return Optional.ofNullable(componentstate);
    }

    public Entitykey withComponentstate(Integer componentstate) {
        Entitykey _x = _copy();
        _x.changedFields = changedFields.add("componentstate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.entitykey");
        _x.componentstate = componentstate;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public Entitykey withName(String name) {
        Checks.checkIsAscii(name);
        Entitykey _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.entitykey");
        _x.name = name;
        return _x;
    }

    public Entitykey withUnmappedField(String name, String value) {
        Entitykey _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Entitykey patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Entitykey _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Entitykey put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Entitykey _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Entitykey _copy() {
        Entitykey _x = new Entitykey();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.logicalname = logicalname;
        _x.solutionid = solutionid;
        _x.overwritetime = overwritetime;
        _x.entitykeyid = entitykeyid;
        _x.componentstate = componentstate;
        _x.name = name;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Entitykey[");
        b.append("logicalname=");
        b.append(this.logicalname);
        b.append(", ");
        b.append("solutionid=");
        b.append(this.solutionid);
        b.append(", ");
        b.append("overwritetime=");
        b.append(this.overwritetime);
        b.append(", ");
        b.append("entitykeyid=");
        b.append(this.entitykeyid);
        b.append(", ");
        b.append("componentstate=");
        b.append(this.componentstate);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
