package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MailboxtrackingfolderCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "componentstate", 
    "versionnumber", 
    "overwritetime", 
    "parententitylogicalname", 
    "solutionid", 
    "primaryimageattribute", 
    "componentidunique", 
    "ismanaged", 
    "entityimageconfigid"})
@JsonInclude(Include.NON_NULL)
public class Entityimageconfig extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.entityimageconfig";
    }

    @JsonProperty("componentstate")
    protected Integer componentstate;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("overwritetime")
    protected OffsetDateTime overwritetime;

    @JsonProperty("parententitylogicalname")
    protected String parententitylogicalname;

    @JsonProperty("solutionid")
    protected UUID solutionid;

    @JsonProperty("primaryimageattribute")
    protected String primaryimageattribute;

    @JsonProperty("componentidunique")
    protected UUID componentidunique;

    @JsonProperty("ismanaged")
    protected Boolean ismanaged;

    @JsonProperty("entityimageconfigid")
    protected UUID entityimageconfigid;

    protected Entityimageconfig() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderEntityimageconfig() {
        return new Builder();
    }

    public static final class Builder {
        private Integer componentstate;
        private Long versionnumber;
        private OffsetDateTime overwritetime;
        private String parententitylogicalname;
        private UUID solutionid;
        private String primaryimageattribute;
        private UUID componentidunique;
        private Boolean ismanaged;
        private UUID entityimageconfigid;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder componentstate(Integer componentstate) {
            this.componentstate = componentstate;
            this.changedFields = changedFields.add("componentstate");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder overwritetime(OffsetDateTime overwritetime) {
            this.overwritetime = overwritetime;
            this.changedFields = changedFields.add("overwritetime");
            return this;
        }

        public Builder parententitylogicalname(String parententitylogicalname) {
            this.parententitylogicalname = parententitylogicalname;
            this.changedFields = changedFields.add("parententitylogicalname");
            return this;
        }

        public Builder solutionid(UUID solutionid) {
            this.solutionid = solutionid;
            this.changedFields = changedFields.add("solutionid");
            return this;
        }

        public Builder primaryimageattribute(String primaryimageattribute) {
            this.primaryimageattribute = primaryimageattribute;
            this.changedFields = changedFields.add("primaryimageattribute");
            return this;
        }

        public Builder componentidunique(UUID componentidunique) {
            this.componentidunique = componentidunique;
            this.changedFields = changedFields.add("componentidunique");
            return this;
        }

        public Builder ismanaged(Boolean ismanaged) {
            this.ismanaged = ismanaged;
            this.changedFields = changedFields.add("ismanaged");
            return this;
        }

        public Builder entityimageconfigid(UUID entityimageconfigid) {
            this.entityimageconfigid = entityimageconfigid;
            this.changedFields = changedFields.add("entityimageconfigid");
            return this;
        }

        public Entityimageconfig build() {
            Entityimageconfig _x = new Entityimageconfig();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.entityimageconfig";
            _x.componentstate = componentstate;
            _x.versionnumber = versionnumber;
            _x.overwritetime = overwritetime;
            _x.parententitylogicalname = parententitylogicalname;
            _x.solutionid = solutionid;
            _x.primaryimageattribute = primaryimageattribute;
            _x.componentidunique = componentidunique;
            _x.ismanaged = ismanaged;
            _x.entityimageconfigid = entityimageconfigid;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && entityimageconfigid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(entityimageconfigid, UUID.class));
        }
    }

    @Property(name="componentstate")
    @JsonIgnore
    public Optional<Integer> getComponentstate() {
        return Optional.ofNullable(componentstate);
    }

    public Entityimageconfig withComponentstate(Integer componentstate) {
        Entityimageconfig _x = _copy();
        _x.changedFields = changedFields.add("componentstate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.entityimageconfig");
        _x.componentstate = componentstate;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Entityimageconfig withVersionnumber(Long versionnumber) {
        Entityimageconfig _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.entityimageconfig");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="overwritetime")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverwritetime() {
        return Optional.ofNullable(overwritetime);
    }

    public Entityimageconfig withOverwritetime(OffsetDateTime overwritetime) {
        Entityimageconfig _x = _copy();
        _x.changedFields = changedFields.add("overwritetime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.entityimageconfig");
        _x.overwritetime = overwritetime;
        return _x;
    }

    @Property(name="parententitylogicalname")
    @JsonIgnore
    public Optional<String> getParententitylogicalname() {
        return Optional.ofNullable(parententitylogicalname);
    }

    public Entityimageconfig withParententitylogicalname(String parententitylogicalname) {
        Checks.checkIsAscii(parententitylogicalname);
        Entityimageconfig _x = _copy();
        _x.changedFields = changedFields.add("parententitylogicalname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.entityimageconfig");
        _x.parententitylogicalname = parententitylogicalname;
        return _x;
    }

    @Property(name="solutionid")
    @JsonIgnore
    public Optional<UUID> getSolutionid() {
        return Optional.ofNullable(solutionid);
    }

    public Entityimageconfig withSolutionid(UUID solutionid) {
        Entityimageconfig _x = _copy();
        _x.changedFields = changedFields.add("solutionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.entityimageconfig");
        _x.solutionid = solutionid;
        return _x;
    }

    @Property(name="primaryimageattribute")
    @JsonIgnore
    public Optional<String> getPrimaryimageattribute() {
        return Optional.ofNullable(primaryimageattribute);
    }

    public Entityimageconfig withPrimaryimageattribute(String primaryimageattribute) {
        Checks.checkIsAscii(primaryimageattribute);
        Entityimageconfig _x = _copy();
        _x.changedFields = changedFields.add("primaryimageattribute");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.entityimageconfig");
        _x.primaryimageattribute = primaryimageattribute;
        return _x;
    }

    @Property(name="componentidunique")
    @JsonIgnore
    public Optional<UUID> getComponentidunique() {
        return Optional.ofNullable(componentidunique);
    }

    public Entityimageconfig withComponentidunique(UUID componentidunique) {
        Entityimageconfig _x = _copy();
        _x.changedFields = changedFields.add("componentidunique");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.entityimageconfig");
        _x.componentidunique = componentidunique;
        return _x;
    }

    @Property(name="ismanaged")
    @JsonIgnore
    public Optional<Boolean> getIsmanaged() {
        return Optional.ofNullable(ismanaged);
    }

    public Entityimageconfig withIsmanaged(Boolean ismanaged) {
        Entityimageconfig _x = _copy();
        _x.changedFields = changedFields.add("ismanaged");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.entityimageconfig");
        _x.ismanaged = ismanaged;
        return _x;
    }

    @Property(name="entityimageconfigid")
    @JsonIgnore
    public Optional<UUID> getEntityimageconfigid() {
        return Optional.ofNullable(entityimageconfigid);
    }

    public Entityimageconfig withEntityimageconfigid(UUID entityimageconfigid) {
        Entityimageconfig _x = _copy();
        _x.changedFields = changedFields.add("entityimageconfigid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.entityimageconfig");
        _x.entityimageconfigid = entityimageconfigid;
        return _x;
    }

    public Entityimageconfig withUnmappedField(String name, String value) {
        Entityimageconfig _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="entityimageconfig_SyncErrors")
    @JsonIgnore
    public SyncerrorCollectionRequest getEntityimageconfig_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("entityimageconfig_SyncErrors"), RequestHelper.getValue(unmappedFields, "entityimageconfig_SyncErrors"));
    }

    @NavigationProperty(name="entityimageconfig_AsyncOperations")
    @JsonIgnore
    public AsyncoperationCollectionRequest getEntityimageconfig_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("entityimageconfig_AsyncOperations"), RequestHelper.getValue(unmappedFields, "entityimageconfig_AsyncOperations"));
    }

    @NavigationProperty(name="entityimageconfig_MailboxTrackingFolders")
    @JsonIgnore
    public MailboxtrackingfolderCollectionRequest getEntityimageconfig_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(
                        contextPath.addSegment("entityimageconfig_MailboxTrackingFolders"), RequestHelper.getValue(unmappedFields, "entityimageconfig_MailboxTrackingFolders"));
    }

    @NavigationProperty(name="entityimageconfig_BulkDeleteFailures")
    @JsonIgnore
    public BulkdeletefailureCollectionRequest getEntityimageconfig_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("entityimageconfig_BulkDeleteFailures"), RequestHelper.getValue(unmappedFields, "entityimageconfig_BulkDeleteFailures"));
    }

    @NavigationProperty(name="entityimageconfig_PrincipalObjectAttributeAccesses")
    @JsonIgnore
    public PrincipalobjectattributeaccessCollectionRequest getEntityimageconfig_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("entityimageconfig_PrincipalObjectAttributeAccesses"), RequestHelper.getValue(unmappedFields, "entityimageconfig_PrincipalObjectAttributeAccesses"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Entityimageconfig patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Entityimageconfig _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Entityimageconfig put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Entityimageconfig _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Entityimageconfig _copy() {
        Entityimageconfig _x = new Entityimageconfig();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.componentstate = componentstate;
        _x.versionnumber = versionnumber;
        _x.overwritetime = overwritetime;
        _x.parententitylogicalname = parententitylogicalname;
        _x.solutionid = solutionid;
        _x.primaryimageattribute = primaryimageattribute;
        _x.componentidunique = componentidunique;
        _x.ismanaged = ismanaged;
        _x.entityimageconfigid = entityimageconfigid;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Entityimageconfig[");
        b.append("componentstate=");
        b.append(this.componentstate);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("overwritetime=");
        b.append(this.overwritetime);
        b.append(", ");
        b.append("parententitylogicalname=");
        b.append(this.parententitylogicalname);
        b.append(", ");
        b.append("solutionid=");
        b.append(this.solutionid);
        b.append(", ");
        b.append("primaryimageattribute=");
        b.append(this.primaryimageattribute);
        b.append(", ");
        b.append("componentidunique=");
        b.append(this.componentidunique);
        b.append(", ");
        b.append("ismanaged=");
        b.append(this.ismanaged);
        b.append(", ");
        b.append("entityimageconfigid=");
        b.append(this.entityimageconfigid);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
