package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.CascadegrantrevokeaccessrecordstrackerCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DuplicaterecordCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MailboxtrackingfolderCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "overriddencreatedon", 
    "_modifiedby_value", 
    "name", 
    "utcconversiontimezonecode", 
    "parentobjecttypecode", 
    "messagename", 
    "statecode", 
    "cascadegrantrevokeaccessversiontrackerid", 
    "createdon", 
    "_createdonbehalfby_value", 
    "parententityid", 
    "statuscode", 
    "modifiedon", 
    "importsequencenumber", 
    "timezoneruleversionnumber", 
    "_modifiedonbehalfby_value", 
    "_createdby_value"})
@JsonInclude(Include.NON_NULL)
public class Cascadegrantrevokeaccessversiontracker extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.cascadegrantrevokeaccessversiontracker";
    }

    @JsonProperty("overriddencreatedon")
    protected OffsetDateTime overriddencreatedon;

    @JsonProperty("_modifiedby_value")
    protected UUID _modifiedby_value;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("utcconversiontimezonecode")
    protected Integer utcconversiontimezonecode;

    @JsonProperty("parentobjecttypecode")
    protected Integer parentobjecttypecode;

    @JsonProperty("messagename")
    protected String messagename;

    @JsonProperty("statecode")
    protected Integer statecode;

    @JsonProperty("cascadegrantrevokeaccessversiontrackerid")
    protected UUID cascadegrantrevokeaccessversiontrackerid;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("_createdonbehalfby_value")
    protected UUID _createdonbehalfby_value;

    @JsonProperty("parententityid")
    protected String parententityid;

    @JsonProperty("statuscode")
    protected Integer statuscode;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("importsequencenumber")
    protected Integer importsequencenumber;

    @JsonProperty("timezoneruleversionnumber")
    protected Integer timezoneruleversionnumber;

    @JsonProperty("_modifiedonbehalfby_value")
    protected UUID _modifiedonbehalfby_value;

    @JsonProperty("_createdby_value")
    protected UUID _createdby_value;

    protected Cascadegrantrevokeaccessversiontracker() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderCascadegrantrevokeaccessversiontracker() {
        return new Builder();
    }

    public static final class Builder {
        private OffsetDateTime overriddencreatedon;
        private UUID _modifiedby_value;
        private String name;
        private Integer utcconversiontimezonecode;
        private Integer parentobjecttypecode;
        private String messagename;
        private Integer statecode;
        private UUID cascadegrantrevokeaccessversiontrackerid;
        private OffsetDateTime createdon;
        private UUID _createdonbehalfby_value;
        private String parententityid;
        private Integer statuscode;
        private OffsetDateTime modifiedon;
        private Integer importsequencenumber;
        private Integer timezoneruleversionnumber;
        private UUID _modifiedonbehalfby_value;
        private UUID _createdby_value;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder overriddencreatedon(OffsetDateTime overriddencreatedon) {
            this.overriddencreatedon = overriddencreatedon;
            this.changedFields = changedFields.add("overriddencreatedon");
            return this;
        }

        public Builder _modifiedby_value(UUID _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder utcconversiontimezonecode(Integer utcconversiontimezonecode) {
            this.utcconversiontimezonecode = utcconversiontimezonecode;
            this.changedFields = changedFields.add("utcconversiontimezonecode");
            return this;
        }

        public Builder parentobjecttypecode(Integer parentobjecttypecode) {
            this.parentobjecttypecode = parentobjecttypecode;
            this.changedFields = changedFields.add("parentobjecttypecode");
            return this;
        }

        public Builder messagename(String messagename) {
            this.messagename = messagename;
            this.changedFields = changedFields.add("messagename");
            return this;
        }

        public Builder statecode(Integer statecode) {
            this.statecode = statecode;
            this.changedFields = changedFields.add("statecode");
            return this;
        }

        public Builder cascadegrantrevokeaccessversiontrackerid(UUID cascadegrantrevokeaccessversiontrackerid) {
            this.cascadegrantrevokeaccessversiontrackerid = cascadegrantrevokeaccessversiontrackerid;
            this.changedFields = changedFields.add("cascadegrantrevokeaccessversiontrackerid");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder _createdonbehalfby_value(UUID _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder parententityid(String parententityid) {
            this.parententityid = parententityid;
            this.changedFields = changedFields.add("parententityid");
            return this;
        }

        public Builder statuscode(Integer statuscode) {
            this.statuscode = statuscode;
            this.changedFields = changedFields.add("statuscode");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder importsequencenumber(Integer importsequencenumber) {
            this.importsequencenumber = importsequencenumber;
            this.changedFields = changedFields.add("importsequencenumber");
            return this;
        }

        public Builder timezoneruleversionnumber(Integer timezoneruleversionnumber) {
            this.timezoneruleversionnumber = timezoneruleversionnumber;
            this.changedFields = changedFields.add("timezoneruleversionnumber");
            return this;
        }

        public Builder _modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder _createdby_value(UUID _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Cascadegrantrevokeaccessversiontracker build() {
            Cascadegrantrevokeaccessversiontracker _x = new Cascadegrantrevokeaccessversiontracker();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.cascadegrantrevokeaccessversiontracker";
            _x.overriddencreatedon = overriddencreatedon;
            _x._modifiedby_value = _modifiedby_value;
            _x.name = name;
            _x.utcconversiontimezonecode = utcconversiontimezonecode;
            _x.parentobjecttypecode = parentobjecttypecode;
            _x.messagename = messagename;
            _x.statecode = statecode;
            _x.cascadegrantrevokeaccessversiontrackerid = cascadegrantrevokeaccessversiontrackerid;
            _x.createdon = createdon;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.parententityid = parententityid;
            _x.statuscode = statuscode;
            _x.modifiedon = modifiedon;
            _x.importsequencenumber = importsequencenumber;
            _x.timezoneruleversionnumber = timezoneruleversionnumber;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x._createdby_value = _createdby_value;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && cascadegrantrevokeaccessversiontrackerid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(cascadegrantrevokeaccessversiontrackerid, UUID.class));
        }
    }

    @Property(name="overriddencreatedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverriddencreatedon() {
        return Optional.ofNullable(overriddencreatedon);
    }

    public Cascadegrantrevokeaccessversiontracker withOverriddencreatedon(OffsetDateTime overriddencreatedon) {
        Cascadegrantrevokeaccessversiontracker _x = _copy();
        _x.changedFields = changedFields.add("overriddencreatedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.cascadegrantrevokeaccessversiontracker");
        _x.overriddencreatedon = overriddencreatedon;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Cascadegrantrevokeaccessversiontracker with_modifiedby_value(UUID _modifiedby_value) {
        Cascadegrantrevokeaccessversiontracker _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.cascadegrantrevokeaccessversiontracker");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public Cascadegrantrevokeaccessversiontracker withName(String name) {
        Checks.checkIsAscii(name);
        Cascadegrantrevokeaccessversiontracker _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.cascadegrantrevokeaccessversiontracker");
        _x.name = name;
        return _x;
    }

    @Property(name="utcconversiontimezonecode")
    @JsonIgnore
    public Optional<Integer> getUtcconversiontimezonecode() {
        return Optional.ofNullable(utcconversiontimezonecode);
    }

    public Cascadegrantrevokeaccessversiontracker withUtcconversiontimezonecode(Integer utcconversiontimezonecode) {
        Cascadegrantrevokeaccessversiontracker _x = _copy();
        _x.changedFields = changedFields.add("utcconversiontimezonecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.cascadegrantrevokeaccessversiontracker");
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        return _x;
    }

    @Property(name="parentobjecttypecode")
    @JsonIgnore
    public Optional<Integer> getParentobjecttypecode() {
        return Optional.ofNullable(parentobjecttypecode);
    }

    public Cascadegrantrevokeaccessversiontracker withParentobjecttypecode(Integer parentobjecttypecode) {
        Cascadegrantrevokeaccessversiontracker _x = _copy();
        _x.changedFields = changedFields.add("parentobjecttypecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.cascadegrantrevokeaccessversiontracker");
        _x.parentobjecttypecode = parentobjecttypecode;
        return _x;
    }

    @Property(name="messagename")
    @JsonIgnore
    public Optional<String> getMessagename() {
        return Optional.ofNullable(messagename);
    }

    public Cascadegrantrevokeaccessversiontracker withMessagename(String messagename) {
        Checks.checkIsAscii(messagename);
        Cascadegrantrevokeaccessversiontracker _x = _copy();
        _x.changedFields = changedFields.add("messagename");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.cascadegrantrevokeaccessversiontracker");
        _x.messagename = messagename;
        return _x;
    }

    @Property(name="statecode")
    @JsonIgnore
    public Optional<Integer> getStatecode() {
        return Optional.ofNullable(statecode);
    }

    public Cascadegrantrevokeaccessversiontracker withStatecode(Integer statecode) {
        Cascadegrantrevokeaccessversiontracker _x = _copy();
        _x.changedFields = changedFields.add("statecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.cascadegrantrevokeaccessversiontracker");
        _x.statecode = statecode;
        return _x;
    }

    @Property(name="cascadegrantrevokeaccessversiontrackerid")
    @JsonIgnore
    public Optional<UUID> getCascadegrantrevokeaccessversiontrackerid() {
        return Optional.ofNullable(cascadegrantrevokeaccessversiontrackerid);
    }

    public Cascadegrantrevokeaccessversiontracker withCascadegrantrevokeaccessversiontrackerid(UUID cascadegrantrevokeaccessversiontrackerid) {
        Cascadegrantrevokeaccessversiontracker _x = _copy();
        _x.changedFields = changedFields.add("cascadegrantrevokeaccessversiontrackerid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.cascadegrantrevokeaccessversiontracker");
        _x.cascadegrantrevokeaccessversiontrackerid = cascadegrantrevokeaccessversiontrackerid;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Cascadegrantrevokeaccessversiontracker withCreatedon(OffsetDateTime createdon) {
        Cascadegrantrevokeaccessversiontracker _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.cascadegrantrevokeaccessversiontracker");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Cascadegrantrevokeaccessversiontracker with_createdonbehalfby_value(UUID _createdonbehalfby_value) {
        Cascadegrantrevokeaccessversiontracker _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.cascadegrantrevokeaccessversiontracker");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="parententityid")
    @JsonIgnore
    public Optional<String> getParententityid() {
        return Optional.ofNullable(parententityid);
    }

    public Cascadegrantrevokeaccessversiontracker withParententityid(String parententityid) {
        Checks.checkIsAscii(parententityid);
        Cascadegrantrevokeaccessversiontracker _x = _copy();
        _x.changedFields = changedFields.add("parententityid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.cascadegrantrevokeaccessversiontracker");
        _x.parententityid = parententityid;
        return _x;
    }

    @Property(name="statuscode")
    @JsonIgnore
    public Optional<Integer> getStatuscode() {
        return Optional.ofNullable(statuscode);
    }

    public Cascadegrantrevokeaccessversiontracker withStatuscode(Integer statuscode) {
        Cascadegrantrevokeaccessversiontracker _x = _copy();
        _x.changedFields = changedFields.add("statuscode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.cascadegrantrevokeaccessversiontracker");
        _x.statuscode = statuscode;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Cascadegrantrevokeaccessversiontracker withModifiedon(OffsetDateTime modifiedon) {
        Cascadegrantrevokeaccessversiontracker _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.cascadegrantrevokeaccessversiontracker");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="importsequencenumber")
    @JsonIgnore
    public Optional<Integer> getImportsequencenumber() {
        return Optional.ofNullable(importsequencenumber);
    }

    public Cascadegrantrevokeaccessversiontracker withImportsequencenumber(Integer importsequencenumber) {
        Cascadegrantrevokeaccessversiontracker _x = _copy();
        _x.changedFields = changedFields.add("importsequencenumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.cascadegrantrevokeaccessversiontracker");
        _x.importsequencenumber = importsequencenumber;
        return _x;
    }

    @Property(name="timezoneruleversionnumber")
    @JsonIgnore
    public Optional<Integer> getTimezoneruleversionnumber() {
        return Optional.ofNullable(timezoneruleversionnumber);
    }

    public Cascadegrantrevokeaccessversiontracker withTimezoneruleversionnumber(Integer timezoneruleversionnumber) {
        Cascadegrantrevokeaccessversiontracker _x = _copy();
        _x.changedFields = changedFields.add("timezoneruleversionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.cascadegrantrevokeaccessversiontracker");
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Cascadegrantrevokeaccessversiontracker with_modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
        Cascadegrantrevokeaccessversiontracker _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.cascadegrantrevokeaccessversiontracker");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<UUID> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Cascadegrantrevokeaccessversiontracker with_createdby_value(UUID _createdby_value) {
        Cascadegrantrevokeaccessversiontracker _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.cascadegrantrevokeaccessversiontracker");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    public Cascadegrantrevokeaccessversiontracker withUnmappedField(String name, String value) {
        Cascadegrantrevokeaccessversiontracker _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="cascadegrantrevokeaccessversiontracker_SyncErrors")
    @JsonIgnore
    public SyncerrorCollectionRequest getCascadegrantrevokeaccessversiontracker_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("cascadegrantrevokeaccessversiontracker_SyncErrors"), RequestHelper.getValue(unmappedFields, "cascadegrantrevokeaccessversiontracker_SyncErrors"));
    }

    @NavigationProperty(name="cascadegrantrevokeaccessversiontracker_DuplicateMatchingRecord")
    @JsonIgnore
    public DuplicaterecordCollectionRequest getCascadegrantrevokeaccessversiontracker_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("cascadegrantrevokeaccessversiontracker_DuplicateMatchingRecord"), RequestHelper.getValue(unmappedFields, "cascadegrantrevokeaccessversiontracker_DuplicateMatchingRecord"));
    }

    @NavigationProperty(name="cascadegrantrevokeaccessversiontracker_DuplicateBaseRecord")
    @JsonIgnore
    public DuplicaterecordCollectionRequest getCascadegrantrevokeaccessversiontracker_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("cascadegrantrevokeaccessversiontracker_DuplicateBaseRecord"), RequestHelper.getValue(unmappedFields, "cascadegrantrevokeaccessversiontracker_DuplicateBaseRecord"));
    }

    @NavigationProperty(name="cascadegrantrevokeaccessversiontracker_AsyncOperations")
    @JsonIgnore
    public AsyncoperationCollectionRequest getCascadegrantrevokeaccessversiontracker_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("cascadegrantrevokeaccessversiontracker_AsyncOperations"), RequestHelper.getValue(unmappedFields, "cascadegrantrevokeaccessversiontracker_AsyncOperations"));
    }

    @NavigationProperty(name="cascadegrantrevokeaccessversiontracker_MailboxTrackingFolders")
    @JsonIgnore
    public MailboxtrackingfolderCollectionRequest getCascadegrantrevokeaccessversiontracker_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(
                        contextPath.addSegment("cascadegrantrevokeaccessversiontracker_MailboxTrackingFolders"), RequestHelper.getValue(unmappedFields, "cascadegrantrevokeaccessversiontracker_MailboxTrackingFolders"));
    }

    @NavigationProperty(name="cascadegrantrevokeaccessversiontracker_ProcessSession")
    @JsonIgnore
    public ProcesssessionCollectionRequest getCascadegrantrevokeaccessversiontracker_ProcessSession() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("cascadegrantrevokeaccessversiontracker_ProcessSession"), RequestHelper.getValue(unmappedFields, "cascadegrantrevokeaccessversiontracker_ProcessSession"));
    }

    @NavigationProperty(name="cascadegrantrevokeaccessversiontracker_BulkDeleteFailures")
    @JsonIgnore
    public BulkdeletefailureCollectionRequest getCascadegrantrevokeaccessversiontracker_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("cascadegrantrevokeaccessversiontracker_BulkDeleteFailures"), RequestHelper.getValue(unmappedFields, "cascadegrantrevokeaccessversiontracker_BulkDeleteFailures"));
    }

    @NavigationProperty(name="cascadegrantrevokeaccessversiontracker_PrincipalObjectAttributeAccesses")
    @JsonIgnore
    public PrincipalobjectattributeaccessCollectionRequest getCascadegrantrevokeaccessversiontracker_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("cascadegrantrevokeaccessversiontracker_PrincipalObjectAttributeAccesses"), RequestHelper.getValue(unmappedFields, "cascadegrantrevokeaccessversiontracker_PrincipalObjectAttributeAccesses"));
    }

    @NavigationProperty(name="SyncTrackerIdLookup")
    @JsonIgnore
    public CascadegrantrevokeaccessrecordstrackerCollectionRequest getSyncTrackerIdLookup() {
        return new CascadegrantrevokeaccessrecordstrackerCollectionRequest(
                        contextPath.addSegment("SyncTrackerIdLookup"), RequestHelper.getValue(unmappedFields, "SyncTrackerIdLookup"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Cascadegrantrevokeaccessversiontracker patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Cascadegrantrevokeaccessversiontracker _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Cascadegrantrevokeaccessversiontracker put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Cascadegrantrevokeaccessversiontracker _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Cascadegrantrevokeaccessversiontracker _copy() {
        Cascadegrantrevokeaccessversiontracker _x = new Cascadegrantrevokeaccessversiontracker();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.overriddencreatedon = overriddencreatedon;
        _x._modifiedby_value = _modifiedby_value;
        _x.name = name;
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        _x.parentobjecttypecode = parentobjecttypecode;
        _x.messagename = messagename;
        _x.statecode = statecode;
        _x.cascadegrantrevokeaccessversiontrackerid = cascadegrantrevokeaccessversiontrackerid;
        _x.createdon = createdon;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.parententityid = parententityid;
        _x.statuscode = statuscode;
        _x.modifiedon = modifiedon;
        _x.importsequencenumber = importsequencenumber;
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Cascadegrantrevokeaccessversiontracker[");
        b.append("overriddencreatedon=");
        b.append(this.overriddencreatedon);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("utcconversiontimezonecode=");
        b.append(this.utcconversiontimezonecode);
        b.append(", ");
        b.append("parentobjecttypecode=");
        b.append(this.parentobjecttypecode);
        b.append(", ");
        b.append("messagename=");
        b.append(this.messagename);
        b.append(", ");
        b.append("statecode=");
        b.append(this.statecode);
        b.append(", ");
        b.append("cascadegrantrevokeaccessversiontrackerid=");
        b.append(this.cascadegrantrevokeaccessversiontrackerid);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("parententityid=");
        b.append(this.parententityid);
        b.append(", ");
        b.append("statuscode=");
        b.append(this.statuscode);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("importsequencenumber=");
        b.append(this.importsequencenumber);
        b.append(", ");
        b.append("timezoneruleversionnumber=");
        b.append(this.timezoneruleversionnumber);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
