package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DuplicaterecordCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.FileattachmentCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MailboxtrackingfolderCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.request.CascadegrantrevokeaccessversiontrackerRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "modifiedon", 
    "_modifiedonbehalfby_value", 
    "recordsattachment_name", 
    "createdon", 
    "overriddencreatedon", 
    "totalrecords", 
    "recordsjson", 
    "timezoneruleversionnumber", 
    "importsequencenumber", 
    "name", 
    "processedrecords", 
    "statuscode", 
    "_synctrackerid_value", 
    "_createdby_value", 
    "utcconversiontimezonecode", 
    "cascadegrantrevokeaccessrecordstrackerid", 
    "_modifiedby_value", 
    "recordsattachment", 
    "statecode", 
    "_createdonbehalfby_value"})
@JsonInclude(Include.NON_NULL)
public class Cascadegrantrevokeaccessrecordstracker extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.cascadegrantrevokeaccessrecordstracker";
    }

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("_modifiedonbehalfby_value")
    protected UUID _modifiedonbehalfby_value;

    @JsonProperty("recordsattachment_name")
    protected String recordsattachment_name;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("overriddencreatedon")
    protected OffsetDateTime overriddencreatedon;

    @JsonProperty("totalrecords")
    protected Integer totalrecords;

    @JsonProperty("recordsjson")
    protected String recordsjson;

    @JsonProperty("timezoneruleversionnumber")
    protected Integer timezoneruleversionnumber;

    @JsonProperty("importsequencenumber")
    protected Integer importsequencenumber;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("processedrecords")
    protected Integer processedrecords;

    @JsonProperty("statuscode")
    protected Integer statuscode;

    @JsonProperty("_synctrackerid_value")
    protected UUID _synctrackerid_value;

    @JsonProperty("_createdby_value")
    protected UUID _createdby_value;

    @JsonProperty("utcconversiontimezonecode")
    protected Integer utcconversiontimezonecode;

    @JsonProperty("cascadegrantrevokeaccessrecordstrackerid")
    protected UUID cascadegrantrevokeaccessrecordstrackerid;

    @JsonProperty("_modifiedby_value")
    protected UUID _modifiedby_value;

    @JsonProperty("recordsattachment")
    protected byte[] recordsattachment;

    @JsonProperty("statecode")
    protected Integer statecode;

    @JsonProperty("_createdonbehalfby_value")
    protected UUID _createdonbehalfby_value;

    protected Cascadegrantrevokeaccessrecordstracker() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderCascadegrantrevokeaccessrecordstracker() {
        return new Builder();
    }

    public static final class Builder {
        private OffsetDateTime modifiedon;
        private UUID _modifiedonbehalfby_value;
        private String recordsattachment_name;
        private OffsetDateTime createdon;
        private OffsetDateTime overriddencreatedon;
        private Integer totalrecords;
        private String recordsjson;
        private Integer timezoneruleversionnumber;
        private Integer importsequencenumber;
        private String name;
        private Integer processedrecords;
        private Integer statuscode;
        private UUID _synctrackerid_value;
        private UUID _createdby_value;
        private Integer utcconversiontimezonecode;
        private UUID cascadegrantrevokeaccessrecordstrackerid;
        private UUID _modifiedby_value;
        private byte[] recordsattachment;
        private Integer statecode;
        private UUID _createdonbehalfby_value;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder _modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder recordsattachment_name(String recordsattachment_name) {
            this.recordsattachment_name = recordsattachment_name;
            this.changedFields = changedFields.add("recordsattachment_name");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder overriddencreatedon(OffsetDateTime overriddencreatedon) {
            this.overriddencreatedon = overriddencreatedon;
            this.changedFields = changedFields.add("overriddencreatedon");
            return this;
        }

        public Builder totalrecords(Integer totalrecords) {
            this.totalrecords = totalrecords;
            this.changedFields = changedFields.add("totalrecords");
            return this;
        }

        public Builder recordsjson(String recordsjson) {
            this.recordsjson = recordsjson;
            this.changedFields = changedFields.add("recordsjson");
            return this;
        }

        public Builder timezoneruleversionnumber(Integer timezoneruleversionnumber) {
            this.timezoneruleversionnumber = timezoneruleversionnumber;
            this.changedFields = changedFields.add("timezoneruleversionnumber");
            return this;
        }

        public Builder importsequencenumber(Integer importsequencenumber) {
            this.importsequencenumber = importsequencenumber;
            this.changedFields = changedFields.add("importsequencenumber");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder processedrecords(Integer processedrecords) {
            this.processedrecords = processedrecords;
            this.changedFields = changedFields.add("processedrecords");
            return this;
        }

        public Builder statuscode(Integer statuscode) {
            this.statuscode = statuscode;
            this.changedFields = changedFields.add("statuscode");
            return this;
        }

        public Builder _synctrackerid_value(UUID _synctrackerid_value) {
            this._synctrackerid_value = _synctrackerid_value;
            this.changedFields = changedFields.add("_synctrackerid_value");
            return this;
        }

        public Builder _createdby_value(UUID _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder utcconversiontimezonecode(Integer utcconversiontimezonecode) {
            this.utcconversiontimezonecode = utcconversiontimezonecode;
            this.changedFields = changedFields.add("utcconversiontimezonecode");
            return this;
        }

        public Builder cascadegrantrevokeaccessrecordstrackerid(UUID cascadegrantrevokeaccessrecordstrackerid) {
            this.cascadegrantrevokeaccessrecordstrackerid = cascadegrantrevokeaccessrecordstrackerid;
            this.changedFields = changedFields.add("cascadegrantrevokeaccessrecordstrackerid");
            return this;
        }

        public Builder _modifiedby_value(UUID _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder recordsattachment(byte[] recordsattachment) {
            this.recordsattachment = recordsattachment;
            this.changedFields = changedFields.add("recordsattachment");
            return this;
        }

        public Builder statecode(Integer statecode) {
            this.statecode = statecode;
            this.changedFields = changedFields.add("statecode");
            return this;
        }

        public Builder _createdonbehalfby_value(UUID _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Cascadegrantrevokeaccessrecordstracker build() {
            Cascadegrantrevokeaccessrecordstracker _x = new Cascadegrantrevokeaccessrecordstracker();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.cascadegrantrevokeaccessrecordstracker";
            _x.modifiedon = modifiedon;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.recordsattachment_name = recordsattachment_name;
            _x.createdon = createdon;
            _x.overriddencreatedon = overriddencreatedon;
            _x.totalrecords = totalrecords;
            _x.recordsjson = recordsjson;
            _x.timezoneruleversionnumber = timezoneruleversionnumber;
            _x.importsequencenumber = importsequencenumber;
            _x.name = name;
            _x.processedrecords = processedrecords;
            _x.statuscode = statuscode;
            _x._synctrackerid_value = _synctrackerid_value;
            _x._createdby_value = _createdby_value;
            _x.utcconversiontimezonecode = utcconversiontimezonecode;
            _x.cascadegrantrevokeaccessrecordstrackerid = cascadegrantrevokeaccessrecordstrackerid;
            _x._modifiedby_value = _modifiedby_value;
            _x.recordsattachment = recordsattachment;
            _x.statecode = statecode;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && cascadegrantrevokeaccessrecordstrackerid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(cascadegrantrevokeaccessrecordstrackerid, UUID.class));
        }
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Cascadegrantrevokeaccessrecordstracker withModifiedon(OffsetDateTime modifiedon) {
        Cascadegrantrevokeaccessrecordstracker _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.cascadegrantrevokeaccessrecordstracker");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Cascadegrantrevokeaccessrecordstracker with_modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
        Cascadegrantrevokeaccessrecordstracker _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.cascadegrantrevokeaccessrecordstracker");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="recordsattachment_name")
    @JsonIgnore
    public Optional<String> getRecordsattachment_name() {
        return Optional.ofNullable(recordsattachment_name);
    }

    public Cascadegrantrevokeaccessrecordstracker withRecordsattachment_name(String recordsattachment_name) {
        Checks.checkIsAscii(recordsattachment_name);
        Cascadegrantrevokeaccessrecordstracker _x = _copy();
        _x.changedFields = changedFields.add("recordsattachment_name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.cascadegrantrevokeaccessrecordstracker");
        _x.recordsattachment_name = recordsattachment_name;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Cascadegrantrevokeaccessrecordstracker withCreatedon(OffsetDateTime createdon) {
        Cascadegrantrevokeaccessrecordstracker _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.cascadegrantrevokeaccessrecordstracker");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="overriddencreatedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverriddencreatedon() {
        return Optional.ofNullable(overriddencreatedon);
    }

    public Cascadegrantrevokeaccessrecordstracker withOverriddencreatedon(OffsetDateTime overriddencreatedon) {
        Cascadegrantrevokeaccessrecordstracker _x = _copy();
        _x.changedFields = changedFields.add("overriddencreatedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.cascadegrantrevokeaccessrecordstracker");
        _x.overriddencreatedon = overriddencreatedon;
        return _x;
    }

    @Property(name="totalrecords")
    @JsonIgnore
    public Optional<Integer> getTotalrecords() {
        return Optional.ofNullable(totalrecords);
    }

    public Cascadegrantrevokeaccessrecordstracker withTotalrecords(Integer totalrecords) {
        Cascadegrantrevokeaccessrecordstracker _x = _copy();
        _x.changedFields = changedFields.add("totalrecords");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.cascadegrantrevokeaccessrecordstracker");
        _x.totalrecords = totalrecords;
        return _x;
    }

    @Property(name="recordsjson")
    @JsonIgnore
    public Optional<String> getRecordsjson() {
        return Optional.ofNullable(recordsjson);
    }

    public Cascadegrantrevokeaccessrecordstracker withRecordsjson(String recordsjson) {
        Checks.checkIsAscii(recordsjson);
        Cascadegrantrevokeaccessrecordstracker _x = _copy();
        _x.changedFields = changedFields.add("recordsjson");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.cascadegrantrevokeaccessrecordstracker");
        _x.recordsjson = recordsjson;
        return _x;
    }

    @Property(name="timezoneruleversionnumber")
    @JsonIgnore
    public Optional<Integer> getTimezoneruleversionnumber() {
        return Optional.ofNullable(timezoneruleversionnumber);
    }

    public Cascadegrantrevokeaccessrecordstracker withTimezoneruleversionnumber(Integer timezoneruleversionnumber) {
        Cascadegrantrevokeaccessrecordstracker _x = _copy();
        _x.changedFields = changedFields.add("timezoneruleversionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.cascadegrantrevokeaccessrecordstracker");
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        return _x;
    }

    @Property(name="importsequencenumber")
    @JsonIgnore
    public Optional<Integer> getImportsequencenumber() {
        return Optional.ofNullable(importsequencenumber);
    }

    public Cascadegrantrevokeaccessrecordstracker withImportsequencenumber(Integer importsequencenumber) {
        Cascadegrantrevokeaccessrecordstracker _x = _copy();
        _x.changedFields = changedFields.add("importsequencenumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.cascadegrantrevokeaccessrecordstracker");
        _x.importsequencenumber = importsequencenumber;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public Cascadegrantrevokeaccessrecordstracker withName(String name) {
        Checks.checkIsAscii(name);
        Cascadegrantrevokeaccessrecordstracker _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.cascadegrantrevokeaccessrecordstracker");
        _x.name = name;
        return _x;
    }

    @Property(name="processedrecords")
    @JsonIgnore
    public Optional<Integer> getProcessedrecords() {
        return Optional.ofNullable(processedrecords);
    }

    public Cascadegrantrevokeaccessrecordstracker withProcessedrecords(Integer processedrecords) {
        Cascadegrantrevokeaccessrecordstracker _x = _copy();
        _x.changedFields = changedFields.add("processedrecords");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.cascadegrantrevokeaccessrecordstracker");
        _x.processedrecords = processedrecords;
        return _x;
    }

    @Property(name="statuscode")
    @JsonIgnore
    public Optional<Integer> getStatuscode() {
        return Optional.ofNullable(statuscode);
    }

    public Cascadegrantrevokeaccessrecordstracker withStatuscode(Integer statuscode) {
        Cascadegrantrevokeaccessrecordstracker _x = _copy();
        _x.changedFields = changedFields.add("statuscode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.cascadegrantrevokeaccessrecordstracker");
        _x.statuscode = statuscode;
        return _x;
    }

    @Property(name="_synctrackerid_value")
    @JsonIgnore
    public Optional<UUID> get_synctrackerid_value() {
        return Optional.ofNullable(_synctrackerid_value);
    }

    public Cascadegrantrevokeaccessrecordstracker with_synctrackerid_value(UUID _synctrackerid_value) {
        Cascadegrantrevokeaccessrecordstracker _x = _copy();
        _x.changedFields = changedFields.add("_synctrackerid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.cascadegrantrevokeaccessrecordstracker");
        _x._synctrackerid_value = _synctrackerid_value;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<UUID> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Cascadegrantrevokeaccessrecordstracker with_createdby_value(UUID _createdby_value) {
        Cascadegrantrevokeaccessrecordstracker _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.cascadegrantrevokeaccessrecordstracker");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="utcconversiontimezonecode")
    @JsonIgnore
    public Optional<Integer> getUtcconversiontimezonecode() {
        return Optional.ofNullable(utcconversiontimezonecode);
    }

    public Cascadegrantrevokeaccessrecordstracker withUtcconversiontimezonecode(Integer utcconversiontimezonecode) {
        Cascadegrantrevokeaccessrecordstracker _x = _copy();
        _x.changedFields = changedFields.add("utcconversiontimezonecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.cascadegrantrevokeaccessrecordstracker");
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        return _x;
    }

    @Property(name="cascadegrantrevokeaccessrecordstrackerid")
    @JsonIgnore
    public Optional<UUID> getCascadegrantrevokeaccessrecordstrackerid() {
        return Optional.ofNullable(cascadegrantrevokeaccessrecordstrackerid);
    }

    public Cascadegrantrevokeaccessrecordstracker withCascadegrantrevokeaccessrecordstrackerid(UUID cascadegrantrevokeaccessrecordstrackerid) {
        Cascadegrantrevokeaccessrecordstracker _x = _copy();
        _x.changedFields = changedFields.add("cascadegrantrevokeaccessrecordstrackerid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.cascadegrantrevokeaccessrecordstracker");
        _x.cascadegrantrevokeaccessrecordstrackerid = cascadegrantrevokeaccessrecordstrackerid;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Cascadegrantrevokeaccessrecordstracker with_modifiedby_value(UUID _modifiedby_value) {
        Cascadegrantrevokeaccessrecordstracker _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.cascadegrantrevokeaccessrecordstracker");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="recordsattachment")
    @JsonIgnore
    public Optional<byte[]> getRecordsattachment() {
        return Optional.ofNullable(recordsattachment);
    }

    public Cascadegrantrevokeaccessrecordstracker withRecordsattachment(byte[] recordsattachment) {
        Cascadegrantrevokeaccessrecordstracker _x = _copy();
        _x.changedFields = changedFields.add("recordsattachment");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.cascadegrantrevokeaccessrecordstracker");
        _x.recordsattachment = recordsattachment;
        return _x;
    }

    @Property(name="statecode")
    @JsonIgnore
    public Optional<Integer> getStatecode() {
        return Optional.ofNullable(statecode);
    }

    public Cascadegrantrevokeaccessrecordstracker withStatecode(Integer statecode) {
        Cascadegrantrevokeaccessrecordstracker _x = _copy();
        _x.changedFields = changedFields.add("statecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.cascadegrantrevokeaccessrecordstracker");
        _x.statecode = statecode;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Cascadegrantrevokeaccessrecordstracker with_createdonbehalfby_value(UUID _createdonbehalfby_value) {
        Cascadegrantrevokeaccessrecordstracker _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.cascadegrantrevokeaccessrecordstracker");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    public Cascadegrantrevokeaccessrecordstracker withUnmappedField(String name, String value) {
        Cascadegrantrevokeaccessrecordstracker _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="cascadegrantrevokeaccessrecordstracker_SyncErrors")
    @JsonIgnore
    public SyncerrorCollectionRequest getCascadegrantrevokeaccessrecordstracker_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("cascadegrantrevokeaccessrecordstracker_SyncErrors"), RequestHelper.getValue(unmappedFields, "cascadegrantrevokeaccessrecordstracker_SyncErrors"));
    }

    @NavigationProperty(name="cascadegrantrevokeaccessrecordstracker_DuplicateMatchingRecord")
    @JsonIgnore
    public DuplicaterecordCollectionRequest getCascadegrantrevokeaccessrecordstracker_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("cascadegrantrevokeaccessrecordstracker_DuplicateMatchingRecord"), RequestHelper.getValue(unmappedFields, "cascadegrantrevokeaccessrecordstracker_DuplicateMatchingRecord"));
    }

    @NavigationProperty(name="cascadegrantrevokeaccessrecordstracker_DuplicateBaseRecord")
    @JsonIgnore
    public DuplicaterecordCollectionRequest getCascadegrantrevokeaccessrecordstracker_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("cascadegrantrevokeaccessrecordstracker_DuplicateBaseRecord"), RequestHelper.getValue(unmappedFields, "cascadegrantrevokeaccessrecordstracker_DuplicateBaseRecord"));
    }

    @NavigationProperty(name="cascadegrantrevokeaccessrecordstracker_AsyncOperations")
    @JsonIgnore
    public AsyncoperationCollectionRequest getCascadegrantrevokeaccessrecordstracker_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("cascadegrantrevokeaccessrecordstracker_AsyncOperations"), RequestHelper.getValue(unmappedFields, "cascadegrantrevokeaccessrecordstracker_AsyncOperations"));
    }

    @NavigationProperty(name="cascadegrantrevokeaccessrecordstracker_MailboxTrackingFolders")
    @JsonIgnore
    public MailboxtrackingfolderCollectionRequest getCascadegrantrevokeaccessrecordstracker_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(
                        contextPath.addSegment("cascadegrantrevokeaccessrecordstracker_MailboxTrackingFolders"), RequestHelper.getValue(unmappedFields, "cascadegrantrevokeaccessrecordstracker_MailboxTrackingFolders"));
    }

    @NavigationProperty(name="cascadegrantrevokeaccessrecordstracker_ProcessSession")
    @JsonIgnore
    public ProcesssessionCollectionRequest getCascadegrantrevokeaccessrecordstracker_ProcessSession() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("cascadegrantrevokeaccessrecordstracker_ProcessSession"), RequestHelper.getValue(unmappedFields, "cascadegrantrevokeaccessrecordstracker_ProcessSession"));
    }

    @NavigationProperty(name="cascadegrantrevokeaccessrecordstracker_BulkDeleteFailures")
    @JsonIgnore
    public BulkdeletefailureCollectionRequest getCascadegrantrevokeaccessrecordstracker_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("cascadegrantrevokeaccessrecordstracker_BulkDeleteFailures"), RequestHelper.getValue(unmappedFields, "cascadegrantrevokeaccessrecordstracker_BulkDeleteFailures"));
    }

    @NavigationProperty(name="cascadegrantrevokeaccessrecordstracker_PrincipalObjectAttributeAccesses")
    @JsonIgnore
    public PrincipalobjectattributeaccessCollectionRequest getCascadegrantrevokeaccessrecordstracker_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("cascadegrantrevokeaccessrecordstracker_PrincipalObjectAttributeAccesses"), RequestHelper.getValue(unmappedFields, "cascadegrantrevokeaccessrecordstracker_PrincipalObjectAttributeAccesses"));
    }

    @NavigationProperty(name="cascadegrantrevokeaccessrecordstracker_FileAttachments")
    @JsonIgnore
    public FileattachmentCollectionRequest getCascadegrantrevokeaccessrecordstracker_FileAttachments() {
        return new FileattachmentCollectionRequest(
                        contextPath.addSegment("cascadegrantrevokeaccessrecordstracker_FileAttachments"), RequestHelper.getValue(unmappedFields, "cascadegrantrevokeaccessrecordstracker_FileAttachments"));
    }

    @NavigationProperty(name="SyncTrackerId")
    @JsonIgnore
    public CascadegrantrevokeaccessversiontrackerRequest getSyncTrackerId() {
        return new CascadegrantrevokeaccessversiontrackerRequest(contextPath.addSegment("SyncTrackerId"), RequestHelper.getValue(unmappedFields, "SyncTrackerId"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Cascadegrantrevokeaccessrecordstracker patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Cascadegrantrevokeaccessrecordstracker _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Cascadegrantrevokeaccessrecordstracker put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Cascadegrantrevokeaccessrecordstracker _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Cascadegrantrevokeaccessrecordstracker _copy() {
        Cascadegrantrevokeaccessrecordstracker _x = new Cascadegrantrevokeaccessrecordstracker();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.modifiedon = modifiedon;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.recordsattachment_name = recordsattachment_name;
        _x.createdon = createdon;
        _x.overriddencreatedon = overriddencreatedon;
        _x.totalrecords = totalrecords;
        _x.recordsjson = recordsjson;
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        _x.importsequencenumber = importsequencenumber;
        _x.name = name;
        _x.processedrecords = processedrecords;
        _x.statuscode = statuscode;
        _x._synctrackerid_value = _synctrackerid_value;
        _x._createdby_value = _createdby_value;
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        _x.cascadegrantrevokeaccessrecordstrackerid = cascadegrantrevokeaccessrecordstrackerid;
        _x._modifiedby_value = _modifiedby_value;
        _x.recordsattachment = recordsattachment;
        _x.statecode = statecode;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Cascadegrantrevokeaccessrecordstracker[");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("recordsattachment_name=");
        b.append(this.recordsattachment_name);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("overriddencreatedon=");
        b.append(this.overriddencreatedon);
        b.append(", ");
        b.append("totalrecords=");
        b.append(this.totalrecords);
        b.append(", ");
        b.append("recordsjson=");
        b.append(this.recordsjson);
        b.append(", ");
        b.append("timezoneruleversionnumber=");
        b.append(this.timezoneruleversionnumber);
        b.append(", ");
        b.append("importsequencenumber=");
        b.append(this.importsequencenumber);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("processedrecords=");
        b.append(this.processedrecords);
        b.append(", ");
        b.append("statuscode=");
        b.append(this.statuscode);
        b.append(", ");
        b.append("_synctrackerid_value=");
        b.append(this._synctrackerid_value);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("utcconversiontimezonecode=");
        b.append(this.utcconversiontimezonecode);
        b.append(", ");
        b.append("cascadegrantrevokeaccessrecordstrackerid=");
        b.append(this.cascadegrantrevokeaccessrecordstrackerid);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("recordsattachment=");
        b.append(this.recordsattachment);
        b.append(", ");
        b.append("statecode=");
        b.append(this.statecode);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
