package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.request.BusinessunitRequest;
import microsoft.dynamics.crm.entity.request.PrincipalRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "entityname", 
    "_modifiedonbehalfby_value", 
    "_createdby_value", 
    "modifiedon", 
    "_createdonbehalfby_value", 
    "url", 
    "scope", 
    "_owningbusinessunit_value", 
    "_modifiedby_value", 
    "_ownerid_value", 
    "runas", 
    "name", 
    "version", 
    "createdon", 
    "filterexpression", 
    "filteringattributes", 
    "message", 
    "postponeuntil", 
    "_owningteam_value", 
    "_owninguser_value", 
    "callbackregistrationid"})
@JsonInclude(Include.NON_NULL)
public class Callbackregistration extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.callbackregistration";
    }

    @JsonProperty("entityname")
    protected String entityname;

    @JsonProperty("_modifiedonbehalfby_value")
    protected UUID _modifiedonbehalfby_value;

    @JsonProperty("_createdby_value")
    protected UUID _createdby_value;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("_createdonbehalfby_value")
    protected UUID _createdonbehalfby_value;

    @JsonProperty("url")
    protected String url;

    @JsonProperty("scope")
    protected Integer scope;

    @JsonProperty("_owningbusinessunit_value")
    protected UUID _owningbusinessunit_value;

    @JsonProperty("_modifiedby_value")
    protected UUID _modifiedby_value;

    @JsonProperty("_ownerid_value")
    protected UUID _ownerid_value;

    @JsonProperty("runas")
    protected Integer runas;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("version")
    protected Integer version;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("filterexpression")
    protected String filterexpression;

    @JsonProperty("filteringattributes")
    protected String filteringattributes;

    @JsonProperty("message")
    protected Integer message;

    @JsonProperty("postponeuntil")
    protected String postponeuntil;

    @JsonProperty("_owningteam_value")
    protected UUID _owningteam_value;

    @JsonProperty("_owninguser_value")
    protected UUID _owninguser_value;

    @JsonProperty("callbackregistrationid")
    protected UUID callbackregistrationid;

    protected Callbackregistration() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderCallbackregistration() {
        return new Builder();
    }

    public static final class Builder {
        private String entityname;
        private UUID _modifiedonbehalfby_value;
        private UUID _createdby_value;
        private OffsetDateTime modifiedon;
        private UUID _createdonbehalfby_value;
        private String url;
        private Integer scope;
        private UUID _owningbusinessunit_value;
        private UUID _modifiedby_value;
        private UUID _ownerid_value;
        private Integer runas;
        private String name;
        private Integer version;
        private OffsetDateTime createdon;
        private String filterexpression;
        private String filteringattributes;
        private Integer message;
        private String postponeuntil;
        private UUID _owningteam_value;
        private UUID _owninguser_value;
        private UUID callbackregistrationid;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder entityname(String entityname) {
            this.entityname = entityname;
            this.changedFields = changedFields.add("entityname");
            return this;
        }

        public Builder _modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder _createdby_value(UUID _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder _createdonbehalfby_value(UUID _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            this.changedFields = changedFields.add("url");
            return this;
        }

        public Builder scope(Integer scope) {
            this.scope = scope;
            this.changedFields = changedFields.add("scope");
            return this;
        }

        public Builder _owningbusinessunit_value(UUID _owningbusinessunit_value) {
            this._owningbusinessunit_value = _owningbusinessunit_value;
            this.changedFields = changedFields.add("_owningbusinessunit_value");
            return this;
        }

        public Builder _modifiedby_value(UUID _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder _ownerid_value(UUID _ownerid_value) {
            this._ownerid_value = _ownerid_value;
            this.changedFields = changedFields.add("_ownerid_value");
            return this;
        }

        public Builder runas(Integer runas) {
            this.runas = runas;
            this.changedFields = changedFields.add("runas");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder filterexpression(String filterexpression) {
            this.filterexpression = filterexpression;
            this.changedFields = changedFields.add("filterexpression");
            return this;
        }

        public Builder filteringattributes(String filteringattributes) {
            this.filteringattributes = filteringattributes;
            this.changedFields = changedFields.add("filteringattributes");
            return this;
        }

        public Builder message(Integer message) {
            this.message = message;
            this.changedFields = changedFields.add("message");
            return this;
        }

        public Builder postponeuntil(String postponeuntil) {
            this.postponeuntil = postponeuntil;
            this.changedFields = changedFields.add("postponeuntil");
            return this;
        }

        public Builder _owningteam_value(UUID _owningteam_value) {
            this._owningteam_value = _owningteam_value;
            this.changedFields = changedFields.add("_owningteam_value");
            return this;
        }

        public Builder _owninguser_value(UUID _owninguser_value) {
            this._owninguser_value = _owninguser_value;
            this.changedFields = changedFields.add("_owninguser_value");
            return this;
        }

        public Builder callbackregistrationid(UUID callbackregistrationid) {
            this.callbackregistrationid = callbackregistrationid;
            this.changedFields = changedFields.add("callbackregistrationid");
            return this;
        }

        public Callbackregistration build() {
            Callbackregistration _x = new Callbackregistration();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.callbackregistration";
            _x.entityname = entityname;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x._createdby_value = _createdby_value;
            _x.modifiedon = modifiedon;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.url = url;
            _x.scope = scope;
            _x._owningbusinessunit_value = _owningbusinessunit_value;
            _x._modifiedby_value = _modifiedby_value;
            _x._ownerid_value = _ownerid_value;
            _x.runas = runas;
            _x.name = name;
            _x.version = version;
            _x.createdon = createdon;
            _x.filterexpression = filterexpression;
            _x.filteringattributes = filteringattributes;
            _x.message = message;
            _x.postponeuntil = postponeuntil;
            _x._owningteam_value = _owningteam_value;
            _x._owninguser_value = _owninguser_value;
            _x.callbackregistrationid = callbackregistrationid;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && callbackregistrationid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(callbackregistrationid, UUID.class));
        }
    }

    @Property(name="entityname")
    @JsonIgnore
    public Optional<String> getEntityname() {
        return Optional.ofNullable(entityname);
    }

    public Callbackregistration withEntityname(String entityname) {
        Checks.checkIsAscii(entityname);
        Callbackregistration _x = _copy();
        _x.changedFields = changedFields.add("entityname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.callbackregistration");
        _x.entityname = entityname;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Callbackregistration with_modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
        Callbackregistration _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.callbackregistration");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<UUID> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Callbackregistration with_createdby_value(UUID _createdby_value) {
        Callbackregistration _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.callbackregistration");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Callbackregistration withModifiedon(OffsetDateTime modifiedon) {
        Callbackregistration _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.callbackregistration");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Callbackregistration with_createdonbehalfby_value(UUID _createdonbehalfby_value) {
        Callbackregistration _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.callbackregistration");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="url")
    @JsonIgnore
    public Optional<String> getUrl() {
        return Optional.ofNullable(url);
    }

    public Callbackregistration withUrl(String url) {
        Checks.checkIsAscii(url);
        Callbackregistration _x = _copy();
        _x.changedFields = changedFields.add("url");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.callbackregistration");
        _x.url = url;
        return _x;
    }

    @Property(name="scope")
    @JsonIgnore
    public Optional<Integer> getScope() {
        return Optional.ofNullable(scope);
    }

    public Callbackregistration withScope(Integer scope) {
        Callbackregistration _x = _copy();
        _x.changedFields = changedFields.add("scope");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.callbackregistration");
        _x.scope = scope;
        return _x;
    }

    @Property(name="_owningbusinessunit_value")
    @JsonIgnore
    public Optional<UUID> get_owningbusinessunit_value() {
        return Optional.ofNullable(_owningbusinessunit_value);
    }

    public Callbackregistration with_owningbusinessunit_value(UUID _owningbusinessunit_value) {
        Callbackregistration _x = _copy();
        _x.changedFields = changedFields.add("_owningbusinessunit_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.callbackregistration");
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Callbackregistration with_modifiedby_value(UUID _modifiedby_value) {
        Callbackregistration _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.callbackregistration");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="_ownerid_value")
    @JsonIgnore
    public Optional<UUID> get_ownerid_value() {
        return Optional.ofNullable(_ownerid_value);
    }

    public Callbackregistration with_ownerid_value(UUID _ownerid_value) {
        Callbackregistration _x = _copy();
        _x.changedFields = changedFields.add("_ownerid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.callbackregistration");
        _x._ownerid_value = _ownerid_value;
        return _x;
    }

    @Property(name="runas")
    @JsonIgnore
    public Optional<Integer> getRunas() {
        return Optional.ofNullable(runas);
    }

    public Callbackregistration withRunas(Integer runas) {
        Callbackregistration _x = _copy();
        _x.changedFields = changedFields.add("runas");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.callbackregistration");
        _x.runas = runas;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public Callbackregistration withName(String name) {
        Checks.checkIsAscii(name);
        Callbackregistration _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.callbackregistration");
        _x.name = name;
        return _x;
    }

    @Property(name="version")
    @JsonIgnore
    public Optional<Integer> getVersion() {
        return Optional.ofNullable(version);
    }

    public Callbackregistration withVersion(Integer version) {
        Callbackregistration _x = _copy();
        _x.changedFields = changedFields.add("version");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.callbackregistration");
        _x.version = version;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Callbackregistration withCreatedon(OffsetDateTime createdon) {
        Callbackregistration _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.callbackregistration");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="filterexpression")
    @JsonIgnore
    public Optional<String> getFilterexpression() {
        return Optional.ofNullable(filterexpression);
    }

    public Callbackregistration withFilterexpression(String filterexpression) {
        Checks.checkIsAscii(filterexpression);
        Callbackregistration _x = _copy();
        _x.changedFields = changedFields.add("filterexpression");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.callbackregistration");
        _x.filterexpression = filterexpression;
        return _x;
    }

    @Property(name="filteringattributes")
    @JsonIgnore
    public Optional<String> getFilteringattributes() {
        return Optional.ofNullable(filteringattributes);
    }

    public Callbackregistration withFilteringattributes(String filteringattributes) {
        Checks.checkIsAscii(filteringattributes);
        Callbackregistration _x = _copy();
        _x.changedFields = changedFields.add("filteringattributes");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.callbackregistration");
        _x.filteringattributes = filteringattributes;
        return _x;
    }

    @Property(name="message")
    @JsonIgnore
    public Optional<Integer> getMessage() {
        return Optional.ofNullable(message);
    }

    public Callbackregistration withMessage(Integer message) {
        Callbackregistration _x = _copy();
        _x.changedFields = changedFields.add("message");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.callbackregistration");
        _x.message = message;
        return _x;
    }

    @Property(name="postponeuntil")
    @JsonIgnore
    public Optional<String> getPostponeuntil() {
        return Optional.ofNullable(postponeuntil);
    }

    public Callbackregistration withPostponeuntil(String postponeuntil) {
        Checks.checkIsAscii(postponeuntil);
        Callbackregistration _x = _copy();
        _x.changedFields = changedFields.add("postponeuntil");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.callbackregistration");
        _x.postponeuntil = postponeuntil;
        return _x;
    }

    @Property(name="_owningteam_value")
    @JsonIgnore
    public Optional<UUID> get_owningteam_value() {
        return Optional.ofNullable(_owningteam_value);
    }

    public Callbackregistration with_owningteam_value(UUID _owningteam_value) {
        Callbackregistration _x = _copy();
        _x.changedFields = changedFields.add("_owningteam_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.callbackregistration");
        _x._owningteam_value = _owningteam_value;
        return _x;
    }

    @Property(name="_owninguser_value")
    @JsonIgnore
    public Optional<UUID> get_owninguser_value() {
        return Optional.ofNullable(_owninguser_value);
    }

    public Callbackregistration with_owninguser_value(UUID _owninguser_value) {
        Callbackregistration _x = _copy();
        _x.changedFields = changedFields.add("_owninguser_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.callbackregistration");
        _x._owninguser_value = _owninguser_value;
        return _x;
    }

    @Property(name="callbackregistrationid")
    @JsonIgnore
    public Optional<UUID> getCallbackregistrationid() {
        return Optional.ofNullable(callbackregistrationid);
    }

    public Callbackregistration withCallbackregistrationid(UUID callbackregistrationid) {
        Callbackregistration _x = _copy();
        _x.changedFields = changedFields.add("callbackregistrationid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.callbackregistration");
        _x.callbackregistrationid = callbackregistrationid;
        return _x;
    }

    public Callbackregistration withUnmappedField(String name, String value) {
        Callbackregistration _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="callbackregistration_modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCallbackregistration_modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("callbackregistration_modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "callbackregistration_modifiedonbehalfby"));
    }

    @NavigationProperty(name="callbackregistration_modifiedby")
    @JsonIgnore
    public SystemuserRequest getCallbackregistration_modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("callbackregistration_modifiedby"), RequestHelper.getValue(unmappedFields, "callbackregistration_modifiedby"));
    }

    @NavigationProperty(name="callbackregistration_createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCallbackregistration_createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("callbackregistration_createdonbehalfby"), RequestHelper.getValue(unmappedFields, "callbackregistration_createdonbehalfby"));
    }

    @NavigationProperty(name="callbackregistration_createdby")
    @JsonIgnore
    public SystemuserRequest getCallbackregistration_createdby() {
        return new SystemuserRequest(contextPath.addSegment("callbackregistration_createdby"), RequestHelper.getValue(unmappedFields, "callbackregistration_createdby"));
    }

    @NavigationProperty(name="owningbusinessunit")
    @JsonIgnore
    public BusinessunitRequest getOwningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), RequestHelper.getValue(unmappedFields, "owningbusinessunit"));
    }

    @NavigationProperty(name="ownerid")
    @JsonIgnore
    public PrincipalRequest getOwnerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), RequestHelper.getValue(unmappedFields, "ownerid"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Callbackregistration patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Callbackregistration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Callbackregistration put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Callbackregistration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Callbackregistration _copy() {
        Callbackregistration _x = new Callbackregistration();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.entityname = entityname;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x._createdby_value = _createdby_value;
        _x.modifiedon = modifiedon;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.url = url;
        _x.scope = scope;
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        _x._modifiedby_value = _modifiedby_value;
        _x._ownerid_value = _ownerid_value;
        _x.runas = runas;
        _x.name = name;
        _x.version = version;
        _x.createdon = createdon;
        _x.filterexpression = filterexpression;
        _x.filteringattributes = filteringattributes;
        _x.message = message;
        _x.postponeuntil = postponeuntil;
        _x._owningteam_value = _owningteam_value;
        _x._owninguser_value = _owninguser_value;
        _x.callbackregistrationid = callbackregistrationid;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Callbackregistration[");
        b.append("entityname=");
        b.append(this.entityname);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("url=");
        b.append(this.url);
        b.append(", ");
        b.append("scope=");
        b.append(this.scope);
        b.append(", ");
        b.append("_owningbusinessunit_value=");
        b.append(this._owningbusinessunit_value);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("_ownerid_value=");
        b.append(this._ownerid_value);
        b.append(", ");
        b.append("runas=");
        b.append(this.runas);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("filterexpression=");
        b.append(this.filterexpression);
        b.append(", ");
        b.append("filteringattributes=");
        b.append(this.filteringattributes);
        b.append(", ");
        b.append("message=");
        b.append(this.message);
        b.append(", ");
        b.append("postponeuntil=");
        b.append(this.postponeuntil);
        b.append(", ");
        b.append("_owningteam_value=");
        b.append(this._owningteam_value);
        b.append(", ");
        b.append("_owninguser_value=");
        b.append(this._owninguser_value);
        b.append(", ");
        b.append("callbackregistrationid=");
        b.append(this.callbackregistrationid);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
