package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Double;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.collection.request.BulkdeleteoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DuplicaterecordCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.EmailCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.FileattachmentCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MailboxtrackingfolderCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SocialactivityCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.WorkflowlogCollectionRequest;
import microsoft.dynamics.crm.entity.request.AccountRequest;
import microsoft.dynamics.crm.entity.request.ActivitymimeattachmentRequest;
import microsoft.dynamics.crm.entity.request.ActivitypointerRequest;
import microsoft.dynamics.crm.entity.request.AnnotationRequest;
import microsoft.dynamics.crm.entity.request.AnnualfiscalcalendarRequest;
import microsoft.dynamics.crm.entity.request.ApplicationuserRequest;
import microsoft.dynamics.crm.entity.request.AppointmentRequest;
import microsoft.dynamics.crm.entity.request.AttributeimageconfigRequest;
import microsoft.dynamics.crm.entity.request.BusinessunitRequest;
import microsoft.dynamics.crm.entity.request.BusinessunitnewsarticleRequest;
import microsoft.dynamics.crm.entity.request.CalendarRequest;
import microsoft.dynamics.crm.entity.request.CascadegrantrevokeaccessrecordstrackerRequest;
import microsoft.dynamics.crm.entity.request.CascadegrantrevokeaccessversiontrackerRequest;
import microsoft.dynamics.crm.entity.request.ConnectionRequest;
import microsoft.dynamics.crm.entity.request.ConnectionreferenceRequest;
import microsoft.dynamics.crm.entity.request.ConnectionroleRequest;
import microsoft.dynamics.crm.entity.request.ConnectorRequest;
import microsoft.dynamics.crm.entity.request.ContactRequest;
import microsoft.dynamics.crm.entity.request.CustomeraddressRequest;
import microsoft.dynamics.crm.entity.request.DatalakeworkspaceRequest;
import microsoft.dynamics.crm.entity.request.DatalakeworkspacepermissionRequest;
import microsoft.dynamics.crm.entity.request.DisplaystringRequest;
import microsoft.dynamics.crm.entity.request.EmailRequest;
import microsoft.dynamics.crm.entity.request.EmailserverprofileRequest;
import microsoft.dynamics.crm.entity.request.EntityanalyticsconfigRequest;
import microsoft.dynamics.crm.entity.request.EntityimageconfigRequest;
import microsoft.dynamics.crm.entity.request.EnvironmentvariabledefinitionRequest;
import microsoft.dynamics.crm.entity.request.EnvironmentvariablevalueRequest;
import microsoft.dynamics.crm.entity.request.ExportsolutionuploadRequest;
import microsoft.dynamics.crm.entity.request.FaxRequest;
import microsoft.dynamics.crm.entity.request.FileattachmentRequest;
import microsoft.dynamics.crm.entity.request.FixedmonthlyfiscalcalendarRequest;
import microsoft.dynamics.crm.entity.request.FlowsessionRequest;
import microsoft.dynamics.crm.entity.request.Ggw_crewRequest;
import microsoft.dynamics.crm.entity.request.Ggw_eventRequest;
import microsoft.dynamics.crm.entity.request.Ggw_teamRequest;
import microsoft.dynamics.crm.entity.request.Ggw_team_applicationRequest;
import microsoft.dynamics.crm.entity.request.GoalRequest;
import microsoft.dynamics.crm.entity.request.GoalrollupqueryRequest;
import microsoft.dynamics.crm.entity.request.ImportRequest;
import microsoft.dynamics.crm.entity.request.ImportdataRequest;
import microsoft.dynamics.crm.entity.request.ImportfileRequest;
import microsoft.dynamics.crm.entity.request.ImportlogRequest;
import microsoft.dynamics.crm.entity.request.ImportmapRequest;
import microsoft.dynamics.crm.entity.request.InteractionforemailRequest;
import microsoft.dynamics.crm.entity.request.KbarticleRequest;
import microsoft.dynamics.crm.entity.request.KbarticlecommentRequest;
import microsoft.dynamics.crm.entity.request.KbarticletemplateRequest;
import microsoft.dynamics.crm.entity.request.KnowledgearticleRequest;
import microsoft.dynamics.crm.entity.request.KnowledgebaserecordRequest;
import microsoft.dynamics.crm.entity.request.LetterRequest;
import microsoft.dynamics.crm.entity.request.MailboxRequest;
import microsoft.dynamics.crm.entity.request.MailmergetemplateRequest;
import microsoft.dynamics.crm.entity.request.MetricRequest;
import microsoft.dynamics.crm.entity.request.MonthlyfiscalcalendarRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aibdatasetRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aibdatasetfileRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aibdatasetrecordRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aibdatasetscontainerRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aibfileRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aibfileattacheddataRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aiconfigurationRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aifptrainingdocumentRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aimodelRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aiodimageRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aiodlabelRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aiodtrainingboundingboxRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aiodtrainingimageRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aitemplateRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_analysiscomponentRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_analysisjobRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_analysisresultRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_analysisresultdetailRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_dataflowRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_helppageRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_knowledgearticleimageRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_knowledgearticletemplateRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_richtextfileRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_serviceconfigurationRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_slakpiRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_solutionhealthruleRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_solutionhealthruleargumentRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_solutionhealthrulesetRequest;
import microsoft.dynamics.crm.entity.request.OrganizationRequest;
import microsoft.dynamics.crm.entity.request.PhonecallRequest;
import microsoft.dynamics.crm.entity.request.PositionRequest;
import microsoft.dynamics.crm.entity.request.PostRequest;
import microsoft.dynamics.crm.entity.request.PostfollowRequest;
import microsoft.dynamics.crm.entity.request.PrincipalRequest;
import microsoft.dynamics.crm.entity.request.PrivilegeRequest;
import microsoft.dynamics.crm.entity.request.ProcessstageparameterRequest;
import microsoft.dynamics.crm.entity.request.QuarterlyfiscalcalendarRequest;
import microsoft.dynamics.crm.entity.request.QueueRequest;
import microsoft.dynamics.crm.entity.request.QueueitemRequest;
import microsoft.dynamics.crm.entity.request.RecurringappointmentmasterRequest;
import microsoft.dynamics.crm.entity.request.RelationshipattributeRequest;
import microsoft.dynamics.crm.entity.request.ReportRequest;
import microsoft.dynamics.crm.entity.request.RoleRequest;
import microsoft.dynamics.crm.entity.request.RollupfieldRequest;
import microsoft.dynamics.crm.entity.request.SavedqueryRequest;
import microsoft.dynamics.crm.entity.request.SdkmessageprocessingstepRequest;
import microsoft.dynamics.crm.entity.request.SemiannualfiscalcalendarRequest;
import microsoft.dynamics.crm.entity.request.ServiceplanRequest;
import microsoft.dynamics.crm.entity.request.SharepointdocumentlocationRequest;
import microsoft.dynamics.crm.entity.request.SharepointsiteRequest;
import microsoft.dynamics.crm.entity.request.SimilarityruleRequest;
import microsoft.dynamics.crm.entity.request.SlaRequest;
import microsoft.dynamics.crm.entity.request.SocialactivityRequest;
import microsoft.dynamics.crm.entity.request.SocialprofileRequest;
import microsoft.dynamics.crm.entity.request.SolutioncomponentattributeconfigurationRequest;
import microsoft.dynamics.crm.entity.request.SolutioncomponentconfigurationRequest;
import microsoft.dynamics.crm.entity.request.SolutioncomponentrelationshipconfigurationRequest;
import microsoft.dynamics.crm.entity.request.StagesolutionuploadRequest;
import microsoft.dynamics.crm.entity.request.SubjectRequest;
import microsoft.dynamics.crm.entity.request.SystemformRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.TaskRequest;
import microsoft.dynamics.crm.entity.request.TeamRequest;
import microsoft.dynamics.crm.entity.request.TemplateRequest;
import microsoft.dynamics.crm.entity.request.TerritoryRequest;
import microsoft.dynamics.crm.entity.request.ThemeRequest;
import microsoft.dynamics.crm.entity.request.TransactioncurrencyRequest;
import microsoft.dynamics.crm.entity.request.UserformRequest;
import microsoft.dynamics.crm.entity.request.UsermappingRequest;
import microsoft.dynamics.crm.entity.request.UserqueryRequest;
import microsoft.dynamics.crm.entity.request.WorkflowRequest;
import microsoft.dynamics.crm.entity.request.WorkflowbinaryRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "callerorigin", 
    "expanderstarttime", 
    "_modifiedonbehalfby_value", 
    "primaryentitytype", 
    "requestid", 
    "workflowstagename", 
    "_regardingobjectid_value", 
    "_modifiedby_value", 
    "_workflowactivationid_value", 
    "modifiedon", 
    "breadcrumbid", 
    "startedon", 
    "statecode", 
    "errorcode", 
    "recurrencestarttime", 
    "recurrencepattern", 
    "parentpluginexecutionid", 
    "_owningbusinessunit_value", 
    "friendlymessage", 
    "correlationupdatedtime", 
    "message", 
    "_owningextensionid_value", 
    "postponeuntil", 
    "depth", 
    "correlationid", 
    "_owningteam_value", 
    "retainjobhistory", 
    "hostid", 
    "createdon", 
    "completedon", 
    "retrycount", 
    "timezoneruleversionnumber", 
    "subtype", 
    "_createdby_value", 
    "_owninguser_value", 
    "datablobid_name", 
    "dependencytoken", 
    "messagename", 
    "_ownerid_value", 
    "utcconversiontimezonecode", 
    "statuscode", 
    "rootexecutioncontext", 
    "operationtype", 
    "name", 
    "data", 
    "sequence", 
    "asyncoperationid", 
    "_createdonbehalfby_value", 
    "executiontimespan", 
    "iswaitingforevent", 
    "workload"})
@JsonInclude(Include.NON_NULL)
public class Asyncoperation extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.asyncoperation";
    }

    @JsonProperty("callerorigin")
    protected String callerorigin;

    @JsonProperty("expanderstarttime")
    protected OffsetDateTime expanderstarttime;

    @JsonProperty("_modifiedonbehalfby_value")
    protected UUID _modifiedonbehalfby_value;

    @JsonProperty("primaryentitytype")
    protected String primaryentitytype;

    @JsonProperty("requestid")
    protected UUID requestid;

    @JsonProperty("workflowstagename")
    protected String workflowstagename;

    @JsonProperty("_regardingobjectid_value")
    protected UUID _regardingobjectid_value;

    @JsonProperty("_modifiedby_value")
    protected UUID _modifiedby_value;

    @JsonProperty("_workflowactivationid_value")
    protected UUID _workflowactivationid_value;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("breadcrumbid")
    protected UUID breadcrumbid;

    @JsonProperty("startedon")
    protected OffsetDateTime startedon;

    @JsonProperty("statecode")
    protected Integer statecode;

    @JsonProperty("errorcode")
    protected Integer errorcode;

    @JsonProperty("recurrencestarttime")
    protected OffsetDateTime recurrencestarttime;

    @JsonProperty("recurrencepattern")
    protected String recurrencepattern;

    @JsonProperty("parentpluginexecutionid")
    protected UUID parentpluginexecutionid;

    @JsonProperty("_owningbusinessunit_value")
    protected UUID _owningbusinessunit_value;

    @JsonProperty("friendlymessage")
    protected String friendlymessage;

    @JsonProperty("correlationupdatedtime")
    protected OffsetDateTime correlationupdatedtime;

    @JsonProperty("message")
    protected String message;

    @JsonProperty("_owningextensionid_value")
    protected UUID _owningextensionid_value;

    @JsonProperty("postponeuntil")
    protected OffsetDateTime postponeuntil;

    @JsonProperty("depth")
    protected Integer depth;

    @JsonProperty("correlationid")
    protected UUID correlationid;

    @JsonProperty("_owningteam_value")
    protected UUID _owningteam_value;

    @JsonProperty("retainjobhistory")
    protected Boolean retainjobhistory;

    @JsonProperty("hostid")
    protected String hostid;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("completedon")
    protected OffsetDateTime completedon;

    @JsonProperty("retrycount")
    protected Integer retrycount;

    @JsonProperty("timezoneruleversionnumber")
    protected Integer timezoneruleversionnumber;

    @JsonProperty("subtype")
    protected Integer subtype;

    @JsonProperty("_createdby_value")
    protected UUID _createdby_value;

    @JsonProperty("_owninguser_value")
    protected UUID _owninguser_value;

    @JsonProperty("datablobid_name")
    protected String datablobid_name;

    @JsonProperty("dependencytoken")
    protected String dependencytoken;

    @JsonProperty("messagename")
    protected String messagename;

    @JsonProperty("_ownerid_value")
    protected UUID _ownerid_value;

    @JsonProperty("utcconversiontimezonecode")
    protected Integer utcconversiontimezonecode;

    @JsonProperty("statuscode")
    protected Integer statuscode;

    @JsonProperty("rootexecutioncontext")
    protected String rootexecutioncontext;

    @JsonProperty("operationtype")
    protected Integer operationtype;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("data")
    protected String data;

    @JsonProperty("sequence")
    protected Long sequence;

    @JsonProperty("asyncoperationid")
    protected UUID asyncoperationid;

    @JsonProperty("_createdonbehalfby_value")
    protected UUID _createdonbehalfby_value;

    @JsonProperty("executiontimespan")
    protected Double executiontimespan;

    @JsonProperty("iswaitingforevent")
    protected Boolean iswaitingforevent;

    @JsonProperty("workload")
    protected String workload;

    protected Asyncoperation() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAsyncoperation() {
        return new Builder();
    }

    public static final class Builder {
        private String callerorigin;
        private OffsetDateTime expanderstarttime;
        private UUID _modifiedonbehalfby_value;
        private String primaryentitytype;
        private UUID requestid;
        private String workflowstagename;
        private UUID _regardingobjectid_value;
        private UUID _modifiedby_value;
        private UUID _workflowactivationid_value;
        private OffsetDateTime modifiedon;
        private UUID breadcrumbid;
        private OffsetDateTime startedon;
        private Integer statecode;
        private Integer errorcode;
        private OffsetDateTime recurrencestarttime;
        private String recurrencepattern;
        private UUID parentpluginexecutionid;
        private UUID _owningbusinessunit_value;
        private String friendlymessage;
        private OffsetDateTime correlationupdatedtime;
        private String message;
        private UUID _owningextensionid_value;
        private OffsetDateTime postponeuntil;
        private Integer depth;
        private UUID correlationid;
        private UUID _owningteam_value;
        private Boolean retainjobhistory;
        private String hostid;
        private OffsetDateTime createdon;
        private OffsetDateTime completedon;
        private Integer retrycount;
        private Integer timezoneruleversionnumber;
        private Integer subtype;
        private UUID _createdby_value;
        private UUID _owninguser_value;
        private String datablobid_name;
        private String dependencytoken;
        private String messagename;
        private UUID _ownerid_value;
        private Integer utcconversiontimezonecode;
        private Integer statuscode;
        private String rootexecutioncontext;
        private Integer operationtype;
        private String name;
        private String data;
        private Long sequence;
        private UUID asyncoperationid;
        private UUID _createdonbehalfby_value;
        private Double executiontimespan;
        private Boolean iswaitingforevent;
        private String workload;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder callerorigin(String callerorigin) {
            this.callerorigin = callerorigin;
            this.changedFields = changedFields.add("callerorigin");
            return this;
        }

        public Builder expanderstarttime(OffsetDateTime expanderstarttime) {
            this.expanderstarttime = expanderstarttime;
            this.changedFields = changedFields.add("expanderstarttime");
            return this;
        }

        public Builder _modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder primaryentitytype(String primaryentitytype) {
            this.primaryentitytype = primaryentitytype;
            this.changedFields = changedFields.add("primaryentitytype");
            return this;
        }

        public Builder requestid(UUID requestid) {
            this.requestid = requestid;
            this.changedFields = changedFields.add("requestid");
            return this;
        }

        public Builder workflowstagename(String workflowstagename) {
            this.workflowstagename = workflowstagename;
            this.changedFields = changedFields.add("workflowstagename");
            return this;
        }

        public Builder _regardingobjectid_value(UUID _regardingobjectid_value) {
            this._regardingobjectid_value = _regardingobjectid_value;
            this.changedFields = changedFields.add("_regardingobjectid_value");
            return this;
        }

        public Builder _modifiedby_value(UUID _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder _workflowactivationid_value(UUID _workflowactivationid_value) {
            this._workflowactivationid_value = _workflowactivationid_value;
            this.changedFields = changedFields.add("_workflowactivationid_value");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder breadcrumbid(UUID breadcrumbid) {
            this.breadcrumbid = breadcrumbid;
            this.changedFields = changedFields.add("breadcrumbid");
            return this;
        }

        public Builder startedon(OffsetDateTime startedon) {
            this.startedon = startedon;
            this.changedFields = changedFields.add("startedon");
            return this;
        }

        public Builder statecode(Integer statecode) {
            this.statecode = statecode;
            this.changedFields = changedFields.add("statecode");
            return this;
        }

        public Builder errorcode(Integer errorcode) {
            this.errorcode = errorcode;
            this.changedFields = changedFields.add("errorcode");
            return this;
        }

        public Builder recurrencestarttime(OffsetDateTime recurrencestarttime) {
            this.recurrencestarttime = recurrencestarttime;
            this.changedFields = changedFields.add("recurrencestarttime");
            return this;
        }

        public Builder recurrencepattern(String recurrencepattern) {
            this.recurrencepattern = recurrencepattern;
            this.changedFields = changedFields.add("recurrencepattern");
            return this;
        }

        public Builder parentpluginexecutionid(UUID parentpluginexecutionid) {
            this.parentpluginexecutionid = parentpluginexecutionid;
            this.changedFields = changedFields.add("parentpluginexecutionid");
            return this;
        }

        public Builder _owningbusinessunit_value(UUID _owningbusinessunit_value) {
            this._owningbusinessunit_value = _owningbusinessunit_value;
            this.changedFields = changedFields.add("_owningbusinessunit_value");
            return this;
        }

        public Builder friendlymessage(String friendlymessage) {
            this.friendlymessage = friendlymessage;
            this.changedFields = changedFields.add("friendlymessage");
            return this;
        }

        public Builder correlationupdatedtime(OffsetDateTime correlationupdatedtime) {
            this.correlationupdatedtime = correlationupdatedtime;
            this.changedFields = changedFields.add("correlationupdatedtime");
            return this;
        }

        public Builder message(String message) {
            this.message = message;
            this.changedFields = changedFields.add("message");
            return this;
        }

        public Builder _owningextensionid_value(UUID _owningextensionid_value) {
            this._owningextensionid_value = _owningextensionid_value;
            this.changedFields = changedFields.add("_owningextensionid_value");
            return this;
        }

        public Builder postponeuntil(OffsetDateTime postponeuntil) {
            this.postponeuntil = postponeuntil;
            this.changedFields = changedFields.add("postponeuntil");
            return this;
        }

        public Builder depth(Integer depth) {
            this.depth = depth;
            this.changedFields = changedFields.add("depth");
            return this;
        }

        public Builder correlationid(UUID correlationid) {
            this.correlationid = correlationid;
            this.changedFields = changedFields.add("correlationid");
            return this;
        }

        public Builder _owningteam_value(UUID _owningteam_value) {
            this._owningteam_value = _owningteam_value;
            this.changedFields = changedFields.add("_owningteam_value");
            return this;
        }

        public Builder retainjobhistory(Boolean retainjobhistory) {
            this.retainjobhistory = retainjobhistory;
            this.changedFields = changedFields.add("retainjobhistory");
            return this;
        }

        public Builder hostid(String hostid) {
            this.hostid = hostid;
            this.changedFields = changedFields.add("hostid");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder completedon(OffsetDateTime completedon) {
            this.completedon = completedon;
            this.changedFields = changedFields.add("completedon");
            return this;
        }

        public Builder retrycount(Integer retrycount) {
            this.retrycount = retrycount;
            this.changedFields = changedFields.add("retrycount");
            return this;
        }

        public Builder timezoneruleversionnumber(Integer timezoneruleversionnumber) {
            this.timezoneruleversionnumber = timezoneruleversionnumber;
            this.changedFields = changedFields.add("timezoneruleversionnumber");
            return this;
        }

        public Builder subtype(Integer subtype) {
            this.subtype = subtype;
            this.changedFields = changedFields.add("subtype");
            return this;
        }

        public Builder _createdby_value(UUID _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder _owninguser_value(UUID _owninguser_value) {
            this._owninguser_value = _owninguser_value;
            this.changedFields = changedFields.add("_owninguser_value");
            return this;
        }

        public Builder datablobid_name(String datablobid_name) {
            this.datablobid_name = datablobid_name;
            this.changedFields = changedFields.add("datablobid_name");
            return this;
        }

        public Builder dependencytoken(String dependencytoken) {
            this.dependencytoken = dependencytoken;
            this.changedFields = changedFields.add("dependencytoken");
            return this;
        }

        public Builder messagename(String messagename) {
            this.messagename = messagename;
            this.changedFields = changedFields.add("messagename");
            return this;
        }

        public Builder _ownerid_value(UUID _ownerid_value) {
            this._ownerid_value = _ownerid_value;
            this.changedFields = changedFields.add("_ownerid_value");
            return this;
        }

        public Builder utcconversiontimezonecode(Integer utcconversiontimezonecode) {
            this.utcconversiontimezonecode = utcconversiontimezonecode;
            this.changedFields = changedFields.add("utcconversiontimezonecode");
            return this;
        }

        public Builder statuscode(Integer statuscode) {
            this.statuscode = statuscode;
            this.changedFields = changedFields.add("statuscode");
            return this;
        }

        public Builder rootexecutioncontext(String rootexecutioncontext) {
            this.rootexecutioncontext = rootexecutioncontext;
            this.changedFields = changedFields.add("rootexecutioncontext");
            return this;
        }

        public Builder operationtype(Integer operationtype) {
            this.operationtype = operationtype;
            this.changedFields = changedFields.add("operationtype");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder data(String data) {
            this.data = data;
            this.changedFields = changedFields.add("data");
            return this;
        }

        public Builder sequence(Long sequence) {
            this.sequence = sequence;
            this.changedFields = changedFields.add("sequence");
            return this;
        }

        public Builder asyncoperationid(UUID asyncoperationid) {
            this.asyncoperationid = asyncoperationid;
            this.changedFields = changedFields.add("asyncoperationid");
            return this;
        }

        public Builder _createdonbehalfby_value(UUID _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder executiontimespan(Double executiontimespan) {
            this.executiontimespan = executiontimespan;
            this.changedFields = changedFields.add("executiontimespan");
            return this;
        }

        public Builder iswaitingforevent(Boolean iswaitingforevent) {
            this.iswaitingforevent = iswaitingforevent;
            this.changedFields = changedFields.add("iswaitingforevent");
            return this;
        }

        public Builder workload(String workload) {
            this.workload = workload;
            this.changedFields = changedFields.add("workload");
            return this;
        }

        public Asyncoperation build() {
            Asyncoperation _x = new Asyncoperation();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.asyncoperation";
            _x.callerorigin = callerorigin;
            _x.expanderstarttime = expanderstarttime;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.primaryentitytype = primaryentitytype;
            _x.requestid = requestid;
            _x.workflowstagename = workflowstagename;
            _x._regardingobjectid_value = _regardingobjectid_value;
            _x._modifiedby_value = _modifiedby_value;
            _x._workflowactivationid_value = _workflowactivationid_value;
            _x.modifiedon = modifiedon;
            _x.breadcrumbid = breadcrumbid;
            _x.startedon = startedon;
            _x.statecode = statecode;
            _x.errorcode = errorcode;
            _x.recurrencestarttime = recurrencestarttime;
            _x.recurrencepattern = recurrencepattern;
            _x.parentpluginexecutionid = parentpluginexecutionid;
            _x._owningbusinessunit_value = _owningbusinessunit_value;
            _x.friendlymessage = friendlymessage;
            _x.correlationupdatedtime = correlationupdatedtime;
            _x.message = message;
            _x._owningextensionid_value = _owningextensionid_value;
            _x.postponeuntil = postponeuntil;
            _x.depth = depth;
            _x.correlationid = correlationid;
            _x._owningteam_value = _owningteam_value;
            _x.retainjobhistory = retainjobhistory;
            _x.hostid = hostid;
            _x.createdon = createdon;
            _x.completedon = completedon;
            _x.retrycount = retrycount;
            _x.timezoneruleversionnumber = timezoneruleversionnumber;
            _x.subtype = subtype;
            _x._createdby_value = _createdby_value;
            _x._owninguser_value = _owninguser_value;
            _x.datablobid_name = datablobid_name;
            _x.dependencytoken = dependencytoken;
            _x.messagename = messagename;
            _x._ownerid_value = _ownerid_value;
            _x.utcconversiontimezonecode = utcconversiontimezonecode;
            _x.statuscode = statuscode;
            _x.rootexecutioncontext = rootexecutioncontext;
            _x.operationtype = operationtype;
            _x.name = name;
            _x.data = data;
            _x.sequence = sequence;
            _x.asyncoperationid = asyncoperationid;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.executiontimespan = executiontimespan;
            _x.iswaitingforevent = iswaitingforevent;
            _x.workload = workload;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && asyncoperationid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(asyncoperationid, UUID.class));
        }
    }

    @Property(name="callerorigin")
    @JsonIgnore
    public Optional<String> getCallerorigin() {
        return Optional.ofNullable(callerorigin);
    }

    public Asyncoperation withCallerorigin(String callerorigin) {
        Checks.checkIsAscii(callerorigin);
        Asyncoperation _x = _copy();
        _x.changedFields = changedFields.add("callerorigin");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.asyncoperation");
        _x.callerorigin = callerorigin;
        return _x;
    }

    @Property(name="expanderstarttime")
    @JsonIgnore
    public Optional<OffsetDateTime> getExpanderstarttime() {
        return Optional.ofNullable(expanderstarttime);
    }

    public Asyncoperation withExpanderstarttime(OffsetDateTime expanderstarttime) {
        Asyncoperation _x = _copy();
        _x.changedFields = changedFields.add("expanderstarttime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.asyncoperation");
        _x.expanderstarttime = expanderstarttime;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Asyncoperation with_modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
        Asyncoperation _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.asyncoperation");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="primaryentitytype")
    @JsonIgnore
    public Optional<String> getPrimaryentitytype() {
        return Optional.ofNullable(primaryentitytype);
    }

    public Asyncoperation withPrimaryentitytype(String primaryentitytype) {
        Checks.checkIsAscii(primaryentitytype);
        Asyncoperation _x = _copy();
        _x.changedFields = changedFields.add("primaryentitytype");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.asyncoperation");
        _x.primaryentitytype = primaryentitytype;
        return _x;
    }

    @Property(name="requestid")
    @JsonIgnore
    public Optional<UUID> getRequestid() {
        return Optional.ofNullable(requestid);
    }

    public Asyncoperation withRequestid(UUID requestid) {
        Asyncoperation _x = _copy();
        _x.changedFields = changedFields.add("requestid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.asyncoperation");
        _x.requestid = requestid;
        return _x;
    }

    @Property(name="workflowstagename")
    @JsonIgnore
    public Optional<String> getWorkflowstagename() {
        return Optional.ofNullable(workflowstagename);
    }

    public Asyncoperation withWorkflowstagename(String workflowstagename) {
        Checks.checkIsAscii(workflowstagename);
        Asyncoperation _x = _copy();
        _x.changedFields = changedFields.add("workflowstagename");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.asyncoperation");
        _x.workflowstagename = workflowstagename;
        return _x;
    }

    @Property(name="_regardingobjectid_value")
    @JsonIgnore
    public Optional<UUID> get_regardingobjectid_value() {
        return Optional.ofNullable(_regardingobjectid_value);
    }

    public Asyncoperation with_regardingobjectid_value(UUID _regardingobjectid_value) {
        Asyncoperation _x = _copy();
        _x.changedFields = changedFields.add("_regardingobjectid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.asyncoperation");
        _x._regardingobjectid_value = _regardingobjectid_value;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Asyncoperation with_modifiedby_value(UUID _modifiedby_value) {
        Asyncoperation _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.asyncoperation");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="_workflowactivationid_value")
    @JsonIgnore
    public Optional<UUID> get_workflowactivationid_value() {
        return Optional.ofNullable(_workflowactivationid_value);
    }

    public Asyncoperation with_workflowactivationid_value(UUID _workflowactivationid_value) {
        Asyncoperation _x = _copy();
        _x.changedFields = changedFields.add("_workflowactivationid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.asyncoperation");
        _x._workflowactivationid_value = _workflowactivationid_value;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Asyncoperation withModifiedon(OffsetDateTime modifiedon) {
        Asyncoperation _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.asyncoperation");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="breadcrumbid")
    @JsonIgnore
    public Optional<UUID> getBreadcrumbid() {
        return Optional.ofNullable(breadcrumbid);
    }

    public Asyncoperation withBreadcrumbid(UUID breadcrumbid) {
        Asyncoperation _x = _copy();
        _x.changedFields = changedFields.add("breadcrumbid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.asyncoperation");
        _x.breadcrumbid = breadcrumbid;
        return _x;
    }

    @Property(name="startedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getStartedon() {
        return Optional.ofNullable(startedon);
    }

    public Asyncoperation withStartedon(OffsetDateTime startedon) {
        Asyncoperation _x = _copy();
        _x.changedFields = changedFields.add("startedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.asyncoperation");
        _x.startedon = startedon;
        return _x;
    }

    @Property(name="statecode")
    @JsonIgnore
    public Optional<Integer> getStatecode() {
        return Optional.ofNullable(statecode);
    }

    public Asyncoperation withStatecode(Integer statecode) {
        Asyncoperation _x = _copy();
        _x.changedFields = changedFields.add("statecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.asyncoperation");
        _x.statecode = statecode;
        return _x;
    }

    @Property(name="errorcode")
    @JsonIgnore
    public Optional<Integer> getErrorcode() {
        return Optional.ofNullable(errorcode);
    }

    public Asyncoperation withErrorcode(Integer errorcode) {
        Asyncoperation _x = _copy();
        _x.changedFields = changedFields.add("errorcode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.asyncoperation");
        _x.errorcode = errorcode;
        return _x;
    }

    @Property(name="recurrencestarttime")
    @JsonIgnore
    public Optional<OffsetDateTime> getRecurrencestarttime() {
        return Optional.ofNullable(recurrencestarttime);
    }

    public Asyncoperation withRecurrencestarttime(OffsetDateTime recurrencestarttime) {
        Asyncoperation _x = _copy();
        _x.changedFields = changedFields.add("recurrencestarttime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.asyncoperation");
        _x.recurrencestarttime = recurrencestarttime;
        return _x;
    }

    @Property(name="recurrencepattern")
    @JsonIgnore
    public Optional<String> getRecurrencepattern() {
        return Optional.ofNullable(recurrencepattern);
    }

    public Asyncoperation withRecurrencepattern(String recurrencepattern) {
        Checks.checkIsAscii(recurrencepattern);
        Asyncoperation _x = _copy();
        _x.changedFields = changedFields.add("recurrencepattern");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.asyncoperation");
        _x.recurrencepattern = recurrencepattern;
        return _x;
    }

    @Property(name="parentpluginexecutionid")
    @JsonIgnore
    public Optional<UUID> getParentpluginexecutionid() {
        return Optional.ofNullable(parentpluginexecutionid);
    }

    public Asyncoperation withParentpluginexecutionid(UUID parentpluginexecutionid) {
        Asyncoperation _x = _copy();
        _x.changedFields = changedFields.add("parentpluginexecutionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.asyncoperation");
        _x.parentpluginexecutionid = parentpluginexecutionid;
        return _x;
    }

    @Property(name="_owningbusinessunit_value")
    @JsonIgnore
    public Optional<UUID> get_owningbusinessunit_value() {
        return Optional.ofNullable(_owningbusinessunit_value);
    }

    public Asyncoperation with_owningbusinessunit_value(UUID _owningbusinessunit_value) {
        Asyncoperation _x = _copy();
        _x.changedFields = changedFields.add("_owningbusinessunit_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.asyncoperation");
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        return _x;
    }

    @Property(name="friendlymessage")
    @JsonIgnore
    public Optional<String> getFriendlymessage() {
        return Optional.ofNullable(friendlymessage);
    }

    public Asyncoperation withFriendlymessage(String friendlymessage) {
        Checks.checkIsAscii(friendlymessage);
        Asyncoperation _x = _copy();
        _x.changedFields = changedFields.add("friendlymessage");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.asyncoperation");
        _x.friendlymessage = friendlymessage;
        return _x;
    }

    @Property(name="correlationupdatedtime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCorrelationupdatedtime() {
        return Optional.ofNullable(correlationupdatedtime);
    }

    public Asyncoperation withCorrelationupdatedtime(OffsetDateTime correlationupdatedtime) {
        Asyncoperation _x = _copy();
        _x.changedFields = changedFields.add("correlationupdatedtime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.asyncoperation");
        _x.correlationupdatedtime = correlationupdatedtime;
        return _x;
    }

    @Property(name="message")
    @JsonIgnore
    public Optional<String> getMessage() {
        return Optional.ofNullable(message);
    }

    public Asyncoperation withMessage(String message) {
        Checks.checkIsAscii(message);
        Asyncoperation _x = _copy();
        _x.changedFields = changedFields.add("message");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.asyncoperation");
        _x.message = message;
        return _x;
    }

    @Property(name="_owningextensionid_value")
    @JsonIgnore
    public Optional<UUID> get_owningextensionid_value() {
        return Optional.ofNullable(_owningextensionid_value);
    }

    public Asyncoperation with_owningextensionid_value(UUID _owningextensionid_value) {
        Asyncoperation _x = _copy();
        _x.changedFields = changedFields.add("_owningextensionid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.asyncoperation");
        _x._owningextensionid_value = _owningextensionid_value;
        return _x;
    }

    @Property(name="postponeuntil")
    @JsonIgnore
    public Optional<OffsetDateTime> getPostponeuntil() {
        return Optional.ofNullable(postponeuntil);
    }

    public Asyncoperation withPostponeuntil(OffsetDateTime postponeuntil) {
        Asyncoperation _x = _copy();
        _x.changedFields = changedFields.add("postponeuntil");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.asyncoperation");
        _x.postponeuntil = postponeuntil;
        return _x;
    }

    @Property(name="depth")
    @JsonIgnore
    public Optional<Integer> getDepth() {
        return Optional.ofNullable(depth);
    }

    public Asyncoperation withDepth(Integer depth) {
        Asyncoperation _x = _copy();
        _x.changedFields = changedFields.add("depth");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.asyncoperation");
        _x.depth = depth;
        return _x;
    }

    @Property(name="correlationid")
    @JsonIgnore
    public Optional<UUID> getCorrelationid() {
        return Optional.ofNullable(correlationid);
    }

    public Asyncoperation withCorrelationid(UUID correlationid) {
        Asyncoperation _x = _copy();
        _x.changedFields = changedFields.add("correlationid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.asyncoperation");
        _x.correlationid = correlationid;
        return _x;
    }

    @Property(name="_owningteam_value")
    @JsonIgnore
    public Optional<UUID> get_owningteam_value() {
        return Optional.ofNullable(_owningteam_value);
    }

    public Asyncoperation with_owningteam_value(UUID _owningteam_value) {
        Asyncoperation _x = _copy();
        _x.changedFields = changedFields.add("_owningteam_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.asyncoperation");
        _x._owningteam_value = _owningteam_value;
        return _x;
    }

    @Property(name="retainjobhistory")
    @JsonIgnore
    public Optional<Boolean> getRetainjobhistory() {
        return Optional.ofNullable(retainjobhistory);
    }

    public Asyncoperation withRetainjobhistory(Boolean retainjobhistory) {
        Asyncoperation _x = _copy();
        _x.changedFields = changedFields.add("retainjobhistory");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.asyncoperation");
        _x.retainjobhistory = retainjobhistory;
        return _x;
    }

    @Property(name="hostid")
    @JsonIgnore
    public Optional<String> getHostid() {
        return Optional.ofNullable(hostid);
    }

    public Asyncoperation withHostid(String hostid) {
        Checks.checkIsAscii(hostid);
        Asyncoperation _x = _copy();
        _x.changedFields = changedFields.add("hostid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.asyncoperation");
        _x.hostid = hostid;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Asyncoperation withCreatedon(OffsetDateTime createdon) {
        Asyncoperation _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.asyncoperation");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="completedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCompletedon() {
        return Optional.ofNullable(completedon);
    }

    public Asyncoperation withCompletedon(OffsetDateTime completedon) {
        Asyncoperation _x = _copy();
        _x.changedFields = changedFields.add("completedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.asyncoperation");
        _x.completedon = completedon;
        return _x;
    }

    @Property(name="retrycount")
    @JsonIgnore
    public Optional<Integer> getRetrycount() {
        return Optional.ofNullable(retrycount);
    }

    public Asyncoperation withRetrycount(Integer retrycount) {
        Asyncoperation _x = _copy();
        _x.changedFields = changedFields.add("retrycount");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.asyncoperation");
        _x.retrycount = retrycount;
        return _x;
    }

    @Property(name="timezoneruleversionnumber")
    @JsonIgnore
    public Optional<Integer> getTimezoneruleversionnumber() {
        return Optional.ofNullable(timezoneruleversionnumber);
    }

    public Asyncoperation withTimezoneruleversionnumber(Integer timezoneruleversionnumber) {
        Asyncoperation _x = _copy();
        _x.changedFields = changedFields.add("timezoneruleversionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.asyncoperation");
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        return _x;
    }

    @Property(name="subtype")
    @JsonIgnore
    public Optional<Integer> getSubtype() {
        return Optional.ofNullable(subtype);
    }

    public Asyncoperation withSubtype(Integer subtype) {
        Asyncoperation _x = _copy();
        _x.changedFields = changedFields.add("subtype");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.asyncoperation");
        _x.subtype = subtype;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<UUID> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Asyncoperation with_createdby_value(UUID _createdby_value) {
        Asyncoperation _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.asyncoperation");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="_owninguser_value")
    @JsonIgnore
    public Optional<UUID> get_owninguser_value() {
        return Optional.ofNullable(_owninguser_value);
    }

    public Asyncoperation with_owninguser_value(UUID _owninguser_value) {
        Asyncoperation _x = _copy();
        _x.changedFields = changedFields.add("_owninguser_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.asyncoperation");
        _x._owninguser_value = _owninguser_value;
        return _x;
    }

    @Property(name="datablobid_name")
    @JsonIgnore
    public Optional<String> getDatablobid_name() {
        return Optional.ofNullable(datablobid_name);
    }

    public Asyncoperation withDatablobid_name(String datablobid_name) {
        Checks.checkIsAscii(datablobid_name);
        Asyncoperation _x = _copy();
        _x.changedFields = changedFields.add("datablobid_name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.asyncoperation");
        _x.datablobid_name = datablobid_name;
        return _x;
    }

    @Property(name="dependencytoken")
    @JsonIgnore
    public Optional<String> getDependencytoken() {
        return Optional.ofNullable(dependencytoken);
    }

    public Asyncoperation withDependencytoken(String dependencytoken) {
        Checks.checkIsAscii(dependencytoken);
        Asyncoperation _x = _copy();
        _x.changedFields = changedFields.add("dependencytoken");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.asyncoperation");
        _x.dependencytoken = dependencytoken;
        return _x;
    }

    @Property(name="messagename")
    @JsonIgnore
    public Optional<String> getMessagename() {
        return Optional.ofNullable(messagename);
    }

    public Asyncoperation withMessagename(String messagename) {
        Checks.checkIsAscii(messagename);
        Asyncoperation _x = _copy();
        _x.changedFields = changedFields.add("messagename");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.asyncoperation");
        _x.messagename = messagename;
        return _x;
    }

    @Property(name="_ownerid_value")
    @JsonIgnore
    public Optional<UUID> get_ownerid_value() {
        return Optional.ofNullable(_ownerid_value);
    }

    public Asyncoperation with_ownerid_value(UUID _ownerid_value) {
        Asyncoperation _x = _copy();
        _x.changedFields = changedFields.add("_ownerid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.asyncoperation");
        _x._ownerid_value = _ownerid_value;
        return _x;
    }

    @Property(name="utcconversiontimezonecode")
    @JsonIgnore
    public Optional<Integer> getUtcconversiontimezonecode() {
        return Optional.ofNullable(utcconversiontimezonecode);
    }

    public Asyncoperation withUtcconversiontimezonecode(Integer utcconversiontimezonecode) {
        Asyncoperation _x = _copy();
        _x.changedFields = changedFields.add("utcconversiontimezonecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.asyncoperation");
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        return _x;
    }

    @Property(name="statuscode")
    @JsonIgnore
    public Optional<Integer> getStatuscode() {
        return Optional.ofNullable(statuscode);
    }

    public Asyncoperation withStatuscode(Integer statuscode) {
        Asyncoperation _x = _copy();
        _x.changedFields = changedFields.add("statuscode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.asyncoperation");
        _x.statuscode = statuscode;
        return _x;
    }

    @Property(name="rootexecutioncontext")
    @JsonIgnore
    public Optional<String> getRootexecutioncontext() {
        return Optional.ofNullable(rootexecutioncontext);
    }

    public Asyncoperation withRootexecutioncontext(String rootexecutioncontext) {
        Checks.checkIsAscii(rootexecutioncontext);
        Asyncoperation _x = _copy();
        _x.changedFields = changedFields.add("rootexecutioncontext");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.asyncoperation");
        _x.rootexecutioncontext = rootexecutioncontext;
        return _x;
    }

    @Property(name="operationtype")
    @JsonIgnore
    public Optional<Integer> getOperationtype() {
        return Optional.ofNullable(operationtype);
    }

    public Asyncoperation withOperationtype(Integer operationtype) {
        Asyncoperation _x = _copy();
        _x.changedFields = changedFields.add("operationtype");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.asyncoperation");
        _x.operationtype = operationtype;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public Asyncoperation withName(String name) {
        Checks.checkIsAscii(name);
        Asyncoperation _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.asyncoperation");
        _x.name = name;
        return _x;
    }

    @Property(name="data")
    @JsonIgnore
    public Optional<String> getData() {
        return Optional.ofNullable(data);
    }

    public Asyncoperation withData(String data) {
        Checks.checkIsAscii(data);
        Asyncoperation _x = _copy();
        _x.changedFields = changedFields.add("data");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.asyncoperation");
        _x.data = data;
        return _x;
    }

    @Property(name="sequence")
    @JsonIgnore
    public Optional<Long> getSequence() {
        return Optional.ofNullable(sequence);
    }

    public Asyncoperation withSequence(Long sequence) {
        Asyncoperation _x = _copy();
        _x.changedFields = changedFields.add("sequence");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.asyncoperation");
        _x.sequence = sequence;
        return _x;
    }

    @Property(name="asyncoperationid")
    @JsonIgnore
    public Optional<UUID> getAsyncoperationid() {
        return Optional.ofNullable(asyncoperationid);
    }

    public Asyncoperation withAsyncoperationid(UUID asyncoperationid) {
        Asyncoperation _x = _copy();
        _x.changedFields = changedFields.add("asyncoperationid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.asyncoperation");
        _x.asyncoperationid = asyncoperationid;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Asyncoperation with_createdonbehalfby_value(UUID _createdonbehalfby_value) {
        Asyncoperation _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.asyncoperation");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="executiontimespan")
    @JsonIgnore
    public Optional<Double> getExecutiontimespan() {
        return Optional.ofNullable(executiontimespan);
    }

    public Asyncoperation withExecutiontimespan(Double executiontimespan) {
        Asyncoperation _x = _copy();
        _x.changedFields = changedFields.add("executiontimespan");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.asyncoperation");
        _x.executiontimespan = executiontimespan;
        return _x;
    }

    @Property(name="iswaitingforevent")
    @JsonIgnore
    public Optional<Boolean> getIswaitingforevent() {
        return Optional.ofNullable(iswaitingforevent);
    }

    public Asyncoperation withIswaitingforevent(Boolean iswaitingforevent) {
        Asyncoperation _x = _copy();
        _x.changedFields = changedFields.add("iswaitingforevent");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.asyncoperation");
        _x.iswaitingforevent = iswaitingforevent;
        return _x;
    }

    @Property(name="workload")
    @JsonIgnore
    public Optional<String> getWorkload() {
        return Optional.ofNullable(workload);
    }

    public Asyncoperation withWorkload(String workload) {
        Checks.checkIsAscii(workload);
        Asyncoperation _x = _copy();
        _x.changedFields = changedFields.add("workload");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.asyncoperation");
        _x.workload = workload;
        return _x;
    }

    public Asyncoperation withUnmappedField(String name, String value) {
        Asyncoperation _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="regardingobjectid_theme")
    @JsonIgnore
    public ThemeRequest getRegardingobjectid_theme() {
        return new ThemeRequest(contextPath.addSegment("regardingobjectid_theme"), RequestHelper.getValue(unmappedFields, "regardingobjectid_theme"));
    }

    @NavigationProperty(name="regardingobjectid_usermapping")
    @JsonIgnore
    public UsermappingRequest getRegardingobjectid_usermapping() {
        return new UsermappingRequest(contextPath.addSegment("regardingobjectid_usermapping"), RequestHelper.getValue(unmappedFields, "regardingobjectid_usermapping"));
    }

    @NavigationProperty(name="regardingobjectid_new_interactionforemail")
    @JsonIgnore
    public InteractionforemailRequest getRegardingobjectid_new_interactionforemail() {
        return new InteractionforemailRequest(contextPath.addSegment("regardingobjectid_new_interactionforemail"), RequestHelper.getValue(unmappedFields, "regardingobjectid_new_interactionforemail"));
    }

    @NavigationProperty(name="regardingobjectid_knowledgearticle")
    @JsonIgnore
    public KnowledgearticleRequest getRegardingobjectid_knowledgearticle() {
        return new KnowledgearticleRequest(contextPath.addSegment("regardingobjectid_knowledgearticle"), RequestHelper.getValue(unmappedFields, "regardingobjectid_knowledgearticle"));
    }

    @NavigationProperty(name="regardingobjectid_post")
    @JsonIgnore
    public PostRequest getRegardingobjectid_post() {
        return new PostRequest(contextPath.addSegment("regardingobjectid_post"), RequestHelper.getValue(unmappedFields, "regardingobjectid_post"));
    }

    @NavigationProperty(name="regardingobjectid_position")
    @JsonIgnore
    public PositionRequest getRegardingobjectid_position() {
        return new PositionRequest(contextPath.addSegment("regardingobjectid_position"), RequestHelper.getValue(unmappedFields, "regardingobjectid_position"));
    }

    @NavigationProperty(name="regardingobjectid_similarityrule")
    @JsonIgnore
    public SimilarityruleRequest getRegardingobjectid_similarityrule() {
        return new SimilarityruleRequest(contextPath.addSegment("regardingobjectid_similarityrule"), RequestHelper.getValue(unmappedFields, "regardingobjectid_similarityrule"));
    }

    @NavigationProperty(name="regardingobjectid_knowledgebaserecord")
    @JsonIgnore
    public KnowledgebaserecordRequest getRegardingobjectid_knowledgebaserecord() {
        return new KnowledgebaserecordRequest(contextPath.addSegment("regardingobjectid_knowledgebaserecord"), RequestHelper.getValue(unmappedFields, "regardingobjectid_knowledgebaserecord"));
    }

    @NavigationProperty(name="regardingobjectid_report")
    @JsonIgnore
    public ReportRequest getRegardingobjectid_report() {
        return new ReportRequest(contextPath.addSegment("regardingobjectid_report"), RequestHelper.getValue(unmappedFields, "regardingobjectid_report"));
    }

    @NavigationProperty(name="AsyncOperation_Emails")
    @JsonIgnore
    public EmailCollectionRequest getAsyncOperation_Emails() {
        return new EmailCollectionRequest(
                        contextPath.addSegment("AsyncOperation_Emails"), RequestHelper.getValue(unmappedFields, "AsyncOperation_Emails"));
    }

    @NavigationProperty(name="regardingobjectid_recurringappointmentmaster")
    @JsonIgnore
    public RecurringappointmentmasterRequest getRegardingobjectid_recurringappointmentmaster() {
        return new RecurringappointmentmasterRequest(contextPath.addSegment("regardingobjectid_recurringappointmentmaster"), RequestHelper.getValue(unmappedFields, "regardingobjectid_recurringappointmentmaster"));
    }

    @NavigationProperty(name="regardingobjectid_privilege")
    @JsonIgnore
    public PrivilegeRequest getRegardingobjectid_privilege() {
        return new PrivilegeRequest(contextPath.addSegment("regardingobjectid_privilege"), RequestHelper.getValue(unmappedFields, "regardingobjectid_privilege"));
    }

    @NavigationProperty(name="AsyncOperation_BulkDeleteOperation")
    @JsonIgnore
    public BulkdeleteoperationCollectionRequest getAsyncOperation_BulkDeleteOperation() {
        return new BulkdeleteoperationCollectionRequest(
                        contextPath.addSegment("AsyncOperation_BulkDeleteOperation"), RequestHelper.getValue(unmappedFields, "AsyncOperation_BulkDeleteOperation"));
    }

    @NavigationProperty(name="regardingobjectid_goalrollupquery")
    @JsonIgnore
    public GoalrollupqueryRequest getRegardingobjectid_goalrollupquery() {
        return new GoalrollupqueryRequest(contextPath.addSegment("regardingobjectid_goalrollupquery"), RequestHelper.getValue(unmappedFields, "regardingobjectid_goalrollupquery"));
    }

    @NavigationProperty(name="AsyncOperation_SocialActivities")
    @JsonIgnore
    public SocialactivityCollectionRequest getAsyncOperation_SocialActivities() {
        return new SocialactivityCollectionRequest(
                        contextPath.addSegment("AsyncOperation_SocialActivities"), RequestHelper.getValue(unmappedFields, "AsyncOperation_SocialActivities"));
    }

    @NavigationProperty(name="regardingobjectid_postfollow")
    @JsonIgnore
    public PostfollowRequest getRegardingobjectid_postfollow() {
        return new PostfollowRequest(contextPath.addSegment("regardingobjectid_postfollow"), RequestHelper.getValue(unmappedFields, "regardingobjectid_postfollow"));
    }

    @NavigationProperty(name="regardingobjectid_businessunit")
    @JsonIgnore
    public BusinessunitRequest getRegardingobjectid_businessunit() {
        return new BusinessunitRequest(contextPath.addSegment("regardingobjectid_businessunit"), RequestHelper.getValue(unmappedFields, "regardingobjectid_businessunit"));
    }

    @NavigationProperty(name="regardingobjectid_annualfiscalcalendar")
    @JsonIgnore
    public AnnualfiscalcalendarRequest getRegardingobjectid_annualfiscalcalendar() {
        return new AnnualfiscalcalendarRequest(contextPath.addSegment("regardingobjectid_annualfiscalcalendar"), RequestHelper.getValue(unmappedFields, "regardingobjectid_annualfiscalcalendar"));
    }

    @NavigationProperty(name="workflowactivationid")
    @JsonIgnore
    public WorkflowRequest getWorkflowactivationid() {
        return new WorkflowRequest(contextPath.addSegment("workflowactivationid"), RequestHelper.getValue(unmappedFields, "workflowactivationid"));
    }

    @NavigationProperty(name="regardingobjectid_monthlyfiscalcalendar")
    @JsonIgnore
    public MonthlyfiscalcalendarRequest getRegardingobjectid_monthlyfiscalcalendar() {
        return new MonthlyfiscalcalendarRequest(contextPath.addSegment("regardingobjectid_monthlyfiscalcalendar"), RequestHelper.getValue(unmappedFields, "regardingobjectid_monthlyfiscalcalendar"));
    }

    @NavigationProperty(name="regardingobjectid_mailbox")
    @JsonIgnore
    public MailboxRequest getRegardingobjectid_mailbox() {
        return new MailboxRequest(contextPath.addSegment("regardingobjectid_mailbox"), RequestHelper.getValue(unmappedFields, "regardingobjectid_mailbox"));
    }

    @NavigationProperty(name="regardingobjectid_importfile")
    @JsonIgnore
    public ImportfileRequest getRegardingobjectid_importfile() {
        return new ImportfileRequest(contextPath.addSegment("regardingobjectid_importfile"), RequestHelper.getValue(unmappedFields, "regardingobjectid_importfile"));
    }

    @NavigationProperty(name="lk_workflowlog_asyncoperation_childworkflow")
    @JsonIgnore
    public WorkflowlogCollectionRequest getLk_workflowlog_asyncoperation_childworkflow() {
        return new WorkflowlogCollectionRequest(
                        contextPath.addSegment("lk_workflowlog_asyncoperation_childworkflow"), RequestHelper.getValue(unmappedFields, "lk_workflowlog_asyncoperation_childworkflow"));
    }

    @NavigationProperty(name="regardingobjectid_importdata")
    @JsonIgnore
    public ImportdataRequest getRegardingobjectid_importdata() {
        return new ImportdataRequest(contextPath.addSegment("regardingobjectid_importdata"), RequestHelper.getValue(unmappedFields, "regardingobjectid_importdata"));
    }

    @NavigationProperty(name="regardingobjectid_email")
    @JsonIgnore
    public EmailRequest getRegardingobjectid_email() {
        return new EmailRequest(contextPath.addSegment("regardingobjectid_email"), RequestHelper.getValue(unmappedFields, "regardingobjectid_email"));
    }

    @NavigationProperty(name="regardingobjectid_team")
    @JsonIgnore
    public TeamRequest getRegardingobjectid_team() {
        return new TeamRequest(contextPath.addSegment("regardingobjectid_team"), RequestHelper.getValue(unmappedFields, "regardingobjectid_team"));
    }

    @NavigationProperty(name="AsyncOperation_DuplicateBaseRecord")
    @JsonIgnore
    public DuplicaterecordCollectionRequest getAsyncOperation_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("AsyncOperation_DuplicateBaseRecord"), RequestHelper.getValue(unmappedFields, "AsyncOperation_DuplicateBaseRecord"));
    }

    @NavigationProperty(name="regardingobjectid_kbarticletemplate")
    @JsonIgnore
    public KbarticletemplateRequest getRegardingobjectid_kbarticletemplate() {
        return new KbarticletemplateRequest(contextPath.addSegment("regardingobjectid_kbarticletemplate"), RequestHelper.getValue(unmappedFields, "regardingobjectid_kbarticletemplate"));
    }

    @NavigationProperty(name="regardingobjectid_emailserverprofile")
    @JsonIgnore
    public EmailserverprofileRequest getRegardingobjectid_emailserverprofile() {
        return new EmailserverprofileRequest(contextPath.addSegment("regardingobjectid_emailserverprofile"), RequestHelper.getValue(unmappedFields, "regardingobjectid_emailserverprofile"));
    }

    @NavigationProperty(name="regardingobjectid_userform")
    @JsonIgnore
    public UserformRequest getRegardingobjectid_userform() {
        return new UserformRequest(contextPath.addSegment("regardingobjectid_userform"), RequestHelper.getValue(unmappedFields, "regardingobjectid_userform"));
    }

    @NavigationProperty(name="regardingobjectid_transactioncurrency")
    @JsonIgnore
    public TransactioncurrencyRequest getRegardingobjectid_transactioncurrency() {
        return new TransactioncurrencyRequest(contextPath.addSegment("regardingobjectid_transactioncurrency"), RequestHelper.getValue(unmappedFields, "regardingobjectid_transactioncurrency"));
    }

    @NavigationProperty(name="regardingobjectid_socialprofile")
    @JsonIgnore
    public SocialprofileRequest getRegardingobjectid_socialprofile() {
        return new SocialprofileRequest(contextPath.addSegment("regardingobjectid_socialprofile"), RequestHelper.getValue(unmappedFields, "regardingobjectid_socialprofile"));
    }

    @NavigationProperty(name="regardingobjectid_importmap")
    @JsonIgnore
    public ImportmapRequest getRegardingobjectid_importmap() {
        return new ImportmapRequest(contextPath.addSegment("regardingobjectid_importmap"), RequestHelper.getValue(unmappedFields, "regardingobjectid_importmap"));
    }

    @NavigationProperty(name="regardingobjectid_account")
    @JsonIgnore
    public AccountRequest getRegardingobjectid_account() {
        return new AccountRequest(contextPath.addSegment("regardingobjectid_account"), RequestHelper.getValue(unmappedFields, "regardingobjectid_account"));
    }

    @NavigationProperty(name="regardingobjectid_phonecall")
    @JsonIgnore
    public PhonecallRequest getRegardingobjectid_phonecall() {
        return new PhonecallRequest(contextPath.addSegment("regardingobjectid_phonecall"), RequestHelper.getValue(unmappedFields, "regardingobjectid_phonecall"));
    }

    @NavigationProperty(name="regardingobjectid_socialactivity")
    @JsonIgnore
    public SocialactivityRequest getRegardingobjectid_socialactivity() {
        return new SocialactivityRequest(contextPath.addSegment("regardingobjectid_socialactivity"), RequestHelper.getValue(unmappedFields, "regardingobjectid_socialactivity"));
    }

    @NavigationProperty(name="regardingobjectid_queueitem")
    @JsonIgnore
    public QueueitemRequest getRegardingobjectid_queueitem() {
        return new QueueitemRequest(contextPath.addSegment("regardingobjectid_queueitem"), RequestHelper.getValue(unmappedFields, "regardingobjectid_queueitem"));
    }

    @NavigationProperty(name="regardingobjectid_quarterlyfiscalcalendar")
    @JsonIgnore
    public QuarterlyfiscalcalendarRequest getRegardingobjectid_quarterlyfiscalcalendar() {
        return new QuarterlyfiscalcalendarRequest(contextPath.addSegment("regardingobjectid_quarterlyfiscalcalendar"), RequestHelper.getValue(unmappedFields, "regardingobjectid_quarterlyfiscalcalendar"));
    }

    @NavigationProperty(name="regardingobjectid_queue")
    @JsonIgnore
    public QueueRequest getRegardingobjectid_queue() {
        return new QueueRequest(contextPath.addSegment("regardingobjectid_queue"), RequestHelper.getValue(unmappedFields, "regardingobjectid_queue"));
    }

    @NavigationProperty(name="regardingobjectid_template")
    @JsonIgnore
    public TemplateRequest getRegardingobjectid_template() {
        return new TemplateRequest(contextPath.addSegment("regardingobjectid_template"), RequestHelper.getValue(unmappedFields, "regardingobjectid_template"));
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="regardingobjectid_kbarticle")
    @JsonIgnore
    public KbarticleRequest getRegardingobjectid_kbarticle() {
        return new KbarticleRequest(contextPath.addSegment("regardingobjectid_kbarticle"), RequestHelper.getValue(unmappedFields, "regardingobjectid_kbarticle"));
    }

    @NavigationProperty(name="regardingobjectid_systemform")
    @JsonIgnore
    public SystemformRequest getRegardingobjectid_systemform() {
        return new SystemformRequest(contextPath.addSegment("regardingobjectid_systemform"), RequestHelper.getValue(unmappedFields, "regardingobjectid_systemform"));
    }

    @NavigationProperty(name="regardingobjectid_displaystring")
    @JsonIgnore
    public DisplaystringRequest getRegardingobjectid_displaystring() {
        return new DisplaystringRequest(contextPath.addSegment("regardingobjectid_displaystring"), RequestHelper.getValue(unmappedFields, "regardingobjectid_displaystring"));
    }

    @NavigationProperty(name="owningbusinessunit")
    @JsonIgnore
    public BusinessunitRequest getOwningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), RequestHelper.getValue(unmappedFields, "owningbusinessunit"));
    }

    @NavigationProperty(name="regardingobjectid_organization")
    @JsonIgnore
    public OrganizationRequest getRegardingobjectid_organization() {
        return new OrganizationRequest(contextPath.addSegment("regardingobjectid_organization"), RequestHelper.getValue(unmappedFields, "regardingobjectid_organization"));
    }

    @NavigationProperty(name="regardingobjectid_connectionrole")
    @JsonIgnore
    public ConnectionroleRequest getRegardingobjectid_connectionrole() {
        return new ConnectionroleRequest(contextPath.addSegment("regardingobjectid_connectionrole"), RequestHelper.getValue(unmappedFields, "regardingobjectid_connectionrole"));
    }

    @NavigationProperty(name="regardingobjectid_kbarticlecomment")
    @JsonIgnore
    public KbarticlecommentRequest getRegardingobjectid_kbarticlecomment() {
        return new KbarticlecommentRequest(contextPath.addSegment("regardingobjectid_kbarticlecomment"), RequestHelper.getValue(unmappedFields, "regardingobjectid_kbarticlecomment"));
    }

    @NavigationProperty(name="regardingobjectid_appointment")
    @JsonIgnore
    public AppointmentRequest getRegardingobjectid_appointment() {
        return new AppointmentRequest(contextPath.addSegment("regardingobjectid_appointment"), RequestHelper.getValue(unmappedFields, "regardingobjectid_appointment"));
    }

    @NavigationProperty(name="regardingobjectid_systemuser")
    @JsonIgnore
    public SystemuserRequest getRegardingobjectid_systemuser() {
        return new SystemuserRequest(contextPath.addSegment("regardingobjectid_systemuser"), RequestHelper.getValue(unmappedFields, "regardingobjectid_systemuser"));
    }

    @NavigationProperty(name="regardingobjectid_mailmergetemplate")
    @JsonIgnore
    public MailmergetemplateRequest getRegardingobjectid_mailmergetemplate() {
        return new MailmergetemplateRequest(contextPath.addSegment("regardingobjectid_mailmergetemplate"), RequestHelper.getValue(unmappedFields, "regardingobjectid_mailmergetemplate"));
    }

    @NavigationProperty(name="AsyncOperation_MailboxTrackingFolder")
    @JsonIgnore
    public MailboxtrackingfolderCollectionRequest getAsyncOperation_MailboxTrackingFolder() {
        return new MailboxtrackingfolderCollectionRequest(
                        contextPath.addSegment("AsyncOperation_MailboxTrackingFolder"), RequestHelper.getValue(unmappedFields, "AsyncOperation_MailboxTrackingFolder"));
    }

    @NavigationProperty(name="regardingobjectid_calendar")
    @JsonIgnore
    public CalendarRequest getRegardingobjectid_calendar() {
        return new CalendarRequest(contextPath.addSegment("regardingobjectid_calendar"), RequestHelper.getValue(unmappedFields, "regardingobjectid_calendar"));
    }

    @NavigationProperty(name="regardingobjectid_rollupfield")
    @JsonIgnore
    public RollupfieldRequest getRegardingobjectid_rollupfield() {
        return new RollupfieldRequest(contextPath.addSegment("regardingobjectid_rollupfield"), RequestHelper.getValue(unmappedFields, "regardingobjectid_rollupfield"));
    }

    @NavigationProperty(name="regardingobjectid_connection")
    @JsonIgnore
    public ConnectionRequest getRegardingobjectid_connection() {
        return new ConnectionRequest(contextPath.addSegment("regardingobjectid_connection"), RequestHelper.getValue(unmappedFields, "regardingobjectid_connection"));
    }

    @NavigationProperty(name="regardingobjectid_metric")
    @JsonIgnore
    public MetricRequest getRegardingobjectid_metric() {
        return new MetricRequest(contextPath.addSegment("regardingobjectid_metric"), RequestHelper.getValue(unmappedFields, "regardingobjectid_metric"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="regardingobjectid_role")
    @JsonIgnore
    public RoleRequest getRegardingobjectid_role() {
        return new RoleRequest(contextPath.addSegment("regardingobjectid_role"), RequestHelper.getValue(unmappedFields, "regardingobjectid_role"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="ownerid")
    @JsonIgnore
    public PrincipalRequest getOwnerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), RequestHelper.getValue(unmappedFields, "ownerid"));
    }

    @NavigationProperty(name="regardingobjectid_subject")
    @JsonIgnore
    public SubjectRequest getRegardingobjectid_subject() {
        return new SubjectRequest(contextPath.addSegment("regardingobjectid_subject"), RequestHelper.getValue(unmappedFields, "regardingobjectid_subject"));
    }

    @NavigationProperty(name="regardingobjectid_savedquery")
    @JsonIgnore
    public SavedqueryRequest getRegardingobjectid_savedquery() {
        return new SavedqueryRequest(contextPath.addSegment("regardingobjectid_savedquery"), RequestHelper.getValue(unmappedFields, "regardingobjectid_savedquery"));
    }

    @NavigationProperty(name="regardingobjectid_sla")
    @JsonIgnore
    public SlaRequest getRegardingobjectid_sla() {
        return new SlaRequest(contextPath.addSegment("regardingobjectid_sla"), RequestHelper.getValue(unmappedFields, "regardingobjectid_sla"));
    }

    @NavigationProperty(name="regardingobjectid_activitymimeattachment")
    @JsonIgnore
    public ActivitymimeattachmentRequest getRegardingobjectid_activitymimeattachment() {
        return new ActivitymimeattachmentRequest(contextPath.addSegment("regardingobjectid_activitymimeattachment"), RequestHelper.getValue(unmappedFields, "regardingobjectid_activitymimeattachment"));
    }

    @NavigationProperty(name="regardingobjectid_letter")
    @JsonIgnore
    public LetterRequest getRegardingobjectid_letter() {
        return new LetterRequest(contextPath.addSegment("regardingobjectid_letter"), RequestHelper.getValue(unmappedFields, "regardingobjectid_letter"));
    }

    @NavigationProperty(name="owningteam")
    @JsonIgnore
    public TeamRequest getOwningteam() {
        return new TeamRequest(contextPath.addSegment("owningteam"), RequestHelper.getValue(unmappedFields, "owningteam"));
    }

    @NavigationProperty(name="regardingobjectid_annotation")
    @JsonIgnore
    public AnnotationRequest getRegardingobjectid_annotation() {
        return new AnnotationRequest(contextPath.addSegment("regardingobjectid_annotation"), RequestHelper.getValue(unmappedFields, "regardingobjectid_annotation"));
    }

    @NavigationProperty(name="regardingobjectid_userquery")
    @JsonIgnore
    public UserqueryRequest getRegardingobjectid_userquery() {
        return new UserqueryRequest(contextPath.addSegment("regardingobjectid_userquery"), RequestHelper.getValue(unmappedFields, "regardingobjectid_userquery"));
    }

    @NavigationProperty(name="lk_workflowlog_asyncoperations")
    @JsonIgnore
    public WorkflowlogCollectionRequest getLk_workflowlog_asyncoperations() {
        return new WorkflowlogCollectionRequest(
                        contextPath.addSegment("lk_workflowlog_asyncoperations"), RequestHelper.getValue(unmappedFields, "lk_workflowlog_asyncoperations"));
    }

    @NavigationProperty(name="regardingobjectid_task")
    @JsonIgnore
    public TaskRequest getRegardingobjectid_task() {
        return new TaskRequest(contextPath.addSegment("regardingobjectid_task"), RequestHelper.getValue(unmappedFields, "regardingobjectid_task"));
    }

    @NavigationProperty(name="regardingobjectid_contact")
    @JsonIgnore
    public ContactRequest getRegardingobjectid_contact() {
        return new ContactRequest(contextPath.addSegment("regardingobjectid_contact"), RequestHelper.getValue(unmappedFields, "regardingobjectid_contact"));
    }

    @NavigationProperty(name="regardingobjectid_sharepointsite")
    @JsonIgnore
    public SharepointsiteRequest getRegardingobjectid_sharepointsite() {
        return new SharepointsiteRequest(contextPath.addSegment("regardingobjectid_sharepointsite"), RequestHelper.getValue(unmappedFields, "regardingobjectid_sharepointsite"));
    }

    @NavigationProperty(name="owningextensionid")
    @JsonIgnore
    public SdkmessageprocessingstepRequest getOwningextensionid() {
        return new SdkmessageprocessingstepRequest(contextPath.addSegment("owningextensionid"), RequestHelper.getValue(unmappedFields, "owningextensionid"));
    }

    @NavigationProperty(name="regardingobjectid_businessunitnewsarticle")
    @JsonIgnore
    public BusinessunitnewsarticleRequest getRegardingobjectid_businessunitnewsarticle() {
        return new BusinessunitnewsarticleRequest(contextPath.addSegment("regardingobjectid_businessunitnewsarticle"), RequestHelper.getValue(unmappedFields, "regardingobjectid_businessunitnewsarticle"));
    }

    @NavigationProperty(name="regardingobjectid_goal")
    @JsonIgnore
    public GoalRequest getRegardingobjectid_goal() {
        return new GoalRequest(contextPath.addSegment("regardingobjectid_goal"), RequestHelper.getValue(unmappedFields, "regardingobjectid_goal"));
    }

    @NavigationProperty(name="regardingobjectid_importlog")
    @JsonIgnore
    public ImportlogRequest getRegardingobjectid_importlog() {
        return new ImportlogRequest(contextPath.addSegment("regardingobjectid_importlog"), RequestHelper.getValue(unmappedFields, "regardingobjectid_importlog"));
    }

    @NavigationProperty(name="regardingobjectid_semiannualfiscalcalendar")
    @JsonIgnore
    public SemiannualfiscalcalendarRequest getRegardingobjectid_semiannualfiscalcalendar() {
        return new SemiannualfiscalcalendarRequest(contextPath.addSegment("regardingobjectid_semiannualfiscalcalendar"), RequestHelper.getValue(unmappedFields, "regardingobjectid_semiannualfiscalcalendar"));
    }

    @NavigationProperty(name="regardingobjectid_fixedmonthlyfiscalcalendar")
    @JsonIgnore
    public FixedmonthlyfiscalcalendarRequest getRegardingobjectid_fixedmonthlyfiscalcalendar() {
        return new FixedmonthlyfiscalcalendarRequest(contextPath.addSegment("regardingobjectid_fixedmonthlyfiscalcalendar"), RequestHelper.getValue(unmappedFields, "regardingobjectid_fixedmonthlyfiscalcalendar"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="regardingobjectid_customeraddress")
    @JsonIgnore
    public CustomeraddressRequest getRegardingobjectid_customeraddress() {
        return new CustomeraddressRequest(contextPath.addSegment("regardingobjectid_customeraddress"), RequestHelper.getValue(unmappedFields, "regardingobjectid_customeraddress"));
    }

    @NavigationProperty(name="regardingobjectid_fax")
    @JsonIgnore
    public FaxRequest getRegardingobjectid_fax() {
        return new FaxRequest(contextPath.addSegment("regardingobjectid_fax"), RequestHelper.getValue(unmappedFields, "regardingobjectid_fax"));
    }

    @NavigationProperty(name="regardingobjectid_sharepointdocumentlocation")
    @JsonIgnore
    public SharepointdocumentlocationRequest getRegardingobjectid_sharepointdocumentlocation() {
        return new SharepointdocumentlocationRequest(contextPath.addSegment("regardingobjectid_sharepointdocumentlocation"), RequestHelper.getValue(unmappedFields, "regardingobjectid_sharepointdocumentlocation"));
    }

    @NavigationProperty(name="regardingobjectid_activitypointer")
    @JsonIgnore
    public ActivitypointerRequest getRegardingobjectid_activitypointer() {
        return new ActivitypointerRequest(contextPath.addSegment("regardingobjectid_activitypointer"), RequestHelper.getValue(unmappedFields, "regardingobjectid_activitypointer"));
    }

    @NavigationProperty(name="owninguser")
    @JsonIgnore
    public SystemuserRequest getOwninguser() {
        return new SystemuserRequest(contextPath.addSegment("owninguser"), RequestHelper.getValue(unmappedFields, "owninguser"));
    }

    @NavigationProperty(name="regardingobjectid_import")
    @JsonIgnore
    public ImportRequest getRegardingobjectid_import() {
        return new ImportRequest(contextPath.addSegment("regardingobjectid_import"), RequestHelper.getValue(unmappedFields, "regardingobjectid_import"));
    }

    @NavigationProperty(name="regardingobjectid_solutioncomponentattributeconfiguration")
    @JsonIgnore
    public SolutioncomponentattributeconfigurationRequest getRegardingobjectid_solutioncomponentattributeconfiguration() {
        return new SolutioncomponentattributeconfigurationRequest(contextPath.addSegment("regardingobjectid_solutioncomponentattributeconfiguration"), RequestHelper.getValue(unmappedFields, "regardingobjectid_solutioncomponentattributeconfiguration"));
    }

    @NavigationProperty(name="regardingobjectid_solutioncomponentconfiguration")
    @JsonIgnore
    public SolutioncomponentconfigurationRequest getRegardingobjectid_solutioncomponentconfiguration() {
        return new SolutioncomponentconfigurationRequest(contextPath.addSegment("regardingobjectid_solutioncomponentconfiguration"), RequestHelper.getValue(unmappedFields, "regardingobjectid_solutioncomponentconfiguration"));
    }

    @NavigationProperty(name="regardingobjectid_solutioncomponentrelationshipconfiguration")
    @JsonIgnore
    public SolutioncomponentrelationshipconfigurationRequest getRegardingobjectid_solutioncomponentrelationshipconfiguration() {
        return new SolutioncomponentrelationshipconfigurationRequest(contextPath.addSegment("regardingobjectid_solutioncomponentrelationshipconfiguration"), RequestHelper.getValue(unmappedFields, "regardingobjectid_solutioncomponentrelationshipconfiguration"));
    }

    @NavigationProperty(name="regardingobjectid_stagesolutionupload")
    @JsonIgnore
    public StagesolutionuploadRequest getRegardingobjectid_stagesolutionupload() {
        return new StagesolutionuploadRequest(contextPath.addSegment("regardingobjectid_stagesolutionupload"), RequestHelper.getValue(unmappedFields, "regardingobjectid_stagesolutionupload"));
    }

    @NavigationProperty(name="regardingobjectid_exportsolutionupload")
    @JsonIgnore
    public ExportsolutionuploadRequest getRegardingobjectid_exportsolutionupload() {
        return new ExportsolutionuploadRequest(contextPath.addSegment("regardingobjectid_exportsolutionupload"), RequestHelper.getValue(unmappedFields, "regardingobjectid_exportsolutionupload"));
    }

    @NavigationProperty(name="regardingobjectid_attributeimageconfig")
    @JsonIgnore
    public AttributeimageconfigRequest getRegardingobjectid_attributeimageconfig() {
        return new AttributeimageconfigRequest(contextPath.addSegment("regardingobjectid_attributeimageconfig"), RequestHelper.getValue(unmappedFields, "regardingobjectid_attributeimageconfig"));
    }

    @NavigationProperty(name="regardingobjectid_entityimageconfig")
    @JsonIgnore
    public EntityimageconfigRequest getRegardingobjectid_entityimageconfig() {
        return new EntityimageconfigRequest(contextPath.addSegment("regardingobjectid_entityimageconfig"), RequestHelper.getValue(unmappedFields, "regardingobjectid_entityimageconfig"));
    }

    @NavigationProperty(name="regardingobjectid_entityanalyticsconfig")
    @JsonIgnore
    public EntityanalyticsconfigRequest getRegardingobjectid_entityanalyticsconfig() {
        return new EntityanalyticsconfigRequest(contextPath.addSegment("regardingobjectid_entityanalyticsconfig"), RequestHelper.getValue(unmappedFields, "regardingobjectid_entityanalyticsconfig"));
    }

    @NavigationProperty(name="regardingobjectid_relationshipattribute")
    @JsonIgnore
    public RelationshipattributeRequest getRegardingobjectid_relationshipattribute() {
        return new RelationshipattributeRequest(contextPath.addSegment("regardingobjectid_relationshipattribute"), RequestHelper.getValue(unmappedFields, "regardingobjectid_relationshipattribute"));
    }

    @NavigationProperty(name="regardingobjectid_datalakeworkspace")
    @JsonIgnore
    public DatalakeworkspaceRequest getRegardingobjectid_datalakeworkspace() {
        return new DatalakeworkspaceRequest(contextPath.addSegment("regardingobjectid_datalakeworkspace"), RequestHelper.getValue(unmappedFields, "regardingobjectid_datalakeworkspace"));
    }

    @NavigationProperty(name="regardingobjectid_datalakeworkspacepermission")
    @JsonIgnore
    public DatalakeworkspacepermissionRequest getRegardingobjectid_datalakeworkspacepermission() {
        return new DatalakeworkspacepermissionRequest(contextPath.addSegment("regardingobjectid_datalakeworkspacepermission"), RequestHelper.getValue(unmappedFields, "regardingobjectid_datalakeworkspacepermission"));
    }

    @NavigationProperty(name="regardingobjectid_applicationuser")
    @JsonIgnore
    public ApplicationuserRequest getRegardingobjectid_applicationuser() {
        return new ApplicationuserRequest(contextPath.addSegment("regardingobjectid_applicationuser"), RequestHelper.getValue(unmappedFields, "regardingobjectid_applicationuser"));
    }

    @NavigationProperty(name="asyncoperation_FileAttachments")
    @JsonIgnore
    public FileattachmentCollectionRequest getAsyncoperation_FileAttachments() {
        return new FileattachmentCollectionRequest(
                        contextPath.addSegment("asyncoperation_FileAttachments"), RequestHelper.getValue(unmappedFields, "asyncoperation_FileAttachments"));
    }

    @NavigationProperty(name="datablobid")
    @JsonIgnore
    public FileattachmentRequest getDatablobid() {
        return new FileattachmentRequest(contextPath.addSegment("datablobid"), RequestHelper.getValue(unmappedFields, "datablobid"));
    }

    @NavigationProperty(name="regardingobjectid_serviceplan")
    @JsonIgnore
    public ServiceplanRequest getRegardingobjectid_serviceplan() {
        return new ServiceplanRequest(contextPath.addSegment("regardingobjectid_serviceplan"), RequestHelper.getValue(unmappedFields, "regardingobjectid_serviceplan"));
    }

    @NavigationProperty(name="regardingobjectid_connector")
    @JsonIgnore
    public ConnectorRequest getRegardingobjectid_connector() {
        return new ConnectorRequest(contextPath.addSegment("regardingobjectid_connector"), RequestHelper.getValue(unmappedFields, "regardingobjectid_connector"));
    }

    @NavigationProperty(name="regardingobjectid_environmentvariabledefinition")
    @JsonIgnore
    public EnvironmentvariabledefinitionRequest getRegardingobjectid_environmentvariabledefinition() {
        return new EnvironmentvariabledefinitionRequest(contextPath.addSegment("regardingobjectid_environmentvariabledefinition"), RequestHelper.getValue(unmappedFields, "regardingobjectid_environmentvariabledefinition"));
    }

    @NavigationProperty(name="regardingobjectid_environmentvariablevalue")
    @JsonIgnore
    public EnvironmentvariablevalueRequest getRegardingobjectid_environmentvariablevalue() {
        return new EnvironmentvariablevalueRequest(contextPath.addSegment("regardingobjectid_environmentvariablevalue"), RequestHelper.getValue(unmappedFields, "regardingobjectid_environmentvariablevalue"));
    }

    @NavigationProperty(name="regardingobjectid_processstageparameter")
    @JsonIgnore
    public ProcessstageparameterRequest getRegardingobjectid_processstageparameter() {
        return new ProcessstageparameterRequest(contextPath.addSegment("regardingobjectid_processstageparameter"), RequestHelper.getValue(unmappedFields, "regardingobjectid_processstageparameter"));
    }

    @NavigationProperty(name="regardingobjectid_flowsession")
    @JsonIgnore
    public FlowsessionRequest getRegardingobjectid_flowsession() {
        return new FlowsessionRequest(contextPath.addSegment("regardingobjectid_flowsession"), RequestHelper.getValue(unmappedFields, "regardingobjectid_flowsession"));
    }

    @NavigationProperty(name="regardingobjectid_workflowbinary")
    @JsonIgnore
    public WorkflowbinaryRequest getRegardingobjectid_workflowbinary() {
        return new WorkflowbinaryRequest(contextPath.addSegment("regardingobjectid_workflowbinary"), RequestHelper.getValue(unmappedFields, "regardingobjectid_workflowbinary"));
    }

    @NavigationProperty(name="regardingobjectid_connectionreference")
    @JsonIgnore
    public ConnectionreferenceRequest getRegardingobjectid_connectionreference() {
        return new ConnectionreferenceRequest(contextPath.addSegment("regardingobjectid_connectionreference"), RequestHelper.getValue(unmappedFields, "regardingobjectid_connectionreference"));
    }

    @NavigationProperty(name="regardingobjectid_msdyn_helppage")
    @JsonIgnore
    public Msdyn_helppageRequest getRegardingobjectid_msdyn_helppage() {
        return new Msdyn_helppageRequest(contextPath.addSegment("regardingobjectid_msdyn_helppage"), RequestHelper.getValue(unmappedFields, "regardingobjectid_msdyn_helppage"));
    }

    @NavigationProperty(name="regardingobjectid_territory")
    @JsonIgnore
    public TerritoryRequest getRegardingobjectid_territory() {
        return new TerritoryRequest(contextPath.addSegment("regardingobjectid_territory"), RequestHelper.getValue(unmappedFields, "regardingobjectid_territory"));
    }

    @NavigationProperty(name="regardingobjectid_msdyn_serviceconfiguration")
    @JsonIgnore
    public Msdyn_serviceconfigurationRequest getRegardingobjectid_msdyn_serviceconfiguration() {
        return new Msdyn_serviceconfigurationRequest(contextPath.addSegment("regardingobjectid_msdyn_serviceconfiguration"), RequestHelper.getValue(unmappedFields, "regardingobjectid_msdyn_serviceconfiguration"));
    }

    @NavigationProperty(name="regardingobjectid_msdyn_slakpi")
    @JsonIgnore
    public Msdyn_slakpiRequest getRegardingobjectid_msdyn_slakpi() {
        return new Msdyn_slakpiRequest(contextPath.addSegment("regardingobjectid_msdyn_slakpi"), RequestHelper.getValue(unmappedFields, "regardingobjectid_msdyn_slakpi"));
    }

    @NavigationProperty(name="regardingobjectid_msdyn_knowledgearticleimage")
    @JsonIgnore
    public Msdyn_knowledgearticleimageRequest getRegardingobjectid_msdyn_knowledgearticleimage() {
        return new Msdyn_knowledgearticleimageRequest(contextPath.addSegment("regardingobjectid_msdyn_knowledgearticleimage"), RequestHelper.getValue(unmappedFields, "regardingobjectid_msdyn_knowledgearticleimage"));
    }

    @NavigationProperty(name="regardingobjectid_msdyn_knowledgearticletemplate")
    @JsonIgnore
    public Msdyn_knowledgearticletemplateRequest getRegardingobjectid_msdyn_knowledgearticletemplate() {
        return new Msdyn_knowledgearticletemplateRequest(contextPath.addSegment("regardingobjectid_msdyn_knowledgearticletemplate"), RequestHelper.getValue(unmappedFields, "regardingobjectid_msdyn_knowledgearticletemplate"));
    }

    @NavigationProperty(name="regardingobjectid_msdyn_dataflow")
    @JsonIgnore
    public Msdyn_dataflowRequest getRegardingobjectid_msdyn_dataflow() {
        return new Msdyn_dataflowRequest(contextPath.addSegment("regardingobjectid_msdyn_dataflow"), RequestHelper.getValue(unmappedFields, "regardingobjectid_msdyn_dataflow"));
    }

    @NavigationProperty(name="regardingobjectid_msdyn_richtextfile")
    @JsonIgnore
    public Msdyn_richtextfileRequest getRegardingobjectid_msdyn_richtextfile() {
        return new Msdyn_richtextfileRequest(contextPath.addSegment("regardingobjectid_msdyn_richtextfile"), RequestHelper.getValue(unmappedFields, "regardingobjectid_msdyn_richtextfile"));
    }

    @NavigationProperty(name="regardingobjectid_msdyn_aiconfiguration")
    @JsonIgnore
    public Msdyn_aiconfigurationRequest getRegardingobjectid_msdyn_aiconfiguration() {
        return new Msdyn_aiconfigurationRequest(contextPath.addSegment("regardingobjectid_msdyn_aiconfiguration"), RequestHelper.getValue(unmappedFields, "regardingobjectid_msdyn_aiconfiguration"));
    }

    @NavigationProperty(name="regardingobjectid_msdyn_aimodel")
    @JsonIgnore
    public Msdyn_aimodelRequest getRegardingobjectid_msdyn_aimodel() {
        return new Msdyn_aimodelRequest(contextPath.addSegment("regardingobjectid_msdyn_aimodel"), RequestHelper.getValue(unmappedFields, "regardingobjectid_msdyn_aimodel"));
    }

    @NavigationProperty(name="regardingobjectid_msdyn_aitemplate")
    @JsonIgnore
    public Msdyn_aitemplateRequest getRegardingobjectid_msdyn_aitemplate() {
        return new Msdyn_aitemplateRequest(contextPath.addSegment("regardingobjectid_msdyn_aitemplate"), RequestHelper.getValue(unmappedFields, "regardingobjectid_msdyn_aitemplate"));
    }

    @NavigationProperty(name="regardingobjectid_msdyn_aibdataset")
    @JsonIgnore
    public Msdyn_aibdatasetRequest getRegardingobjectid_msdyn_aibdataset() {
        return new Msdyn_aibdatasetRequest(contextPath.addSegment("regardingobjectid_msdyn_aibdataset"), RequestHelper.getValue(unmappedFields, "regardingobjectid_msdyn_aibdataset"));
    }

    @NavigationProperty(name="regardingobjectid_msdyn_aibdatasetfile")
    @JsonIgnore
    public Msdyn_aibdatasetfileRequest getRegardingobjectid_msdyn_aibdatasetfile() {
        return new Msdyn_aibdatasetfileRequest(contextPath.addSegment("regardingobjectid_msdyn_aibdatasetfile"), RequestHelper.getValue(unmappedFields, "regardingobjectid_msdyn_aibdatasetfile"));
    }

    @NavigationProperty(name="regardingobjectid_msdyn_aibdatasetrecord")
    @JsonIgnore
    public Msdyn_aibdatasetrecordRequest getRegardingobjectid_msdyn_aibdatasetrecord() {
        return new Msdyn_aibdatasetrecordRequest(contextPath.addSegment("regardingobjectid_msdyn_aibdatasetrecord"), RequestHelper.getValue(unmappedFields, "regardingobjectid_msdyn_aibdatasetrecord"));
    }

    @NavigationProperty(name="regardingobjectid_msdyn_aibdatasetscontainer")
    @JsonIgnore
    public Msdyn_aibdatasetscontainerRequest getRegardingobjectid_msdyn_aibdatasetscontainer() {
        return new Msdyn_aibdatasetscontainerRequest(contextPath.addSegment("regardingobjectid_msdyn_aibdatasetscontainer"), RequestHelper.getValue(unmappedFields, "regardingobjectid_msdyn_aibdatasetscontainer"));
    }

    @NavigationProperty(name="regardingobjectid_msdyn_aibfile")
    @JsonIgnore
    public Msdyn_aibfileRequest getRegardingobjectid_msdyn_aibfile() {
        return new Msdyn_aibfileRequest(contextPath.addSegment("regardingobjectid_msdyn_aibfile"), RequestHelper.getValue(unmappedFields, "regardingobjectid_msdyn_aibfile"));
    }

    @NavigationProperty(name="regardingobjectid_msdyn_aibfileattacheddata")
    @JsonIgnore
    public Msdyn_aibfileattacheddataRequest getRegardingobjectid_msdyn_aibfileattacheddata() {
        return new Msdyn_aibfileattacheddataRequest(contextPath.addSegment("regardingobjectid_msdyn_aibfileattacheddata"), RequestHelper.getValue(unmappedFields, "regardingobjectid_msdyn_aibfileattacheddata"));
    }

    @NavigationProperty(name="regardingobjectid_msdyn_aifptrainingdocument")
    @JsonIgnore
    public Msdyn_aifptrainingdocumentRequest getRegardingobjectid_msdyn_aifptrainingdocument() {
        return new Msdyn_aifptrainingdocumentRequest(contextPath.addSegment("regardingobjectid_msdyn_aifptrainingdocument"), RequestHelper.getValue(unmappedFields, "regardingobjectid_msdyn_aifptrainingdocument"));
    }

    @NavigationProperty(name="regardingobjectid_msdyn_aiodimage")
    @JsonIgnore
    public Msdyn_aiodimageRequest getRegardingobjectid_msdyn_aiodimage() {
        return new Msdyn_aiodimageRequest(contextPath.addSegment("regardingobjectid_msdyn_aiodimage"), RequestHelper.getValue(unmappedFields, "regardingobjectid_msdyn_aiodimage"));
    }

    @NavigationProperty(name="regardingobjectid_msdyn_aiodlabel")
    @JsonIgnore
    public Msdyn_aiodlabelRequest getRegardingobjectid_msdyn_aiodlabel() {
        return new Msdyn_aiodlabelRequest(contextPath.addSegment("regardingobjectid_msdyn_aiodlabel"), RequestHelper.getValue(unmappedFields, "regardingobjectid_msdyn_aiodlabel"));
    }

    @NavigationProperty(name="regardingobjectid_msdyn_aiodtrainingboundingbox")
    @JsonIgnore
    public Msdyn_aiodtrainingboundingboxRequest getRegardingobjectid_msdyn_aiodtrainingboundingbox() {
        return new Msdyn_aiodtrainingboundingboxRequest(contextPath.addSegment("regardingobjectid_msdyn_aiodtrainingboundingbox"), RequestHelper.getValue(unmappedFields, "regardingobjectid_msdyn_aiodtrainingboundingbox"));
    }

    @NavigationProperty(name="regardingobjectid_msdyn_aiodtrainingimage")
    @JsonIgnore
    public Msdyn_aiodtrainingimageRequest getRegardingobjectid_msdyn_aiodtrainingimage() {
        return new Msdyn_aiodtrainingimageRequest(contextPath.addSegment("regardingobjectid_msdyn_aiodtrainingimage"), RequestHelper.getValue(unmappedFields, "regardingobjectid_msdyn_aiodtrainingimage"));
    }

    @NavigationProperty(name="regardingobjectid_msdyn_analysiscomponent")
    @JsonIgnore
    public Msdyn_analysiscomponentRequest getRegardingobjectid_msdyn_analysiscomponent() {
        return new Msdyn_analysiscomponentRequest(contextPath.addSegment("regardingobjectid_msdyn_analysiscomponent"), RequestHelper.getValue(unmappedFields, "regardingobjectid_msdyn_analysiscomponent"));
    }

    @NavigationProperty(name="regardingobjectid_msdyn_analysisjob")
    @JsonIgnore
    public Msdyn_analysisjobRequest getRegardingobjectid_msdyn_analysisjob() {
        return new Msdyn_analysisjobRequest(contextPath.addSegment("regardingobjectid_msdyn_analysisjob"), RequestHelper.getValue(unmappedFields, "regardingobjectid_msdyn_analysisjob"));
    }

    @NavigationProperty(name="regardingobjectid_msdyn_analysisresult")
    @JsonIgnore
    public Msdyn_analysisresultRequest getRegardingobjectid_msdyn_analysisresult() {
        return new Msdyn_analysisresultRequest(contextPath.addSegment("regardingobjectid_msdyn_analysisresult"), RequestHelper.getValue(unmappedFields, "regardingobjectid_msdyn_analysisresult"));
    }

    @NavigationProperty(name="regardingobjectid_msdyn_analysisresultdetail")
    @JsonIgnore
    public Msdyn_analysisresultdetailRequest getRegardingobjectid_msdyn_analysisresultdetail() {
        return new Msdyn_analysisresultdetailRequest(contextPath.addSegment("regardingobjectid_msdyn_analysisresultdetail"), RequestHelper.getValue(unmappedFields, "regardingobjectid_msdyn_analysisresultdetail"));
    }

    @NavigationProperty(name="regardingobjectid_msdyn_solutionhealthrule")
    @JsonIgnore
    public Msdyn_solutionhealthruleRequest getRegardingobjectid_msdyn_solutionhealthrule() {
        return new Msdyn_solutionhealthruleRequest(contextPath.addSegment("regardingobjectid_msdyn_solutionhealthrule"), RequestHelper.getValue(unmappedFields, "regardingobjectid_msdyn_solutionhealthrule"));
    }

    @NavigationProperty(name="regardingobjectid_msdyn_solutionhealthruleargument")
    @JsonIgnore
    public Msdyn_solutionhealthruleargumentRequest getRegardingobjectid_msdyn_solutionhealthruleargument() {
        return new Msdyn_solutionhealthruleargumentRequest(contextPath.addSegment("regardingobjectid_msdyn_solutionhealthruleargument"), RequestHelper.getValue(unmappedFields, "regardingobjectid_msdyn_solutionhealthruleargument"));
    }

    @NavigationProperty(name="regardingobjectid_msdyn_solutionhealthruleset")
    @JsonIgnore
    public Msdyn_solutionhealthrulesetRequest getRegardingobjectid_msdyn_solutionhealthruleset() {
        return new Msdyn_solutionhealthrulesetRequest(contextPath.addSegment("regardingobjectid_msdyn_solutionhealthruleset"), RequestHelper.getValue(unmappedFields, "regardingobjectid_msdyn_solutionhealthruleset"));
    }

    @NavigationProperty(name="regardingobjectid_ggw_event")
    @JsonIgnore
    public Ggw_eventRequest getRegardingobjectid_ggw_event() {
        return new Ggw_eventRequest(contextPath.addSegment("regardingobjectid_ggw_event"), RequestHelper.getValue(unmappedFields, "regardingobjectid_ggw_event"));
    }

    @NavigationProperty(name="regardingobjectid_ggw_team")
    @JsonIgnore
    public Ggw_teamRequest getRegardingobjectid_ggw_team() {
        return new Ggw_teamRequest(contextPath.addSegment("regardingobjectid_ggw_team"), RequestHelper.getValue(unmappedFields, "regardingobjectid_ggw_team"));
    }

    @NavigationProperty(name="regardingobjectid_ggw_crew")
    @JsonIgnore
    public Ggw_crewRequest getRegardingobjectid_ggw_crew() {
        return new Ggw_crewRequest(contextPath.addSegment("regardingobjectid_ggw_crew"), RequestHelper.getValue(unmappedFields, "regardingobjectid_ggw_crew"));
    }

    @NavigationProperty(name="regardingobjectid_ggw_team_application")
    @JsonIgnore
    public Ggw_team_applicationRequest getRegardingobjectid_ggw_team_application() {
        return new Ggw_team_applicationRequest(contextPath.addSegment("regardingobjectid_ggw_team_application"), RequestHelper.getValue(unmappedFields, "regardingobjectid_ggw_team_application"));
    }

    @NavigationProperty(name="regardingobjectid_cascadegrantrevokeaccessrecordstracker")
    @JsonIgnore
    public CascadegrantrevokeaccessrecordstrackerRequest getRegardingobjectid_cascadegrantrevokeaccessrecordstracker() {
        return new CascadegrantrevokeaccessrecordstrackerRequest(contextPath.addSegment("regardingobjectid_cascadegrantrevokeaccessrecordstracker"), RequestHelper.getValue(unmappedFields, "regardingobjectid_cascadegrantrevokeaccessrecordstracker"));
    }

    @NavigationProperty(name="regardingobjectid_cascadegrantrevokeaccessversiontracker")
    @JsonIgnore
    public CascadegrantrevokeaccessversiontrackerRequest getRegardingobjectid_cascadegrantrevokeaccessversiontracker() {
        return new CascadegrantrevokeaccessversiontrackerRequest(contextPath.addSegment("regardingobjectid_cascadegrantrevokeaccessversiontracker"), RequestHelper.getValue(unmappedFields, "regardingobjectid_cascadegrantrevokeaccessversiontracker"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Asyncoperation patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Asyncoperation _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Asyncoperation put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Asyncoperation _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Asyncoperation _copy() {
        Asyncoperation _x = new Asyncoperation();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.callerorigin = callerorigin;
        _x.expanderstarttime = expanderstarttime;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.primaryentitytype = primaryentitytype;
        _x.requestid = requestid;
        _x.workflowstagename = workflowstagename;
        _x._regardingobjectid_value = _regardingobjectid_value;
        _x._modifiedby_value = _modifiedby_value;
        _x._workflowactivationid_value = _workflowactivationid_value;
        _x.modifiedon = modifiedon;
        _x.breadcrumbid = breadcrumbid;
        _x.startedon = startedon;
        _x.statecode = statecode;
        _x.errorcode = errorcode;
        _x.recurrencestarttime = recurrencestarttime;
        _x.recurrencepattern = recurrencepattern;
        _x.parentpluginexecutionid = parentpluginexecutionid;
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        _x.friendlymessage = friendlymessage;
        _x.correlationupdatedtime = correlationupdatedtime;
        _x.message = message;
        _x._owningextensionid_value = _owningextensionid_value;
        _x.postponeuntil = postponeuntil;
        _x.depth = depth;
        _x.correlationid = correlationid;
        _x._owningteam_value = _owningteam_value;
        _x.retainjobhistory = retainjobhistory;
        _x.hostid = hostid;
        _x.createdon = createdon;
        _x.completedon = completedon;
        _x.retrycount = retrycount;
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        _x.subtype = subtype;
        _x._createdby_value = _createdby_value;
        _x._owninguser_value = _owninguser_value;
        _x.datablobid_name = datablobid_name;
        _x.dependencytoken = dependencytoken;
        _x.messagename = messagename;
        _x._ownerid_value = _ownerid_value;
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        _x.statuscode = statuscode;
        _x.rootexecutioncontext = rootexecutioncontext;
        _x.operationtype = operationtype;
        _x.name = name;
        _x.data = data;
        _x.sequence = sequence;
        _x.asyncoperationid = asyncoperationid;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.executiontimespan = executiontimespan;
        _x.iswaitingforevent = iswaitingforevent;
        _x.workload = workload;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Asyncoperation[");
        b.append("callerorigin=");
        b.append(this.callerorigin);
        b.append(", ");
        b.append("expanderstarttime=");
        b.append(this.expanderstarttime);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("primaryentitytype=");
        b.append(this.primaryentitytype);
        b.append(", ");
        b.append("requestid=");
        b.append(this.requestid);
        b.append(", ");
        b.append("workflowstagename=");
        b.append(this.workflowstagename);
        b.append(", ");
        b.append("_regardingobjectid_value=");
        b.append(this._regardingobjectid_value);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("_workflowactivationid_value=");
        b.append(this._workflowactivationid_value);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("breadcrumbid=");
        b.append(this.breadcrumbid);
        b.append(", ");
        b.append("startedon=");
        b.append(this.startedon);
        b.append(", ");
        b.append("statecode=");
        b.append(this.statecode);
        b.append(", ");
        b.append("errorcode=");
        b.append(this.errorcode);
        b.append(", ");
        b.append("recurrencestarttime=");
        b.append(this.recurrencestarttime);
        b.append(", ");
        b.append("recurrencepattern=");
        b.append(this.recurrencepattern);
        b.append(", ");
        b.append("parentpluginexecutionid=");
        b.append(this.parentpluginexecutionid);
        b.append(", ");
        b.append("_owningbusinessunit_value=");
        b.append(this._owningbusinessunit_value);
        b.append(", ");
        b.append("friendlymessage=");
        b.append(this.friendlymessage);
        b.append(", ");
        b.append("correlationupdatedtime=");
        b.append(this.correlationupdatedtime);
        b.append(", ");
        b.append("message=");
        b.append(this.message);
        b.append(", ");
        b.append("_owningextensionid_value=");
        b.append(this._owningextensionid_value);
        b.append(", ");
        b.append("postponeuntil=");
        b.append(this.postponeuntil);
        b.append(", ");
        b.append("depth=");
        b.append(this.depth);
        b.append(", ");
        b.append("correlationid=");
        b.append(this.correlationid);
        b.append(", ");
        b.append("_owningteam_value=");
        b.append(this._owningteam_value);
        b.append(", ");
        b.append("retainjobhistory=");
        b.append(this.retainjobhistory);
        b.append(", ");
        b.append("hostid=");
        b.append(this.hostid);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("completedon=");
        b.append(this.completedon);
        b.append(", ");
        b.append("retrycount=");
        b.append(this.retrycount);
        b.append(", ");
        b.append("timezoneruleversionnumber=");
        b.append(this.timezoneruleversionnumber);
        b.append(", ");
        b.append("subtype=");
        b.append(this.subtype);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("_owninguser_value=");
        b.append(this._owninguser_value);
        b.append(", ");
        b.append("datablobid_name=");
        b.append(this.datablobid_name);
        b.append(", ");
        b.append("dependencytoken=");
        b.append(this.dependencytoken);
        b.append(", ");
        b.append("messagename=");
        b.append(this.messagename);
        b.append(", ");
        b.append("_ownerid_value=");
        b.append(this._ownerid_value);
        b.append(", ");
        b.append("utcconversiontimezonecode=");
        b.append(this.utcconversiontimezonecode);
        b.append(", ");
        b.append("statuscode=");
        b.append(this.statuscode);
        b.append(", ");
        b.append("rootexecutioncontext=");
        b.append(this.rootexecutioncontext);
        b.append(", ");
        b.append("operationtype=");
        b.append(this.operationtype);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("data=");
        b.append(this.data);
        b.append(", ");
        b.append("sequence=");
        b.append(this.sequence);
        b.append(", ");
        b.append("asyncoperationid=");
        b.append(this.asyncoperationid);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("executiontimespan=");
        b.append(this.executiontimespan);
        b.append(", ");
        b.append("iswaitingforevent=");
        b.append(this.iswaitingforevent);
        b.append(", ");
        b.append("workload=");
        b.append(this.workload);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
