package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.request.AppconfigRequest;
import microsoft.dynamics.crm.entity.request.AppconfigmasterRequest;
import microsoft.dynamics.crm.entity.request.OrganizationRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "_createdby_value", 
    "_organizationid_value", 
    "appconfiginstanceidunique", 
    "importsequencenumber", 
    "versionnumber", 
    "modifiedon", 
    "appconfiginstanceid", 
    "_modifiedby_value", 
    "solutionid", 
    "componenttype", 
    "_appconfigmasterid_value", 
    "ismanaged", 
    "componentstate", 
    "objectid", 
    "appconfigidunique", 
    "introducedversion", 
    "overwritetime", 
    "_appconfigid_value", 
    "createdon", 
    "overriddencreatedon", 
    "value", 
    "_createdonbehalfby_value", 
    "_modifiedonbehalfby_value"})
@JsonInclude(Include.NON_NULL)
public class Appconfiginstance extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.appconfiginstance";
    }

    @JsonProperty("_createdby_value")
    protected UUID _createdby_value;

    @JsonProperty("_organizationid_value")
    protected UUID _organizationid_value;

    @JsonProperty("appconfiginstanceidunique")
    protected UUID appconfiginstanceidunique;

    @JsonProperty("importsequencenumber")
    protected Integer importsequencenumber;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("appconfiginstanceid")
    protected UUID appconfiginstanceid;

    @JsonProperty("_modifiedby_value")
    protected UUID _modifiedby_value;

    @JsonProperty("solutionid")
    protected UUID solutionid;

    @JsonProperty("componenttype")
    protected String componenttype;

    @JsonProperty("_appconfigmasterid_value")
    protected UUID _appconfigmasterid_value;

    @JsonProperty("ismanaged")
    protected Boolean ismanaged;

    @JsonProperty("componentstate")
    protected Integer componentstate;

    @JsonProperty("objectid")
    protected UUID objectid;

    @JsonProperty("appconfigidunique")
    protected UUID appconfigidunique;

    @JsonProperty("introducedversion")
    protected String introducedversion;

    @JsonProperty("overwritetime")
    protected OffsetDateTime overwritetime;

    @JsonProperty("_appconfigid_value")
    protected UUID _appconfigid_value;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("overriddencreatedon")
    protected OffsetDateTime overriddencreatedon;

    @JsonProperty("value")
    protected String value;

    @JsonProperty("_createdonbehalfby_value")
    protected UUID _createdonbehalfby_value;

    @JsonProperty("_modifiedonbehalfby_value")
    protected UUID _modifiedonbehalfby_value;

    protected Appconfiginstance() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAppconfiginstance() {
        return new Builder();
    }

    public static final class Builder {
        private UUID _createdby_value;
        private UUID _organizationid_value;
        private UUID appconfiginstanceidunique;
        private Integer importsequencenumber;
        private Long versionnumber;
        private OffsetDateTime modifiedon;
        private UUID appconfiginstanceid;
        private UUID _modifiedby_value;
        private UUID solutionid;
        private String componenttype;
        private UUID _appconfigmasterid_value;
        private Boolean ismanaged;
        private Integer componentstate;
        private UUID objectid;
        private UUID appconfigidunique;
        private String introducedversion;
        private OffsetDateTime overwritetime;
        private UUID _appconfigid_value;
        private OffsetDateTime createdon;
        private OffsetDateTime overriddencreatedon;
        private String value;
        private UUID _createdonbehalfby_value;
        private UUID _modifiedonbehalfby_value;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder _createdby_value(UUID _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder _organizationid_value(UUID _organizationid_value) {
            this._organizationid_value = _organizationid_value;
            this.changedFields = changedFields.add("_organizationid_value");
            return this;
        }

        public Builder appconfiginstanceidunique(UUID appconfiginstanceidunique) {
            this.appconfiginstanceidunique = appconfiginstanceidunique;
            this.changedFields = changedFields.add("appconfiginstanceidunique");
            return this;
        }

        public Builder importsequencenumber(Integer importsequencenumber) {
            this.importsequencenumber = importsequencenumber;
            this.changedFields = changedFields.add("importsequencenumber");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder appconfiginstanceid(UUID appconfiginstanceid) {
            this.appconfiginstanceid = appconfiginstanceid;
            this.changedFields = changedFields.add("appconfiginstanceid");
            return this;
        }

        public Builder _modifiedby_value(UUID _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder solutionid(UUID solutionid) {
            this.solutionid = solutionid;
            this.changedFields = changedFields.add("solutionid");
            return this;
        }

        public Builder componenttype(String componenttype) {
            this.componenttype = componenttype;
            this.changedFields = changedFields.add("componenttype");
            return this;
        }

        public Builder _appconfigmasterid_value(UUID _appconfigmasterid_value) {
            this._appconfigmasterid_value = _appconfigmasterid_value;
            this.changedFields = changedFields.add("_appconfigmasterid_value");
            return this;
        }

        public Builder ismanaged(Boolean ismanaged) {
            this.ismanaged = ismanaged;
            this.changedFields = changedFields.add("ismanaged");
            return this;
        }

        public Builder componentstate(Integer componentstate) {
            this.componentstate = componentstate;
            this.changedFields = changedFields.add("componentstate");
            return this;
        }

        public Builder objectid(UUID objectid) {
            this.objectid = objectid;
            this.changedFields = changedFields.add("objectid");
            return this;
        }

        public Builder appconfigidunique(UUID appconfigidunique) {
            this.appconfigidunique = appconfigidunique;
            this.changedFields = changedFields.add("appconfigidunique");
            return this;
        }

        public Builder introducedversion(String introducedversion) {
            this.introducedversion = introducedversion;
            this.changedFields = changedFields.add("introducedversion");
            return this;
        }

        public Builder overwritetime(OffsetDateTime overwritetime) {
            this.overwritetime = overwritetime;
            this.changedFields = changedFields.add("overwritetime");
            return this;
        }

        public Builder _appconfigid_value(UUID _appconfigid_value) {
            this._appconfigid_value = _appconfigid_value;
            this.changedFields = changedFields.add("_appconfigid_value");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder overriddencreatedon(OffsetDateTime overriddencreatedon) {
            this.overriddencreatedon = overriddencreatedon;
            this.changedFields = changedFields.add("overriddencreatedon");
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            this.changedFields = changedFields.add("value");
            return this;
        }

        public Builder _createdonbehalfby_value(UUID _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder _modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Appconfiginstance build() {
            Appconfiginstance _x = new Appconfiginstance();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.appconfiginstance";
            _x._createdby_value = _createdby_value;
            _x._organizationid_value = _organizationid_value;
            _x.appconfiginstanceidunique = appconfiginstanceidunique;
            _x.importsequencenumber = importsequencenumber;
            _x.versionnumber = versionnumber;
            _x.modifiedon = modifiedon;
            _x.appconfiginstanceid = appconfiginstanceid;
            _x._modifiedby_value = _modifiedby_value;
            _x.solutionid = solutionid;
            _x.componenttype = componenttype;
            _x._appconfigmasterid_value = _appconfigmasterid_value;
            _x.ismanaged = ismanaged;
            _x.componentstate = componentstate;
            _x.objectid = objectid;
            _x.appconfigidunique = appconfigidunique;
            _x.introducedversion = introducedversion;
            _x.overwritetime = overwritetime;
            _x._appconfigid_value = _appconfigid_value;
            _x.createdon = createdon;
            _x.overriddencreatedon = overriddencreatedon;
            _x.value = value;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && appconfiginstanceid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(appconfiginstanceid, UUID.class));
        }
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<UUID> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Appconfiginstance with_createdby_value(UUID _createdby_value) {
        Appconfiginstance _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appconfiginstance");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="_organizationid_value")
    @JsonIgnore
    public Optional<UUID> get_organizationid_value() {
        return Optional.ofNullable(_organizationid_value);
    }

    public Appconfiginstance with_organizationid_value(UUID _organizationid_value) {
        Appconfiginstance _x = _copy();
        _x.changedFields = changedFields.add("_organizationid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appconfiginstance");
        _x._organizationid_value = _organizationid_value;
        return _x;
    }

    @Property(name="appconfiginstanceidunique")
    @JsonIgnore
    public Optional<UUID> getAppconfiginstanceidunique() {
        return Optional.ofNullable(appconfiginstanceidunique);
    }

    public Appconfiginstance withAppconfiginstanceidunique(UUID appconfiginstanceidunique) {
        Appconfiginstance _x = _copy();
        _x.changedFields = changedFields.add("appconfiginstanceidunique");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appconfiginstance");
        _x.appconfiginstanceidunique = appconfiginstanceidunique;
        return _x;
    }

    @Property(name="importsequencenumber")
    @JsonIgnore
    public Optional<Integer> getImportsequencenumber() {
        return Optional.ofNullable(importsequencenumber);
    }

    public Appconfiginstance withImportsequencenumber(Integer importsequencenumber) {
        Appconfiginstance _x = _copy();
        _x.changedFields = changedFields.add("importsequencenumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appconfiginstance");
        _x.importsequencenumber = importsequencenumber;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Appconfiginstance withVersionnumber(Long versionnumber) {
        Appconfiginstance _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appconfiginstance");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Appconfiginstance withModifiedon(OffsetDateTime modifiedon) {
        Appconfiginstance _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appconfiginstance");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="appconfiginstanceid")
    @JsonIgnore
    public Optional<UUID> getAppconfiginstanceid() {
        return Optional.ofNullable(appconfiginstanceid);
    }

    public Appconfiginstance withAppconfiginstanceid(UUID appconfiginstanceid) {
        Appconfiginstance _x = _copy();
        _x.changedFields = changedFields.add("appconfiginstanceid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appconfiginstance");
        _x.appconfiginstanceid = appconfiginstanceid;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Appconfiginstance with_modifiedby_value(UUID _modifiedby_value) {
        Appconfiginstance _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appconfiginstance");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="solutionid")
    @JsonIgnore
    public Optional<UUID> getSolutionid() {
        return Optional.ofNullable(solutionid);
    }

    public Appconfiginstance withSolutionid(UUID solutionid) {
        Appconfiginstance _x = _copy();
        _x.changedFields = changedFields.add("solutionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appconfiginstance");
        _x.solutionid = solutionid;
        return _x;
    }

    @Property(name="componenttype")
    @JsonIgnore
    public Optional<String> getComponenttype() {
        return Optional.ofNullable(componenttype);
    }

    public Appconfiginstance withComponenttype(String componenttype) {
        Checks.checkIsAscii(componenttype);
        Appconfiginstance _x = _copy();
        _x.changedFields = changedFields.add("componenttype");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appconfiginstance");
        _x.componenttype = componenttype;
        return _x;
    }

    @Property(name="_appconfigmasterid_value")
    @JsonIgnore
    public Optional<UUID> get_appconfigmasterid_value() {
        return Optional.ofNullable(_appconfigmasterid_value);
    }

    public Appconfiginstance with_appconfigmasterid_value(UUID _appconfigmasterid_value) {
        Appconfiginstance _x = _copy();
        _x.changedFields = changedFields.add("_appconfigmasterid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appconfiginstance");
        _x._appconfigmasterid_value = _appconfigmasterid_value;
        return _x;
    }

    @Property(name="ismanaged")
    @JsonIgnore
    public Optional<Boolean> getIsmanaged() {
        return Optional.ofNullable(ismanaged);
    }

    public Appconfiginstance withIsmanaged(Boolean ismanaged) {
        Appconfiginstance _x = _copy();
        _x.changedFields = changedFields.add("ismanaged");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appconfiginstance");
        _x.ismanaged = ismanaged;
        return _x;
    }

    @Property(name="componentstate")
    @JsonIgnore
    public Optional<Integer> getComponentstate() {
        return Optional.ofNullable(componentstate);
    }

    public Appconfiginstance withComponentstate(Integer componentstate) {
        Appconfiginstance _x = _copy();
        _x.changedFields = changedFields.add("componentstate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appconfiginstance");
        _x.componentstate = componentstate;
        return _x;
    }

    @Property(name="objectid")
    @JsonIgnore
    public Optional<UUID> getObjectid() {
        return Optional.ofNullable(objectid);
    }

    public Appconfiginstance withObjectid(UUID objectid) {
        Appconfiginstance _x = _copy();
        _x.changedFields = changedFields.add("objectid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appconfiginstance");
        _x.objectid = objectid;
        return _x;
    }

    @Property(name="appconfigidunique")
    @JsonIgnore
    public Optional<UUID> getAppconfigidunique() {
        return Optional.ofNullable(appconfigidunique);
    }

    public Appconfiginstance withAppconfigidunique(UUID appconfigidunique) {
        Appconfiginstance _x = _copy();
        _x.changedFields = changedFields.add("appconfigidunique");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appconfiginstance");
        _x.appconfigidunique = appconfigidunique;
        return _x;
    }

    @Property(name="introducedversion")
    @JsonIgnore
    public Optional<String> getIntroducedversion() {
        return Optional.ofNullable(introducedversion);
    }

    public Appconfiginstance withIntroducedversion(String introducedversion) {
        Checks.checkIsAscii(introducedversion);
        Appconfiginstance _x = _copy();
        _x.changedFields = changedFields.add("introducedversion");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appconfiginstance");
        _x.introducedversion = introducedversion;
        return _x;
    }

    @Property(name="overwritetime")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverwritetime() {
        return Optional.ofNullable(overwritetime);
    }

    public Appconfiginstance withOverwritetime(OffsetDateTime overwritetime) {
        Appconfiginstance _x = _copy();
        _x.changedFields = changedFields.add("overwritetime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appconfiginstance");
        _x.overwritetime = overwritetime;
        return _x;
    }

    @Property(name="_appconfigid_value")
    @JsonIgnore
    public Optional<UUID> get_appconfigid_value() {
        return Optional.ofNullable(_appconfigid_value);
    }

    public Appconfiginstance with_appconfigid_value(UUID _appconfigid_value) {
        Appconfiginstance _x = _copy();
        _x.changedFields = changedFields.add("_appconfigid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appconfiginstance");
        _x._appconfigid_value = _appconfigid_value;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Appconfiginstance withCreatedon(OffsetDateTime createdon) {
        Appconfiginstance _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appconfiginstance");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="overriddencreatedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverriddencreatedon() {
        return Optional.ofNullable(overriddencreatedon);
    }

    public Appconfiginstance withOverriddencreatedon(OffsetDateTime overriddencreatedon) {
        Appconfiginstance _x = _copy();
        _x.changedFields = changedFields.add("overriddencreatedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appconfiginstance");
        _x.overriddencreatedon = overriddencreatedon;
        return _x;
    }

    @Property(name="value")
    @JsonIgnore
    public Optional<String> getValue() {
        return Optional.ofNullable(value);
    }

    public Appconfiginstance withValue(String value) {
        Checks.checkIsAscii(value);
        Appconfiginstance _x = _copy();
        _x.changedFields = changedFields.add("value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appconfiginstance");
        _x.value = value;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Appconfiginstance with_createdonbehalfby_value(UUID _createdonbehalfby_value) {
        Appconfiginstance _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appconfiginstance");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Appconfiginstance with_modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
        Appconfiginstance _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appconfiginstance");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    public Appconfiginstance withUnmappedField(String name, String value) {
        Appconfiginstance _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="appconfiginstance_appconfigmaster")
    @JsonIgnore
    public AppconfigmasterRequest getAppconfiginstance_appconfigmaster() {
        return new AppconfigmasterRequest(contextPath.addSegment("appconfiginstance_appconfigmaster"), RequestHelper.getValue(unmappedFields, "appconfiginstance_appconfigmaster"));
    }

    @NavigationProperty(name="organization_appconfiginstance_appconfiginstance")
    @JsonIgnore
    public OrganizationRequest getOrganization_appconfiginstance_appconfiginstance() {
        return new OrganizationRequest(contextPath.addSegment("organization_appconfiginstance_appconfiginstance"), RequestHelper.getValue(unmappedFields, "organization_appconfiginstance_appconfiginstance"));
    }

    @NavigationProperty(name="appconfiginstance_createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getAppconfiginstance_createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("appconfiginstance_createdonbehalfby"), RequestHelper.getValue(unmappedFields, "appconfiginstance_createdonbehalfby"));
    }

    @NavigationProperty(name="appconfiginstance_appconfig")
    @JsonIgnore
    public AppconfigRequest getAppconfiginstance_appconfig() {
        return new AppconfigRequest(contextPath.addSegment("appconfiginstance_appconfig"), RequestHelper.getValue(unmappedFields, "appconfiginstance_appconfig"));
    }

    @NavigationProperty(name="appconfiginstance_modifiedby")
    @JsonIgnore
    public SystemuserRequest getAppconfiginstance_modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("appconfiginstance_modifiedby"), RequestHelper.getValue(unmappedFields, "appconfiginstance_modifiedby"));
    }

    @NavigationProperty(name="appconfiginstance_modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getAppconfiginstance_modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("appconfiginstance_modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "appconfiginstance_modifiedonbehalfby"));
    }

    @NavigationProperty(name="appconfiginstance_createdby")
    @JsonIgnore
    public SystemuserRequest getAppconfiginstance_createdby() {
        return new SystemuserRequest(contextPath.addSegment("appconfiginstance_createdby"), RequestHelper.getValue(unmappedFields, "appconfiginstance_createdby"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Appconfiginstance patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Appconfiginstance _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Appconfiginstance put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Appconfiginstance _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Appconfiginstance _copy() {
        Appconfiginstance _x = new Appconfiginstance();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x._createdby_value = _createdby_value;
        _x._organizationid_value = _organizationid_value;
        _x.appconfiginstanceidunique = appconfiginstanceidunique;
        _x.importsequencenumber = importsequencenumber;
        _x.versionnumber = versionnumber;
        _x.modifiedon = modifiedon;
        _x.appconfiginstanceid = appconfiginstanceid;
        _x._modifiedby_value = _modifiedby_value;
        _x.solutionid = solutionid;
        _x.componenttype = componenttype;
        _x._appconfigmasterid_value = _appconfigmasterid_value;
        _x.ismanaged = ismanaged;
        _x.componentstate = componentstate;
        _x.objectid = objectid;
        _x.appconfigidunique = appconfigidunique;
        _x.introducedversion = introducedversion;
        _x.overwritetime = overwritetime;
        _x._appconfigid_value = _appconfigid_value;
        _x.createdon = createdon;
        _x.overriddencreatedon = overriddencreatedon;
        _x.value = value;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Function(name = "RetrieveUnpublished")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<Appconfiginstance> retrieveUnpublished() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<Appconfiginstance>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveUnpublished"), Appconfiginstance.class, _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Appconfiginstance[");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("_organizationid_value=");
        b.append(this._organizationid_value);
        b.append(", ");
        b.append("appconfiginstanceidunique=");
        b.append(this.appconfiginstanceidunique);
        b.append(", ");
        b.append("importsequencenumber=");
        b.append(this.importsequencenumber);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("appconfiginstanceid=");
        b.append(this.appconfiginstanceid);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("solutionid=");
        b.append(this.solutionid);
        b.append(", ");
        b.append("componenttype=");
        b.append(this.componenttype);
        b.append(", ");
        b.append("_appconfigmasterid_value=");
        b.append(this._appconfigmasterid_value);
        b.append(", ");
        b.append("ismanaged=");
        b.append(this.ismanaged);
        b.append(", ");
        b.append("componentstate=");
        b.append(this.componentstate);
        b.append(", ");
        b.append("objectid=");
        b.append(this.objectid);
        b.append(", ");
        b.append("appconfigidunique=");
        b.append(this.appconfigidunique);
        b.append(", ");
        b.append("introducedversion=");
        b.append(this.introducedversion);
        b.append(", ");
        b.append("overwritetime=");
        b.append(this.overwritetime);
        b.append(", ");
        b.append("_appconfigid_value=");
        b.append(this._appconfigid_value);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("overriddencreatedon=");
        b.append(this.overriddencreatedon);
        b.append(", ");
        b.append("value=");
        b.append(this.value);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
