package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.request.ActioncardRequest;
import microsoft.dynamics.crm.entity.request.PrincipalRequest;
import microsoft.dynamics.crm.entity.request.TransactioncurrencyRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "actioncarduserstateid", 
    "versionnumber", 
    "_transactioncurrencyid_value", 
    "exchangerate", 
    "_owningbusinessunit_value", 
    "_ownerid_value", 
    "utcconversiontimezonecode", 
    "startdate", 
    "timezoneruleversionnumber", 
    "_actioncardid_value", 
    "state"})
@JsonInclude(Include.NON_NULL)
public class Actioncarduserstate extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.actioncarduserstate";
    }

    @JsonProperty("actioncarduserstateid")
    protected UUID actioncarduserstateid;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("_transactioncurrencyid_value")
    protected UUID _transactioncurrencyid_value;

    @JsonProperty("exchangerate")
    protected BigDecimal exchangerate;

    @JsonProperty("_owningbusinessunit_value")
    protected UUID _owningbusinessunit_value;

    @JsonProperty("_ownerid_value")
    protected UUID _ownerid_value;

    @JsonProperty("utcconversiontimezonecode")
    protected Integer utcconversiontimezonecode;

    @JsonProperty("startdate")
    protected OffsetDateTime startdate;

    @JsonProperty("timezoneruleversionnumber")
    protected Integer timezoneruleversionnumber;

    @JsonProperty("_actioncardid_value")
    protected UUID _actioncardid_value;

    @JsonProperty("state")
    protected Integer state;

    protected Actioncarduserstate() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderActioncarduserstate() {
        return new Builder();
    }

    public static final class Builder {
        private UUID actioncarduserstateid;
        private Long versionnumber;
        private UUID _transactioncurrencyid_value;
        private BigDecimal exchangerate;
        private UUID _owningbusinessunit_value;
        private UUID _ownerid_value;
        private Integer utcconversiontimezonecode;
        private OffsetDateTime startdate;
        private Integer timezoneruleversionnumber;
        private UUID _actioncardid_value;
        private Integer state;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder actioncarduserstateid(UUID actioncarduserstateid) {
            this.actioncarduserstateid = actioncarduserstateid;
            this.changedFields = changedFields.add("actioncarduserstateid");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder _transactioncurrencyid_value(UUID _transactioncurrencyid_value) {
            this._transactioncurrencyid_value = _transactioncurrencyid_value;
            this.changedFields = changedFields.add("_transactioncurrencyid_value");
            return this;
        }

        public Builder exchangerate(BigDecimal exchangerate) {
            this.exchangerate = exchangerate;
            this.changedFields = changedFields.add("exchangerate");
            return this;
        }

        public Builder _owningbusinessunit_value(UUID _owningbusinessunit_value) {
            this._owningbusinessunit_value = _owningbusinessunit_value;
            this.changedFields = changedFields.add("_owningbusinessunit_value");
            return this;
        }

        public Builder _ownerid_value(UUID _ownerid_value) {
            this._ownerid_value = _ownerid_value;
            this.changedFields = changedFields.add("_ownerid_value");
            return this;
        }

        public Builder utcconversiontimezonecode(Integer utcconversiontimezonecode) {
            this.utcconversiontimezonecode = utcconversiontimezonecode;
            this.changedFields = changedFields.add("utcconversiontimezonecode");
            return this;
        }

        public Builder startdate(OffsetDateTime startdate) {
            this.startdate = startdate;
            this.changedFields = changedFields.add("startdate");
            return this;
        }

        public Builder timezoneruleversionnumber(Integer timezoneruleversionnumber) {
            this.timezoneruleversionnumber = timezoneruleversionnumber;
            this.changedFields = changedFields.add("timezoneruleversionnumber");
            return this;
        }

        public Builder _actioncardid_value(UUID _actioncardid_value) {
            this._actioncardid_value = _actioncardid_value;
            this.changedFields = changedFields.add("_actioncardid_value");
            return this;
        }

        public Builder state(Integer state) {
            this.state = state;
            this.changedFields = changedFields.add("state");
            return this;
        }

        public Actioncarduserstate build() {
            Actioncarduserstate _x = new Actioncarduserstate();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.actioncarduserstate";
            _x.actioncarduserstateid = actioncarduserstateid;
            _x.versionnumber = versionnumber;
            _x._transactioncurrencyid_value = _transactioncurrencyid_value;
            _x.exchangerate = exchangerate;
            _x._owningbusinessunit_value = _owningbusinessunit_value;
            _x._ownerid_value = _ownerid_value;
            _x.utcconversiontimezonecode = utcconversiontimezonecode;
            _x.startdate = startdate;
            _x.timezoneruleversionnumber = timezoneruleversionnumber;
            _x._actioncardid_value = _actioncardid_value;
            _x.state = state;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && actioncarduserstateid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(actioncarduserstateid, UUID.class));
        }
    }

    @Property(name="actioncarduserstateid")
    @JsonIgnore
    public Optional<UUID> getActioncarduserstateid() {
        return Optional.ofNullable(actioncarduserstateid);
    }

    public Actioncarduserstate withActioncarduserstateid(UUID actioncarduserstateid) {
        Actioncarduserstate _x = _copy();
        _x.changedFields = changedFields.add("actioncarduserstateid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.actioncarduserstate");
        _x.actioncarduserstateid = actioncarduserstateid;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Actioncarduserstate withVersionnumber(Long versionnumber) {
        Actioncarduserstate _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.actioncarduserstate");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="_transactioncurrencyid_value")
    @JsonIgnore
    public Optional<UUID> get_transactioncurrencyid_value() {
        return Optional.ofNullable(_transactioncurrencyid_value);
    }

    public Actioncarduserstate with_transactioncurrencyid_value(UUID _transactioncurrencyid_value) {
        Actioncarduserstate _x = _copy();
        _x.changedFields = changedFields.add("_transactioncurrencyid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.actioncarduserstate");
        _x._transactioncurrencyid_value = _transactioncurrencyid_value;
        return _x;
    }

    @Property(name="exchangerate")
    @JsonIgnore
    public Optional<BigDecimal> getExchangerate() {
        return Optional.ofNullable(exchangerate);
    }

    public Actioncarduserstate withExchangerate(BigDecimal exchangerate) {
        Actioncarduserstate _x = _copy();
        _x.changedFields = changedFields.add("exchangerate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.actioncarduserstate");
        _x.exchangerate = exchangerate;
        return _x;
    }

    @Property(name="_owningbusinessunit_value")
    @JsonIgnore
    public Optional<UUID> get_owningbusinessunit_value() {
        return Optional.ofNullable(_owningbusinessunit_value);
    }

    public Actioncarduserstate with_owningbusinessunit_value(UUID _owningbusinessunit_value) {
        Actioncarduserstate _x = _copy();
        _x.changedFields = changedFields.add("_owningbusinessunit_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.actioncarduserstate");
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        return _x;
    }

    @Property(name="_ownerid_value")
    @JsonIgnore
    public Optional<UUID> get_ownerid_value() {
        return Optional.ofNullable(_ownerid_value);
    }

    public Actioncarduserstate with_ownerid_value(UUID _ownerid_value) {
        Actioncarduserstate _x = _copy();
        _x.changedFields = changedFields.add("_ownerid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.actioncarduserstate");
        _x._ownerid_value = _ownerid_value;
        return _x;
    }

    @Property(name="utcconversiontimezonecode")
    @JsonIgnore
    public Optional<Integer> getUtcconversiontimezonecode() {
        return Optional.ofNullable(utcconversiontimezonecode);
    }

    public Actioncarduserstate withUtcconversiontimezonecode(Integer utcconversiontimezonecode) {
        Actioncarduserstate _x = _copy();
        _x.changedFields = changedFields.add("utcconversiontimezonecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.actioncarduserstate");
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        return _x;
    }

    @Property(name="startdate")
    @JsonIgnore
    public Optional<OffsetDateTime> getStartdate() {
        return Optional.ofNullable(startdate);
    }

    public Actioncarduserstate withStartdate(OffsetDateTime startdate) {
        Actioncarduserstate _x = _copy();
        _x.changedFields = changedFields.add("startdate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.actioncarduserstate");
        _x.startdate = startdate;
        return _x;
    }

    @Property(name="timezoneruleversionnumber")
    @JsonIgnore
    public Optional<Integer> getTimezoneruleversionnumber() {
        return Optional.ofNullable(timezoneruleversionnumber);
    }

    public Actioncarduserstate withTimezoneruleversionnumber(Integer timezoneruleversionnumber) {
        Actioncarduserstate _x = _copy();
        _x.changedFields = changedFields.add("timezoneruleversionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.actioncarduserstate");
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        return _x;
    }

    @Property(name="_actioncardid_value")
    @JsonIgnore
    public Optional<UUID> get_actioncardid_value() {
        return Optional.ofNullable(_actioncardid_value);
    }

    public Actioncarduserstate with_actioncardid_value(UUID _actioncardid_value) {
        Actioncarduserstate _x = _copy();
        _x.changedFields = changedFields.add("_actioncardid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.actioncarduserstate");
        _x._actioncardid_value = _actioncardid_value;
        return _x;
    }

    @Property(name="state")
    @JsonIgnore
    public Optional<Integer> getState() {
        return Optional.ofNullable(state);
    }

    public Actioncarduserstate withState(Integer state) {
        Actioncarduserstate _x = _copy();
        _x.changedFields = changedFields.add("state");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.actioncarduserstate");
        _x.state = state;
        return _x;
    }

    public Actioncarduserstate withUnmappedField(String name, String value) {
        Actioncarduserstate _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="actioncardid")
    @JsonIgnore
    public ActioncardRequest getActioncardid() {
        return new ActioncardRequest(contextPath.addSegment("actioncardid"), RequestHelper.getValue(unmappedFields, "actioncardid"));
    }

    @NavigationProperty(name="transactioncurrencyid")
    @JsonIgnore
    public TransactioncurrencyRequest getTransactioncurrencyid() {
        return new TransactioncurrencyRequest(contextPath.addSegment("transactioncurrencyid"), RequestHelper.getValue(unmappedFields, "transactioncurrencyid"));
    }

    @NavigationProperty(name="ownerid")
    @JsonIgnore
    public PrincipalRequest getOwnerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), RequestHelper.getValue(unmappedFields, "ownerid"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Actioncarduserstate patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Actioncarduserstate _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Actioncarduserstate put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Actioncarduserstate _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Actioncarduserstate _copy() {
        Actioncarduserstate _x = new Actioncarduserstate();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.actioncarduserstateid = actioncarduserstateid;
        _x.versionnumber = versionnumber;
        _x._transactioncurrencyid_value = _transactioncurrencyid_value;
        _x.exchangerate = exchangerate;
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        _x._ownerid_value = _ownerid_value;
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        _x.startdate = startdate;
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        _x._actioncardid_value = _actioncardid_value;
        _x.state = state;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Actioncarduserstate[");
        b.append("actioncarduserstateid=");
        b.append(this.actioncarduserstateid);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("_transactioncurrencyid_value=");
        b.append(this._transactioncurrencyid_value);
        b.append(", ");
        b.append("exchangerate=");
        b.append(this.exchangerate);
        b.append(", ");
        b.append("_owningbusinessunit_value=");
        b.append(this._owningbusinessunit_value);
        b.append(", ");
        b.append("_ownerid_value=");
        b.append(this._ownerid_value);
        b.append(", ");
        b.append("utcconversiontimezonecode=");
        b.append(this.utcconversiontimezonecode);
        b.append(", ");
        b.append("startdate=");
        b.append(this.startdate);
        b.append(", ");
        b.append("timezoneruleversionnumber=");
        b.append(this.timezoneruleversionnumber);
        b.append(", ");
        b.append("_actioncardid_value=");
        b.append(this._actioncardid_value);
        b.append(", ");
        b.append("state=");
        b.append(this.state);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
