package microsoft.dynamics.crm.container;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.Context;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollection;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.HasContext;
import com.github.davidmoten.odata.client.HttpService;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.TestingService.BuilderBase;
import com.github.davidmoten.odata.client.TestingService.ContainerBuilder;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.complex.AddSolutionComponentResponse;
import microsoft.dynamics.crm.complex.AlmHandlerResponse;
import microsoft.dynamics.crm.complex.AnalyzeSentimentResponse;
import microsoft.dynamics.crm.complex.BackgroundSendEmailResponse;
import microsoft.dynamics.crm.complex.BookResponse;
import microsoft.dynamics.crm.complex.BulkDeleteResponse;
import microsoft.dynamics.crm.complex.BulkDetectDuplicatesResponse;
import microsoft.dynamics.crm.complex.CanBeReferencedResponse;
import microsoft.dynamics.crm.complex.CanBeReferencingResponse;
import microsoft.dynamics.crm.complex.CanManyToManyResponse;
import microsoft.dynamics.crm.complex.CategorizeTextResponse;
import microsoft.dynamics.crm.complex.ChannelAccessProfilePrivilege;
import microsoft.dynamics.crm.complex.CheckIncomingEmailResponse;
import microsoft.dynamics.crm.complex.CheckPromoteEmailResponse;
import microsoft.dynamics.crm.complex.CloneAsPatchResponse;
import microsoft.dynamics.crm.complex.CloneAsSolutionResponse;
import microsoft.dynamics.crm.complex.CommitAnnotationBlocksUploadResponse;
import microsoft.dynamics.crm.complex.CommitAttachmentBlocksUploadResponse;
import microsoft.dynamics.crm.complex.CommitFileBlocksUploadResponse;
import microsoft.dynamics.crm.complex.ComplexLookupAttributeMetadata;
import microsoft.dynamics.crm.complex.ComplexOneToManyRelationshipMetadata;
import microsoft.dynamics.crm.complex.CreateCustomerRelationshipsResponse;
import microsoft.dynamics.crm.complex.CreateInstanceResponse;
import microsoft.dynamics.crm.complex.DeleteAndPromoteResponse;
import microsoft.dynamics.crm.complex.DeleteAuditDataResponse;
import microsoft.dynamics.crm.complex.DeleteRecordChangeHistoryResponse;
import microsoft.dynamics.crm.complex.DetectLanguageResponse;
import microsoft.dynamics.crm.complex.DownloadBlockResponse;
import microsoft.dynamics.crm.complex.DownloadSolutionExportDataResponse;
import microsoft.dynamics.crm.complex.EntityQueryExpression;
import microsoft.dynamics.crm.complex.ExportFieldTranslationResponse;
import microsoft.dynamics.crm.complex.ExportSolutionAsyncResponse;
import microsoft.dynamics.crm.complex.ExportSolutionResponse;
import microsoft.dynamics.crm.complex.ExtractKeyPhrasesResponse;
import microsoft.dynamics.crm.complex.ExtractTextEntitiesResponse;
import microsoft.dynamics.crm.complex.FetchXmlToQueryExpressionResponse;
import microsoft.dynamics.crm.complex.FormatAddressResponse;
import microsoft.dynamics.crm.complex.GetAutoNumberSeedResponse;
import microsoft.dynamics.crm.complex.GetFileSasUrlResponse;
import microsoft.dynamics.crm.complex.GetJobStatusResponse;
import microsoft.dynamics.crm.complex.GetNextAutoNumberValueResponse;
import microsoft.dynamics.crm.complex.GetTimeZoneCodeByLocalizedNameResponse;
import microsoft.dynamics.crm.complex.GetTrackingTokenEmailResponse;
import microsoft.dynamics.crm.complex.GetValidManyToManyResponse;
import microsoft.dynamics.crm.complex.GetValidReferencedEntitiesResponse;
import microsoft.dynamics.crm.complex.GetValidReferencingEntitiesResponse;
import microsoft.dynamics.crm.complex.ImmediateBookResponse;
import microsoft.dynamics.crm.complex.ImportCardTypeSchemaResponse;
import microsoft.dynamics.crm.complex.InitializeAnnotationBlocksDownloadResponse;
import microsoft.dynamics.crm.complex.InitializeAnnotationBlocksUploadResponse;
import microsoft.dynamics.crm.complex.InitializeAttachmentBlocksDownloadResponse;
import microsoft.dynamics.crm.complex.InitializeAttachmentBlocksUploadResponse;
import microsoft.dynamics.crm.complex.InitializeFileBlocksDownloadResponse;
import microsoft.dynamics.crm.complex.InitializeFileBlocksUploadResponse;
import microsoft.dynamics.crm.complex.InsertOptionValueResponse;
import microsoft.dynamics.crm.complex.InsertStatusValueResponse;
import microsoft.dynamics.crm.complex.IsComponentCustomizableResponse;
import microsoft.dynamics.crm.complex.IsDataEncryptionActiveResponse;
import microsoft.dynamics.crm.complex.IsPaiEnabledResponse;
import microsoft.dynamics.crm.complex.IsValidStateTransitionResponse;
import microsoft.dynamics.crm.complex.Label;
import microsoft.dynamics.crm.complex.LayerDesiredOrder;
import microsoft.dynamics.crm.complex.LocalTimeFromUtcTimeResponse;
import microsoft.dynamics.crm.complex.LocalizedLabel;
import microsoft.dynamics.crm.complex.Msdyn_ActivateProcessesResponse;
import microsoft.dynamics.crm.complex.Msdyn_ActivateSdkMessageProcessingStepsResponse;
import microsoft.dynamics.crm.complex.Msdyn_CheckForCustomizedOptionSetResponse;
import microsoft.dynamics.crm.complex.Msdyn_CheckForCustomizedSitemapResponse;
import microsoft.dynamics.crm.complex.Msdyn_CheckForCustomizedWebResourcesResponse;
import microsoft.dynamics.crm.complex.Msdyn_CheckForDeletedProcessResponse;
import microsoft.dynamics.crm.complex.Msdyn_CheckForDeletedSDKMessageProcessingStepsResponse;
import microsoft.dynamics.crm.complex.Msdyn_CheckForDeletedWebResourcesResponse;
import microsoft.dynamics.crm.complex.Msdyn_CheckForPendingProcessesResponse;
import microsoft.dynamics.crm.complex.Msdyn_CheckIfProcessesAreActiveResponse;
import microsoft.dynamics.crm.complex.Msdyn_CheckIfProcessesOwnedByDisabledUsersResponse;
import microsoft.dynamics.crm.complex.Msdyn_CheckIfSDKMessageProcessingStepsAreActiveResponse;
import microsoft.dynamics.crm.complex.Msdyn_ConditionXmlConversionResponse;
import microsoft.dynamics.crm.complex.Msdyn_DeleteCalendarResponse;
import microsoft.dynamics.crm.complex.Msdyn_RegisterSolutionHealthRuleResponse;
import microsoft.dynamics.crm.complex.Msdyn_SaveCalendarResponse;
import microsoft.dynamics.crm.complex.PagingInfo;
import microsoft.dynamics.crm.complex.PrincipalAccess;
import microsoft.dynamics.crm.complex.QueryBase;
import microsoft.dynamics.crm.complex.QueryExpression;
import microsoft.dynamics.crm.complex.QueryExpressionToFetchXmlResponse;
import microsoft.dynamics.crm.complex.QueryScheduleResponse;
import microsoft.dynamics.crm.complex.RecognizeTextResponse;
import microsoft.dynamics.crm.complex.RemoveActiveCustomizationsResponse;
import microsoft.dynamics.crm.complex.RemoveSolutionComponentResponse;
import microsoft.dynamics.crm.complex.RescheduleResponse;
import microsoft.dynamics.crm.complex.RetrieveAccessOriginResponse;
import microsoft.dynamics.crm.complex.RetrieveAllEntitiesResponse;
import microsoft.dynamics.crm.complex.RetrieveAnalyticsStoreDetailsResponse;
import microsoft.dynamics.crm.complex.RetrieveAppSettingListResponse;
import microsoft.dynamics.crm.complex.RetrieveAppSettingResponse;
import microsoft.dynamics.crm.complex.RetrieveApplicationRibbonResponse;
import microsoft.dynamics.crm.complex.RetrieveAttributeChangeHistoryResponse;
import microsoft.dynamics.crm.complex.RetrieveAuditPartitionListResponse;
import microsoft.dynamics.crm.complex.RetrieveAvailableLanguagesResponse;
import microsoft.dynamics.crm.complex.RetrieveChannelAccessProfilePrivilegesResponse;
import microsoft.dynamics.crm.complex.RetrieveCurrentOrganizationResponse;
import microsoft.dynamics.crm.complex.RetrieveDataEncryptionKeyResponse;
import microsoft.dynamics.crm.complex.RetrieveDeploymentLicenseTypeResponse;
import microsoft.dynamics.crm.complex.RetrieveDeprovisionedLanguagesResponse;
import microsoft.dynamics.crm.complex.RetrieveEntityResponse;
import microsoft.dynamics.crm.complex.RetrieveEntityRibbonResponse;
import microsoft.dynamics.crm.complex.RetrieveExchangeRateResponse;
import microsoft.dynamics.crm.complex.RetrieveFormattedImportJobResultsResponse;
import microsoft.dynamics.crm.complex.RetrieveInstalledLanguagePackVersionResponse;
import microsoft.dynamics.crm.complex.RetrieveInstalledLanguagePacksResponse;
import microsoft.dynamics.crm.complex.RetrieveLicenseInfoResponse;
import microsoft.dynamics.crm.complex.RetrieveLocLabelsResponse;
import microsoft.dynamics.crm.complex.RetrieveMailboxTrackingFoldersResponse;
import microsoft.dynamics.crm.complex.RetrieveMetadataChangesResponse;
import microsoft.dynamics.crm.complex.RetrieveMissingComponentsResponse;
import microsoft.dynamics.crm.complex.RetrieveOrganizationInfoResponse;
import microsoft.dynamics.crm.complex.RetrieveOrganizationResourcesResponse;
import microsoft.dynamics.crm.complex.RetrieveParsedDataImportFileResponse;
import microsoft.dynamics.crm.complex.RetrieveProvisionedLanguagePackVersionResponse;
import microsoft.dynamics.crm.complex.RetrieveProvisionedLanguagesResponse;
import microsoft.dynamics.crm.complex.RetrieveRecordChangeHistoryResponse;
import microsoft.dynamics.crm.complex.RetrieveRolePrivilegesRoleResponse;
import microsoft.dynamics.crm.complex.RetrieveSharedPrincipalsAndAccessResponse;
import microsoft.dynamics.crm.complex.RetrieveTimestampResponse;
import microsoft.dynamics.crm.complex.RetrieveTotalRecordCountResponse;
import microsoft.dynamics.crm.complex.RetrieveVersionResponse;
import microsoft.dynamics.crm.complex.SearchResponse;
import microsoft.dynamics.crm.complex.StageAndUpgradeResponse;
import microsoft.dynamics.crm.complex.SyncBulkOperationResponse;
import microsoft.dynamics.crm.complex.ValidateAIConfigurationResponse;
import microsoft.dynamics.crm.complex.ValidateAppResponse;
import microsoft.dynamics.crm.complex.ValidateFetchXmlExpressionResponse;
import microsoft.dynamics.crm.complex.ValidateRecurrenceRuleResponse;
import microsoft.dynamics.crm.complex.ValidateResponse;
import microsoft.dynamics.crm.complex.WhoAmIResponse;
import microsoft.dynamics.crm.entity.Activityparty;
import microsoft.dynamics.crm.entity.Activitypointer;
import microsoft.dynamics.crm.entity.Asyncoperation;
import microsoft.dynamics.crm.entity.Crmbaseentity;
import microsoft.dynamics.crm.entity.Dependency;
import microsoft.dynamics.crm.entity.Email;
import microsoft.dynamics.crm.entity.Importjob;
import microsoft.dynamics.crm.entity.Importmap;
import microsoft.dynamics.crm.entity.Msdyn_analysisjob;
import microsoft.dynamics.crm.entity.Msdyn_solutionhealthruleset;
import microsoft.dynamics.crm.entity.Processstage;
import microsoft.dynamics.crm.entity.Queueitem;
import microsoft.dynamics.crm.entity.Recurrencerule;
import microsoft.dynamics.crm.entity.Recurringappointmentmaster;
import microsoft.dynamics.crm.entity.Solutioncomponent;
import microsoft.dynamics.crm.entity.Workflow;
import microsoft.dynamics.crm.entity.request.AccountRequest;
import microsoft.dynamics.crm.entity.request.AciviewmapperRequest;
import microsoft.dynamics.crm.entity.request.ActioncardRequest;
import microsoft.dynamics.crm.entity.request.ActioncarduserstateRequest;
import microsoft.dynamics.crm.entity.request.ActivitymimeattachmentRequest;
import microsoft.dynamics.crm.entity.request.ActivitypartyRequest;
import microsoft.dynamics.crm.entity.request.ActivitypointerRequest;
import microsoft.dynamics.crm.entity.request.AnnotationRequest;
import microsoft.dynamics.crm.entity.request.AnnualfiscalcalendarRequest;
import microsoft.dynamics.crm.entity.request.AppconfigRequest;
import microsoft.dynamics.crm.entity.request.AppconfiginstanceRequest;
import microsoft.dynamics.crm.entity.request.AppconfigmasterRequest;
import microsoft.dynamics.crm.entity.request.ApplicationuserRequest;
import microsoft.dynamics.crm.entity.request.ApplicationuserroleRequest;
import microsoft.dynamics.crm.entity.request.AppmoduleRequest;
import microsoft.dynamics.crm.entity.request.AppmodulecomponentRequest;
import microsoft.dynamics.crm.entity.request.AppmodulerolesRequest;
import microsoft.dynamics.crm.entity.request.AppointmentRequest;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.AttachmentRequest;
import microsoft.dynamics.crm.entity.request.AttributeRequest;
import microsoft.dynamics.crm.entity.request.AttributeimageconfigRequest;
import microsoft.dynamics.crm.entity.request.AuditRequest;
import microsoft.dynamics.crm.entity.request.BulkdeletefailureRequest;
import microsoft.dynamics.crm.entity.request.BulkdeleteoperationRequest;
import microsoft.dynamics.crm.entity.request.BusinessunitRequest;
import microsoft.dynamics.crm.entity.request.BusinessunitnewsarticleRequest;
import microsoft.dynamics.crm.entity.request.CalendarRequest;
import microsoft.dynamics.crm.entity.request.CalendarruleRequest;
import microsoft.dynamics.crm.entity.request.CallbackregistrationRequest;
import microsoft.dynamics.crm.entity.request.CanvasappRequest;
import microsoft.dynamics.crm.entity.request.CascadegrantrevokeaccessrecordstrackerRequest;
import microsoft.dynamics.crm.entity.request.CascadegrantrevokeaccessversiontrackerRequest;
import microsoft.dynamics.crm.entity.request.CategoryRequest;
import microsoft.dynamics.crm.entity.request.ChannelaccessprofileentityaccesslevelRequest;
import microsoft.dynamics.crm.entity.request.ColumnmappingRequest;
import microsoft.dynamics.crm.entity.request.ComplexcontrolRequest;
import microsoft.dynamics.crm.entity.request.ConnectionRequest;
import microsoft.dynamics.crm.entity.request.ConnectionreferenceRequest;
import microsoft.dynamics.crm.entity.request.ConnectionroleRequest;
import microsoft.dynamics.crm.entity.request.ConnectionroleassociationRequest;
import microsoft.dynamics.crm.entity.request.ConnectorRequest;
import microsoft.dynamics.crm.entity.request.ContactRequest;
import microsoft.dynamics.crm.entity.request.CustomcontrolRequest;
import microsoft.dynamics.crm.entity.request.CustomcontroldefaultconfigRequest;
import microsoft.dynamics.crm.entity.request.CustomcontrolresourceRequest;
import microsoft.dynamics.crm.entity.request.CustomeraddressRequest;
import microsoft.dynamics.crm.entity.request.DatalakeworkspaceRequest;
import microsoft.dynamics.crm.entity.request.DatalakeworkspacepermissionRequest;
import microsoft.dynamics.crm.entity.request.DataperformanceRequest;
import microsoft.dynamics.crm.entity.request.DependencyRequest;
import microsoft.dynamics.crm.entity.request.DisplaystringRequest;
import microsoft.dynamics.crm.entity.request.DocumenttemplateRequest;
import microsoft.dynamics.crm.entity.request.DuplicaterecordRequest;
import microsoft.dynamics.crm.entity.request.DuplicateruleRequest;
import microsoft.dynamics.crm.entity.request.DuplicateruleconditionRequest;
import microsoft.dynamics.crm.entity.request.EmailRequest;
import microsoft.dynamics.crm.entity.request.EmailserverprofileRequest;
import microsoft.dynamics.crm.entity.request.EntityMetadataRequest;
import microsoft.dynamics.crm.entity.request.EntityRequest;
import microsoft.dynamics.crm.entity.request.EntityanalyticsconfigRequest;
import microsoft.dynamics.crm.entity.request.EntitydataproviderRequest;
import microsoft.dynamics.crm.entity.request.EntityimageconfigRequest;
import microsoft.dynamics.crm.entity.request.EntitykeyRequest;
import microsoft.dynamics.crm.entity.request.EntityrelationshipRequest;
import microsoft.dynamics.crm.entity.request.EnvironmentvariabledefinitionRequest;
import microsoft.dynamics.crm.entity.request.EnvironmentvariablevalueRequest;
import microsoft.dynamics.crm.entity.request.ExchangesyncidmappingRequest;
import microsoft.dynamics.crm.entity.request.ExpiredprocessRequest;
import microsoft.dynamics.crm.entity.request.ExportsolutionuploadRequest;
import microsoft.dynamics.crm.entity.request.FaxRequest;
import microsoft.dynamics.crm.entity.request.FeedbackRequest;
import microsoft.dynamics.crm.entity.request.FieldpermissionRequest;
import microsoft.dynamics.crm.entity.request.FieldsecurityprofileRequest;
import microsoft.dynamics.crm.entity.request.FileattachmentRequest;
import microsoft.dynamics.crm.entity.request.FixedmonthlyfiscalcalendarRequest;
import microsoft.dynamics.crm.entity.request.FlowsessionRequest;
import microsoft.dynamics.crm.entity.request.Ggw_crewRequest;
import microsoft.dynamics.crm.entity.request.Ggw_eventRequest;
import microsoft.dynamics.crm.entity.request.Ggw_ggw_crew_ggw_teamRequest;
import microsoft.dynamics.crm.entity.request.Ggw_teamRequest;
import microsoft.dynamics.crm.entity.request.Ggw_team_applicationRequest;
import microsoft.dynamics.crm.entity.request.GoalRequest;
import microsoft.dynamics.crm.entity.request.GoalrollupqueryRequest;
import microsoft.dynamics.crm.entity.request.ImportRequest;
import microsoft.dynamics.crm.entity.request.ImportdataRequest;
import microsoft.dynamics.crm.entity.request.ImportentitymappingRequest;
import microsoft.dynamics.crm.entity.request.ImportfileRequest;
import microsoft.dynamics.crm.entity.request.ImportjobRequest;
import microsoft.dynamics.crm.entity.request.ImportlogRequest;
import microsoft.dynamics.crm.entity.request.ImportmapRequest;
import microsoft.dynamics.crm.entity.request.InteractionforemailRequest;
import microsoft.dynamics.crm.entity.request.InvaliddependencyRequest;
import microsoft.dynamics.crm.entity.request.KbarticleRequest;
import microsoft.dynamics.crm.entity.request.KbarticlecommentRequest;
import microsoft.dynamics.crm.entity.request.KbarticletemplateRequest;
import microsoft.dynamics.crm.entity.request.KnowledgearticleRequest;
import microsoft.dynamics.crm.entity.request.KnowledgearticlescategoriesRequest;
import microsoft.dynamics.crm.entity.request.KnowledgearticleviewsRequest;
import microsoft.dynamics.crm.entity.request.KnowledgebaserecordRequest;
import microsoft.dynamics.crm.entity.request.LanguagelocaleRequest;
import microsoft.dynamics.crm.entity.request.LanguageprovisioningstateRequest;
import microsoft.dynamics.crm.entity.request.LetterRequest;
import microsoft.dynamics.crm.entity.request.LookupmappingRequest;
import microsoft.dynamics.crm.entity.request.MailboxRequest;
import microsoft.dynamics.crm.entity.request.MailboxtrackingfolderRequest;
import microsoft.dynamics.crm.entity.request.MailmergetemplateRequest;
import microsoft.dynamics.crm.entity.request.ManagedPropertyMetadataRequest;
import microsoft.dynamics.crm.entity.request.ManagedpropertyRequest;
import microsoft.dynamics.crm.entity.request.MetricRequest;
import microsoft.dynamics.crm.entity.request.MobileofflineprofileRequest;
import microsoft.dynamics.crm.entity.request.MobileofflineprofileitemRequest;
import microsoft.dynamics.crm.entity.request.MobileofflineprofileitemassociationRequest;
import microsoft.dynamics.crm.entity.request.MonthlyfiscalcalendarRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aibdatasetRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aibdatasetfileRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aibdatasetrecordRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aibdatasetscontainerRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aibfileRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aibfileattacheddataRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aiconfigurationRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aifptrainingdocumentRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aimodelRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aiodimageRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aiodlabelRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aiodlabel_msdyn_aiconfigurationRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aiodtrainingboundingboxRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aiodtrainingimageRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aitemplateRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_analysiscomponentRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_analysisjobRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_analysisresultRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_analysisresultdetailRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_componentlayerRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_componentlayerdatasourceRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_dataflowRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_helppageRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_knowledgearticleimageRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_knowledgearticletemplateRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_nonrelationaldsRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_odatav4dsRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_richtextfileRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_serviceconfigurationRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_slakpiRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_solutioncomponentdatasourceRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_solutioncomponentsummaryRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_solutionhealthruleRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_solutionhealthruleargumentRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_solutionhealthrulesetRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_solutionhistoryRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_solutionhistorydatasourceRequest;
import microsoft.dynamics.crm.entity.request.NavigationsettingRequest;
import microsoft.dynamics.crm.entity.request.NewprocessRequest;
import microsoft.dynamics.crm.entity.request.OfficegraphdocumentRequest;
import microsoft.dynamics.crm.entity.request.OptionSetMetadataBaseRequest;
import microsoft.dynamics.crm.entity.request.OptionsetRequest;
import microsoft.dynamics.crm.entity.request.OrganizationRequest;
import microsoft.dynamics.crm.entity.request.OwnermappingRequest;
import microsoft.dynamics.crm.entity.request.PersonaldocumenttemplateRequest;
import microsoft.dynamics.crm.entity.request.PhonecallRequest;
import microsoft.dynamics.crm.entity.request.PicklistmappingRequest;
import microsoft.dynamics.crm.entity.request.PluginassemblyRequest;
import microsoft.dynamics.crm.entity.request.PlugintracelogRequest;
import microsoft.dynamics.crm.entity.request.PlugintypeRequest;
import microsoft.dynamics.crm.entity.request.PlugintypestatisticRequest;
import microsoft.dynamics.crm.entity.request.PositionRequest;
import microsoft.dynamics.crm.entity.request.PostRequest;
import microsoft.dynamics.crm.entity.request.PostcommentRequest;
import microsoft.dynamics.crm.entity.request.PostfollowRequest;
import microsoft.dynamics.crm.entity.request.PostlikeRequest;
import microsoft.dynamics.crm.entity.request.PostregardingRequest;
import microsoft.dynamics.crm.entity.request.PrincipalentitymapRequest;
import microsoft.dynamics.crm.entity.request.PrincipalobjectaccessRequest;
import microsoft.dynamics.crm.entity.request.PrincipalobjectattributeaccessRequest;
import microsoft.dynamics.crm.entity.request.PrivilegeRequest;
import microsoft.dynamics.crm.entity.request.ProcesssessionRequest;
import microsoft.dynamics.crm.entity.request.ProcessstageRequest;
import microsoft.dynamics.crm.entity.request.ProcessstageparameterRequest;
import microsoft.dynamics.crm.entity.request.ProcesstriggerRequest;
import microsoft.dynamics.crm.entity.request.PublisherRequest;
import microsoft.dynamics.crm.entity.request.PublisheraddressRequest;
import microsoft.dynamics.crm.entity.request.QuarterlyfiscalcalendarRequest;
import microsoft.dynamics.crm.entity.request.QueueRequest;
import microsoft.dynamics.crm.entity.request.QueueitemRequest;
import microsoft.dynamics.crm.entity.request.QueuemembershipRequest;
import microsoft.dynamics.crm.entity.request.RecommendeddocumentRequest;
import microsoft.dynamics.crm.entity.request.RecurrenceruleRequest;
import microsoft.dynamics.crm.entity.request.RecurringappointmentmasterRequest;
import microsoft.dynamics.crm.entity.request.RelationshipMetadataBaseRequest;
import microsoft.dynamics.crm.entity.request.RelationshipRequest;
import microsoft.dynamics.crm.entity.request.RelationshipattributeRequest;
import microsoft.dynamics.crm.entity.request.ReportRequest;
import microsoft.dynamics.crm.entity.request.ReportcategoryRequest;
import microsoft.dynamics.crm.entity.request.RibbonmetadatatoprocessRequest;
import microsoft.dynamics.crm.entity.request.RoleRequest;
import microsoft.dynamics.crm.entity.request.RoleprivilegesRequest;
import microsoft.dynamics.crm.entity.request.RoletemplateRequest;
import microsoft.dynamics.crm.entity.request.RoletemplateprivilegesRequest;
import microsoft.dynamics.crm.entity.request.RollupfieldRequest;
import microsoft.dynamics.crm.entity.request.RuntimedependencyRequest;
import microsoft.dynamics.crm.entity.request.SavedqueryRequest;
import microsoft.dynamics.crm.entity.request.SavedqueryvisualizationRequest;
import microsoft.dynamics.crm.entity.request.SdkmessageRequest;
import microsoft.dynamics.crm.entity.request.SdkmessagefilterRequest;
import microsoft.dynamics.crm.entity.request.SdkmessageprocessingstepRequest;
import microsoft.dynamics.crm.entity.request.SdkmessageprocessingstepimageRequest;
import microsoft.dynamics.crm.entity.request.SdkmessageprocessingstepsecureconfigRequest;
import microsoft.dynamics.crm.entity.request.SemiannualfiscalcalendarRequest;
import microsoft.dynamics.crm.entity.request.ServiceendpointRequest;
import microsoft.dynamics.crm.entity.request.ServiceplanRequest;
import microsoft.dynamics.crm.entity.request.ServiceplanappmodulesRequest;
import microsoft.dynamics.crm.entity.request.SharepointdocumentlocationRequest;
import microsoft.dynamics.crm.entity.request.SharepointsiteRequest;
import microsoft.dynamics.crm.entity.request.SimilarityruleRequest;
import microsoft.dynamics.crm.entity.request.SitemapRequest;
import microsoft.dynamics.crm.entity.request.SlaRequest;
import microsoft.dynamics.crm.entity.request.SlaitemRequest;
import microsoft.dynamics.crm.entity.request.SlakpiinstanceRequest;
import microsoft.dynamics.crm.entity.request.SocialactivityRequest;
import microsoft.dynamics.crm.entity.request.SocialprofileRequest;
import microsoft.dynamics.crm.entity.request.SolutionRequest;
import microsoft.dynamics.crm.entity.request.SolutioncomponentRequest;
import microsoft.dynamics.crm.entity.request.SolutioncomponentattributeconfigurationRequest;
import microsoft.dynamics.crm.entity.request.SolutioncomponentconfigurationRequest;
import microsoft.dynamics.crm.entity.request.SolutioncomponentrelationshipconfigurationRequest;
import microsoft.dynamics.crm.entity.request.SolutionhistorydataRequest;
import microsoft.dynamics.crm.entity.request.StagesolutionuploadRequest;
import microsoft.dynamics.crm.entity.request.SubjectRequest;
import microsoft.dynamics.crm.entity.request.SubscriptionmanuallytrackedobjectRequest;
import microsoft.dynamics.crm.entity.request.SubscriptionstatisticsofflineRequest;
import microsoft.dynamics.crm.entity.request.SubscriptionstatisticsoutlookRequest;
import microsoft.dynamics.crm.entity.request.SubscriptionsyncentryofflineRequest;
import microsoft.dynamics.crm.entity.request.SubscriptionsyncentryoutlookRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;
import microsoft.dynamics.crm.entity.request.SystemformRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.SystemuserlicensesRequest;
import microsoft.dynamics.crm.entity.request.SystemuserprofilesRequest;
import microsoft.dynamics.crm.entity.request.SystemuserrolesRequest;
import microsoft.dynamics.crm.entity.request.SystemusersyncmappingprofilesRequest;
import microsoft.dynamics.crm.entity.request.TaskRequest;
import microsoft.dynamics.crm.entity.request.TeamRequest;
import microsoft.dynamics.crm.entity.request.TeammembershipRequest;
import microsoft.dynamics.crm.entity.request.TeamprofilesRequest;
import microsoft.dynamics.crm.entity.request.TeamrolesRequest;
import microsoft.dynamics.crm.entity.request.TeamsyncattributemappingprofilesRequest;
import microsoft.dynamics.crm.entity.request.TeamtemplateRequest;
import microsoft.dynamics.crm.entity.request.TemplateRequest;
import microsoft.dynamics.crm.entity.request.TerritoryRequest;
import microsoft.dynamics.crm.entity.request.ThemeRequest;
import microsoft.dynamics.crm.entity.request.TimestampdatemappingRequest;
import microsoft.dynamics.crm.entity.request.TimezonedefinitionRequest;
import microsoft.dynamics.crm.entity.request.TimezonelocalizednameRequest;
import microsoft.dynamics.crm.entity.request.TimezoneruleRequest;
import microsoft.dynamics.crm.entity.request.TracelogRequest;
import microsoft.dynamics.crm.entity.request.TransactioncurrencyRequest;
import microsoft.dynamics.crm.entity.request.TransformationmappingRequest;
import microsoft.dynamics.crm.entity.request.TransformationparametermappingRequest;
import microsoft.dynamics.crm.entity.request.TranslationprocessRequest;
import microsoft.dynamics.crm.entity.request.UserformRequest;
import microsoft.dynamics.crm.entity.request.UsermappingRequest;
import microsoft.dynamics.crm.entity.request.UserqueryRequest;
import microsoft.dynamics.crm.entity.request.UserqueryvisualizationRequest;
import microsoft.dynamics.crm.entity.request.UsersettingsRequest;
import microsoft.dynamics.crm.entity.request.WebresourceRequest;
import microsoft.dynamics.crm.entity.request.WebwizardRequest;
import microsoft.dynamics.crm.entity.request.WorkflowRequest;
import microsoft.dynamics.crm.entity.request.WorkflowbinaryRequest;
import microsoft.dynamics.crm.entity.request.WorkflowlogRequest;
import microsoft.dynamics.crm.entity.set.Accounts;
import microsoft.dynamics.crm.entity.set.Aciviewmappers;
import microsoft.dynamics.crm.entity.set.Actioncards;
import microsoft.dynamics.crm.entity.set.Actioncarduserstates;
import microsoft.dynamics.crm.entity.set.Activitymimeattachments;
import microsoft.dynamics.crm.entity.set.Activityparties;
import microsoft.dynamics.crm.entity.set.Activitypointers;
import microsoft.dynamics.crm.entity.set.Annotations;
import microsoft.dynamics.crm.entity.set.Annualfiscalcalendars;
import microsoft.dynamics.crm.entity.set.Appconfiginstances;
import microsoft.dynamics.crm.entity.set.Appconfigmasters;
import microsoft.dynamics.crm.entity.set.Appconfigs;
import microsoft.dynamics.crm.entity.set.Applicationuserroleset;
import microsoft.dynamics.crm.entity.set.Applicationusers;
import microsoft.dynamics.crm.entity.set.Appmodulecomponents;
import microsoft.dynamics.crm.entity.set.Appmodulerolescollection;
import microsoft.dynamics.crm.entity.set.Appmodules;
import microsoft.dynamics.crm.entity.set.Appointments;
import microsoft.dynamics.crm.entity.set.Asyncoperations;
import microsoft.dynamics.crm.entity.set.Attachments;
import microsoft.dynamics.crm.entity.set.Attributeimageconfigs;
import microsoft.dynamics.crm.entity.set.Attributes;
import microsoft.dynamics.crm.entity.set.Audits;
import microsoft.dynamics.crm.entity.set.Bulkdeletefailures;
import microsoft.dynamics.crm.entity.set.Bulkdeleteoperations;
import microsoft.dynamics.crm.entity.set.Businessunitnewsarticles;
import microsoft.dynamics.crm.entity.set.Businessunits;
import microsoft.dynamics.crm.entity.set.Calendarrules;
import microsoft.dynamics.crm.entity.set.Calendars;
import microsoft.dynamics.crm.entity.set.Callbackregistrations;
import microsoft.dynamics.crm.entity.set.Canvasapps;
import microsoft.dynamics.crm.entity.set.Cascadegrantrevokeaccessrecordstrackers;
import microsoft.dynamics.crm.entity.set.Cascadegrantrevokeaccessversiontrackers;
import microsoft.dynamics.crm.entity.set.Categories;
import microsoft.dynamics.crm.entity.set.Channelaccessprofileentityaccesslevels;
import microsoft.dynamics.crm.entity.set.Columnmappings;
import microsoft.dynamics.crm.entity.set.Complexcontrols;
import microsoft.dynamics.crm.entity.set.Connectionreferences;
import microsoft.dynamics.crm.entity.set.Connectionroleassociations;
import microsoft.dynamics.crm.entity.set.Connectionroles;
import microsoft.dynamics.crm.entity.set.Connections;
import microsoft.dynamics.crm.entity.set.Connectors;
import microsoft.dynamics.crm.entity.set.Contacts;
import microsoft.dynamics.crm.entity.set.Customcontroldefaultconfigs;
import microsoft.dynamics.crm.entity.set.Customcontrolresources;
import microsoft.dynamics.crm.entity.set.Customcontrols;
import microsoft.dynamics.crm.entity.set.Customeraddresses;
import microsoft.dynamics.crm.entity.set.Datalakeworkspacepermissions;
import microsoft.dynamics.crm.entity.set.Datalakeworkspaces;
import microsoft.dynamics.crm.entity.set.Dataperformances;
import microsoft.dynamics.crm.entity.set.Dependencies;
import microsoft.dynamics.crm.entity.set.Displaystrings;
import microsoft.dynamics.crm.entity.set.Documenttemplates;
import microsoft.dynamics.crm.entity.set.Duplicaterecords;
import microsoft.dynamics.crm.entity.set.Duplicateruleconditions;
import microsoft.dynamics.crm.entity.set.Duplicaterules;
import microsoft.dynamics.crm.entity.set.Emails;
import microsoft.dynamics.crm.entity.set.Emailserverprofiles;
import microsoft.dynamics.crm.entity.set.Entities;
import microsoft.dynamics.crm.entity.set.EntityDefinitions;
import microsoft.dynamics.crm.entity.set.Entityanalyticsconfigs;
import microsoft.dynamics.crm.entity.set.Entitydataproviders;
import microsoft.dynamics.crm.entity.set.Entityimageconfigs;
import microsoft.dynamics.crm.entity.set.Entitykeys;
import microsoft.dynamics.crm.entity.set.Entityrelationships;
import microsoft.dynamics.crm.entity.set.Environmentvariabledefinitions;
import microsoft.dynamics.crm.entity.set.Environmentvariablevalues;
import microsoft.dynamics.crm.entity.set.Exchangesyncidmappings;
import microsoft.dynamics.crm.entity.set.Expiredprocesses;
import microsoft.dynamics.crm.entity.set.Exportsolutionuploads;
import microsoft.dynamics.crm.entity.set.Faxes;
import microsoft.dynamics.crm.entity.set.Feedback;
import microsoft.dynamics.crm.entity.set.Fieldpermissions;
import microsoft.dynamics.crm.entity.set.Fieldsecurityprofiles;
import microsoft.dynamics.crm.entity.set.Fileattachments;
import microsoft.dynamics.crm.entity.set.Fixedmonthlyfiscalcalendars;
import microsoft.dynamics.crm.entity.set.Flowsessions;
import microsoft.dynamics.crm.entity.set.Ggw_crews;
import microsoft.dynamics.crm.entity.set.Ggw_events;
import microsoft.dynamics.crm.entity.set.Ggw_ggw_crew_ggw_teamset;
import microsoft.dynamics.crm.entity.set.Ggw_team_applications;
import microsoft.dynamics.crm.entity.set.Ggw_teams;
import microsoft.dynamics.crm.entity.set.GlobalOptionSetDefinitions;
import microsoft.dynamics.crm.entity.set.Goalrollupqueries;
import microsoft.dynamics.crm.entity.set.Goals;
import microsoft.dynamics.crm.entity.set.Importdataset;
import microsoft.dynamics.crm.entity.set.Importentitymappings;
import microsoft.dynamics.crm.entity.set.Importfiles;
import microsoft.dynamics.crm.entity.set.Importjobs;
import microsoft.dynamics.crm.entity.set.Importlogs;
import microsoft.dynamics.crm.entity.set.Importmaps;
import microsoft.dynamics.crm.entity.set.Imports;
import microsoft.dynamics.crm.entity.set.Interactionforemails;
import microsoft.dynamics.crm.entity.set.Invaliddependencies;
import microsoft.dynamics.crm.entity.set.Kbarticlecomments;
import microsoft.dynamics.crm.entity.set.Kbarticles;
import microsoft.dynamics.crm.entity.set.Kbarticletemplates;
import microsoft.dynamics.crm.entity.set.Knowledgearticlecategories;
import microsoft.dynamics.crm.entity.set.Knowledgearticles;
import microsoft.dynamics.crm.entity.set.Knowledgearticleviews;
import microsoft.dynamics.crm.entity.set.Knowledgebaserecords;
import microsoft.dynamics.crm.entity.set.Languagelocale;
import microsoft.dynamics.crm.entity.set.Languageprovisioningstates;
import microsoft.dynamics.crm.entity.set.Letters;
import microsoft.dynamics.crm.entity.set.Lookupmappings;
import microsoft.dynamics.crm.entity.set.Mailboxes;
import microsoft.dynamics.crm.entity.set.Mailboxtrackingfolders;
import microsoft.dynamics.crm.entity.set.Mailmergetemplates;
import microsoft.dynamics.crm.entity.set.ManagedPropertyDefinitions;
import microsoft.dynamics.crm.entity.set.Managedproperties;
import microsoft.dynamics.crm.entity.set.Metrics;
import microsoft.dynamics.crm.entity.set.Mobileofflineprofileitemassociations;
import microsoft.dynamics.crm.entity.set.Mobileofflineprofileitems;
import microsoft.dynamics.crm.entity.set.Mobileofflineprofiles;
import microsoft.dynamics.crm.entity.set.Monthlyfiscalcalendars;
import microsoft.dynamics.crm.entity.set.Msdyn_aibdatasetfiles;
import microsoft.dynamics.crm.entity.set.Msdyn_aibdatasetrecords;
import microsoft.dynamics.crm.entity.set.Msdyn_aibdatasets;
import microsoft.dynamics.crm.entity.set.Msdyn_aibdatasetscontainers;
import microsoft.dynamics.crm.entity.set.Msdyn_aibfileattacheddatas;
import microsoft.dynamics.crm.entity.set.Msdyn_aibfiles;
import microsoft.dynamics.crm.entity.set.Msdyn_aiconfigurations;
import microsoft.dynamics.crm.entity.set.Msdyn_aifptrainingdocuments;
import microsoft.dynamics.crm.entity.set.Msdyn_aimodels;
import microsoft.dynamics.crm.entity.set.Msdyn_aiodimages;
import microsoft.dynamics.crm.entity.set.Msdyn_aiodlabel_msdyn_aiconfigurationset;
import microsoft.dynamics.crm.entity.set.Msdyn_aiodlabels;
import microsoft.dynamics.crm.entity.set.Msdyn_aiodtrainingboundingboxes;
import microsoft.dynamics.crm.entity.set.Msdyn_aiodtrainingimages;
import microsoft.dynamics.crm.entity.set.Msdyn_aitemplates;
import microsoft.dynamics.crm.entity.set.Msdyn_analysiscomponents;
import microsoft.dynamics.crm.entity.set.Msdyn_analysisjobs;
import microsoft.dynamics.crm.entity.set.Msdyn_analysisresultdetails;
import microsoft.dynamics.crm.entity.set.Msdyn_analysisresults;
import microsoft.dynamics.crm.entity.set.Msdyn_componentlayerdatasources;
import microsoft.dynamics.crm.entity.set.Msdyn_componentlayers;
import microsoft.dynamics.crm.entity.set.Msdyn_dataflows;
import microsoft.dynamics.crm.entity.set.Msdyn_helppages;
import microsoft.dynamics.crm.entity.set.Msdyn_knowledgearticleimages;
import microsoft.dynamics.crm.entity.set.Msdyn_knowledgearticletemplates;
import microsoft.dynamics.crm.entity.set.Msdyn_nonrelationaldses;
import microsoft.dynamics.crm.entity.set.Msdyn_odatav4ds;
import microsoft.dynamics.crm.entity.set.Msdyn_richtextfiles;
import microsoft.dynamics.crm.entity.set.Msdyn_serviceconfigurations;
import microsoft.dynamics.crm.entity.set.Msdyn_slakpis;
import microsoft.dynamics.crm.entity.set.Msdyn_solutioncomponentdatasources;
import microsoft.dynamics.crm.entity.set.Msdyn_solutioncomponentsummaries;
import microsoft.dynamics.crm.entity.set.Msdyn_solutionhealthrulearguments;
import microsoft.dynamics.crm.entity.set.Msdyn_solutionhealthrules;
import microsoft.dynamics.crm.entity.set.Msdyn_solutionhealthrulesets;
import microsoft.dynamics.crm.entity.set.Msdyn_solutionhistories;
import microsoft.dynamics.crm.entity.set.Msdyn_solutionhistorydatasources;
import microsoft.dynamics.crm.entity.set.Navigationsettings;
import microsoft.dynamics.crm.entity.set.Newprocesses;
import microsoft.dynamics.crm.entity.set.Officegraphdocuments;
import microsoft.dynamics.crm.entity.set.Optionsets;
import microsoft.dynamics.crm.entity.set.Organizations;
import microsoft.dynamics.crm.entity.set.Ownermappings;
import microsoft.dynamics.crm.entity.set.Personaldocumenttemplates;
import microsoft.dynamics.crm.entity.set.Phonecalls;
import microsoft.dynamics.crm.entity.set.Picklistmappings;
import microsoft.dynamics.crm.entity.set.Pluginassemblies;
import microsoft.dynamics.crm.entity.set.Plugintracelogs;
import microsoft.dynamics.crm.entity.set.Plugintypes;
import microsoft.dynamics.crm.entity.set.Plugintypestatistics;
import microsoft.dynamics.crm.entity.set.Positions;
import microsoft.dynamics.crm.entity.set.Postcomments;
import microsoft.dynamics.crm.entity.set.Postfollows;
import microsoft.dynamics.crm.entity.set.Postlikes;
import microsoft.dynamics.crm.entity.set.Postregardings;
import microsoft.dynamics.crm.entity.set.Posts;
import microsoft.dynamics.crm.entity.set.Principalentitymaps;
import microsoft.dynamics.crm.entity.set.Principalobjectaccessset;
import microsoft.dynamics.crm.entity.set.Principalobjectattributeaccessset;
import microsoft.dynamics.crm.entity.set.Privileges;
import microsoft.dynamics.crm.entity.set.Processsessions;
import microsoft.dynamics.crm.entity.set.Processstageparameters;
import microsoft.dynamics.crm.entity.set.Processstages;
import microsoft.dynamics.crm.entity.set.Processtriggers;
import microsoft.dynamics.crm.entity.set.Publisheraddresses;
import microsoft.dynamics.crm.entity.set.Publishers;
import microsoft.dynamics.crm.entity.set.Quarterlyfiscalcalendars;
import microsoft.dynamics.crm.entity.set.Queueitems;
import microsoft.dynamics.crm.entity.set.Queuememberships;
import microsoft.dynamics.crm.entity.set.Queues;
import microsoft.dynamics.crm.entity.set.Recommendeddocuments;
import microsoft.dynamics.crm.entity.set.Recurrencerules;
import microsoft.dynamics.crm.entity.set.Recurringappointmentmasters;
import microsoft.dynamics.crm.entity.set.RelationshipDefinitions;
import microsoft.dynamics.crm.entity.set.Relationshipattributes;
import microsoft.dynamics.crm.entity.set.Relationships;
import microsoft.dynamics.crm.entity.set.Reportcategories;
import microsoft.dynamics.crm.entity.set.Reports;
import microsoft.dynamics.crm.entity.set.Ribbonmetadatasettoprocess;
import microsoft.dynamics.crm.entity.set.Roleprivilegescollection;
import microsoft.dynamics.crm.entity.set.Roles;
import microsoft.dynamics.crm.entity.set.Roletemplateprivilegescollection;
import microsoft.dynamics.crm.entity.set.Roletemplates;
import microsoft.dynamics.crm.entity.set.Rollupfields;
import microsoft.dynamics.crm.entity.set.Runtimedependencies;
import microsoft.dynamics.crm.entity.set.Savedqueries;
import microsoft.dynamics.crm.entity.set.Savedqueryvisualizations;
import microsoft.dynamics.crm.entity.set.Sdkmessagefilters;
import microsoft.dynamics.crm.entity.set.Sdkmessageprocessingstepimages;
import microsoft.dynamics.crm.entity.set.Sdkmessageprocessingsteps;
import microsoft.dynamics.crm.entity.set.Sdkmessageprocessingstepsecureconfigs;
import microsoft.dynamics.crm.entity.set.Sdkmessages;
import microsoft.dynamics.crm.entity.set.Semiannualfiscalcalendars;
import microsoft.dynamics.crm.entity.set.Serviceendpoints;
import microsoft.dynamics.crm.entity.set.Serviceplanappmodulesset;
import microsoft.dynamics.crm.entity.set.Serviceplans;
import microsoft.dynamics.crm.entity.set.Sharepointdocumentlocations;
import microsoft.dynamics.crm.entity.set.Sharepointsites;
import microsoft.dynamics.crm.entity.set.Similarityrules;
import microsoft.dynamics.crm.entity.set.Sitemaps;
import microsoft.dynamics.crm.entity.set.Slaitems;
import microsoft.dynamics.crm.entity.set.Slakpiinstances;
import microsoft.dynamics.crm.entity.set.Slas;
import microsoft.dynamics.crm.entity.set.Socialactivities;
import microsoft.dynamics.crm.entity.set.Socialprofiles;
import microsoft.dynamics.crm.entity.set.Solutioncomponentattributeconfigurations;
import microsoft.dynamics.crm.entity.set.Solutioncomponentconfigurations;
import microsoft.dynamics.crm.entity.set.Solutioncomponentrelationshipconfigurations;
import microsoft.dynamics.crm.entity.set.Solutioncomponents;
import microsoft.dynamics.crm.entity.set.Solutionhistories;
import microsoft.dynamics.crm.entity.set.Solutions;
import microsoft.dynamics.crm.entity.set.Stagesolutionuploads;
import microsoft.dynamics.crm.entity.set.Subjects;
import microsoft.dynamics.crm.entity.set.Subscriptionmanuallytrackedobjects;
import microsoft.dynamics.crm.entity.set.Subscriptionstatisticsofflineset;
import microsoft.dynamics.crm.entity.set.Subscriptionstatisticsoutlookset;
import microsoft.dynamics.crm.entity.set.Subscriptionsyncentriesoffline;
import microsoft.dynamics.crm.entity.set.Subscriptionsyncentriesoutlook;
import microsoft.dynamics.crm.entity.set.Syncerrors;
import microsoft.dynamics.crm.entity.set.Systemforms;
import microsoft.dynamics.crm.entity.set.Systemuserlicensescollection;
import microsoft.dynamics.crm.entity.set.Systemuserprofilescollection;
import microsoft.dynamics.crm.entity.set.Systemuserrolescollection;
import microsoft.dynamics.crm.entity.set.Systemusers;
import microsoft.dynamics.crm.entity.set.Systemusersyncmappingprofilescollection;
import microsoft.dynamics.crm.entity.set.Tasks;
import microsoft.dynamics.crm.entity.set.Teammemberships;
import microsoft.dynamics.crm.entity.set.Teamprofilescollection;
import microsoft.dynamics.crm.entity.set.Teamrolescollection;
import microsoft.dynamics.crm.entity.set.Teams;
import microsoft.dynamics.crm.entity.set.Teamsyncattributemappingprofilescollection;
import microsoft.dynamics.crm.entity.set.Teamtemplates;
import microsoft.dynamics.crm.entity.set.Templates;
import microsoft.dynamics.crm.entity.set.Territories;
import microsoft.dynamics.crm.entity.set.Themes;
import microsoft.dynamics.crm.entity.set.Timestampdatemappings;
import microsoft.dynamics.crm.entity.set.Timezonedefinitions;
import microsoft.dynamics.crm.entity.set.Timezonelocalizednames;
import microsoft.dynamics.crm.entity.set.Timezonerules;
import microsoft.dynamics.crm.entity.set.Tracelogs;
import microsoft.dynamics.crm.entity.set.Transactioncurrencies;
import microsoft.dynamics.crm.entity.set.Transformationmappings;
import microsoft.dynamics.crm.entity.set.Transformationparametermappings;
import microsoft.dynamics.crm.entity.set.Translationprocesses;
import microsoft.dynamics.crm.entity.set.Userforms;
import microsoft.dynamics.crm.entity.set.Usermappings;
import microsoft.dynamics.crm.entity.set.Userqueries;
import microsoft.dynamics.crm.entity.set.Userqueryvisualizations;
import microsoft.dynamics.crm.entity.set.Usersettingscollection;
import microsoft.dynamics.crm.entity.set.Webresourceset;
import microsoft.dynamics.crm.entity.set.Webwizards;
import microsoft.dynamics.crm.entity.set.Workflowbinaries;
import microsoft.dynamics.crm.entity.set.Workflowlogs;
import microsoft.dynamics.crm.entity.set.Workflows;
import microsoft.dynamics.crm.enums.DeletedMetadataFilters;
import microsoft.dynamics.crm.enums.EndpointAccessType;
import microsoft.dynamics.crm.enums.EntityFilters;
import microsoft.dynamics.crm.enums.RibbonLocationFilters;
import microsoft.dynamics.crm.enums.RollupType;
import microsoft.dynamics.crm.enums.TargetFieldType;
import microsoft.dynamics.crm.enums.TimeCode;

public final class System implements HasContext {

    private final ContextPath contextPath;

    public System(Context context) {
        this.contextPath = new ContextPath(context, context.service().getBasePath());
    }

    @Override
    public Context _context() {
        return contextPath.context();
    }

    public HttpService _service() {
        return contextPath.context().service();
    }

    static final class ContainerBuilderImpl extends ContainerBuilder<System> {

        @Override
        public System _create(Context context) {
            return new System(context);
        }
    }

    public static BuilderBase<ContainerBuilder<System>, System> test() {
        return new ContainerBuilderImpl();
    }

    public AccountRequest accounts(UUID accountid) {
        return new AccountRequest(contextPath.addSegment("accounts").addKeys(new NameValue(accountid, UUID.class)), Optional.empty());
    }

    public Accounts accounts() {
        return new Accounts(
                        contextPath.addSegment("accounts"));
    }

    public AciviewmapperRequest aciviewmappers(UUID aciviewmapperid) {
        return new AciviewmapperRequest(contextPath.addSegment("aciviewmappers").addKeys(new NameValue(aciviewmapperid, UUID.class)), Optional.empty());
    }

    public Aciviewmappers aciviewmappers() {
        return new Aciviewmappers(
                        contextPath.addSegment("aciviewmappers"));
    }

    public ActioncardRequest actioncards(UUID actioncardid) {
        return new ActioncardRequest(contextPath.addSegment("actioncards").addKeys(new NameValue(actioncardid, UUID.class)), Optional.empty());
    }

    public Actioncards actioncards() {
        return new Actioncards(
                        contextPath.addSegment("actioncards"));
    }

    public ActioncarduserstateRequest actioncarduserstates(UUID actioncarduserstateid) {
        return new ActioncarduserstateRequest(contextPath.addSegment("actioncarduserstates").addKeys(new NameValue(actioncarduserstateid, UUID.class)), Optional.empty());
    }

    public Actioncarduserstates actioncarduserstates() {
        return new Actioncarduserstates(
                        contextPath.addSegment("actioncarduserstates"));
    }

    public ActivitymimeattachmentRequest activitymimeattachments(UUID activitymimeattachmentid) {
        return new ActivitymimeattachmentRequest(contextPath.addSegment("activitymimeattachments").addKeys(new NameValue(activitymimeattachmentid, UUID.class)), Optional.empty());
    }

    public Activitymimeattachments activitymimeattachments() {
        return new Activitymimeattachments(
                        contextPath.addSegment("activitymimeattachments"));
    }

    public ActivitypartyRequest activityparties(UUID activitypartyid) {
        return new ActivitypartyRequest(contextPath.addSegment("activityparties").addKeys(new NameValue(activitypartyid, UUID.class)), Optional.empty());
    }

    public Activityparties activityparties() {
        return new Activityparties(
                        contextPath.addSegment("activityparties"));
    }

    public ActivitypointerRequest activitypointers(UUID activityid) {
        return new ActivitypointerRequest(contextPath.addSegment("activitypointers").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public Activitypointers activitypointers() {
        return new Activitypointers(
                        contextPath.addSegment("activitypointers"));
    }

    public AnnotationRequest annotations(UUID annotationid) {
        return new AnnotationRequest(contextPath.addSegment("annotations").addKeys(new NameValue(annotationid, UUID.class)), Optional.empty());
    }

    public Annotations annotations() {
        return new Annotations(
                        contextPath.addSegment("annotations"));
    }

    public AnnualfiscalcalendarRequest annualfiscalcalendars(UUID userfiscalcalendarid) {
        return new AnnualfiscalcalendarRequest(contextPath.addSegment("annualfiscalcalendars").addKeys(new NameValue(userfiscalcalendarid, UUID.class)), Optional.empty());
    }

    public Annualfiscalcalendars annualfiscalcalendars() {
        return new Annualfiscalcalendars(
                        contextPath.addSegment("annualfiscalcalendars"));
    }

    public AppconfiginstanceRequest appconfiginstances(UUID appconfiginstanceid) {
        return new AppconfiginstanceRequest(contextPath.addSegment("appconfiginstances").addKeys(new NameValue(appconfiginstanceid, UUID.class)), Optional.empty());
    }

    public Appconfiginstances appconfiginstances() {
        return new Appconfiginstances(
                        contextPath.addSegment("appconfiginstances"));
    }

    public AppconfigmasterRequest appconfigmasters(UUID appconfigmasterid) {
        return new AppconfigmasterRequest(contextPath.addSegment("appconfigmasters").addKeys(new NameValue(appconfigmasterid, UUID.class)), Optional.empty());
    }

    public Appconfigmasters appconfigmasters() {
        return new Appconfigmasters(
                        contextPath.addSegment("appconfigmasters"));
    }

    public AppconfigRequest appconfigs(UUID appconfigid) {
        return new AppconfigRequest(contextPath.addSegment("appconfigs").addKeys(new NameValue(appconfigid, UUID.class)), Optional.empty());
    }

    public Appconfigs appconfigs() {
        return new Appconfigs(
                        contextPath.addSegment("appconfigs"));
    }

    public ApplicationuserroleRequest applicationuserroleset(UUID applicationuserroleid) {
        return new ApplicationuserroleRequest(contextPath.addSegment("applicationuserroleset").addKeys(new NameValue(applicationuserroleid, UUID.class)), Optional.empty());
    }

    public Applicationuserroleset applicationuserroleset() {
        return new Applicationuserroleset(
                        contextPath.addSegment("applicationuserroleset"));
    }

    public ApplicationuserRequest applicationusers(UUID applicationuserid) {
        return new ApplicationuserRequest(contextPath.addSegment("applicationusers").addKeys(new NameValue(applicationuserid, UUID.class)), Optional.empty());
    }

    public Applicationusers applicationusers() {
        return new Applicationusers(
                        contextPath.addSegment("applicationusers"));
    }

    public AppmodulecomponentRequest appmodulecomponents(UUID appmodulecomponentid) {
        return new AppmodulecomponentRequest(contextPath.addSegment("appmodulecomponents").addKeys(new NameValue(appmodulecomponentid, UUID.class)), Optional.empty());
    }

    public Appmodulecomponents appmodulecomponents() {
        return new Appmodulecomponents(
                        contextPath.addSegment("appmodulecomponents"));
    }

    public AppmodulerolesRequest appmodulerolescollection(UUID appmoduleroleid) {
        return new AppmodulerolesRequest(contextPath.addSegment("appmodulerolescollection").addKeys(new NameValue(appmoduleroleid, UUID.class)), Optional.empty());
    }

    public Appmodulerolescollection appmodulerolescollection() {
        return new Appmodulerolescollection(
                        contextPath.addSegment("appmodulerolescollection"));
    }

    public AppmoduleRequest appmodules(UUID appmoduleid) {
        return new AppmoduleRequest(contextPath.addSegment("appmodules").addKeys(new NameValue(appmoduleid, UUID.class)), Optional.empty());
    }

    public Appmodules appmodules() {
        return new Appmodules(
                        contextPath.addSegment("appmodules"));
    }

    public AppointmentRequest appointments(UUID activityid) {
        return new AppointmentRequest(contextPath.addSegment("appointments").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public Appointments appointments() {
        return new Appointments(
                        contextPath.addSegment("appointments"));
    }

    public AsyncoperationRequest asyncoperations(UUID asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("asyncoperations").addKeys(new NameValue(asyncoperationid, UUID.class)), Optional.empty());
    }

    public Asyncoperations asyncoperations() {
        return new Asyncoperations(
                        contextPath.addSegment("asyncoperations"));
    }

    public AttachmentRequest attachments(UUID attachmentid) {
        return new AttachmentRequest(contextPath.addSegment("attachments").addKeys(new NameValue(attachmentid, UUID.class)), Optional.empty());
    }

    public Attachments attachments() {
        return new Attachments(
                        contextPath.addSegment("attachments"));
    }

    public AttributeimageconfigRequest attributeimageconfigs(UUID attributeimageconfigid) {
        return new AttributeimageconfigRequest(contextPath.addSegment("attributeimageconfigs").addKeys(new NameValue(attributeimageconfigid, UUID.class)), Optional.empty());
    }

    public Attributeimageconfigs attributeimageconfigs() {
        return new Attributeimageconfigs(
                        contextPath.addSegment("attributeimageconfigs"));
    }

    public AttributeRequest attributes(UUID attributeid) {
        return new AttributeRequest(contextPath.addSegment("attributes").addKeys(new NameValue(attributeid, UUID.class)), Optional.empty());
    }

    public Attributes attributes() {
        return new Attributes(
                        contextPath.addSegment("attributes"));
    }

    public AuditRequest audits(UUID auditid) {
        return new AuditRequest(contextPath.addSegment("audits").addKeys(new NameValue(auditid, UUID.class)), Optional.empty());
    }

    public Audits audits() {
        return new Audits(
                        contextPath.addSegment("audits"));
    }

    public BulkdeletefailureRequest bulkdeletefailures(UUID bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("bulkdeletefailures").addKeys(new NameValue(bulkdeletefailureid, UUID.class)), Optional.empty());
    }

    public Bulkdeletefailures bulkdeletefailures() {
        return new Bulkdeletefailures(
                        contextPath.addSegment("bulkdeletefailures"));
    }

    public BulkdeleteoperationRequest bulkdeleteoperations(UUID bulkdeleteoperationid) {
        return new BulkdeleteoperationRequest(contextPath.addSegment("bulkdeleteoperations").addKeys(new NameValue(bulkdeleteoperationid, UUID.class)), Optional.empty());
    }

    public Bulkdeleteoperations bulkdeleteoperations() {
        return new Bulkdeleteoperations(
                        contextPath.addSegment("bulkdeleteoperations"));
    }

    public BusinessunitnewsarticleRequest businessunitnewsarticles(UUID businessunitnewsarticleid) {
        return new BusinessunitnewsarticleRequest(contextPath.addSegment("businessunitnewsarticles").addKeys(new NameValue(businessunitnewsarticleid, UUID.class)), Optional.empty());
    }

    public Businessunitnewsarticles businessunitnewsarticles() {
        return new Businessunitnewsarticles(
                        contextPath.addSegment("businessunitnewsarticles"));
    }

    public BusinessunitRequest businessunits(UUID businessunitid) {
        return new BusinessunitRequest(contextPath.addSegment("businessunits").addKeys(new NameValue(businessunitid, UUID.class)), Optional.empty());
    }

    public Businessunits businessunits() {
        return new Businessunits(
                        contextPath.addSegment("businessunits"));
    }

    public CalendarruleRequest calendarrules(UUID calendarruleid) {
        return new CalendarruleRequest(contextPath.addSegment("calendarrules").addKeys(new NameValue(calendarruleid, UUID.class)), Optional.empty());
    }

    public Calendarrules calendarrules() {
        return new Calendarrules(
                        contextPath.addSegment("calendarrules"));
    }

    public CalendarRequest calendars(UUID calendarid) {
        return new CalendarRequest(contextPath.addSegment("calendars").addKeys(new NameValue(calendarid, UUID.class)), Optional.empty());
    }

    public Calendars calendars() {
        return new Calendars(
                        contextPath.addSegment("calendars"));
    }

    public CallbackregistrationRequest callbackregistrations(UUID callbackregistrationid) {
        return new CallbackregistrationRequest(contextPath.addSegment("callbackregistrations").addKeys(new NameValue(callbackregistrationid, UUID.class)), Optional.empty());
    }

    public Callbackregistrations callbackregistrations() {
        return new Callbackregistrations(
                        contextPath.addSegment("callbackregistrations"));
    }

    public CanvasappRequest canvasapps(UUID canvasappid) {
        return new CanvasappRequest(contextPath.addSegment("canvasapps").addKeys(new NameValue(canvasappid, UUID.class)), Optional.empty());
    }

    public Canvasapps canvasapps() {
        return new Canvasapps(
                        contextPath.addSegment("canvasapps"));
    }

    public CascadegrantrevokeaccessrecordstrackerRequest cascadegrantrevokeaccessrecordstrackers(UUID cascadegrantrevokeaccessrecordstrackerid) {
        return new CascadegrantrevokeaccessrecordstrackerRequest(contextPath.addSegment("cascadegrantrevokeaccessrecordstrackers").addKeys(new NameValue(cascadegrantrevokeaccessrecordstrackerid, UUID.class)), Optional.empty());
    }

    public Cascadegrantrevokeaccessrecordstrackers cascadegrantrevokeaccessrecordstrackers() {
        return new Cascadegrantrevokeaccessrecordstrackers(
                        contextPath.addSegment("cascadegrantrevokeaccessrecordstrackers"));
    }

    public CascadegrantrevokeaccessversiontrackerRequest cascadegrantrevokeaccessversiontrackers(UUID cascadegrantrevokeaccessversiontrackerid) {
        return new CascadegrantrevokeaccessversiontrackerRequest(contextPath.addSegment("cascadegrantrevokeaccessversiontrackers").addKeys(new NameValue(cascadegrantrevokeaccessversiontrackerid, UUID.class)), Optional.empty());
    }

    public Cascadegrantrevokeaccessversiontrackers cascadegrantrevokeaccessversiontrackers() {
        return new Cascadegrantrevokeaccessversiontrackers(
                        contextPath.addSegment("cascadegrantrevokeaccessversiontrackers"));
    }

    public CategoryRequest categories(UUID categoryid) {
        return new CategoryRequest(contextPath.addSegment("categories").addKeys(new NameValue(categoryid, UUID.class)), Optional.empty());
    }

    public Categories categories() {
        return new Categories(
                        contextPath.addSegment("categories"));
    }

    public ChannelaccessprofileentityaccesslevelRequest channelaccessprofileentityaccesslevels(UUID channelaccessprofileentityaccesslevelid) {
        return new ChannelaccessprofileentityaccesslevelRequest(contextPath.addSegment("channelaccessprofileentityaccesslevels").addKeys(new NameValue(channelaccessprofileentityaccesslevelid, UUID.class)), Optional.empty());
    }

    public Channelaccessprofileentityaccesslevels channelaccessprofileentityaccesslevels() {
        return new Channelaccessprofileentityaccesslevels(
                        contextPath.addSegment("channelaccessprofileentityaccesslevels"));
    }

    public ColumnmappingRequest columnmappings(UUID columnmappingid) {
        return new ColumnmappingRequest(contextPath.addSegment("columnmappings").addKeys(new NameValue(columnmappingid, UUID.class)), Optional.empty());
    }

    public Columnmappings columnmappings() {
        return new Columnmappings(
                        contextPath.addSegment("columnmappings"));
    }

    public ComplexcontrolRequest complexcontrols(UUID complexcontrolid) {
        return new ComplexcontrolRequest(contextPath.addSegment("complexcontrols").addKeys(new NameValue(complexcontrolid, UUID.class)), Optional.empty());
    }

    public Complexcontrols complexcontrols() {
        return new Complexcontrols(
                        contextPath.addSegment("complexcontrols"));
    }

    public ConnectionreferenceRequest connectionreferences(UUID connectionreferenceid) {
        return new ConnectionreferenceRequest(contextPath.addSegment("connectionreferences").addKeys(new NameValue(connectionreferenceid, UUID.class)), Optional.empty());
    }

    public Connectionreferences connectionreferences() {
        return new Connectionreferences(
                        contextPath.addSegment("connectionreferences"));
    }

    public ConnectionroleassociationRequest connectionroleassociations(UUID connectionroleassociationid) {
        return new ConnectionroleassociationRequest(contextPath.addSegment("connectionroleassociations").addKeys(new NameValue(connectionroleassociationid, UUID.class)), Optional.empty());
    }

    public Connectionroleassociations connectionroleassociations() {
        return new Connectionroleassociations(
                        contextPath.addSegment("connectionroleassociations"));
    }

    public ConnectionroleRequest connectionroles(UUID connectionroleid) {
        return new ConnectionroleRequest(contextPath.addSegment("connectionroles").addKeys(new NameValue(connectionroleid, UUID.class)), Optional.empty());
    }

    public Connectionroles connectionroles() {
        return new Connectionroles(
                        contextPath.addSegment("connectionroles"));
    }

    public ConnectionRequest connections(UUID connectionid) {
        return new ConnectionRequest(contextPath.addSegment("connections").addKeys(new NameValue(connectionid, UUID.class)), Optional.empty());
    }

    public Connections connections() {
        return new Connections(
                        contextPath.addSegment("connections"));
    }

    public ConnectorRequest connectors(UUID connectorid) {
        return new ConnectorRequest(contextPath.addSegment("connectors").addKeys(new NameValue(connectorid, UUID.class)), Optional.empty());
    }

    public Connectors connectors() {
        return new Connectors(
                        contextPath.addSegment("connectors"));
    }

    public ContactRequest contacts(UUID contactid) {
        return new ContactRequest(contextPath.addSegment("contacts").addKeys(new NameValue(contactid, UUID.class)), Optional.empty());
    }

    public Contacts contacts() {
        return new Contacts(
                        contextPath.addSegment("contacts"));
    }

    public CustomcontroldefaultconfigRequest customcontroldefaultconfigs(UUID customcontroldefaultconfigid) {
        return new CustomcontroldefaultconfigRequest(contextPath.addSegment("customcontroldefaultconfigs").addKeys(new NameValue(customcontroldefaultconfigid, UUID.class)), Optional.empty());
    }

    public Customcontroldefaultconfigs customcontroldefaultconfigs() {
        return new Customcontroldefaultconfigs(
                        contextPath.addSegment("customcontroldefaultconfigs"));
    }

    public CustomcontrolresourceRequest customcontrolresources(UUID customcontrolresourceid) {
        return new CustomcontrolresourceRequest(contextPath.addSegment("customcontrolresources").addKeys(new NameValue(customcontrolresourceid, UUID.class)), Optional.empty());
    }

    public Customcontrolresources customcontrolresources() {
        return new Customcontrolresources(
                        contextPath.addSegment("customcontrolresources"));
    }

    public CustomcontrolRequest customcontrols(UUID customcontrolid) {
        return new CustomcontrolRequest(contextPath.addSegment("customcontrols").addKeys(new NameValue(customcontrolid, UUID.class)), Optional.empty());
    }

    public Customcontrols customcontrols() {
        return new Customcontrols(
                        contextPath.addSegment("customcontrols"));
    }

    public CustomeraddressRequest customeraddresses(UUID customeraddressid) {
        return new CustomeraddressRequest(contextPath.addSegment("customeraddresses").addKeys(new NameValue(customeraddressid, UUID.class)), Optional.empty());
    }

    public Customeraddresses customeraddresses() {
        return new Customeraddresses(
                        contextPath.addSegment("customeraddresses"));
    }

    public DatalakeworkspacepermissionRequest datalakeworkspacepermissions(UUID datalakeworkspacepermissionid) {
        return new DatalakeworkspacepermissionRequest(contextPath.addSegment("datalakeworkspacepermissions").addKeys(new NameValue(datalakeworkspacepermissionid, UUID.class)), Optional.empty());
    }

    public Datalakeworkspacepermissions datalakeworkspacepermissions() {
        return new Datalakeworkspacepermissions(
                        contextPath.addSegment("datalakeworkspacepermissions"));
    }

    public DatalakeworkspaceRequest datalakeworkspaces(UUID datalakeworkspaceid) {
        return new DatalakeworkspaceRequest(contextPath.addSegment("datalakeworkspaces").addKeys(new NameValue(datalakeworkspaceid, UUID.class)), Optional.empty());
    }

    public Datalakeworkspaces datalakeworkspaces() {
        return new Datalakeworkspaces(
                        contextPath.addSegment("datalakeworkspaces"));
    }

    public DataperformanceRequest dataperformances(UUID dataperformanceid) {
        return new DataperformanceRequest(contextPath.addSegment("dataperformances").addKeys(new NameValue(dataperformanceid, UUID.class)), Optional.empty());
    }

    public Dataperformances dataperformances() {
        return new Dataperformances(
                        contextPath.addSegment("dataperformances"));
    }

    public DependencyRequest dependencies(UUID dependencyid) {
        return new DependencyRequest(contextPath.addSegment("dependencies").addKeys(new NameValue(dependencyid, UUID.class)), Optional.empty());
    }

    public Dependencies dependencies() {
        return new Dependencies(
                        contextPath.addSegment("dependencies"));
    }

    public DisplaystringRequest displaystrings(UUID displaystringid) {
        return new DisplaystringRequest(contextPath.addSegment("displaystrings").addKeys(new NameValue(displaystringid, UUID.class)), Optional.empty());
    }

    public Displaystrings displaystrings() {
        return new Displaystrings(
                        contextPath.addSegment("displaystrings"));
    }

    public DocumenttemplateRequest documenttemplates(UUID documenttemplateid) {
        return new DocumenttemplateRequest(contextPath.addSegment("documenttemplates").addKeys(new NameValue(documenttemplateid, UUID.class)), Optional.empty());
    }

    public Documenttemplates documenttemplates() {
        return new Documenttemplates(
                        contextPath.addSegment("documenttemplates"));
    }

    public DuplicaterecordRequest duplicaterecords(UUID duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("duplicaterecords").addKeys(new NameValue(duplicateid, UUID.class)), Optional.empty());
    }

    public Duplicaterecords duplicaterecords() {
        return new Duplicaterecords(
                        contextPath.addSegment("duplicaterecords"));
    }

    public DuplicateruleconditionRequest duplicateruleconditions(UUID duplicateruleconditionid) {
        return new DuplicateruleconditionRequest(contextPath.addSegment("duplicateruleconditions").addKeys(new NameValue(duplicateruleconditionid, UUID.class)), Optional.empty());
    }

    public Duplicateruleconditions duplicateruleconditions() {
        return new Duplicateruleconditions(
                        contextPath.addSegment("duplicateruleconditions"));
    }

    public DuplicateruleRequest duplicaterules(UUID duplicateruleid) {
        return new DuplicateruleRequest(contextPath.addSegment("duplicaterules").addKeys(new NameValue(duplicateruleid, UUID.class)), Optional.empty());
    }

    public Duplicaterules duplicaterules() {
        return new Duplicaterules(
                        contextPath.addSegment("duplicaterules"));
    }

    public EmailRequest emails(UUID activityid) {
        return new EmailRequest(contextPath.addSegment("emails").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public Emails emails() {
        return new Emails(
                        contextPath.addSegment("emails"));
    }

    public EmailserverprofileRequest emailserverprofiles(UUID emailserverprofileid) {
        return new EmailserverprofileRequest(contextPath.addSegment("emailserverprofiles").addKeys(new NameValue(emailserverprofileid, UUID.class)), Optional.empty());
    }

    public Emailserverprofiles emailserverprofiles() {
        return new Emailserverprofiles(
                        contextPath.addSegment("emailserverprofiles"));
    }

    public EntityRequest entities(UUID entityid) {
        return new EntityRequest(contextPath.addSegment("entities").addKeys(new NameValue(entityid, UUID.class)), Optional.empty());
    }

    public Entities entities() {
        return new Entities(
                        contextPath.addSegment("entities"));
    }

    public EntityanalyticsconfigRequest entityanalyticsconfigs(UUID entityanalyticsconfigid) {
        return new EntityanalyticsconfigRequest(contextPath.addSegment("entityanalyticsconfigs").addKeys(new NameValue(entityanalyticsconfigid, UUID.class)), Optional.empty());
    }

    public Entityanalyticsconfigs entityanalyticsconfigs() {
        return new Entityanalyticsconfigs(
                        contextPath.addSegment("entityanalyticsconfigs"));
    }

    public EntitydataproviderRequest entitydataproviders(UUID entitydataproviderid) {
        return new EntitydataproviderRequest(contextPath.addSegment("entitydataproviders").addKeys(new NameValue(entitydataproviderid, UUID.class)), Optional.empty());
    }

    public Entitydataproviders entitydataproviders() {
        return new Entitydataproviders(
                        contextPath.addSegment("entitydataproviders"));
    }

    public EntityimageconfigRequest entityimageconfigs(UUID entityimageconfigid) {
        return new EntityimageconfigRequest(contextPath.addSegment("entityimageconfigs").addKeys(new NameValue(entityimageconfigid, UUID.class)), Optional.empty());
    }

    public Entityimageconfigs entityimageconfigs() {
        return new Entityimageconfigs(
                        contextPath.addSegment("entityimageconfigs"));
    }

    public EntitykeyRequest entitykeys(UUID entitykeyid) {
        return new EntitykeyRequest(contextPath.addSegment("entitykeys").addKeys(new NameValue(entitykeyid, UUID.class)), Optional.empty());
    }

    public Entitykeys entitykeys() {
        return new Entitykeys(
                        contextPath.addSegment("entitykeys"));
    }

    public EntityrelationshipRequest entityrelationships(UUID entityrelationshipid) {
        return new EntityrelationshipRequest(contextPath.addSegment("entityrelationships").addKeys(new NameValue(entityrelationshipid, UUID.class)), Optional.empty());
    }

    public Entityrelationships entityrelationships() {
        return new Entityrelationships(
                        contextPath.addSegment("entityrelationships"));
    }

    public EnvironmentvariabledefinitionRequest environmentvariabledefinitions(UUID environmentvariabledefinitionid) {
        return new EnvironmentvariabledefinitionRequest(contextPath.addSegment("environmentvariabledefinitions").addKeys(new NameValue(environmentvariabledefinitionid, UUID.class)), Optional.empty());
    }

    public Environmentvariabledefinitions environmentvariabledefinitions() {
        return new Environmentvariabledefinitions(
                        contextPath.addSegment("environmentvariabledefinitions"));
    }

    public EnvironmentvariablevalueRequest environmentvariablevalues(UUID environmentvariablevalueid) {
        return new EnvironmentvariablevalueRequest(contextPath.addSegment("environmentvariablevalues").addKeys(new NameValue(environmentvariablevalueid, UUID.class)), Optional.empty());
    }

    public Environmentvariablevalues environmentvariablevalues() {
        return new Environmentvariablevalues(
                        contextPath.addSegment("environmentvariablevalues"));
    }

    public ExchangesyncidmappingRequest exchangesyncidmappings(UUID exchangesyncidmappingid) {
        return new ExchangesyncidmappingRequest(contextPath.addSegment("exchangesyncidmappings").addKeys(new NameValue(exchangesyncidmappingid, UUID.class)), Optional.empty());
    }

    public Exchangesyncidmappings exchangesyncidmappings() {
        return new Exchangesyncidmappings(
                        contextPath.addSegment("exchangesyncidmappings"));
    }

    public ExpiredprocessRequest expiredprocesses(UUID businessprocessflowinstanceid) {
        return new ExpiredprocessRequest(contextPath.addSegment("expiredprocesses").addKeys(new NameValue(businessprocessflowinstanceid, UUID.class)), Optional.empty());
    }

    public Expiredprocesses expiredprocesses() {
        return new Expiredprocesses(
                        contextPath.addSegment("expiredprocesses"));
    }

    public ExportsolutionuploadRequest exportsolutionuploads(UUID exportsolutionuploadid) {
        return new ExportsolutionuploadRequest(contextPath.addSegment("exportsolutionuploads").addKeys(new NameValue(exportsolutionuploadid, UUID.class)), Optional.empty());
    }

    public Exportsolutionuploads exportsolutionuploads() {
        return new Exportsolutionuploads(
                        contextPath.addSegment("exportsolutionuploads"));
    }

    public FaxRequest faxes(UUID activityid) {
        return new FaxRequest(contextPath.addSegment("faxes").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public Faxes faxes() {
        return new Faxes(
                        contextPath.addSegment("faxes"));
    }

    public FeedbackRequest feedback(UUID feedbackid) {
        return new FeedbackRequest(contextPath.addSegment("feedback").addKeys(new NameValue(feedbackid, UUID.class)), Optional.empty());
    }

    public Feedback feedback() {
        return new Feedback(
                        contextPath.addSegment("feedback"));
    }

    public FieldpermissionRequest fieldpermissions(UUID fieldpermissionid) {
        return new FieldpermissionRequest(contextPath.addSegment("fieldpermissions").addKeys(new NameValue(fieldpermissionid, UUID.class)), Optional.empty());
    }

    public Fieldpermissions fieldpermissions() {
        return new Fieldpermissions(
                        contextPath.addSegment("fieldpermissions"));
    }

    public FieldsecurityprofileRequest fieldsecurityprofiles(UUID fieldsecurityprofileid) {
        return new FieldsecurityprofileRequest(contextPath.addSegment("fieldsecurityprofiles").addKeys(new NameValue(fieldsecurityprofileid, UUID.class)), Optional.empty());
    }

    public Fieldsecurityprofiles fieldsecurityprofiles() {
        return new Fieldsecurityprofiles(
                        contextPath.addSegment("fieldsecurityprofiles"));
    }

    public FileattachmentRequest fileattachments(UUID fileattachmentid) {
        return new FileattachmentRequest(contextPath.addSegment("fileattachments").addKeys(new NameValue(fileattachmentid, UUID.class)), Optional.empty());
    }

    public Fileattachments fileattachments() {
        return new Fileattachments(
                        contextPath.addSegment("fileattachments"));
    }

    public FixedmonthlyfiscalcalendarRequest fixedmonthlyfiscalcalendars(UUID userfiscalcalendarid) {
        return new FixedmonthlyfiscalcalendarRequest(contextPath.addSegment("fixedmonthlyfiscalcalendars").addKeys(new NameValue(userfiscalcalendarid, UUID.class)), Optional.empty());
    }

    public Fixedmonthlyfiscalcalendars fixedmonthlyfiscalcalendars() {
        return new Fixedmonthlyfiscalcalendars(
                        contextPath.addSegment("fixedmonthlyfiscalcalendars"));
    }

    public FlowsessionRequest flowsessions(UUID flowsessionid) {
        return new FlowsessionRequest(contextPath.addSegment("flowsessions").addKeys(new NameValue(flowsessionid, UUID.class)), Optional.empty());
    }

    public Flowsessions flowsessions() {
        return new Flowsessions(
                        contextPath.addSegment("flowsessions"));
    }

    public Ggw_crewRequest ggw_crews(UUID ggw_crewid) {
        return new Ggw_crewRequest(contextPath.addSegment("ggw_crews").addKeys(new NameValue(ggw_crewid, UUID.class)), Optional.empty());
    }

    public Ggw_crews ggw_crews() {
        return new Ggw_crews(
                        contextPath.addSegment("ggw_crews"));
    }

    public Ggw_eventRequest ggw_events(UUID ggw_eventid) {
        return new Ggw_eventRequest(contextPath.addSegment("ggw_events").addKeys(new NameValue(ggw_eventid, UUID.class)), Optional.empty());
    }

    public Ggw_events ggw_events() {
        return new Ggw_events(
                        contextPath.addSegment("ggw_events"));
    }

    public Ggw_ggw_crew_ggw_teamRequest ggw_ggw_crew_ggw_teamset(UUID ggw_ggw_crew_ggw_teamid) {
        return new Ggw_ggw_crew_ggw_teamRequest(contextPath.addSegment("ggw_ggw_crew_ggw_teamset").addKeys(new NameValue(ggw_ggw_crew_ggw_teamid, UUID.class)), Optional.empty());
    }

    public Ggw_ggw_crew_ggw_teamset ggw_ggw_crew_ggw_teamset() {
        return new Ggw_ggw_crew_ggw_teamset(
                        contextPath.addSegment("ggw_ggw_crew_ggw_teamset"));
    }

    public Ggw_team_applicationRequest ggw_team_applications(UUID ggw_team_applicationid) {
        return new Ggw_team_applicationRequest(contextPath.addSegment("ggw_team_applications").addKeys(new NameValue(ggw_team_applicationid, UUID.class)), Optional.empty());
    }

    public Ggw_team_applications ggw_team_applications() {
        return new Ggw_team_applications(
                        contextPath.addSegment("ggw_team_applications"));
    }

    public Ggw_teamRequest ggw_teams(UUID ggw_teamid) {
        return new Ggw_teamRequest(contextPath.addSegment("ggw_teams").addKeys(new NameValue(ggw_teamid, UUID.class)), Optional.empty());
    }

    public Ggw_teams ggw_teams() {
        return new Ggw_teams(
                        contextPath.addSegment("ggw_teams"));
    }

    public GoalrollupqueryRequest goalrollupqueries(UUID goalrollupqueryid) {
        return new GoalrollupqueryRequest(contextPath.addSegment("goalrollupqueries").addKeys(new NameValue(goalrollupqueryid, UUID.class)), Optional.empty());
    }

    public Goalrollupqueries goalrollupqueries() {
        return new Goalrollupqueries(
                        contextPath.addSegment("goalrollupqueries"));
    }

    public GoalRequest goals(UUID goalid) {
        return new GoalRequest(contextPath.addSegment("goals").addKeys(new NameValue(goalid, UUID.class)), Optional.empty());
    }

    public Goals goals() {
        return new Goals(
                        contextPath.addSegment("goals"));
    }

    public ImportdataRequest importdataset(UUID importdataid) {
        return new ImportdataRequest(contextPath.addSegment("importdataset").addKeys(new NameValue(importdataid, UUID.class)), Optional.empty());
    }

    public Importdataset importdataset() {
        return new Importdataset(
                        contextPath.addSegment("importdataset"));
    }

    public ImportentitymappingRequest importentitymappings(UUID importentitymappingid) {
        return new ImportentitymappingRequest(contextPath.addSegment("importentitymappings").addKeys(new NameValue(importentitymappingid, UUID.class)), Optional.empty());
    }

    public Importentitymappings importentitymappings() {
        return new Importentitymappings(
                        contextPath.addSegment("importentitymappings"));
    }

    public ImportfileRequest importfiles(UUID importfileid) {
        return new ImportfileRequest(contextPath.addSegment("importfiles").addKeys(new NameValue(importfileid, UUID.class)), Optional.empty());
    }

    public Importfiles importfiles() {
        return new Importfiles(
                        contextPath.addSegment("importfiles"));
    }

    public ImportjobRequest importjobs(UUID importjobid) {
        return new ImportjobRequest(contextPath.addSegment("importjobs").addKeys(new NameValue(importjobid, UUID.class)), Optional.empty());
    }

    public Importjobs importjobs() {
        return new Importjobs(
                        contextPath.addSegment("importjobs"));
    }

    public ImportlogRequest importlogs(UUID importlogid) {
        return new ImportlogRequest(contextPath.addSegment("importlogs").addKeys(new NameValue(importlogid, UUID.class)), Optional.empty());
    }

    public Importlogs importlogs() {
        return new Importlogs(
                        contextPath.addSegment("importlogs"));
    }

    public ImportmapRequest importmaps(UUID importmapid) {
        return new ImportmapRequest(contextPath.addSegment("importmaps").addKeys(new NameValue(importmapid, UUID.class)), Optional.empty());
    }

    public Importmaps importmaps() {
        return new Importmaps(
                        contextPath.addSegment("importmaps"));
    }

    public ImportRequest imports(UUID importid) {
        return new ImportRequest(contextPath.addSegment("imports").addKeys(new NameValue(importid, UUID.class)), Optional.empty());
    }

    public Imports imports() {
        return new Imports(
                        contextPath.addSegment("imports"));
    }

    public InteractionforemailRequest interactionforemails(UUID interactionforemailid) {
        return new InteractionforemailRequest(contextPath.addSegment("interactionforemails").addKeys(new NameValue(interactionforemailid, UUID.class)), Optional.empty());
    }

    public Interactionforemails interactionforemails() {
        return new Interactionforemails(
                        contextPath.addSegment("interactionforemails"));
    }

    public InvaliddependencyRequest invaliddependencies(UUID invaliddependencyid) {
        return new InvaliddependencyRequest(contextPath.addSegment("invaliddependencies").addKeys(new NameValue(invaliddependencyid, UUID.class)), Optional.empty());
    }

    public Invaliddependencies invaliddependencies() {
        return new Invaliddependencies(
                        contextPath.addSegment("invaliddependencies"));
    }

    public KbarticlecommentRequest kbarticlecomments(UUID kbarticlecommentid) {
        return new KbarticlecommentRequest(contextPath.addSegment("kbarticlecomments").addKeys(new NameValue(kbarticlecommentid, UUID.class)), Optional.empty());
    }

    public Kbarticlecomments kbarticlecomments() {
        return new Kbarticlecomments(
                        contextPath.addSegment("kbarticlecomments"));
    }

    public KbarticleRequest kbarticles(UUID kbarticleid) {
        return new KbarticleRequest(contextPath.addSegment("kbarticles").addKeys(new NameValue(kbarticleid, UUID.class)), Optional.empty());
    }

    public Kbarticles kbarticles() {
        return new Kbarticles(
                        contextPath.addSegment("kbarticles"));
    }

    public KbarticletemplateRequest kbarticletemplates(UUID kbarticletemplateid) {
        return new KbarticletemplateRequest(contextPath.addSegment("kbarticletemplates").addKeys(new NameValue(kbarticletemplateid, UUID.class)), Optional.empty());
    }

    public Kbarticletemplates kbarticletemplates() {
        return new Kbarticletemplates(
                        contextPath.addSegment("kbarticletemplates"));
    }

    public KnowledgearticlescategoriesRequest knowledgearticlecategories(UUID knowledgearticlecategoryid) {
        return new KnowledgearticlescategoriesRequest(contextPath.addSegment("knowledgearticlecategories").addKeys(new NameValue(knowledgearticlecategoryid, UUID.class)), Optional.empty());
    }

    public Knowledgearticlecategories knowledgearticlecategories() {
        return new Knowledgearticlecategories(
                        contextPath.addSegment("knowledgearticlecategories"));
    }

    public KnowledgearticleRequest knowledgearticles(UUID knowledgearticleid) {
        return new KnowledgearticleRequest(contextPath.addSegment("knowledgearticles").addKeys(new NameValue(knowledgearticleid, UUID.class)), Optional.empty());
    }

    public Knowledgearticles knowledgearticles() {
        return new Knowledgearticles(
                        contextPath.addSegment("knowledgearticles"));
    }

    public KnowledgearticleviewsRequest knowledgearticleviews(UUID knowledgearticleviewsid) {
        return new KnowledgearticleviewsRequest(contextPath.addSegment("knowledgearticleviews").addKeys(new NameValue(knowledgearticleviewsid, UUID.class)), Optional.empty());
    }

    public Knowledgearticleviews knowledgearticleviews() {
        return new Knowledgearticleviews(
                        contextPath.addSegment("knowledgearticleviews"));
    }

    public KnowledgebaserecordRequest knowledgebaserecords(UUID knowledgebaserecordid) {
        return new KnowledgebaserecordRequest(contextPath.addSegment("knowledgebaserecords").addKeys(new NameValue(knowledgebaserecordid, UUID.class)), Optional.empty());
    }

    public Knowledgebaserecords knowledgebaserecords() {
        return new Knowledgebaserecords(
                        contextPath.addSegment("knowledgebaserecords"));
    }

    public LanguagelocaleRequest languagelocale(UUID languagelocaleid) {
        return new LanguagelocaleRequest(contextPath.addSegment("languagelocale").addKeys(new NameValue(languagelocaleid, UUID.class)), Optional.empty());
    }

    public Languagelocale languagelocale() {
        return new Languagelocale(
                        contextPath.addSegment("languagelocale"));
    }

    public LanguageprovisioningstateRequest languageprovisioningstates(UUID languageprovisioningstateid) {
        return new LanguageprovisioningstateRequest(contextPath.addSegment("languageprovisioningstates").addKeys(new NameValue(languageprovisioningstateid, UUID.class)), Optional.empty());
    }

    public Languageprovisioningstates languageprovisioningstates() {
        return new Languageprovisioningstates(
                        contextPath.addSegment("languageprovisioningstates"));
    }

    public LetterRequest letters(UUID activityid) {
        return new LetterRequest(contextPath.addSegment("letters").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public Letters letters() {
        return new Letters(
                        contextPath.addSegment("letters"));
    }

    public LookupmappingRequest lookupmappings(UUID lookupmappingid) {
        return new LookupmappingRequest(contextPath.addSegment("lookupmappings").addKeys(new NameValue(lookupmappingid, UUID.class)), Optional.empty());
    }

    public Lookupmappings lookupmappings() {
        return new Lookupmappings(
                        contextPath.addSegment("lookupmappings"));
    }

    public MailboxRequest mailboxes(UUID mailboxid) {
        return new MailboxRequest(contextPath.addSegment("mailboxes").addKeys(new NameValue(mailboxid, UUID.class)), Optional.empty());
    }

    public Mailboxes mailboxes() {
        return new Mailboxes(
                        contextPath.addSegment("mailboxes"));
    }

    public MailboxtrackingfolderRequest mailboxtrackingfolders(UUID mailboxtrackingfolderid) {
        return new MailboxtrackingfolderRequest(contextPath.addSegment("mailboxtrackingfolders").addKeys(new NameValue(mailboxtrackingfolderid, UUID.class)), Optional.empty());
    }

    public Mailboxtrackingfolders mailboxtrackingfolders() {
        return new Mailboxtrackingfolders(
                        contextPath.addSegment("mailboxtrackingfolders"));
    }

    public MailmergetemplateRequest mailmergetemplates(UUID mailmergetemplateid) {
        return new MailmergetemplateRequest(contextPath.addSegment("mailmergetemplates").addKeys(new NameValue(mailmergetemplateid, UUID.class)), Optional.empty());
    }

    public Mailmergetemplates mailmergetemplates() {
        return new Mailmergetemplates(
                        contextPath.addSegment("mailmergetemplates"));
    }

    public ManagedpropertyRequest managedproperties(UUID managedpropertyid) {
        return new ManagedpropertyRequest(contextPath.addSegment("managedproperties").addKeys(new NameValue(managedpropertyid, UUID.class)), Optional.empty());
    }

    public Managedproperties managedproperties() {
        return new Managedproperties(
                        contextPath.addSegment("managedproperties"));
    }

    public MetricRequest metrics(UUID metricid) {
        return new MetricRequest(contextPath.addSegment("metrics").addKeys(new NameValue(metricid, UUID.class)), Optional.empty());
    }

    public Metrics metrics() {
        return new Metrics(
                        contextPath.addSegment("metrics"));
    }

    public MobileofflineprofileitemassociationRequest mobileofflineprofileitemassociations(UUID mobileofflineprofileitemassociationid) {
        return new MobileofflineprofileitemassociationRequest(contextPath.addSegment("mobileofflineprofileitemassociations").addKeys(new NameValue(mobileofflineprofileitemassociationid, UUID.class)), Optional.empty());
    }

    public Mobileofflineprofileitemassociations mobileofflineprofileitemassociations() {
        return new Mobileofflineprofileitemassociations(
                        contextPath.addSegment("mobileofflineprofileitemassociations"));
    }

    public MobileofflineprofileitemRequest mobileofflineprofileitems(UUID mobileofflineprofileitemid) {
        return new MobileofflineprofileitemRequest(contextPath.addSegment("mobileofflineprofileitems").addKeys(new NameValue(mobileofflineprofileitemid, UUID.class)), Optional.empty());
    }

    public Mobileofflineprofileitems mobileofflineprofileitems() {
        return new Mobileofflineprofileitems(
                        contextPath.addSegment("mobileofflineprofileitems"));
    }

    public MobileofflineprofileRequest mobileofflineprofiles(UUID mobileofflineprofileid) {
        return new MobileofflineprofileRequest(contextPath.addSegment("mobileofflineprofiles").addKeys(new NameValue(mobileofflineprofileid, UUID.class)), Optional.empty());
    }

    public Mobileofflineprofiles mobileofflineprofiles() {
        return new Mobileofflineprofiles(
                        contextPath.addSegment("mobileofflineprofiles"));
    }

    public MonthlyfiscalcalendarRequest monthlyfiscalcalendars(UUID userfiscalcalendarid) {
        return new MonthlyfiscalcalendarRequest(contextPath.addSegment("monthlyfiscalcalendars").addKeys(new NameValue(userfiscalcalendarid, UUID.class)), Optional.empty());
    }

    public Monthlyfiscalcalendars monthlyfiscalcalendars() {
        return new Monthlyfiscalcalendars(
                        contextPath.addSegment("monthlyfiscalcalendars"));
    }

    public Msdyn_aibdatasetfileRequest msdyn_aibdatasetfiles(UUID msdyn_aibdatasetfileid) {
        return new Msdyn_aibdatasetfileRequest(contextPath.addSegment("msdyn_aibdatasetfiles").addKeys(new NameValue(msdyn_aibdatasetfileid, UUID.class)), Optional.empty());
    }

    public Msdyn_aibdatasetfiles msdyn_aibdatasetfiles() {
        return new Msdyn_aibdatasetfiles(
                        contextPath.addSegment("msdyn_aibdatasetfiles"));
    }

    public Msdyn_aibdatasetrecordRequest msdyn_aibdatasetrecords(UUID msdyn_aibdatasetrecordid) {
        return new Msdyn_aibdatasetrecordRequest(contextPath.addSegment("msdyn_aibdatasetrecords").addKeys(new NameValue(msdyn_aibdatasetrecordid, UUID.class)), Optional.empty());
    }

    public Msdyn_aibdatasetrecords msdyn_aibdatasetrecords() {
        return new Msdyn_aibdatasetrecords(
                        contextPath.addSegment("msdyn_aibdatasetrecords"));
    }

    public Msdyn_aibdatasetRequest msdyn_aibdatasets(UUID msdyn_aibdatasetid) {
        return new Msdyn_aibdatasetRequest(contextPath.addSegment("msdyn_aibdatasets").addKeys(new NameValue(msdyn_aibdatasetid, UUID.class)), Optional.empty());
    }

    public Msdyn_aibdatasets msdyn_aibdatasets() {
        return new Msdyn_aibdatasets(
                        contextPath.addSegment("msdyn_aibdatasets"));
    }

    public Msdyn_aibdatasetscontainerRequest msdyn_aibdatasetscontainers(UUID msdyn_aibdatasetscontainerid) {
        return new Msdyn_aibdatasetscontainerRequest(contextPath.addSegment("msdyn_aibdatasetscontainers").addKeys(new NameValue(msdyn_aibdatasetscontainerid, UUID.class)), Optional.empty());
    }

    public Msdyn_aibdatasetscontainers msdyn_aibdatasetscontainers() {
        return new Msdyn_aibdatasetscontainers(
                        contextPath.addSegment("msdyn_aibdatasetscontainers"));
    }

    public Msdyn_aibfileattacheddataRequest msdyn_aibfileattacheddatas(UUID msdyn_aibfileattacheddataid) {
        return new Msdyn_aibfileattacheddataRequest(contextPath.addSegment("msdyn_aibfileattacheddatas").addKeys(new NameValue(msdyn_aibfileattacheddataid, UUID.class)), Optional.empty());
    }

    public Msdyn_aibfileattacheddatas msdyn_aibfileattacheddatas() {
        return new Msdyn_aibfileattacheddatas(
                        contextPath.addSegment("msdyn_aibfileattacheddatas"));
    }

    public Msdyn_aibfileRequest msdyn_aibfiles(UUID msdyn_aibfileid) {
        return new Msdyn_aibfileRequest(contextPath.addSegment("msdyn_aibfiles").addKeys(new NameValue(msdyn_aibfileid, UUID.class)), Optional.empty());
    }

    public Msdyn_aibfiles msdyn_aibfiles() {
        return new Msdyn_aibfiles(
                        contextPath.addSegment("msdyn_aibfiles"));
    }

    public Msdyn_aiconfigurationRequest msdyn_aiconfigurations(UUID msdyn_aiconfigurationid) {
        return new Msdyn_aiconfigurationRequest(contextPath.addSegment("msdyn_aiconfigurations").addKeys(new NameValue(msdyn_aiconfigurationid, UUID.class)), Optional.empty());
    }

    public Msdyn_aiconfigurations msdyn_aiconfigurations() {
        return new Msdyn_aiconfigurations(
                        contextPath.addSegment("msdyn_aiconfigurations"));
    }

    public Msdyn_aifptrainingdocumentRequest msdyn_aifptrainingdocuments(UUID msdyn_aifptrainingdocumentid) {
        return new Msdyn_aifptrainingdocumentRequest(contextPath.addSegment("msdyn_aifptrainingdocuments").addKeys(new NameValue(msdyn_aifptrainingdocumentid, UUID.class)), Optional.empty());
    }

    public Msdyn_aifptrainingdocuments msdyn_aifptrainingdocuments() {
        return new Msdyn_aifptrainingdocuments(
                        contextPath.addSegment("msdyn_aifptrainingdocuments"));
    }

    public Msdyn_aimodelRequest msdyn_aimodels(UUID msdyn_aimodelid) {
        return new Msdyn_aimodelRequest(contextPath.addSegment("msdyn_aimodels").addKeys(new NameValue(msdyn_aimodelid, UUID.class)), Optional.empty());
    }

    public Msdyn_aimodels msdyn_aimodels() {
        return new Msdyn_aimodels(
                        contextPath.addSegment("msdyn_aimodels"));
    }

    public Msdyn_aiodimageRequest msdyn_aiodimages(UUID msdyn_aiodimageid) {
        return new Msdyn_aiodimageRequest(contextPath.addSegment("msdyn_aiodimages").addKeys(new NameValue(msdyn_aiodimageid, UUID.class)), Optional.empty());
    }

    public Msdyn_aiodimages msdyn_aiodimages() {
        return new Msdyn_aiodimages(
                        contextPath.addSegment("msdyn_aiodimages"));
    }

    public Msdyn_aiodlabel_msdyn_aiconfigurationRequest msdyn_aiodlabel_msdyn_aiconfigurationset(UUID msdyn_aiodlabel_msdyn_aiconfigurationid) {
        return new Msdyn_aiodlabel_msdyn_aiconfigurationRequest(contextPath.addSegment("msdyn_aiodlabel_msdyn_aiconfigurationset").addKeys(new NameValue(msdyn_aiodlabel_msdyn_aiconfigurationid, UUID.class)), Optional.empty());
    }

    public Msdyn_aiodlabel_msdyn_aiconfigurationset msdyn_aiodlabel_msdyn_aiconfigurationset() {
        return new Msdyn_aiodlabel_msdyn_aiconfigurationset(
                        contextPath.addSegment("msdyn_aiodlabel_msdyn_aiconfigurationset"));
    }

    public Msdyn_aiodlabelRequest msdyn_aiodlabels(UUID msdyn_aiodlabelid) {
        return new Msdyn_aiodlabelRequest(contextPath.addSegment("msdyn_aiodlabels").addKeys(new NameValue(msdyn_aiodlabelid, UUID.class)), Optional.empty());
    }

    public Msdyn_aiodlabels msdyn_aiodlabels() {
        return new Msdyn_aiodlabels(
                        contextPath.addSegment("msdyn_aiodlabels"));
    }

    public Msdyn_aiodtrainingboundingboxRequest msdyn_aiodtrainingboundingboxes(UUID msdyn_aiodtrainingboundingboxid) {
        return new Msdyn_aiodtrainingboundingboxRequest(contextPath.addSegment("msdyn_aiodtrainingboundingboxes").addKeys(new NameValue(msdyn_aiodtrainingboundingboxid, UUID.class)), Optional.empty());
    }

    public Msdyn_aiodtrainingboundingboxes msdyn_aiodtrainingboundingboxes() {
        return new Msdyn_aiodtrainingboundingboxes(
                        contextPath.addSegment("msdyn_aiodtrainingboundingboxes"));
    }

    public Msdyn_aiodtrainingimageRequest msdyn_aiodtrainingimages(UUID msdyn_aiodtrainingimageid) {
        return new Msdyn_aiodtrainingimageRequest(contextPath.addSegment("msdyn_aiodtrainingimages").addKeys(new NameValue(msdyn_aiodtrainingimageid, UUID.class)), Optional.empty());
    }

    public Msdyn_aiodtrainingimages msdyn_aiodtrainingimages() {
        return new Msdyn_aiodtrainingimages(
                        contextPath.addSegment("msdyn_aiodtrainingimages"));
    }

    public Msdyn_aitemplateRequest msdyn_aitemplates(UUID msdyn_aitemplateid) {
        return new Msdyn_aitemplateRequest(contextPath.addSegment("msdyn_aitemplates").addKeys(new NameValue(msdyn_aitemplateid, UUID.class)), Optional.empty());
    }

    public Msdyn_aitemplates msdyn_aitemplates() {
        return new Msdyn_aitemplates(
                        contextPath.addSegment("msdyn_aitemplates"));
    }

    public Msdyn_analysiscomponentRequest msdyn_analysiscomponents(UUID msdyn_analysiscomponentid) {
        return new Msdyn_analysiscomponentRequest(contextPath.addSegment("msdyn_analysiscomponents").addKeys(new NameValue(msdyn_analysiscomponentid, UUID.class)), Optional.empty());
    }

    public Msdyn_analysiscomponents msdyn_analysiscomponents() {
        return new Msdyn_analysiscomponents(
                        contextPath.addSegment("msdyn_analysiscomponents"));
    }

    public Msdyn_analysisjobRequest msdyn_analysisjobs(UUID msdyn_analysisjobid) {
        return new Msdyn_analysisjobRequest(contextPath.addSegment("msdyn_analysisjobs").addKeys(new NameValue(msdyn_analysisjobid, UUID.class)), Optional.empty());
    }

    public Msdyn_analysisjobs msdyn_analysisjobs() {
        return new Msdyn_analysisjobs(
                        contextPath.addSegment("msdyn_analysisjobs"));
    }

    public Msdyn_analysisresultdetailRequest msdyn_analysisresultdetails(UUID msdyn_analysisresultdetailid) {
        return new Msdyn_analysisresultdetailRequest(contextPath.addSegment("msdyn_analysisresultdetails").addKeys(new NameValue(msdyn_analysisresultdetailid, UUID.class)), Optional.empty());
    }

    public Msdyn_analysisresultdetails msdyn_analysisresultdetails() {
        return new Msdyn_analysisresultdetails(
                        contextPath.addSegment("msdyn_analysisresultdetails"));
    }

    public Msdyn_analysisresultRequest msdyn_analysisresults(UUID msdyn_analysisresultid) {
        return new Msdyn_analysisresultRequest(contextPath.addSegment("msdyn_analysisresults").addKeys(new NameValue(msdyn_analysisresultid, UUID.class)), Optional.empty());
    }

    public Msdyn_analysisresults msdyn_analysisresults() {
        return new Msdyn_analysisresults(
                        contextPath.addSegment("msdyn_analysisresults"));
    }

    public Msdyn_componentlayerdatasourceRequest msdyn_componentlayerdatasources(UUID msdyn_componentlayerdatasourceid) {
        return new Msdyn_componentlayerdatasourceRequest(contextPath.addSegment("msdyn_componentlayerdatasources").addKeys(new NameValue(msdyn_componentlayerdatasourceid, UUID.class)), Optional.empty());
    }

    public Msdyn_componentlayerdatasources msdyn_componentlayerdatasources() {
        return new Msdyn_componentlayerdatasources(
                        contextPath.addSegment("msdyn_componentlayerdatasources"));
    }

    public Msdyn_componentlayerRequest msdyn_componentlayers(UUID msdyn_componentlayerid) {
        return new Msdyn_componentlayerRequest(contextPath.addSegment("msdyn_componentlayers").addKeys(new NameValue(msdyn_componentlayerid, UUID.class)), Optional.empty());
    }

    public Msdyn_componentlayers msdyn_componentlayers() {
        return new Msdyn_componentlayers(
                        contextPath.addSegment("msdyn_componentlayers"));
    }

    public Msdyn_dataflowRequest msdyn_dataflows(UUID msdyn_dataflowid) {
        return new Msdyn_dataflowRequest(contextPath.addSegment("msdyn_dataflows").addKeys(new NameValue(msdyn_dataflowid, UUID.class)), Optional.empty());
    }

    public Msdyn_dataflows msdyn_dataflows() {
        return new Msdyn_dataflows(
                        contextPath.addSegment("msdyn_dataflows"));
    }

    public Msdyn_helppageRequest msdyn_helppages(UUID msdyn_helppageid) {
        return new Msdyn_helppageRequest(contextPath.addSegment("msdyn_helppages").addKeys(new NameValue(msdyn_helppageid, UUID.class)), Optional.empty());
    }

    public Msdyn_helppages msdyn_helppages() {
        return new Msdyn_helppages(
                        contextPath.addSegment("msdyn_helppages"));
    }

    public Msdyn_knowledgearticleimageRequest msdyn_knowledgearticleimages(UUID msdyn_knowledgearticleimageid) {
        return new Msdyn_knowledgearticleimageRequest(contextPath.addSegment("msdyn_knowledgearticleimages").addKeys(new NameValue(msdyn_knowledgearticleimageid, UUID.class)), Optional.empty());
    }

    public Msdyn_knowledgearticleimages msdyn_knowledgearticleimages() {
        return new Msdyn_knowledgearticleimages(
                        contextPath.addSegment("msdyn_knowledgearticleimages"));
    }

    public Msdyn_knowledgearticletemplateRequest msdyn_knowledgearticletemplates(UUID msdyn_knowledgearticletemplateid) {
        return new Msdyn_knowledgearticletemplateRequest(contextPath.addSegment("msdyn_knowledgearticletemplates").addKeys(new NameValue(msdyn_knowledgearticletemplateid, UUID.class)), Optional.empty());
    }

    public Msdyn_knowledgearticletemplates msdyn_knowledgearticletemplates() {
        return new Msdyn_knowledgearticletemplates(
                        contextPath.addSegment("msdyn_knowledgearticletemplates"));
    }

    public Msdyn_nonrelationaldsRequest msdyn_nonrelationaldses(UUID msdyn_nonrelationaldsid) {
        return new Msdyn_nonrelationaldsRequest(contextPath.addSegment("msdyn_nonrelationaldses").addKeys(new NameValue(msdyn_nonrelationaldsid, UUID.class)), Optional.empty());
    }

    public Msdyn_nonrelationaldses msdyn_nonrelationaldses() {
        return new Msdyn_nonrelationaldses(
                        contextPath.addSegment("msdyn_nonrelationaldses"));
    }

    public Msdyn_odatav4dsRequest msdyn_odatav4ds(UUID msdyn_odatav4dsid) {
        return new Msdyn_odatav4dsRequest(contextPath.addSegment("msdyn_odatav4ds").addKeys(new NameValue(msdyn_odatav4dsid, UUID.class)), Optional.empty());
    }

    public Msdyn_odatav4ds msdyn_odatav4ds() {
        return new Msdyn_odatav4ds(
                        contextPath.addSegment("msdyn_odatav4ds"));
    }

    public Msdyn_richtextfileRequest msdyn_richtextfiles(UUID msdyn_richtextfileid) {
        return new Msdyn_richtextfileRequest(contextPath.addSegment("msdyn_richtextfiles").addKeys(new NameValue(msdyn_richtextfileid, UUID.class)), Optional.empty());
    }

    public Msdyn_richtextfiles msdyn_richtextfiles() {
        return new Msdyn_richtextfiles(
                        contextPath.addSegment("msdyn_richtextfiles"));
    }

    public Msdyn_serviceconfigurationRequest msdyn_serviceconfigurations(UUID msdyn_serviceconfigurationid) {
        return new Msdyn_serviceconfigurationRequest(contextPath.addSegment("msdyn_serviceconfigurations").addKeys(new NameValue(msdyn_serviceconfigurationid, UUID.class)), Optional.empty());
    }

    public Msdyn_serviceconfigurations msdyn_serviceconfigurations() {
        return new Msdyn_serviceconfigurations(
                        contextPath.addSegment("msdyn_serviceconfigurations"));
    }

    public Msdyn_slakpiRequest msdyn_slakpis(UUID msdyn_slakpiid) {
        return new Msdyn_slakpiRequest(contextPath.addSegment("msdyn_slakpis").addKeys(new NameValue(msdyn_slakpiid, UUID.class)), Optional.empty());
    }

    public Msdyn_slakpis msdyn_slakpis() {
        return new Msdyn_slakpis(
                        contextPath.addSegment("msdyn_slakpis"));
    }

    public Msdyn_solutioncomponentdatasourceRequest msdyn_solutioncomponentdatasources(UUID msdyn_solutioncomponentdatasourceid) {
        return new Msdyn_solutioncomponentdatasourceRequest(contextPath.addSegment("msdyn_solutioncomponentdatasources").addKeys(new NameValue(msdyn_solutioncomponentdatasourceid, UUID.class)), Optional.empty());
    }

    public Msdyn_solutioncomponentdatasources msdyn_solutioncomponentdatasources() {
        return new Msdyn_solutioncomponentdatasources(
                        contextPath.addSegment("msdyn_solutioncomponentdatasources"));
    }

    public Msdyn_solutioncomponentsummaryRequest msdyn_solutioncomponentsummaries(UUID msdyn_solutioncomponentsummaryid) {
        return new Msdyn_solutioncomponentsummaryRequest(contextPath.addSegment("msdyn_solutioncomponentsummaries").addKeys(new NameValue(msdyn_solutioncomponentsummaryid, UUID.class)), Optional.empty());
    }

    public Msdyn_solutioncomponentsummaries msdyn_solutioncomponentsummaries() {
        return new Msdyn_solutioncomponentsummaries(
                        contextPath.addSegment("msdyn_solutioncomponentsummaries"));
    }

    public Msdyn_solutionhealthruleargumentRequest msdyn_solutionhealthrulearguments(UUID msdyn_solutionhealthruleargumentid) {
        return new Msdyn_solutionhealthruleargumentRequest(contextPath.addSegment("msdyn_solutionhealthrulearguments").addKeys(new NameValue(msdyn_solutionhealthruleargumentid, UUID.class)), Optional.empty());
    }

    public Msdyn_solutionhealthrulearguments msdyn_solutionhealthrulearguments() {
        return new Msdyn_solutionhealthrulearguments(
                        contextPath.addSegment("msdyn_solutionhealthrulearguments"));
    }

    public Msdyn_solutionhealthruleRequest msdyn_solutionhealthrules(UUID msdyn_solutionhealthruleid) {
        return new Msdyn_solutionhealthruleRequest(contextPath.addSegment("msdyn_solutionhealthrules").addKeys(new NameValue(msdyn_solutionhealthruleid, UUID.class)), Optional.empty());
    }

    public Msdyn_solutionhealthrules msdyn_solutionhealthrules() {
        return new Msdyn_solutionhealthrules(
                        contextPath.addSegment("msdyn_solutionhealthrules"));
    }

    public Msdyn_solutionhealthrulesetRequest msdyn_solutionhealthrulesets(UUID msdyn_solutionhealthrulesetid) {
        return new Msdyn_solutionhealthrulesetRequest(contextPath.addSegment("msdyn_solutionhealthrulesets").addKeys(new NameValue(msdyn_solutionhealthrulesetid, UUID.class)), Optional.empty());
    }

    public Msdyn_solutionhealthrulesets msdyn_solutionhealthrulesets() {
        return new Msdyn_solutionhealthrulesets(
                        contextPath.addSegment("msdyn_solutionhealthrulesets"));
    }

    public Msdyn_solutionhistoryRequest msdyn_solutionhistories(UUID msdyn_solutionhistoryid) {
        return new Msdyn_solutionhistoryRequest(contextPath.addSegment("msdyn_solutionhistories").addKeys(new NameValue(msdyn_solutionhistoryid, UUID.class)), Optional.empty());
    }

    public Msdyn_solutionhistories msdyn_solutionhistories() {
        return new Msdyn_solutionhistories(
                        contextPath.addSegment("msdyn_solutionhistories"));
    }

    public Msdyn_solutionhistorydatasourceRequest msdyn_solutionhistorydatasources(UUID msdyn_solutionhistorydatasourceid) {
        return new Msdyn_solutionhistorydatasourceRequest(contextPath.addSegment("msdyn_solutionhistorydatasources").addKeys(new NameValue(msdyn_solutionhistorydatasourceid, UUID.class)), Optional.empty());
    }

    public Msdyn_solutionhistorydatasources msdyn_solutionhistorydatasources() {
        return new Msdyn_solutionhistorydatasources(
                        contextPath.addSegment("msdyn_solutionhistorydatasources"));
    }

    public NavigationsettingRequest navigationsettings(UUID navigationsettingid) {
        return new NavigationsettingRequest(contextPath.addSegment("navigationsettings").addKeys(new NameValue(navigationsettingid, UUID.class)), Optional.empty());
    }

    public Navigationsettings navigationsettings() {
        return new Navigationsettings(
                        contextPath.addSegment("navigationsettings"));
    }

    public NewprocessRequest newprocesses(UUID businessprocessflowinstanceid) {
        return new NewprocessRequest(contextPath.addSegment("newprocesses").addKeys(new NameValue(businessprocessflowinstanceid, UUID.class)), Optional.empty());
    }

    public Newprocesses newprocesses() {
        return new Newprocesses(
                        contextPath.addSegment("newprocesses"));
    }

    public OfficegraphdocumentRequest officegraphdocuments(UUID officegraphdocumentid) {
        return new OfficegraphdocumentRequest(contextPath.addSegment("officegraphdocuments").addKeys(new NameValue(officegraphdocumentid, UUID.class)), Optional.empty());
    }

    public Officegraphdocuments officegraphdocuments() {
        return new Officegraphdocuments(
                        contextPath.addSegment("officegraphdocuments"));
    }

    public OptionsetRequest optionsets(UUID optionsetid) {
        return new OptionsetRequest(contextPath.addSegment("optionsets").addKeys(new NameValue(optionsetid, UUID.class)), Optional.empty());
    }

    public Optionsets optionsets() {
        return new Optionsets(
                        contextPath.addSegment("optionsets"));
    }

    public OrganizationRequest organizations(UUID organizationid) {
        return new OrganizationRequest(contextPath.addSegment("organizations").addKeys(new NameValue(organizationid, UUID.class)), Optional.empty());
    }

    public Organizations organizations() {
        return new Organizations(
                        contextPath.addSegment("organizations"));
    }

    public OwnermappingRequest ownermappings(UUID ownermappingid) {
        return new OwnermappingRequest(contextPath.addSegment("ownermappings").addKeys(new NameValue(ownermappingid, UUID.class)), Optional.empty());
    }

    public Ownermappings ownermappings() {
        return new Ownermappings(
                        contextPath.addSegment("ownermappings"));
    }

    public PersonaldocumenttemplateRequest personaldocumenttemplates(UUID personaldocumenttemplateid) {
        return new PersonaldocumenttemplateRequest(contextPath.addSegment("personaldocumenttemplates").addKeys(new NameValue(personaldocumenttemplateid, UUID.class)), Optional.empty());
    }

    public Personaldocumenttemplates personaldocumenttemplates() {
        return new Personaldocumenttemplates(
                        contextPath.addSegment("personaldocumenttemplates"));
    }

    public PhonecallRequest phonecalls(UUID activityid) {
        return new PhonecallRequest(contextPath.addSegment("phonecalls").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public Phonecalls phonecalls() {
        return new Phonecalls(
                        contextPath.addSegment("phonecalls"));
    }

    public PicklistmappingRequest picklistmappings(UUID picklistmappingid) {
        return new PicklistmappingRequest(contextPath.addSegment("picklistmappings").addKeys(new NameValue(picklistmappingid, UUID.class)), Optional.empty());
    }

    public Picklistmappings picklistmappings() {
        return new Picklistmappings(
                        contextPath.addSegment("picklistmappings"));
    }

    public PluginassemblyRequest pluginassemblies(UUID pluginassemblyid) {
        return new PluginassemblyRequest(contextPath.addSegment("pluginassemblies").addKeys(new NameValue(pluginassemblyid, UUID.class)), Optional.empty());
    }

    public Pluginassemblies pluginassemblies() {
        return new Pluginassemblies(
                        contextPath.addSegment("pluginassemblies"));
    }

    public PlugintracelogRequest plugintracelogs(UUID plugintracelogid) {
        return new PlugintracelogRequest(contextPath.addSegment("plugintracelogs").addKeys(new NameValue(plugintracelogid, UUID.class)), Optional.empty());
    }

    public Plugintracelogs plugintracelogs() {
        return new Plugintracelogs(
                        contextPath.addSegment("plugintracelogs"));
    }

    public PlugintypeRequest plugintypes(UUID plugintypeid) {
        return new PlugintypeRequest(contextPath.addSegment("plugintypes").addKeys(new NameValue(plugintypeid, UUID.class)), Optional.empty());
    }

    public Plugintypes plugintypes() {
        return new Plugintypes(
                        contextPath.addSegment("plugintypes"));
    }

    public PlugintypestatisticRequest plugintypestatistics(UUID plugintypestatisticid) {
        return new PlugintypestatisticRequest(contextPath.addSegment("plugintypestatistics").addKeys(new NameValue(plugintypestatisticid, UUID.class)), Optional.empty());
    }

    public Plugintypestatistics plugintypestatistics() {
        return new Plugintypestatistics(
                        contextPath.addSegment("plugintypestatistics"));
    }

    public PositionRequest positions(UUID positionid) {
        return new PositionRequest(contextPath.addSegment("positions").addKeys(new NameValue(positionid, UUID.class)), Optional.empty());
    }

    public Positions positions() {
        return new Positions(
                        contextPath.addSegment("positions"));
    }

    public PostcommentRequest postcomments(UUID postcommentid) {
        return new PostcommentRequest(contextPath.addSegment("postcomments").addKeys(new NameValue(postcommentid, UUID.class)), Optional.empty());
    }

    public Postcomments postcomments() {
        return new Postcomments(
                        contextPath.addSegment("postcomments"));
    }

    public PostfollowRequest postfollows(UUID postfollowid) {
        return new PostfollowRequest(contextPath.addSegment("postfollows").addKeys(new NameValue(postfollowid, UUID.class)), Optional.empty());
    }

    public Postfollows postfollows() {
        return new Postfollows(
                        contextPath.addSegment("postfollows"));
    }

    public PostlikeRequest postlikes(UUID postlikeid) {
        return new PostlikeRequest(contextPath.addSegment("postlikes").addKeys(new NameValue(postlikeid, UUID.class)), Optional.empty());
    }

    public Postlikes postlikes() {
        return new Postlikes(
                        contextPath.addSegment("postlikes"));
    }

    public PostregardingRequest postregardings(UUID postregardingid) {
        return new PostregardingRequest(contextPath.addSegment("postregardings").addKeys(new NameValue(postregardingid, UUID.class)), Optional.empty());
    }

    public Postregardings postregardings() {
        return new Postregardings(
                        contextPath.addSegment("postregardings"));
    }

    public PostRequest posts(UUID postid) {
        return new PostRequest(contextPath.addSegment("posts").addKeys(new NameValue(postid, UUID.class)), Optional.empty());
    }

    public Posts posts() {
        return new Posts(
                        contextPath.addSegment("posts"));
    }

    public PrincipalentitymapRequest principalentitymaps(UUID principalentitymapid) {
        return new PrincipalentitymapRequest(contextPath.addSegment("principalentitymaps").addKeys(new NameValue(principalentitymapid, UUID.class)), Optional.empty());
    }

    public Principalentitymaps principalentitymaps() {
        return new Principalentitymaps(
                        contextPath.addSegment("principalentitymaps"));
    }

    public PrincipalobjectaccessRequest principalobjectaccessset(UUID principalobjectaccessid) {
        return new PrincipalobjectaccessRequest(contextPath.addSegment("principalobjectaccessset").addKeys(new NameValue(principalobjectaccessid, UUID.class)), Optional.empty());
    }

    public Principalobjectaccessset principalobjectaccessset() {
        return new Principalobjectaccessset(
                        contextPath.addSegment("principalobjectaccessset"));
    }

    public PrincipalobjectattributeaccessRequest principalobjectattributeaccessset(UUID principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("principalobjectattributeaccessset").addKeys(new NameValue(principalobjectattributeaccessid, UUID.class)), Optional.empty());
    }

    public Principalobjectattributeaccessset principalobjectattributeaccessset() {
        return new Principalobjectattributeaccessset(
                        contextPath.addSegment("principalobjectattributeaccessset"));
    }

    public PrivilegeRequest privileges(UUID privilegeid) {
        return new PrivilegeRequest(contextPath.addSegment("privileges").addKeys(new NameValue(privilegeid, UUID.class)), Optional.empty());
    }

    public Privileges privileges() {
        return new Privileges(
                        contextPath.addSegment("privileges"));
    }

    public ProcesssessionRequest processsessions(UUID processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("processsessions").addKeys(new NameValue(processsessionid, UUID.class)), Optional.empty());
    }

    public Processsessions processsessions() {
        return new Processsessions(
                        contextPath.addSegment("processsessions"));
    }

    public ProcessstageparameterRequest processstageparameters(UUID processstageparameterid) {
        return new ProcessstageparameterRequest(contextPath.addSegment("processstageparameters").addKeys(new NameValue(processstageparameterid, UUID.class)), Optional.empty());
    }

    public Processstageparameters processstageparameters() {
        return new Processstageparameters(
                        contextPath.addSegment("processstageparameters"));
    }

    public ProcessstageRequest processstages(UUID processstageid) {
        return new ProcessstageRequest(contextPath.addSegment("processstages").addKeys(new NameValue(processstageid, UUID.class)), Optional.empty());
    }

    public Processstages processstages() {
        return new Processstages(
                        contextPath.addSegment("processstages"));
    }

    public ProcesstriggerRequest processtriggers(UUID processtriggerid) {
        return new ProcesstriggerRequest(contextPath.addSegment("processtriggers").addKeys(new NameValue(processtriggerid, UUID.class)), Optional.empty());
    }

    public Processtriggers processtriggers() {
        return new Processtriggers(
                        contextPath.addSegment("processtriggers"));
    }

    public PublisheraddressRequest publisheraddresses(UUID publisheraddressid) {
        return new PublisheraddressRequest(contextPath.addSegment("publisheraddresses").addKeys(new NameValue(publisheraddressid, UUID.class)), Optional.empty());
    }

    public Publisheraddresses publisheraddresses() {
        return new Publisheraddresses(
                        contextPath.addSegment("publisheraddresses"));
    }

    public PublisherRequest publishers(UUID publisherid) {
        return new PublisherRequest(contextPath.addSegment("publishers").addKeys(new NameValue(publisherid, UUID.class)), Optional.empty());
    }

    public Publishers publishers() {
        return new Publishers(
                        contextPath.addSegment("publishers"));
    }

    public QuarterlyfiscalcalendarRequest quarterlyfiscalcalendars(UUID userfiscalcalendarid) {
        return new QuarterlyfiscalcalendarRequest(contextPath.addSegment("quarterlyfiscalcalendars").addKeys(new NameValue(userfiscalcalendarid, UUID.class)), Optional.empty());
    }

    public Quarterlyfiscalcalendars quarterlyfiscalcalendars() {
        return new Quarterlyfiscalcalendars(
                        contextPath.addSegment("quarterlyfiscalcalendars"));
    }

    public QueueitemRequest queueitems(UUID queueitemid) {
        return new QueueitemRequest(contextPath.addSegment("queueitems").addKeys(new NameValue(queueitemid, UUID.class)), Optional.empty());
    }

    public Queueitems queueitems() {
        return new Queueitems(
                        contextPath.addSegment("queueitems"));
    }

    public QueuemembershipRequest queuememberships(UUID queuemembershipid) {
        return new QueuemembershipRequest(contextPath.addSegment("queuememberships").addKeys(new NameValue(queuemembershipid, UUID.class)), Optional.empty());
    }

    public Queuememberships queuememberships() {
        return new Queuememberships(
                        contextPath.addSegment("queuememberships"));
    }

    public QueueRequest queues(UUID queueid) {
        return new QueueRequest(contextPath.addSegment("queues").addKeys(new NameValue(queueid, UUID.class)), Optional.empty());
    }

    public Queues queues() {
        return new Queues(
                        contextPath.addSegment("queues"));
    }

    public RecommendeddocumentRequest recommendeddocuments(UUID recommendeddocumentid) {
        return new RecommendeddocumentRequest(contextPath.addSegment("recommendeddocuments").addKeys(new NameValue(recommendeddocumentid, UUID.class)), Optional.empty());
    }

    public Recommendeddocuments recommendeddocuments() {
        return new Recommendeddocuments(
                        contextPath.addSegment("recommendeddocuments"));
    }

    public RecurrenceruleRequest recurrencerules(UUID ruleid) {
        return new RecurrenceruleRequest(contextPath.addSegment("recurrencerules").addKeys(new NameValue(ruleid, UUID.class)), Optional.empty());
    }

    public Recurrencerules recurrencerules() {
        return new Recurrencerules(
                        contextPath.addSegment("recurrencerules"));
    }

    public RecurringappointmentmasterRequest recurringappointmentmasters(UUID activityid) {
        return new RecurringappointmentmasterRequest(contextPath.addSegment("recurringappointmentmasters").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public Recurringappointmentmasters recurringappointmentmasters() {
        return new Recurringappointmentmasters(
                        contextPath.addSegment("recurringappointmentmasters"));
    }

    public RelationshipattributeRequest relationshipattributes(UUID relationshipattributeid) {
        return new RelationshipattributeRequest(contextPath.addSegment("relationshipattributes").addKeys(new NameValue(relationshipattributeid, UUID.class)), Optional.empty());
    }

    public Relationshipattributes relationshipattributes() {
        return new Relationshipattributes(
                        contextPath.addSegment("relationshipattributes"));
    }

    public RelationshipRequest relationships(UUID relationshipid) {
        return new RelationshipRequest(contextPath.addSegment("relationships").addKeys(new NameValue(relationshipid, UUID.class)), Optional.empty());
    }

    public Relationships relationships() {
        return new Relationships(
                        contextPath.addSegment("relationships"));
    }

    public ReportcategoryRequest reportcategories(UUID reportcategoryid) {
        return new ReportcategoryRequest(contextPath.addSegment("reportcategories").addKeys(new NameValue(reportcategoryid, UUID.class)), Optional.empty());
    }

    public Reportcategories reportcategories() {
        return new Reportcategories(
                        contextPath.addSegment("reportcategories"));
    }

    public ReportRequest reports(UUID reportid) {
        return new ReportRequest(contextPath.addSegment("reports").addKeys(new NameValue(reportid, UUID.class)), Optional.empty());
    }

    public Reports reports() {
        return new Reports(
                        contextPath.addSegment("reports"));
    }

    public RibbonmetadatatoprocessRequest ribbonmetadatasettoprocess(UUID ribbonmetadatarowid) {
        return new RibbonmetadatatoprocessRequest(contextPath.addSegment("ribbonmetadatasettoprocess").addKeys(new NameValue(ribbonmetadatarowid, UUID.class)), Optional.empty());
    }

    public Ribbonmetadatasettoprocess ribbonmetadatasettoprocess() {
        return new Ribbonmetadatasettoprocess(
                        contextPath.addSegment("ribbonmetadatasettoprocess"));
    }

    public RoleprivilegesRequest roleprivilegescollection(UUID roleprivilegeid) {
        return new RoleprivilegesRequest(contextPath.addSegment("roleprivilegescollection").addKeys(new NameValue(roleprivilegeid, UUID.class)), Optional.empty());
    }

    public Roleprivilegescollection roleprivilegescollection() {
        return new Roleprivilegescollection(
                        contextPath.addSegment("roleprivilegescollection"));
    }

    public RoleRequest roles(UUID roleid) {
        return new RoleRequest(contextPath.addSegment("roles").addKeys(new NameValue(roleid, UUID.class)), Optional.empty());
    }

    public Roles roles() {
        return new Roles(
                        contextPath.addSegment("roles"));
    }

    public RoletemplateprivilegesRequest roletemplateprivilegescollection(UUID roletemplateprivilegeid) {
        return new RoletemplateprivilegesRequest(contextPath.addSegment("roletemplateprivilegescollection").addKeys(new NameValue(roletemplateprivilegeid, UUID.class)), Optional.empty());
    }

    public Roletemplateprivilegescollection roletemplateprivilegescollection() {
        return new Roletemplateprivilegescollection(
                        contextPath.addSegment("roletemplateprivilegescollection"));
    }

    public RoletemplateRequest roletemplates(UUID roletemplateid) {
        return new RoletemplateRequest(contextPath.addSegment("roletemplates").addKeys(new NameValue(roletemplateid, UUID.class)), Optional.empty());
    }

    public Roletemplates roletemplates() {
        return new Roletemplates(
                        contextPath.addSegment("roletemplates"));
    }

    public RollupfieldRequest rollupfields(UUID rollupfieldid) {
        return new RollupfieldRequest(contextPath.addSegment("rollupfields").addKeys(new NameValue(rollupfieldid, UUID.class)), Optional.empty());
    }

    public Rollupfields rollupfields() {
        return new Rollupfields(
                        contextPath.addSegment("rollupfields"));
    }

    public RuntimedependencyRequest runtimedependencies(UUID dependencyid) {
        return new RuntimedependencyRequest(contextPath.addSegment("runtimedependencies").addKeys(new NameValue(dependencyid, UUID.class)), Optional.empty());
    }

    public Runtimedependencies runtimedependencies() {
        return new Runtimedependencies(
                        contextPath.addSegment("runtimedependencies"));
    }

    public SavedqueryRequest savedqueries(UUID savedqueryid) {
        return new SavedqueryRequest(contextPath.addSegment("savedqueries").addKeys(new NameValue(savedqueryid, UUID.class)), Optional.empty());
    }

    public Savedqueries savedqueries() {
        return new Savedqueries(
                        contextPath.addSegment("savedqueries"));
    }

    public SavedqueryvisualizationRequest savedqueryvisualizations(UUID savedqueryvisualizationid) {
        return new SavedqueryvisualizationRequest(contextPath.addSegment("savedqueryvisualizations").addKeys(new NameValue(savedqueryvisualizationid, UUID.class)), Optional.empty());
    }

    public Savedqueryvisualizations savedqueryvisualizations() {
        return new Savedqueryvisualizations(
                        contextPath.addSegment("savedqueryvisualizations"));
    }

    public SdkmessagefilterRequest sdkmessagefilters(UUID sdkmessagefilterid) {
        return new SdkmessagefilterRequest(contextPath.addSegment("sdkmessagefilters").addKeys(new NameValue(sdkmessagefilterid, UUID.class)), Optional.empty());
    }

    public Sdkmessagefilters sdkmessagefilters() {
        return new Sdkmessagefilters(
                        contextPath.addSegment("sdkmessagefilters"));
    }

    public SdkmessageprocessingstepimageRequest sdkmessageprocessingstepimages(UUID sdkmessageprocessingstepimageid) {
        return new SdkmessageprocessingstepimageRequest(contextPath.addSegment("sdkmessageprocessingstepimages").addKeys(new NameValue(sdkmessageprocessingstepimageid, UUID.class)), Optional.empty());
    }

    public Sdkmessageprocessingstepimages sdkmessageprocessingstepimages() {
        return new Sdkmessageprocessingstepimages(
                        contextPath.addSegment("sdkmessageprocessingstepimages"));
    }

    public SdkmessageprocessingstepRequest sdkmessageprocessingsteps(UUID sdkmessageprocessingstepid) {
        return new SdkmessageprocessingstepRequest(contextPath.addSegment("sdkmessageprocessingsteps").addKeys(new NameValue(sdkmessageprocessingstepid, UUID.class)), Optional.empty());
    }

    public Sdkmessageprocessingsteps sdkmessageprocessingsteps() {
        return new Sdkmessageprocessingsteps(
                        contextPath.addSegment("sdkmessageprocessingsteps"));
    }

    public SdkmessageprocessingstepsecureconfigRequest sdkmessageprocessingstepsecureconfigs(UUID sdkmessageprocessingstepsecureconfigid) {
        return new SdkmessageprocessingstepsecureconfigRequest(contextPath.addSegment("sdkmessageprocessingstepsecureconfigs").addKeys(new NameValue(sdkmessageprocessingstepsecureconfigid, UUID.class)), Optional.empty());
    }

    public Sdkmessageprocessingstepsecureconfigs sdkmessageprocessingstepsecureconfigs() {
        return new Sdkmessageprocessingstepsecureconfigs(
                        contextPath.addSegment("sdkmessageprocessingstepsecureconfigs"));
    }

    public SdkmessageRequest sdkmessages(UUID sdkmessageid) {
        return new SdkmessageRequest(contextPath.addSegment("sdkmessages").addKeys(new NameValue(sdkmessageid, UUID.class)), Optional.empty());
    }

    public Sdkmessages sdkmessages() {
        return new Sdkmessages(
                        contextPath.addSegment("sdkmessages"));
    }

    public SemiannualfiscalcalendarRequest semiannualfiscalcalendars(UUID userfiscalcalendarid) {
        return new SemiannualfiscalcalendarRequest(contextPath.addSegment("semiannualfiscalcalendars").addKeys(new NameValue(userfiscalcalendarid, UUID.class)), Optional.empty());
    }

    public Semiannualfiscalcalendars semiannualfiscalcalendars() {
        return new Semiannualfiscalcalendars(
                        contextPath.addSegment("semiannualfiscalcalendars"));
    }

    public ServiceendpointRequest serviceendpoints(UUID serviceendpointid) {
        return new ServiceendpointRequest(contextPath.addSegment("serviceendpoints").addKeys(new NameValue(serviceendpointid, UUID.class)), Optional.empty());
    }

    public Serviceendpoints serviceendpoints() {
        return new Serviceendpoints(
                        contextPath.addSegment("serviceendpoints"));
    }

    public ServiceplanappmodulesRequest serviceplanappmodulesset(UUID serviceplanappmodulesid) {
        return new ServiceplanappmodulesRequest(contextPath.addSegment("serviceplanappmodulesset").addKeys(new NameValue(serviceplanappmodulesid, UUID.class)), Optional.empty());
    }

    public Serviceplanappmodulesset serviceplanappmodulesset() {
        return new Serviceplanappmodulesset(
                        contextPath.addSegment("serviceplanappmodulesset"));
    }

    public ServiceplanRequest serviceplans(UUID serviceplanid) {
        return new ServiceplanRequest(contextPath.addSegment("serviceplans").addKeys(new NameValue(serviceplanid, UUID.class)), Optional.empty());
    }

    public Serviceplans serviceplans() {
        return new Serviceplans(
                        contextPath.addSegment("serviceplans"));
    }

    public SharepointdocumentlocationRequest sharepointdocumentlocations(UUID sharepointdocumentlocationid) {
        return new SharepointdocumentlocationRequest(contextPath.addSegment("sharepointdocumentlocations").addKeys(new NameValue(sharepointdocumentlocationid, UUID.class)), Optional.empty());
    }

    public Sharepointdocumentlocations sharepointdocumentlocations() {
        return new Sharepointdocumentlocations(
                        contextPath.addSegment("sharepointdocumentlocations"));
    }

    public SharepointsiteRequest sharepointsites(UUID sharepointsiteid) {
        return new SharepointsiteRequest(contextPath.addSegment("sharepointsites").addKeys(new NameValue(sharepointsiteid, UUID.class)), Optional.empty());
    }

    public Sharepointsites sharepointsites() {
        return new Sharepointsites(
                        contextPath.addSegment("sharepointsites"));
    }

    public SimilarityruleRequest similarityrules(UUID similarityruleid) {
        return new SimilarityruleRequest(contextPath.addSegment("similarityrules").addKeys(new NameValue(similarityruleid, UUID.class)), Optional.empty());
    }

    public Similarityrules similarityrules() {
        return new Similarityrules(
                        contextPath.addSegment("similarityrules"));
    }

    public SitemapRequest sitemaps(UUID sitemapid) {
        return new SitemapRequest(contextPath.addSegment("sitemaps").addKeys(new NameValue(sitemapid, UUID.class)), Optional.empty());
    }

    public Sitemaps sitemaps() {
        return new Sitemaps(
                        contextPath.addSegment("sitemaps"));
    }

    public SlaitemRequest slaitems(UUID slaitemid) {
        return new SlaitemRequest(contextPath.addSegment("slaitems").addKeys(new NameValue(slaitemid, UUID.class)), Optional.empty());
    }

    public Slaitems slaitems() {
        return new Slaitems(
                        contextPath.addSegment("slaitems"));
    }

    public SlakpiinstanceRequest slakpiinstances(UUID slakpiinstanceid) {
        return new SlakpiinstanceRequest(contextPath.addSegment("slakpiinstances").addKeys(new NameValue(slakpiinstanceid, UUID.class)), Optional.empty());
    }

    public Slakpiinstances slakpiinstances() {
        return new Slakpiinstances(
                        contextPath.addSegment("slakpiinstances"));
    }

    public SlaRequest slas(UUID slaid) {
        return new SlaRequest(contextPath.addSegment("slas").addKeys(new NameValue(slaid, UUID.class)), Optional.empty());
    }

    public Slas slas() {
        return new Slas(
                        contextPath.addSegment("slas"));
    }

    public SocialactivityRequest socialactivities(UUID activityid) {
        return new SocialactivityRequest(contextPath.addSegment("socialactivities").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public Socialactivities socialactivities() {
        return new Socialactivities(
                        contextPath.addSegment("socialactivities"));
    }

    public SocialprofileRequest socialprofiles(UUID socialprofileid) {
        return new SocialprofileRequest(contextPath.addSegment("socialprofiles").addKeys(new NameValue(socialprofileid, UUID.class)), Optional.empty());
    }

    public Socialprofiles socialprofiles() {
        return new Socialprofiles(
                        contextPath.addSegment("socialprofiles"));
    }

    public SolutioncomponentattributeconfigurationRequest solutioncomponentattributeconfigurations(UUID solutioncomponentattributeconfigurationid) {
        return new SolutioncomponentattributeconfigurationRequest(contextPath.addSegment("solutioncomponentattributeconfigurations").addKeys(new NameValue(solutioncomponentattributeconfigurationid, UUID.class)), Optional.empty());
    }

    public Solutioncomponentattributeconfigurations solutioncomponentattributeconfigurations() {
        return new Solutioncomponentattributeconfigurations(
                        contextPath.addSegment("solutioncomponentattributeconfigurations"));
    }

    public SolutioncomponentconfigurationRequest solutioncomponentconfigurations(UUID solutioncomponentconfigurationid) {
        return new SolutioncomponentconfigurationRequest(contextPath.addSegment("solutioncomponentconfigurations").addKeys(new NameValue(solutioncomponentconfigurationid, UUID.class)), Optional.empty());
    }

    public Solutioncomponentconfigurations solutioncomponentconfigurations() {
        return new Solutioncomponentconfigurations(
                        contextPath.addSegment("solutioncomponentconfigurations"));
    }

    public SolutioncomponentrelationshipconfigurationRequest solutioncomponentrelationshipconfigurations(UUID solutioncomponentrelationshipconfigurationid) {
        return new SolutioncomponentrelationshipconfigurationRequest(contextPath.addSegment("solutioncomponentrelationshipconfigurations").addKeys(new NameValue(solutioncomponentrelationshipconfigurationid, UUID.class)), Optional.empty());
    }

    public Solutioncomponentrelationshipconfigurations solutioncomponentrelationshipconfigurations() {
        return new Solutioncomponentrelationshipconfigurations(
                        contextPath.addSegment("solutioncomponentrelationshipconfigurations"));
    }

    public SolutioncomponentRequest solutioncomponents(UUID solutioncomponentid) {
        return new SolutioncomponentRequest(contextPath.addSegment("solutioncomponents").addKeys(new NameValue(solutioncomponentid, UUID.class)), Optional.empty());
    }

    public Solutioncomponents solutioncomponents() {
        return new Solutioncomponents(
                        contextPath.addSegment("solutioncomponents"));
    }

    public SolutionhistorydataRequest solutionhistories(UUID solutionhistorydataid) {
        return new SolutionhistorydataRequest(contextPath.addSegment("solutionhistories").addKeys(new NameValue(solutionhistorydataid, UUID.class)), Optional.empty());
    }

    public Solutionhistories solutionhistories() {
        return new Solutionhistories(
                        contextPath.addSegment("solutionhistories"));
    }

    public SolutionRequest solutions(UUID solutionid) {
        return new SolutionRequest(contextPath.addSegment("solutions").addKeys(new NameValue(solutionid, UUID.class)), Optional.empty());
    }

    public Solutions solutions() {
        return new Solutions(
                        contextPath.addSegment("solutions"));
    }

    public StagesolutionuploadRequest stagesolutionuploads(UUID stagesolutionuploadid) {
        return new StagesolutionuploadRequest(contextPath.addSegment("stagesolutionuploads").addKeys(new NameValue(stagesolutionuploadid, UUID.class)), Optional.empty());
    }

    public Stagesolutionuploads stagesolutionuploads() {
        return new Stagesolutionuploads(
                        contextPath.addSegment("stagesolutionuploads"));
    }

    public SubjectRequest subjects(UUID subjectid) {
        return new SubjectRequest(contextPath.addSegment("subjects").addKeys(new NameValue(subjectid, UUID.class)), Optional.empty());
    }

    public Subjects subjects() {
        return new Subjects(
                        contextPath.addSegment("subjects"));
    }

    public SubscriptionmanuallytrackedobjectRequest subscriptionmanuallytrackedobjects(UUID subscriptionmanuallytrackedobjectid) {
        return new SubscriptionmanuallytrackedobjectRequest(contextPath.addSegment("subscriptionmanuallytrackedobjects").addKeys(new NameValue(subscriptionmanuallytrackedobjectid, UUID.class)), Optional.empty());
    }

    public Subscriptionmanuallytrackedobjects subscriptionmanuallytrackedobjects() {
        return new Subscriptionmanuallytrackedobjects(
                        contextPath.addSegment("subscriptionmanuallytrackedobjects"));
    }

    public SubscriptionstatisticsofflineRequest subscriptionstatisticsofflineset(UUID subscriptionid) {
        return new SubscriptionstatisticsofflineRequest(contextPath.addSegment("subscriptionstatisticsofflineset").addKeys(new NameValue(subscriptionid, UUID.class)), Optional.empty());
    }

    public Subscriptionstatisticsofflineset subscriptionstatisticsofflineset() {
        return new Subscriptionstatisticsofflineset(
                        contextPath.addSegment("subscriptionstatisticsofflineset"));
    }

    public SubscriptionstatisticsoutlookRequest subscriptionstatisticsoutlookset(UUID subscriptionid) {
        return new SubscriptionstatisticsoutlookRequest(contextPath.addSegment("subscriptionstatisticsoutlookset").addKeys(new NameValue(subscriptionid, UUID.class)), Optional.empty());
    }

    public Subscriptionstatisticsoutlookset subscriptionstatisticsoutlookset() {
        return new Subscriptionstatisticsoutlookset(
                        contextPath.addSegment("subscriptionstatisticsoutlookset"));
    }

    public SubscriptionsyncentryofflineRequest subscriptionsyncentriesoffline(UUID subscriptionid) {
        return new SubscriptionsyncentryofflineRequest(contextPath.addSegment("subscriptionsyncentriesoffline").addKeys(new NameValue(subscriptionid, UUID.class)), Optional.empty());
    }

    public Subscriptionsyncentriesoffline subscriptionsyncentriesoffline() {
        return new Subscriptionsyncentriesoffline(
                        contextPath.addSegment("subscriptionsyncentriesoffline"));
    }

    public SubscriptionsyncentryoutlookRequest subscriptionsyncentriesoutlook(UUID subscriptionid) {
        return new SubscriptionsyncentryoutlookRequest(contextPath.addSegment("subscriptionsyncentriesoutlook").addKeys(new NameValue(subscriptionid, UUID.class)), Optional.empty());
    }

    public Subscriptionsyncentriesoutlook subscriptionsyncentriesoutlook() {
        return new Subscriptionsyncentriesoutlook(
                        contextPath.addSegment("subscriptionsyncentriesoutlook"));
    }

    public SyncerrorRequest syncerrors(UUID syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("syncerrors").addKeys(new NameValue(syncerrorid, UUID.class)), Optional.empty());
    }

    public Syncerrors syncerrors() {
        return new Syncerrors(
                        contextPath.addSegment("syncerrors"));
    }

    public SystemformRequest systemforms(UUID formid) {
        return new SystemformRequest(contextPath.addSegment("systemforms").addKeys(new NameValue(formid, UUID.class)), Optional.empty());
    }

    public Systemforms systemforms() {
        return new Systemforms(
                        contextPath.addSegment("systemforms"));
    }

    public SystemuserlicensesRequest systemuserlicensescollection(UUID systemuserlicenseid) {
        return new SystemuserlicensesRequest(contextPath.addSegment("systemuserlicensescollection").addKeys(new NameValue(systemuserlicenseid, UUID.class)), Optional.empty());
    }

    public Systemuserlicensescollection systemuserlicensescollection() {
        return new Systemuserlicensescollection(
                        contextPath.addSegment("systemuserlicensescollection"));
    }

    public SystemuserprofilesRequest systemuserprofilescollection(UUID systemuserprofileid) {
        return new SystemuserprofilesRequest(contextPath.addSegment("systemuserprofilescollection").addKeys(new NameValue(systemuserprofileid, UUID.class)), Optional.empty());
    }

    public Systemuserprofilescollection systemuserprofilescollection() {
        return new Systemuserprofilescollection(
                        contextPath.addSegment("systemuserprofilescollection"));
    }

    public SystemuserrolesRequest systemuserrolescollection(UUID systemuserroleid) {
        return new SystemuserrolesRequest(contextPath.addSegment("systemuserrolescollection").addKeys(new NameValue(systemuserroleid, UUID.class)), Optional.empty());
    }

    public Systemuserrolescollection systemuserrolescollection() {
        return new Systemuserrolescollection(
                        contextPath.addSegment("systemuserrolescollection"));
    }

    public SystemuserRequest systemusers(UUID ownerid) {
        return new SystemuserRequest(contextPath.addSegment("systemusers").addKeys(new NameValue(ownerid, UUID.class)), Optional.empty());
    }

    public Systemusers systemusers() {
        return new Systemusers(
                        contextPath.addSegment("systemusers"));
    }

    public SystemusersyncmappingprofilesRequest systemusersyncmappingprofilescollection(UUID systemusersyncmappingprofileid) {
        return new SystemusersyncmappingprofilesRequest(contextPath.addSegment("systemusersyncmappingprofilescollection").addKeys(new NameValue(systemusersyncmappingprofileid, UUID.class)), Optional.empty());
    }

    public Systemusersyncmappingprofilescollection systemusersyncmappingprofilescollection() {
        return new Systemusersyncmappingprofilescollection(
                        contextPath.addSegment("systemusersyncmappingprofilescollection"));
    }

    public TaskRequest tasks(UUID activityid) {
        return new TaskRequest(contextPath.addSegment("tasks").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public Tasks tasks() {
        return new Tasks(
                        contextPath.addSegment("tasks"));
    }

    public TeammembershipRequest teammemberships(UUID teammembershipid) {
        return new TeammembershipRequest(contextPath.addSegment("teammemberships").addKeys(new NameValue(teammembershipid, UUID.class)), Optional.empty());
    }

    public Teammemberships teammemberships() {
        return new Teammemberships(
                        contextPath.addSegment("teammemberships"));
    }

    public TeamprofilesRequest teamprofilescollection(UUID teamprofileid) {
        return new TeamprofilesRequest(contextPath.addSegment("teamprofilescollection").addKeys(new NameValue(teamprofileid, UUID.class)), Optional.empty());
    }

    public Teamprofilescollection teamprofilescollection() {
        return new Teamprofilescollection(
                        contextPath.addSegment("teamprofilescollection"));
    }

    public TeamrolesRequest teamrolescollection(UUID teamroleid) {
        return new TeamrolesRequest(contextPath.addSegment("teamrolescollection").addKeys(new NameValue(teamroleid, UUID.class)), Optional.empty());
    }

    public Teamrolescollection teamrolescollection() {
        return new Teamrolescollection(
                        contextPath.addSegment("teamrolescollection"));
    }

    public TeamRequest teams(UUID ownerid) {
        return new TeamRequest(contextPath.addSegment("teams").addKeys(new NameValue(ownerid, UUID.class)), Optional.empty());
    }

    public Teams teams() {
        return new Teams(
                        contextPath.addSegment("teams"));
    }

    public TeamsyncattributemappingprofilesRequest teamsyncattributemappingprofilescollection(UUID teamsyncattributemappingprofileid) {
        return new TeamsyncattributemappingprofilesRequest(contextPath.addSegment("teamsyncattributemappingprofilescollection").addKeys(new NameValue(teamsyncattributemappingprofileid, UUID.class)), Optional.empty());
    }

    public Teamsyncattributemappingprofilescollection teamsyncattributemappingprofilescollection() {
        return new Teamsyncattributemappingprofilescollection(
                        contextPath.addSegment("teamsyncattributemappingprofilescollection"));
    }

    public TeamtemplateRequest teamtemplates(UUID teamtemplateid) {
        return new TeamtemplateRequest(contextPath.addSegment("teamtemplates").addKeys(new NameValue(teamtemplateid, UUID.class)), Optional.empty());
    }

    public Teamtemplates teamtemplates() {
        return new Teamtemplates(
                        contextPath.addSegment("teamtemplates"));
    }

    public TemplateRequest templates(UUID templateid) {
        return new TemplateRequest(contextPath.addSegment("templates").addKeys(new NameValue(templateid, UUID.class)), Optional.empty());
    }

    public Templates templates() {
        return new Templates(
                        contextPath.addSegment("templates"));
    }

    public TerritoryRequest territories(UUID territoryid) {
        return new TerritoryRequest(contextPath.addSegment("territories").addKeys(new NameValue(territoryid, UUID.class)), Optional.empty());
    }

    public Territories territories() {
        return new Territories(
                        contextPath.addSegment("territories"));
    }

    public ThemeRequest themes(UUID themeid) {
        return new ThemeRequest(contextPath.addSegment("themes").addKeys(new NameValue(themeid, UUID.class)), Optional.empty());
    }

    public Themes themes() {
        return new Themes(
                        contextPath.addSegment("themes"));
    }

    public TimestampdatemappingRequest timestampdatemappings(UUID timestampdatemappingid) {
        return new TimestampdatemappingRequest(contextPath.addSegment("timestampdatemappings").addKeys(new NameValue(timestampdatemappingid, UUID.class)), Optional.empty());
    }

    public Timestampdatemappings timestampdatemappings() {
        return new Timestampdatemappings(
                        contextPath.addSegment("timestampdatemappings"));
    }

    public TimezonedefinitionRequest timezonedefinitions(UUID timezonedefinitionid) {
        return new TimezonedefinitionRequest(contextPath.addSegment("timezonedefinitions").addKeys(new NameValue(timezonedefinitionid, UUID.class)), Optional.empty());
    }

    public Timezonedefinitions timezonedefinitions() {
        return new Timezonedefinitions(
                        contextPath.addSegment("timezonedefinitions"));
    }

    public TimezonelocalizednameRequest timezonelocalizednames(UUID timezonelocalizednameid) {
        return new TimezonelocalizednameRequest(contextPath.addSegment("timezonelocalizednames").addKeys(new NameValue(timezonelocalizednameid, UUID.class)), Optional.empty());
    }

    public Timezonelocalizednames timezonelocalizednames() {
        return new Timezonelocalizednames(
                        contextPath.addSegment("timezonelocalizednames"));
    }

    public TimezoneruleRequest timezonerules(UUID timezoneruleid) {
        return new TimezoneruleRequest(contextPath.addSegment("timezonerules").addKeys(new NameValue(timezoneruleid, UUID.class)), Optional.empty());
    }

    public Timezonerules timezonerules() {
        return new Timezonerules(
                        contextPath.addSegment("timezonerules"));
    }

    public TracelogRequest tracelogs(UUID tracelogid) {
        return new TracelogRequest(contextPath.addSegment("tracelogs").addKeys(new NameValue(tracelogid, UUID.class)), Optional.empty());
    }

    public Tracelogs tracelogs() {
        return new Tracelogs(
                        contextPath.addSegment("tracelogs"));
    }

    public TransactioncurrencyRequest transactioncurrencies(UUID transactioncurrencyid) {
        return new TransactioncurrencyRequest(contextPath.addSegment("transactioncurrencies").addKeys(new NameValue(transactioncurrencyid, UUID.class)), Optional.empty());
    }

    public Transactioncurrencies transactioncurrencies() {
        return new Transactioncurrencies(
                        contextPath.addSegment("transactioncurrencies"));
    }

    public TransformationmappingRequest transformationmappings(UUID transformationmappingid) {
        return new TransformationmappingRequest(contextPath.addSegment("transformationmappings").addKeys(new NameValue(transformationmappingid, UUID.class)), Optional.empty());
    }

    public Transformationmappings transformationmappings() {
        return new Transformationmappings(
                        contextPath.addSegment("transformationmappings"));
    }

    public TransformationparametermappingRequest transformationparametermappings(UUID transformationparametermappingid) {
        return new TransformationparametermappingRequest(contextPath.addSegment("transformationparametermappings").addKeys(new NameValue(transformationparametermappingid, UUID.class)), Optional.empty());
    }

    public Transformationparametermappings transformationparametermappings() {
        return new Transformationparametermappings(
                        contextPath.addSegment("transformationparametermappings"));
    }

    public TranslationprocessRequest translationprocesses(UUID businessprocessflowinstanceid) {
        return new TranslationprocessRequest(contextPath.addSegment("translationprocesses").addKeys(new NameValue(businessprocessflowinstanceid, UUID.class)), Optional.empty());
    }

    public Translationprocesses translationprocesses() {
        return new Translationprocesses(
                        contextPath.addSegment("translationprocesses"));
    }

    public UserformRequest userforms(UUID userformid) {
        return new UserformRequest(contextPath.addSegment("userforms").addKeys(new NameValue(userformid, UUID.class)), Optional.empty());
    }

    public Userforms userforms() {
        return new Userforms(
                        contextPath.addSegment("userforms"));
    }

    public UsermappingRequest usermappings(UUID usermappingid) {
        return new UsermappingRequest(contextPath.addSegment("usermappings").addKeys(new NameValue(usermappingid, UUID.class)), Optional.empty());
    }

    public Usermappings usermappings() {
        return new Usermappings(
                        contextPath.addSegment("usermappings"));
    }

    public UserqueryRequest userqueries(UUID userqueryid) {
        return new UserqueryRequest(contextPath.addSegment("userqueries").addKeys(new NameValue(userqueryid, UUID.class)), Optional.empty());
    }

    public Userqueries userqueries() {
        return new Userqueries(
                        contextPath.addSegment("userqueries"));
    }

    public UserqueryvisualizationRequest userqueryvisualizations(UUID userqueryvisualizationid) {
        return new UserqueryvisualizationRequest(contextPath.addSegment("userqueryvisualizations").addKeys(new NameValue(userqueryvisualizationid, UUID.class)), Optional.empty());
    }

    public Userqueryvisualizations userqueryvisualizations() {
        return new Userqueryvisualizations(
                        contextPath.addSegment("userqueryvisualizations"));
    }

    public UsersettingsRequest usersettingscollection(UUID systemuserid) {
        return new UsersettingsRequest(contextPath.addSegment("usersettingscollection").addKeys(new NameValue(systemuserid, UUID.class)), Optional.empty());
    }

    public Usersettingscollection usersettingscollection() {
        return new Usersettingscollection(
                        contextPath.addSegment("usersettingscollection"));
    }

    public WebresourceRequest webresourceset(UUID webresourceid) {
        return new WebresourceRequest(contextPath.addSegment("webresourceset").addKeys(new NameValue(webresourceid, UUID.class)), Optional.empty());
    }

    public Webresourceset webresourceset() {
        return new Webresourceset(
                        contextPath.addSegment("webresourceset"));
    }

    public WebwizardRequest webwizards(UUID webwizardid) {
        return new WebwizardRequest(contextPath.addSegment("webwizards").addKeys(new NameValue(webwizardid, UUID.class)), Optional.empty());
    }

    public Webwizards webwizards() {
        return new Webwizards(
                        contextPath.addSegment("webwizards"));
    }

    public WorkflowbinaryRequest workflowbinaries(UUID workflowbinaryid) {
        return new WorkflowbinaryRequest(contextPath.addSegment("workflowbinaries").addKeys(new NameValue(workflowbinaryid, UUID.class)), Optional.empty());
    }

    public Workflowbinaries workflowbinaries() {
        return new Workflowbinaries(
                        contextPath.addSegment("workflowbinaries"));
    }

    public WorkflowlogRequest workflowlogs(UUID workflowlogid) {
        return new WorkflowlogRequest(contextPath.addSegment("workflowlogs").addKeys(new NameValue(workflowlogid, UUID.class)), Optional.empty());
    }

    public Workflowlogs workflowlogs() {
        return new Workflowlogs(
                        contextPath.addSegment("workflowlogs"));
    }

    public WorkflowRequest workflows(UUID workflowid) {
        return new WorkflowRequest(contextPath.addSegment("workflows").addKeys(new NameValue(workflowid, UUID.class)), Optional.empty());
    }

    public Workflows workflows() {
        return new Workflows(
                        contextPath.addSegment("workflows"));
    }

    public EntityMetadataRequest entityDefinitions(UUID metadataId) {
        return new EntityMetadataRequest(contextPath.addSegment("EntityDefinitions").addKeys(new NameValue(metadataId, UUID.class)), Optional.empty());
    }

    public EntityDefinitions entityDefinitions() {
        return new EntityDefinitions(
                        contextPath.addSegment("EntityDefinitions"));
    }

    public OptionSetMetadataBaseRequest globalOptionSetDefinitions(UUID metadataId) {
        return new OptionSetMetadataBaseRequest(contextPath.addSegment("GlobalOptionSetDefinitions").addKeys(new NameValue(metadataId, UUID.class)), Optional.empty());
    }

    public GlobalOptionSetDefinitions globalOptionSetDefinitions() {
        return new GlobalOptionSetDefinitions(
                        contextPath.addSegment("GlobalOptionSetDefinitions"));
    }

    public ManagedPropertyMetadataRequest managedPropertyDefinitions(UUID metadataId) {
        return new ManagedPropertyMetadataRequest(contextPath.addSegment("ManagedPropertyDefinitions").addKeys(new NameValue(metadataId, UUID.class)), Optional.empty());
    }

    public ManagedPropertyDefinitions managedPropertyDefinitions() {
        return new ManagedPropertyDefinitions(
                        contextPath.addSegment("ManagedPropertyDefinitions"));
    }

    public RelationshipMetadataBaseRequest relationshipDefinitions(UUID metadataId) {
        return new RelationshipMetadataBaseRequest(contextPath.addSegment("RelationshipDefinitions").addKeys(new NameValue(metadataId, UUID.class)), Optional.empty());
    }

    public RelationshipDefinitions relationshipDefinitions() {
        return new RelationshipDefinitions(
                        contextPath.addSegment("RelationshipDefinitions"));
    }

    @Action(name = "AddAppComponents")
    @JsonIgnore
    public ActionRequestNoReturn addAppComponents(UUID appId, List<Crmbaseentity> components) {
        Preconditions.checkNotNull(appId, "appId cannot be null");
        Preconditions.checkNotNull(components, "components cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("AppId", "Edm.Guid", appId)
            .put("Components", "Collection(Microsoft.Dynamics.CRM.crmbaseentity)", components)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.AddAppComponents"), _parameters);
    }

    @Action(name = "AddChannelAccessProfilePrivileges")
    @JsonIgnore
    public ActionRequestNoReturn addChannelAccessProfilePrivileges(UUID channelAccessProfileId, List<ChannelAccessProfilePrivilege> privileges) {
        Preconditions.checkNotNull(channelAccessProfileId, "channelAccessProfileId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ChannelAccessProfileId", "Edm.Guid", channelAccessProfileId)
            .put("Privileges", "Collection(Microsoft.Dynamics.CRM.ChannelAccessProfilePrivilege)", privileges)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.AddChannelAccessProfilePrivileges"), _parameters);
    }

    @Action(name = "AddSolutionComponent")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<AddSolutionComponentResponse> addSolutionComponent(UUID componentId, Integer componentType, String solutionUniqueName, Boolean addRequiredComponents, Boolean doNotIncludeSubcomponents, List<String> includedComponentSettingsValues) {
        Preconditions.checkNotNull(componentId, "componentId cannot be null");
        Preconditions.checkNotNull(componentType, "componentType cannot be null");
        Preconditions.checkNotNull(solutionUniqueName, "solutionUniqueName cannot be null");
        Preconditions.checkNotNull(addRequiredComponents, "addRequiredComponents cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ComponentId", "Edm.Guid", componentId)
            .put("ComponentType", "Edm.Int32", componentType)
            .put("SolutionUniqueName", "Edm.String", Checks.checkIsAscii(solutionUniqueName))
            .put("AddRequiredComponents", "Edm.Boolean", addRequiredComponents)
            .put("DoNotIncludeSubcomponents", "Edm.Boolean", doNotIncludeSubcomponents)
            .put("IncludedComponentSettingsValues", "Collection(Edm.String)", Checks.checkIsAscii(includedComponentSettingsValues))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<AddSolutionComponentResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.AddSolutionComponent"), AddSolutionComponentResponse.class, _parameters);
    }

    @Action(name = "AlmHandler")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<AlmHandlerResponse> almHandler(String action, String input) {
        Preconditions.checkNotNull(action, "action cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("action", "Edm.String", Checks.checkIsAscii(action))
            .put("input", "Edm.String", Checks.checkIsAscii(input))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<AlmHandlerResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.AlmHandler"), AlmHandlerResponse.class, _parameters);
    }

    @Action(name = "AnalyzeSentiment")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<AnalyzeSentimentResponse> analyzeSentiment(String text, UUID modelId, String language) {
        Preconditions.checkNotNull(text, "text cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("text", "Edm.String", Checks.checkIsAscii(text))
            .put("modelId", "Edm.Guid", modelId)
            .put("language", "Edm.String", Checks.checkIsAscii(language))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<AnalyzeSentimentResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.AnalyzeSentiment"), AnalyzeSentimentResponse.class, _parameters);
    }

    @Action(name = "ApplyRecordCreationAndUpdateRule")
    @JsonIgnore
    public ActionRequestNoReturn applyRecordCreationAndUpdateRule(Crmbaseentity target) {
        Preconditions.checkNotNull(target, "target cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Target", "Microsoft.Dynamics.CRM.crmbaseentity", target)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.ApplyRecordCreationAndUpdateRule"), _parameters);
    }

    @Action(name = "AutoMapEntity")
    @JsonIgnore
    public ActionRequestNoReturn autoMapEntity(UUID entityMapId) {
        Preconditions.checkNotNull(entityMapId, "entityMapId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("EntityMapId", "Edm.Guid", entityMapId)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.AutoMapEntity"), _parameters);
    }

    @Action(name = "BackgroundSendEmail")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<BackgroundSendEmailResponse> backgroundSendEmail(QueryBase query) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Query", "Microsoft.Dynamics.CRM.QueryBase", query)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<BackgroundSendEmailResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.BackgroundSendEmail"), BackgroundSendEmailResponse.class, _parameters);
    }

    @Action(name = "Book")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<BookResponse> book(Crmbaseentity target, Boolean returnNotifications) {
        Preconditions.checkNotNull(target, "target cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Target", "Microsoft.Dynamics.CRM.crmbaseentity", target)
            .put("ReturnNotifications", "Edm.Boolean", returnNotifications)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<BookResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.Book"), BookResponse.class, _parameters);
    }

    @Action(name = "BulkDelete")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<BulkDeleteResponse> bulkDelete(List<QueryExpression> querySet, String jobName, Boolean sendEmailNotification, List<Activityparty> toRecipients, List<Activityparty> cCRecipients, String recurrencePattern, OffsetDateTime startDateTime, UUID sourceImportId, Boolean runNow) {
        Preconditions.checkNotNull(jobName, "jobName cannot be null");
        Preconditions.checkNotNull(sendEmailNotification, "sendEmailNotification cannot be null");
        Preconditions.checkNotNull(toRecipients, "toRecipients cannot be null");
        Preconditions.checkNotNull(cCRecipients, "cCRecipients cannot be null");
        Preconditions.checkNotNull(recurrencePattern, "recurrencePattern cannot be null");
        Preconditions.checkNotNull(startDateTime, "startDateTime cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("QuerySet", "Collection(Microsoft.Dynamics.CRM.QueryExpression)", querySet)
            .put("JobName", "Edm.String", Checks.checkIsAscii(jobName))
            .put("SendEmailNotification", "Edm.Boolean", sendEmailNotification)
            .put("ToRecipients", "Collection(Microsoft.Dynamics.CRM.activityparty)", toRecipients)
            .put("CCRecipients", "Collection(Microsoft.Dynamics.CRM.activityparty)", cCRecipients)
            .put("RecurrencePattern", "Edm.String", Checks.checkIsAscii(recurrencePattern))
            .put("StartDateTime", "Edm.DateTimeOffset", startDateTime)
            .put("SourceImportId", "Edm.Guid", sourceImportId)
            .put("RunNow", "Edm.Boolean", runNow)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<BulkDeleteResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.BulkDelete"), BulkDeleteResponse.class, _parameters);
    }

    @Action(name = "BulkDetectDuplicates")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<BulkDetectDuplicatesResponse> bulkDetectDuplicates(QueryBase query, String jobName, Boolean sendEmailNotification, UUID templateId, List<Activityparty> toRecipients, List<Activityparty> cCRecipients, String recurrencePattern, OffsetDateTime recurrenceStartTime) {
        Preconditions.checkNotNull(jobName, "jobName cannot be null");
        Preconditions.checkNotNull(sendEmailNotification, "sendEmailNotification cannot be null");
        Preconditions.checkNotNull(templateId, "templateId cannot be null");
        Preconditions.checkNotNull(toRecipients, "toRecipients cannot be null");
        Preconditions.checkNotNull(cCRecipients, "cCRecipients cannot be null");
        Preconditions.checkNotNull(recurrencePattern, "recurrencePattern cannot be null");
        Preconditions.checkNotNull(recurrenceStartTime, "recurrenceStartTime cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Query", "Microsoft.Dynamics.CRM.QueryBase", query)
            .put("JobName", "Edm.String", Checks.checkIsAscii(jobName))
            .put("SendEmailNotification", "Edm.Boolean", sendEmailNotification)
            .put("TemplateId", "Edm.Guid", templateId)
            .put("ToRecipients", "Collection(Microsoft.Dynamics.CRM.activityparty)", toRecipients)
            .put("CCRecipients", "Collection(Microsoft.Dynamics.CRM.activityparty)", cCRecipients)
            .put("RecurrencePattern", "Edm.String", Checks.checkIsAscii(recurrencePattern))
            .put("RecurrenceStartTime", "Edm.DateTimeOffset", recurrenceStartTime)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<BulkDetectDuplicatesResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.BulkDetectDuplicates"), BulkDetectDuplicatesResponse.class, _parameters);
    }

    @Action(name = "CalculatePrice")
    @JsonIgnore
    public ActionRequestNoReturn calculatePrice(Crmbaseentity target, UUID parentId) {
        Preconditions.checkNotNull(target, "target cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Target", "Microsoft.Dynamics.CRM.crmbaseentity", target)
            .put("ParentId", "Edm.Guid", parentId)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.CalculatePrice"), _parameters);
    }

    @Action(name = "CanBeReferenced")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<CanBeReferencedResponse> canBeReferenced(String entityName) {
        Preconditions.checkNotNull(entityName, "entityName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("EntityName", "Edm.String", Checks.checkIsAscii(entityName))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<CanBeReferencedResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.CanBeReferenced"), CanBeReferencedResponse.class, _parameters);
    }

    @Action(name = "CanBeReferencing")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<CanBeReferencingResponse> canBeReferencing(String entityName) {
        Preconditions.checkNotNull(entityName, "entityName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("EntityName", "Edm.String", Checks.checkIsAscii(entityName))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<CanBeReferencingResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.CanBeReferencing"), CanBeReferencingResponse.class, _parameters);
    }

    @Action(name = "CanManyToMany")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<CanManyToManyResponse> canManyToMany(String entityName) {
        Preconditions.checkNotNull(entityName, "entityName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("EntityName", "Edm.String", Checks.checkIsAscii(entityName))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<CanManyToManyResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.CanManyToMany"), CanManyToManyResponse.class, _parameters);
    }

    @Action(name = "CategorizeText")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<CategorizeTextResponse> categorizeText(String text, UUID modelId, String language) {
        Preconditions.checkNotNull(text, "text cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("text", "Edm.String", Checks.checkIsAscii(text))
            .put("modelId", "Edm.Guid", modelId)
            .put("language", "Edm.String", Checks.checkIsAscii(language))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<CategorizeTextResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.CategorizeText"), CategorizeTextResponse.class, _parameters);
    }

    @Action(name = "CloneAsPatch")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<CloneAsPatchResponse> cloneAsPatch(String parentSolutionUniqueName, String displayName, String versionNumber) {
        Preconditions.checkNotNull(parentSolutionUniqueName, "parentSolutionUniqueName cannot be null");
        Preconditions.checkNotNull(displayName, "displayName cannot be null");
        Preconditions.checkNotNull(versionNumber, "versionNumber cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ParentSolutionUniqueName", "Edm.String", Checks.checkIsAscii(parentSolutionUniqueName))
            .put("DisplayName", "Edm.String", Checks.checkIsAscii(displayName))
            .put("VersionNumber", "Edm.String", Checks.checkIsAscii(versionNumber))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<CloneAsPatchResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.CloneAsPatch"), CloneAsPatchResponse.class, _parameters);
    }

    @Action(name = "CloneAsSolution")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<CloneAsSolutionResponse> cloneAsSolution(String parentSolutionUniqueName, String displayName, String versionNumber) {
        Preconditions.checkNotNull(parentSolutionUniqueName, "parentSolutionUniqueName cannot be null");
        Preconditions.checkNotNull(displayName, "displayName cannot be null");
        Preconditions.checkNotNull(versionNumber, "versionNumber cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ParentSolutionUniqueName", "Edm.String", Checks.checkIsAscii(parentSolutionUniqueName))
            .put("DisplayName", "Edm.String", Checks.checkIsAscii(displayName))
            .put("VersionNumber", "Edm.String", Checks.checkIsAscii(versionNumber))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<CloneAsSolutionResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.CloneAsSolution"), CloneAsSolutionResponse.class, _parameters);
    }

    @Action(name = "CommitAnnotationBlocksUpload")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<CommitAnnotationBlocksUploadResponse> commitAnnotationBlocksUpload(Crmbaseentity target, List<String> blockList, String fileContinuationToken) {
        Preconditions.checkNotNull(target, "target cannot be null");
        Preconditions.checkNotNull(blockList, "blockList cannot be null");
        Preconditions.checkNotNull(fileContinuationToken, "fileContinuationToken cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Target", "Microsoft.Dynamics.CRM.crmbaseentity", target)
            .put("BlockList", "Collection(Edm.String)", Checks.checkIsAscii(blockList))
            .put("FileContinuationToken", "Edm.String", Checks.checkIsAscii(fileContinuationToken))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<CommitAnnotationBlocksUploadResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.CommitAnnotationBlocksUpload"), CommitAnnotationBlocksUploadResponse.class, _parameters);
    }

    @Action(name = "CommitAttachmentBlocksUpload")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<CommitAttachmentBlocksUploadResponse> commitAttachmentBlocksUpload(Crmbaseentity target, List<String> blockList, String fileContinuationToken) {
        Preconditions.checkNotNull(target, "target cannot be null");
        Preconditions.checkNotNull(blockList, "blockList cannot be null");
        Preconditions.checkNotNull(fileContinuationToken, "fileContinuationToken cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Target", "Microsoft.Dynamics.CRM.crmbaseentity", target)
            .put("BlockList", "Collection(Edm.String)", Checks.checkIsAscii(blockList))
            .put("FileContinuationToken", "Edm.String", Checks.checkIsAscii(fileContinuationToken))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<CommitAttachmentBlocksUploadResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.CommitAttachmentBlocksUpload"), CommitAttachmentBlocksUploadResponse.class, _parameters);
    }

    @Action(name = "CommitFileBlocksUpload")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<CommitFileBlocksUploadResponse> commitFileBlocksUpload(String fileName, String mimeType, List<String> blockList, String fileContinuationToken) {
        Preconditions.checkNotNull(fileName, "fileName cannot be null");
        Preconditions.checkNotNull(mimeType, "mimeType cannot be null");
        Preconditions.checkNotNull(blockList, "blockList cannot be null");
        Preconditions.checkNotNull(fileContinuationToken, "fileContinuationToken cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("FileName", "Edm.String", Checks.checkIsAscii(fileName))
            .put("MimeType", "Edm.String", Checks.checkIsAscii(mimeType))
            .put("BlockList", "Collection(Edm.String)", Checks.checkIsAscii(blockList))
            .put("FileContinuationToken", "Edm.String", Checks.checkIsAscii(fileContinuationToken))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<CommitFileBlocksUploadResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.CommitFileBlocksUpload"), CommitFileBlocksUploadResponse.class, _parameters);
    }

    @Action(name = "CompoundUpdateDuplicateDetectionRule")
    @JsonIgnore
    public ActionRequestNoReturn compoundUpdateDuplicateDetectionRule(Crmbaseentity entity, List<Crmbaseentity> childEntities) {
        Preconditions.checkNotNull(entity, "entity cannot be null");
        Preconditions.checkNotNull(childEntities, "childEntities cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Entity", "Microsoft.Dynamics.CRM.crmbaseentity", entity)
            .put("ChildEntities", "Collection(Microsoft.Dynamics.CRM.crmbaseentity)", childEntities)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.CompoundUpdateDuplicateDetectionRule"), _parameters);
    }

    @Action(name = "CreateAsyncJobToRevokeInheritedAccess")
    @JsonIgnore
    public ActionRequestNoReturn createAsyncJobToRevokeInheritedAccess(String relationshipSchema) {
        Preconditions.checkNotNull(relationshipSchema, "relationshipSchema cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("RelationshipSchema", "Edm.String", Checks.checkIsAscii(relationshipSchema))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.CreateAsyncJobToRevokeInheritedAccess"), _parameters);
    }

    @Action(name = "CreateCustomerRelationships")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<CreateCustomerRelationshipsResponse> createCustomerRelationships(ComplexLookupAttributeMetadata lookup, List<ComplexOneToManyRelationshipMetadata> oneToManyRelationships, String solutionUniqueName) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Lookup", "Microsoft.Dynamics.CRM.ComplexLookupAttributeMetadata", lookup)
            .put("OneToManyRelationships", "Collection(Microsoft.Dynamics.CRM.ComplexOneToManyRelationshipMetadata)", oneToManyRelationships)
            .put("SolutionUniqueName", "Edm.String", Checks.checkIsAscii(solutionUniqueName))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<CreateCustomerRelationshipsResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.CreateCustomerRelationships"), CreateCustomerRelationshipsResponse.class, _parameters);
    }

    @Action(name = "CreateInstance")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<CreateInstanceResponse> createInstance(Crmbaseentity target, Integer count) {
        Preconditions.checkNotNull(target, "target cannot be null");
        Preconditions.checkNotNull(count, "count cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Target", "Microsoft.Dynamics.CRM.crmbaseentity", target)
            .put("Count", "Edm.Int32", count)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<CreateInstanceResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.CreateInstance"), CreateInstanceResponse.class, _parameters);
    }

    @Action(name = "CreateKnowledgeArticleTranslation")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Crmbaseentity> createKnowledgeArticleTranslation(Crmbaseentity source, Crmbaseentity language, Boolean isMajor) {
        Preconditions.checkNotNull(source, "source cannot be null");
        Preconditions.checkNotNull(language, "language cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Source", "Microsoft.Dynamics.CRM.crmbaseentity", source)
            .put("Language", "Microsoft.Dynamics.CRM.crmbaseentity", language)
            .put("IsMajor", "Edm.Boolean", isMajor)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<Crmbaseentity>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.CreateKnowledgeArticleTranslation"), Crmbaseentity.class, _parameters);
    }

    @Action(name = "CreateKnowledgeArticleVersion")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Crmbaseentity> createKnowledgeArticleVersion(Crmbaseentity source, Boolean isMajor) {
        Preconditions.checkNotNull(source, "source cannot be null");
        Preconditions.checkNotNull(isMajor, "isMajor cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Source", "Microsoft.Dynamics.CRM.crmbaseentity", source)
            .put("IsMajor", "Edm.Boolean", isMajor)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<Crmbaseentity>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.CreateKnowledgeArticleVersion"), Crmbaseentity.class, _parameters);
    }

    @Action(name = "DeleteAndPromote")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<DeleteAndPromoteResponse> deleteAndPromote(String uniqueName) {
        Preconditions.checkNotNull(uniqueName, "uniqueName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("UniqueName", "Edm.String", Checks.checkIsAscii(uniqueName))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<DeleteAndPromoteResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.DeleteAndPromote"), DeleteAndPromoteResponse.class, _parameters);
    }

    @Action(name = "DeleteAuditData")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<DeleteAuditDataResponse> deleteAuditData(OffsetDateTime endDate) {
        Preconditions.checkNotNull(endDate, "endDate cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("EndDate", "Edm.DateTimeOffset", endDate)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<DeleteAuditDataResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.DeleteAuditData"), DeleteAuditDataResponse.class, _parameters);
    }

    @Action(name = "DeleteFile")
    @JsonIgnore
    public ActionRequestNoReturn deleteFile(UUID fileId) {
        Preconditions.checkNotNull(fileId, "fileId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("FileId", "Edm.Guid", fileId)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.DeleteFile"), _parameters);
    }

    @Action(name = "DeleteOpenInstances")
    @JsonIgnore
    public ActionRequestNoReturn deleteOpenInstances(Recurringappointmentmaster target, OffsetDateTime seriesEndDate, Integer stateOfPastInstances) {
        Preconditions.checkNotNull(target, "target cannot be null");
        Preconditions.checkNotNull(seriesEndDate, "seriesEndDate cannot be null");
        Preconditions.checkNotNull(stateOfPastInstances, "stateOfPastInstances cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Target", "Microsoft.Dynamics.CRM.recurringappointmentmaster", target)
            .put("SeriesEndDate", "Edm.DateTimeOffset", seriesEndDate)
            .put("StateOfPastInstances", "Edm.Int32", stateOfPastInstances)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.DeleteOpenInstances"), _parameters);
    }

    @Action(name = "DeleteOptionValue")
    @JsonIgnore
    public ActionRequestNoReturn deleteOptionValue(String optionSetName, String attributeLogicalName, String entityLogicalName, Integer value, String solutionUniqueName) {
        Preconditions.checkNotNull(value, "value cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("OptionSetName", "Edm.String", Checks.checkIsAscii(optionSetName))
            .put("AttributeLogicalName", "Edm.String", Checks.checkIsAscii(attributeLogicalName))
            .put("EntityLogicalName", "Edm.String", Checks.checkIsAscii(entityLogicalName))
            .put("Value", "Edm.Int32", value)
            .put("SolutionUniqueName", "Edm.String", Checks.checkIsAscii(solutionUniqueName))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.DeleteOptionValue"), _parameters);
    }

    @Action(name = "DeleteRecordChangeHistory")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<DeleteRecordChangeHistoryResponse> deleteRecordChangeHistory(Crmbaseentity target) {
        Preconditions.checkNotNull(target, "target cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Target", "Microsoft.Dynamics.CRM.crmbaseentity", target)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<DeleteRecordChangeHistoryResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.DeleteRecordChangeHistory"), DeleteRecordChangeHistoryResponse.class, _parameters);
    }

    @Action(name = "DeprovisionLanguage")
    @JsonIgnore
    public ActionRequestNoReturn deprovisionLanguage(Integer language) {
        Preconditions.checkNotNull(language, "language cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Language", "Edm.Int32", language)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.DeprovisionLanguage"), _parameters);
    }

    @Action(name = "DetectLanguage")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<DetectLanguageResponse> detectLanguage(String text, UUID modelId, String countryHint) {
        Preconditions.checkNotNull(text, "text cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("text", "Edm.String", Checks.checkIsAscii(text))
            .put("modelId", "Edm.Guid", modelId)
            .put("countryHint", "Edm.String", Checks.checkIsAscii(countryHint))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<DetectLanguageResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.DetectLanguage"), DetectLanguageResponse.class, _parameters);
    }

    @Action(name = "DownloadBlock")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<DownloadBlockResponse> downloadBlock(Long offset, Long blockLength, String fileContinuationToken) {
        Preconditions.checkNotNull(offset, "offset cannot be null");
        Preconditions.checkNotNull(blockLength, "blockLength cannot be null");
        Preconditions.checkNotNull(fileContinuationToken, "fileContinuationToken cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Offset", "Edm.Int64", offset)
            .put("BlockLength", "Edm.Int64", blockLength)
            .put("FileContinuationToken", "Edm.String", Checks.checkIsAscii(fileContinuationToken))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<DownloadBlockResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.DownloadBlock"), DownloadBlockResponse.class, _parameters);
    }

    @Action(name = "DownloadSolutionExportData")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<DownloadSolutionExportDataResponse> downloadSolutionExportData(UUID exportJobId) {
        Preconditions.checkNotNull(exportJobId, "exportJobId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ExportJobId", "Edm.Guid", exportJobId)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<DownloadSolutionExportDataResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.DownloadSolutionExportData"), DownloadSolutionExportDataResponse.class, _parameters);
    }

    @Action(name = "ExportSolution")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<ExportSolutionResponse> exportSolution(String solutionName, Boolean managed, String targetVersion, Boolean exportAutoNumberingSettings, Boolean exportCalendarSettings, Boolean exportCustomizationSettings, Boolean exportEmailTrackingSettings, Boolean exportGeneralSettings, Boolean exportMarketingSettings, Boolean exportOutlookSynchronizationSettings, Boolean exportRelationshipRoles, Boolean exportIsvConfig, Boolean exportSales, Boolean exportExternalApplications) {
        Preconditions.checkNotNull(solutionName, "solutionName cannot be null");
        Preconditions.checkNotNull(managed, "managed cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("SolutionName", "Edm.String", Checks.checkIsAscii(solutionName))
            .put("Managed", "Edm.Boolean", managed)
            .put("TargetVersion", "Edm.String", Checks.checkIsAscii(targetVersion))
            .put("ExportAutoNumberingSettings", "Edm.Boolean", exportAutoNumberingSettings)
            .put("ExportCalendarSettings", "Edm.Boolean", exportCalendarSettings)
            .put("ExportCustomizationSettings", "Edm.Boolean", exportCustomizationSettings)
            .put("ExportEmailTrackingSettings", "Edm.Boolean", exportEmailTrackingSettings)
            .put("ExportGeneralSettings", "Edm.Boolean", exportGeneralSettings)
            .put("ExportMarketingSettings", "Edm.Boolean", exportMarketingSettings)
            .put("ExportOutlookSynchronizationSettings", "Edm.Boolean", exportOutlookSynchronizationSettings)
            .put("ExportRelationshipRoles", "Edm.Boolean", exportRelationshipRoles)
            .put("ExportIsvConfig", "Edm.Boolean", exportIsvConfig)
            .put("ExportSales", "Edm.Boolean", exportSales)
            .put("ExportExternalApplications", "Edm.Boolean", exportExternalApplications)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<ExportSolutionResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.ExportSolution"), ExportSolutionResponse.class, _parameters);
    }

    @Action(name = "ExportSolutionAsync")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<ExportSolutionAsyncResponse> exportSolutionAsync(String solutionName, Boolean managed, String targetVersion, Boolean exportAutoNumberingSettings, Boolean exportCalendarSettings, Boolean exportCustomizationSettings, Boolean exportEmailTrackingSettings, Boolean exportGeneralSettings, Boolean exportMarketingSettings, Boolean exportOutlookSynchronizationSettings, Boolean exportRelationshipRoles, Boolean exportIsvConfig, Boolean exportSales, Boolean exportExternalApplications) {
        Preconditions.checkNotNull(solutionName, "solutionName cannot be null");
        Preconditions.checkNotNull(managed, "managed cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("SolutionName", "Edm.String", Checks.checkIsAscii(solutionName))
            .put("Managed", "Edm.Boolean", managed)
            .put("TargetVersion", "Edm.String", Checks.checkIsAscii(targetVersion))
            .put("ExportAutoNumberingSettings", "Edm.Boolean", exportAutoNumberingSettings)
            .put("ExportCalendarSettings", "Edm.Boolean", exportCalendarSettings)
            .put("ExportCustomizationSettings", "Edm.Boolean", exportCustomizationSettings)
            .put("ExportEmailTrackingSettings", "Edm.Boolean", exportEmailTrackingSettings)
            .put("ExportGeneralSettings", "Edm.Boolean", exportGeneralSettings)
            .put("ExportMarketingSettings", "Edm.Boolean", exportMarketingSettings)
            .put("ExportOutlookSynchronizationSettings", "Edm.Boolean", exportOutlookSynchronizationSettings)
            .put("ExportRelationshipRoles", "Edm.Boolean", exportRelationshipRoles)
            .put("ExportIsvConfig", "Edm.Boolean", exportIsvConfig)
            .put("ExportSales", "Edm.Boolean", exportSales)
            .put("ExportExternalApplications", "Edm.Boolean", exportExternalApplications)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<ExportSolutionAsyncResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.ExportSolutionAsync"), ExportSolutionAsyncResponse.class, _parameters);
    }

    @Action(name = "ExtractKeyPhrases")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<ExtractKeyPhrasesResponse> extractKeyPhrases(String text, UUID modelId, String language) {
        Preconditions.checkNotNull(text, "text cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("text", "Edm.String", Checks.checkIsAscii(text))
            .put("modelId", "Edm.Guid", modelId)
            .put("language", "Edm.String", Checks.checkIsAscii(language))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<ExtractKeyPhrasesResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.ExtractKeyPhrases"), ExtractKeyPhrasesResponse.class, _parameters);
    }

    @Action(name = "ExtractTextEntities")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<ExtractTextEntitiesResponse> extractTextEntities(String text, UUID modelId, String language) {
        Preconditions.checkNotNull(text, "text cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("text", "Edm.String", Checks.checkIsAscii(text))
            .put("modelId", "Edm.Guid", modelId)
            .put("language", "Edm.String", Checks.checkIsAscii(language))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<ExtractTextEntitiesResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.ExtractTextEntities"), ExtractTextEntitiesResponse.class, _parameters);
    }

    @Action(name = "FullTextSearchKnowledgeArticle")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Crmbaseentity> fullTextSearchKnowledgeArticle(String searchText, Boolean useInflection, Boolean removeDuplicates, Integer stateCode, QueryBase queryExpression) {
        Preconditions.checkNotNull(searchText, "searchText cannot be null");
        Preconditions.checkNotNull(useInflection, "useInflection cannot be null");
        Preconditions.checkNotNull(removeDuplicates, "removeDuplicates cannot be null");
        Preconditions.checkNotNull(stateCode, "stateCode cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("SearchText", "Edm.String", Checks.checkIsAscii(searchText))
            .put("UseInflection", "Edm.Boolean", useInflection)
            .put("RemoveDuplicates", "Edm.Boolean", removeDuplicates)
            .put("StateCode", "Edm.Int32", stateCode)
            .put("QueryExpression", "Microsoft.Dynamics.CRM.QueryBase", queryExpression)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.FullTextSearchKnowledgeArticle"), Crmbaseentity.class, _parameters);
    }

    @Action(name = "GetAutoNumberSeed")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<GetAutoNumberSeedResponse> getAutoNumberSeed(String entityName, String attributeName) {
        Preconditions.checkNotNull(entityName, "entityName cannot be null");
        Preconditions.checkNotNull(attributeName, "attributeName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("EntityName", "Edm.String", Checks.checkIsAscii(entityName))
            .put("AttributeName", "Edm.String", Checks.checkIsAscii(attributeName))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<GetAutoNumberSeedResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.GetAutoNumberSeed"), GetAutoNumberSeedResponse.class, _parameters);
    }

    @Action(name = "GetJobStatus")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<GetJobStatusResponse> getJobStatus(Boolean istrain, UUID correlationid, UUID aimodelid) {
        Preconditions.checkNotNull(istrain, "istrain cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("istrain", "Edm.Boolean", istrain)
            .put("correlationid", "Edm.Guid", correlationid)
            .put("aimodelid", "Edm.Guid", aimodelid)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<GetJobStatusResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.GetJobStatus"), GetJobStatusResponse.class, _parameters);
    }

    @Action(name = "GetNextAutoNumberValue")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<GetNextAutoNumberValueResponse> getNextAutoNumberValue(String entityName, String attributeName) {
        Preconditions.checkNotNull(entityName, "entityName cannot be null");
        Preconditions.checkNotNull(attributeName, "attributeName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("EntityName", "Edm.String", Checks.checkIsAscii(entityName))
            .put("AttributeName", "Edm.String", Checks.checkIsAscii(attributeName))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<GetNextAutoNumberValueResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.GetNextAutoNumberValue"), GetNextAutoNumberValueResponse.class, _parameters);
    }

    @Action(name = "GetTrackingTokenEmail")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<GetTrackingTokenEmailResponse> getTrackingTokenEmail(String subject) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Subject", "Edm.String", Checks.checkIsAscii(subject))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<GetTrackingTokenEmailResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.GetTrackingTokenEmail"), GetTrackingTokenEmailResponse.class, _parameters);
    }

    @Action(name = "GrantAccess")
    @JsonIgnore
    public ActionRequestNoReturn grantAccess(Crmbaseentity target, PrincipalAccess principalAccess) {
        Preconditions.checkNotNull(target, "target cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Target", "Microsoft.Dynamics.CRM.crmbaseentity", target)
            .put("PrincipalAccess", "Microsoft.Dynamics.CRM.PrincipalAccess", principalAccess)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.GrantAccess"), _parameters);
    }

    @Action(name = "ImmediateBook")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<ImmediateBookResponse> immediateBook(Crmbaseentity target, List<String> attachmentIds, String eWSUrl, String attachmentToken) {
        Preconditions.checkNotNull(target, "target cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Target", "Microsoft.Dynamics.CRM.crmbaseentity", target)
            .put("AttachmentIds", "Collection(Edm.String)", Checks.checkIsAscii(attachmentIds))
            .put("EWSUrl", "Edm.String", Checks.checkIsAscii(eWSUrl))
            .put("AttachmentToken", "Edm.String", Checks.checkIsAscii(attachmentToken))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<ImmediateBookResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.ImmediateBook"), ImmediateBookResponse.class, _parameters);
    }

    @Action(name = "ImportCardTypeSchema")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<ImportCardTypeSchemaResponse> importCardTypeSchema(String importCardTypeSchema) {
        Preconditions.checkNotNull(importCardTypeSchema, "importCardTypeSchema cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ImportCardTypeSchema", "Edm.String", Checks.checkIsAscii(importCardTypeSchema))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<ImportCardTypeSchemaResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.ImportCardTypeSchema"), ImportCardTypeSchemaResponse.class, _parameters);
    }

    @Action(name = "ImportFieldTranslation")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Importjob> importFieldTranslation(byte[] translationFile) {
        Preconditions.checkNotNull(translationFile, "translationFile cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("TranslationFile", "Edm.Binary", translationFile)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<Importjob>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.ImportFieldTranslation"), Importjob.class, _parameters);
    }

    @Action(name = "ImportMappingsImportMap")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Importmap> importMappingsImportMap(String mappingsXml, Boolean replaceIds) {
        Preconditions.checkNotNull(mappingsXml, "mappingsXml cannot be null");
        Preconditions.checkNotNull(replaceIds, "replaceIds cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("MappingsXml", "Edm.String", Checks.checkIsAscii(mappingsXml))
            .put("ReplaceIds", "Edm.Boolean", replaceIds)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<Importmap>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.ImportMappingsImportMap"), Importmap.class, _parameters);
    }

    @Action(name = "ImportSolution")
    @JsonIgnore
    public ActionRequestNoReturn importSolution(Boolean overwriteUnmanagedCustomizations, Boolean publishWorkflows, byte[] customizationFile, UUID importJobId, Boolean convertToManaged, Boolean skipProductUpdateDependencies, Boolean holdingSolution, Boolean skipQueueRibbonJob, LayerDesiredOrder layerDesiredOrder, Boolean asyncRibbonProcessing, List<Crmbaseentity> componentParameters) {
        Preconditions.checkNotNull(overwriteUnmanagedCustomizations, "overwriteUnmanagedCustomizations cannot be null");
        Preconditions.checkNotNull(publishWorkflows, "publishWorkflows cannot be null");
        Preconditions.checkNotNull(customizationFile, "customizationFile cannot be null");
        Preconditions.checkNotNull(importJobId, "importJobId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("OverwriteUnmanagedCustomizations", "Edm.Boolean", overwriteUnmanagedCustomizations)
            .put("PublishWorkflows", "Edm.Boolean", publishWorkflows)
            .put("CustomizationFile", "Edm.Binary", customizationFile)
            .put("ImportJobId", "Edm.Guid", importJobId)
            .put("ConvertToManaged", "Edm.Boolean", convertToManaged)
            .put("SkipProductUpdateDependencies", "Edm.Boolean", skipProductUpdateDependencies)
            .put("HoldingSolution", "Edm.Boolean", holdingSolution)
            .put("SkipQueueRibbonJob", "Edm.Boolean", skipQueueRibbonJob)
            .put("LayerDesiredOrder", "Microsoft.Dynamics.CRM.LayerDesiredOrder", layerDesiredOrder)
            .put("AsyncRibbonProcessing", "Edm.Boolean", asyncRibbonProcessing)
            .put("ComponentParameters", "Collection(Microsoft.Dynamics.CRM.crmbaseentity)", componentParameters)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.ImportSolution"), _parameters);
    }

    @Action(name = "ImportSolutions")
    @JsonIgnore
    public ActionRequestNoReturn importSolutions(Boolean overwriteUnmanagedCustomizations, Boolean publishWorkflows, byte[] customizationFiles, UUID importJobId, Boolean convertToManaged, Boolean skipProductUpdateDependencies, Boolean holdingSolution) {
        Preconditions.checkNotNull(overwriteUnmanagedCustomizations, "overwriteUnmanagedCustomizations cannot be null");
        Preconditions.checkNotNull(publishWorkflows, "publishWorkflows cannot be null");
        Preconditions.checkNotNull(customizationFiles, "customizationFiles cannot be null");
        Preconditions.checkNotNull(importJobId, "importJobId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("OverwriteUnmanagedCustomizations", "Edm.Boolean", overwriteUnmanagedCustomizations)
            .put("PublishWorkflows", "Edm.Boolean", publishWorkflows)
            .put("CustomizationFiles", "Edm.Binary", customizationFiles)
            .put("ImportJobId", "Edm.Guid", importJobId)
            .put("ConvertToManaged", "Edm.Boolean", convertToManaged)
            .put("SkipProductUpdateDependencies", "Edm.Boolean", skipProductUpdateDependencies)
            .put("HoldingSolution", "Edm.Boolean", holdingSolution)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.ImportSolutions"), _parameters);
    }

    @Action(name = "ImportTranslation")
    @JsonIgnore
    public ActionRequestNoReturn importTranslation(byte[] translationFile, UUID importJobId) {
        Preconditions.checkNotNull(translationFile, "translationFile cannot be null");
        Preconditions.checkNotNull(importJobId, "importJobId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("TranslationFile", "Edm.Binary", translationFile)
            .put("ImportJobId", "Edm.Guid", importJobId)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.ImportTranslation"), _parameters);
    }

    @Action(name = "InitializeAnnotationBlocksDownload")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<InitializeAnnotationBlocksDownloadResponse> initializeAnnotationBlocksDownload(Crmbaseentity target) {
        Preconditions.checkNotNull(target, "target cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Target", "Microsoft.Dynamics.CRM.crmbaseentity", target)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<InitializeAnnotationBlocksDownloadResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.InitializeAnnotationBlocksDownload"), InitializeAnnotationBlocksDownloadResponse.class, _parameters);
    }

    @Action(name = "InitializeAnnotationBlocksUpload")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<InitializeAnnotationBlocksUploadResponse> initializeAnnotationBlocksUpload(Crmbaseentity target) {
        Preconditions.checkNotNull(target, "target cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Target", "Microsoft.Dynamics.CRM.crmbaseentity", target)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<InitializeAnnotationBlocksUploadResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.InitializeAnnotationBlocksUpload"), InitializeAnnotationBlocksUploadResponse.class, _parameters);
    }

    @Action(name = "InitializeAttachmentBlocksDownload")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<InitializeAttachmentBlocksDownloadResponse> initializeAttachmentBlocksDownload(Crmbaseentity target) {
        Preconditions.checkNotNull(target, "target cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Target", "Microsoft.Dynamics.CRM.crmbaseentity", target)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<InitializeAttachmentBlocksDownloadResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.InitializeAttachmentBlocksDownload"), InitializeAttachmentBlocksDownloadResponse.class, _parameters);
    }

    @Action(name = "InitializeAttachmentBlocksUpload")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<InitializeAttachmentBlocksUploadResponse> initializeAttachmentBlocksUpload(Crmbaseentity target) {
        Preconditions.checkNotNull(target, "target cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Target", "Microsoft.Dynamics.CRM.crmbaseentity", target)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<InitializeAttachmentBlocksUploadResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.InitializeAttachmentBlocksUpload"), InitializeAttachmentBlocksUploadResponse.class, _parameters);
    }

    @Action(name = "InitializeFileBlocksDownload")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<InitializeFileBlocksDownloadResponse> initializeFileBlocksDownload(Crmbaseentity target, String fileAttributeName) {
        Preconditions.checkNotNull(target, "target cannot be null");
        Preconditions.checkNotNull(fileAttributeName, "fileAttributeName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Target", "Microsoft.Dynamics.CRM.crmbaseentity", target)
            .put("FileAttributeName", "Edm.String", Checks.checkIsAscii(fileAttributeName))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<InitializeFileBlocksDownloadResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.InitializeFileBlocksDownload"), InitializeFileBlocksDownloadResponse.class, _parameters);
    }

    @Action(name = "InitializeFileBlocksUpload")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<InitializeFileBlocksUploadResponse> initializeFileBlocksUpload(Crmbaseentity target, String fileName, String fileAttributeName) {
        Preconditions.checkNotNull(target, "target cannot be null");
        Preconditions.checkNotNull(fileName, "fileName cannot be null");
        Preconditions.checkNotNull(fileAttributeName, "fileAttributeName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Target", "Microsoft.Dynamics.CRM.crmbaseentity", target)
            .put("FileName", "Edm.String", Checks.checkIsAscii(fileName))
            .put("FileAttributeName", "Edm.String", Checks.checkIsAscii(fileAttributeName))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<InitializeFileBlocksUploadResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.InitializeFileBlocksUpload"), InitializeFileBlocksUploadResponse.class, _parameters);
    }

    @Action(name = "InsertOptionValue")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<InsertOptionValueResponse> insertOptionValue(String color, String optionSetName, String attributeLogicalName, String entityLogicalName, Integer value, Label label, Label description, List<Integer> parentValues, String solutionUniqueName) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Color", "Edm.String", Checks.checkIsAscii(color))
            .put("OptionSetName", "Edm.String", Checks.checkIsAscii(optionSetName))
            .put("AttributeLogicalName", "Edm.String", Checks.checkIsAscii(attributeLogicalName))
            .put("EntityLogicalName", "Edm.String", Checks.checkIsAscii(entityLogicalName))
            .put("Value", "Edm.Int32", value)
            .put("Label", "Microsoft.Dynamics.CRM.Label", label)
            .put("Description", "Microsoft.Dynamics.CRM.Label", description)
            .put("ParentValues", "Collection(Edm.Int32)", parentValues)
            .put("SolutionUniqueName", "Edm.String", Checks.checkIsAscii(solutionUniqueName))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<InsertOptionValueResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.InsertOptionValue"), InsertOptionValueResponse.class, _parameters);
    }

    @Action(name = "InsertStatusValue")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<InsertStatusValueResponse> insertStatusValue(String optionSetName, String attributeLogicalName, String entityLogicalName, Integer value, Label label, Label description, Integer stateCode, String solutionUniqueName) {
        Preconditions.checkNotNull(stateCode, "stateCode cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("OptionSetName", "Edm.String", Checks.checkIsAscii(optionSetName))
            .put("AttributeLogicalName", "Edm.String", Checks.checkIsAscii(attributeLogicalName))
            .put("EntityLogicalName", "Edm.String", Checks.checkIsAscii(entityLogicalName))
            .put("Value", "Edm.Int32", value)
            .put("Label", "Microsoft.Dynamics.CRM.Label", label)
            .put("Description", "Microsoft.Dynamics.CRM.Label", description)
            .put("StateCode", "Edm.Int32", stateCode)
            .put("SolutionUniqueName", "Edm.String", Checks.checkIsAscii(solutionUniqueName))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<InsertStatusValueResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.InsertStatusValue"), InsertStatusValueResponse.class, _parameters);
    }

    @Action(name = "InstallSampleData")
    @JsonIgnore
    public ActionRequestNoReturn installSampleData() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.InstallSampleData"), _parameters);
    }

    @Action(name = "InstantiateTemplate")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Crmbaseentity> instantiateTemplate(UUID templateId, String objectType, UUID objectId) {
        Preconditions.checkNotNull(templateId, "templateId cannot be null");
        Preconditions.checkNotNull(objectType, "objectType cannot be null");
        Preconditions.checkNotNull(objectId, "objectId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("TemplateId", "Edm.Guid", templateId)
            .put("ObjectType", "Edm.String", Checks.checkIsAscii(objectType))
            .put("ObjectId", "Edm.Guid", objectId)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.InstantiateTemplate"), Crmbaseentity.class, _parameters);
    }

    @Action(name = "IsPaiEnabled")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<IsPaiEnabledResponse> isPaiEnabled() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollectionUnwrapped<IsPaiEnabledResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.IsPaiEnabled"), IsPaiEnabledResponse.class, _parameters);
    }

    @Action(name = "Merge")
    @JsonIgnore
    public ActionRequestNoReturn merge(Crmbaseentity target, Crmbaseentity subordinate, Crmbaseentity updateContent, Boolean performParentingChecks) {
        Preconditions.checkNotNull(target, "target cannot be null");
        Preconditions.checkNotNull(subordinate, "subordinate cannot be null");
        Preconditions.checkNotNull(updateContent, "updateContent cannot be null");
        Preconditions.checkNotNull(performParentingChecks, "performParentingChecks cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Target", "Microsoft.Dynamics.CRM.crmbaseentity", target)
            .put("Subordinate", "Microsoft.Dynamics.CRM.crmbaseentity", subordinate)
            .put("UpdateContent", "Microsoft.Dynamics.CRM.crmbaseentity", updateContent)
            .put("PerformParentingChecks", "Edm.Boolean", performParentingChecks)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.Merge"), _parameters);
    }

    @Action(name = "ModifyAccess")
    @JsonIgnore
    public ActionRequestNoReturn modifyAccess(Crmbaseentity target, PrincipalAccess principalAccess) {
        Preconditions.checkNotNull(target, "target cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Target", "Microsoft.Dynamics.CRM.crmbaseentity", target)
            .put("PrincipalAccess", "Microsoft.Dynamics.CRM.PrincipalAccess", principalAccess)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.ModifyAccess"), _parameters);
    }

    @Action(name = "msdyn_ActivateProcesses")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Msdyn_ActivateProcessesResponse> msdyn_ActivateProcesses(Crmbaseentity analysisResult) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("AnalysisResult", "Microsoft.Dynamics.CRM.crmbaseentity", analysisResult)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<Msdyn_ActivateProcessesResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.msdyn_ActivateProcesses"), Msdyn_ActivateProcessesResponse.class, _parameters);
    }

    @Action(name = "msdyn_ActivateSdkMessageProcessingSteps")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Msdyn_ActivateSdkMessageProcessingStepsResponse> msdyn_ActivateSdkMessageProcessingSteps(Crmbaseentity analysisResult) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("AnalysisResult", "Microsoft.Dynamics.CRM.crmbaseentity", analysisResult)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<Msdyn_ActivateSdkMessageProcessingStepsResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.msdyn_ActivateSdkMessageProcessingSteps"), Msdyn_ActivateSdkMessageProcessingStepsResponse.class, _parameters);
    }

    @Action(name = "msdyn_CheckForCustomizedOptionSet")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Msdyn_CheckForCustomizedOptionSetResponse> msdyn_CheckForCustomizedOptionSet(String entityIds, String solutionId, String excludeSolutionIds) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("EntityIds", "Edm.String", Checks.checkIsAscii(entityIds))
            .put("SolutionId", "Edm.String", Checks.checkIsAscii(solutionId))
            .put("ExcludeSolutionIds", "Edm.String", Checks.checkIsAscii(excludeSolutionIds))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<Msdyn_CheckForCustomizedOptionSetResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.msdyn_CheckForCustomizedOptionSet"), Msdyn_CheckForCustomizedOptionSetResponse.class, _parameters);
    }

    @Action(name = "msdyn_CheckForCustomizedSitemap")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Msdyn_CheckForCustomizedSitemapResponse> msdyn_CheckForCustomizedSitemap(String entityIds, String solutionId, String excludeSolutionIds) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("EntityIds", "Edm.String", Checks.checkIsAscii(entityIds))
            .put("SolutionId", "Edm.String", Checks.checkIsAscii(solutionId))
            .put("ExcludeSolutionIds", "Edm.String", Checks.checkIsAscii(excludeSolutionIds))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<Msdyn_CheckForCustomizedSitemapResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.msdyn_CheckForCustomizedSitemap"), Msdyn_CheckForCustomizedSitemapResponse.class, _parameters);
    }

    @Action(name = "msdyn_CheckForCustomizedWebResources")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Msdyn_CheckForCustomizedWebResourcesResponse> msdyn_CheckForCustomizedWebResources(String entityIds, String solutionId, String excludeSolutionIds) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("EntityIds", "Edm.String", Checks.checkIsAscii(entityIds))
            .put("SolutionId", "Edm.String", Checks.checkIsAscii(solutionId))
            .put("ExcludeSolutionIds", "Edm.String", Checks.checkIsAscii(excludeSolutionIds))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<Msdyn_CheckForCustomizedWebResourcesResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.msdyn_CheckForCustomizedWebResources"), Msdyn_CheckForCustomizedWebResourcesResponse.class, _parameters);
    }

    @Action(name = "msdyn_CheckForDeletedProcess")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Msdyn_CheckForDeletedProcessResponse> msdyn_CheckForDeletedProcess(String entityIds, String solutionId) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("EntityIds", "Edm.String", Checks.checkIsAscii(entityIds))
            .put("SolutionId", "Edm.String", Checks.checkIsAscii(solutionId))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<Msdyn_CheckForDeletedProcessResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.msdyn_CheckForDeletedProcess"), Msdyn_CheckForDeletedProcessResponse.class, _parameters);
    }

    @Action(name = "msdyn_CheckForDeletedSDKMessageProcessingSteps")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Msdyn_CheckForDeletedSDKMessageProcessingStepsResponse> msdyn_CheckForDeletedSDKMessageProcessingSteps(String entityIds, String solutionId) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("EntityIds", "Edm.String", Checks.checkIsAscii(entityIds))
            .put("SolutionId", "Edm.String", Checks.checkIsAscii(solutionId))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<Msdyn_CheckForDeletedSDKMessageProcessingStepsResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.msdyn_CheckForDeletedSDKMessageProcessingSteps"), Msdyn_CheckForDeletedSDKMessageProcessingStepsResponse.class, _parameters);
    }

    @Action(name = "msdyn_CheckForDeletedWebResources")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Msdyn_CheckForDeletedWebResourcesResponse> msdyn_CheckForDeletedWebResources(String entityIds, String solutionId, String excludeSolutionIds) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("EntityIds", "Edm.String", Checks.checkIsAscii(entityIds))
            .put("SolutionId", "Edm.String", Checks.checkIsAscii(solutionId))
            .put("ExcludeSolutionIds", "Edm.String", Checks.checkIsAscii(excludeSolutionIds))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<Msdyn_CheckForDeletedWebResourcesResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.msdyn_CheckForDeletedWebResources"), Msdyn_CheckForDeletedWebResourcesResponse.class, _parameters);
    }

    @Action(name = "msdyn_CheckForPendingProcesses")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Msdyn_CheckForPendingProcessesResponse> msdyn_CheckForPendingProcesses(String solutionId) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("SolutionId", "Edm.String", Checks.checkIsAscii(solutionId))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<Msdyn_CheckForPendingProcessesResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.msdyn_CheckForPendingProcesses"), Msdyn_CheckForPendingProcessesResponse.class, _parameters);
    }

    @Action(name = "msdyn_CheckIfProcessesAreActive")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Msdyn_CheckIfProcessesAreActiveResponse> msdyn_CheckIfProcessesAreActive(String entityIds, String solutionId) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("EntityIds", "Edm.String", Checks.checkIsAscii(entityIds))
            .put("SolutionId", "Edm.String", Checks.checkIsAscii(solutionId))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<Msdyn_CheckIfProcessesAreActiveResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.msdyn_CheckIfProcessesAreActive"), Msdyn_CheckIfProcessesAreActiveResponse.class, _parameters);
    }

    @Action(name = "msdyn_CheckIfProcessesOwnedByDisabledUsers")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Msdyn_CheckIfProcessesOwnedByDisabledUsersResponse> msdyn_CheckIfProcessesOwnedByDisabledUsers(String solutionId) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("SolutionId", "Edm.String", Checks.checkIsAscii(solutionId))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<Msdyn_CheckIfProcessesOwnedByDisabledUsersResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.msdyn_CheckIfProcessesOwnedByDisabledUsers"), Msdyn_CheckIfProcessesOwnedByDisabledUsersResponse.class, _parameters);
    }

    @Action(name = "msdyn_CheckIfSDKMessageProcessingStepsAreActive")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Msdyn_CheckIfSDKMessageProcessingStepsAreActiveResponse> msdyn_CheckIfSDKMessageProcessingStepsAreActive(String entityIds, String solutionId) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("EntityIds", "Edm.String", Checks.checkIsAscii(entityIds))
            .put("SolutionId", "Edm.String", Checks.checkIsAscii(solutionId))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<Msdyn_CheckIfSDKMessageProcessingStepsAreActiveResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.msdyn_CheckIfSDKMessageProcessingStepsAreActive"), Msdyn_CheckIfSDKMessageProcessingStepsAreActiveResponse.class, _parameters);
    }

    @Action(name = "msdyn_ConditionXmlConversion")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Msdyn_ConditionXmlConversionResponse> msdyn_ConditionXmlConversion(String inputType, String outputType, String inputString, String entityName) {
        Preconditions.checkNotNull(inputType, "inputType cannot be null");
        Preconditions.checkNotNull(outputType, "outputType cannot be null");
        Preconditions.checkNotNull(inputString, "inputString cannot be null");
        Preconditions.checkNotNull(entityName, "entityName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("InputType", "Edm.String", Checks.checkIsAscii(inputType))
            .put("OutputType", "Edm.String", Checks.checkIsAscii(outputType))
            .put("InputString", "Edm.String", Checks.checkIsAscii(inputString))
            .put("EntityName", "Edm.String", Checks.checkIsAscii(entityName))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<Msdyn_ConditionXmlConversionResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.msdyn_ConditionXmlConversion"), Msdyn_ConditionXmlConversionResponse.class, _parameters);
    }

    @Action(name = "msdyn_CreateActionFlow")
    @JsonIgnore
    public ActionRequestNoReturn msdyn_CreateActionFlow(String sLAId) {
        Preconditions.checkNotNull(sLAId, "sLAId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("SLAId", "Edm.String", Checks.checkIsAscii(sLAId))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.msdyn_CreateActionFlow"), _parameters);
    }

    @Action(name = "msdyn_CreateNewAnalysisJobForRuleSet")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Msdyn_analysisjob> msdyn_CreateNewAnalysisJobForRuleSet(Msdyn_solutionhealthruleset solutionHealthRuleSet) {
        Preconditions.checkNotNull(solutionHealthRuleSet, "solutionHealthRuleSet cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("SolutionHealthRuleSet", "Microsoft.Dynamics.CRM.msdyn_solutionhealthruleset", solutionHealthRuleSet)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<Msdyn_analysisjob>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.msdyn_CreateNewAnalysisJobForRuleSet"), Msdyn_analysisjob.class, _parameters);
    }

    @Action(name = "msdyn_DeleteCalendar")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Msdyn_DeleteCalendarResponse> msdyn_DeleteCalendar(String calendarEventInfo) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("CalendarEventInfo", "Edm.String", Checks.checkIsAscii(calendarEventInfo))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<Msdyn_DeleteCalendarResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.msdyn_DeleteCalendar"), Msdyn_DeleteCalendarResponse.class, _parameters);
    }

    @Action(name = "msdyn_GetKAObjectFromTemplate")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Crmbaseentity> msdyn_GetKAObjectFromTemplate(String templateId) {
        Preconditions.checkNotNull(templateId, "templateId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("TemplateId", "Edm.String", Checks.checkIsAscii(templateId))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<Crmbaseentity>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.msdyn_GetKAObjectFromTemplate"), Crmbaseentity.class, _parameters);
    }

    @Action(name = "msdyn_ManageSLAInstances")
    @JsonIgnore
    public ActionRequestNoReturn msdyn_ManageSLAInstances(String sLAId, String regardingId, String entityLogicalName) {
        Preconditions.checkNotNull(sLAId, "sLAId cannot be null");
        Preconditions.checkNotNull(regardingId, "regardingId cannot be null");
        Preconditions.checkNotNull(entityLogicalName, "entityLogicalName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("SLAId", "Edm.String", Checks.checkIsAscii(sLAId))
            .put("RegardingId", "Edm.String", Checks.checkIsAscii(regardingId))
            .put("EntityLogicalName", "Edm.String", Checks.checkIsAscii(entityLogicalName))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.msdyn_ManageSLAInstances"), _parameters);
    }

    @Action(name = "msdyn_RegisterSolutionHealthRule")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Msdyn_RegisterSolutionHealthRuleResponse> msdyn_RegisterSolutionHealthRule(String ruleDescription, String owningSolutionId, String uniqueName, Crmbaseentity resolutionAction, Msdyn_solutionhealthruleset ruleSetId, String ruleArguments, String ruleName, Workflow workflowReference, String resolutionMessage) {
        Preconditions.checkNotNull(ruleSetId, "ruleSetId cannot be null");
        Preconditions.checkNotNull(ruleName, "ruleName cannot be null");
        Preconditions.checkNotNull(workflowReference, "workflowReference cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("RuleDescription", "Edm.String", Checks.checkIsAscii(ruleDescription))
            .put("OwningSolutionId", "Edm.String", Checks.checkIsAscii(owningSolutionId))
            .put("UniqueName", "Edm.String", Checks.checkIsAscii(uniqueName))
            .put("ResolutionAction", "Microsoft.Dynamics.CRM.crmbaseentity", resolutionAction)
            .put("RuleSetId", "Microsoft.Dynamics.CRM.msdyn_solutionhealthruleset", ruleSetId)
            .put("RuleArguments", "Edm.String", Checks.checkIsAscii(ruleArguments))
            .put("RuleName", "Edm.String", Checks.checkIsAscii(ruleName))
            .put("WorkflowReference", "Microsoft.Dynamics.CRM.workflow", workflowReference)
            .put("ResolutionMessage", "Edm.String", Checks.checkIsAscii(resolutionMessage))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<Msdyn_RegisterSolutionHealthRuleResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.msdyn_RegisterSolutionHealthRule"), Msdyn_RegisterSolutionHealthRuleResponse.class, _parameters);
    }

    @Action(name = "msdyn_ResolveSolutionHealthRuleFailure")
    @JsonIgnore
    public ActionRequestNoReturn msdyn_ResolveSolutionHealthRuleFailure(Crmbaseentity analysisResult) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("AnalysisResult", "Microsoft.Dynamics.CRM.crmbaseentity", analysisResult)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.msdyn_ResolveSolutionHealthRuleFailure"), _parameters);
    }

    @Action(name = "msdyn_RunSolutionCheckerRules")
    @JsonIgnore
    public ActionRequestNoReturn msdyn_RunSolutionCheckerRules(String analysisComponentId) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("AnalysisComponentId", "Edm.String", Checks.checkIsAscii(analysisComponentId))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.msdyn_RunSolutionCheckerRules"), _parameters);
    }

    @Action(name = "msdyn_SaveCalendar")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Msdyn_SaveCalendarResponse> msdyn_SaveCalendar(String calendarEventInfo) {
        Preconditions.checkNotNull(calendarEventInfo, "calendarEventInfo cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("CalendarEventInfo", "Edm.String", Checks.checkIsAscii(calendarEventInfo))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<Msdyn_SaveCalendarResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.msdyn_SaveCalendar"), Msdyn_SaveCalendarResponse.class, _parameters);
    }

    @Action(name = "OrderOption")
    @JsonIgnore
    public ActionRequestNoReturn orderOption(String optionSetName, String attributeLogicalName, String entityLogicalName, List<Integer> values, String solutionUniqueName) {
        Preconditions.checkNotNull(values, "values cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("OptionSetName", "Edm.String", Checks.checkIsAscii(optionSetName))
            .put("AttributeLogicalName", "Edm.String", Checks.checkIsAscii(attributeLogicalName))
            .put("EntityLogicalName", "Edm.String", Checks.checkIsAscii(entityLogicalName))
            .put("Values", "Collection(Edm.Int32)", values)
            .put("SolutionUniqueName", "Edm.String", Checks.checkIsAscii(solutionUniqueName))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.OrderOption"), _parameters);
    }

    @Action(name = "ProvisionLanguage")
    @JsonIgnore
    public ActionRequestNoReturn provisionLanguage(Integer language) {
        Preconditions.checkNotNull(language, "language cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Language", "Edm.Int32", language)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.ProvisionLanguage"), _parameters);
    }

    @Action(name = "ProvisionLanguageAsync")
    @JsonIgnore
    public ActionRequestNoReturn provisionLanguageAsync(Integer language) {
        Preconditions.checkNotNull(language, "language cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Language", "Edm.Int32", language)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.ProvisionLanguageAsync"), _parameters);
    }

    @Action(name = "PublishAllXml")
    @JsonIgnore
    public ActionRequestNoReturn publishAllXml() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.PublishAllXml"), _parameters);
    }

    @Action(name = "PublishXml")
    @JsonIgnore
    public ActionRequestNoReturn publishXml(String parameterXml) {
        Preconditions.checkNotNull(parameterXml, "parameterXml cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ParameterXml", "Edm.String", Checks.checkIsAscii(parameterXml))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.PublishXml"), _parameters);
    }

    @Action(name = "QueryExpressionToFetchXml")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<QueryExpressionToFetchXmlResponse> queryExpressionToFetchXml(QueryBase query) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Query", "Microsoft.Dynamics.CRM.QueryBase", query)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<QueryExpressionToFetchXmlResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.QueryExpressionToFetchXml"), QueryExpressionToFetchXmlResponse.class, _parameters);
    }

    @Action(name = "QueueUpdateRibbonClientMetadata")
    @JsonIgnore
    public ActionRequestNoReturn queueUpdateRibbonClientMetadata() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.QueueUpdateRibbonClientMetadata"), _parameters);
    }

    @Action(name = "ReactivateEntityKey")
    @JsonIgnore
    public ActionRequestNoReturn reactivateEntityKey(String entityKeyLogicalName, String entityLogicalName) {
        Preconditions.checkNotNull(entityKeyLogicalName, "entityKeyLogicalName cannot be null");
        Preconditions.checkNotNull(entityLogicalName, "entityLogicalName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("EntityKeyLogicalName", "Edm.String", Checks.checkIsAscii(entityKeyLogicalName))
            .put("EntityLogicalName", "Edm.String", Checks.checkIsAscii(entityLogicalName))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.ReactivateEntityKey"), _parameters);
    }

    @Action(name = "ReassignObjectsOwner")
    @JsonIgnore
    public ActionRequestNoReturn reassignObjectsOwner(Crmbaseentity fromPrincipal, Crmbaseentity toPrincipal) {
        Preconditions.checkNotNull(fromPrincipal, "fromPrincipal cannot be null");
        Preconditions.checkNotNull(toPrincipal, "toPrincipal cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("FromPrincipal", "Microsoft.Dynamics.CRM.crmbaseentity", fromPrincipal)
            .put("ToPrincipal", "Microsoft.Dynamics.CRM.crmbaseentity", toPrincipal)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.ReassignObjectsOwner"), _parameters);
    }

    @Action(name = "RecognizeText")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<RecognizeTextResponse> recognizeText(UUID modelId, String base64encoded) {
        Preconditions.checkNotNull(base64encoded, "base64encoded cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("modelId", "Edm.Guid", modelId)
            .put("base64encoded", "Edm.String", Checks.checkIsAscii(base64encoded))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<RecognizeTextResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RecognizeText"), RecognizeTextResponse.class, _parameters);
    }

    @Action(name = "RemoveAppComponents")
    @JsonIgnore
    public ActionRequestNoReturn removeAppComponents(UUID appId, List<Crmbaseentity> components) {
        Preconditions.checkNotNull(appId, "appId cannot be null");
        Preconditions.checkNotNull(components, "components cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("AppId", "Edm.Guid", appId)
            .put("Components", "Collection(Microsoft.Dynamics.CRM.crmbaseentity)", components)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RemoveAppComponents"), _parameters);
    }

    @Action(name = "RemoveParent")
    @JsonIgnore
    public ActionRequestNoReturn removeParent(Crmbaseentity target) {
        Preconditions.checkNotNull(target, "target cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Target", "Microsoft.Dynamics.CRM.crmbaseentity", target)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RemoveParent"), _parameters);
    }

    @Action(name = "RemoveSolutionComponent")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<RemoveSolutionComponentResponse> removeSolutionComponent(Solutioncomponent solutionComponent, Integer componentType, String solutionUniqueName) {
        Preconditions.checkNotNull(solutionComponent, "solutionComponent cannot be null");
        Preconditions.checkNotNull(componentType, "componentType cannot be null");
        Preconditions.checkNotNull(solutionUniqueName, "solutionUniqueName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("SolutionComponent", "Microsoft.Dynamics.CRM.solutioncomponent", solutionComponent)
            .put("ComponentType", "Edm.Int32", componentType)
            .put("SolutionUniqueName", "Edm.String", Checks.checkIsAscii(solutionUniqueName))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<RemoveSolutionComponentResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RemoveSolutionComponent"), RemoveSolutionComponentResponse.class, _parameters);
    }

    @Action(name = "Reschedule")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<RescheduleResponse> reschedule(Crmbaseentity target, Boolean returnNotifications) {
        Preconditions.checkNotNull(target, "target cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Target", "Microsoft.Dynamics.CRM.crmbaseentity", target)
            .put("ReturnNotifications", "Edm.Boolean", returnNotifications)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<RescheduleResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.Reschedule"), RescheduleResponse.class, _parameters);
    }

    @Action(name = "ResetUserFilters")
    @JsonIgnore
    public ActionRequestNoReturn resetUserFilters(Integer queryType) {
        Preconditions.checkNotNull(queryType, "queryType cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("QueryType", "Edm.Int32", queryType)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.ResetUserFilters"), _parameters);
    }

    @Action(name = "RetrieveAccessOrigin")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<RetrieveAccessOriginResponse> retrieveAccessOrigin(UUID objectId, String logicalName, UUID principalId) {
        Preconditions.checkNotNull(objectId, "objectId cannot be null");
        Preconditions.checkNotNull(logicalName, "logicalName cannot be null");
        Preconditions.checkNotNull(principalId, "principalId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ObjectId", "Edm.Guid", objectId)
            .put("LogicalName", "Edm.String", Checks.checkIsAscii(logicalName))
            .put("PrincipalId", "Edm.Guid", principalId)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<RetrieveAccessOriginResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveAccessOrigin"), RetrieveAccessOriginResponse.class, _parameters);
    }

    @Action(name = "RevokeAccess")
    @JsonIgnore
    public ActionRequestNoReturn revokeAccess(Crmbaseentity target, Crmbaseentity revokee) {
        Preconditions.checkNotNull(target, "target cannot be null");
        Preconditions.checkNotNull(revokee, "revokee cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Target", "Microsoft.Dynamics.CRM.crmbaseentity", target)
            .put("Revokee", "Microsoft.Dynamics.CRM.crmbaseentity", revokee)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RevokeAccess"), _parameters);
    }

    @Action(name = "RouteTo")
    @JsonIgnore
    public ActionRequestNoReturn routeTo(Crmbaseentity target, Queueitem queueItem) {
        Preconditions.checkNotNull(target, "target cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Target", "Microsoft.Dynamics.CRM.crmbaseentity", target)
            .put("QueueItem", "Microsoft.Dynamics.CRM.queueitem", queueItem)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RouteTo"), _parameters);
    }

    @Action(name = "SaveAppSetting")
    @JsonIgnore
    public ActionRequestNoReturn saveAppSetting(String appUniqueName, String settingName, String value) {
        Preconditions.checkNotNull(appUniqueName, "appUniqueName cannot be null");
        Preconditions.checkNotNull(settingName, "settingName cannot be null");
        Preconditions.checkNotNull(value, "value cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("AppUniqueName", "Edm.String", Checks.checkIsAscii(appUniqueName))
            .put("SettingName", "Edm.String", Checks.checkIsAscii(settingName))
            .put("Value", "Edm.String", Checks.checkIsAscii(value))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.SaveAppSetting"), _parameters);
    }

    @Action(name = "SendBulkMail")
    @JsonIgnore
    public ActionRequestNoReturn sendBulkMail(Crmbaseentity sender, UUID templateId, String regardingType, UUID regardingId, QueryBase query) {
        Preconditions.checkNotNull(sender, "sender cannot be null");
        Preconditions.checkNotNull(templateId, "templateId cannot be null");
        Preconditions.checkNotNull(regardingType, "regardingType cannot be null");
        Preconditions.checkNotNull(regardingId, "regardingId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Sender", "Microsoft.Dynamics.CRM.crmbaseentity", sender)
            .put("TemplateId", "Edm.Guid", templateId)
            .put("RegardingType", "Edm.String", Checks.checkIsAscii(regardingType))
            .put("RegardingId", "Edm.Guid", regardingId)
            .put("Query", "Microsoft.Dynamics.CRM.QueryBase", query)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.SendBulkMail"), _parameters);
    }

    @Action(name = "SendEmailFromTemplate")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Email> sendEmailFromTemplate(UUID templateId, Crmbaseentity regarding, Crmbaseentity target) {
        Preconditions.checkNotNull(templateId, "templateId cannot be null");
        Preconditions.checkNotNull(regarding, "regarding cannot be null");
        Preconditions.checkNotNull(target, "target cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("TemplateId", "Edm.Guid", templateId)
            .put("Regarding", "Microsoft.Dynamics.CRM.crmbaseentity", regarding)
            .put("Target", "Microsoft.Dynamics.CRM.crmbaseentity", target)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<Email>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.SendEmailFromTemplate"), Email.class, _parameters);
    }

    @Action(name = "SendFax")
    @JsonIgnore
    public ActionRequestNoReturn sendFax(UUID faxId, Boolean issueSend) {
        Preconditions.checkNotNull(faxId, "faxId cannot be null");
        Preconditions.checkNotNull(issueSend, "issueSend cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("FaxId", "Edm.Guid", faxId)
            .put("IssueSend", "Edm.Boolean", issueSend)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.SendFax"), _parameters);
    }

    @Action(name = "SendTemplate")
    @JsonIgnore
    public ActionRequestNoReturn sendTemplate(UUID templateId, Crmbaseentity sender, List<Crmbaseentity> recipients, Crmbaseentity regarding, Integer deliveryPriorityCode) {
        Preconditions.checkNotNull(templateId, "templateId cannot be null");
        Preconditions.checkNotNull(sender, "sender cannot be null");
        Preconditions.checkNotNull(recipients, "recipients cannot be null");
        Preconditions.checkNotNull(regarding, "regarding cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("TemplateId", "Edm.Guid", templateId)
            .put("Sender", "Microsoft.Dynamics.CRM.crmbaseentity", sender)
            .put("Recipients", "Collection(Microsoft.Dynamics.CRM.crmbaseentity)", recipients)
            .put("Regarding", "Microsoft.Dynamics.CRM.crmbaseentity", regarding)
            .put("DeliveryPriorityCode", "Edm.Int32", deliveryPriorityCode)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.SendTemplate"), _parameters);
    }

    @Action(name = "SetAutoNumberSeed")
    @JsonIgnore
    public ActionRequestNoReturn setAutoNumberSeed(String entityName, String attributeName, Long value) {
        Preconditions.checkNotNull(entityName, "entityName cannot be null");
        Preconditions.checkNotNull(attributeName, "attributeName cannot be null");
        Preconditions.checkNotNull(value, "value cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("EntityName", "Edm.String", Checks.checkIsAscii(entityName))
            .put("AttributeName", "Edm.String", Checks.checkIsAscii(attributeName))
            .put("Value", "Edm.Int64", value)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.SetAutoNumberSeed"), _parameters);
    }

    @Action(name = "SetDataEncryptionKey")
    @JsonIgnore
    public ActionRequestNoReturn setDataEncryptionKey(String encryptionKey, Boolean changeEncryptionKey) {
        Preconditions.checkNotNull(encryptionKey, "encryptionKey cannot be null");
        Preconditions.checkNotNull(changeEncryptionKey, "changeEncryptionKey cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("EncryptionKey", "Edm.String", Checks.checkIsAscii(encryptionKey))
            .put("ChangeEncryptionKey", "Edm.Boolean", changeEncryptionKey)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.SetDataEncryptionKey"), _parameters);
    }

    @Action(name = "SetFeatureStatus")
    @JsonIgnore
    public ActionRequestNoReturn setFeatureStatus(Integer featureType, Boolean status, String configData, Boolean isSolutionUninstall) {
        Preconditions.checkNotNull(featureType, "featureType cannot be null");
        Preconditions.checkNotNull(status, "status cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("FeatureType", "Edm.Int32", featureType)
            .put("Status", "Edm.Boolean", status)
            .put("ConfigData", "Edm.String", Checks.checkIsAscii(configData))
            .put("IsSolutionUninstall", "Edm.Boolean", isSolutionUninstall)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.SetFeatureStatus"), _parameters);
    }

    @Action(name = "SetLocLabels")
    @JsonIgnore
    public ActionRequestNoReturn setLocLabels(Crmbaseentity entityMoniker, String attributeName, List<LocalizedLabel> labels) {
        Preconditions.checkNotNull(entityMoniker, "entityMoniker cannot be null");
        Preconditions.checkNotNull(attributeName, "attributeName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("EntityMoniker", "Microsoft.Dynamics.CRM.crmbaseentity", entityMoniker)
            .put("AttributeName", "Edm.String", Checks.checkIsAscii(attributeName))
            .put("Labels", "Collection(Microsoft.Dynamics.CRM.LocalizedLabel)", labels)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.SetLocLabels"), _parameters);
    }

    @Action(name = "SetProcess")
    @JsonIgnore
    public ActionRequestNoReturn setProcess(Crmbaseentity target, Crmbaseentity newProcess, Crmbaseentity newProcessInstance) {
        Preconditions.checkNotNull(target, "target cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Target", "Microsoft.Dynamics.CRM.crmbaseentity", target)
            .put("NewProcess", "Microsoft.Dynamics.CRM.crmbaseentity", newProcess)
            .put("NewProcessInstance", "Microsoft.Dynamics.CRM.crmbaseentity", newProcessInstance)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.SetProcess"), _parameters);
    }

    @Action(name = "SetReportRelated")
    @JsonIgnore
    public ActionRequestNoReturn setReportRelated(UUID reportId, List<Integer> entities, List<Integer> categories, List<Integer> visibility) {
        Preconditions.checkNotNull(reportId, "reportId cannot be null");
        Preconditions.checkNotNull(entities, "entities cannot be null");
        Preconditions.checkNotNull(categories, "categories cannot be null");
        Preconditions.checkNotNull(visibility, "visibility cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ReportId", "Edm.Guid", reportId)
            .put("Entities", "Collection(Edm.Int32)", entities)
            .put("Categories", "Collection(Edm.Int32)", categories)
            .put("Visibility", "Collection(Edm.Int32)", visibility)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.SetReportRelated"), _parameters);
    }

    @Action(name = "StageAndUpgrade")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<StageAndUpgradeResponse> stageAndUpgrade(Boolean overwriteUnmanagedCustomizations, Boolean publishWorkflows, byte[] customizationFile, UUID importJobId, Boolean convertToManaged, Boolean skipProductUpdateDependencies, Boolean skipQueueRibbonJob, Boolean asyncRibbonProcessing, List<Crmbaseentity> componentParameters) {
        Preconditions.checkNotNull(overwriteUnmanagedCustomizations, "overwriteUnmanagedCustomizations cannot be null");
        Preconditions.checkNotNull(publishWorkflows, "publishWorkflows cannot be null");
        Preconditions.checkNotNull(customizationFile, "customizationFile cannot be null");
        Preconditions.checkNotNull(importJobId, "importJobId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("OverwriteUnmanagedCustomizations", "Edm.Boolean", overwriteUnmanagedCustomizations)
            .put("PublishWorkflows", "Edm.Boolean", publishWorkflows)
            .put("CustomizationFile", "Edm.Binary", customizationFile)
            .put("ImportJobId", "Edm.Guid", importJobId)
            .put("ConvertToManaged", "Edm.Boolean", convertToManaged)
            .put("SkipProductUpdateDependencies", "Edm.Boolean", skipProductUpdateDependencies)
            .put("SkipQueueRibbonJob", "Edm.Boolean", skipQueueRibbonJob)
            .put("AsyncRibbonProcessing", "Edm.Boolean", asyncRibbonProcessing)
            .put("ComponentParameters", "Collection(Microsoft.Dynamics.CRM.crmbaseentity)", componentParameters)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<StageAndUpgradeResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.StageAndUpgrade"), StageAndUpgradeResponse.class, _parameters);
    }

    @Action(name = "SyncBulkOperation")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<SyncBulkOperationResponse> syncBulkOperation(List<QueryExpression> querySet, Integer operationType) {
        Preconditions.checkNotNull(operationType, "operationType cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("QuerySet", "Collection(Microsoft.Dynamics.CRM.QueryExpression)", querySet)
            .put("OperationType", "Edm.Int32", operationType)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<SyncBulkOperationResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.SyncBulkOperation"), SyncBulkOperationResponse.class, _parameters);
    }

    @Action(name = "TransformImport")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Asyncoperation> transformImport(UUID importId) {
        Preconditions.checkNotNull(importId, "importId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ImportId", "Edm.Guid", importId)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<Asyncoperation>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.TransformImport"), Asyncoperation.class, _parameters);
    }

    @Action(name = "UninstallSampleData")
    @JsonIgnore
    public ActionRequestNoReturn uninstallSampleData() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.UninstallSampleData"), _parameters);
    }

    @Action(name = "UnpublishDuplicateRule")
    @JsonIgnore
    public ActionRequestNoReturn unpublishDuplicateRule(UUID duplicateRuleId) {
        Preconditions.checkNotNull(duplicateRuleId, "duplicateRuleId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("DuplicateRuleId", "Edm.Guid", duplicateRuleId)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.UnpublishDuplicateRule"), _parameters);
    }

    @Action(name = "UpdateFeatureConfig")
    @JsonIgnore
    public ActionRequestNoReturn updateFeatureConfig(Integer featureType, String configData) {
        Preconditions.checkNotNull(featureType, "featureType cannot be null");
        Preconditions.checkNotNull(configData, "configData cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("FeatureType", "Edm.Int32", featureType)
            .put("ConfigData", "Edm.String", Checks.checkIsAscii(configData))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.UpdateFeatureConfig"), _parameters);
    }

    @Action(name = "UpdateOptionValue")
    @JsonIgnore
    public ActionRequestNoReturn updateOptionValue(String color, String optionSetName, String attributeLogicalName, String entityLogicalName, Integer value, Label label, Label description, Boolean mergeLabels, List<Integer> parentValues, String solutionUniqueName) {
        Preconditions.checkNotNull(value, "value cannot be null");
        Preconditions.checkNotNull(mergeLabels, "mergeLabels cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Color", "Edm.String", Checks.checkIsAscii(color))
            .put("OptionSetName", "Edm.String", Checks.checkIsAscii(optionSetName))
            .put("AttributeLogicalName", "Edm.String", Checks.checkIsAscii(attributeLogicalName))
            .put("EntityLogicalName", "Edm.String", Checks.checkIsAscii(entityLogicalName))
            .put("Value", "Edm.Int32", value)
            .put("Label", "Microsoft.Dynamics.CRM.Label", label)
            .put("Description", "Microsoft.Dynamics.CRM.Label", description)
            .put("MergeLabels", "Edm.Boolean", mergeLabels)
            .put("ParentValues", "Collection(Edm.Int32)", parentValues)
            .put("SolutionUniqueName", "Edm.String", Checks.checkIsAscii(solutionUniqueName))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.UpdateOptionValue"), _parameters);
    }

    @Action(name = "UpdateRibbonClientMetadata")
    @JsonIgnore
    public ActionRequestNoReturn updateRibbonClientMetadata() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.UpdateRibbonClientMetadata"), _parameters);
    }

    @Action(name = "UpdateSolutionComponent")
    @JsonIgnore
    public ActionRequestNoReturn updateSolutionComponent(UUID componentId, Integer componentType, String solutionUniqueName, List<String> includedComponentSettingsValues) {
        Preconditions.checkNotNull(componentId, "componentId cannot be null");
        Preconditions.checkNotNull(componentType, "componentType cannot be null");
        Preconditions.checkNotNull(solutionUniqueName, "solutionUniqueName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ComponentId", "Edm.Guid", componentId)
            .put("ComponentType", "Edm.Int32", componentType)
            .put("SolutionUniqueName", "Edm.String", Checks.checkIsAscii(solutionUniqueName))
            .put("IncludedComponentSettingsValues", "Collection(Edm.String)", Checks.checkIsAscii(includedComponentSettingsValues))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.UpdateSolutionComponent"), _parameters);
    }

    @Action(name = "UpdateStateValue")
    @JsonIgnore
    public ActionRequestNoReturn updateStateValue(String optionSetName, String attributeLogicalName, String entityLogicalName, Integer value, Label label, Label description, Boolean mergeLabels, Integer defaultStatusCode) {
        Preconditions.checkNotNull(value, "value cannot be null");
        Preconditions.checkNotNull(mergeLabels, "mergeLabels cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("OptionSetName", "Edm.String", Checks.checkIsAscii(optionSetName))
            .put("AttributeLogicalName", "Edm.String", Checks.checkIsAscii(attributeLogicalName))
            .put("EntityLogicalName", "Edm.String", Checks.checkIsAscii(entityLogicalName))
            .put("Value", "Edm.Int32", value)
            .put("Label", "Microsoft.Dynamics.CRM.Label", label)
            .put("Description", "Microsoft.Dynamics.CRM.Label", description)
            .put("MergeLabels", "Edm.Boolean", mergeLabels)
            .put("DefaultStatusCode", "Edm.Int32", defaultStatusCode)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.UpdateStateValue"), _parameters);
    }

    @Action(name = "UploadBlock")
    @JsonIgnore
    public ActionRequestNoReturn uploadBlock(String blockId, byte[] blockData, String fileContinuationToken) {
        Preconditions.checkNotNull(blockId, "blockId cannot be null");
        Preconditions.checkNotNull(blockData, "blockData cannot be null");
        Preconditions.checkNotNull(fileContinuationToken, "fileContinuationToken cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("BlockId", "Edm.String", Checks.checkIsAscii(blockId))
            .put("BlockData", "Edm.Binary", blockData)
            .put("FileContinuationToken", "Edm.String", Checks.checkIsAscii(fileContinuationToken))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.UploadBlock"), _parameters);
    }

    @Action(name = "Validate")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<ValidateResponse> validate(List<Activitypointer> activities) {
        Preconditions.checkNotNull(activities, "activities cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Activities", "Collection(Microsoft.Dynamics.CRM.activitypointer)", activities)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<ValidateResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.Validate"), ValidateResponse.class, _parameters);
    }

    @Action(name = "ValidateAIConfiguration")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<ValidateAIConfigurationResponse> validateAIConfiguration(String version, String aiconfigurationId) {
        Preconditions.checkNotNull(version, "version cannot be null");
        Preconditions.checkNotNull(aiconfigurationId, "aiconfigurationId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("version", "Edm.String", Checks.checkIsAscii(version))
            .put("aiconfigurationId", "Edm.String", Checks.checkIsAscii(aiconfigurationId))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<ValidateAIConfigurationResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.ValidateAIConfiguration"), ValidateAIConfigurationResponse.class, _parameters);
    }

    @Action(name = "ValidateUnpublished")
    @JsonIgnore
    public ActionRequestNoReturn validateUnpublished(Crmbaseentity target) {
        Preconditions.checkNotNull(target, "target cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Target", "Microsoft.Dynamics.CRM.crmbaseentity", target)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.ValidateUnpublished"), _parameters);
    }

    @Function(name = "CalculateRollupField")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<Crmbaseentity> calculateRollupField(Crmbaseentity target, String fieldName) {
        Preconditions.checkNotNull(target, "target cannot be null");
        Preconditions.checkNotNull(fieldName, "fieldName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Target", "Microsoft.Dynamics.CRM.crmbaseentity", target)
            .put("FieldName", "Edm.String", Checks.checkIsAscii(fieldName))
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<Crmbaseentity>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.CalculateRollupField"), Crmbaseentity.class, _parameters);
    }

    @Function(name = "CheckIncomingEmail")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<CheckIncomingEmailResponse> checkIncomingEmail(String messageId, String subject, String from, String to, String cc, String bcc, Email extraProperties) {
        Preconditions.checkNotNull(messageId, "messageId cannot be null");
        Preconditions.checkNotNull(subject, "subject cannot be null");
        Preconditions.checkNotNull(from, "from cannot be null");
        Preconditions.checkNotNull(to, "to cannot be null");
        Preconditions.checkNotNull(cc, "cc cannot be null");
        Preconditions.checkNotNull(bcc, "bcc cannot be null");
        Preconditions.checkNotNull(extraProperties, "extraProperties cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("MessageId", "Edm.String", Checks.checkIsAscii(messageId))
            .put("Subject", "Edm.String", Checks.checkIsAscii(subject))
            .put("From", "Edm.String", Checks.checkIsAscii(from))
            .put("To", "Edm.String", Checks.checkIsAscii(to))
            .put("Cc", "Edm.String", Checks.checkIsAscii(cc))
            .put("Bcc", "Edm.String", Checks.checkIsAscii(bcc))
            .put("ExtraProperties", "Microsoft.Dynamics.CRM.email", extraProperties)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<CheckIncomingEmailResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.CheckIncomingEmail"), CheckIncomingEmailResponse.class, _parameters);
    }

    @Function(name = "CheckPromoteEmail")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<CheckPromoteEmailResponse> checkPromoteEmail(String messageId, String subject, Integer directionCode) {
        Preconditions.checkNotNull(messageId, "messageId cannot be null");
        Preconditions.checkNotNull(subject, "subject cannot be null");
        Preconditions.checkNotNull(directionCode, "directionCode cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("MessageId", "Edm.String", Checks.checkIsAscii(messageId))
            .put("Subject", "Edm.String", Checks.checkIsAscii(subject))
            .put("DirectionCode", "Edm.Int32", directionCode)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<CheckPromoteEmailResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.CheckPromoteEmail"), CheckPromoteEmailResponse.class, _parameters);
    }

    @Function(name = "ExportFieldTranslation")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<ExportFieldTranslationResponse> exportFieldTranslation() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<ExportFieldTranslationResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.ExportFieldTranslation"), ExportFieldTranslationResponse.class, _parameters);
    }

    @Function(name = "FetchXmlToQueryExpression")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<FetchXmlToQueryExpressionResponse> fetchXmlToQueryExpression(String fetchXml) {
        Preconditions.checkNotNull(fetchXml, "fetchXml cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("FetchXml", "Edm.String", Checks.checkIsAscii(fetchXml))
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<FetchXmlToQueryExpressionResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.FetchXmlToQueryExpression"), FetchXmlToQueryExpressionResponse.class, _parameters);
    }

    @Function(name = "FormatAddress")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<FormatAddressResponse> formatAddress(String line1, String city, String stateOrProvince, String postalCode, String country) {
        Preconditions.checkNotNull(line1, "line1 cannot be null");
        Preconditions.checkNotNull(city, "city cannot be null");
        Preconditions.checkNotNull(stateOrProvince, "stateOrProvince cannot be null");
        Preconditions.checkNotNull(postalCode, "postalCode cannot be null");
        Preconditions.checkNotNull(country, "country cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Line1", "Edm.String", Checks.checkIsAscii(line1))
            .put("City", "Edm.String", Checks.checkIsAscii(city))
            .put("StateOrProvince", "Edm.String", Checks.checkIsAscii(stateOrProvince))
            .put("PostalCode", "Edm.String", Checks.checkIsAscii(postalCode))
            .put("Country", "Edm.String", Checks.checkIsAscii(country))
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<FormatAddressResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.FormatAddress"), FormatAddressResponse.class, _parameters);
    }

    @Function(name = "GetFileSasUrl")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<GetFileSasUrlResponse> getFileSasUrl(Crmbaseentity target, String fileAttributeName) {
        Preconditions.checkNotNull(target, "target cannot be null");
        Preconditions.checkNotNull(fileAttributeName, "fileAttributeName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Target", "Microsoft.Dynamics.CRM.crmbaseentity", target)
            .put("FileAttributeName", "Edm.String", Checks.checkIsAscii(fileAttributeName))
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<GetFileSasUrlResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.GetFileSasUrl"), GetFileSasUrlResponse.class, _parameters);
    }

    @Function(name = "GetTimeZoneCodeByLocalizedName")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<GetTimeZoneCodeByLocalizedNameResponse> getTimeZoneCodeByLocalizedName(String localizedStandardName, Integer localeId) {
        Preconditions.checkNotNull(localizedStandardName, "localizedStandardName cannot be null");
        Preconditions.checkNotNull(localeId, "localeId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("LocalizedStandardName", "Edm.String", Checks.checkIsAscii(localizedStandardName))
            .put("LocaleId", "Edm.Int32", localeId)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<GetTimeZoneCodeByLocalizedNameResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.GetTimeZoneCodeByLocalizedName"), GetTimeZoneCodeByLocalizedNameResponse.class, _parameters);
    }

    @Function(name = "GetValidManyToMany")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<GetValidManyToManyResponse> getValidManyToMany() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<GetValidManyToManyResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.GetValidManyToMany"), GetValidManyToManyResponse.class, _parameters);
    }

    @Function(name = "GetValidReferencedEntities")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<GetValidReferencedEntitiesResponse> getValidReferencedEntities(String referencingEntityName) {
        Preconditions.checkNotNull(referencingEntityName, "referencingEntityName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ReferencingEntityName", "Edm.String", Checks.checkIsAscii(referencingEntityName))
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<GetValidReferencedEntitiesResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.GetValidReferencedEntities"), GetValidReferencedEntitiesResponse.class, _parameters);
    }

    @Function(name = "GetValidReferencingEntities")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<GetValidReferencingEntitiesResponse> getValidReferencingEntities(String referencedEntityName) {
        Preconditions.checkNotNull(referencedEntityName, "referencedEntityName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ReferencedEntityName", "Edm.String", Checks.checkIsAscii(referencedEntityName))
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<GetValidReferencingEntitiesResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.GetValidReferencingEntities"), GetValidReferencingEntitiesResponse.class, _parameters);
    }

    @Function(name = "IncrementKnowledgeArticleViewCount")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<Crmbaseentity> incrementKnowledgeArticleViewCount(Crmbaseentity source, OffsetDateTime viewDate, Integer location, Integer count) {
        Preconditions.checkNotNull(source, "source cannot be null");
        Preconditions.checkNotNull(viewDate, "viewDate cannot be null");
        Preconditions.checkNotNull(location, "location cannot be null");
        Preconditions.checkNotNull(count, "count cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Source", "Microsoft.Dynamics.CRM.crmbaseentity", source)
            .put("ViewDate", "Edm.DateTimeOffset", viewDate)
            .put("Location", "Edm.Int32", location)
            .put("Count", "Edm.Int32", count)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<Crmbaseentity>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.IncrementKnowledgeArticleViewCount"), Crmbaseentity.class, _parameters);
    }

    @Function(name = "InitializeFrom")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<Crmbaseentity> initializeFrom(Crmbaseentity entityMoniker, String targetEntityName, TargetFieldType targetFieldType, Boolean retrieveConsumableRecord) {
        Preconditions.checkNotNull(entityMoniker, "entityMoniker cannot be null");
        Preconditions.checkNotNull(targetEntityName, "targetEntityName cannot be null");
        Preconditions.checkNotNull(targetFieldType, "targetFieldType cannot be null");
        Preconditions.checkNotNull(retrieveConsumableRecord, "retrieveConsumableRecord cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("EntityMoniker", "Microsoft.Dynamics.CRM.crmbaseentity", entityMoniker)
            .put("TargetEntityName", "Edm.String", Checks.checkIsAscii(targetEntityName))
            .put("TargetFieldType", "Microsoft.Dynamics.CRM.TargetFieldType", targetFieldType)
            .put("RetrieveConsumableRecord", "Edm.Boolean", retrieveConsumableRecord)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<Crmbaseentity>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.InitializeFrom"), Crmbaseentity.class, _parameters);
    }

    @Function(name = "IsComponentCustomizable")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<IsComponentCustomizableResponse> isComponentCustomizable(UUID componentId, Integer componentType) {
        Preconditions.checkNotNull(componentId, "componentId cannot be null");
        Preconditions.checkNotNull(componentType, "componentType cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ComponentId", "Edm.Guid", componentId)
            .put("ComponentType", "Edm.Int32", componentType)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<IsComponentCustomizableResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.IsComponentCustomizable"), IsComponentCustomizableResponse.class, _parameters);
    }

    @Function(name = "IsDataEncryptionActive")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<IsDataEncryptionActiveResponse> isDataEncryptionActive() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<IsDataEncryptionActiveResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.IsDataEncryptionActive"), IsDataEncryptionActiveResponse.class, _parameters);
    }

    @Function(name = "IsValidStateTransition")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<IsValidStateTransitionResponse> isValidStateTransition(Crmbaseentity entity, String newState, Integer newStatus) {
        Preconditions.checkNotNull(entity, "entity cannot be null");
        Preconditions.checkNotNull(newState, "newState cannot be null");
        Preconditions.checkNotNull(newStatus, "newStatus cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Entity", "Microsoft.Dynamics.CRM.crmbaseentity", entity)
            .put("NewState", "Edm.String", Checks.checkIsAscii(newState))
            .put("NewStatus", "Edm.Int32", newStatus)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<IsValidStateTransitionResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.IsValidStateTransition"), IsValidStateTransitionResponse.class, _parameters);
    }

    @Function(name = "LocalTimeFromUtcTime")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<LocalTimeFromUtcTimeResponse> localTimeFromUtcTime(Integer timeZoneCode, OffsetDateTime utcTime) {
        Preconditions.checkNotNull(timeZoneCode, "timeZoneCode cannot be null");
        Preconditions.checkNotNull(utcTime, "utcTime cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("TimeZoneCode", "Edm.Int32", timeZoneCode)
            .put("UtcTime", "Edm.DateTimeOffset", utcTime)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<LocalTimeFromUtcTimeResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.LocalTimeFromUtcTime"), LocalTimeFromUtcTimeResponse.class, _parameters);
    }

    @Function(name = "QuerySchedule")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<QueryScheduleResponse> querySchedule(UUID resourceId, OffsetDateTime start, OffsetDateTime end, List<TimeCode> timeCodes) {
        Preconditions.checkNotNull(resourceId, "resourceId cannot be null");
        Preconditions.checkNotNull(start, "start cannot be null");
        Preconditions.checkNotNull(end, "end cannot be null");
        Preconditions.checkNotNull(timeCodes, "timeCodes cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ResourceId", "Edm.Guid", resourceId)
            .put("Start", "Edm.DateTimeOffset", start)
            .put("End", "Edm.DateTimeOffset", end)
            .put("TimeCodes", "Collection(Microsoft.Dynamics.CRM.TimeCode)", timeCodes)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<QueryScheduleResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.QuerySchedule"), QueryScheduleResponse.class, _parameters);
    }

    @Function(name = "RemoveActiveCustomizations")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RemoveActiveCustomizationsResponse> removeActiveCustomizations(String solutionComponentName, UUID componentId) {
        Preconditions.checkNotNull(solutionComponentName, "solutionComponentName cannot be null");
        Preconditions.checkNotNull(componentId, "componentId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("SolutionComponentName", "Edm.String", Checks.checkIsAscii(solutionComponentName))
            .put("ComponentId", "Edm.Guid", componentId)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<RemoveActiveCustomizationsResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RemoveActiveCustomizations"), RemoveActiveCustomizationsResponse.class, _parameters);
    }

    @Function(name = "RetrieveActivePath")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Processstage> retrieveActivePath(UUID processInstanceId) {
        Preconditions.checkNotNull(processInstanceId, "processInstanceId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ProcessInstanceId", "Edm.Guid", processInstanceId)
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveActivePath"), Processstage.class, _parameters);
    }

    @Function(name = "RetrieveAllEntities")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RetrieveAllEntitiesResponse> retrieveAllEntities(EntityFilters entityFilters, Boolean retrieveAsIfPublished) {
        Preconditions.checkNotNull(entityFilters, "entityFilters cannot be null");
        Preconditions.checkNotNull(retrieveAsIfPublished, "retrieveAsIfPublished cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("EntityFilters", "Microsoft.Dynamics.CRM.EntityFilters", entityFilters)
            .put("RetrieveAsIfPublished", "Edm.Boolean", retrieveAsIfPublished)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<RetrieveAllEntitiesResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveAllEntities"), RetrieveAllEntitiesResponse.class, _parameters);
    }

    @Function(name = "RetrieveAnalyticsStoreDetails")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RetrieveAnalyticsStoreDetailsResponse> retrieveAnalyticsStoreDetails() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<RetrieveAnalyticsStoreDetailsResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveAnalyticsStoreDetails"), RetrieveAnalyticsStoreDetailsResponse.class, _parameters);
    }

    @Function(name = "RetrieveAppComponents")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Crmbaseentity> retrieveAppComponents(UUID appModuleId) {
        Preconditions.checkNotNull(appModuleId, "appModuleId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("AppModuleId", "Edm.Guid", appModuleId)
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveAppComponents"), Crmbaseentity.class, _parameters);
    }

    @Function(name = "RetrieveApplicationRibbon")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RetrieveApplicationRibbonResponse> retrieveApplicationRibbon() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<RetrieveApplicationRibbonResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveApplicationRibbon"), RetrieveApplicationRibbonResponse.class, _parameters);
    }

    @Function(name = "RetrieveAppSetting")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RetrieveAppSettingResponse> retrieveAppSetting(String appUniqueName, String settingName) {
        Preconditions.checkNotNull(appUniqueName, "appUniqueName cannot be null");
        Preconditions.checkNotNull(settingName, "settingName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("AppUniqueName", "Edm.String", Checks.checkIsAscii(appUniqueName))
            .put("SettingName", "Edm.String", Checks.checkIsAscii(settingName))
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<RetrieveAppSettingResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveAppSetting"), RetrieveAppSettingResponse.class, _parameters);
    }

    @Function(name = "RetrieveAppSettingList")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RetrieveAppSettingListResponse> retrieveAppSettingList(String appUniqueName, Boolean includeInactiveSettings) {
        Preconditions.checkNotNull(appUniqueName, "appUniqueName cannot be null");
        Preconditions.checkNotNull(includeInactiveSettings, "includeInactiveSettings cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("AppUniqueName", "Edm.String", Checks.checkIsAscii(appUniqueName))
            .put("IncludeInactiveSettings", "Edm.Boolean", includeInactiveSettings)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<RetrieveAppSettingListResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveAppSettingList"), RetrieveAppSettingListResponse.class, _parameters);
    }

    @Function(name = "RetrieveAttributeChangeHistory")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RetrieveAttributeChangeHistoryResponse> retrieveAttributeChangeHistory(Crmbaseentity target, String attributeLogicalName, PagingInfo pagingInfo) {
        Preconditions.checkNotNull(target, "target cannot be null");
        Preconditions.checkNotNull(attributeLogicalName, "attributeLogicalName cannot be null");
        Preconditions.checkNotNull(pagingInfo, "pagingInfo cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Target", "Microsoft.Dynamics.CRM.crmbaseentity", target)
            .put("AttributeLogicalName", "Edm.String", Checks.checkIsAscii(attributeLogicalName))
            .put("PagingInfo", "Microsoft.Dynamics.CRM.PagingInfo", pagingInfo)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<RetrieveAttributeChangeHistoryResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveAttributeChangeHistory"), RetrieveAttributeChangeHistoryResponse.class, _parameters);
    }

    @Function(name = "RetrieveAuditPartitionList")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RetrieveAuditPartitionListResponse> retrieveAuditPartitionList() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<RetrieveAuditPartitionListResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveAuditPartitionList"), RetrieveAuditPartitionListResponse.class, _parameters);
    }

    @Function(name = "RetrieveAvailableLanguages")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RetrieveAvailableLanguagesResponse> retrieveAvailableLanguages() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<RetrieveAvailableLanguagesResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveAvailableLanguages"), RetrieveAvailableLanguagesResponse.class, _parameters);
    }

    @Function(name = "RetrieveChannelAccessProfilePrivileges")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RetrieveChannelAccessProfilePrivilegesResponse> retrieveChannelAccessProfilePrivileges(UUID channelAccessProfileId) {
        Preconditions.checkNotNull(channelAccessProfileId, "channelAccessProfileId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ChannelAccessProfileId", "Edm.Guid", channelAccessProfileId)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<RetrieveChannelAccessProfilePrivilegesResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveChannelAccessProfilePrivileges"), RetrieveChannelAccessProfilePrivilegesResponse.class, _parameters);
    }

    @Function(name = "RetrieveCurrentOrganization")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RetrieveCurrentOrganizationResponse> retrieveCurrentOrganization(EndpointAccessType accessType) {
        Preconditions.checkNotNull(accessType, "accessType cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("AccessType", "Microsoft.Dynamics.CRM.EndpointAccessType", accessType)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<RetrieveCurrentOrganizationResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveCurrentOrganization"), RetrieveCurrentOrganizationResponse.class, _parameters);
    }

    @Function(name = "RetrieveDataEncryptionKey")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RetrieveDataEncryptionKeyResponse> retrieveDataEncryptionKey() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<RetrieveDataEncryptionKeyResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveDataEncryptionKey"), RetrieveDataEncryptionKeyResponse.class, _parameters);
    }

    @Function(name = "RetrieveDependenciesForDelete")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Dependency> retrieveDependenciesForDelete(UUID objectId, Integer componentType) {
        Preconditions.checkNotNull(objectId, "objectId cannot be null");
        Preconditions.checkNotNull(componentType, "componentType cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ObjectId", "Edm.Guid", objectId)
            .put("ComponentType", "Edm.Int32", componentType)
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveDependenciesForDelete"), Dependency.class, _parameters);
    }

    @Function(name = "RetrieveDependenciesForUninstall")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Dependency> retrieveDependenciesForUninstall(String solutionUniqueName) {
        Preconditions.checkNotNull(solutionUniqueName, "solutionUniqueName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("SolutionUniqueName", "Edm.String", Checks.checkIsAscii(solutionUniqueName))
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveDependenciesForUninstall"), Dependency.class, _parameters);
    }

    @Function(name = "RetrieveDependentComponents")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Dependency> retrieveDependentComponents(UUID objectId, Integer componentType) {
        Preconditions.checkNotNull(objectId, "objectId cannot be null");
        Preconditions.checkNotNull(componentType, "componentType cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ObjectId", "Edm.Guid", objectId)
            .put("ComponentType", "Edm.Int32", componentType)
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveDependentComponents"), Dependency.class, _parameters);
    }

    @Function(name = "RetrieveDeploymentLicenseType")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RetrieveDeploymentLicenseTypeResponse> retrieveDeploymentLicenseType() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<RetrieveDeploymentLicenseTypeResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveDeploymentLicenseType"), RetrieveDeploymentLicenseTypeResponse.class, _parameters);
    }

    @Function(name = "RetrieveDeprovisionedLanguages")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RetrieveDeprovisionedLanguagesResponse> retrieveDeprovisionedLanguages() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<RetrieveDeprovisionedLanguagesResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveDeprovisionedLanguages"), RetrieveDeprovisionedLanguagesResponse.class, _parameters);
    }

    @Function(name = "RetrieveDuplicates")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Crmbaseentity> retrieveDuplicates(Crmbaseentity businessEntity, String matchingEntityName, PagingInfo pagingInfo) {
        Preconditions.checkNotNull(businessEntity, "businessEntity cannot be null");
        Preconditions.checkNotNull(matchingEntityName, "matchingEntityName cannot be null");
        Preconditions.checkNotNull(pagingInfo, "pagingInfo cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("BusinessEntity", "Microsoft.Dynamics.CRM.crmbaseentity", businessEntity)
            .put("MatchingEntityName", "Edm.String", Checks.checkIsAscii(matchingEntityName))
            .put("PagingInfo", "Microsoft.Dynamics.CRM.PagingInfo", pagingInfo)
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveDuplicates"), Crmbaseentity.class, _parameters);
    }

    @Function(name = "RetrieveEntity")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RetrieveEntityResponse> retrieveEntity(EntityFilters entityFilters, String logicalName, UUID metadataId, Boolean retrieveAsIfPublished) {
        Preconditions.checkNotNull(entityFilters, "entityFilters cannot be null");
        Preconditions.checkNotNull(logicalName, "logicalName cannot be null");
        Preconditions.checkNotNull(metadataId, "metadataId cannot be null");
        Preconditions.checkNotNull(retrieveAsIfPublished, "retrieveAsIfPublished cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("EntityFilters", "Microsoft.Dynamics.CRM.EntityFilters", entityFilters)
            .put("LogicalName", "Edm.String", Checks.checkIsAscii(logicalName))
            .put("MetadataId", "Edm.Guid", metadataId)
            .put("RetrieveAsIfPublished", "Edm.Boolean", retrieveAsIfPublished)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<RetrieveEntityResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveEntity"), RetrieveEntityResponse.class, _parameters);
    }

    @Function(name = "RetrieveEntityRibbon")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RetrieveEntityRibbonResponse> retrieveEntityRibbon(String entityName, RibbonLocationFilters ribbonLocationFilter) {
        Preconditions.checkNotNull(entityName, "entityName cannot be null");
        Preconditions.checkNotNull(ribbonLocationFilter, "ribbonLocationFilter cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("EntityName", "Edm.String", Checks.checkIsAscii(entityName))
            .put("RibbonLocationFilter", "Microsoft.Dynamics.CRM.RibbonLocationFilters", ribbonLocationFilter)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<RetrieveEntityRibbonResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveEntityRibbon"), RetrieveEntityRibbonResponse.class, _parameters);
    }

    @Function(name = "RetrieveExchangeAppointments")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Crmbaseentity> retrieveExchangeAppointments(OffsetDateTime startDate, OffsetDateTime endDate) {
        Preconditions.checkNotNull(startDate, "startDate cannot be null");
        Preconditions.checkNotNull(endDate, "endDate cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("StartDate", "Edm.DateTimeOffset", startDate)
            .put("EndDate", "Edm.DateTimeOffset", endDate)
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveExchangeAppointments"), Crmbaseentity.class, _parameters);
    }

    @Function(name = "RetrieveExchangeRate")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RetrieveExchangeRateResponse> retrieveExchangeRate(UUID transactionCurrencyId) {
        Preconditions.checkNotNull(transactionCurrencyId, "transactionCurrencyId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("TransactionCurrencyId", "Edm.Guid", transactionCurrencyId)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<RetrieveExchangeRateResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveExchangeRate"), RetrieveExchangeRateResponse.class, _parameters);
    }

    @Function(name = "RetrieveFormattedImportJobResults")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RetrieveFormattedImportJobResultsResponse> retrieveFormattedImportJobResults(UUID importJobId) {
        Preconditions.checkNotNull(importJobId, "importJobId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ImportJobId", "Edm.Guid", importJobId)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<RetrieveFormattedImportJobResultsResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveFormattedImportJobResults"), RetrieveFormattedImportJobResultsResponse.class, _parameters);
    }

    @Function(name = "RetrieveInstalledLanguagePacks")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RetrieveInstalledLanguagePacksResponse> retrieveInstalledLanguagePacks() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<RetrieveInstalledLanguagePacksResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveInstalledLanguagePacks"), RetrieveInstalledLanguagePacksResponse.class, _parameters);
    }

    @Function(name = "RetrieveInstalledLanguagePackVersion")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RetrieveInstalledLanguagePackVersionResponse> retrieveInstalledLanguagePackVersion(Integer language) {
        Preconditions.checkNotNull(language, "language cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Language", "Edm.Int32", language)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<RetrieveInstalledLanguagePackVersionResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveInstalledLanguagePackVersion"), RetrieveInstalledLanguagePackVersionResponse.class, _parameters);
    }

    @Function(name = "RetrieveLicenseInfo")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RetrieveLicenseInfoResponse> retrieveLicenseInfo(Integer accessMode) {
        Preconditions.checkNotNull(accessMode, "accessMode cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("AccessMode", "Edm.Int32", accessMode)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<RetrieveLicenseInfoResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveLicenseInfo"), RetrieveLicenseInfoResponse.class, _parameters);
    }

    @Function(name = "RetrieveLocLabels")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RetrieveLocLabelsResponse> retrieveLocLabels(Crmbaseentity entityMoniker, String attributeName, Boolean includeUnpublished) {
        Preconditions.checkNotNull(entityMoniker, "entityMoniker cannot be null");
        Preconditions.checkNotNull(attributeName, "attributeName cannot be null");
        Preconditions.checkNotNull(includeUnpublished, "includeUnpublished cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("EntityMoniker", "Microsoft.Dynamics.CRM.crmbaseentity", entityMoniker)
            .put("AttributeName", "Edm.String", Checks.checkIsAscii(attributeName))
            .put("IncludeUnpublished", "Edm.Boolean", includeUnpublished)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<RetrieveLocLabelsResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveLocLabels"), RetrieveLocLabelsResponse.class, _parameters);
    }

    @Function(name = "RetrieveMailboxTrackingFolders")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RetrieveMailboxTrackingFoldersResponse> retrieveMailboxTrackingFolders(String mailboxId) {
        Preconditions.checkNotNull(mailboxId, "mailboxId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("MailboxId", "Edm.String", Checks.checkIsAscii(mailboxId))
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<RetrieveMailboxTrackingFoldersResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveMailboxTrackingFolders"), RetrieveMailboxTrackingFoldersResponse.class, _parameters);
    }

    @Function(name = "RetrieveMetadataChanges")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RetrieveMetadataChangesResponse> retrieveMetadataChanges(EntityQueryExpression query, DeletedMetadataFilters deletedMetadataFilters, String clientVersionStamp, UUID appModuleId, Boolean retrieveAllSettings) {
        Preconditions.checkNotNull(query, "query cannot be null");
        Preconditions.checkNotNull(deletedMetadataFilters, "deletedMetadataFilters cannot be null");
        Preconditions.checkNotNull(clientVersionStamp, "clientVersionStamp cannot be null");
        Preconditions.checkNotNull(appModuleId, "appModuleId cannot be null");
        Preconditions.checkNotNull(retrieveAllSettings, "retrieveAllSettings cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Query", "Microsoft.Dynamics.CRM.EntityQueryExpression", query)
            .put("DeletedMetadataFilters", "Microsoft.Dynamics.CRM.DeletedMetadataFilters", deletedMetadataFilters)
            .put("ClientVersionStamp", "Edm.String", Checks.checkIsAscii(clientVersionStamp))
            .put("AppModuleId", "Edm.Guid", appModuleId)
            .put("RetrieveAllSettings", "Edm.Boolean", retrieveAllSettings)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<RetrieveMetadataChangesResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveMetadataChanges"), RetrieveMetadataChangesResponse.class, _parameters);
    }

    @Function(name = "RetrieveMissingComponents")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RetrieveMissingComponentsResponse> retrieveMissingComponents(byte[] customizationFile) {
        Preconditions.checkNotNull(customizationFile, "customizationFile cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("CustomizationFile", "Edm.Binary", customizationFile)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<RetrieveMissingComponentsResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveMissingComponents"), RetrieveMissingComponentsResponse.class, _parameters);
    }

    @Function(name = "RetrieveMissingDependencies")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Crmbaseentity> retrieveMissingDependencies(String solutionUniqueName) {
        Preconditions.checkNotNull(solutionUniqueName, "solutionUniqueName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("SolutionUniqueName", "Edm.String", Checks.checkIsAscii(solutionUniqueName))
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveMissingDependencies"), Crmbaseentity.class, _parameters);
    }

    @Function(name = "RetrieveOrganizationInfo")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RetrieveOrganizationInfoResponse> retrieveOrganizationInfo() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<RetrieveOrganizationInfoResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveOrganizationInfo"), RetrieveOrganizationInfoResponse.class, _parameters);
    }

    @Function(name = "RetrieveOrganizationResources")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RetrieveOrganizationResourcesResponse> retrieveOrganizationResources() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<RetrieveOrganizationResourcesResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveOrganizationResources"), RetrieveOrganizationResourcesResponse.class, _parameters);
    }

    @Function(name = "RetrieveParsedDataImportFile")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RetrieveParsedDataImportFileResponse> retrieveParsedDataImportFile(UUID importFileId, PagingInfo pagingInfo) {
        Preconditions.checkNotNull(importFileId, "importFileId cannot be null");
        Preconditions.checkNotNull(pagingInfo, "pagingInfo cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ImportFileId", "Edm.Guid", importFileId)
            .put("PagingInfo", "Microsoft.Dynamics.CRM.PagingInfo", pagingInfo)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<RetrieveParsedDataImportFileResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveParsedDataImportFile"), RetrieveParsedDataImportFileResponse.class, _parameters);
    }

    @Function(name = "RetrieveProcessInstances")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Crmbaseentity> retrieveProcessInstances(UUID entityId, String entityLogicalName) {
        Preconditions.checkNotNull(entityId, "entityId cannot be null");
        Preconditions.checkNotNull(entityLogicalName, "entityLogicalName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("EntityId", "Edm.Guid", entityId)
            .put("EntityLogicalName", "Edm.String", Checks.checkIsAscii(entityLogicalName))
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveProcessInstances"), Crmbaseentity.class, _parameters);
    }

    @Function(name = "RetrieveProvisionedLanguagePackVersion")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RetrieveProvisionedLanguagePackVersionResponse> retrieveProvisionedLanguagePackVersion(Integer language) {
        Preconditions.checkNotNull(language, "language cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Language", "Edm.Int32", language)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<RetrieveProvisionedLanguagePackVersionResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveProvisionedLanguagePackVersion"), RetrieveProvisionedLanguagePackVersionResponse.class, _parameters);
    }

    @Function(name = "RetrieveProvisionedLanguages")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RetrieveProvisionedLanguagesResponse> retrieveProvisionedLanguages() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<RetrieveProvisionedLanguagesResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveProvisionedLanguages"), RetrieveProvisionedLanguagesResponse.class, _parameters);
    }

    @Function(name = "RetrieveRecordChangeHistory")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RetrieveRecordChangeHistoryResponse> retrieveRecordChangeHistory(Crmbaseentity target, PagingInfo pagingInfo) {
        Preconditions.checkNotNull(target, "target cannot be null");
        Preconditions.checkNotNull(pagingInfo, "pagingInfo cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Target", "Microsoft.Dynamics.CRM.crmbaseentity", target)
            .put("PagingInfo", "Microsoft.Dynamics.CRM.PagingInfo", pagingInfo)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<RetrieveRecordChangeHistoryResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveRecordChangeHistory"), RetrieveRecordChangeHistoryResponse.class, _parameters);
    }

    @Function(name = "RetrieveRequiredComponents")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Crmbaseentity> retrieveRequiredComponents(UUID objectId, Integer componentType) {
        Preconditions.checkNotNull(objectId, "objectId cannot be null");
        Preconditions.checkNotNull(componentType, "componentType cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ObjectId", "Edm.Guid", objectId)
            .put("ComponentType", "Edm.Int32", componentType)
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveRequiredComponents"), Crmbaseentity.class, _parameters);
    }

    @Function(name = "RetrieveRolePrivilegesRole")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RetrieveRolePrivilegesRoleResponse> retrieveRolePrivilegesRole(UUID roleId) {
        Preconditions.checkNotNull(roleId, "roleId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("RoleId", "Edm.Guid", roleId)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<RetrieveRolePrivilegesRoleResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveRolePrivilegesRole"), RetrieveRolePrivilegesRoleResponse.class, _parameters);
    }

    @Function(name = "RetrieveSharedPrincipalsAndAccess")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RetrieveSharedPrincipalsAndAccessResponse> retrieveSharedPrincipalsAndAccess(Crmbaseentity target) {
        Preconditions.checkNotNull(target, "target cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Target", "Microsoft.Dynamics.CRM.crmbaseentity", target)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<RetrieveSharedPrincipalsAndAccessResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveSharedPrincipalsAndAccess"), RetrieveSharedPrincipalsAndAccessResponse.class, _parameters);
    }

    @Function(name = "RetrieveTimestamp")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RetrieveTimestampResponse> retrieveTimestamp() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<RetrieveTimestampResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveTimestamp"), RetrieveTimestampResponse.class, _parameters);
    }

    @Function(name = "RetrieveTotalRecordCount")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RetrieveTotalRecordCountResponse> retrieveTotalRecordCount(List<String> entityNames) {
        Preconditions.checkNotNull(entityNames, "entityNames cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("EntityNames", "Collection(Edm.String)", Checks.checkIsAscii(entityNames))
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<RetrieveTotalRecordCountResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveTotalRecordCount"), RetrieveTotalRecordCountResponse.class, _parameters);
    }

    @Function(name = "RetrieveVersion")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RetrieveVersionResponse> retrieveVersion() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<RetrieveVersionResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveVersion"), RetrieveVersionResponse.class, _parameters);
    }

    @Function(name = "Rollup")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Crmbaseentity> rollup(Crmbaseentity target, QueryBase query, RollupType rollupType) {
        Preconditions.checkNotNull(target, "target cannot be null");
        Preconditions.checkNotNull(query, "query cannot be null");
        Preconditions.checkNotNull(rollupType, "rollupType cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Target", "Microsoft.Dynamics.CRM.crmbaseentity", target)
            .put("Query", "Microsoft.Dynamics.CRM.QueryBase", query)
            .put("RollupType", "Microsoft.Dynamics.CRM.RollupType", rollupType)
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.Rollup"), Crmbaseentity.class, _parameters);
    }

    @Function(name = "Search")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<SearchResponse> search(microsoft.dynamics.crm.complex.AppointmentRequest appointmentRequest) {
        Preconditions.checkNotNull(appointmentRequest, "appointmentRequest cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("AppointmentRequest", "Microsoft.Dynamics.CRM.AppointmentRequest", appointmentRequest)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<SearchResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.Search"), SearchResponse.class, _parameters);
    }

    @Function(name = "ValidateApp")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<ValidateAppResponse> validateApp(UUID appModuleId) {
        Preconditions.checkNotNull(appModuleId, "appModuleId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("AppModuleId", "Edm.Guid", appModuleId)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<ValidateAppResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.ValidateApp"), ValidateAppResponse.class, _parameters);
    }

    @Function(name = "ValidateFetchXmlExpression")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<ValidateFetchXmlExpressionResponse> validateFetchXmlExpression(String fetchXml) {
        Preconditions.checkNotNull(fetchXml, "fetchXml cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("FetchXml", "Edm.String", Checks.checkIsAscii(fetchXml))
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<ValidateFetchXmlExpressionResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.ValidateFetchXmlExpression"), ValidateFetchXmlExpressionResponse.class, _parameters);
    }

    @Function(name = "ValidateRecurrenceRule")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<ValidateRecurrenceRuleResponse> validateRecurrenceRule(Recurrencerule target) {
        Preconditions.checkNotNull(target, "target cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Target", "Microsoft.Dynamics.CRM.recurrencerule", target)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<ValidateRecurrenceRuleResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.ValidateRecurrenceRule"), ValidateRecurrenceRuleResponse.class, _parameters);
    }

    @Function(name = "WhoAmI")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<WhoAmIResponse> whoAmI() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<WhoAmIResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.WhoAmI"), WhoAmIResponse.class, _parameters);
    }

    @Function(name = "In")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> in(String propertyName, List<String> propertyValues) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Preconditions.checkNotNull(propertyValues, "propertyValues cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .put("PropertyValues", "Collection(Edm.String)", Checks.checkIsAscii(propertyValues))
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.In"), Boolean.class, _parameters);
    }

    @Function(name = "NotIn")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> notIn(String propertyName, List<String> propertyValues) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Preconditions.checkNotNull(propertyValues, "propertyValues cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .put("PropertyValues", "Collection(Edm.String)", Checks.checkIsAscii(propertyValues))
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.NotIn"), Boolean.class, _parameters);
    }

    @Function(name = "Between")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> between(String propertyName, List<String> propertyValues) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Preconditions.checkNotNull(propertyValues, "propertyValues cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .put("PropertyValues", "Collection(Edm.String)", Checks.checkIsAscii(propertyValues))
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.Between"), Boolean.class, _parameters);
    }

    @Function(name = "NotBetween")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> notBetween(String propertyName, List<String> propertyValues) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Preconditions.checkNotNull(propertyValues, "propertyValues cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .put("PropertyValues", "Collection(Edm.String)", Checks.checkIsAscii(propertyValues))
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.NotBetween"), Boolean.class, _parameters);
    }

    @Function(name = "Yesterday")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> yesterday(String propertyName) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.Yesterday"), Boolean.class, _parameters);
    }

    @Function(name = "Today")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> today(String propertyName) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.Today"), Boolean.class, _parameters);
    }

    @Function(name = "Tomorrow")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> tomorrow(String propertyName) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.Tomorrow"), Boolean.class, _parameters);
    }

    @Function(name = "Last7Days")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> last7Days(String propertyName) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.Last7Days"), Boolean.class, _parameters);
    }

    @Function(name = "Next7Days")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> next7Days(String propertyName) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.Next7Days"), Boolean.class, _parameters);
    }

    @Function(name = "LastWeek")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> lastWeek(String propertyName) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.LastWeek"), Boolean.class, _parameters);
    }

    @Function(name = "ThisWeek")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> thisWeek(String propertyName) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.ThisWeek"), Boolean.class, _parameters);
    }

    @Function(name = "NextWeek")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> nextWeek(String propertyName) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.NextWeek"), Boolean.class, _parameters);
    }

    @Function(name = "LastMonth")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> lastMonth(String propertyName) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.LastMonth"), Boolean.class, _parameters);
    }

    @Function(name = "ThisMonth")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> thisMonth(String propertyName) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.ThisMonth"), Boolean.class, _parameters);
    }

    @Function(name = "NextMonth")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> nextMonth(String propertyName) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.NextMonth"), Boolean.class, _parameters);
    }

    @Function(name = "On")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> on(String propertyName, String propertyValue) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Preconditions.checkNotNull(propertyValue, "propertyValue cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .put("PropertyValue", "Edm.String", Checks.checkIsAscii(propertyValue))
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.On"), Boolean.class, _parameters);
    }

    @Function(name = "OnOrBefore")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> onOrBefore(String propertyName, String propertyValue) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Preconditions.checkNotNull(propertyValue, "propertyValue cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .put("PropertyValue", "Edm.String", Checks.checkIsAscii(propertyValue))
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.OnOrBefore"), Boolean.class, _parameters);
    }

    @Function(name = "OnOrAfter")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> onOrAfter(String propertyName, String propertyValue) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Preconditions.checkNotNull(propertyValue, "propertyValue cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .put("PropertyValue", "Edm.String", Checks.checkIsAscii(propertyValue))
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.OnOrAfter"), Boolean.class, _parameters);
    }

    @Function(name = "LastYear")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> lastYear(String propertyName) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.LastYear"), Boolean.class, _parameters);
    }

    @Function(name = "ThisYear")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> thisYear(String propertyName) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.ThisYear"), Boolean.class, _parameters);
    }

    @Function(name = "NextYear")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> nextYear(String propertyName) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.NextYear"), Boolean.class, _parameters);
    }

    @Function(name = "LastXHours")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> lastXHours(String propertyName, Long propertyValue) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Preconditions.checkNotNull(propertyValue, "propertyValue cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .put("PropertyValue", "Edm.Int64", propertyValue)
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.LastXHours"), Boolean.class, _parameters);
    }

    @Function(name = "NextXHours")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> nextXHours(String propertyName, Long propertyValue) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Preconditions.checkNotNull(propertyValue, "propertyValue cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .put("PropertyValue", "Edm.Int64", propertyValue)
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.NextXHours"), Boolean.class, _parameters);
    }

    @Function(name = "LastXDays")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> lastXDays(String propertyName, Long propertyValue) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Preconditions.checkNotNull(propertyValue, "propertyValue cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .put("PropertyValue", "Edm.Int64", propertyValue)
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.LastXDays"), Boolean.class, _parameters);
    }

    @Function(name = "NextXDays")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> nextXDays(String propertyName, Long propertyValue) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Preconditions.checkNotNull(propertyValue, "propertyValue cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .put("PropertyValue", "Edm.Int64", propertyValue)
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.NextXDays"), Boolean.class, _parameters);
    }

    @Function(name = "LastXWeeks")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> lastXWeeks(String propertyName, Long propertyValue) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Preconditions.checkNotNull(propertyValue, "propertyValue cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .put("PropertyValue", "Edm.Int64", propertyValue)
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.LastXWeeks"), Boolean.class, _parameters);
    }

    @Function(name = "NextXWeeks")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> nextXWeeks(String propertyName, Long propertyValue) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Preconditions.checkNotNull(propertyValue, "propertyValue cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .put("PropertyValue", "Edm.Int64", propertyValue)
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.NextXWeeks"), Boolean.class, _parameters);
    }

    @Function(name = "LastXMonths")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> lastXMonths(String propertyName, Long propertyValue) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Preconditions.checkNotNull(propertyValue, "propertyValue cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .put("PropertyValue", "Edm.Int64", propertyValue)
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.LastXMonths"), Boolean.class, _parameters);
    }

    @Function(name = "NextXMonths")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> nextXMonths(String propertyName, Long propertyValue) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Preconditions.checkNotNull(propertyValue, "propertyValue cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .put("PropertyValue", "Edm.Int64", propertyValue)
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.NextXMonths"), Boolean.class, _parameters);
    }

    @Function(name = "LastXYears")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> lastXYears(String propertyName, Long propertyValue) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Preconditions.checkNotNull(propertyValue, "propertyValue cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .put("PropertyValue", "Edm.Int64", propertyValue)
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.LastXYears"), Boolean.class, _parameters);
    }

    @Function(name = "NextXYears")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> nextXYears(String propertyName, Long propertyValue) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Preconditions.checkNotNull(propertyValue, "propertyValue cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .put("PropertyValue", "Edm.Int64", propertyValue)
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.NextXYears"), Boolean.class, _parameters);
    }

    @Function(name = "EqualUserId")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> equalUserId(String propertyName) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.EqualUserId"), Boolean.class, _parameters);
    }

    @Function(name = "NotEqualUserId")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> notEqualUserId(String propertyName) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.NotEqualUserId"), Boolean.class, _parameters);
    }

    @Function(name = "EqualBusinessId")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> equalBusinessId(String propertyName) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.EqualBusinessId"), Boolean.class, _parameters);
    }

    @Function(name = "NotEqualBusinessId")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> notEqualBusinessId(String propertyName) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.NotEqualBusinessId"), Boolean.class, _parameters);
    }

    @Function(name = "Contains")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> contains(String propertyName, String propertyValue) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Preconditions.checkNotNull(propertyValue, "propertyValue cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .put("PropertyValue", "Edm.String", Checks.checkIsAscii(propertyValue))
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.Contains"), Boolean.class, _parameters);
    }

    @Function(name = "EqualUserLanguage")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> equalUserLanguage(String propertyName) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.EqualUserLanguage"), Boolean.class, _parameters);
    }

    @Function(name = "OlderThanXMonths")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> olderThanXMonths(String propertyName, Long propertyValue) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Preconditions.checkNotNull(propertyValue, "propertyValue cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .put("PropertyValue", "Edm.Int64", propertyValue)
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.OlderThanXMonths"), Boolean.class, _parameters);
    }

    @Function(name = "ThisFiscalYear")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> thisFiscalYear(String propertyName) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.ThisFiscalYear"), Boolean.class, _parameters);
    }

    @Function(name = "ThisFiscalPeriod")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> thisFiscalPeriod(String propertyName) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.ThisFiscalPeriod"), Boolean.class, _parameters);
    }

    @Function(name = "NextFiscalYear")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> nextFiscalYear(String propertyName) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.NextFiscalYear"), Boolean.class, _parameters);
    }

    @Function(name = "NextFiscalPeriod")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> nextFiscalPeriod(String propertyName) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.NextFiscalPeriod"), Boolean.class, _parameters);
    }

    @Function(name = "LastFiscalYear")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> lastFiscalYear(String propertyName) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.LastFiscalYear"), Boolean.class, _parameters);
    }

    @Function(name = "LastFiscalPeriod")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> lastFiscalPeriod(String propertyName) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.LastFiscalPeriod"), Boolean.class, _parameters);
    }

    @Function(name = "LastXFiscalYears")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> lastXFiscalYears(String propertyName, Long propertyValue) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Preconditions.checkNotNull(propertyValue, "propertyValue cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .put("PropertyValue", "Edm.Int64", propertyValue)
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.LastXFiscalYears"), Boolean.class, _parameters);
    }

    @Function(name = "LastXFiscalPeriods")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> lastXFiscalPeriods(String propertyName, Long propertyValue) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Preconditions.checkNotNull(propertyValue, "propertyValue cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .put("PropertyValue", "Edm.Int64", propertyValue)
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.LastXFiscalPeriods"), Boolean.class, _parameters);
    }

    @Function(name = "NextXFiscalYears")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> nextXFiscalYears(String propertyName, Long propertyValue) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Preconditions.checkNotNull(propertyValue, "propertyValue cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .put("PropertyValue", "Edm.Int64", propertyValue)
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.NextXFiscalYears"), Boolean.class, _parameters);
    }

    @Function(name = "NextXFiscalPeriods")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> nextXFiscalPeriods(String propertyName, Long propertyValue) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Preconditions.checkNotNull(propertyValue, "propertyValue cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .put("PropertyValue", "Edm.Int64", propertyValue)
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.NextXFiscalPeriods"), Boolean.class, _parameters);
    }

    @Function(name = "InFiscalYear")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> inFiscalYear(String propertyName, Long propertyValue) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Preconditions.checkNotNull(propertyValue, "propertyValue cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .put("PropertyValue", "Edm.Int64", propertyValue)
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.InFiscalYear"), Boolean.class, _parameters);
    }

    @Function(name = "InFiscalPeriod")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> inFiscalPeriod(String propertyName, Long propertyValue) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Preconditions.checkNotNull(propertyValue, "propertyValue cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .put("PropertyValue", "Edm.Int64", propertyValue)
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.InFiscalPeriod"), Boolean.class, _parameters);
    }

    @Function(name = "InFiscalPeriodAndYear")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> inFiscalPeriodAndYear(String propertyName, Long propertyValue1, Long propertyValue2) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Preconditions.checkNotNull(propertyValue1, "propertyValue1 cannot be null");
        Preconditions.checkNotNull(propertyValue2, "propertyValue2 cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .put("PropertyValue1", "Edm.Int64", propertyValue1)
            .put("PropertyValue2", "Edm.Int64", propertyValue2)
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.InFiscalPeriodAndYear"), Boolean.class, _parameters);
    }

    @Function(name = "InOrBeforeFiscalPeriodAndYear")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> inOrBeforeFiscalPeriodAndYear(String propertyName, Long propertyValue1, Long propertyValue2) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Preconditions.checkNotNull(propertyValue1, "propertyValue1 cannot be null");
        Preconditions.checkNotNull(propertyValue2, "propertyValue2 cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .put("PropertyValue1", "Edm.Int64", propertyValue1)
            .put("PropertyValue2", "Edm.Int64", propertyValue2)
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.InOrBeforeFiscalPeriodAndYear"), Boolean.class, _parameters);
    }

    @Function(name = "InOrAfterFiscalPeriodAndYear")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> inOrAfterFiscalPeriodAndYear(String propertyName, Long propertyValue1, Long propertyValue2) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Preconditions.checkNotNull(propertyValue1, "propertyValue1 cannot be null");
        Preconditions.checkNotNull(propertyValue2, "propertyValue2 cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .put("PropertyValue1", "Edm.Int64", propertyValue1)
            .put("PropertyValue2", "Edm.Int64", propertyValue2)
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.InOrAfterFiscalPeriodAndYear"), Boolean.class, _parameters);
    }

    @Function(name = "EqualUserTeams")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> equalUserTeams(String propertyName) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.EqualUserTeams"), Boolean.class, _parameters);
    }

    @Function(name = "EqualUserOrUserTeams")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> equalUserOrUserTeams(String propertyName) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.EqualUserOrUserTeams"), Boolean.class, _parameters);
    }

    @Function(name = "Under")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> under(String propertyName, String propertyValue) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Preconditions.checkNotNull(propertyValue, "propertyValue cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .put("PropertyValue", "Edm.String", Checks.checkIsAscii(propertyValue))
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.Under"), Boolean.class, _parameters);
    }

    @Function(name = "NotUnder")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> notUnder(String propertyName, String propertyValue) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Preconditions.checkNotNull(propertyValue, "propertyValue cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .put("PropertyValue", "Edm.String", Checks.checkIsAscii(propertyValue))
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.NotUnder"), Boolean.class, _parameters);
    }

    @Function(name = "UnderOrEqual")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> underOrEqual(String propertyName, String propertyValue) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Preconditions.checkNotNull(propertyValue, "propertyValue cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .put("PropertyValue", "Edm.String", Checks.checkIsAscii(propertyValue))
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.UnderOrEqual"), Boolean.class, _parameters);
    }

    @Function(name = "Above")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> above(String propertyName, String propertyValue) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Preconditions.checkNotNull(propertyValue, "propertyValue cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .put("PropertyValue", "Edm.String", Checks.checkIsAscii(propertyValue))
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.Above"), Boolean.class, _parameters);
    }

    @Function(name = "AboveOrEqual")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> aboveOrEqual(String propertyName, String propertyValue) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Preconditions.checkNotNull(propertyValue, "propertyValue cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .put("PropertyValue", "Edm.String", Checks.checkIsAscii(propertyValue))
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.AboveOrEqual"), Boolean.class, _parameters);
    }

    @Function(name = "EqualUserOrUserHierarchy")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> equalUserOrUserHierarchy(String propertyName) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.EqualUserOrUserHierarchy"), Boolean.class, _parameters);
    }

    @Function(name = "EqualUserOrUserHierarchyAndTeams")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> equalUserOrUserHierarchyAndTeams(String propertyName) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.EqualUserOrUserHierarchyAndTeams"), Boolean.class, _parameters);
    }

    @Function(name = "OlderThanXYears")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> olderThanXYears(String propertyName, Long propertyValue) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Preconditions.checkNotNull(propertyValue, "propertyValue cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .put("PropertyValue", "Edm.Int64", propertyValue)
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.OlderThanXYears"), Boolean.class, _parameters);
    }

    @Function(name = "OlderThanXWeeks")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> olderThanXWeeks(String propertyName, Long propertyValue) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Preconditions.checkNotNull(propertyValue, "propertyValue cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .put("PropertyValue", "Edm.Int64", propertyValue)
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.OlderThanXWeeks"), Boolean.class, _parameters);
    }

    @Function(name = "OlderThanXDays")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> olderThanXDays(String propertyName, Long propertyValue) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Preconditions.checkNotNull(propertyValue, "propertyValue cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .put("PropertyValue", "Edm.Int64", propertyValue)
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.OlderThanXDays"), Boolean.class, _parameters);
    }

    @Function(name = "OlderThanXHours")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> olderThanXHours(String propertyName, Long propertyValue) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Preconditions.checkNotNull(propertyValue, "propertyValue cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .put("PropertyValue", "Edm.Int64", propertyValue)
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.OlderThanXHours"), Boolean.class, _parameters);
    }

    @Function(name = "OlderThanXMinutes")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> olderThanXMinutes(String propertyName, Long propertyValue) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Preconditions.checkNotNull(propertyValue, "propertyValue cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .put("PropertyValue", "Edm.Int64", propertyValue)
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.OlderThanXMinutes"), Boolean.class, _parameters);
    }

    @Function(name = "ContainValues")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> containValues(String propertyName, List<String> propertyValues) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Preconditions.checkNotNull(propertyValues, "propertyValues cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .put("PropertyValues", "Collection(Edm.String)", Checks.checkIsAscii(propertyValues))
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.ContainValues"), Boolean.class, _parameters);
    }

    @Function(name = "DoesNotContainValues")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> doesNotContainValues(String propertyName, List<String> propertyValues) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Preconditions.checkNotNull(propertyValues, "propertyValues cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .put("PropertyValues", "Collection(Edm.String)", Checks.checkIsAscii(propertyValues))
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.DoesNotContainValues"), Boolean.class, _parameters);
    }

}
